/*
 * All Rights Reserved, Copyright (C) 2003, Hitachi Software Engineering Co., Ltd.
 */
/* $Id: debug.c,v 1.1.1.1 2003/01/20 02:39:36 ueno Exp $ */

#include <stdio.h>
#include <stdarg.h>

/**
 *  @name:	debug_print
 *  @about:	call yyerror like printf
 *  @args:	file (char *) -> file name
 *  @args:	lineno (int) -> line nuber
 *  @args:	fmt (char *) -> print format
 *  @return:	none
 */
void
debug_print(char *file, int lineno, char *fmt,...)
{
#ifdef DEBUG
	va_list ap;
	char buf[1024];

	va_start(ap, fmt);

	vsnprintf(buf, sizeof(buf), fmt, ap);
	va_end(ap);

	fprintf(stderr, "DEBUG:In file %s:%d:[%s]\n", file, lineno, buf);
#endif
}

/**
 *  @name:	error_print
 *  @about:	call yyerror like printf
 *  @args:	file (char *) -> file name
 *  @args:	lineno (int) -> line nuber
 *  @args:	fmt (char *) -> print format
 *  @return:	none
 */
void
error_print(char *file, int lineno, char *fmt,...)
{
	va_list ap;
	char buf[1024];

	va_start(ap, fmt);

	vsnprintf(buf, sizeof(buf), fmt, ap);
	va_end(ap);

	fprintf(stderr, "ERROR:In file %s:%d:[%s]\n", file, lineno, buf);
}
