/*
 * All Rights Reserved, Copyright (C) 2003, Hitachi Software Engineering Co., Ltd.
 */
/* $Id: common.c,v 1.1.1.1 2003/01/20 02:39:36 ueno Exp $ */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "common.h"

/**
 *  @name:	chop_nl
 *  @about:	chop \n
 *  @args:	buf (char *) -> target data
 *  @return:	none
 */
void
chop_nl(char *buf)
{
	int len;

	len = strlen(buf);

	if (buf[len - 1] == '\n')
		buf[len - 1] = '\0';

	return ;
}

/**
 *  @name:	get_nth_tok
 *  @about:	get n th token of str.
 *  @args:	str (char *) -> target string
 *  @args:	delm (char *) -> delimitor
 *  @args:	n (int) -> target number
 *  @attention:	str is destroyed.
 */
char *
get_nth_tok(char *str, char *delm, int n)
{
	char *p;
	int i = 0;
	char *result = NULL;

	p = strtok(str, delm);
	if (p == NULL)
	{
		return NULL;
	}

	i = 0;
	while (p != NULL)
	{
		i++;
		if (i == n)
		{
			result = p;
		}
		p = strtok(NULL, delm);
	}

	return result;
}

/**
 *  @name:	extend_array
 *  @about:	extends dynamic array.
 *  @args:	array (void *) -> pointer to dynamic array.
 *  @args:	array_num (int) -> number of elements
 *  @args:	size (size_t) -> size of each element
 *  @return:	pointer to extended array 
 */
void *
extend_array(void *array, int *array_num, size_t size)
{
	void *tmp;

	if (array == NULL)
	{
		if ((tmp = (void *)malloc(size)) == NULL)
		{
			perror("malloc");
			exit(1);
		}
	}
	else
	{
		if ((tmp = (void *)realloc(array, size*(*array_num + 1))) == NULL)
		{
			perror("realloc");
			exit(1);
		}
	}
	array = tmp;
	(*array_num)++;

	return tmp;
}
