#line 1 "tmp/all.te"
#
# Declarations for type attributes.
# 

# A type attribute can be used to identify a set of types with a similar
# property.  Each type can have any number of attributes, and each
# attribute can be associated with any number of types.  Attributes are
# explicitly declared here, and can then be associated with particular
# types in type declarations.  Attribute names can then be used throughout 
# the configuration to express the set of types that are associated with 
# the attribute.  Except for the MLS attributes, attributes have no implicit
# meaning to SELinux.  The meaning of all other attributes are completely 
# defined through their usage within the configuration, but should be 
# documented here as comments preceding the attribute declaration.  

#####################
# Attributes for MLS:
#

# The mlstrustedreader attribute identifies every domain that can
# override the normal MLS restrictions on reading (i.e. domains
# that can read up).  
attribute mlstrustedreader;

# The mlstrustedwriter attribute identifies every domain that can
# override the normal MLS restrictions on writing (i.e. domains
# that can write down).  
attribute mlstrustedwriter;

# The mlstrustedobject attribute identifies every type that can
# be accessed without normal MLS restrictions (i.e. processes can
# read or write objects with this type regardless of MLS level).  
# Examples:  /dev/null, descriptors created by login
attribute mlstrustedobject;


#########################
# Attributes for domains:
#

# The domain attribute identifies every type that can be 
# assigned to a process.  This attribute is used in TE rules 
# that should be applied to all domains, e.g. permitting 
# init to kill all processes or permitting all processes
# to read a particular file.
attribute domain;

# The privuser attribute identifies every domain that can 
# change its SELinux user identity.  This attribute is used 
# in the constraints configuration.  NOTE:  This attribute
# is not required for domains that merely change the Linux
# uid attributes, only for domains that must change the
# SELinux user identity.
attribute privuser;

# The privrole attribute identifies every domain that can 
# change its SELinux role.  This attribute is used in the 
# constraints configuration.
attribute privrole;

# The privowner attribute identifies every domain that can 
# assign a different SELinux user identity to a file.  This 
# attribute is used in the constraints configuration.
attribute privowner;

# The privlog attribute identifies every domain that can 
# communicate with syslogd through its Unix domain socket.
# This attribute is used in the TE rules in 
# domains/program/syslogd.te to grant such access.  
# XXX If you want to mandate the use of this attribute for all 
# XXX domains that can log, then you should also write corresponding 
# XXX assertions in assert.te to enforce this restriction.  Otherwise,
# XXX it is just an optional convenience for domain writers.
attribute privlog;

# The privmem attribute identifies every domain that can 
# access kernel memory devices.
# This attribute is used in the TE assertions to verify
# that such access is limited to domains that are explicitly
# tagged with this attribute.
attribute privmem;

# The privfd attribute identifies every domain that should have
# file handles inherited widely (IE sshd_t and getty_t).
attribute privfd;

# The privhome attribute identifies every domain that can create files under
# regular user home directories in the regular context (IE act on behalf of
# a user in writing regular files)
attribute privhome;

# The auth attribute identifies every domain that needs
# to read /etc/shadow, and grants the permission.
attribute auth;

# The auth_write attribute identifies every domain that can have write or
# relabel access to /etc/shadow, but does not grant it.
attribute auth_write;

# The auth_chkpwd attribute identifies every system domain that can
# authenticate users by running unix_chkpwd
attribute auth_chkpwd;

# The admin attribute identifies every administrator domain.
# It is used in TE assertions when verifying that only administrator 
# domains have certain permissions.  
# This attribute is presently associated with sysadm_t and 
# certain administrator utility domains.  
# XXX The use of this attribute should be reviewed for consistency.
# XXX Might want to partition into several finer-grained attributes 
# XXX used in different assertions within assert.te.
attribute admin;

# The userdomain attribute identifies every user domain, presently
# user_t and sysadm_t.  It is used in TE rules that should be applied
# to all user domains.
attribute userdomain;

# for a small domain that can only be used for newrole
attribute user_mini_domain;

# pty for the mini domain
attribute mini_pty_type;

# pty created by a server such as sshd
attribute server_pty;

# attribute for all non-administrative devpts types
attribute userpty_type;

# The user_crond_domain attribute identifies every user_crond domain, presently
# user_crond_t and sysadm_crond_t.  It is used in TE rules that should be
# applied to all user domains.
attribute user_crond_domain;

# The unpriv_userdomain identifies non-administrative users (default user_t)
attribute unpriv_userdomain;

# This attribute is for the main user home directory for unpriv users
attribute user_home_dir_type;

# The gphdomain attribute identifies every gnome-pty-helper derived
# domain.  It is used in TE rules to permit inheritance and use of
# descriptors created by these domains.
attribute gphdomain;

# The fs_domain identifies every domain that may directly access a fixed disk
attribute fs_domain;

############################
# Attributes for file types:
#

# The file_type attribute identifies all types assigned to files 
# in persistent filesystems.  It is used in TE rules to permit
# the association of all such file types with persistent filesystem
# types, and to permit certain domains to access all such types as 
# appropriate.
attribute file_type;

# The device_type attribute identifies all types assigned to device nodes
attribute device_type;

# The sysadmfile attribute identifies all types assigned to files 
# that should be completely accessible to administrators.  It is used
# in TE rules to grant such access for administrator domains.
attribute sysadmfile;

# The fs_type attribute identifies all types assigned to filesystems
# (not limited to persistent filesystems).
# It is used in TE rules to permit certain domains to mount
# any filesystem and to permit most domains to obtain the
# overall filesystem statistics.
attribute fs_type;

# The root_dir_type attribute identifies all types assigned to 
# root directories of filesystems (not limited to persistent
# filesystems).
# XXX This attribute was used to grant mountassociate permission,
# XXX but this permission is no longer defined.  We can likely
# XXX remove this attribute.
attribute root_dir_type;

# The exec_type attribute identifies all types assigned
# to entrypoint executables for domains.  This attribute is 
# used in TE rules and assertions that should be applied to all 
# such executables.
attribute exec_type;

# The tmpfile attribute identifies all types assigned to temporary 
# files.  This attribute is used in TE rules to grant certain 
# domains the ability to remove all such files (e.g. init, crond).
attribute tmpfile;

# The user_tmpfile attribute identifies all types associated with temporary
# files for unpriv_userdomain domains.
attribute user_tmpfile;

# for the user_xserver_tmp_t etc
attribute xserver_tmpfile;

# The tmpfsfile attribute identifies all types defined for tmpfs 
# type transitions. 
# It is used in TE rules to grant certain domains the ability to
# access all such files.
attribute tmpfsfile;

# The home_type attribute identifies all types assigned to home
# directories.  This attribute is used in TE rules to grant certain
# domains the ability to access all home directory types.
attribute home_type;

# This attribute is for the main user home directory /home/user, to
# distinguish it from sub-dirs.  Often you want a process to be able to
# read the user home directory but not read the regular directories under it.
attribute home_dir_type;

# The ttyfile attribute identifies all types assigned to ttys.
# It is used in TE rules to grant certain domains the ability to
# access all ttys.
attribute ttyfile;

# The ptyfile attribute identifies all types assigned to ptys.
# It is used in TE rules to grant certain domains the ability to
# access all ptys.
attribute ptyfile;

# The pidfile attribute identifies all types assigned to pid files.
# It is used in TE rules to grant certain domains the ability to
# access all such files.
attribute pidfile;


############################
# Attributes for network types:
#

# The socket_type attribute identifies all types assigned to 
# kernel-created sockets.  Ordinary sockets are assigned the 
# domain of the creating process.
# XXX This attribute is unused.  Remove?
attribute socket_type;

# Identifies all types assigned to port numbers to control binding.
attribute port_type;

# Identifies all types assigned to network interfaces to control
# operations on the interface (XXX obsolete, not supported via LSM) 
# and to control traffic sent or received on the interface.
attribute netif_type;

# Identifies all default types assigned to packets received 
# on network interfaces.  
attribute netmsg_type;

# Identifies all types assigned to network nodes/hosts to control
# traffic sent to or received from the node.
attribute node_type;

# Identifier for log files or directories that only exist for log files.
attribute logfile;

# Identifier for lock files (/var/lock/*) or directories that only exist for
# lock files.
attribute lockfile;



##############################
# Attributes for security policy types:
#

# The login_contexts attribute idenitifies the files used
# to define default contexts for login types (e.g., login, cron).
attribute login_contexts;

# Identifier for a domain used by "sendmail -t" (IE user_mail_t,
# sysadm_mail_t, etc)
attribute user_mail_domain;

# Identifies domains that can transition to system_mail_t
attribute privmail;

# Type for non-sysadm home directory
attribute user_home_type;

# For domains that are part of a mail server and need to read user files and
# fifos, and inherit file handles to enable user email to get to the mail
# spool
attribute mta_user_agent;

# For domains that are part of a mail server for delivering messages to the
# user
attribute mta_delivery_agent;

# For web clients such as netscape and squid
attribute web_client_domain;

# For a mail server process that takes TCP connections on port 25
attribute mail_server_domain;


























#
# Macros for all admin domains.
#

#
# admin_domain(domain_prefix)
#
# Define derived types and rules for an administrator domain.
#
# The type declaration and role authorization for the domain must be
# provided separately.  Likewise, domain transitions into this domain
# must be specified separately.  If the every_domain() rules are desired,
# then these rules must also be specified separately.
#

#line 475


##############################
#
# core macros for the type enforcement (TE) configuration.
#
#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
#           Howard Holm (NSA), <hdholm@epoch.ncsc.mil>
#           Russell Coker <russell@coker.com.au>
#

#################################
# 
# Macros for groups of classes and 
# groups of permissions.
#

#
# All directory and file classes
#


#
# All non-directory file classes.
#


#
# Non-device file classes.
#


#
# Device file classes.
#


#
# All socket classes.
#


#
# Datagram socket classes.
# 


#
# Stream socket classes.
#


#
# Unprivileged socket classes (exclude rawip, netlink, packet).
#



# 
# Permissions for getting file attributes.
#


# 
# Permissions for executing files.
#


# 
# Permissions for reading files and their attributes.
#


# 
# Permissions for reading and executing files.
#


# 
# Permissions for reading and writing files and their attributes.
#


# 
# Permissions for reading and appending to files.
#


#
# Permissions for linking, unlinking and renaming files.
# 


#
# Permissions for creating and using files.
# 


# 
# Permissions for reading directories and their attributes.
#


# 
# Permissions for reading and writing directories and their attributes.
#


# 
# Permissions for reading and adding names to directories.
#



#
# Permissions for creating and using directories.
# 


#
# Permissions to mount and unmount file systems.
#


#
# Permissions for using sockets.
# 


#
# Permissions for creating and using sockets.
# 


#
# Permissions for using stream sockets.
# 


#
# Permissions for creating and using stream sockets.
# 



#
# Permissions for sending all signals.
#


#
# Permissions for sending and receiving network packets.
#


#
# Permissions for using System V IPC
#










#################################
# 
# Macros for type transition rules and
# access vector rules.
#

#
# Simple combinations for reading and writing both
# directories and files.
# 
#line 657


#line 662


#line 667


#line 672


#line 677


#line 682


#line 687


##################################
#
# can_getsecurity(domain)
#
# Authorize a domain to get security policy decisions.
#
#line 699


##################################
#
# can_setenforce(domain)
#
# Authorize a domain to set the enforcing flag.
# Due to its sensitivity, always audit this permission.
#
#line 713


##################################
#
# can_loadpol(domain)
#
# Authorize a domain to load a policy configuration.
# Due to its sensitivity, always audit this permission.
#
#line 727


#################################
#
# domain_trans(parent_domain, program_type, child_domain)
#
# Permissions for transitioning to a new domain.
#

#line 779


#################################
#
# domain_auto_trans(parent_domain, program_type, child_domain)
#
# Define a default domain transition and allow it.
#
#line 790


#################################
#
# can_ptrace(domain, domain)
#
# Permissions for running ptrace (strace or gdb) on another domain
#
#line 801


#################################
#
# can_exec(domain, type)
#
# Permissions for executing programs with
# a specified type without changing domains.
#
#line 812


#################################
#
# file_type_trans(domain, dir_type, file_type)
#
# Permissions for transitioning to a new file type.
#

#line 842


#################################
#
# file_type_auto_trans(creator_domain, parent_directory_type, file_type, object_class)
#
# the object class will default to notdevfile_class_set if not specified as
# the fourth parameter
#
# Define a default file type transition and allow it.
#
#line 863



#################################
#
# can_unix_connect(client, server)
#
# Permissions for establishing a Unix stream connection.
#
#line 874


#################################
#
# can_unix_send(sender, receiver)
#
# Permissions for sending Unix datagrams.
#
#line 884


#################################
#
# can_tcp_connect(client, server)
#
# Permissions for establishing a TCP connection.
#
#line 897


#################################
#
# can_udp_send(sender, receiver)
#
# Permissions for sending/receiving UDP datagrams.
#
#line 908



##################################
#
# base_pty_perms(domain_prefix)
#
# Base permissions used for can_create_pty() and can_create_other_pty()
#
#line 928



##################################
#
# pty_slave_label(domain_prefix, attributes)
#
# give access to a slave pty but do not allow creating new ptys
#
#line 948



##################################
#
# can_create_pty(domain_prefix, attributes)
#
# Permissions for creating ptys.
#
#line 960



##################################
#
# can_create_other_pty(domain_prefix,other_domain)
#
# Permissions for creating ptys for another domain.
#
#line 976



#
# general_domain_access(domain)
#
# Grant permissions within the domain.
# This includes permissions to processes, /proc/PID files,
# file descriptors, pipes, Unix sockets, and System V IPC objects
# labeled with the domain.
#
#line 1013

##############################
#
# Global macros for the type enforcement (TE) configuration.
#

#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
#           Howard Holm (NSA) <hdholm@epoch.ncsc.mil>
#           Russell Coker <russell@coker.com.au>
#
#
#

##################################
#
# can_setexec(domain)
#
# Authorize a domain to set its exec context
# (via /proc/pid/attr/exec).
#
#line 1040


##################################
#
# can_setfscreate(domain)
#
# Authorize a domain to set its fscreate context
# (via /proc/pid/attr/fscreate).
#
#line 1055


#################################
#
# uses_shlib(domain)
#
# Permissions for using shared libraries.
#
#line 1074


#################################
#
# can_exec_any(domain)
#
# Permissions for executing a variety
# of executable types.
#
#line 1092



#################################
#
# can_network(domain)
#
# Permissions for accessing the network.
# See types/network.te for the network types.
# See net_contexts for security contexts for network entities.
#
#line 1171


#################################
#
# can_sysctl(domain)
#
# Permissions for modifying sysctl parameters.
#
#line 1195



##################################
#
# read_locale(domain)
#
# Permissions for reading the locale data,
# /etc/localtime and the files that it links to
#
#line 1208



#
# general_proc_read_access(domain)
#
# Grant read/search permissions to most of /proc, excluding
# the /proc/PID directories and the /proc/kmsg and /proc/kcore files.
# The general_domain_access macro grants access to the domain /proc/PID
# directories, but not to other domains.  Only permissions to stat
# are granted for /proc/kmsg and /proc/kcore, since these files are more
# sensitive.
# 
#line 1244


#
# base_file_read_access(domain)
#
# Grant read/search permissions to a few system file types.
#
#line 1268


#######################
# daemon_core_rules(domain_prefix, attribs)
#
# Define the core rules for a daemon, used by both daemon_base_domain() and
# init_service_domain().
# Attribs is the list of attributes which must start with "," if it is not empty
#
# Author:  Russell Coker <russell@coker.com.au>
#
#line 1299

#######################
# init_service_domain(domain_prefix, attribs)
#
# Define a domain for a program that is run from init
# Attribs is the list of attributes which must start with "," if it is not empty
#
# Author:  Russell Coker <russell@coker.com.au>
#
#line 1313

#######################
# daemon_base_domain(domain_prefix, attribs)
#
# Define a daemon domain with a base set of type declarations
# and permissions that are common to most daemons.
# attribs is the list of attributes which must start with "," if it is not empty
#
# Author:  Russell Coker <russell@coker.com.au>
#
#line 1331

# allow a domain to create its own files under /var/run and to create files
# in directories that are created for it.  For sock_file etc you need to add
# your own rules
#line 1339


#line 1357

#line 1363


# define a sub-domain, $1_t is the parent domain, $2 is the name
# of the sub-domain.
#
#line 1390



#line 1396


#line 1403


#line 1409


#line 1414


#line 1419


#line 1424


#######################
# application_domain(domain_prefix)
#
# Define a domain with a base set of type declarations
# and permissions that are common to simple applications.
#
# Author:  Russell Coker <russell@coker.com.au>
#
#line 1440


#line 1446


#line 1454


#
# Macros for all user login domains.
#

#
# user_domain(domain_prefix)
#
# Define derived types and rules for an ordinary user domain.
#
# The type declaration and role authorization for the domain must be
# provided separately.  Likewise, domain transitions into this domain
# must be specified separately.  
#

#line 1735



###########################################################################
#
# Domains for ordinary users.
#

#line 1831



#line 1837


#########################################################
#
# Ugly macros that give way too much access until we can
# go over the http policy more carefully.

#########################################################
#
# apache_domain_read_access(domain)
#
# This is a temporary measure to remove the every_domain,
# general_file_read_access and general_file_write_access macros.
# This macro gives far too much access.  The access needs to
# be trimmed down where this macro is used in this file and
# then destroyed.
#
#line 1983


#########################################################
#
# apache_domain_write_access(domain)
#
# This is a temporary measure to remove the every_domain,
# general_file_read_access and general_file_write_access macros.
# This macro gives far too much access.  The access needs to
# be trimmed down where this macro is used in this file and
# then destroyed.
#
#line 2002


#########################################################
#
# apache_domain_general_access(domain)
#
# This is a temporary measure to remove the every_domain,
# general_file_read_access and general_file_write_access macros.
# This macro gives far too much access.  The access needs to
# be trimmed down where this macro is used in this file and
# then destroyed.
#
#line 2038

#
# Macros for chkpwd domains.
#

#
# chkpwd_domain(domain_prefix)
#
# Define a derived domain for the *_chkpwd program when executed
# by a user domain.
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/su.te. 
#

#line 2098

#line 2098

#line 2098

#line 2098


# macro for chroot environments
# Author Russell Coker

# chroot(initial_domain, basename, role, tty_device_type)
#line 2228

#
# Macros for clamscan
#
# Author:  Brian May <bam@snoopy.apana.org.au>
#

#
# can_clamd_connect(domain_prefix)
#
# Define a domain that can access clamd
#
#line 2243


# clamscan_domain(domain_prefix)
#
# Define a derived domain for the clamscan program when executed
#
#line 2272


#line 2285


#line 2320


#line 2330


#
# Macros for crond domains.
#

#
# Authors:  Jonathan Crowley (MITRE) <jonathan@mitre.org>,
#	    Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser
#

#
# crond_domain(domain_prefix)
#
# Define a derived domain for cron jobs executed by crond on behalf 
# of a user domain.  These domains are separate from the top-level domain
# defined for the crond daemon and the domain defined for system cron jobs,
# which are specified in domains/program/crond.te.
#

#line 2427


# When system_crond_t domain executes a type $1 executable then transition to
# domain $2, allow $2 to interact with crond_t as well.
#line 2437

#
# Macros for crontab domains.
#

#
# Authors:  Jonathan Crowley (MITRE) <jonathan@mitre.org>
# Revised by Stephen Smalley <sds@epoch.ncsc.mil>
#

#
# crontab_domain(domain_prefix)
#
# Define a derived domain for the crontab program when executed by
# a user domain.  
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/crontab.te. 
#

#line 2528

#
# Macro for fingerd
#
# Author:  Russell Coker <russell@coker.com.au>
#

#
# fingerd_macro(domain_prefix)
#
# allow fingerd to create a fingerlog file in the user home dir
#
#line 2543

#
# Macros for gpg and pgp
#
# Author:  Russell Coker <russell@coker.com.au>
#
# based on the work of:
# Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser
#

#
# gpg_domain(domain_prefix)
#
# Define a derived domain for the gpg/pgp program when executed by
# a user domain.
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/gpg.te.
#
#line 2630

#
# Macros for gnome-pty-helper domains.
#

#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser 
#

#
# gph_domain(domain_prefix)
#
# Define a derived domain for the gnome-pty-helper program when
# executed by a user domain.
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/gnome-pty-helper.te. 
#
# The *_gph_t domains are for the gnome_pty_helper program.
# This program is executed by gnome-terminal to handle
# updates to utmp and wtmp.  In this regard, it is similar
# to utempter.  However, unlike utempter, gnome-pty-helper
# also creates the pty file for the terminal program.
# There is one *_gph_t domain for each user domain.  
#

#line 2702


#
# Macros for irc domains.
#

#
# Author:  Russell Coker <russell@coker.com.au>
#

#
# irc_domain(domain_prefix)
#
# Define a derived domain for the irc program when executed
# by a user domain.
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/irc.te. 
#

#line 2790

#line 2790

#line 2790

#line 2790

#line 2790

#
# Macros for lpr domains.
#

#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser 
#

#
# lpr_domain(domain_prefix)
#
# Define a derived domain for the lpr/lpq/lprm programs when executed
# by a user domain.
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/lpr.te. 
#

#line 2897

#
# Macros for mount
#
# Author:  Brian May <bam@snoopy.apana.org.au>
# Extended by Russell Coker <russell@coker.com.au>
#

#
# mount_domain(domain_prefix,dst_domain_prefix)
#
# Define a derived domain for the mount program for anyone.
#
#line 2947

#
# Macros for MTA domains.
#

#
# Author:   Russell Coker <russell@coker.com.au>
# Based on the work of: Stephen Smalley <sds@epoch.ncsc.mil>
#                       Timothy Fraser 
#

#
# mail_domain(domain_prefix)
#
# Define a derived domain for the sendmail program when executed by
# a user domain to send outgoing mail.  These domains are separate and
# independent of the domain used for the sendmail daemon process.
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/mta.te. 
#

#line 3058

#
# Macros for netscape/mozilla (or other browser) domains.
#

#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser 
#

#
# netscape_domain(domain_prefix)
#
# Define a derived domain for the netscape/mozilla program when executed by
# a user domain.  
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/netscape.te. 
#
#line 3120

# $1 is the source domain (or domains), $2 is the source role (or roles) and $3
# is the base name for the domain to run.  $1 is normally sysadm_t, and $2 is
# normally sysadm_r.  $4 is the type of program to run and $5 is the domain to
# transition to.
# sample usage:
# run_program(sysadm_t, sysadm_r, init, etc_t, initrc_t)
#
# if you have several users who run the same run_init type program for
# different purposes (think of a run_db program used by several database
# administrators to start several databases) then you can list all the source
# domains in $1, all the source roles in $2, but you may not want to list all
# types of programs to run in $4 and target domains in $5 (as that may permit
# entering a domain from the wrong type).  In such a situation just specify
# one value for each of $4 and $5 and have some rules such as the following:
# domain_trans(run_whatever_t, whatever_exec_t, whatever_t)

#line 3176

#
# Macros for screen domains.
#

#
# Author: Russell Coker <russell@coker.com.au>
# Based on the work of Stephen Smalley <sds@epoch.ncsc.mil>
# and Timothy Fraser
#

#
# screen_domain(domain_prefix)
#
# Define a derived domain for the screen program when executed
# by a user domain.
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/screen.te. 
#

#line 3270

#line 3270

#line 3270

#line 3270

#line 3270

#
# Macros for sendmail domains.
#

#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser 
#           Russell Coker <russell@coker.com.au>
#

#
# sendmail_user_domain(domain_prefix)
#
# Define a derived domain for the sendmail program when executed by
# a user domain to send outgoing mail.  These domains are separate and
# independent of the domain used for the sendmail daemon process.
#

#line 3304


#
# Macros for ssh domains.
#

#
# Author:  Stephen Smalley <sds@epoch.ncsc.mil>
#

# 
# ssh_domain(domain_prefix)
#
# Define a derived domain for the ssh program when executed
# by a user domain.
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/ssh.te. 
#

#line 3474

#line 3474

#line 3474

#line 3474

#
# Macros for su domains.
#

#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser
#

#
# su_domain(domain_prefix)
#
# Define a derived domain for the su program when executed
# by a user domain.
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/su.te. 
#


#line 3567

#line 3567

#line 3567

#line 3567

#
# Macros for X client programs ($2 etc)
#

#
# Author: Russell Coker <russell@coker.com.au>
# Based on the work of Stephen Smalley <sds@epoch.ncsc.mil>
# and Timothy Fraser 
#

#
# x_client_domain(domain_prefix)
#
# Define a derived domain for an X program when executed by
# a user domain.  
#
# The type declaration for the executable type for this program ($2_exec_t)
# must be provided separately!
#
# The first parameter is the base name for the domain/role (EG user or sysadm)
# The second parameter is the program name (EG $2)
# The third parameter is the attributes for the domain (if any)
#
#line 3731
#
# Macros for xauth domains.
#

#
# Author:  Russell Coker <russell@coker.com.au>
#

#
# xauth_domain(domain_prefix)
#
# Define a derived domain for the xauth program when executed
# by a user domain.
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/xauth.te. 
#

#line 3818

#line 3818

#line 3818

#line 3818

#line 3818

#
# Macros for X server domains.
#

#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser
#

#################################
#
# xserver_domain(domain_prefix)
#
# Define a derived domain for the X server when executed
# by a user domain (e.g. via startx).  See the xdm_t domain
# in domains/program/xdm.te if using an X Display Manager.
#
# The type declarations for the executable type for this program 
# and the log type are provided separately in domains/program/xserver.te. 
#
# FIXME!  The X server requires far too many privileges.
#

#line 3996

#line 3996

#line 3996

#line 3996

#line 3996


#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
#

############################################
#
# Device types
#

#
# device_t is the type of /dev.
#
type device_t, file_type;

#
# null_device_t is the type of /dev/null.
#
type null_device_t, file_type, device_type, mlstrustedobject;

#
# zero_device_t is the type of /dev/zero.
#
type zero_device_t, file_type, device_type, mlstrustedobject;

#
# console_device_t is the type of /dev/console.
#
type console_device_t, file_type, device_type;

#
# memory_device_t is the type of /dev/kmem,
# /dev/mem, and /dev/port.
#
type memory_device_t, file_type, device_type;

#
# random_device_t is the type of /dev/urandom
# and /dev/random.
#
type random_device_t, file_type, device_type;

#
# devtty_t is the type of /dev/tty.
#
type devtty_t, file_type, device_type, mlstrustedobject;

#
# tty_device_t is the type of /dev/*tty*
#
type tty_device_t, file_type, device_type;

#
# fixed_disk_device_t is the type of 
# /dev/hd* and /dev/sd*.
#
type fixed_disk_device_t, file_type, device_type;

#
# removable_device_t is the type of
# /dev/scd* and /dev/fd*.
#
type removable_device_t, file_type, device_type;

#
# clock_device_t is the type of
# /dev/rtc.
#
type clock_device_t, file_type, device_type;

#
# tun_tap_device_t is the type of /dev/net/tun/* and /dev/net/tap/*
#
type tun_tap_device_t, file_type, device_type;

#
# misc_device_t is the type of miscellaneous devices.
# XXX:  FIXME!  Appropriate access to these devices need to be identified.
#
type misc_device_t, file_type, device_type;

#
# psaux_t is the type of the /dev/psaux mouse device.
# This type is deprecated and will be removed.
#
type psaux_t, file_type, device_type;

#
# A more general type for mouse devices.
#
type mouse_device_t, file_type, device_type;

#
# Not sure what these devices are for, but X wants access to them.
#
type agp_device_t, file_type, device_type;
type dri_device_t, file_type, device_type;

# Type for sound devices.
type sound_device_t, file_type, device_type;

# Type for /dev/ppp.
type ppp_device_t, file_type, device_type;

# Type for frame buffer /dev/fb/*
type framebuf_device_t, file_type, device_type;

# Type for /dev/.devfsd
type devfs_control_t, file_type, device_type;

# Type for /dev/cpu/mtrr
type mtrr_device_t, file_type, device_type;


# Type for /dev/apm_bios
type apm_bios_t, file_type, device_type;

# Type for v4l
type v4l_device_t, file_type, device_type;

# tape drives
type tape_device_t, file_type, device_type;

# scanners
type scanner_device_t, file_type, device_type;

# cpu control devices /dev/cpu/0/*
type cpu_device_t, file_type, device_type;
#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
#

############################################
#
# Devpts types
#

#
# ptmx_t is the type for /dev/ptmx.
#
type ptmx_t, file_type, sysadmfile;

#
# devpts_t is the type of the devpts file system and 
# the type of the root directory of the file system.
#
type devpts_t, fs_type, root_dir_type;


#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
#

#######################################
#
# General file-related types
#

#
# unlabeled_t is the type of unlabeled objects.
# Eventually, once all objects are labeled and 
# controlled by the security policy, unlabeled_t 
# will not be used.
#
type unlabeled_t, fs_type, file_type, root_dir_type, sysadmfile;

#
# fs_t is the default type of an unlabeled
# file system.  When an unlabeled file system is
# mounted read-write, the file system is labeled
# with this type.  Except for the root file system,
# other types may be specified using the fs_contexts
# or fs_contexts.mls file.
#
type fs_t, fs_type;

#
# file_t is the default type of an unlabeled
# file.  When an unlabeled file system is mounted
# read-write, all files in the file system are labeled
# with this type.   Except for the root file system,
# other types may be specified using the fs_contexts
# or fs_contexts.mls file.
#
type file_t, file_type, root_dir_type, sysadmfile;

#
# root_t is the type for the root directory.
#
type root_t, file_type, sysadmfile;

#
# home_root_t is the type for the directory where user home directories
# are created
#
type home_root_t, file_type, sysadmfile;

#
# lost_found_t is the type for the lost+found directories.
#
type lost_found_t, file_type, sysadmfile;

#
# boot_t is the type for files in /boot,
# including the kernel.
#
type boot_t, file_type, root_dir_type, sysadmfile;
# system_map_t is for the system.map files in /boot
type system_map_t, file_type, sysadmfile;

#
# boot_runtime_t is the type for /boot/kernel.h,
# which is automatically generated at boot time.
# only for red hat
type boot_runtime_t, file_type, sysadmfile;

#
# tmp_t is the type of /tmp and /var/tmp.
#
type tmp_t, file_type, sysadmfile, tmpfile;

#
# etc_t is the type of the system etc directories.
#
type etc_t, file_type, sysadmfile;
#
# shadow_t is the type of the /etc/shadow file
#
type shadow_t, file_type;
allow auth shadow_t:file { getattr read };

#
# ld_so_cache_t is the type of /etc/ld.so.cache.
#
type ld_so_cache_t, file_type, sysadmfile;

#
# etc_runtime_t is the type of various
# files in /etc that are automatically
# generated during initialization.
#
type etc_runtime_t, file_type, sysadmfile;

#
# etc_aliases_t is the type of the aliases database.
# etc_mail_t is the type of /etc/mail.
# sendmail needs write access to these files.
#
type etc_aliases_t, file_type, sysadmfile;
type etc_mail_t, file_type, sysadmfile;

# resolv_conf_t is the type of the /etc/resolv.conf file.
# pump needs write access to this file.
type resolv_conf_t, file_type, sysadmfile;

#
# lib_t is the type of files in the system lib directories.
#
type lib_t, file_type, sysadmfile;

#
# shlib_t is the type of shared objects in the system lib
# directories.
#
type shlib_t, file_type, sysadmfile;

#
# ld_so_t is the type of the system dynamic loaders.
#
type ld_so_t, file_type, sysadmfile;

#
# bin_t is the type of files in the system bin directories.
#
type bin_t, file_type, sysadmfile;

#
# ls_exec_t is the type of the ls program.
#
type ls_exec_t, file_type, exec_type, sysadmfile;

#
# shell_exec_t is the type of user shells such as /bin/bash.
#
type shell_exec_t, file_type, exec_type, sysadmfile;

#
# sbin_t is the type of files in the system sbin directories.
#
type sbin_t, file_type, sysadmfile;

#
# usr_t is the type for /usr.
#
type usr_t, file_type, root_dir_type, sysadmfile;

#
# src_t is the type of files in the system src directories.
#
type src_t, file_type, sysadmfile;

#
# var_t is the type for /var.
#
type var_t, file_type, root_dir_type, sysadmfile;

#
# Types for subdirectories of /var.
#
type var_run_t, file_type, sysadmfile;
type var_log_t, file_type, sysadmfile, logfile;
type faillog_t, file_type, sysadmfile, logfile;
type var_lock_t, file_type, sysadmfile, lockfile;
type var_lib_t, file_type, sysadmfile;
# for /var/{spool,lib}/texmf index files
type tetex_data_t, file_type, sysadmfile, tmpfile;
type var_spool_t, file_type, sysadmfile;
type var_yp_t, file_type, sysadmfile;

# Type for /var/log/sa.
type var_log_sa_t, file_type, sysadmfile, logfile;

# Type for /var/log/ksyms.
type var_log_ksyms_t, file_type, sysadmfile, logfile;

# Type for /var/log/lastlog.
type lastlog_t, file_type, sysadmfile, logfile;

# Type for /var/lib/nfs.
type var_lib_nfs_t, file_type, sysadmfile;

#
# wtmp_t is the type of /var/log/wtmp.
#
type wtmp_t, file_type, sysadmfile, logfile;

#
# catman_t is the type for /var/catman.
#
type catman_t, file_type, sysadmfile, tmpfile;

#
# at_spool_t is the type for /var/spool/at.
#
type at_spool_t, file_type, sysadmfile;

#
# cron_spool_t is the type for /var/spool/cron.
#
type cron_spool_t, file_type, sysadmfile;

#
# print_spool_t is the type for /var/spool/lpd and /var/spool/cups.
#
type print_spool_t, file_type, sysadmfile;

#
# mail_spool_t is the type for /var/spool/mail.
#
type mail_spool_t, file_type, sysadmfile;

#
# mqueue_spool_t is the type for /var/spool/mqueue.
#
type mqueue_spool_t, file_type, sysadmfile;

#
# man_t is the type for the man directories.
#
type man_t, file_type, sysadmfile;

#
# readable_t is a general type for
# files that are readable by all domains.
#
type readable_t, file_type, sysadmfile;

# 
# Base type for the tests directory.
# 
type test_file_t, file_type, sysadmfile;

#
# poly_t is the type for the polyinstantiated directories.
#
type poly_t, file_type, sysadmfile;

#
# swapfile_t is for swap files
#
type swapfile_t, file_type, sysadmfile;

#
# locale_t is the type for system localization
# 
type locale_t, file_type, sysadmfile;

#
# Allow each file type to be associated with 
# the default file system type.
#
allow file_type fs_t:filesystem associate;

# Allow the pty to be associated with the file system.
allow devpts_t devpts_t:filesystem associate;

type tmpfs_t, file_type, sysadmfile, fs_type, root_dir_type;
allow { tmpfs_t tmp_t } tmpfs_t:filesystem associate;

type usbdevfs_t, fs_type, root_dir_type, sysadmfile;
allow usbdevfs_t usbdevfs_t:filesystem associate;

type sysfs_t alias driverfs_t, fs_type, root_dir_type, sysadmfile;
allow sysfs_t sysfs_t:filesystem associate;

type iso9660_t, fs_type, root_dir_type, sysadmfile;
allow iso9660_t iso9660_t:filesystem associate;

type dosfs_t, fs_type, root_dir_type, sysadmfile;
allow dosfs_t dosfs_t:filesystem associate;
#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
#

# Modified by Reino Wallin <reino@oribium.com>
# Multi NIC, and IPSEC features

# Modified by Russell Coker
# Move port types to their respective domains, add ifdefs, other cleanups.

# generally we do not want to define port types in this file, but some things
# are insanely difficult to do elsewhere, xserver_port_t is a good example
# getting the type defined is the easy part for X, conditional code for many
# other domains (including one that starts with a) is the hard part.


#line 4435


############################################
#
# Network types
#

# 
# any_socket_t is the default destination
# socket type for UDP traffic.  Unless a 
# destination socket type is explicitly specified
# using sendto_secure/sendmsg_secure, this type
# is used for the udp_socket sendto permission check.
#
type any_socket_t, socket_type;
role system_r types any_socket_t;

#
# igmp_packet_t is the type of kernel-generated IGMP packets.
# icmp_socket_t is the type of the kernel socket used to send ICMP messages.
# tcp_socket_t is the type of the kernel socket used to send TCP resets.
# scmp_packet_t is the type for SCMP packets used by the SELOPT packet labeling.
#
type igmp_packet_t;
role system_r types igmp_packet_t;
type icmp_socket_t, socket_type;
role system_r types icmp_socket_t;
type tcp_socket_t, socket_type;
role system_r types tcp_socket_t;
type scmp_packet_t;
role system_r types scmp_packet_t;

#
# port_t is the default type of INET port numbers.
# The *_port_t types are used for specific port
# numbers in net_contexts or net_contexts.mls.
#
type port_t, port_type;

#
# netif_t is the default type of network interfaces.
# The netif_*_t types are used for specific network
# interfaces in net_contexts or net_contexts.mls.
#
type netif_t, netif_type;
type netif_eth0_t, netif_type;
type netif_eth1_t, netif_type;
type netif_eth2_t, netif_type;
type netif_lo_t, netif_type;
type netif_ippp0_t, netif_type;

type netif_ipsec0_t, netif_type;
type netif_ipsec1_t, netif_type;
type netif_ipsec2_t, netif_type;

#
# netmsg_t is the default type of unlabeled received messages.
# The netmsg_*_t types are used for specific network
# interfaces in net_contexts or net_contexts.mls.
#
type netmsg_t, netmsg_type;
type netmsg_eth0_t, netmsg_type;
type netmsg_eth1_t, netmsg_type;
type netmsg_eth2_t, netmsg_type;
type netmsg_lo_t, netmsg_type;
type netmsg_ippp0_t, netmsg_type;

type netmsg_ipsec0_t, netmsg_type;
type netmsg_ipsec1_t, netmsg_type;
type netmsg_ipsec2_t, netmsg_type;

#
# node_t is the default type of network nodes.
# The node_*_t types are used for specific network
# nodes in net_contexts or net_contexts.mls.
#
type node_t, node_type;
type node_lo_t, node_type;
type node_internal_t, node_type;

#
# Permissions for the kernel-generated IGMP packets.
#
allow igmp_packet_t netif_type:netif { rawip_send rawip_recv };
allow igmp_packet_t node_type:node { rawip_send rawip_recv };

#
# Permissions for the kernel ICMP socket.
#
allow icmp_socket_t netif_type:netif { rawip_send rawip_recv };
allow icmp_socket_t node_type:node { rawip_send rawip_recv };
allow icmp_socket_t netmsg_type:rawip_socket recvfrom;

#
# Permissions for the kernel TCP reset socket.
#
allow tcp_socket_t netif_type:netif { tcp_send tcp_recv };
allow tcp_socket_t netmsg_type:tcp_socket recvfrom;
allow tcp_socket_t node_type:node { tcp_send tcp_recv };

#
# Allow network messages to be received.
#
allow netmsg_t node_t:node { tcp_recv udp_recv rawip_recv };
allow netmsg_eth0_t node_t:node { tcp_recv udp_recv rawip_recv };
allow netmsg_eth0_t netif_eth0_t:netif { tcp_recv udp_recv rawip_recv };
allow netmsg_eth1_t node_t:node { tcp_recv udp_recv rawip_recv };
allow netmsg_eth1_t netif_eth1_t:netif { tcp_recv udp_recv rawip_recv };
allow netmsg_eth2_t node_t:node { tcp_recv udp_recv rawip_recv };
allow netmsg_eth2_t netif_eth2_t:netif { tcp_recv udp_recv rawip_recv };
allow netmsg_lo_t node_lo_t:node { tcp_recv udp_recv rawip_recv };
allow netmsg_lo_t node_t:node { tcp_recv udp_recv rawip_recv };
allow netmsg_lo_t netif_lo_t:netif { tcp_recv udp_recv rawip_recv };
allow netmsg_ippp0_t node_t:node { tcp_recv udp_recv rawip_recv };
allow netmsg_ippp0_t netif_ippp0_t:netif { tcp_recv udp_recv rawip_recv };
allow netmsg_ipsec0_t node_t:node { tcp_recv udp_recv rawip_recv };
allow netmsg_ipsec0_t netif_ipsec0_t:node { tcp_recv udp_recv rawip_recv };
allow netmsg_ipsec1_t node_t:node { tcp_recv udp_recv rawip_recv };
allow netmsg_ipsec1_t netif_ipsec1_t:netif { tcp_recv udp_recv rawip_recv };
allow netmsg_ipsec2_t node_t:node { tcp_recv udp_recv rawip_recv };
allow netmsg_ipsec2_t netif_ipsec2_t:netif { tcp_recv udp_recv rawip_recv };

#
# Allow ICMP echo requests to be sent and received, and echo replies to 
# be received (when packets are labeled)
#
#line 4564

#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
#

#############################################
#
# NFS types
#

#
# nfs_t is the default type for NFS file systems 
# and their files.  
# The nfs_*_t types are used for specific NFS
# servers in net_contexts or net_contexts.mls.
#
type nfs_t, fs_type, root_dir_type;

#
# Allow NFS files to be associated with an NFS file system.
#
allow nfs_t nfs_t:filesystem associate;
#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
#

############################################
#
# Procfs types
#

#
# proc_t is the type of /proc.
# proc_kmsg_t is the type of /proc/kmsg.
# proc_kcore_t is the type of /proc/kcore.
#
type proc_t, fs_type, root_dir_type;
type proc_kmsg_t;
type proc_kcore_t;

#
# sysctl_t is the type of /proc/sys.
# sysctl_fs_t is the type of /proc/sys/fs.
# sysctl_kernel_t is the type of /proc/sys/kernel.
# sysctl_modprobe_t is the type of /proc/sys/kernel/modprobe.
# sysctl_net_t is the type of /proc/sys/net.
# sysctl_net_unix_t is the type of /proc/sys/net/unix.
# sysctl_vm_t is the type of /proc/sys/vm.
# sysctl_dev_t is the type of /proc/sys/dev.
#
# These types are applied to both the entries in
# /proc/sys and the corresponding sysctl parameters.
#
type sysctl_t;
type sysctl_fs_t;
type sysctl_kernel_t;
type sysctl_modprobe_t;
type sysctl_net_t;
type sysctl_net_unix_t;
type sysctl_vm_t;
type sysctl_dev_t;


#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
#

############################################
#
# Security types
#

# 
# security_t is the target type when checking
# the permissions in the security class.  It is also
# applied to selinuxfs inodes.
#
type security_t, fs_type;

#
# policy_config_t is the type of /etc/security/selinux/*
# the security server policy configuration.
#
type policy_config_t, file_type;

#
# policy_src_t is the type of the policy source
# files.
#
type policy_src_t, file_type;

#
# default_context_t is the type applied to 
# /etc/security/default_context
#
type default_context_t, file_type, sysadmfile, login_contexts;

#
# file_labels_t is the type of the persistent
# label mapping stored in each file system.
# The mapping files are in the ...security
# subdirectory at the root of each file system.
#
type file_labels_t, file_type, sysadmfile;

#
# no_access_t is the type for objects that should
# only be accessed administratively. 
#
type no_access_t, file_type, sysadmfile;


#DESC Admin - Domains for administrators.
#
#################################

# sysadm_t is the system administrator domain.
type sysadm_t, domain, privlog, privowner, admin, userdomain, web_client_domain, privhome;
allow privhome home_root_t:dir search;

# system_r is authorized for sysadm_t for single-user mode.
role system_r types sysadm_t; 

# sysadm_r is authorized for sysadm_t for the initial login domain.
role sysadm_r types sysadm_t;


#line 4690
# Read system information files in /proc.
#line 4690
allow sysadm_t proc_t:dir { read getattr lock search ioctl };
#line 4690
allow sysadm_t proc_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4690

#line 4690
# Stat /proc/kmsg and /proc/kcore.
#line 4690
allow sysadm_t proc_kmsg_t:file { getattr };
#line 4690
allow sysadm_t proc_kcore_t:file { getattr };
#line 4690

#line 4690
# Read system variables in /proc/sys.
#line 4690
allow sysadm_t sysctl_modprobe_t:file { read getattr lock ioctl };
#line 4690
allow sysadm_t sysctl_t:file { read getattr lock ioctl };
#line 4690
allow sysadm_t sysctl_t:dir { read getattr lock search ioctl };
#line 4690
allow sysadm_t sysctl_fs_t:file { read getattr lock ioctl };
#line 4690
allow sysadm_t sysctl_fs_t:dir { read getattr lock search ioctl };
#line 4690
allow sysadm_t sysctl_kernel_t:file { read getattr lock ioctl };
#line 4690
allow sysadm_t sysctl_kernel_t:dir { read getattr lock search ioctl };
#line 4690
allow sysadm_t sysctl_net_t:file { read getattr lock ioctl };
#line 4690
allow sysadm_t sysctl_net_t:dir { read getattr lock search ioctl };
#line 4690
allow sysadm_t sysctl_vm_t:file { read getattr lock ioctl };
#line 4690
allow sysadm_t sysctl_vm_t:dir { read getattr lock search ioctl };
#line 4690
allow sysadm_t sysctl_dev_t:file { read getattr lock ioctl };
#line 4690
allow sysadm_t sysctl_dev_t:dir { read getattr lock search ioctl };
#line 4690


#line 4691
# Access other processes in the same domain.
#line 4691
# Omits ptrace, setexec, and setfscreate.  These must be granted 
#line 4691
# separately if desired.
#line 4691
allow sysadm_t self:process ~{ptrace setexec setfscreate};
#line 4691

#line 4691
# Access /proc/PID files for processes in the same domain.
#line 4691
allow sysadm_t self:dir { read getattr lock search ioctl };
#line 4691
allow sysadm_t self:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4691

#line 4691
# Access file descriptions, pipes, and sockets
#line 4691
# created by processes in the same domain.
#line 4691
allow sysadm_t self:fd *;
#line 4691
allow sysadm_t self:fifo_file { ioctl read getattr lock write append };
#line 4691
allow sysadm_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4691
allow sysadm_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4691

#line 4691
# Allow the domain to communicate with other processes in the same domain.
#line 4691
allow sysadm_t self:unix_dgram_socket sendto;
#line 4691
allow sysadm_t self:unix_stream_socket connectto;
#line 4691

#line 4691
# Access System V IPC objects created by processes in the same domain.
#line 4691
allow sysadm_t self:sem  { associate getattr setattr create destroy read write unix_read unix_write };
#line 4691
allow sysadm_t self:msg  { send receive };
#line 4691
allow sysadm_t self:msgq { associate getattr setattr create destroy read write enqueue unix_read unix_write };
#line 4691
allow sysadm_t self:shm  { associate getattr setattr create destroy read write lock unix_read unix_write };
#line 4691


# sysadm_t is also granted permissions specific to administrator domains.

#line 4694
# Inherit rules for ordinary users.
#line 4694

#line 4694
# Use capabilities
#line 4694
allow sysadm_t self:capability { setgid chown fowner };
#line 4694
dontaudit sysadm_t self:capability { sys_nice fsetid };
#line 4694

#line 4694
# Type for home directory.
#line 4694

#line 4694
type sysadm_home_dir_t, file_type, sysadmfile, home_dir_type, home_type;
#line 4694
type sysadm_home_t, file_type, sysadmfile, home_type;
#line 4694

#line 4694
type sysadm_tmp_t, file_type, sysadmfile, tmpfile ;
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
#
#line 4694
# Allow the process to modify the directory.
#line 4694
#
#line 4694
allow sysadm_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4694

#line 4694
#
#line 4694
# Allow the process to create the file.
#line 4694
#
#line 4694

#line 4694
allow sysadm_t sysadm_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4694
allow sysadm_t sysadm_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4694

#line 4694

#line 4694
type_transition sysadm_t tmp_t:dir sysadm_tmp_t;
#line 4694
type_transition sysadm_t tmp_t:{ file lnk_file sock_file fifo_file } sysadm_tmp_t;
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
# allow ptrace
#line 4694
#can_ptrace(sysadm_t, sysadm_t)
#line 4694

#line 4694
# Create, access, and remove files in home directory.
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
#
#line 4694
# Allow the process to modify the directory.
#line 4694
#
#line 4694
allow sysadm_t sysadm_home_dir_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4694

#line 4694
#
#line 4694
# Allow the process to create the file.
#line 4694
#
#line 4694

#line 4694
allow sysadm_t sysadm_home_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4694
allow sysadm_t sysadm_home_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4694

#line 4694

#line 4694
type_transition sysadm_t sysadm_home_dir_t:dir sysadm_home_t;
#line 4694
type_transition sysadm_t sysadm_home_dir_t:{ file lnk_file sock_file fifo_file } sysadm_home_t;
#line 4694

#line 4694

#line 4694
allow sysadm_t sysadm_home_t:{ dir file lnk_file sock_file fifo_file chr_file blk_file } { relabelfrom relabelto };
#line 4694

#line 4694
# Bind to a Unix domain socket in /tmp.
#line 4694
allow sysadm_t sysadm_tmp_t:unix_stream_socket name_bind;
#line 4694

#line 4694
# Type for tty devices.
#line 4694
type sysadm_tty_device_t, file_type, sysadmfile, ttyfile;
#line 4694
# Access ttys.
#line 4694
allow sysadm_t privfd:fd use;
#line 4694
allow sysadm_t sysadm_tty_device_t:chr_file { setattr { ioctl read getattr lock write append } };
#line 4694
# Use the type when relabeling terminal devices.
#line 4694
type_change sysadm_t tty_device_t:chr_file sysadm_tty_device_t;
#line 4694

#line 4694
# read localization information
#line 4694

#line 4694
allow sysadm_t etc_t:lnk_file read;
#line 4694

#line 4694
allow sysadm_t locale_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
# Type and access for pty devices.
#line 4694

#line 4694

#line 4694

#line 4694
# Access the pty master multiplexer.
#line 4694
allow sysadm_t ptmx_t:chr_file { ioctl read getattr lock write append };
#line 4694

#line 4694

#line 4694
allow sysadm_t devpts_t:filesystem getattr;
#line 4694

#line 4694
# allow searching /dev/pts
#line 4694
allow sysadm_t devpts_t:dir { getattr read search };
#line 4694

#line 4694

#line 4694
type sysadm_devpts_t, file_type, sysadmfile, ptyfile ;
#line 4694

#line 4694
# Allow the pty to be associated with the file system.
#line 4694
allow sysadm_devpts_t devpts_t:filesystem associate;
#line 4694

#line 4694
# Label pty files with a derived type.
#line 4694
type_transition sysadm_t devpts_t:chr_file sysadm_devpts_t;
#line 4694

#line 4694
# Read and write my pty files.
#line 4694
allow sysadm_t sysadm_devpts_t:chr_file { setattr { ioctl read getattr lock write append } };
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
# Use the type when relabeling pty devices.
#line 4694
type_change sysadm_t server_pty:chr_file sysadm_devpts_t;
#line 4694

#line 4694

#line 4694
# Connect to sshd.
#line 4694

#line 4694
allow sysadm_t sshd_t:tcp_socket { connectto recvfrom };
#line 4694
allow sshd_t sysadm_t:tcp_socket { acceptfrom recvfrom };
#line 4694
allow sshd_t tcp_socket_t:tcp_socket { recvfrom };
#line 4694
allow sysadm_t tcp_socket_t:tcp_socket { recvfrom };
#line 4694

#line 4694

#line 4694
# Connect to ssh proxy.
#line 4694

#line 4694
allow sysadm_t sysadm_ssh_t:tcp_socket { connectto recvfrom };
#line 4694
allow sysadm_ssh_t sysadm_t:tcp_socket { acceptfrom recvfrom };
#line 4694
allow sysadm_ssh_t tcp_socket_t:tcp_socket { recvfrom };
#line 4694
allow sysadm_t tcp_socket_t:tcp_socket { recvfrom };
#line 4694

#line 4694

#line 4694
allow sysadm_t sshd_t:fd use;
#line 4694
allow sysadm_t sshd_t:tcp_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4694
# inheriting stream sockets is needed for "ssh host command"
#line 4694
allow sysadm_t sshd_t:unix_stream_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4694

#line 4694
# for ifconfig which is run all the time
#line 4694
dontaudit sysadm_t sysctl_t:dir search;
#line 4694

#line 4694
allow sysadm_t boot_t:dir { getattr search };
#line 4694
dontaudit sysadm_t boot_t:dir read;
#line 4694
dontaudit sysadm_t boot_t:lnk_file getattr;
#line 4694
dontaudit sysadm_t boot_t:file { getattr read };
#line 4694
allow sysadm_t system_map_t:file { getattr read };
#line 4694

#line 4694

#line 4694
type sysadm_tmpfs_t, file_type, sysadmfile, tmpfsfile;
#line 4694
# Use this type when creating tmpfs/shm objects.
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
#
#line 4694
# Allow the process to modify the directory.
#line 4694
#
#line 4694
allow sysadm_t tmpfs_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4694

#line 4694
#
#line 4694
# Allow the process to create the file.
#line 4694
#
#line 4694

#line 4694
allow sysadm_t sysadm_tmpfs_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4694
allow sysadm_t sysadm_tmpfs_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4694

#line 4694

#line 4694
type_transition sysadm_t tmpfs_t:dir sysadm_tmpfs_t;
#line 4694
type_transition sysadm_t tmpfs_t:{ file lnk_file sock_file fifo_file } sysadm_tmpfs_t;
#line 4694

#line 4694

#line 4694
allow sysadm_tmpfs_t tmpfs_t:filesystem associate;
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
# Read and write /var/catman.
#line 4694
allow sysadm_t catman_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4694
allow sysadm_t catman_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4694

#line 4694
# Modify mail spool file.
#line 4694
allow sysadm_t mail_spool_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_t mail_spool_t:file { ioctl read getattr lock write append };
#line 4694
allow sysadm_t mail_spool_t:lnk_file read;
#line 4694

#line 4694
#
#line 4694
# Allow the query of filesystem quotas
#line 4694
#
#line 4694
allow sysadm_t fs_type:filesystem quotaget;
#line 4694

#line 4694
# Run helper programs.
#line 4694

#line 4694
allow sysadm_t { bin_t sbin_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_t { bin_t sbin_t etc_t }:lnk_file { getattr read };
#line 4694

#line 4694
allow sysadm_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_t lib_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_t ld_so_t:file { read getattr lock execute ioctl };
#line 4694
allow sysadm_t ld_so_t:file execute_no_trans;
#line 4694
allow sysadm_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_t shlib_t:file { read getattr lock execute ioctl };
#line 4694
allow sysadm_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4694
allow sysadm_t device_t:dir search;
#line 4694
allow sysadm_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4694

#line 4694

#line 4694
allow sysadm_t etc_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694
allow sysadm_t lib_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694
allow sysadm_t bin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694
allow sysadm_t sbin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694
allow sysadm_t exec_type:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694
# Run programs developed by other users in the same domain.
#line 4694

#line 4694
allow sysadm_t sysadm_home_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694
allow sysadm_t sysadm_tmp_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694
# Run user programs that require different permissions in their own domain.
#line 4694
# These rules were moved into the individual program domains.
#line 4694

#line 4694
# Instantiate derived domains for a number of programs.
#line 4694
# These derived domains encode both information about the calling
#line 4694
# user domain and the program, and allow us to maintain separation
#line 4694
# between different instances of the program being run by different
#line 4694
# user domains.
#line 4694

#line 4694

#line 4694

#line 4694
# Derived domain based on the calling user domain and the program.
#line 4694
type sysadm_su_t, domain, privlog, auth;
#line 4694

#line 4694
# Transition from the user domain to this domain.
#line 4694

#line 4694

#line 4694

#line 4694
#
#line 4694
# Allow the process to transition to the new domain.
#line 4694
#
#line 4694
allow sysadm_t sysadm_su_t:process transition;
#line 4694

#line 4694
#
#line 4694
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4694
#
#line 4694
dontaudit sysadm_t sysadm_su_t:process noatsecure;
#line 4694

#line 4694
#
#line 4694
# Allow the process to execute the program.
#line 4694
# 
#line 4694
allow sysadm_t su_exec_t:file { read { getattr execute } };
#line 4694

#line 4694
#
#line 4694
# Allow the process to reap the new domain.
#line 4694
#
#line 4694
allow sysadm_su_t sysadm_t:process sigchld;
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to inherit and use file 
#line 4694
# descriptions from the creating process and vice versa.
#line 4694
#
#line 4694
allow sysadm_su_t sysadm_t:fd use;
#line 4694
allow sysadm_t sysadm_su_t:fd use;
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to write back to the old domain via a pipe.
#line 4694
#
#line 4694
allow sysadm_su_t sysadm_t:fifo_file { ioctl read getattr lock write append };
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to read and execute the program.
#line 4694
#
#line 4694
allow sysadm_su_t su_exec_t:file { read getattr lock execute ioctl };
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to be entered via the program.
#line 4694
#
#line 4694
allow sysadm_su_t su_exec_t:file entrypoint;
#line 4694

#line 4694
type_transition sysadm_t su_exec_t:process sysadm_su_t;
#line 4694

#line 4694

#line 4694

#line 4694
allow sysadm_su_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_su_t lib_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_su_t ld_so_t:file { read getattr lock execute ioctl };
#line 4694
allow sysadm_su_t ld_so_t:file execute_no_trans;
#line 4694
allow sysadm_su_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_su_t shlib_t:file { read getattr lock execute ioctl };
#line 4694
allow sysadm_su_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_su_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4694
allow sysadm_su_t device_t:dir search;
#line 4694
allow sysadm_su_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4694

#line 4694
allow sysadm_su_t etc_t:file { getattr read };
#line 4694

#line 4694
allow sysadm_su_t etc_t:lnk_file read;
#line 4694

#line 4694
allow sysadm_su_t locale_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_su_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 4694

#line 4694

#line 4694
allow sysadm_su_t self:unix_dgram_socket { connect create write };
#line 4694
allow sysadm_su_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4694
allow sysadm_su_t proc_t:dir search;
#line 4694
allow sysadm_su_t proc_t:lnk_file read;
#line 4694

#line 4694
allow sysadm_su_t self:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_su_t self:{ file lnk_file } { read getattr lock ioctl };
#line 4694

#line 4694
allow sysadm_su_t self:process setsched;
#line 4694
allow sysadm_su_t device_t:dir search;
#line 4694
allow sysadm_su_t self:process { fork sigchld };
#line 4694

#line 4694
# Use capabilities.
#line 4694
allow sysadm_su_t self:capability { setuid setgid net_bind_service chown dac_override sys_nice sys_resource };
#line 4694

#line 4694
# Revert to the user domain when a shell is executed.
#line 4694

#line 4694

#line 4694

#line 4694
#
#line 4694
# Allow the process to transition to the new domain.
#line 4694
#
#line 4694
allow sysadm_su_t sysadm_t:process transition;
#line 4694

#line 4694
#
#line 4694
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4694
#
#line 4694
dontaudit sysadm_su_t sysadm_t:process noatsecure;
#line 4694

#line 4694
#
#line 4694
# Allow the process to execute the program.
#line 4694
# 
#line 4694
allow sysadm_su_t shell_exec_t:file { read { getattr execute } };
#line 4694

#line 4694
#
#line 4694
# Allow the process to reap the new domain.
#line 4694
#
#line 4694
allow sysadm_t sysadm_su_t:process sigchld;
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to inherit and use file 
#line 4694
# descriptions from the creating process and vice versa.
#line 4694
#
#line 4694
allow sysadm_t sysadm_su_t:fd use;
#line 4694
allow sysadm_su_t sysadm_t:fd use;
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to write back to the old domain via a pipe.
#line 4694
#
#line 4694
allow sysadm_t sysadm_su_t:fifo_file { ioctl read getattr lock write append };
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to read and execute the program.
#line 4694
#
#line 4694
allow sysadm_t shell_exec_t:file { read getattr lock execute ioctl };
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to be entered via the program.
#line 4694
#
#line 4694
allow sysadm_t shell_exec_t:file entrypoint;
#line 4694

#line 4694
type_transition sysadm_su_t shell_exec_t:process sysadm_t;
#line 4694

#line 4694
allow sysadm_su_t bin_t:dir search;
#line 4694
allow sysadm_su_t bin_t:lnk_file read;
#line 4694

#line 4694
allow sysadm_su_t privfd:fd use;
#line 4694

#line 4694
# Write to utmp.
#line 4694
allow sysadm_su_t { var_t var_run_t }:dir search;
#line 4694
allow sysadm_su_t initrc_var_run_t:file { ioctl read getattr lock write append };
#line 4694

#line 4694

#line 4694

#line 4694
# Run chkpwd.
#line 4694

#line 4694
allow sysadm_su_t chkpwd_exec_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694

#line 4694
# Inherit and use descriptors from gnome-pty-helper.
#line 4694

#line 4694

#line 4694
# The user role is authorized for this domain.
#line 4694
role sysadm_r types sysadm_su_t;
#line 4694

#line 4694
# Write to the user domain tty.
#line 4694
allow sysadm_su_t sysadm_tty_device_t:chr_file { ioctl read getattr lock write append };
#line 4694
allow sysadm_su_t sysadm_devpts_t:chr_file { ioctl read getattr lock write append };
#line 4694

#line 4694
allow sysadm_su_t { home_root_t sysadm_home_dir_t }:dir search;
#line 4694

#line 4694
# Modify .Xauthority file (via xauth program).
#line 4694

#line 4694

#line 4694
# Access sshd cookie files.
#line 4694
allow sysadm_su_t sshd_tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4694
allow sysadm_su_t sshd_tmp_t:file { ioctl read getattr lock write append };
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
#
#line 4694
# Allow the process to modify the directory.
#line 4694
#
#line 4694
allow sysadm_su_t sshd_tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4694

#line 4694
#
#line 4694
# Allow the process to create the file.
#line 4694
#
#line 4694

#line 4694
allow sysadm_su_t sysadm_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4694
allow sysadm_su_t sysadm_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4694

#line 4694

#line 4694
type_transition sysadm_su_t sshd_tmp_t:dir sysadm_tmp_t;
#line 4694
type_transition sysadm_su_t sshd_tmp_t:{ file lnk_file sock_file fifo_file } sysadm_tmp_t;
#line 4694

#line 4694

#line 4694

#line 4694
# stop su complaining if you run it from a directory with restrictive perms
#line 4694
dontaudit sysadm_su_t file_type:dir search;
#line 4694

#line 4694

#line 4694
# Derived domain based on the calling user domain and the program.
#line 4694
type sysadm_chkpwd_t, domain, privlog, auth;
#line 4694

#line 4694
# Transition from the user domain to this domain.
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
#
#line 4694
# Allow the process to transition to the new domain.
#line 4694
#
#line 4694
allow sysadm_t sysadm_chkpwd_t:process transition;
#line 4694

#line 4694
#
#line 4694
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4694
#
#line 4694
dontaudit sysadm_t sysadm_chkpwd_t:process noatsecure;
#line 4694

#line 4694
#
#line 4694
# Allow the process to execute the program.
#line 4694
# 
#line 4694
allow sysadm_t chkpwd_exec_t:file { read { getattr execute } };
#line 4694

#line 4694
#
#line 4694
# Allow the process to reap the new domain.
#line 4694
#
#line 4694
allow sysadm_chkpwd_t sysadm_t:process sigchld;
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to inherit and use file 
#line 4694
# descriptions from the creating process and vice versa.
#line 4694
#
#line 4694
allow sysadm_chkpwd_t sysadm_t:fd use;
#line 4694
allow sysadm_t sysadm_chkpwd_t:fd use;
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to write back to the old domain via a pipe.
#line 4694
#
#line 4694
allow sysadm_chkpwd_t sysadm_t:fifo_file { ioctl read getattr lock write append };
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to read and execute the program.
#line 4694
#
#line 4694
allow sysadm_chkpwd_t chkpwd_exec_t:file { read getattr lock execute ioctl };
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to be entered via the program.
#line 4694
#
#line 4694
allow sysadm_chkpwd_t chkpwd_exec_t:file entrypoint;
#line 4694

#line 4694
type_transition sysadm_t chkpwd_exec_t:process sysadm_chkpwd_t;
#line 4694

#line 4694

#line 4694
# The user role is authorized for this domain.
#line 4694
role sysadm_r types sysadm_chkpwd_t;
#line 4694

#line 4694
# Write to the user domain tty.
#line 4694
allow sysadm_chkpwd_t sysadm_tty_device_t:chr_file { ioctl read getattr lock write append };
#line 4694
allow sysadm_chkpwd_t sysadm_devpts_t:chr_file { ioctl read getattr lock write append };
#line 4694

#line 4694
# Inherit and use descriptors from gnome-pty-helper.
#line 4694

#line 4694

#line 4694
# Inherit and use descriptors from newrole.
#line 4694
allow sysadm_chkpwd_t newrole_t:fd use;
#line 4694

#line 4694

#line 4694

#line 4694
allow sysadm_chkpwd_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_chkpwd_t lib_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_chkpwd_t ld_so_t:file { read getattr lock execute ioctl };
#line 4694
allow sysadm_chkpwd_t ld_so_t:file execute_no_trans;
#line 4694
allow sysadm_chkpwd_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_chkpwd_t shlib_t:file { read getattr lock execute ioctl };
#line 4694
allow sysadm_chkpwd_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_chkpwd_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4694
allow sysadm_chkpwd_t device_t:dir search;
#line 4694
allow sysadm_chkpwd_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4694

#line 4694
allow sysadm_chkpwd_t etc_t:file { getattr read };
#line 4694
allow sysadm_chkpwd_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4694
allow sysadm_chkpwd_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4694

#line 4694
allow sysadm_chkpwd_t etc_t:lnk_file read;
#line 4694

#line 4694
allow sysadm_chkpwd_t locale_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_chkpwd_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 4694

#line 4694

#line 4694

#line 4694
# Use capabilities.
#line 4694
allow sysadm_chkpwd_t self:capability setuid;
#line 4694

#line 4694
# for nscd
#line 4694
dontaudit sysadm_chkpwd_t var_t:dir search;
#line 4694

#line 4694
dontaudit sysadm_chkpwd_t fs_t:filesystem getattr;
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694

#line 4694

#line 4694

#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
# Derived domain based on the calling user domain and the program.
#line 4694
type sysadm_crontab_t, domain, privlog;
#line 4694

#line 4694
# Transition from the user domain to the derived domain.
#line 4694

#line 4694

#line 4694

#line 4694
#
#line 4694
# Allow the process to transition to the new domain.
#line 4694
#
#line 4694
allow sysadm_t sysadm_crontab_t:process transition;
#line 4694

#line 4694
#
#line 4694
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4694
#
#line 4694
dontaudit sysadm_t sysadm_crontab_t:process noatsecure;
#line 4694

#line 4694
#
#line 4694
# Allow the process to execute the program.
#line 4694
# 
#line 4694
allow sysadm_t crontab_exec_t:file { read { getattr execute } };
#line 4694

#line 4694
#
#line 4694
# Allow the process to reap the new domain.
#line 4694
#
#line 4694
allow sysadm_crontab_t sysadm_t:process sigchld;
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to inherit and use file 
#line 4694
# descriptions from the creating process and vice versa.
#line 4694
#
#line 4694
allow sysadm_crontab_t sysadm_t:fd use;
#line 4694
allow sysadm_t sysadm_crontab_t:fd use;
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to write back to the old domain via a pipe.
#line 4694
#
#line 4694
allow sysadm_crontab_t sysadm_t:fifo_file { ioctl read getattr lock write append };
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to read and execute the program.
#line 4694
#
#line 4694
allow sysadm_crontab_t crontab_exec_t:file { read getattr lock execute ioctl };
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to be entered via the program.
#line 4694
#
#line 4694
allow sysadm_crontab_t crontab_exec_t:file entrypoint;
#line 4694

#line 4694
type_transition sysadm_t crontab_exec_t:process sysadm_crontab_t;
#line 4694

#line 4694

#line 4694
# The user role is authorized for this domain.
#line 4694
role sysadm_r types sysadm_crontab_t;
#line 4694

#line 4694

#line 4694
allow sysadm_crontab_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_crontab_t lib_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_crontab_t ld_so_t:file { read getattr lock execute ioctl };
#line 4694
allow sysadm_crontab_t ld_so_t:file execute_no_trans;
#line 4694
allow sysadm_crontab_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_crontab_t shlib_t:file { read getattr lock execute ioctl };
#line 4694
allow sysadm_crontab_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_crontab_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4694
allow sysadm_crontab_t device_t:dir search;
#line 4694
allow sysadm_crontab_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4694

#line 4694
allow sysadm_crontab_t etc_t:file { getattr read };
#line 4694
allow sysadm_crontab_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4694
allow sysadm_crontab_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4694

#line 4694
allow sysadm_crontab_t etc_t:lnk_file read;
#line 4694

#line 4694
allow sysadm_crontab_t locale_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_crontab_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 4694

#line 4694

#line 4694

#line 4694
# Use capabilities dac_override is to create the file in the directory
#line 4694
# under /tmp
#line 4694
allow sysadm_crontab_t sysadm_crontab_t:capability { setuid setgid chown dac_override };
#line 4694

#line 4694
# Type for temporary files.
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
#
#line 4694
# Allow the process to modify the directory.
#line 4694
#
#line 4694
allow sysadm_crontab_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4694

#line 4694
#
#line 4694
# Allow the process to create the file.
#line 4694
#
#line 4694

#line 4694

#line 4694
allow sysadm_crontab_t sysadm_tmp_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 4694

#line 4694

#line 4694
type_transition sysadm_crontab_t tmp_t:file sysadm_tmp_t;
#line 4694

#line 4694

#line 4694

#line 4694
# Type of user crontabs once moved to cron spool.
#line 4694
type sysadm_cron_spool_t, file_type, sysadmfile;
#line 4694
# Use the type when creating files in /var/spool/cron.
#line 4694
allow sysadm_crontab_t sysadm_cron_spool_t:file { getattr read };
#line 4694
allow sysadm_crontab_t { var_t var_spool_t }:dir search;
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
#
#line 4694
# Allow the process to modify the directory.
#line 4694
#
#line 4694
allow sysadm_crontab_t cron_spool_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4694

#line 4694
#
#line 4694
# Allow the process to create the file.
#line 4694
#
#line 4694

#line 4694

#line 4694
allow sysadm_crontab_t sysadm_cron_spool_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 4694

#line 4694

#line 4694
type_transition sysadm_crontab_t cron_spool_t:file sysadm_cron_spool_t;
#line 4694

#line 4694

#line 4694
allow sysadm_crontab_t self:process { fork { sigchld sigkill sigstop signull signal } };
#line 4694

#line 4694
# crontab signals crond by updating the mtime on the spooldir
#line 4694
allow sysadm_crontab_t cron_spool_t:dir setattr;
#line 4694
# Allow crond to read those crontabs in cron spool.
#line 4694
allow crond_t sysadm_cron_spool_t:file { read getattr lock ioctl };
#line 4694

#line 4694
# Run helper programs as sysadm_t
#line 4694
allow sysadm_crontab_t { bin_t sbin_t }:dir search;
#line 4694
allow sysadm_crontab_t bin_t:lnk_file read;
#line 4694

#line 4694

#line 4694

#line 4694
#
#line 4694
# Allow the process to transition to the new domain.
#line 4694
#
#line 4694
allow sysadm_crontab_t sysadm_t:process transition;
#line 4694

#line 4694
#
#line 4694
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4694
#
#line 4694
dontaudit sysadm_crontab_t sysadm_t:process noatsecure;
#line 4694

#line 4694
#
#line 4694
# Allow the process to execute the program.
#line 4694
# 
#line 4694
allow sysadm_crontab_t { bin_t sbin_t shell_exec_t }:file { read { getattr execute } };
#line 4694

#line 4694
#
#line 4694
# Allow the process to reap the new domain.
#line 4694
#
#line 4694
allow sysadm_t sysadm_crontab_t:process sigchld;
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to inherit and use file 
#line 4694
# descriptions from the creating process and vice versa.
#line 4694
#
#line 4694
allow sysadm_t sysadm_crontab_t:fd use;
#line 4694
allow sysadm_crontab_t sysadm_t:fd use;
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to write back to the old domain via a pipe.
#line 4694
#
#line 4694
allow sysadm_t sysadm_crontab_t:fifo_file { ioctl read getattr lock write append };
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to read and execute the program.
#line 4694
#
#line 4694
allow sysadm_t { bin_t sbin_t shell_exec_t }:file { read getattr lock execute ioctl };
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to be entered via the program.
#line 4694
#
#line 4694
allow sysadm_t { bin_t sbin_t shell_exec_t }:file entrypoint;
#line 4694

#line 4694
type_transition sysadm_crontab_t { bin_t sbin_t shell_exec_t }:process sysadm_t;
#line 4694

#line 4694

#line 4694
# Read user crontabs 
#line 4694
allow sysadm_crontab_t { sysadm_home_t sysadm_home_dir_t }:dir { read getattr lock search ioctl };  
#line 4694
allow sysadm_crontab_t sysadm_home_t:file { read getattr lock ioctl };  
#line 4694
dontaudit sysadm_crontab_t sysadm_home_dir_t:dir write;
#line 4694

#line 4694
# Access the cron log file.
#line 4694
allow sysadm_crontab_t crond_log_t:file { read getattr lock ioctl };
#line 4694
allow sysadm_crontab_t crond_log_t:file { append };
#line 4694

#line 4694
# Access terminals.
#line 4694
allow sysadm_crontab_t device_t:dir search;
#line 4694
allow sysadm_crontab_t sysadm_tty_device_t:chr_file { ioctl read getattr lock write append };
#line 4694
allow sysadm_crontab_t sysadm_devpts_t:chr_file { ioctl read getattr lock write append };
#line 4694

#line 4694
allow sysadm_crontab_t fs_t:filesystem getattr;
#line 4694

#line 4694
# Inherit and use descriptors from gnome-pty-helper.
#line 4694

#line 4694
allow sysadm_crontab_t privfd:fd use;
#line 4694

#line 4694
dontaudit sysadm_crontab_t var_run_t:dir search;
#line 4694

#line 4694

#line 4694
# Derived domain based on the calling user domain and the program.
#line 4694
type sysadm_ssh_t, domain, privlog;
#line 4694

#line 4694
# Transition from the user domain to the derived domain.
#line 4694

#line 4694

#line 4694

#line 4694
#
#line 4694
# Allow the process to transition to the new domain.
#line 4694
#
#line 4694
allow sysadm_t sysadm_ssh_t:process transition;
#line 4694

#line 4694
#
#line 4694
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4694
#
#line 4694
dontaudit sysadm_t sysadm_ssh_t:process noatsecure;
#line 4694

#line 4694
#
#line 4694
# Allow the process to execute the program.
#line 4694
# 
#line 4694
allow sysadm_t ssh_exec_t:file { read { getattr execute } };
#line 4694

#line 4694
#
#line 4694
# Allow the process to reap the new domain.
#line 4694
#
#line 4694
allow sysadm_ssh_t sysadm_t:process sigchld;
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to inherit and use file 
#line 4694
# descriptions from the creating process and vice versa.
#line 4694
#
#line 4694
allow sysadm_ssh_t sysadm_t:fd use;
#line 4694
allow sysadm_t sysadm_ssh_t:fd use;
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to write back to the old domain via a pipe.
#line 4694
#
#line 4694
allow sysadm_ssh_t sysadm_t:fifo_file { ioctl read getattr lock write append };
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to read and execute the program.
#line 4694
#
#line 4694
allow sysadm_ssh_t ssh_exec_t:file { read getattr lock execute ioctl };
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to be entered via the program.
#line 4694
#
#line 4694
allow sysadm_ssh_t ssh_exec_t:file entrypoint;
#line 4694

#line 4694
type_transition sysadm_t ssh_exec_t:process sysadm_ssh_t;
#line 4694

#line 4694

#line 4694
# The user role is authorized for this domain.
#line 4694
role sysadm_r types sysadm_ssh_t;
#line 4694

#line 4694
# Grant permissions within the domain.
#line 4694

#line 4694
# Access other processes in the same domain.
#line 4694
# Omits ptrace, setexec, and setfscreate.  These must be granted 
#line 4694
# separately if desired.
#line 4694
allow sysadm_ssh_t self:process ~{ptrace setexec setfscreate};
#line 4694

#line 4694
# Access /proc/PID files for processes in the same domain.
#line 4694
allow sysadm_ssh_t self:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_ssh_t self:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4694

#line 4694
# Access file descriptions, pipes, and sockets
#line 4694
# created by processes in the same domain.
#line 4694
allow sysadm_ssh_t self:fd *;
#line 4694
allow sysadm_ssh_t self:fifo_file { ioctl read getattr lock write append };
#line 4694
allow sysadm_ssh_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4694
allow sysadm_ssh_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4694

#line 4694
# Allow the domain to communicate with other processes in the same domain.
#line 4694
allow sysadm_ssh_t self:unix_dgram_socket sendto;
#line 4694
allow sysadm_ssh_t self:unix_stream_socket connectto;
#line 4694

#line 4694
# Access System V IPC objects created by processes in the same domain.
#line 4694
allow sysadm_ssh_t self:sem  { associate getattr setattr create destroy read write unix_read unix_write };
#line 4694
allow sysadm_ssh_t self:msg  { send receive };
#line 4694
allow sysadm_ssh_t self:msgq { associate getattr setattr create destroy read write enqueue unix_read unix_write };
#line 4694
allow sysadm_ssh_t self:shm  { associate getattr setattr create destroy read write lock unix_read unix_write };
#line 4694

#line 4694

#line 4694
# Use descriptors created by sshd
#line 4694
allow sysadm_ssh_t privfd:fd use;
#line 4694

#line 4694

#line 4694
allow sysadm_ssh_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_ssh_t lib_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_ssh_t ld_so_t:file { read getattr lock execute ioctl };
#line 4694
allow sysadm_ssh_t ld_so_t:file execute_no_trans;
#line 4694
allow sysadm_ssh_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_ssh_t shlib_t:file { read getattr lock execute ioctl };
#line 4694
allow sysadm_ssh_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_ssh_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4694
allow sysadm_ssh_t device_t:dir search;
#line 4694
allow sysadm_ssh_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4694

#line 4694

#line 4694
allow sysadm_ssh_t etc_t:lnk_file read;
#line 4694

#line 4694
allow sysadm_ssh_t locale_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_ssh_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 4694

#line 4694

#line 4694

#line 4694
# Get attributes of file systems.
#line 4694
allow sysadm_ssh_t fs_type:filesystem getattr;
#line 4694

#line 4694

#line 4694
# Read /.
#line 4694
allow sysadm_ssh_t root_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_ssh_t root_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4694

#line 4694
# Read /home.
#line 4694
allow sysadm_ssh_t home_root_t:dir { read getattr lock search ioctl };
#line 4694

#line 4694
# Read /usr.
#line 4694
allow sysadm_ssh_t usr_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_ssh_t usr_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4694

#line 4694
# Read bin and sbin directories.
#line 4694
allow sysadm_ssh_t bin_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_ssh_t bin_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4694
allow sysadm_ssh_t sbin_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_ssh_t sbin_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4694

#line 4694

#line 4694
# Read the devpts root directory.
#line 4694
allow sysadm_ssh_t devpts_t:dir { read getattr lock search ioctl };
#line 4694

#line 4694
# Read /var.
#line 4694
allow sysadm_ssh_t var_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_ssh_t var_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4694

#line 4694
# Read /var/run, /var/log.
#line 4694
allow sysadm_ssh_t var_run_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_ssh_t var_run_t:{ file lnk_file } { read getattr lock ioctl };
#line 4694
allow sysadm_ssh_t var_log_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_ssh_t var_log_t:{ file lnk_file } { read getattr lock ioctl };
#line 4694

#line 4694
# Read /etc.
#line 4694
allow sysadm_ssh_t etc_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_ssh_t etc_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4694
allow sysadm_ssh_t etc_runtime_t:{ file lnk_file } { read getattr lock ioctl };
#line 4694
allow sysadm_ssh_t resolv_conf_t:{ file lnk_file } { read getattr lock ioctl };
#line 4694

#line 4694
# Read the linker, shared library, and executable types.
#line 4694
allow sysadm_ssh_t ld_so_t:{ file lnk_file } { read getattr lock ioctl };
#line 4694
allow sysadm_ssh_t shlib_t:{ file lnk_file } { read getattr lock ioctl };
#line 4694
allow sysadm_ssh_t exec_type:{ file lnk_file } { read getattr lock ioctl };
#line 4694

#line 4694
# Read /dev directories and any symbolic links.
#line 4694
allow sysadm_ssh_t device_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_ssh_t device_t:lnk_file { read getattr lock ioctl };
#line 4694

#line 4694
# Read /dev/random.
#line 4694
allow sysadm_ssh_t random_device_t:chr_file { read getattr lock ioctl };
#line 4694

#line 4694
# Read and write /dev/tty and /dev/null.
#line 4694
allow sysadm_ssh_t devtty_t:chr_file { ioctl read getattr lock write append };
#line 4694
allow sysadm_ssh_t { null_device_t zero_device_t }:chr_file { ioctl read getattr lock write append };
#line 4694

#line 4694
# Grant permissions needed to create TCP and UDP sockets and
#line 4694
# to access the network.
#line 4694

#line 4694
#
#line 4694
# Allow the domain to create and use UDP and TCP sockets.
#line 4694
# Other kinds of sockets must be separately authorized for use.
#line 4694
allow sysadm_ssh_t self:udp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4694
allow sysadm_ssh_t self:tcp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4694

#line 4694
#
#line 4694
# Allow the domain to send UDP packets.
#line 4694
# Since the destination sockets type is unknown, the generic
#line 4694
# any_socket_t type is used as a placeholder.
#line 4694
#
#line 4694
allow sysadm_ssh_t any_socket_t:udp_socket sendto;
#line 4694

#line 4694
#
#line 4694
# Allow the domain to send using any network interface.
#line 4694
# netif_type is a type attribute for all network interface types.
#line 4694
#
#line 4694
allow sysadm_ssh_t netif_type:netif { tcp_send udp_send rawip_send };
#line 4694

#line 4694
#
#line 4694
# Allow packets sent by the domain to be received on any network interface.
#line 4694
#
#line 4694
allow sysadm_ssh_t netif_type:netif { tcp_recv udp_recv rawip_recv };
#line 4694

#line 4694
#
#line 4694
# Allow the domain to receive packets from any network interface.
#line 4694
# netmsg_type is a type attribute for all default message types.
#line 4694
#
#line 4694
allow sysadm_ssh_t netmsg_type:{ udp_socket tcp_socket rawip_socket } recvfrom;
#line 4694

#line 4694
#
#line 4694
# Allow the domain to initiate or accept TCP connections 
#line 4694
# on any network interface.
#line 4694
#
#line 4694
allow sysadm_ssh_t netmsg_type:tcp_socket { connectto acceptfrom };
#line 4694

#line 4694
#
#line 4694
# Receive resets from the TCP reset socket.
#line 4694
# The TCP reset socket is labeled with the tcp_socket_t type.
#line 4694
#
#line 4694
allow sysadm_ssh_t tcp_socket_t:tcp_socket recvfrom;
#line 4694

#line 4694
dontaudit sysadm_ssh_t tcp_socket_t:tcp_socket connectto;
#line 4694

#line 4694
#
#line 4694
# Allow the domain to send to any node.
#line 4694
# node_type is a type attribute for all node types.
#line 4694
#
#line 4694
allow sysadm_ssh_t node_type:node { tcp_send udp_send rawip_send };
#line 4694

#line 4694
#
#line 4694
# Allow packets sent by the domain to be received from any node.
#line 4694
#
#line 4694
allow sysadm_ssh_t node_type:node { tcp_recv udp_recv rawip_recv };
#line 4694

#line 4694
#
#line 4694
# Allow the domain to send NFS client requests via the socket
#line 4694
# created by mount.
#line 4694
#
#line 4694
allow sysadm_ssh_t mount_t:udp_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4694

#line 4694
#
#line 4694
# Bind to the default port type.
#line 4694
# Other port types must be separately authorized.
#line 4694
#
#line 4694
#allow sysadm_ssh_t port_t:udp_socket name_bind;
#line 4694
#allow sysadm_ssh_t port_t:tcp_socket name_bind;
#line 4694

#line 4694

#line 4694
# for sshing to a ssh tunnel
#line 4694

#line 4694
allow sysadm_ssh_t sysadm_ssh_t:tcp_socket { connectto recvfrom };
#line 4694
allow sysadm_ssh_t sysadm_ssh_t:tcp_socket { acceptfrom recvfrom };
#line 4694
allow sysadm_ssh_t tcp_socket_t:tcp_socket { recvfrom };
#line 4694
allow sysadm_ssh_t tcp_socket_t:tcp_socket { recvfrom };
#line 4694

#line 4694

#line 4694
# Use capabilities.
#line 4694
allow sysadm_ssh_t self:capability { setuid setgid dac_override dac_read_search };
#line 4694

#line 4694
# Run helpers.
#line 4694

#line 4694
allow sysadm_ssh_t { bin_t sbin_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_ssh_t { bin_t sbin_t etc_t }:lnk_file { getattr read };
#line 4694

#line 4694
allow sysadm_ssh_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_ssh_t lib_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_ssh_t ld_so_t:file { read getattr lock execute ioctl };
#line 4694
allow sysadm_ssh_t ld_so_t:file execute_no_trans;
#line 4694
allow sysadm_ssh_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_ssh_t shlib_t:file { read getattr lock execute ioctl };
#line 4694
allow sysadm_ssh_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_ssh_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4694
allow sysadm_ssh_t device_t:dir search;
#line 4694
allow sysadm_ssh_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4694

#line 4694

#line 4694
allow sysadm_ssh_t etc_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694
allow sysadm_ssh_t lib_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694
allow sysadm_ssh_t bin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694
allow sysadm_ssh_t sbin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694
allow sysadm_ssh_t exec_type:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694

#line 4694
# Read the ssh key file.
#line 4694
allow sysadm_ssh_t sshd_key_t:file { read getattr lock ioctl };
#line 4694

#line 4694
# Access the ssh temporary files.
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
#
#line 4694
# Allow the process to modify the directory.
#line 4694
#
#line 4694
allow sysadm_ssh_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4694

#line 4694
#
#line 4694
# Allow the process to create the file.
#line 4694
#
#line 4694

#line 4694
allow sysadm_ssh_t sshd_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4694
allow sysadm_ssh_t sshd_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4694

#line 4694

#line 4694
type_transition sysadm_ssh_t tmp_t:dir sshd_tmp_t;
#line 4694
type_transition sysadm_ssh_t tmp_t:{ file lnk_file sock_file fifo_file } sshd_tmp_t;
#line 4694

#line 4694

#line 4694
allow sysadm_ssh_t sysadm_tmp_t:dir { read getattr lock search ioctl };
#line 4694

#line 4694
# for rsync
#line 4694
allow sysadm_ssh_t sysadm_t:unix_stream_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4694

#line 4694
# Access the users .ssh directory.
#line 4694
type sysadm_home_ssh_t, file_type, sysadmfile;
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
#
#line 4694
# Allow the process to modify the directory.
#line 4694
#
#line 4694
allow { sysadm_ssh_t sysadm_ssh_t } sysadm_home_dir_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4694

#line 4694
#
#line 4694
# Allow the process to create the file.
#line 4694
#
#line 4694

#line 4694
allow { sysadm_ssh_t sysadm_ssh_t } sysadm_home_ssh_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4694
allow { sysadm_ssh_t sysadm_ssh_t } sysadm_home_ssh_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4694

#line 4694

#line 4694
type_transition { sysadm_ssh_t sysadm_ssh_t } sysadm_home_dir_t:dir sysadm_home_ssh_t;
#line 4694
type_transition { sysadm_ssh_t sysadm_ssh_t } sysadm_home_dir_t:{ file lnk_file sock_file fifo_file } sysadm_home_ssh_t;
#line 4694

#line 4694

#line 4694
allow { sysadm_ssh_t sysadm_ssh_t } sysadm_home_ssh_t:lnk_file { getattr read };
#line 4694
dontaudit sysadm_ssh_t sysadm_home_t:dir search;
#line 4694

#line 4694
allow sshd_t sysadm_home_ssh_t:dir { read getattr lock search ioctl };
#line 4694
allow sshd_t sysadm_home_ssh_t:{ file lnk_file } { read getattr lock ioctl };
#line 4694

#line 4694

#line 4694
allow sysadm_t sysadm_home_ssh_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4694
allow sysadm_t sysadm_home_ssh_t:{ file lnk_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4694

#line 4694

#line 4694
# for /bin/sh used to execute xauth
#line 4694
dontaudit sysadm_ssh_t proc_t:dir search;
#line 4694

#line 4694
# Inherit and use descriptors from gnome-pty-helper.
#line 4694

#line 4694

#line 4694
# Connect to sshd.
#line 4694

#line 4694

#line 4694
allow sysadm_ssh_t sshd_t:tcp_socket { connectto recvfrom };
#line 4694
allow sshd_t sysadm_ssh_t:tcp_socket { acceptfrom recvfrom };
#line 4694
allow sshd_t tcp_socket_t:tcp_socket { recvfrom };
#line 4694
allow sysadm_ssh_t tcp_socket_t:tcp_socket { recvfrom };
#line 4694

#line 4694

#line 4694

#line 4694
# Write to the user domain tty.
#line 4694
allow sysadm_ssh_t sysadm_tty_device_t:chr_file { ioctl read getattr lock write append };
#line 4694
allow sysadm_ssh_t sysadm_devpts_t:chr_file { ioctl read getattr lock write append };
#line 4694

#line 4694
# Allow the user shell to signal the ssh program.
#line 4694
allow sysadm_t sysadm_ssh_t:process signal;
#line 4694
# allow ps to show ssh
#line 4694
allow sysadm_t sysadm_ssh_t:dir { search getattr read };
#line 4694
allow sysadm_t sysadm_ssh_t:{ file lnk_file } { read getattr };
#line 4694

#line 4694
# Allow the ssh program to communicate with ssh-agent.
#line 4694
allow sysadm_ssh_t sysadm_tmp_t:sock_file write;
#line 4694
allow sysadm_ssh_t sysadm_t:unix_stream_socket connectto;
#line 4694
allow sysadm_ssh_t sshd_t:unix_stream_socket connectto;
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694

#line 4694

#line 4694

#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
# Instantiate a derived domain for user cron jobs.
#line 4694

#line 4694
# Derived domain for user cron jobs, user user_crond_domain if not system
#line 4694

#line 4694
type sysadm_crond_t, domain, user_crond_domain;
#line 4694

#line 4694

#line 4694
# Permit a transition from the crond_t domain to this domain.
#line 4694
# The transition is requested explicitly by the modified crond 
#line 4694
# via execve_secure.  There is no way to set up an automatic
#line 4694
# transition, since crontabs are configuration files, not executables.
#line 4694

#line 4694

#line 4694
#
#line 4694
# Allow the process to transition to the new domain.
#line 4694
#
#line 4694
allow crond_t sysadm_crond_t:process transition;
#line 4694

#line 4694
#
#line 4694
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4694
#
#line 4694
dontaudit crond_t sysadm_crond_t:process noatsecure;
#line 4694

#line 4694
#
#line 4694
# Allow the process to execute the program.
#line 4694
# 
#line 4694
allow crond_t shell_exec_t:file { read { getattr execute } };
#line 4694

#line 4694
#
#line 4694
# Allow the process to reap the new domain.
#line 4694
#
#line 4694
allow sysadm_crond_t crond_t:process sigchld;
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to inherit and use file 
#line 4694
# descriptions from the creating process and vice versa.
#line 4694
#
#line 4694
allow sysadm_crond_t crond_t:fd use;
#line 4694
allow crond_t sysadm_crond_t:fd use;
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to write back to the old domain via a pipe.
#line 4694
#
#line 4694
allow sysadm_crond_t crond_t:fifo_file { ioctl read getattr lock write append };
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to read and execute the program.
#line 4694
#
#line 4694
allow sysadm_crond_t shell_exec_t:file { read getattr lock execute ioctl };
#line 4694

#line 4694
#
#line 4694
# Allow the new domain to be entered via the program.
#line 4694
#
#line 4694
allow sysadm_crond_t shell_exec_t:file entrypoint;
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
# The user role is authorized for this domain.
#line 4694
role sysadm_r types sysadm_crond_t;
#line 4694

#line 4694
# This domain is granted permissions common to most domains.
#line 4694

#line 4694
#
#line 4694
# Allow the domain to create and use UDP and TCP sockets.
#line 4694
# Other kinds of sockets must be separately authorized for use.
#line 4694
allow sysadm_crond_t self:udp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4694
allow sysadm_crond_t self:tcp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4694

#line 4694
#
#line 4694
# Allow the domain to send UDP packets.
#line 4694
# Since the destination sockets type is unknown, the generic
#line 4694
# any_socket_t type is used as a placeholder.
#line 4694
#
#line 4694
allow sysadm_crond_t any_socket_t:udp_socket sendto;
#line 4694

#line 4694
#
#line 4694
# Allow the domain to send using any network interface.
#line 4694
# netif_type is a type attribute for all network interface types.
#line 4694
#
#line 4694
allow sysadm_crond_t netif_type:netif { tcp_send udp_send rawip_send };
#line 4694

#line 4694
#
#line 4694
# Allow packets sent by the domain to be received on any network interface.
#line 4694
#
#line 4694
allow sysadm_crond_t netif_type:netif { tcp_recv udp_recv rawip_recv };
#line 4694

#line 4694
#
#line 4694
# Allow the domain to receive packets from any network interface.
#line 4694
# netmsg_type is a type attribute for all default message types.
#line 4694
#
#line 4694
allow sysadm_crond_t netmsg_type:{ udp_socket tcp_socket rawip_socket } recvfrom;
#line 4694

#line 4694
#
#line 4694
# Allow the domain to initiate or accept TCP connections 
#line 4694
# on any network interface.
#line 4694
#
#line 4694
allow sysadm_crond_t netmsg_type:tcp_socket { connectto acceptfrom };
#line 4694

#line 4694
#
#line 4694
# Receive resets from the TCP reset socket.
#line 4694
# The TCP reset socket is labeled with the tcp_socket_t type.
#line 4694
#
#line 4694
allow sysadm_crond_t tcp_socket_t:tcp_socket recvfrom;
#line 4694

#line 4694
dontaudit sysadm_crond_t tcp_socket_t:tcp_socket connectto;
#line 4694

#line 4694
#
#line 4694
# Allow the domain to send to any node.
#line 4694
# node_type is a type attribute for all node types.
#line 4694
#
#line 4694
allow sysadm_crond_t node_type:node { tcp_send udp_send rawip_send };
#line 4694

#line 4694
#
#line 4694
# Allow packets sent by the domain to be received from any node.
#line 4694
#
#line 4694
allow sysadm_crond_t node_type:node { tcp_recv udp_recv rawip_recv };
#line 4694

#line 4694
#
#line 4694
# Allow the domain to send NFS client requests via the socket
#line 4694
# created by mount.
#line 4694
#
#line 4694
allow sysadm_crond_t mount_t:udp_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4694

#line 4694
#
#line 4694
# Bind to the default port type.
#line 4694
# Other port types must be separately authorized.
#line 4694
#
#line 4694
#allow sysadm_crond_t port_t:udp_socket name_bind;
#line 4694
#allow sysadm_crond_t port_t:tcp_socket name_bind;
#line 4694

#line 4694
allow sysadm_crond_t resolv_conf_t:file { getattr read };
#line 4694

#line 4694
allow sysadm_crond_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_crond_t lib_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_crond_t ld_so_t:file { read getattr lock execute ioctl };
#line 4694
allow sysadm_crond_t ld_so_t:file execute_no_trans;
#line 4694
allow sysadm_crond_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_crond_t shlib_t:file { read getattr lock execute ioctl };
#line 4694
allow sysadm_crond_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_crond_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4694
allow sysadm_crond_t device_t:dir search;
#line 4694
allow sysadm_crond_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4694

#line 4694

#line 4694
allow sysadm_crond_t self:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_crond_t self:{ file lnk_file } { read getattr lock ioctl };
#line 4694

#line 4694
allow sysadm_crond_t self:fifo_file { ioctl read getattr lock write append };
#line 4694
allow sysadm_crond_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4694
allow sysadm_crond_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4694
allow sysadm_crond_t etc_runtime_t:file { getattr read };
#line 4694
allow sysadm_crond_t self:process { fork { sigchld sigkill sigstop signull signal } };
#line 4694
allow sysadm_crond_t proc_t:dir { getattr search read };
#line 4694
allow sysadm_crond_t proc_t:file { getattr read };
#line 4694

#line 4694
allow sysadm_crond_t etc_t:lnk_file read;
#line 4694

#line 4694
allow sysadm_crond_t locale_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_crond_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 4694

#line 4694

#line 4694
allow sysadm_crond_t sysctl_kernel_t:dir search;
#line 4694
allow sysadm_crond_t sysctl_kernel_t:file { getattr read };
#line 4694
allow sysadm_crond_t var_spool_t:dir search;
#line 4694
allow sysadm_crond_t fs_t:filesystem getattr;
#line 4694

#line 4694
allow sysadm_crond_t devtty_t:chr_file { read write };
#line 4694

#line 4694
# Use capabilities.
#line 4694
allow sysadm_crond_t sysadm_crond_t:capability dac_override;
#line 4694

#line 4694
# Inherit and use descriptors from initrc.
#line 4694
allow sysadm_crond_t initrc_t:fd use;
#line 4694

#line 4694
# 
#line 4694
# Since crontab files are not directly executed,
#line 4694
# crond must ensure that the crontab file has
#line 4694
# a type that is appropriate for the domain of
#line 4694
# the user cron job.  It performs an entrypoint
#line 4694
# permission check for this purpose.
#line 4694
#
#line 4694
allow sysadm_crond_t sysadm_cron_spool_t:file entrypoint;
#line 4694

#line 4694
# Access user files and dirs.
#line 4694
allow sysadm_crond_t home_root_t:dir search;
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
#
#line 4694
# Allow the process to modify the directory.
#line 4694
#
#line 4694
allow sysadm_crond_t sysadm_home_dir_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4694

#line 4694
#
#line 4694
# Allow the process to create the file.
#line 4694
#
#line 4694

#line 4694
allow sysadm_crond_t sysadm_home_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4694
allow sysadm_crond_t sysadm_home_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4694

#line 4694

#line 4694
type_transition sysadm_crond_t sysadm_home_dir_t:dir sysadm_home_t;
#line 4694
type_transition sysadm_crond_t sysadm_home_dir_t:{ file lnk_file sock_file fifo_file } sysadm_home_t;
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
#
#line 4694
# Allow the process to modify the directory.
#line 4694
#
#line 4694
allow sysadm_crond_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4694

#line 4694
#
#line 4694
# Allow the process to create the file.
#line 4694
#
#line 4694

#line 4694
allow sysadm_crond_t sysadm_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4694
allow sysadm_crond_t sysadm_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4694

#line 4694

#line 4694
type_transition sysadm_crond_t tmp_t:dir sysadm_tmp_t;
#line 4694
type_transition sysadm_crond_t tmp_t:{ file lnk_file sock_file fifo_file } sysadm_tmp_t;
#line 4694

#line 4694

#line 4694

#line 4694
# Run helper programs.
#line 4694

#line 4694
allow sysadm_crond_t { bin_t sbin_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_crond_t { bin_t sbin_t etc_t }:lnk_file { getattr read };
#line 4694

#line 4694
allow sysadm_crond_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_crond_t lib_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_crond_t ld_so_t:file { read getattr lock execute ioctl };
#line 4694
allow sysadm_crond_t ld_so_t:file execute_no_trans;
#line 4694
allow sysadm_crond_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_crond_t shlib_t:file { read getattr lock execute ioctl };
#line 4694
allow sysadm_crond_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4694
allow sysadm_crond_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4694
allow sysadm_crond_t device_t:dir search;
#line 4694
allow sysadm_crond_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4694

#line 4694

#line 4694
allow sysadm_crond_t etc_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694
allow sysadm_crond_t lib_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694
allow sysadm_crond_t bin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694
allow sysadm_crond_t sbin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694
allow sysadm_crond_t exec_type:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694

#line 4694
# Run scripts in user home directory.
#line 4694

#line 4694
allow sysadm_crond_t sysadm_home_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694
# ps does not need to access /boot when run from cron
#line 4694
dontaudit sysadm_crond_t boot_t:dir search;
#line 4694
# quiet other ps operations
#line 4694
dontaudit sysadm_crond_t domain:dir getattr;
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
# Read the mouse.
#line 4694
allow sysadm_t mouse_device_t:chr_file { read getattr lock ioctl };
#line 4694
# Access other miscellaneous devices.
#line 4694
allow sysadm_t misc_device_t:{ file lnk_file sock_file fifo_file chr_file blk_file } { ioctl read getattr lock write append };
#line 4694

#line 4694
# Use the network.
#line 4694

#line 4694
#
#line 4694
# Allow the domain to create and use UDP and TCP sockets.
#line 4694
# Other kinds of sockets must be separately authorized for use.
#line 4694
allow sysadm_t self:udp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4694
allow sysadm_t self:tcp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4694

#line 4694
#
#line 4694
# Allow the domain to send UDP packets.
#line 4694
# Since the destination sockets type is unknown, the generic
#line 4694
# any_socket_t type is used as a placeholder.
#line 4694
#
#line 4694
allow sysadm_t any_socket_t:udp_socket sendto;
#line 4694

#line 4694
#
#line 4694
# Allow the domain to send using any network interface.
#line 4694
# netif_type is a type attribute for all network interface types.
#line 4694
#
#line 4694
allow sysadm_t netif_type:netif { tcp_send udp_send rawip_send };
#line 4694

#line 4694
#
#line 4694
# Allow packets sent by the domain to be received on any network interface.
#line 4694
#
#line 4694
allow sysadm_t netif_type:netif { tcp_recv udp_recv rawip_recv };
#line 4694

#line 4694
#
#line 4694
# Allow the domain to receive packets from any network interface.
#line 4694
# netmsg_type is a type attribute for all default message types.
#line 4694
#
#line 4694
allow sysadm_t netmsg_type:{ udp_socket tcp_socket rawip_socket } recvfrom;
#line 4694

#line 4694
#
#line 4694
# Allow the domain to initiate or accept TCP connections 
#line 4694
# on any network interface.
#line 4694
#
#line 4694
allow sysadm_t netmsg_type:tcp_socket { connectto acceptfrom };
#line 4694

#line 4694
#
#line 4694
# Receive resets from the TCP reset socket.
#line 4694
# The TCP reset socket is labeled with the tcp_socket_t type.
#line 4694
#
#line 4694
allow sysadm_t tcp_socket_t:tcp_socket recvfrom;
#line 4694

#line 4694
dontaudit sysadm_t tcp_socket_t:tcp_socket connectto;
#line 4694

#line 4694
#
#line 4694
# Allow the domain to send to any node.
#line 4694
# node_type is a type attribute for all node types.
#line 4694
#
#line 4694
allow sysadm_t node_type:node { tcp_send udp_send rawip_send };
#line 4694

#line 4694
#
#line 4694
# Allow packets sent by the domain to be received from any node.
#line 4694
#
#line 4694
allow sysadm_t node_type:node { tcp_recv udp_recv rawip_recv };
#line 4694

#line 4694
#
#line 4694
# Allow the domain to send NFS client requests via the socket
#line 4694
# created by mount.
#line 4694
#
#line 4694
allow sysadm_t mount_t:udp_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4694

#line 4694
#
#line 4694
# Bind to the default port type.
#line 4694
# Other port types must be separately authorized.
#line 4694
#
#line 4694
#allow sysadm_t port_t:udp_socket name_bind;
#line 4694
#allow sysadm_t port_t:tcp_socket name_bind;
#line 4694

#line 4694
# allow port_t name binding for UDP because it is not very usable otherwise
#line 4694
allow sysadm_t port_t:udp_socket name_bind;
#line 4694
allow sysadm_t resolv_conf_t:file { getattr read };
#line 4694
# for perl
#line 4694
dontaudit sysadm_t resolv_conf_t:file ioctl;
#line 4694

#line 4694
#
#line 4694
# connect_secure and sendmsg_secure calls with a 
#line 4694
# peer or destination socket SID can be enforced
#line 4694
# when using the loopback interface.  Enforcement
#line 4694
# for real network interfaces will be possible when
#line 4694
# a packet labeling mechanism is integrated.
#line 4694
#
#line 4694
allow sysadm_t node_lo_t:node enforce_dest;
#line 4694

#line 4694
# Communicate within the domain.
#line 4694

#line 4694
allow sysadm_t sysadm_t:udp_socket { sendto };
#line 4694
allow sysadm_t sysadm_t:udp_socket { recvfrom };
#line 4694

#line 4694

#line 4694
allow sysadm_t sysadm_t:tcp_socket { connectto recvfrom };
#line 4694
allow sysadm_t sysadm_t:tcp_socket { acceptfrom recvfrom };
#line 4694
allow sysadm_t tcp_socket_t:tcp_socket { recvfrom };
#line 4694
allow sysadm_t tcp_socket_t:tcp_socket { recvfrom };
#line 4694

#line 4694

#line 4694
# Connect to inetd.
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
# Connect data port to ftpd.
#line 4694

#line 4694

#line 4694
# Connect to portmap.
#line 4694

#line 4694

#line 4694
# Inherit and use sockets from inetd
#line 4694

#line 4694

#line 4694
# Allow system log read
#line 4694
#allow sysadm_t kernel_t:system syslog_read;
#line 4694
# else do not log it
#line 4694
dontaudit sysadm_t kernel_t:system syslog_read;
#line 4694

#line 4694
# Very permissive allowing every domain to see every type.
#line 4694
allow sysadm_t kernel_t:system { ipc_info };
#line 4694

#line 4694
# When the user domain runs ps, there will be a number of access
#line 4694
# denials when ps tries to search /proc.  Do not audit these denials.
#line 4694
dontaudit sysadm_t domain:dir { read getattr lock search ioctl };
#line 4694
dontaudit sysadm_t domain:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4694

#line 4694
# Some shells ask for w access to utmp, but will operate
#line 4694
# correctly without it.  Do not audit write denials to utmp.
#line 4694
dontaudit sysadm_t initrc_var_run_t:file { getattr read write };
#line 4694

#line 4694
# do not audit getattr on tmpfile, otherwise ls -l /tmp fills the logs
#line 4694
dontaudit sysadm_t tmpfile:{ dir file lnk_file sock_file fifo_file chr_file blk_file } getattr;
#line 4694

#line 4694
# do not audit getattr on disk devices, otherwise KDE fills the logs
#line 4694
dontaudit sysadm_t { removable_device_t fixed_disk_device_t }:blk_file getattr;
#line 4694

#line 4694

#line 4694
# Access the sound device.
#line 4694
allow sysadm_t sound_device_t:chr_file { getattr read write ioctl };
#line 4694

#line 4694

#line 4694

#line 4694
# Get attributes of file systems.
#line 4694
allow sysadm_t fs_type:filesystem getattr;
#line 4694

#line 4694
# Read and write /dev/tty and /dev/null.
#line 4694
allow sysadm_t devtty_t:chr_file { ioctl read getattr lock write append };
#line 4694
allow sysadm_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4694
allow sysadm_t zero_device_t:chr_file { { ioctl read getattr lock write append } execute };
#line 4694
allow sysadm_t random_device_t:chr_file { getattr read };
#line 4694

#line 4694
# Read the devpts root directory.
#line 4694
allow sysadm_t devpts_t:dir { read getattr lock search ioctl };
#line 4694

#line 4694

#line 4694
allow sysadm_t policy_config_t:dir { getattr search };
#line 4694
allow sysadm_t policy_config_t:file getattr;
#line 4694

#line 4694
# Violates the goal of limiting write access to checkpolicy.
#line 4694
#rw_dir_create_file(sysadm_t, policy_config_t)
#line 4694

#line 4694
# Let admin stat the shadow file.
#line 4694
#allow sysadm_t shadow_t:file getattr;
#line 4694

#line 4694

#line 4694
allow sysadm_crond_t var_log_t:file { read getattr lock ioctl };
#line 4694

#line 4694

#line 4694
# Allow system log read
#line 4694
allow sysadm_t kernel_t:system syslog_read;
#line 4694

#line 4694
# Use capabilities other than sys_module.
#line 4694
allow sysadm_t self:capability ~sys_module;
#line 4694

#line 4694
# Get security policy decisions.
#line 4694

#line 4694
allow sysadm_t security_t:dir { read search getattr };
#line 4694
allow sysadm_t security_t:file { getattr read write };
#line 4694
allow sysadm_t security_t:security { check_context compute_av compute_create compute_relabel compute_user };
#line 4694

#line 4694

#line 4694
# Use system operations.
#line 4694
allow sysadm_t kernel_t:system *;
#line 4694

#line 4694
# Set password information for other users.
#line 4694
allow sysadm_t self:passwd { passwd chfn chsh };
#line 4694

#line 4694
# Change system parameters.
#line 4694

#line 4694
allow sysadm_t sysctl_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_t sysctl_t:file { setattr { ioctl read getattr lock write append } };
#line 4694
allow sysadm_t sysctl_fs_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_t sysctl_fs_t:file { setattr { ioctl read getattr lock write append } };
#line 4694
allow sysadm_t sysctl_kernel_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_t sysctl_kernel_t:file { setattr { ioctl read getattr lock write append } };
#line 4694
allow sysadm_t sysctl_net_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_t sysctl_net_t:file { setattr { ioctl read getattr lock write append } };
#line 4694
allow sysadm_t sysctl_net_unix_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_t sysctl_net_unix_t:file { setattr { ioctl read getattr lock write append } };
#line 4694
allow sysadm_t sysctl_vm_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_t sysctl_vm_t:file { setattr { ioctl read getattr lock write append } };
#line 4694
allow sysadm_t sysctl_dev_t:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_t sysctl_dev_t:file { setattr { ioctl read getattr lock write append } };
#line 4694
allow sysadm_t sysctl_modprobe_t:file { setattr { ioctl read getattr lock write append } };
#line 4694

#line 4694

#line 4694
# Create and use all files that have the sysadmfile attribute.
#line 4694
allow sysadm_t sysadmfile:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4694
allow sysadm_t sysadmfile:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4694

#line 4694
# Set a context other than the default one for newly created files.
#line 4694

#line 4694
allow sysadm_t self:process setfscreate;
#line 4694
allow sysadm_t proc_t:dir search;
#line 4694
allow sysadm_t proc_t:lnk_file read;
#line 4694
allow sysadm_t self:dir search;
#line 4694
allow sysadm_t self:file { read write };
#line 4694

#line 4694

#line 4694
# Access removable devices.
#line 4694
allow sysadm_t removable_device_t:{ chr_file blk_file } { ioctl read getattr lock write append };
#line 4694

#line 4694
# Communicate with the init process.
#line 4694
allow sysadm_t initctl_t:fifo_file { ioctl read getattr lock write append };
#line 4694

#line 4694
# Examine all processes.
#line 4694
allow sysadm_t domain:dir { read getattr lock search ioctl };
#line 4694
allow sysadm_t domain:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4694
allow sysadm_t domain:process getattr;
#line 4694

#line 4694
# Send signals to all processes.
#line 4694
allow sysadm_t { domain unlabeled_t }:process { sigchld sigkill sigstop signull signal };
#line 4694

#line 4694
# Access all user terminals.
#line 4694
allow sysadm_t tty_device_t:chr_file { ioctl read getattr lock write append };
#line 4694
allow sysadm_t ttyfile:chr_file { ioctl read getattr lock write append };
#line 4694
allow sysadm_t ptyfile:chr_file { ioctl read getattr lock write append };
#line 4694

#line 4694
# allow setting up tunnels
#line 4694
allow sysadm_t tun_tap_device_t:chr_file { ioctl read getattr lock write append };
#line 4694

#line 4694
# Run init (telinit).
#line 4694

#line 4694
allow sysadm_t init_exec_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694
# Run programs from user home directories.
#line 4694
# Not ideal, but typical if users want to login as both sysadm_t or user_t.
#line 4694

#line 4694
allow sysadm_t user_home_type:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694
# Run programs from /usr/src.
#line 4694

#line 4694
allow sysadm_t src_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4694

#line 4694

#line 4694
# Run admin programs that require different permissions in their own domain.
#line 4694
# These rules were moved into the appropriate program domain file.
#line 4694

#line 4694
# added by mayerf@tresys.com
#line 4694
# The following rules are temporary until such time that a complete
#line 4694
# policy management infrastructure is in place so that an administrator
#line 4694
# cannot directly manipulate policy files with arbitrary programs.
#line 4694
#
#line 4694
allow sysadm_t policy_src_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4694
allow sysadm_t policy_src_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4694

#line 4694
# Remove the binary policy.
#line 4694
allow sysadm_t policy_config_t:file unlink;
#line 4694

#line 4694
# Relabel all files.
#line 4694
# Actually this will not allow relabeling ALL files unless you change
#line 4694
# sysadmfile to file_type (and change the assertion in assert.te that
#line 4694
# only auth_write can relabel shadow_t)
#line 4694
allow sysadm_t sysadmfile:dir { getattr read search relabelfrom relabelto };
#line 4694
allow sysadm_t sysadmfile:{ file lnk_file sock_file fifo_file chr_file blk_file } { getattr relabelfrom relabelto };
#line 4694

#line 4694
# Create files in /tmp/orbit-* and /tmp/.ICE-unix
#line 4694
# with our derived tmp type rather than user_tmp_t.
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
#
#line 4694
# Allow the process to modify the directory.
#line 4694
#
#line 4694
allow sysadm_t user_tmpfile:dir { read getattr lock search ioctl add_name remove_name write };
#line 4694

#line 4694
#
#line 4694
# Allow the process to create the file.
#line 4694
#
#line 4694

#line 4694

#line 4694
allow sysadm_t sysadm_tmp_t:sock_file { create ioctl read getattr lock write setattr append link unlink rename };
#line 4694

#line 4694

#line 4694
type_transition sysadm_t user_tmpfile:sock_file sysadm_tmp_t;
#line 4694

#line 4694

#line 4694

#line 4694

#line 4694

#line 4694
#
#line 4694
# A user who is authorized for sysadm_t may nonetheless have
#line 4694
# a home directory labeled with user_home_t if the user is expected
#line 4694
# to login in either user_t or sysadm_t.  Hence, the derived domains
#line 4694
# for programs need to be able to access user_home_t.  
#line 4694
# 
#line 4694

#line 4694
# Allow our gph domain to write to .xsession-errors.
#line 4694

#line 4694

#line 4694
# Allow our crontab domain to unlink a user cron spool file.
#line 4694
allow sysadm_crontab_t user_cron_spool_t:file unlink;
#line 4694

#line 4694
#
#line 4694
# Allow sysadm to execute quota commands against filesystems and files.
#line 4694
#
#line 4694
allow sysadm_t fs_type:filesystem quotamod;
#line 4694

#line 4694
# Grant read and write access to /dev/console.
#line 4694
allow sysadm_t console_device_t:chr_file { ioctl read getattr lock write append };
#line 4694

#line 4694
# for lsof
#line 4694
allow sysadm_t domain:{ tcp_socket udp_socket rawip_socket netlink_socket packet_socket unix_stream_socket unix_dgram_socket } getattr;
#line 4694

#line 4694

#line 4694


# Allow administrator domains to set the enforcing flag.

#line 4697
allow admin security_t:dir { read search getattr };
#line 4697
allow admin security_t:file { getattr read write };
#line 4697
allow admin security_t:security setenforce;
#line 4697
auditallow admin security_t:security setenforce;
#line 4697





#DESC Httpd admin -  Domain for httpd administrators
########################################
# httpd_admin domain macro and rules for 
# httpd_admin_t
########################################

# Uses some types defined in apache.te, so conditionally defined this macro.
# The intent is to remove this file in the future.
#
#line 4846

#DESC User - Domains for ordinary users.
#
#################################

#line 4850

#line 4850
# user_t/user_t is an unprivileged users domain.
#line 4850
type user_t, domain, userdomain, unpriv_userdomain, web_client_domain;
#line 4850

#line 4850
# user_r is authorized for user_t for the initial login domain.
#line 4850
role user_r types user_t;
#line 4850
allow system_r user_r;
#line 4850

#line 4850
# Grant permissions within the domain.
#line 4850

#line 4850
# Access other processes in the same domain.
#line 4850
# Omits ptrace, setexec, and setfscreate.  These must be granted 
#line 4850
# separately if desired.
#line 4850
allow user_t self:process ~{ptrace setexec setfscreate};
#line 4850

#line 4850
# Access /proc/PID files for processes in the same domain.
#line 4850
allow user_t self:dir { read getattr lock search ioctl };
#line 4850
allow user_t self:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4850

#line 4850
# Access file descriptions, pipes, and sockets
#line 4850
# created by processes in the same domain.
#line 4850
allow user_t self:fd *;
#line 4850
allow user_t self:fifo_file { ioctl read getattr lock write append };
#line 4850
allow user_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4850
allow user_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4850

#line 4850
# Allow the domain to communicate with other processes in the same domain.
#line 4850
allow user_t self:unix_dgram_socket sendto;
#line 4850
allow user_t self:unix_stream_socket connectto;
#line 4850

#line 4850
# Access System V IPC objects created by processes in the same domain.
#line 4850
allow user_t self:sem  { associate getattr setattr create destroy read write unix_read unix_write };
#line 4850
allow user_t self:msg  { send receive };
#line 4850
allow user_t self:msgq { associate getattr setattr create destroy read write enqueue unix_read unix_write };
#line 4850
allow user_t self:shm  { associate getattr setattr create destroy read write lock unix_read unix_write };
#line 4850
;
#line 4850

#line 4850
# Grant read/search permissions to some of /proc.
#line 4850
allow user_t proc_t:dir { read getattr lock search ioctl };
#line 4850
allow user_t proc_t:{ file lnk_file } { read getattr lock ioctl };
#line 4850

#line 4850

#line 4850
# Read /.
#line 4850
allow user_t root_t:dir { read getattr lock search ioctl };
#line 4850
allow user_t root_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4850

#line 4850
# Read /home.
#line 4850
allow user_t home_root_t:dir { read getattr lock search ioctl };
#line 4850

#line 4850
# Read /usr.
#line 4850
allow user_t usr_t:dir { read getattr lock search ioctl };
#line 4850
allow user_t usr_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4850

#line 4850
# Read bin and sbin directories.
#line 4850
allow user_t bin_t:dir { read getattr lock search ioctl };
#line 4850
allow user_t bin_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4850
allow user_t sbin_t:dir { read getattr lock search ioctl };
#line 4850
allow user_t sbin_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4850

#line 4850

#line 4850
# Read directories and files with the readable_t type.
#line 4850
# This type is a general type for "world"-readable files.
#line 4850
allow user_t readable_t:dir { read getattr lock search ioctl };
#line 4850
allow user_t readable_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4850

#line 4850
# Stat /...security and lost+found.
#line 4850
allow user_t file_labels_t:dir getattr;
#line 4850
allow user_t lost_found_t:dir getattr;
#line 4850

#line 4850
# Read the /tmp directory and any /tmp files with the base type.
#line 4850
# Temporary files created at runtime will typically use derived types.
#line 4850
allow user_t tmp_t:dir { read getattr lock search ioctl };
#line 4850
allow user_t tmp_t:{ file lnk_file } { read getattr lock ioctl };
#line 4850

#line 4850
# Read /var, /var/spool, /var/run.
#line 4850
allow user_t var_t:dir { read getattr lock search ioctl };
#line 4850
allow user_t var_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4850
allow user_t var_spool_t:dir { read getattr lock search ioctl };
#line 4850
allow user_t var_spool_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4850
allow user_t var_run_t:dir { read getattr lock search ioctl };
#line 4850
allow user_t var_run_t:{ file lnk_file } { read getattr lock ioctl };
#line 4850

#line 4850
allow user_t sysctl_kernel_t:dir search;
#line 4850
allow user_t sysctl_kernel_t:file { getattr read };
#line 4850

#line 4850
# Read /etc.
#line 4850
allow user_t etc_t:dir { read getattr lock search ioctl };
#line 4850
allow user_t etc_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4850
allow user_t etc_runtime_t:{ file lnk_file } { read getattr lock ioctl };
#line 4850

#line 4850
# for running depmod as part of the kernel packaging process
#line 4850
allow user_t modules_conf_t:file { getattr read };
#line 4850

#line 4850
# Read man directories and files.
#line 4850
allow user_t man_t:dir { read getattr lock search ioctl };
#line 4850
allow user_t man_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4850

#line 4850
# Read /dev directories and any symbolic links.
#line 4850
allow user_t device_t:dir { read getattr lock search ioctl };
#line 4850
allow user_t device_t:lnk_file { read getattr lock ioctl };
#line 4850

#line 4850
# Do not audit write denials to /etc/ld.so.cache.
#line 4850
dontaudit user_t ld_so_cache_t:file write;
#line 4850

#line 4850
# Execute from the system shared libraries.
#line 4850

#line 4850
allow user_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4850
allow user_t lib_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_t ld_so_t:file { read getattr lock execute ioctl };
#line 4850
allow user_t ld_so_t:file execute_no_trans;
#line 4850
allow user_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_t shlib_t:file { read getattr lock execute ioctl };
#line 4850
allow user_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4850
allow user_t device_t:dir search;
#line 4850
allow user_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4850
;
#line 4850

#line 4850
# user_t is also granted permissions specific to user domains.
#line 4850

#line 4850
# Use capabilities
#line 4850
allow user_t self:capability { setgid chown fowner };
#line 4850
dontaudit user_t self:capability { sys_nice fsetid };
#line 4850

#line 4850
# Type for home directory.
#line 4850

#line 4850
type user_home_dir_t, file_type, sysadmfile, home_dir_type, user_home_dir_type, home_type, user_home_type;
#line 4850
type user_home_t, file_type, sysadmfile, home_type, user_home_type;
#line 4850
# do not allow privhome access to sysadm_home_dir_t
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
#
#line 4850
# Allow the process to modify the directory.
#line 4850
#
#line 4850
allow privhome user_home_dir_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4850

#line 4850
#
#line 4850
# Allow the process to create the file.
#line 4850
#
#line 4850

#line 4850
allow privhome user_home_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4850
allow privhome user_home_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4850

#line 4850

#line 4850
type_transition privhome user_home_dir_t:dir user_home_t;
#line 4850
type_transition privhome user_home_dir_t:{ file lnk_file sock_file fifo_file } user_home_t;
#line 4850

#line 4850

#line 4850

#line 4850
type user_tmp_t, file_type, sysadmfile, tmpfile , user_tmpfile;
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
#
#line 4850
# Allow the process to modify the directory.
#line 4850
#
#line 4850
allow user_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4850

#line 4850
#
#line 4850
# Allow the process to create the file.
#line 4850
#
#line 4850

#line 4850
allow user_t user_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4850
allow user_t user_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4850

#line 4850

#line 4850
type_transition user_t tmp_t:dir user_tmp_t;
#line 4850
type_transition user_t tmp_t:{ file lnk_file sock_file fifo_file } user_tmp_t;
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
# allow ptrace
#line 4850
#can_ptrace(user_t, user_t)
#line 4850

#line 4850
# Create, access, and remove files in home directory.
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
#
#line 4850
# Allow the process to modify the directory.
#line 4850
#
#line 4850
allow user_t user_home_dir_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4850

#line 4850
#
#line 4850
# Allow the process to create the file.
#line 4850
#
#line 4850

#line 4850
allow user_t user_home_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4850
allow user_t user_home_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4850

#line 4850

#line 4850
type_transition user_t user_home_dir_t:dir user_home_t;
#line 4850
type_transition user_t user_home_dir_t:{ file lnk_file sock_file fifo_file } user_home_t;
#line 4850

#line 4850

#line 4850
allow user_t user_home_t:{ dir file lnk_file sock_file fifo_file chr_file blk_file } { relabelfrom relabelto };
#line 4850

#line 4850
# Bind to a Unix domain socket in /tmp.
#line 4850
allow user_t user_tmp_t:unix_stream_socket name_bind;
#line 4850

#line 4850
# Type for tty devices.
#line 4850
type user_tty_device_t, file_type, sysadmfile, ttyfile;
#line 4850
# Access ttys.
#line 4850
allow user_t privfd:fd use;
#line 4850
allow user_t user_tty_device_t:chr_file { setattr { ioctl read getattr lock write append } };
#line 4850
# Use the type when relabeling terminal devices.
#line 4850
type_change user_t tty_device_t:chr_file user_tty_device_t;
#line 4850

#line 4850
# read localization information
#line 4850

#line 4850
allow user_t etc_t:lnk_file read;
#line 4850

#line 4850
allow user_t locale_t:dir { read getattr lock search ioctl };
#line 4850
allow user_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
# Type and access for pty devices.
#line 4850

#line 4850

#line 4850

#line 4850
# Access the pty master multiplexer.
#line 4850
allow user_t ptmx_t:chr_file { ioctl read getattr lock write append };
#line 4850

#line 4850

#line 4850
allow user_t devpts_t:filesystem getattr;
#line 4850

#line 4850
# allow searching /dev/pts
#line 4850
allow user_t devpts_t:dir { getattr read search };
#line 4850

#line 4850

#line 4850
type user_devpts_t, file_type, sysadmfile, ptyfile , userpty_type;
#line 4850

#line 4850
# Allow the pty to be associated with the file system.
#line 4850
allow user_devpts_t devpts_t:filesystem associate;
#line 4850

#line 4850
# Label pty files with a derived type.
#line 4850
type_transition user_t devpts_t:chr_file user_devpts_t;
#line 4850

#line 4850
# Read and write my pty files.
#line 4850
allow user_t user_devpts_t:chr_file { setattr { ioctl read getattr lock write append } };
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
# Use the type when relabeling pty devices.
#line 4850
type_change user_t server_pty:chr_file user_devpts_t;
#line 4850

#line 4850

#line 4850
# Connect to sshd.
#line 4850

#line 4850
allow user_t sshd_t:tcp_socket { connectto recvfrom };
#line 4850
allow sshd_t user_t:tcp_socket { acceptfrom recvfrom };
#line 4850
allow sshd_t tcp_socket_t:tcp_socket { recvfrom };
#line 4850
allow user_t tcp_socket_t:tcp_socket { recvfrom };
#line 4850

#line 4850

#line 4850
# Connect to ssh proxy.
#line 4850

#line 4850
allow user_t user_ssh_t:tcp_socket { connectto recvfrom };
#line 4850
allow user_ssh_t user_t:tcp_socket { acceptfrom recvfrom };
#line 4850
allow user_ssh_t tcp_socket_t:tcp_socket { recvfrom };
#line 4850
allow user_t tcp_socket_t:tcp_socket { recvfrom };
#line 4850

#line 4850

#line 4850
allow user_t sshd_t:fd use;
#line 4850
allow user_t sshd_t:tcp_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4850
# inheriting stream sockets is needed for "ssh host command"
#line 4850
allow user_t sshd_t:unix_stream_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4850

#line 4850
# for ifconfig which is run all the time
#line 4850
dontaudit user_t sysctl_t:dir search;
#line 4850

#line 4850
allow user_t boot_t:dir { getattr search };
#line 4850
dontaudit user_t boot_t:dir read;
#line 4850
dontaudit user_t boot_t:lnk_file getattr;
#line 4850
dontaudit user_t boot_t:file { getattr read };
#line 4850
allow user_t system_map_t:file { getattr read };
#line 4850

#line 4850

#line 4850
type user_tmpfs_t, file_type, sysadmfile, tmpfsfile;
#line 4850
# Use this type when creating tmpfs/shm objects.
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
#
#line 4850
# Allow the process to modify the directory.
#line 4850
#
#line 4850
allow user_t tmpfs_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4850

#line 4850
#
#line 4850
# Allow the process to create the file.
#line 4850
#
#line 4850

#line 4850
allow user_t user_tmpfs_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4850
allow user_t user_tmpfs_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4850

#line 4850

#line 4850
type_transition user_t tmpfs_t:dir user_tmpfs_t;
#line 4850
type_transition user_t tmpfs_t:{ file lnk_file sock_file fifo_file } user_tmpfs_t;
#line 4850

#line 4850

#line 4850
allow user_tmpfs_t tmpfs_t:filesystem associate;
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
# Read and write /var/catman.
#line 4850
allow user_t catman_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4850
allow user_t catman_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4850

#line 4850
# Modify mail spool file.
#line 4850
allow user_t mail_spool_t:dir { read getattr lock search ioctl };
#line 4850
allow user_t mail_spool_t:file { ioctl read getattr lock write append };
#line 4850
allow user_t mail_spool_t:lnk_file read;
#line 4850

#line 4850
#
#line 4850
# Allow the query of filesystem quotas
#line 4850
#
#line 4850
allow user_t fs_type:filesystem quotaget;
#line 4850

#line 4850
# Run helper programs.
#line 4850

#line 4850
allow user_t { bin_t sbin_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4850
allow user_t { bin_t sbin_t etc_t }:lnk_file { getattr read };
#line 4850

#line 4850
allow user_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4850
allow user_t lib_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_t ld_so_t:file { read getattr lock execute ioctl };
#line 4850
allow user_t ld_so_t:file execute_no_trans;
#line 4850
allow user_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_t shlib_t:file { read getattr lock execute ioctl };
#line 4850
allow user_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4850
allow user_t device_t:dir search;
#line 4850
allow user_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4850

#line 4850

#line 4850
allow user_t etc_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4850

#line 4850

#line 4850
allow user_t lib_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4850

#line 4850

#line 4850
allow user_t bin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4850

#line 4850

#line 4850
allow user_t sbin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4850

#line 4850

#line 4850
allow user_t exec_type:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4850

#line 4850

#line 4850
# Run programs developed by other users in the same domain.
#line 4850

#line 4850
allow user_t user_home_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4850

#line 4850

#line 4850
allow user_t user_tmp_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4850

#line 4850

#line 4850
# Run user programs that require different permissions in their own domain.
#line 4850
# These rules were moved into the individual program domains.
#line 4850

#line 4850
# Instantiate derived domains for a number of programs.
#line 4850
# These derived domains encode both information about the calling
#line 4850
# user domain and the program, and allow us to maintain separation
#line 4850
# between different instances of the program being run by different
#line 4850
# user domains.
#line 4850

#line 4850

#line 4850

#line 4850
# Derived domain based on the calling user domain and the program.
#line 4850
type user_su_t, domain, privlog, auth;
#line 4850

#line 4850
# Transition from the user domain to this domain.
#line 4850

#line 4850

#line 4850

#line 4850
#
#line 4850
# Allow the process to transition to the new domain.
#line 4850
#
#line 4850
allow user_t user_su_t:process transition;
#line 4850

#line 4850
#
#line 4850
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4850
#
#line 4850
dontaudit user_t user_su_t:process noatsecure;
#line 4850

#line 4850
#
#line 4850
# Allow the process to execute the program.
#line 4850
# 
#line 4850
allow user_t su_exec_t:file { read { getattr execute } };
#line 4850

#line 4850
#
#line 4850
# Allow the process to reap the new domain.
#line 4850
#
#line 4850
allow user_su_t user_t:process sigchld;
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to inherit and use file 
#line 4850
# descriptions from the creating process and vice versa.
#line 4850
#
#line 4850
allow user_su_t user_t:fd use;
#line 4850
allow user_t user_su_t:fd use;
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to write back to the old domain via a pipe.
#line 4850
#
#line 4850
allow user_su_t user_t:fifo_file { ioctl read getattr lock write append };
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to read and execute the program.
#line 4850
#
#line 4850
allow user_su_t su_exec_t:file { read getattr lock execute ioctl };
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to be entered via the program.
#line 4850
#
#line 4850
allow user_su_t su_exec_t:file entrypoint;
#line 4850

#line 4850
type_transition user_t su_exec_t:process user_su_t;
#line 4850

#line 4850

#line 4850

#line 4850
allow user_su_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4850
allow user_su_t lib_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_su_t ld_so_t:file { read getattr lock execute ioctl };
#line 4850
allow user_su_t ld_so_t:file execute_no_trans;
#line 4850
allow user_su_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_su_t shlib_t:file { read getattr lock execute ioctl };
#line 4850
allow user_su_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_su_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4850
allow user_su_t device_t:dir search;
#line 4850
allow user_su_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4850

#line 4850
allow user_su_t etc_t:file { getattr read };
#line 4850

#line 4850
allow user_su_t etc_t:lnk_file read;
#line 4850

#line 4850
allow user_su_t locale_t:dir { read getattr lock search ioctl };
#line 4850
allow user_su_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 4850

#line 4850

#line 4850
allow user_su_t self:unix_dgram_socket { connect create write };
#line 4850
allow user_su_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4850
allow user_su_t proc_t:dir search;
#line 4850
allow user_su_t proc_t:lnk_file read;
#line 4850

#line 4850
allow user_su_t self:dir { read getattr lock search ioctl };
#line 4850
allow user_su_t self:{ file lnk_file } { read getattr lock ioctl };
#line 4850

#line 4850
allow user_su_t self:process setsched;
#line 4850
allow user_su_t device_t:dir search;
#line 4850
allow user_su_t self:process { fork sigchld };
#line 4850

#line 4850
# Use capabilities.
#line 4850
allow user_su_t self:capability { setuid setgid net_bind_service chown dac_override sys_nice sys_resource };
#line 4850

#line 4850
# Revert to the user domain when a shell is executed.
#line 4850

#line 4850

#line 4850

#line 4850
#
#line 4850
# Allow the process to transition to the new domain.
#line 4850
#
#line 4850
allow user_su_t user_t:process transition;
#line 4850

#line 4850
#
#line 4850
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4850
#
#line 4850
dontaudit user_su_t user_t:process noatsecure;
#line 4850

#line 4850
#
#line 4850
# Allow the process to execute the program.
#line 4850
# 
#line 4850
allow user_su_t shell_exec_t:file { read { getattr execute } };
#line 4850

#line 4850
#
#line 4850
# Allow the process to reap the new domain.
#line 4850
#
#line 4850
allow user_t user_su_t:process sigchld;
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to inherit and use file 
#line 4850
# descriptions from the creating process and vice versa.
#line 4850
#
#line 4850
allow user_t user_su_t:fd use;
#line 4850
allow user_su_t user_t:fd use;
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to write back to the old domain via a pipe.
#line 4850
#
#line 4850
allow user_t user_su_t:fifo_file { ioctl read getattr lock write append };
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to read and execute the program.
#line 4850
#
#line 4850
allow user_t shell_exec_t:file { read getattr lock execute ioctl };
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to be entered via the program.
#line 4850
#
#line 4850
allow user_t shell_exec_t:file entrypoint;
#line 4850

#line 4850
type_transition user_su_t shell_exec_t:process user_t;
#line 4850

#line 4850
allow user_su_t bin_t:dir search;
#line 4850
allow user_su_t bin_t:lnk_file read;
#line 4850

#line 4850
allow user_su_t privfd:fd use;
#line 4850

#line 4850
# Write to utmp.
#line 4850
allow user_su_t { var_t var_run_t }:dir search;
#line 4850
allow user_su_t initrc_var_run_t:file { ioctl read getattr lock write append };
#line 4850

#line 4850

#line 4850

#line 4850
# Run chkpwd.
#line 4850

#line 4850
allow user_su_t chkpwd_exec_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4850

#line 4850

#line 4850

#line 4850
# Inherit and use descriptors from gnome-pty-helper.
#line 4850

#line 4850

#line 4850
# The user role is authorized for this domain.
#line 4850
role user_r types user_su_t;
#line 4850

#line 4850
# Write to the user domain tty.
#line 4850
allow user_su_t user_tty_device_t:chr_file { ioctl read getattr lock write append };
#line 4850
allow user_su_t user_devpts_t:chr_file { ioctl read getattr lock write append };
#line 4850

#line 4850
allow user_su_t { home_root_t user_home_dir_t }:dir search;
#line 4850

#line 4850
# Modify .Xauthority file (via xauth program).
#line 4850

#line 4850

#line 4850
# Access sshd cookie files.
#line 4850
allow user_su_t sshd_tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4850
allow user_su_t sshd_tmp_t:file { ioctl read getattr lock write append };
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
#
#line 4850
# Allow the process to modify the directory.
#line 4850
#
#line 4850
allow user_su_t sshd_tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4850

#line 4850
#
#line 4850
# Allow the process to create the file.
#line 4850
#
#line 4850

#line 4850
allow user_su_t user_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4850
allow user_su_t user_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4850

#line 4850

#line 4850
type_transition user_su_t sshd_tmp_t:dir user_tmp_t;
#line 4850
type_transition user_su_t sshd_tmp_t:{ file lnk_file sock_file fifo_file } user_tmp_t;
#line 4850

#line 4850

#line 4850

#line 4850
# stop su complaining if you run it from a directory with restrictive perms
#line 4850
dontaudit user_su_t file_type:dir search;
#line 4850

#line 4850

#line 4850
# Derived domain based on the calling user domain and the program.
#line 4850
type user_chkpwd_t, domain, privlog, auth;
#line 4850

#line 4850
# Transition from the user domain to this domain.
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
#
#line 4850
# Allow the process to transition to the new domain.
#line 4850
#
#line 4850
allow user_t user_chkpwd_t:process transition;
#line 4850

#line 4850
#
#line 4850
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4850
#
#line 4850
dontaudit user_t user_chkpwd_t:process noatsecure;
#line 4850

#line 4850
#
#line 4850
# Allow the process to execute the program.
#line 4850
# 
#line 4850
allow user_t chkpwd_exec_t:file { read { getattr execute } };
#line 4850

#line 4850
#
#line 4850
# Allow the process to reap the new domain.
#line 4850
#
#line 4850
allow user_chkpwd_t user_t:process sigchld;
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to inherit and use file 
#line 4850
# descriptions from the creating process and vice versa.
#line 4850
#
#line 4850
allow user_chkpwd_t user_t:fd use;
#line 4850
allow user_t user_chkpwd_t:fd use;
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to write back to the old domain via a pipe.
#line 4850
#
#line 4850
allow user_chkpwd_t user_t:fifo_file { ioctl read getattr lock write append };
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to read and execute the program.
#line 4850
#
#line 4850
allow user_chkpwd_t chkpwd_exec_t:file { read getattr lock execute ioctl };
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to be entered via the program.
#line 4850
#
#line 4850
allow user_chkpwd_t chkpwd_exec_t:file entrypoint;
#line 4850

#line 4850
type_transition user_t chkpwd_exec_t:process user_chkpwd_t;
#line 4850

#line 4850

#line 4850
# The user role is authorized for this domain.
#line 4850
role user_r types user_chkpwd_t;
#line 4850

#line 4850
# Write to the user domain tty.
#line 4850
allow user_chkpwd_t user_tty_device_t:chr_file { ioctl read getattr lock write append };
#line 4850
allow user_chkpwd_t user_devpts_t:chr_file { ioctl read getattr lock write append };
#line 4850

#line 4850
# Inherit and use descriptors from gnome-pty-helper.
#line 4850

#line 4850

#line 4850
# Inherit and use descriptors from newrole.
#line 4850
allow user_chkpwd_t newrole_t:fd use;
#line 4850

#line 4850

#line 4850

#line 4850
allow user_chkpwd_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4850
allow user_chkpwd_t lib_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_chkpwd_t ld_so_t:file { read getattr lock execute ioctl };
#line 4850
allow user_chkpwd_t ld_so_t:file execute_no_trans;
#line 4850
allow user_chkpwd_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_chkpwd_t shlib_t:file { read getattr lock execute ioctl };
#line 4850
allow user_chkpwd_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_chkpwd_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4850
allow user_chkpwd_t device_t:dir search;
#line 4850
allow user_chkpwd_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4850

#line 4850
allow user_chkpwd_t etc_t:file { getattr read };
#line 4850
allow user_chkpwd_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4850
allow user_chkpwd_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4850

#line 4850
allow user_chkpwd_t etc_t:lnk_file read;
#line 4850

#line 4850
allow user_chkpwd_t locale_t:dir { read getattr lock search ioctl };
#line 4850
allow user_chkpwd_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 4850

#line 4850

#line 4850

#line 4850
# Use capabilities.
#line 4850
allow user_chkpwd_t self:capability setuid;
#line 4850

#line 4850
# for nscd
#line 4850
dontaudit user_chkpwd_t var_t:dir search;
#line 4850

#line 4850
dontaudit user_chkpwd_t fs_t:filesystem getattr;
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850

#line 4850

#line 4850

#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
# Derived domain based on the calling user domain and the program.
#line 4850
type user_crontab_t, domain, privlog;
#line 4850

#line 4850
# Transition from the user domain to the derived domain.
#line 4850

#line 4850

#line 4850

#line 4850
#
#line 4850
# Allow the process to transition to the new domain.
#line 4850
#
#line 4850
allow user_t user_crontab_t:process transition;
#line 4850

#line 4850
#
#line 4850
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4850
#
#line 4850
dontaudit user_t user_crontab_t:process noatsecure;
#line 4850

#line 4850
#
#line 4850
# Allow the process to execute the program.
#line 4850
# 
#line 4850
allow user_t crontab_exec_t:file { read { getattr execute } };
#line 4850

#line 4850
#
#line 4850
# Allow the process to reap the new domain.
#line 4850
#
#line 4850
allow user_crontab_t user_t:process sigchld;
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to inherit and use file 
#line 4850
# descriptions from the creating process and vice versa.
#line 4850
#
#line 4850
allow user_crontab_t user_t:fd use;
#line 4850
allow user_t user_crontab_t:fd use;
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to write back to the old domain via a pipe.
#line 4850
#
#line 4850
allow user_crontab_t user_t:fifo_file { ioctl read getattr lock write append };
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to read and execute the program.
#line 4850
#
#line 4850
allow user_crontab_t crontab_exec_t:file { read getattr lock execute ioctl };
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to be entered via the program.
#line 4850
#
#line 4850
allow user_crontab_t crontab_exec_t:file entrypoint;
#line 4850

#line 4850
type_transition user_t crontab_exec_t:process user_crontab_t;
#line 4850

#line 4850

#line 4850
# The user role is authorized for this domain.
#line 4850
role user_r types user_crontab_t;
#line 4850

#line 4850

#line 4850
allow user_crontab_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4850
allow user_crontab_t lib_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_crontab_t ld_so_t:file { read getattr lock execute ioctl };
#line 4850
allow user_crontab_t ld_so_t:file execute_no_trans;
#line 4850
allow user_crontab_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_crontab_t shlib_t:file { read getattr lock execute ioctl };
#line 4850
allow user_crontab_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_crontab_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4850
allow user_crontab_t device_t:dir search;
#line 4850
allow user_crontab_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4850

#line 4850
allow user_crontab_t etc_t:file { getattr read };
#line 4850
allow user_crontab_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4850
allow user_crontab_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4850

#line 4850
allow user_crontab_t etc_t:lnk_file read;
#line 4850

#line 4850
allow user_crontab_t locale_t:dir { read getattr lock search ioctl };
#line 4850
allow user_crontab_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 4850

#line 4850

#line 4850

#line 4850
# Use capabilities dac_override is to create the file in the directory
#line 4850
# under /tmp
#line 4850
allow user_crontab_t user_crontab_t:capability { setuid setgid chown dac_override };
#line 4850

#line 4850
# Type for temporary files.
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
#
#line 4850
# Allow the process to modify the directory.
#line 4850
#
#line 4850
allow user_crontab_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4850

#line 4850
#
#line 4850
# Allow the process to create the file.
#line 4850
#
#line 4850

#line 4850

#line 4850
allow user_crontab_t user_tmp_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 4850

#line 4850

#line 4850
type_transition user_crontab_t tmp_t:file user_tmp_t;
#line 4850

#line 4850

#line 4850

#line 4850
# Type of user crontabs once moved to cron spool.
#line 4850
type user_cron_spool_t, file_type, sysadmfile;
#line 4850
# Use the type when creating files in /var/spool/cron.
#line 4850
allow sysadm_crontab_t user_cron_spool_t:file { getattr read };
#line 4850
allow user_crontab_t { var_t var_spool_t }:dir search;
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
#
#line 4850
# Allow the process to modify the directory.
#line 4850
#
#line 4850
allow user_crontab_t cron_spool_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4850

#line 4850
#
#line 4850
# Allow the process to create the file.
#line 4850
#
#line 4850

#line 4850

#line 4850
allow user_crontab_t user_cron_spool_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 4850

#line 4850

#line 4850
type_transition user_crontab_t cron_spool_t:file user_cron_spool_t;
#line 4850

#line 4850

#line 4850
allow user_crontab_t self:process { fork { sigchld sigkill sigstop signull signal } };
#line 4850

#line 4850
# crontab signals crond by updating the mtime on the spooldir
#line 4850
allow user_crontab_t cron_spool_t:dir setattr;
#line 4850
# Allow crond to read those crontabs in cron spool.
#line 4850
allow crond_t user_cron_spool_t:file { read getattr lock ioctl };
#line 4850

#line 4850
# Run helper programs as user_t
#line 4850
allow user_crontab_t { bin_t sbin_t }:dir search;
#line 4850
allow user_crontab_t bin_t:lnk_file read;
#line 4850

#line 4850

#line 4850

#line 4850
#
#line 4850
# Allow the process to transition to the new domain.
#line 4850
#
#line 4850
allow user_crontab_t user_t:process transition;
#line 4850

#line 4850
#
#line 4850
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4850
#
#line 4850
dontaudit user_crontab_t user_t:process noatsecure;
#line 4850

#line 4850
#
#line 4850
# Allow the process to execute the program.
#line 4850
# 
#line 4850
allow user_crontab_t { bin_t sbin_t shell_exec_t }:file { read { getattr execute } };
#line 4850

#line 4850
#
#line 4850
# Allow the process to reap the new domain.
#line 4850
#
#line 4850
allow user_t user_crontab_t:process sigchld;
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to inherit and use file 
#line 4850
# descriptions from the creating process and vice versa.
#line 4850
#
#line 4850
allow user_t user_crontab_t:fd use;
#line 4850
allow user_crontab_t user_t:fd use;
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to write back to the old domain via a pipe.
#line 4850
#
#line 4850
allow user_t user_crontab_t:fifo_file { ioctl read getattr lock write append };
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to read and execute the program.
#line 4850
#
#line 4850
allow user_t { bin_t sbin_t shell_exec_t }:file { read getattr lock execute ioctl };
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to be entered via the program.
#line 4850
#
#line 4850
allow user_t { bin_t sbin_t shell_exec_t }:file entrypoint;
#line 4850

#line 4850
type_transition user_crontab_t { bin_t sbin_t shell_exec_t }:process user_t;
#line 4850

#line 4850

#line 4850
# Read user crontabs 
#line 4850
allow user_crontab_t { user_home_t user_home_dir_t }:dir { read getattr lock search ioctl };  
#line 4850
allow user_crontab_t user_home_t:file { read getattr lock ioctl };  
#line 4850
dontaudit user_crontab_t user_home_dir_t:dir write;
#line 4850

#line 4850
# Access the cron log file.
#line 4850
allow user_crontab_t crond_log_t:file { read getattr lock ioctl };
#line 4850
allow user_crontab_t crond_log_t:file { append };
#line 4850

#line 4850
# Access terminals.
#line 4850
allow user_crontab_t device_t:dir search;
#line 4850
allow user_crontab_t user_tty_device_t:chr_file { ioctl read getattr lock write append };
#line 4850
allow user_crontab_t user_devpts_t:chr_file { ioctl read getattr lock write append };
#line 4850

#line 4850
allow user_crontab_t fs_t:filesystem getattr;
#line 4850

#line 4850
# Inherit and use descriptors from gnome-pty-helper.
#line 4850

#line 4850
allow user_crontab_t privfd:fd use;
#line 4850

#line 4850
dontaudit user_crontab_t var_run_t:dir search;
#line 4850

#line 4850

#line 4850
# Derived domain based on the calling user domain and the program.
#line 4850
type user_ssh_t, domain, privlog;
#line 4850

#line 4850
# Transition from the user domain to the derived domain.
#line 4850

#line 4850

#line 4850

#line 4850
#
#line 4850
# Allow the process to transition to the new domain.
#line 4850
#
#line 4850
allow user_t user_ssh_t:process transition;
#line 4850

#line 4850
#
#line 4850
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4850
#
#line 4850
dontaudit user_t user_ssh_t:process noatsecure;
#line 4850

#line 4850
#
#line 4850
# Allow the process to execute the program.
#line 4850
# 
#line 4850
allow user_t ssh_exec_t:file { read { getattr execute } };
#line 4850

#line 4850
#
#line 4850
# Allow the process to reap the new domain.
#line 4850
#
#line 4850
allow user_ssh_t user_t:process sigchld;
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to inherit and use file 
#line 4850
# descriptions from the creating process and vice versa.
#line 4850
#
#line 4850
allow user_ssh_t user_t:fd use;
#line 4850
allow user_t user_ssh_t:fd use;
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to write back to the old domain via a pipe.
#line 4850
#
#line 4850
allow user_ssh_t user_t:fifo_file { ioctl read getattr lock write append };
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to read and execute the program.
#line 4850
#
#line 4850
allow user_ssh_t ssh_exec_t:file { read getattr lock execute ioctl };
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to be entered via the program.
#line 4850
#
#line 4850
allow user_ssh_t ssh_exec_t:file entrypoint;
#line 4850

#line 4850
type_transition user_t ssh_exec_t:process user_ssh_t;
#line 4850

#line 4850

#line 4850
# The user role is authorized for this domain.
#line 4850
role user_r types user_ssh_t;
#line 4850

#line 4850
# Grant permissions within the domain.
#line 4850

#line 4850
# Access other processes in the same domain.
#line 4850
# Omits ptrace, setexec, and setfscreate.  These must be granted 
#line 4850
# separately if desired.
#line 4850
allow user_ssh_t self:process ~{ptrace setexec setfscreate};
#line 4850

#line 4850
# Access /proc/PID files for processes in the same domain.
#line 4850
allow user_ssh_t self:dir { read getattr lock search ioctl };
#line 4850
allow user_ssh_t self:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4850

#line 4850
# Access file descriptions, pipes, and sockets
#line 4850
# created by processes in the same domain.
#line 4850
allow user_ssh_t self:fd *;
#line 4850
allow user_ssh_t self:fifo_file { ioctl read getattr lock write append };
#line 4850
allow user_ssh_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4850
allow user_ssh_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4850

#line 4850
# Allow the domain to communicate with other processes in the same domain.
#line 4850
allow user_ssh_t self:unix_dgram_socket sendto;
#line 4850
allow user_ssh_t self:unix_stream_socket connectto;
#line 4850

#line 4850
# Access System V IPC objects created by processes in the same domain.
#line 4850
allow user_ssh_t self:sem  { associate getattr setattr create destroy read write unix_read unix_write };
#line 4850
allow user_ssh_t self:msg  { send receive };
#line 4850
allow user_ssh_t self:msgq { associate getattr setattr create destroy read write enqueue unix_read unix_write };
#line 4850
allow user_ssh_t self:shm  { associate getattr setattr create destroy read write lock unix_read unix_write };
#line 4850

#line 4850

#line 4850
# Use descriptors created by sshd
#line 4850
allow user_ssh_t privfd:fd use;
#line 4850

#line 4850

#line 4850
allow user_ssh_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4850
allow user_ssh_t lib_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_ssh_t ld_so_t:file { read getattr lock execute ioctl };
#line 4850
allow user_ssh_t ld_so_t:file execute_no_trans;
#line 4850
allow user_ssh_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_ssh_t shlib_t:file { read getattr lock execute ioctl };
#line 4850
allow user_ssh_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_ssh_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4850
allow user_ssh_t device_t:dir search;
#line 4850
allow user_ssh_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4850

#line 4850

#line 4850
allow user_ssh_t etc_t:lnk_file read;
#line 4850

#line 4850
allow user_ssh_t locale_t:dir { read getattr lock search ioctl };
#line 4850
allow user_ssh_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 4850

#line 4850

#line 4850

#line 4850
# Get attributes of file systems.
#line 4850
allow user_ssh_t fs_type:filesystem getattr;
#line 4850

#line 4850

#line 4850
# Read /.
#line 4850
allow user_ssh_t root_t:dir { read getattr lock search ioctl };
#line 4850
allow user_ssh_t root_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4850

#line 4850
# Read /home.
#line 4850
allow user_ssh_t home_root_t:dir { read getattr lock search ioctl };
#line 4850

#line 4850
# Read /usr.
#line 4850
allow user_ssh_t usr_t:dir { read getattr lock search ioctl };
#line 4850
allow user_ssh_t usr_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4850

#line 4850
# Read bin and sbin directories.
#line 4850
allow user_ssh_t bin_t:dir { read getattr lock search ioctl };
#line 4850
allow user_ssh_t bin_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4850
allow user_ssh_t sbin_t:dir { read getattr lock search ioctl };
#line 4850
allow user_ssh_t sbin_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4850

#line 4850

#line 4850
# Read the devpts root directory.
#line 4850
allow user_ssh_t devpts_t:dir { read getattr lock search ioctl };
#line 4850

#line 4850
# Read /var.
#line 4850
allow user_ssh_t var_t:dir { read getattr lock search ioctl };
#line 4850
allow user_ssh_t var_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4850

#line 4850
# Read /var/run, /var/log.
#line 4850
allow user_ssh_t var_run_t:dir { read getattr lock search ioctl };
#line 4850
allow user_ssh_t var_run_t:{ file lnk_file } { read getattr lock ioctl };
#line 4850
allow user_ssh_t var_log_t:dir { read getattr lock search ioctl };
#line 4850
allow user_ssh_t var_log_t:{ file lnk_file } { read getattr lock ioctl };
#line 4850

#line 4850
# Read /etc.
#line 4850
allow user_ssh_t etc_t:dir { read getattr lock search ioctl };
#line 4850
allow user_ssh_t etc_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4850
allow user_ssh_t etc_runtime_t:{ file lnk_file } { read getattr lock ioctl };
#line 4850
allow user_ssh_t resolv_conf_t:{ file lnk_file } { read getattr lock ioctl };
#line 4850

#line 4850
# Read the linker, shared library, and executable types.
#line 4850
allow user_ssh_t ld_so_t:{ file lnk_file } { read getattr lock ioctl };
#line 4850
allow user_ssh_t shlib_t:{ file lnk_file } { read getattr lock ioctl };
#line 4850
allow user_ssh_t exec_type:{ file lnk_file } { read getattr lock ioctl };
#line 4850

#line 4850
# Read /dev directories and any symbolic links.
#line 4850
allow user_ssh_t device_t:dir { read getattr lock search ioctl };
#line 4850
allow user_ssh_t device_t:lnk_file { read getattr lock ioctl };
#line 4850

#line 4850
# Read /dev/random.
#line 4850
allow user_ssh_t random_device_t:chr_file { read getattr lock ioctl };
#line 4850

#line 4850
# Read and write /dev/tty and /dev/null.
#line 4850
allow user_ssh_t devtty_t:chr_file { ioctl read getattr lock write append };
#line 4850
allow user_ssh_t { null_device_t zero_device_t }:chr_file { ioctl read getattr lock write append };
#line 4850

#line 4850
# Grant permissions needed to create TCP and UDP sockets and
#line 4850
# to access the network.
#line 4850

#line 4850
#
#line 4850
# Allow the domain to create and use UDP and TCP sockets.
#line 4850
# Other kinds of sockets must be separately authorized for use.
#line 4850
allow user_ssh_t self:udp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4850
allow user_ssh_t self:tcp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4850

#line 4850
#
#line 4850
# Allow the domain to send UDP packets.
#line 4850
# Since the destination sockets type is unknown, the generic
#line 4850
# any_socket_t type is used as a placeholder.
#line 4850
#
#line 4850
allow user_ssh_t any_socket_t:udp_socket sendto;
#line 4850

#line 4850
#
#line 4850
# Allow the domain to send using any network interface.
#line 4850
# netif_type is a type attribute for all network interface types.
#line 4850
#
#line 4850
allow user_ssh_t netif_type:netif { tcp_send udp_send rawip_send };
#line 4850

#line 4850
#
#line 4850
# Allow packets sent by the domain to be received on any network interface.
#line 4850
#
#line 4850
allow user_ssh_t netif_type:netif { tcp_recv udp_recv rawip_recv };
#line 4850

#line 4850
#
#line 4850
# Allow the domain to receive packets from any network interface.
#line 4850
# netmsg_type is a type attribute for all default message types.
#line 4850
#
#line 4850
allow user_ssh_t netmsg_type:{ udp_socket tcp_socket rawip_socket } recvfrom;
#line 4850

#line 4850
#
#line 4850
# Allow the domain to initiate or accept TCP connections 
#line 4850
# on any network interface.
#line 4850
#
#line 4850
allow user_ssh_t netmsg_type:tcp_socket { connectto acceptfrom };
#line 4850

#line 4850
#
#line 4850
# Receive resets from the TCP reset socket.
#line 4850
# The TCP reset socket is labeled with the tcp_socket_t type.
#line 4850
#
#line 4850
allow user_ssh_t tcp_socket_t:tcp_socket recvfrom;
#line 4850

#line 4850
dontaudit user_ssh_t tcp_socket_t:tcp_socket connectto;
#line 4850

#line 4850
#
#line 4850
# Allow the domain to send to any node.
#line 4850
# node_type is a type attribute for all node types.
#line 4850
#
#line 4850
allow user_ssh_t node_type:node { tcp_send udp_send rawip_send };
#line 4850

#line 4850
#
#line 4850
# Allow packets sent by the domain to be received from any node.
#line 4850
#
#line 4850
allow user_ssh_t node_type:node { tcp_recv udp_recv rawip_recv };
#line 4850

#line 4850
#
#line 4850
# Allow the domain to send NFS client requests via the socket
#line 4850
# created by mount.
#line 4850
#
#line 4850
allow user_ssh_t mount_t:udp_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4850

#line 4850
#
#line 4850
# Bind to the default port type.
#line 4850
# Other port types must be separately authorized.
#line 4850
#
#line 4850
#allow user_ssh_t port_t:udp_socket name_bind;
#line 4850
#allow user_ssh_t port_t:tcp_socket name_bind;
#line 4850

#line 4850

#line 4850
# for sshing to a ssh tunnel
#line 4850

#line 4850
allow user_ssh_t user_ssh_t:tcp_socket { connectto recvfrom };
#line 4850
allow user_ssh_t user_ssh_t:tcp_socket { acceptfrom recvfrom };
#line 4850
allow user_ssh_t tcp_socket_t:tcp_socket { recvfrom };
#line 4850
allow user_ssh_t tcp_socket_t:tcp_socket { recvfrom };
#line 4850

#line 4850

#line 4850
# Use capabilities.
#line 4850
allow user_ssh_t self:capability { setuid setgid dac_override dac_read_search };
#line 4850

#line 4850
# Run helpers.
#line 4850

#line 4850
allow user_ssh_t { bin_t sbin_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4850
allow user_ssh_t { bin_t sbin_t etc_t }:lnk_file { getattr read };
#line 4850

#line 4850
allow user_ssh_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4850
allow user_ssh_t lib_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_ssh_t ld_so_t:file { read getattr lock execute ioctl };
#line 4850
allow user_ssh_t ld_so_t:file execute_no_trans;
#line 4850
allow user_ssh_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_ssh_t shlib_t:file { read getattr lock execute ioctl };
#line 4850
allow user_ssh_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_ssh_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4850
allow user_ssh_t device_t:dir search;
#line 4850
allow user_ssh_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4850

#line 4850

#line 4850
allow user_ssh_t etc_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4850

#line 4850

#line 4850
allow user_ssh_t lib_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4850

#line 4850

#line 4850
allow user_ssh_t bin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4850

#line 4850

#line 4850
allow user_ssh_t sbin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4850

#line 4850

#line 4850
allow user_ssh_t exec_type:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4850

#line 4850

#line 4850

#line 4850
# Read the ssh key file.
#line 4850
allow user_ssh_t sshd_key_t:file { read getattr lock ioctl };
#line 4850

#line 4850
# Access the ssh temporary files.
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
#
#line 4850
# Allow the process to modify the directory.
#line 4850
#
#line 4850
allow user_ssh_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4850

#line 4850
#
#line 4850
# Allow the process to create the file.
#line 4850
#
#line 4850

#line 4850
allow user_ssh_t sshd_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4850
allow user_ssh_t sshd_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4850

#line 4850

#line 4850
type_transition user_ssh_t tmp_t:dir sshd_tmp_t;
#line 4850
type_transition user_ssh_t tmp_t:{ file lnk_file sock_file fifo_file } sshd_tmp_t;
#line 4850

#line 4850

#line 4850
allow user_ssh_t user_tmp_t:dir { read getattr lock search ioctl };
#line 4850

#line 4850
# for rsync
#line 4850
allow user_ssh_t user_t:unix_stream_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4850

#line 4850
# Access the users .ssh directory.
#line 4850
type user_home_ssh_t, file_type, sysadmfile;
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
#
#line 4850
# Allow the process to modify the directory.
#line 4850
#
#line 4850
allow { sysadm_ssh_t user_ssh_t } user_home_dir_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4850

#line 4850
#
#line 4850
# Allow the process to create the file.
#line 4850
#
#line 4850

#line 4850
allow { sysadm_ssh_t user_ssh_t } user_home_ssh_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4850
allow { sysadm_ssh_t user_ssh_t } user_home_ssh_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4850

#line 4850

#line 4850
type_transition { sysadm_ssh_t user_ssh_t } user_home_dir_t:dir user_home_ssh_t;
#line 4850
type_transition { sysadm_ssh_t user_ssh_t } user_home_dir_t:{ file lnk_file sock_file fifo_file } user_home_ssh_t;
#line 4850

#line 4850

#line 4850
allow { sysadm_ssh_t user_ssh_t } user_home_ssh_t:lnk_file { getattr read };
#line 4850
dontaudit user_ssh_t user_home_t:dir search;
#line 4850

#line 4850
allow sshd_t user_home_ssh_t:dir { read getattr lock search ioctl };
#line 4850
allow sshd_t user_home_ssh_t:{ file lnk_file } { read getattr lock ioctl };
#line 4850

#line 4850

#line 4850
allow user_t user_home_ssh_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4850
allow user_t user_home_ssh_t:{ file lnk_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4850

#line 4850

#line 4850
# for /bin/sh used to execute xauth
#line 4850
dontaudit user_ssh_t proc_t:dir search;
#line 4850

#line 4850
# Inherit and use descriptors from gnome-pty-helper.
#line 4850

#line 4850

#line 4850
# Connect to sshd.
#line 4850

#line 4850

#line 4850
allow user_ssh_t sshd_t:tcp_socket { connectto recvfrom };
#line 4850
allow sshd_t user_ssh_t:tcp_socket { acceptfrom recvfrom };
#line 4850
allow sshd_t tcp_socket_t:tcp_socket { recvfrom };
#line 4850
allow user_ssh_t tcp_socket_t:tcp_socket { recvfrom };
#line 4850

#line 4850

#line 4850

#line 4850
# Write to the user domain tty.
#line 4850
allow user_ssh_t user_tty_device_t:chr_file { ioctl read getattr lock write append };
#line 4850
allow user_ssh_t user_devpts_t:chr_file { ioctl read getattr lock write append };
#line 4850

#line 4850
# Allow the user shell to signal the ssh program.
#line 4850
allow user_t user_ssh_t:process signal;
#line 4850
# allow ps to show ssh
#line 4850
allow user_t user_ssh_t:dir { search getattr read };
#line 4850
allow user_t user_ssh_t:{ file lnk_file } { read getattr };
#line 4850

#line 4850
# Allow the ssh program to communicate with ssh-agent.
#line 4850
allow user_ssh_t user_tmp_t:sock_file write;
#line 4850
allow user_ssh_t user_t:unix_stream_socket connectto;
#line 4850
allow user_ssh_t sshd_t:unix_stream_socket connectto;
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850

#line 4850

#line 4850

#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
# Instantiate a derived domain for user cron jobs.
#line 4850

#line 4850
# Derived domain for user cron jobs, user user_crond_domain if not system
#line 4850

#line 4850
type user_crond_t, domain, user_crond_domain;
#line 4850

#line 4850

#line 4850
# Permit a transition from the crond_t domain to this domain.
#line 4850
# The transition is requested explicitly by the modified crond 
#line 4850
# via execve_secure.  There is no way to set up an automatic
#line 4850
# transition, since crontabs are configuration files, not executables.
#line 4850

#line 4850

#line 4850
#
#line 4850
# Allow the process to transition to the new domain.
#line 4850
#
#line 4850
allow crond_t user_crond_t:process transition;
#line 4850

#line 4850
#
#line 4850
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4850
#
#line 4850
dontaudit crond_t user_crond_t:process noatsecure;
#line 4850

#line 4850
#
#line 4850
# Allow the process to execute the program.
#line 4850
# 
#line 4850
allow crond_t shell_exec_t:file { read { getattr execute } };
#line 4850

#line 4850
#
#line 4850
# Allow the process to reap the new domain.
#line 4850
#
#line 4850
allow user_crond_t crond_t:process sigchld;
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to inherit and use file 
#line 4850
# descriptions from the creating process and vice versa.
#line 4850
#
#line 4850
allow user_crond_t crond_t:fd use;
#line 4850
allow crond_t user_crond_t:fd use;
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to write back to the old domain via a pipe.
#line 4850
#
#line 4850
allow user_crond_t crond_t:fifo_file { ioctl read getattr lock write append };
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to read and execute the program.
#line 4850
#
#line 4850
allow user_crond_t shell_exec_t:file { read getattr lock execute ioctl };
#line 4850

#line 4850
#
#line 4850
# Allow the new domain to be entered via the program.
#line 4850
#
#line 4850
allow user_crond_t shell_exec_t:file entrypoint;
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
# The user role is authorized for this domain.
#line 4850
role user_r types user_crond_t;
#line 4850

#line 4850
# This domain is granted permissions common to most domains.
#line 4850

#line 4850
#
#line 4850
# Allow the domain to create and use UDP and TCP sockets.
#line 4850
# Other kinds of sockets must be separately authorized for use.
#line 4850
allow user_crond_t self:udp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4850
allow user_crond_t self:tcp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4850

#line 4850
#
#line 4850
# Allow the domain to send UDP packets.
#line 4850
# Since the destination sockets type is unknown, the generic
#line 4850
# any_socket_t type is used as a placeholder.
#line 4850
#
#line 4850
allow user_crond_t any_socket_t:udp_socket sendto;
#line 4850

#line 4850
#
#line 4850
# Allow the domain to send using any network interface.
#line 4850
# netif_type is a type attribute for all network interface types.
#line 4850
#
#line 4850
allow user_crond_t netif_type:netif { tcp_send udp_send rawip_send };
#line 4850

#line 4850
#
#line 4850
# Allow packets sent by the domain to be received on any network interface.
#line 4850
#
#line 4850
allow user_crond_t netif_type:netif { tcp_recv udp_recv rawip_recv };
#line 4850

#line 4850
#
#line 4850
# Allow the domain to receive packets from any network interface.
#line 4850
# netmsg_type is a type attribute for all default message types.
#line 4850
#
#line 4850
allow user_crond_t netmsg_type:{ udp_socket tcp_socket rawip_socket } recvfrom;
#line 4850

#line 4850
#
#line 4850
# Allow the domain to initiate or accept TCP connections 
#line 4850
# on any network interface.
#line 4850
#
#line 4850
allow user_crond_t netmsg_type:tcp_socket { connectto acceptfrom };
#line 4850

#line 4850
#
#line 4850
# Receive resets from the TCP reset socket.
#line 4850
# The TCP reset socket is labeled with the tcp_socket_t type.
#line 4850
#
#line 4850
allow user_crond_t tcp_socket_t:tcp_socket recvfrom;
#line 4850

#line 4850
dontaudit user_crond_t tcp_socket_t:tcp_socket connectto;
#line 4850

#line 4850
#
#line 4850
# Allow the domain to send to any node.
#line 4850
# node_type is a type attribute for all node types.
#line 4850
#
#line 4850
allow user_crond_t node_type:node { tcp_send udp_send rawip_send };
#line 4850

#line 4850
#
#line 4850
# Allow packets sent by the domain to be received from any node.
#line 4850
#
#line 4850
allow user_crond_t node_type:node { tcp_recv udp_recv rawip_recv };
#line 4850

#line 4850
#
#line 4850
# Allow the domain to send NFS client requests via the socket
#line 4850
# created by mount.
#line 4850
#
#line 4850
allow user_crond_t mount_t:udp_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4850

#line 4850
#
#line 4850
# Bind to the default port type.
#line 4850
# Other port types must be separately authorized.
#line 4850
#
#line 4850
#allow user_crond_t port_t:udp_socket name_bind;
#line 4850
#allow user_crond_t port_t:tcp_socket name_bind;
#line 4850

#line 4850
allow user_crond_t resolv_conf_t:file { getattr read };
#line 4850

#line 4850
allow user_crond_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4850
allow user_crond_t lib_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_crond_t ld_so_t:file { read getattr lock execute ioctl };
#line 4850
allow user_crond_t ld_so_t:file execute_no_trans;
#line 4850
allow user_crond_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_crond_t shlib_t:file { read getattr lock execute ioctl };
#line 4850
allow user_crond_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_crond_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4850
allow user_crond_t device_t:dir search;
#line 4850
allow user_crond_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4850

#line 4850

#line 4850
allow user_crond_t self:dir { read getattr lock search ioctl };
#line 4850
allow user_crond_t self:{ file lnk_file } { read getattr lock ioctl };
#line 4850

#line 4850
allow user_crond_t self:fifo_file { ioctl read getattr lock write append };
#line 4850
allow user_crond_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4850
allow user_crond_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4850
allow user_crond_t etc_runtime_t:file { getattr read };
#line 4850
allow user_crond_t self:process { fork { sigchld sigkill sigstop signull signal } };
#line 4850
allow user_crond_t proc_t:dir { getattr search read };
#line 4850
allow user_crond_t proc_t:file { getattr read };
#line 4850

#line 4850
allow user_crond_t etc_t:lnk_file read;
#line 4850

#line 4850
allow user_crond_t locale_t:dir { read getattr lock search ioctl };
#line 4850
allow user_crond_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 4850

#line 4850

#line 4850
allow user_crond_t sysctl_kernel_t:dir search;
#line 4850
allow user_crond_t sysctl_kernel_t:file { getattr read };
#line 4850
allow user_crond_t var_spool_t:dir search;
#line 4850
allow user_crond_t fs_t:filesystem getattr;
#line 4850

#line 4850
allow user_crond_t devtty_t:chr_file { read write };
#line 4850

#line 4850
# Use capabilities.
#line 4850
allow user_crond_t user_crond_t:capability dac_override;
#line 4850

#line 4850
# Inherit and use descriptors from initrc.
#line 4850
allow user_crond_t initrc_t:fd use;
#line 4850

#line 4850
# 
#line 4850
# Since crontab files are not directly executed,
#line 4850
# crond must ensure that the crontab file has
#line 4850
# a type that is appropriate for the domain of
#line 4850
# the user cron job.  It performs an entrypoint
#line 4850
# permission check for this purpose.
#line 4850
#
#line 4850
allow user_crond_t user_cron_spool_t:file entrypoint;
#line 4850

#line 4850
# Access user files and dirs.
#line 4850
allow user_crond_t home_root_t:dir search;
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
#
#line 4850
# Allow the process to modify the directory.
#line 4850
#
#line 4850
allow user_crond_t user_home_dir_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4850

#line 4850
#
#line 4850
# Allow the process to create the file.
#line 4850
#
#line 4850

#line 4850
allow user_crond_t user_home_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4850
allow user_crond_t user_home_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4850

#line 4850

#line 4850
type_transition user_crond_t user_home_dir_t:dir user_home_t;
#line 4850
type_transition user_crond_t user_home_dir_t:{ file lnk_file sock_file fifo_file } user_home_t;
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
#
#line 4850
# Allow the process to modify the directory.
#line 4850
#
#line 4850
allow user_crond_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4850

#line 4850
#
#line 4850
# Allow the process to create the file.
#line 4850
#
#line 4850

#line 4850
allow user_crond_t user_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4850
allow user_crond_t user_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4850

#line 4850

#line 4850
type_transition user_crond_t tmp_t:dir user_tmp_t;
#line 4850
type_transition user_crond_t tmp_t:{ file lnk_file sock_file fifo_file } user_tmp_t;
#line 4850

#line 4850

#line 4850

#line 4850
# Run helper programs.
#line 4850

#line 4850
allow user_crond_t { bin_t sbin_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4850
allow user_crond_t { bin_t sbin_t etc_t }:lnk_file { getattr read };
#line 4850

#line 4850
allow user_crond_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4850
allow user_crond_t lib_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_crond_t ld_so_t:file { read getattr lock execute ioctl };
#line 4850
allow user_crond_t ld_so_t:file execute_no_trans;
#line 4850
allow user_crond_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_crond_t shlib_t:file { read getattr lock execute ioctl };
#line 4850
allow user_crond_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4850
allow user_crond_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4850
allow user_crond_t device_t:dir search;
#line 4850
allow user_crond_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4850

#line 4850

#line 4850
allow user_crond_t etc_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4850

#line 4850

#line 4850
allow user_crond_t lib_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4850

#line 4850

#line 4850
allow user_crond_t bin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4850

#line 4850

#line 4850
allow user_crond_t sbin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4850

#line 4850

#line 4850
allow user_crond_t exec_type:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4850

#line 4850

#line 4850

#line 4850
# Run scripts in user home directory.
#line 4850

#line 4850
allow user_crond_t user_home_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4850

#line 4850

#line 4850
# ps does not need to access /boot when run from cron
#line 4850
dontaudit user_crond_t boot_t:dir search;
#line 4850
# quiet other ps operations
#line 4850
dontaudit user_crond_t domain:dir getattr;
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
# Read the mouse.
#line 4850
allow user_t mouse_device_t:chr_file { read getattr lock ioctl };
#line 4850
# Access other miscellaneous devices.
#line 4850
allow user_t misc_device_t:{ file lnk_file sock_file fifo_file chr_file blk_file } { ioctl read getattr lock write append };
#line 4850

#line 4850
# Use the network.
#line 4850

#line 4850
#
#line 4850
# Allow the domain to create and use UDP and TCP sockets.
#line 4850
# Other kinds of sockets must be separately authorized for use.
#line 4850
allow user_t self:udp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4850
allow user_t self:tcp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4850

#line 4850
#
#line 4850
# Allow the domain to send UDP packets.
#line 4850
# Since the destination sockets type is unknown, the generic
#line 4850
# any_socket_t type is used as a placeholder.
#line 4850
#
#line 4850
allow user_t any_socket_t:udp_socket sendto;
#line 4850

#line 4850
#
#line 4850
# Allow the domain to send using any network interface.
#line 4850
# netif_type is a type attribute for all network interface types.
#line 4850
#
#line 4850
allow user_t netif_type:netif { tcp_send udp_send rawip_send };
#line 4850

#line 4850
#
#line 4850
# Allow packets sent by the domain to be received on any network interface.
#line 4850
#
#line 4850
allow user_t netif_type:netif { tcp_recv udp_recv rawip_recv };
#line 4850

#line 4850
#
#line 4850
# Allow the domain to receive packets from any network interface.
#line 4850
# netmsg_type is a type attribute for all default message types.
#line 4850
#
#line 4850
allow user_t netmsg_type:{ udp_socket tcp_socket rawip_socket } recvfrom;
#line 4850

#line 4850
#
#line 4850
# Allow the domain to initiate or accept TCP connections 
#line 4850
# on any network interface.
#line 4850
#
#line 4850
allow user_t netmsg_type:tcp_socket { connectto acceptfrom };
#line 4850

#line 4850
#
#line 4850
# Receive resets from the TCP reset socket.
#line 4850
# The TCP reset socket is labeled with the tcp_socket_t type.
#line 4850
#
#line 4850
allow user_t tcp_socket_t:tcp_socket recvfrom;
#line 4850

#line 4850
dontaudit user_t tcp_socket_t:tcp_socket connectto;
#line 4850

#line 4850
#
#line 4850
# Allow the domain to send to any node.
#line 4850
# node_type is a type attribute for all node types.
#line 4850
#
#line 4850
allow user_t node_type:node { tcp_send udp_send rawip_send };
#line 4850

#line 4850
#
#line 4850
# Allow packets sent by the domain to be received from any node.
#line 4850
#
#line 4850
allow user_t node_type:node { tcp_recv udp_recv rawip_recv };
#line 4850

#line 4850
#
#line 4850
# Allow the domain to send NFS client requests via the socket
#line 4850
# created by mount.
#line 4850
#
#line 4850
allow user_t mount_t:udp_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4850

#line 4850
#
#line 4850
# Bind to the default port type.
#line 4850
# Other port types must be separately authorized.
#line 4850
#
#line 4850
#allow user_t port_t:udp_socket name_bind;
#line 4850
#allow user_t port_t:tcp_socket name_bind;
#line 4850

#line 4850
# allow port_t name binding for UDP because it is not very usable otherwise
#line 4850
allow user_t port_t:udp_socket name_bind;
#line 4850
allow user_t resolv_conf_t:file { getattr read };
#line 4850
# for perl
#line 4850
dontaudit user_t resolv_conf_t:file ioctl;
#line 4850

#line 4850
#
#line 4850
# connect_secure and sendmsg_secure calls with a 
#line 4850
# peer or destination socket SID can be enforced
#line 4850
# when using the loopback interface.  Enforcement
#line 4850
# for real network interfaces will be possible when
#line 4850
# a packet labeling mechanism is integrated.
#line 4850
#
#line 4850
allow user_t node_lo_t:node enforce_dest;
#line 4850

#line 4850
# Communicate within the domain.
#line 4850

#line 4850
allow user_t user_t:udp_socket { sendto };
#line 4850
allow user_t user_t:udp_socket { recvfrom };
#line 4850

#line 4850

#line 4850
allow user_t user_t:tcp_socket { connectto recvfrom };
#line 4850
allow user_t user_t:tcp_socket { acceptfrom recvfrom };
#line 4850
allow user_t tcp_socket_t:tcp_socket { recvfrom };
#line 4850
allow user_t tcp_socket_t:tcp_socket { recvfrom };
#line 4850

#line 4850

#line 4850
# Connect to inetd.
#line 4850

#line 4850

#line 4850

#line 4850

#line 4850
# Connect data port to ftpd.
#line 4850

#line 4850

#line 4850
# Connect to portmap.
#line 4850

#line 4850

#line 4850
# Inherit and use sockets from inetd
#line 4850

#line 4850

#line 4850
# Allow system log read
#line 4850
#allow user_t kernel_t:system syslog_read;
#line 4850
# else do not log it
#line 4850
dontaudit user_t kernel_t:system syslog_read;
#line 4850

#line 4850
# Very permissive allowing every domain to see every type.
#line 4850
allow user_t kernel_t:system { ipc_info };
#line 4850

#line 4850
# When the user domain runs ps, there will be a number of access
#line 4850
# denials when ps tries to search /proc.  Do not audit these denials.
#line 4850
dontaudit user_t domain:dir { read getattr lock search ioctl };
#line 4850
dontaudit user_t domain:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4850

#line 4850
# Some shells ask for w access to utmp, but will operate
#line 4850
# correctly without it.  Do not audit write denials to utmp.
#line 4850
dontaudit user_t initrc_var_run_t:file { getattr read write };
#line 4850

#line 4850
# do not audit getattr on tmpfile, otherwise ls -l /tmp fills the logs
#line 4850
dontaudit user_t tmpfile:{ dir file lnk_file sock_file fifo_file chr_file blk_file } getattr;
#line 4850

#line 4850
# do not audit getattr on disk devices, otherwise KDE fills the logs
#line 4850
dontaudit user_t { removable_device_t fixed_disk_device_t }:blk_file getattr;
#line 4850

#line 4850

#line 4850
# Access the sound device.
#line 4850
allow user_t sound_device_t:chr_file { getattr read write ioctl };
#line 4850

#line 4850

#line 4850

#line 4850
# Get attributes of file systems.
#line 4850
allow user_t fs_type:filesystem getattr;
#line 4850

#line 4850
# Read and write /dev/tty and /dev/null.
#line 4850
allow user_t devtty_t:chr_file { ioctl read getattr lock write append };
#line 4850
allow user_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4850
allow user_t zero_device_t:chr_file { { ioctl read getattr lock write append } execute };
#line 4850
allow user_t random_device_t:chr_file { getattr read };
#line 4850

#line 4850
# Read the devpts root directory.
#line 4850
allow user_t devpts_t:dir { read getattr lock search ioctl };
#line 4850

#line 4850

#line 4850
# When an ordinary user domain runs su, su may try to
#line 4850
# update the /root/.Xauthority file, and the user shell may
#line 4850
# try to update the shell history. This isnt allowed, but 
#line 4850
# we dont need to audit it.
#line 4850

#line 4850
dontaudit user_su_t sysadm_home_t:dir  { read getattr search write add_name remove_name };
#line 4850
dontaudit user_su_t sysadm_home_t:file { read getattr create write link unlink };
#line 4850
dontaudit user_t    sysadm_home_t:dir { read search getattr };
#line 4850
dontaudit user_t    sysadm_home_t:file { read getattr append };
#line 4850

#line 4850

#line 4850
# Some programs that are left in user_t will try to connect
#line 4850
# to syslogd, but we do not want to let them generate log messages.
#line 4850
# Do not audit.
#line 4850
dontaudit user_t devlog_t:sock_file { read write };
#line 4850
dontaudit user_t syslogd_t:unix_dgram_socket sendto;
#line 4850

#line 4850

#line 4850
# stop warnings about "ls -l" on directories with unlabelled files
#line 4850
dontaudit user_t file_t:{ dir file lnk_file } getattr;
#line 4850


#  Do not add any rules referring to user_t to this file!  That will break
#  support for multiple user roles.

# a role for staff that allows seeing all domains and control over the user_t
# domain

#line 4857

#line 4857
# user_t/staff_t is an unprivileged users domain.
#line 4857
type staff_t, domain, userdomain, unpriv_userdomain, web_client_domain;
#line 4857

#line 4857
# staff_r is authorized for staff_t for the initial login domain.
#line 4857
role staff_r types staff_t;
#line 4857
allow system_r staff_r;
#line 4857

#line 4857
# Grant permissions within the domain.
#line 4857

#line 4857
# Access other processes in the same domain.
#line 4857
# Omits ptrace, setexec, and setfscreate.  These must be granted 
#line 4857
# separately if desired.
#line 4857
allow staff_t self:process ~{ptrace setexec setfscreate};
#line 4857

#line 4857
# Access /proc/PID files for processes in the same domain.
#line 4857
allow staff_t self:dir { read getattr lock search ioctl };
#line 4857
allow staff_t self:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4857

#line 4857
# Access file descriptions, pipes, and sockets
#line 4857
# created by processes in the same domain.
#line 4857
allow staff_t self:fd *;
#line 4857
allow staff_t self:fifo_file { ioctl read getattr lock write append };
#line 4857
allow staff_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4857
allow staff_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4857

#line 4857
# Allow the domain to communicate with other processes in the same domain.
#line 4857
allow staff_t self:unix_dgram_socket sendto;
#line 4857
allow staff_t self:unix_stream_socket connectto;
#line 4857

#line 4857
# Access System V IPC objects created by processes in the same domain.
#line 4857
allow staff_t self:sem  { associate getattr setattr create destroy read write unix_read unix_write };
#line 4857
allow staff_t self:msg  { send receive };
#line 4857
allow staff_t self:msgq { associate getattr setattr create destroy read write enqueue unix_read unix_write };
#line 4857
allow staff_t self:shm  { associate getattr setattr create destroy read write lock unix_read unix_write };
#line 4857
;
#line 4857

#line 4857
# Grant read/search permissions to some of /proc.
#line 4857
allow staff_t proc_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_t proc_t:{ file lnk_file } { read getattr lock ioctl };
#line 4857

#line 4857

#line 4857
# Read /.
#line 4857
allow staff_t root_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_t root_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4857

#line 4857
# Read /home.
#line 4857
allow staff_t home_root_t:dir { read getattr lock search ioctl };
#line 4857

#line 4857
# Read /usr.
#line 4857
allow staff_t usr_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_t usr_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4857

#line 4857
# Read bin and sbin directories.
#line 4857
allow staff_t bin_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_t bin_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4857
allow staff_t sbin_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_t sbin_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4857

#line 4857

#line 4857
# Read directories and files with the readable_t type.
#line 4857
# This type is a general type for "world"-readable files.
#line 4857
allow staff_t readable_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_t readable_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4857

#line 4857
# Stat /...security and lost+found.
#line 4857
allow staff_t file_labels_t:dir getattr;
#line 4857
allow staff_t lost_found_t:dir getattr;
#line 4857

#line 4857
# Read the /tmp directory and any /tmp files with the base type.
#line 4857
# Temporary files created at runtime will typically use derived types.
#line 4857
allow staff_t tmp_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_t tmp_t:{ file lnk_file } { read getattr lock ioctl };
#line 4857

#line 4857
# Read /var, /var/spool, /var/run.
#line 4857
allow staff_t var_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_t var_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4857
allow staff_t var_spool_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_t var_spool_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4857
allow staff_t var_run_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_t var_run_t:{ file lnk_file } { read getattr lock ioctl };
#line 4857

#line 4857
allow staff_t sysctl_kernel_t:dir search;
#line 4857
allow staff_t sysctl_kernel_t:file { getattr read };
#line 4857

#line 4857
# Read /etc.
#line 4857
allow staff_t etc_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_t etc_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4857
allow staff_t etc_runtime_t:{ file lnk_file } { read getattr lock ioctl };
#line 4857

#line 4857
# for running depmod as part of the kernel packaging process
#line 4857
allow staff_t modules_conf_t:file { getattr read };
#line 4857

#line 4857
# Read man directories and files.
#line 4857
allow staff_t man_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_t man_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4857

#line 4857
# Read /dev directories and any symbolic links.
#line 4857
allow staff_t device_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_t device_t:lnk_file { read getattr lock ioctl };
#line 4857

#line 4857
# Do not audit write denials to /etc/ld.so.cache.
#line 4857
dontaudit staff_t ld_so_cache_t:file write;
#line 4857

#line 4857
# Execute from the system shared libraries.
#line 4857

#line 4857
allow staff_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4857
allow staff_t lib_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_t ld_so_t:file { read getattr lock execute ioctl };
#line 4857
allow staff_t ld_so_t:file execute_no_trans;
#line 4857
allow staff_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_t shlib_t:file { read getattr lock execute ioctl };
#line 4857
allow staff_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4857
allow staff_t device_t:dir search;
#line 4857
allow staff_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4857
;
#line 4857

#line 4857
# staff_t is also granted permissions specific to user domains.
#line 4857

#line 4857
# Use capabilities
#line 4857
allow staff_t self:capability { setgid chown fowner };
#line 4857
dontaudit staff_t self:capability { sys_nice fsetid };
#line 4857

#line 4857
# Type for home directory.
#line 4857

#line 4857
type staff_home_dir_t, file_type, sysadmfile, home_dir_type, user_home_dir_type, home_type, user_home_type;
#line 4857
type staff_home_t, file_type, sysadmfile, home_type, user_home_type;
#line 4857
# do not allow privhome access to sysadm_home_dir_t
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
#
#line 4857
# Allow the process to modify the directory.
#line 4857
#
#line 4857
allow privhome staff_home_dir_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4857

#line 4857
#
#line 4857
# Allow the process to create the file.
#line 4857
#
#line 4857

#line 4857
allow privhome staff_home_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4857
allow privhome staff_home_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4857

#line 4857

#line 4857
type_transition privhome staff_home_dir_t:dir staff_home_t;
#line 4857
type_transition privhome staff_home_dir_t:{ file lnk_file sock_file fifo_file } staff_home_t;
#line 4857

#line 4857

#line 4857

#line 4857
type staff_tmp_t, file_type, sysadmfile, tmpfile , user_tmpfile;
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
#
#line 4857
# Allow the process to modify the directory.
#line 4857
#
#line 4857
allow staff_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4857

#line 4857
#
#line 4857
# Allow the process to create the file.
#line 4857
#
#line 4857

#line 4857
allow staff_t staff_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4857
allow staff_t staff_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4857

#line 4857

#line 4857
type_transition staff_t tmp_t:dir staff_tmp_t;
#line 4857
type_transition staff_t tmp_t:{ file lnk_file sock_file fifo_file } staff_tmp_t;
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
# allow ptrace
#line 4857
#can_ptrace(staff_t, staff_t)
#line 4857

#line 4857
# Create, access, and remove files in home directory.
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
#
#line 4857
# Allow the process to modify the directory.
#line 4857
#
#line 4857
allow staff_t staff_home_dir_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4857

#line 4857
#
#line 4857
# Allow the process to create the file.
#line 4857
#
#line 4857

#line 4857
allow staff_t staff_home_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4857
allow staff_t staff_home_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4857

#line 4857

#line 4857
type_transition staff_t staff_home_dir_t:dir staff_home_t;
#line 4857
type_transition staff_t staff_home_dir_t:{ file lnk_file sock_file fifo_file } staff_home_t;
#line 4857

#line 4857

#line 4857
allow staff_t staff_home_t:{ dir file lnk_file sock_file fifo_file chr_file blk_file } { relabelfrom relabelto };
#line 4857

#line 4857
# Bind to a Unix domain socket in /tmp.
#line 4857
allow staff_t staff_tmp_t:unix_stream_socket name_bind;
#line 4857

#line 4857
# Type for tty devices.
#line 4857
type staff_tty_device_t, file_type, sysadmfile, ttyfile;
#line 4857
# Access ttys.
#line 4857
allow staff_t privfd:fd use;
#line 4857
allow staff_t staff_tty_device_t:chr_file { setattr { ioctl read getattr lock write append } };
#line 4857
# Use the type when relabeling terminal devices.
#line 4857
type_change staff_t tty_device_t:chr_file staff_tty_device_t;
#line 4857

#line 4857
# read localization information
#line 4857

#line 4857
allow staff_t etc_t:lnk_file read;
#line 4857

#line 4857
allow staff_t locale_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
# Type and access for pty devices.
#line 4857

#line 4857

#line 4857

#line 4857
# Access the pty master multiplexer.
#line 4857
allow staff_t ptmx_t:chr_file { ioctl read getattr lock write append };
#line 4857

#line 4857

#line 4857
allow staff_t devpts_t:filesystem getattr;
#line 4857

#line 4857
# allow searching /dev/pts
#line 4857
allow staff_t devpts_t:dir { getattr read search };
#line 4857

#line 4857

#line 4857
type staff_devpts_t, file_type, sysadmfile, ptyfile , userpty_type;
#line 4857

#line 4857
# Allow the pty to be associated with the file system.
#line 4857
allow staff_devpts_t devpts_t:filesystem associate;
#line 4857

#line 4857
# Label pty files with a derived type.
#line 4857
type_transition staff_t devpts_t:chr_file staff_devpts_t;
#line 4857

#line 4857
# Read and write my pty files.
#line 4857
allow staff_t staff_devpts_t:chr_file { setattr { ioctl read getattr lock write append } };
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
# Use the type when relabeling pty devices.
#line 4857
type_change staff_t server_pty:chr_file staff_devpts_t;
#line 4857

#line 4857

#line 4857
# Connect to sshd.
#line 4857

#line 4857
allow staff_t sshd_t:tcp_socket { connectto recvfrom };
#line 4857
allow sshd_t staff_t:tcp_socket { acceptfrom recvfrom };
#line 4857
allow sshd_t tcp_socket_t:tcp_socket { recvfrom };
#line 4857
allow staff_t tcp_socket_t:tcp_socket { recvfrom };
#line 4857

#line 4857

#line 4857
# Connect to ssh proxy.
#line 4857

#line 4857
allow staff_t staff_ssh_t:tcp_socket { connectto recvfrom };
#line 4857
allow staff_ssh_t staff_t:tcp_socket { acceptfrom recvfrom };
#line 4857
allow staff_ssh_t tcp_socket_t:tcp_socket { recvfrom };
#line 4857
allow staff_t tcp_socket_t:tcp_socket { recvfrom };
#line 4857

#line 4857

#line 4857
allow staff_t sshd_t:fd use;
#line 4857
allow staff_t sshd_t:tcp_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4857
# inheriting stream sockets is needed for "ssh host command"
#line 4857
allow staff_t sshd_t:unix_stream_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4857

#line 4857
# for ifconfig which is run all the time
#line 4857
dontaudit staff_t sysctl_t:dir search;
#line 4857

#line 4857
allow staff_t boot_t:dir { getattr search };
#line 4857
dontaudit staff_t boot_t:dir read;
#line 4857
dontaudit staff_t boot_t:lnk_file getattr;
#line 4857
dontaudit staff_t boot_t:file { getattr read };
#line 4857
allow staff_t system_map_t:file { getattr read };
#line 4857

#line 4857

#line 4857
type staff_tmpfs_t, file_type, sysadmfile, tmpfsfile;
#line 4857
# Use this type when creating tmpfs/shm objects.
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
#
#line 4857
# Allow the process to modify the directory.
#line 4857
#
#line 4857
allow staff_t tmpfs_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4857

#line 4857
#
#line 4857
# Allow the process to create the file.
#line 4857
#
#line 4857

#line 4857
allow staff_t staff_tmpfs_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4857
allow staff_t staff_tmpfs_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4857

#line 4857

#line 4857
type_transition staff_t tmpfs_t:dir staff_tmpfs_t;
#line 4857
type_transition staff_t tmpfs_t:{ file lnk_file sock_file fifo_file } staff_tmpfs_t;
#line 4857

#line 4857

#line 4857
allow staff_tmpfs_t tmpfs_t:filesystem associate;
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
# Read and write /var/catman.
#line 4857
allow staff_t catman_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4857
allow staff_t catman_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4857

#line 4857
# Modify mail spool file.
#line 4857
allow staff_t mail_spool_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_t mail_spool_t:file { ioctl read getattr lock write append };
#line 4857
allow staff_t mail_spool_t:lnk_file read;
#line 4857

#line 4857
#
#line 4857
# Allow the query of filesystem quotas
#line 4857
#
#line 4857
allow staff_t fs_type:filesystem quotaget;
#line 4857

#line 4857
# Run helper programs.
#line 4857

#line 4857
allow staff_t { bin_t sbin_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4857
allow staff_t { bin_t sbin_t etc_t }:lnk_file { getattr read };
#line 4857

#line 4857
allow staff_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4857
allow staff_t lib_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_t ld_so_t:file { read getattr lock execute ioctl };
#line 4857
allow staff_t ld_so_t:file execute_no_trans;
#line 4857
allow staff_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_t shlib_t:file { read getattr lock execute ioctl };
#line 4857
allow staff_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4857
allow staff_t device_t:dir search;
#line 4857
allow staff_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4857

#line 4857

#line 4857
allow staff_t etc_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4857

#line 4857

#line 4857
allow staff_t lib_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4857

#line 4857

#line 4857
allow staff_t bin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4857

#line 4857

#line 4857
allow staff_t sbin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4857

#line 4857

#line 4857
allow staff_t exec_type:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4857

#line 4857

#line 4857
# Run programs developed by other users in the same domain.
#line 4857

#line 4857
allow staff_t staff_home_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4857

#line 4857

#line 4857
allow staff_t staff_tmp_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4857

#line 4857

#line 4857
# Run user programs that require different permissions in their own domain.
#line 4857
# These rules were moved into the individual program domains.
#line 4857

#line 4857
# Instantiate derived domains for a number of programs.
#line 4857
# These derived domains encode both information about the calling
#line 4857
# user domain and the program, and allow us to maintain separation
#line 4857
# between different instances of the program being run by different
#line 4857
# user domains.
#line 4857

#line 4857

#line 4857

#line 4857
# Derived domain based on the calling user domain and the program.
#line 4857
type staff_su_t, domain, privlog, auth;
#line 4857

#line 4857
# Transition from the user domain to this domain.
#line 4857

#line 4857

#line 4857

#line 4857
#
#line 4857
# Allow the process to transition to the new domain.
#line 4857
#
#line 4857
allow staff_t staff_su_t:process transition;
#line 4857

#line 4857
#
#line 4857
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4857
#
#line 4857
dontaudit staff_t staff_su_t:process noatsecure;
#line 4857

#line 4857
#
#line 4857
# Allow the process to execute the program.
#line 4857
# 
#line 4857
allow staff_t su_exec_t:file { read { getattr execute } };
#line 4857

#line 4857
#
#line 4857
# Allow the process to reap the new domain.
#line 4857
#
#line 4857
allow staff_su_t staff_t:process sigchld;
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to inherit and use file 
#line 4857
# descriptions from the creating process and vice versa.
#line 4857
#
#line 4857
allow staff_su_t staff_t:fd use;
#line 4857
allow staff_t staff_su_t:fd use;
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to write back to the old domain via a pipe.
#line 4857
#
#line 4857
allow staff_su_t staff_t:fifo_file { ioctl read getattr lock write append };
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to read and execute the program.
#line 4857
#
#line 4857
allow staff_su_t su_exec_t:file { read getattr lock execute ioctl };
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to be entered via the program.
#line 4857
#
#line 4857
allow staff_su_t su_exec_t:file entrypoint;
#line 4857

#line 4857
type_transition staff_t su_exec_t:process staff_su_t;
#line 4857

#line 4857

#line 4857

#line 4857
allow staff_su_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4857
allow staff_su_t lib_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_su_t ld_so_t:file { read getattr lock execute ioctl };
#line 4857
allow staff_su_t ld_so_t:file execute_no_trans;
#line 4857
allow staff_su_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_su_t shlib_t:file { read getattr lock execute ioctl };
#line 4857
allow staff_su_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_su_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4857
allow staff_su_t device_t:dir search;
#line 4857
allow staff_su_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4857

#line 4857
allow staff_su_t etc_t:file { getattr read };
#line 4857

#line 4857
allow staff_su_t etc_t:lnk_file read;
#line 4857

#line 4857
allow staff_su_t locale_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_su_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 4857

#line 4857

#line 4857
allow staff_su_t self:unix_dgram_socket { connect create write };
#line 4857
allow staff_su_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4857
allow staff_su_t proc_t:dir search;
#line 4857
allow staff_su_t proc_t:lnk_file read;
#line 4857

#line 4857
allow staff_su_t self:dir { read getattr lock search ioctl };
#line 4857
allow staff_su_t self:{ file lnk_file } { read getattr lock ioctl };
#line 4857

#line 4857
allow staff_su_t self:process setsched;
#line 4857
allow staff_su_t device_t:dir search;
#line 4857
allow staff_su_t self:process { fork sigchld };
#line 4857

#line 4857
# Use capabilities.
#line 4857
allow staff_su_t self:capability { setuid setgid net_bind_service chown dac_override sys_nice sys_resource };
#line 4857

#line 4857
# Revert to the user domain when a shell is executed.
#line 4857

#line 4857

#line 4857

#line 4857
#
#line 4857
# Allow the process to transition to the new domain.
#line 4857
#
#line 4857
allow staff_su_t staff_t:process transition;
#line 4857

#line 4857
#
#line 4857
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4857
#
#line 4857
dontaudit staff_su_t staff_t:process noatsecure;
#line 4857

#line 4857
#
#line 4857
# Allow the process to execute the program.
#line 4857
# 
#line 4857
allow staff_su_t shell_exec_t:file { read { getattr execute } };
#line 4857

#line 4857
#
#line 4857
# Allow the process to reap the new domain.
#line 4857
#
#line 4857
allow staff_t staff_su_t:process sigchld;
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to inherit and use file 
#line 4857
# descriptions from the creating process and vice versa.
#line 4857
#
#line 4857
allow staff_t staff_su_t:fd use;
#line 4857
allow staff_su_t staff_t:fd use;
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to write back to the old domain via a pipe.
#line 4857
#
#line 4857
allow staff_t staff_su_t:fifo_file { ioctl read getattr lock write append };
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to read and execute the program.
#line 4857
#
#line 4857
allow staff_t shell_exec_t:file { read getattr lock execute ioctl };
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to be entered via the program.
#line 4857
#
#line 4857
allow staff_t shell_exec_t:file entrypoint;
#line 4857

#line 4857
type_transition staff_su_t shell_exec_t:process staff_t;
#line 4857

#line 4857
allow staff_su_t bin_t:dir search;
#line 4857
allow staff_su_t bin_t:lnk_file read;
#line 4857

#line 4857
allow staff_su_t privfd:fd use;
#line 4857

#line 4857
# Write to utmp.
#line 4857
allow staff_su_t { var_t var_run_t }:dir search;
#line 4857
allow staff_su_t initrc_var_run_t:file { ioctl read getattr lock write append };
#line 4857

#line 4857

#line 4857

#line 4857
# Run chkpwd.
#line 4857

#line 4857
allow staff_su_t chkpwd_exec_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4857

#line 4857

#line 4857

#line 4857
# Inherit and use descriptors from gnome-pty-helper.
#line 4857

#line 4857

#line 4857
# The user role is authorized for this domain.
#line 4857
role staff_r types staff_su_t;
#line 4857

#line 4857
# Write to the user domain tty.
#line 4857
allow staff_su_t staff_tty_device_t:chr_file { ioctl read getattr lock write append };
#line 4857
allow staff_su_t staff_devpts_t:chr_file { ioctl read getattr lock write append };
#line 4857

#line 4857
allow staff_su_t { home_root_t staff_home_dir_t }:dir search;
#line 4857

#line 4857
# Modify .Xauthority file (via xauth program).
#line 4857

#line 4857

#line 4857
# Access sshd cookie files.
#line 4857
allow staff_su_t sshd_tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4857
allow staff_su_t sshd_tmp_t:file { ioctl read getattr lock write append };
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
#
#line 4857
# Allow the process to modify the directory.
#line 4857
#
#line 4857
allow staff_su_t sshd_tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4857

#line 4857
#
#line 4857
# Allow the process to create the file.
#line 4857
#
#line 4857

#line 4857
allow staff_su_t staff_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4857
allow staff_su_t staff_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4857

#line 4857

#line 4857
type_transition staff_su_t sshd_tmp_t:dir staff_tmp_t;
#line 4857
type_transition staff_su_t sshd_tmp_t:{ file lnk_file sock_file fifo_file } staff_tmp_t;
#line 4857

#line 4857

#line 4857

#line 4857
# stop su complaining if you run it from a directory with restrictive perms
#line 4857
dontaudit staff_su_t file_type:dir search;
#line 4857

#line 4857

#line 4857
# Derived domain based on the calling user domain and the program.
#line 4857
type staff_chkpwd_t, domain, privlog, auth;
#line 4857

#line 4857
# Transition from the user domain to this domain.
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
#
#line 4857
# Allow the process to transition to the new domain.
#line 4857
#
#line 4857
allow staff_t staff_chkpwd_t:process transition;
#line 4857

#line 4857
#
#line 4857
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4857
#
#line 4857
dontaudit staff_t staff_chkpwd_t:process noatsecure;
#line 4857

#line 4857
#
#line 4857
# Allow the process to execute the program.
#line 4857
# 
#line 4857
allow staff_t chkpwd_exec_t:file { read { getattr execute } };
#line 4857

#line 4857
#
#line 4857
# Allow the process to reap the new domain.
#line 4857
#
#line 4857
allow staff_chkpwd_t staff_t:process sigchld;
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to inherit and use file 
#line 4857
# descriptions from the creating process and vice versa.
#line 4857
#
#line 4857
allow staff_chkpwd_t staff_t:fd use;
#line 4857
allow staff_t staff_chkpwd_t:fd use;
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to write back to the old domain via a pipe.
#line 4857
#
#line 4857
allow staff_chkpwd_t staff_t:fifo_file { ioctl read getattr lock write append };
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to read and execute the program.
#line 4857
#
#line 4857
allow staff_chkpwd_t chkpwd_exec_t:file { read getattr lock execute ioctl };
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to be entered via the program.
#line 4857
#
#line 4857
allow staff_chkpwd_t chkpwd_exec_t:file entrypoint;
#line 4857

#line 4857
type_transition staff_t chkpwd_exec_t:process staff_chkpwd_t;
#line 4857

#line 4857

#line 4857
# The user role is authorized for this domain.
#line 4857
role staff_r types staff_chkpwd_t;
#line 4857

#line 4857
# Write to the user domain tty.
#line 4857
allow staff_chkpwd_t staff_tty_device_t:chr_file { ioctl read getattr lock write append };
#line 4857
allow staff_chkpwd_t staff_devpts_t:chr_file { ioctl read getattr lock write append };
#line 4857

#line 4857
# Inherit and use descriptors from gnome-pty-helper.
#line 4857

#line 4857

#line 4857
# Inherit and use descriptors from newrole.
#line 4857
allow staff_chkpwd_t newrole_t:fd use;
#line 4857

#line 4857

#line 4857

#line 4857
allow staff_chkpwd_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4857
allow staff_chkpwd_t lib_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_chkpwd_t ld_so_t:file { read getattr lock execute ioctl };
#line 4857
allow staff_chkpwd_t ld_so_t:file execute_no_trans;
#line 4857
allow staff_chkpwd_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_chkpwd_t shlib_t:file { read getattr lock execute ioctl };
#line 4857
allow staff_chkpwd_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_chkpwd_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4857
allow staff_chkpwd_t device_t:dir search;
#line 4857
allow staff_chkpwd_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4857

#line 4857
allow staff_chkpwd_t etc_t:file { getattr read };
#line 4857
allow staff_chkpwd_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4857
allow staff_chkpwd_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4857

#line 4857
allow staff_chkpwd_t etc_t:lnk_file read;
#line 4857

#line 4857
allow staff_chkpwd_t locale_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_chkpwd_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 4857

#line 4857

#line 4857

#line 4857
# Use capabilities.
#line 4857
allow staff_chkpwd_t self:capability setuid;
#line 4857

#line 4857
# for nscd
#line 4857
dontaudit staff_chkpwd_t var_t:dir search;
#line 4857

#line 4857
dontaudit staff_chkpwd_t fs_t:filesystem getattr;
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857

#line 4857

#line 4857

#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
# Derived domain based on the calling user domain and the program.
#line 4857
type staff_crontab_t, domain, privlog;
#line 4857

#line 4857
# Transition from the user domain to the derived domain.
#line 4857

#line 4857

#line 4857

#line 4857
#
#line 4857
# Allow the process to transition to the new domain.
#line 4857
#
#line 4857
allow staff_t staff_crontab_t:process transition;
#line 4857

#line 4857
#
#line 4857
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4857
#
#line 4857
dontaudit staff_t staff_crontab_t:process noatsecure;
#line 4857

#line 4857
#
#line 4857
# Allow the process to execute the program.
#line 4857
# 
#line 4857
allow staff_t crontab_exec_t:file { read { getattr execute } };
#line 4857

#line 4857
#
#line 4857
# Allow the process to reap the new domain.
#line 4857
#
#line 4857
allow staff_crontab_t staff_t:process sigchld;
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to inherit and use file 
#line 4857
# descriptions from the creating process and vice versa.
#line 4857
#
#line 4857
allow staff_crontab_t staff_t:fd use;
#line 4857
allow staff_t staff_crontab_t:fd use;
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to write back to the old domain via a pipe.
#line 4857
#
#line 4857
allow staff_crontab_t staff_t:fifo_file { ioctl read getattr lock write append };
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to read and execute the program.
#line 4857
#
#line 4857
allow staff_crontab_t crontab_exec_t:file { read getattr lock execute ioctl };
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to be entered via the program.
#line 4857
#
#line 4857
allow staff_crontab_t crontab_exec_t:file entrypoint;
#line 4857

#line 4857
type_transition staff_t crontab_exec_t:process staff_crontab_t;
#line 4857

#line 4857

#line 4857
# The user role is authorized for this domain.
#line 4857
role staff_r types staff_crontab_t;
#line 4857

#line 4857

#line 4857
allow staff_crontab_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4857
allow staff_crontab_t lib_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_crontab_t ld_so_t:file { read getattr lock execute ioctl };
#line 4857
allow staff_crontab_t ld_so_t:file execute_no_trans;
#line 4857
allow staff_crontab_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_crontab_t shlib_t:file { read getattr lock execute ioctl };
#line 4857
allow staff_crontab_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_crontab_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4857
allow staff_crontab_t device_t:dir search;
#line 4857
allow staff_crontab_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4857

#line 4857
allow staff_crontab_t etc_t:file { getattr read };
#line 4857
allow staff_crontab_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4857
allow staff_crontab_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4857

#line 4857
allow staff_crontab_t etc_t:lnk_file read;
#line 4857

#line 4857
allow staff_crontab_t locale_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_crontab_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 4857

#line 4857

#line 4857

#line 4857
# Use capabilities dac_override is to create the file in the directory
#line 4857
# under /tmp
#line 4857
allow staff_crontab_t staff_crontab_t:capability { setuid setgid chown dac_override };
#line 4857

#line 4857
# Type for temporary files.
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
#
#line 4857
# Allow the process to modify the directory.
#line 4857
#
#line 4857
allow staff_crontab_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4857

#line 4857
#
#line 4857
# Allow the process to create the file.
#line 4857
#
#line 4857

#line 4857

#line 4857
allow staff_crontab_t staff_tmp_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 4857

#line 4857

#line 4857
type_transition staff_crontab_t tmp_t:file staff_tmp_t;
#line 4857

#line 4857

#line 4857

#line 4857
# Type of user crontabs once moved to cron spool.
#line 4857
type staff_cron_spool_t, file_type, sysadmfile;
#line 4857
# Use the type when creating files in /var/spool/cron.
#line 4857
allow sysadm_crontab_t staff_cron_spool_t:file { getattr read };
#line 4857
allow staff_crontab_t { var_t var_spool_t }:dir search;
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
#
#line 4857
# Allow the process to modify the directory.
#line 4857
#
#line 4857
allow staff_crontab_t cron_spool_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4857

#line 4857
#
#line 4857
# Allow the process to create the file.
#line 4857
#
#line 4857

#line 4857

#line 4857
allow staff_crontab_t staff_cron_spool_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 4857

#line 4857

#line 4857
type_transition staff_crontab_t cron_spool_t:file staff_cron_spool_t;
#line 4857

#line 4857

#line 4857
allow staff_crontab_t self:process { fork { sigchld sigkill sigstop signull signal } };
#line 4857

#line 4857
# crontab signals crond by updating the mtime on the spooldir
#line 4857
allow staff_crontab_t cron_spool_t:dir setattr;
#line 4857
# Allow crond to read those crontabs in cron spool.
#line 4857
allow crond_t staff_cron_spool_t:file { read getattr lock ioctl };
#line 4857

#line 4857
# Run helper programs as staff_t
#line 4857
allow staff_crontab_t { bin_t sbin_t }:dir search;
#line 4857
allow staff_crontab_t bin_t:lnk_file read;
#line 4857

#line 4857

#line 4857

#line 4857
#
#line 4857
# Allow the process to transition to the new domain.
#line 4857
#
#line 4857
allow staff_crontab_t staff_t:process transition;
#line 4857

#line 4857
#
#line 4857
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4857
#
#line 4857
dontaudit staff_crontab_t staff_t:process noatsecure;
#line 4857

#line 4857
#
#line 4857
# Allow the process to execute the program.
#line 4857
# 
#line 4857
allow staff_crontab_t { bin_t sbin_t shell_exec_t }:file { read { getattr execute } };
#line 4857

#line 4857
#
#line 4857
# Allow the process to reap the new domain.
#line 4857
#
#line 4857
allow staff_t staff_crontab_t:process sigchld;
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to inherit and use file 
#line 4857
# descriptions from the creating process and vice versa.
#line 4857
#
#line 4857
allow staff_t staff_crontab_t:fd use;
#line 4857
allow staff_crontab_t staff_t:fd use;
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to write back to the old domain via a pipe.
#line 4857
#
#line 4857
allow staff_t staff_crontab_t:fifo_file { ioctl read getattr lock write append };
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to read and execute the program.
#line 4857
#
#line 4857
allow staff_t { bin_t sbin_t shell_exec_t }:file { read getattr lock execute ioctl };
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to be entered via the program.
#line 4857
#
#line 4857
allow staff_t { bin_t sbin_t shell_exec_t }:file entrypoint;
#line 4857

#line 4857
type_transition staff_crontab_t { bin_t sbin_t shell_exec_t }:process staff_t;
#line 4857

#line 4857

#line 4857
# Read user crontabs 
#line 4857
allow staff_crontab_t { staff_home_t staff_home_dir_t }:dir { read getattr lock search ioctl };  
#line 4857
allow staff_crontab_t staff_home_t:file { read getattr lock ioctl };  
#line 4857
dontaudit staff_crontab_t staff_home_dir_t:dir write;
#line 4857

#line 4857
# Access the cron log file.
#line 4857
allow staff_crontab_t crond_log_t:file { read getattr lock ioctl };
#line 4857
allow staff_crontab_t crond_log_t:file { append };
#line 4857

#line 4857
# Access terminals.
#line 4857
allow staff_crontab_t device_t:dir search;
#line 4857
allow staff_crontab_t staff_tty_device_t:chr_file { ioctl read getattr lock write append };
#line 4857
allow staff_crontab_t staff_devpts_t:chr_file { ioctl read getattr lock write append };
#line 4857

#line 4857
allow staff_crontab_t fs_t:filesystem getattr;
#line 4857

#line 4857
# Inherit and use descriptors from gnome-pty-helper.
#line 4857

#line 4857
allow staff_crontab_t privfd:fd use;
#line 4857

#line 4857
dontaudit staff_crontab_t var_run_t:dir search;
#line 4857

#line 4857

#line 4857
# Derived domain based on the calling user domain and the program.
#line 4857
type staff_ssh_t, domain, privlog;
#line 4857

#line 4857
# Transition from the user domain to the derived domain.
#line 4857

#line 4857

#line 4857

#line 4857
#
#line 4857
# Allow the process to transition to the new domain.
#line 4857
#
#line 4857
allow staff_t staff_ssh_t:process transition;
#line 4857

#line 4857
#
#line 4857
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4857
#
#line 4857
dontaudit staff_t staff_ssh_t:process noatsecure;
#line 4857

#line 4857
#
#line 4857
# Allow the process to execute the program.
#line 4857
# 
#line 4857
allow staff_t ssh_exec_t:file { read { getattr execute } };
#line 4857

#line 4857
#
#line 4857
# Allow the process to reap the new domain.
#line 4857
#
#line 4857
allow staff_ssh_t staff_t:process sigchld;
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to inherit and use file 
#line 4857
# descriptions from the creating process and vice versa.
#line 4857
#
#line 4857
allow staff_ssh_t staff_t:fd use;
#line 4857
allow staff_t staff_ssh_t:fd use;
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to write back to the old domain via a pipe.
#line 4857
#
#line 4857
allow staff_ssh_t staff_t:fifo_file { ioctl read getattr lock write append };
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to read and execute the program.
#line 4857
#
#line 4857
allow staff_ssh_t ssh_exec_t:file { read getattr lock execute ioctl };
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to be entered via the program.
#line 4857
#
#line 4857
allow staff_ssh_t ssh_exec_t:file entrypoint;
#line 4857

#line 4857
type_transition staff_t ssh_exec_t:process staff_ssh_t;
#line 4857

#line 4857

#line 4857
# The user role is authorized for this domain.
#line 4857
role staff_r types staff_ssh_t;
#line 4857

#line 4857
# Grant permissions within the domain.
#line 4857

#line 4857
# Access other processes in the same domain.
#line 4857
# Omits ptrace, setexec, and setfscreate.  These must be granted 
#line 4857
# separately if desired.
#line 4857
allow staff_ssh_t self:process ~{ptrace setexec setfscreate};
#line 4857

#line 4857
# Access /proc/PID files for processes in the same domain.
#line 4857
allow staff_ssh_t self:dir { read getattr lock search ioctl };
#line 4857
allow staff_ssh_t self:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4857

#line 4857
# Access file descriptions, pipes, and sockets
#line 4857
# created by processes in the same domain.
#line 4857
allow staff_ssh_t self:fd *;
#line 4857
allow staff_ssh_t self:fifo_file { ioctl read getattr lock write append };
#line 4857
allow staff_ssh_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4857
allow staff_ssh_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4857

#line 4857
# Allow the domain to communicate with other processes in the same domain.
#line 4857
allow staff_ssh_t self:unix_dgram_socket sendto;
#line 4857
allow staff_ssh_t self:unix_stream_socket connectto;
#line 4857

#line 4857
# Access System V IPC objects created by processes in the same domain.
#line 4857
allow staff_ssh_t self:sem  { associate getattr setattr create destroy read write unix_read unix_write };
#line 4857
allow staff_ssh_t self:msg  { send receive };
#line 4857
allow staff_ssh_t self:msgq { associate getattr setattr create destroy read write enqueue unix_read unix_write };
#line 4857
allow staff_ssh_t self:shm  { associate getattr setattr create destroy read write lock unix_read unix_write };
#line 4857

#line 4857

#line 4857
# Use descriptors created by sshd
#line 4857
allow staff_ssh_t privfd:fd use;
#line 4857

#line 4857

#line 4857
allow staff_ssh_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4857
allow staff_ssh_t lib_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_ssh_t ld_so_t:file { read getattr lock execute ioctl };
#line 4857
allow staff_ssh_t ld_so_t:file execute_no_trans;
#line 4857
allow staff_ssh_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_ssh_t shlib_t:file { read getattr lock execute ioctl };
#line 4857
allow staff_ssh_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_ssh_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4857
allow staff_ssh_t device_t:dir search;
#line 4857
allow staff_ssh_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4857

#line 4857

#line 4857
allow staff_ssh_t etc_t:lnk_file read;
#line 4857

#line 4857
allow staff_ssh_t locale_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_ssh_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 4857

#line 4857

#line 4857

#line 4857
# Get attributes of file systems.
#line 4857
allow staff_ssh_t fs_type:filesystem getattr;
#line 4857

#line 4857

#line 4857
# Read /.
#line 4857
allow staff_ssh_t root_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_ssh_t root_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4857

#line 4857
# Read /home.
#line 4857
allow staff_ssh_t home_root_t:dir { read getattr lock search ioctl };
#line 4857

#line 4857
# Read /usr.
#line 4857
allow staff_ssh_t usr_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_ssh_t usr_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4857

#line 4857
# Read bin and sbin directories.
#line 4857
allow staff_ssh_t bin_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_ssh_t bin_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4857
allow staff_ssh_t sbin_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_ssh_t sbin_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4857

#line 4857

#line 4857
# Read the devpts root directory.
#line 4857
allow staff_ssh_t devpts_t:dir { read getattr lock search ioctl };
#line 4857

#line 4857
# Read /var.
#line 4857
allow staff_ssh_t var_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_ssh_t var_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4857

#line 4857
# Read /var/run, /var/log.
#line 4857
allow staff_ssh_t var_run_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_ssh_t var_run_t:{ file lnk_file } { read getattr lock ioctl };
#line 4857
allow staff_ssh_t var_log_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_ssh_t var_log_t:{ file lnk_file } { read getattr lock ioctl };
#line 4857

#line 4857
# Read /etc.
#line 4857
allow staff_ssh_t etc_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_ssh_t etc_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4857
allow staff_ssh_t etc_runtime_t:{ file lnk_file } { read getattr lock ioctl };
#line 4857
allow staff_ssh_t resolv_conf_t:{ file lnk_file } { read getattr lock ioctl };
#line 4857

#line 4857
# Read the linker, shared library, and executable types.
#line 4857
allow staff_ssh_t ld_so_t:{ file lnk_file } { read getattr lock ioctl };
#line 4857
allow staff_ssh_t shlib_t:{ file lnk_file } { read getattr lock ioctl };
#line 4857
allow staff_ssh_t exec_type:{ file lnk_file } { read getattr lock ioctl };
#line 4857

#line 4857
# Read /dev directories and any symbolic links.
#line 4857
allow staff_ssh_t device_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_ssh_t device_t:lnk_file { read getattr lock ioctl };
#line 4857

#line 4857
# Read /dev/random.
#line 4857
allow staff_ssh_t random_device_t:chr_file { read getattr lock ioctl };
#line 4857

#line 4857
# Read and write /dev/tty and /dev/null.
#line 4857
allow staff_ssh_t devtty_t:chr_file { ioctl read getattr lock write append };
#line 4857
allow staff_ssh_t { null_device_t zero_device_t }:chr_file { ioctl read getattr lock write append };
#line 4857

#line 4857
# Grant permissions needed to create TCP and UDP sockets and
#line 4857
# to access the network.
#line 4857

#line 4857
#
#line 4857
# Allow the domain to create and use UDP and TCP sockets.
#line 4857
# Other kinds of sockets must be separately authorized for use.
#line 4857
allow staff_ssh_t self:udp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4857
allow staff_ssh_t self:tcp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4857

#line 4857
#
#line 4857
# Allow the domain to send UDP packets.
#line 4857
# Since the destination sockets type is unknown, the generic
#line 4857
# any_socket_t type is used as a placeholder.
#line 4857
#
#line 4857
allow staff_ssh_t any_socket_t:udp_socket sendto;
#line 4857

#line 4857
#
#line 4857
# Allow the domain to send using any network interface.
#line 4857
# netif_type is a type attribute for all network interface types.
#line 4857
#
#line 4857
allow staff_ssh_t netif_type:netif { tcp_send udp_send rawip_send };
#line 4857

#line 4857
#
#line 4857
# Allow packets sent by the domain to be received on any network interface.
#line 4857
#
#line 4857
allow staff_ssh_t netif_type:netif { tcp_recv udp_recv rawip_recv };
#line 4857

#line 4857
#
#line 4857
# Allow the domain to receive packets from any network interface.
#line 4857
# netmsg_type is a type attribute for all default message types.
#line 4857
#
#line 4857
allow staff_ssh_t netmsg_type:{ udp_socket tcp_socket rawip_socket } recvfrom;
#line 4857

#line 4857
#
#line 4857
# Allow the domain to initiate or accept TCP connections 
#line 4857
# on any network interface.
#line 4857
#
#line 4857
allow staff_ssh_t netmsg_type:tcp_socket { connectto acceptfrom };
#line 4857

#line 4857
#
#line 4857
# Receive resets from the TCP reset socket.
#line 4857
# The TCP reset socket is labeled with the tcp_socket_t type.
#line 4857
#
#line 4857
allow staff_ssh_t tcp_socket_t:tcp_socket recvfrom;
#line 4857

#line 4857
dontaudit staff_ssh_t tcp_socket_t:tcp_socket connectto;
#line 4857

#line 4857
#
#line 4857
# Allow the domain to send to any node.
#line 4857
# node_type is a type attribute for all node types.
#line 4857
#
#line 4857
allow staff_ssh_t node_type:node { tcp_send udp_send rawip_send };
#line 4857

#line 4857
#
#line 4857
# Allow packets sent by the domain to be received from any node.
#line 4857
#
#line 4857
allow staff_ssh_t node_type:node { tcp_recv udp_recv rawip_recv };
#line 4857

#line 4857
#
#line 4857
# Allow the domain to send NFS client requests via the socket
#line 4857
# created by mount.
#line 4857
#
#line 4857
allow staff_ssh_t mount_t:udp_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4857

#line 4857
#
#line 4857
# Bind to the default port type.
#line 4857
# Other port types must be separately authorized.
#line 4857
#
#line 4857
#allow staff_ssh_t port_t:udp_socket name_bind;
#line 4857
#allow staff_ssh_t port_t:tcp_socket name_bind;
#line 4857

#line 4857

#line 4857
# for sshing to a ssh tunnel
#line 4857

#line 4857
allow staff_ssh_t staff_ssh_t:tcp_socket { connectto recvfrom };
#line 4857
allow staff_ssh_t staff_ssh_t:tcp_socket { acceptfrom recvfrom };
#line 4857
allow staff_ssh_t tcp_socket_t:tcp_socket { recvfrom };
#line 4857
allow staff_ssh_t tcp_socket_t:tcp_socket { recvfrom };
#line 4857

#line 4857

#line 4857
# Use capabilities.
#line 4857
allow staff_ssh_t self:capability { setuid setgid dac_override dac_read_search };
#line 4857

#line 4857
# Run helpers.
#line 4857

#line 4857
allow staff_ssh_t { bin_t sbin_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4857
allow staff_ssh_t { bin_t sbin_t etc_t }:lnk_file { getattr read };
#line 4857

#line 4857
allow staff_ssh_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4857
allow staff_ssh_t lib_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_ssh_t ld_so_t:file { read getattr lock execute ioctl };
#line 4857
allow staff_ssh_t ld_so_t:file execute_no_trans;
#line 4857
allow staff_ssh_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_ssh_t shlib_t:file { read getattr lock execute ioctl };
#line 4857
allow staff_ssh_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_ssh_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4857
allow staff_ssh_t device_t:dir search;
#line 4857
allow staff_ssh_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4857

#line 4857

#line 4857
allow staff_ssh_t etc_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4857

#line 4857

#line 4857
allow staff_ssh_t lib_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4857

#line 4857

#line 4857
allow staff_ssh_t bin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4857

#line 4857

#line 4857
allow staff_ssh_t sbin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4857

#line 4857

#line 4857
allow staff_ssh_t exec_type:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4857

#line 4857

#line 4857

#line 4857
# Read the ssh key file.
#line 4857
allow staff_ssh_t sshd_key_t:file { read getattr lock ioctl };
#line 4857

#line 4857
# Access the ssh temporary files.
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
#
#line 4857
# Allow the process to modify the directory.
#line 4857
#
#line 4857
allow staff_ssh_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4857

#line 4857
#
#line 4857
# Allow the process to create the file.
#line 4857
#
#line 4857

#line 4857
allow staff_ssh_t sshd_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4857
allow staff_ssh_t sshd_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4857

#line 4857

#line 4857
type_transition staff_ssh_t tmp_t:dir sshd_tmp_t;
#line 4857
type_transition staff_ssh_t tmp_t:{ file lnk_file sock_file fifo_file } sshd_tmp_t;
#line 4857

#line 4857

#line 4857
allow staff_ssh_t staff_tmp_t:dir { read getattr lock search ioctl };
#line 4857

#line 4857
# for rsync
#line 4857
allow staff_ssh_t staff_t:unix_stream_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4857

#line 4857
# Access the users .ssh directory.
#line 4857
type staff_home_ssh_t, file_type, sysadmfile;
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
#
#line 4857
# Allow the process to modify the directory.
#line 4857
#
#line 4857
allow { sysadm_ssh_t staff_ssh_t } staff_home_dir_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4857

#line 4857
#
#line 4857
# Allow the process to create the file.
#line 4857
#
#line 4857

#line 4857
allow { sysadm_ssh_t staff_ssh_t } staff_home_ssh_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4857
allow { sysadm_ssh_t staff_ssh_t } staff_home_ssh_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4857

#line 4857

#line 4857
type_transition { sysadm_ssh_t staff_ssh_t } staff_home_dir_t:dir staff_home_ssh_t;
#line 4857
type_transition { sysadm_ssh_t staff_ssh_t } staff_home_dir_t:{ file lnk_file sock_file fifo_file } staff_home_ssh_t;
#line 4857

#line 4857

#line 4857
allow { sysadm_ssh_t staff_ssh_t } staff_home_ssh_t:lnk_file { getattr read };
#line 4857
dontaudit staff_ssh_t staff_home_t:dir search;
#line 4857

#line 4857
allow sshd_t staff_home_ssh_t:dir { read getattr lock search ioctl };
#line 4857
allow sshd_t staff_home_ssh_t:{ file lnk_file } { read getattr lock ioctl };
#line 4857

#line 4857

#line 4857
allow staff_t staff_home_ssh_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4857
allow staff_t staff_home_ssh_t:{ file lnk_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4857

#line 4857

#line 4857
# for /bin/sh used to execute xauth
#line 4857
dontaudit staff_ssh_t proc_t:dir search;
#line 4857

#line 4857
# Inherit and use descriptors from gnome-pty-helper.
#line 4857

#line 4857

#line 4857
# Connect to sshd.
#line 4857

#line 4857

#line 4857
allow staff_ssh_t sshd_t:tcp_socket { connectto recvfrom };
#line 4857
allow sshd_t staff_ssh_t:tcp_socket { acceptfrom recvfrom };
#line 4857
allow sshd_t tcp_socket_t:tcp_socket { recvfrom };
#line 4857
allow staff_ssh_t tcp_socket_t:tcp_socket { recvfrom };
#line 4857

#line 4857

#line 4857

#line 4857
# Write to the user domain tty.
#line 4857
allow staff_ssh_t staff_tty_device_t:chr_file { ioctl read getattr lock write append };
#line 4857
allow staff_ssh_t staff_devpts_t:chr_file { ioctl read getattr lock write append };
#line 4857

#line 4857
# Allow the user shell to signal the ssh program.
#line 4857
allow staff_t staff_ssh_t:process signal;
#line 4857
# allow ps to show ssh
#line 4857
allow staff_t staff_ssh_t:dir { search getattr read };
#line 4857
allow staff_t staff_ssh_t:{ file lnk_file } { read getattr };
#line 4857

#line 4857
# Allow the ssh program to communicate with ssh-agent.
#line 4857
allow staff_ssh_t staff_tmp_t:sock_file write;
#line 4857
allow staff_ssh_t staff_t:unix_stream_socket connectto;
#line 4857
allow staff_ssh_t sshd_t:unix_stream_socket connectto;
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857

#line 4857

#line 4857

#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
# Instantiate a derived domain for user cron jobs.
#line 4857

#line 4857
# Derived domain for user cron jobs, user user_crond_domain if not system
#line 4857

#line 4857
type staff_crond_t, domain, user_crond_domain;
#line 4857

#line 4857

#line 4857
# Permit a transition from the crond_t domain to this domain.
#line 4857
# The transition is requested explicitly by the modified crond 
#line 4857
# via execve_secure.  There is no way to set up an automatic
#line 4857
# transition, since crontabs are configuration files, not executables.
#line 4857

#line 4857

#line 4857
#
#line 4857
# Allow the process to transition to the new domain.
#line 4857
#
#line 4857
allow crond_t staff_crond_t:process transition;
#line 4857

#line 4857
#
#line 4857
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4857
#
#line 4857
dontaudit crond_t staff_crond_t:process noatsecure;
#line 4857

#line 4857
#
#line 4857
# Allow the process to execute the program.
#line 4857
# 
#line 4857
allow crond_t shell_exec_t:file { read { getattr execute } };
#line 4857

#line 4857
#
#line 4857
# Allow the process to reap the new domain.
#line 4857
#
#line 4857
allow staff_crond_t crond_t:process sigchld;
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to inherit and use file 
#line 4857
# descriptions from the creating process and vice versa.
#line 4857
#
#line 4857
allow staff_crond_t crond_t:fd use;
#line 4857
allow crond_t staff_crond_t:fd use;
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to write back to the old domain via a pipe.
#line 4857
#
#line 4857
allow staff_crond_t crond_t:fifo_file { ioctl read getattr lock write append };
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to read and execute the program.
#line 4857
#
#line 4857
allow staff_crond_t shell_exec_t:file { read getattr lock execute ioctl };
#line 4857

#line 4857
#
#line 4857
# Allow the new domain to be entered via the program.
#line 4857
#
#line 4857
allow staff_crond_t shell_exec_t:file entrypoint;
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
# The user role is authorized for this domain.
#line 4857
role staff_r types staff_crond_t;
#line 4857

#line 4857
# This domain is granted permissions common to most domains.
#line 4857

#line 4857
#
#line 4857
# Allow the domain to create and use UDP and TCP sockets.
#line 4857
# Other kinds of sockets must be separately authorized for use.
#line 4857
allow staff_crond_t self:udp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4857
allow staff_crond_t self:tcp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4857

#line 4857
#
#line 4857
# Allow the domain to send UDP packets.
#line 4857
# Since the destination sockets type is unknown, the generic
#line 4857
# any_socket_t type is used as a placeholder.
#line 4857
#
#line 4857
allow staff_crond_t any_socket_t:udp_socket sendto;
#line 4857

#line 4857
#
#line 4857
# Allow the domain to send using any network interface.
#line 4857
# netif_type is a type attribute for all network interface types.
#line 4857
#
#line 4857
allow staff_crond_t netif_type:netif { tcp_send udp_send rawip_send };
#line 4857

#line 4857
#
#line 4857
# Allow packets sent by the domain to be received on any network interface.
#line 4857
#
#line 4857
allow staff_crond_t netif_type:netif { tcp_recv udp_recv rawip_recv };
#line 4857

#line 4857
#
#line 4857
# Allow the domain to receive packets from any network interface.
#line 4857
# netmsg_type is a type attribute for all default message types.
#line 4857
#
#line 4857
allow staff_crond_t netmsg_type:{ udp_socket tcp_socket rawip_socket } recvfrom;
#line 4857

#line 4857
#
#line 4857
# Allow the domain to initiate or accept TCP connections 
#line 4857
# on any network interface.
#line 4857
#
#line 4857
allow staff_crond_t netmsg_type:tcp_socket { connectto acceptfrom };
#line 4857

#line 4857
#
#line 4857
# Receive resets from the TCP reset socket.
#line 4857
# The TCP reset socket is labeled with the tcp_socket_t type.
#line 4857
#
#line 4857
allow staff_crond_t tcp_socket_t:tcp_socket recvfrom;
#line 4857

#line 4857
dontaudit staff_crond_t tcp_socket_t:tcp_socket connectto;
#line 4857

#line 4857
#
#line 4857
# Allow the domain to send to any node.
#line 4857
# node_type is a type attribute for all node types.
#line 4857
#
#line 4857
allow staff_crond_t node_type:node { tcp_send udp_send rawip_send };
#line 4857

#line 4857
#
#line 4857
# Allow packets sent by the domain to be received from any node.
#line 4857
#
#line 4857
allow staff_crond_t node_type:node { tcp_recv udp_recv rawip_recv };
#line 4857

#line 4857
#
#line 4857
# Allow the domain to send NFS client requests via the socket
#line 4857
# created by mount.
#line 4857
#
#line 4857
allow staff_crond_t mount_t:udp_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4857

#line 4857
#
#line 4857
# Bind to the default port type.
#line 4857
# Other port types must be separately authorized.
#line 4857
#
#line 4857
#allow staff_crond_t port_t:udp_socket name_bind;
#line 4857
#allow staff_crond_t port_t:tcp_socket name_bind;
#line 4857

#line 4857
allow staff_crond_t resolv_conf_t:file { getattr read };
#line 4857

#line 4857
allow staff_crond_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4857
allow staff_crond_t lib_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_crond_t ld_so_t:file { read getattr lock execute ioctl };
#line 4857
allow staff_crond_t ld_so_t:file execute_no_trans;
#line 4857
allow staff_crond_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_crond_t shlib_t:file { read getattr lock execute ioctl };
#line 4857
allow staff_crond_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_crond_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4857
allow staff_crond_t device_t:dir search;
#line 4857
allow staff_crond_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4857

#line 4857

#line 4857
allow staff_crond_t self:dir { read getattr lock search ioctl };
#line 4857
allow staff_crond_t self:{ file lnk_file } { read getattr lock ioctl };
#line 4857

#line 4857
allow staff_crond_t self:fifo_file { ioctl read getattr lock write append };
#line 4857
allow staff_crond_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4857
allow staff_crond_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4857
allow staff_crond_t etc_runtime_t:file { getattr read };
#line 4857
allow staff_crond_t self:process { fork { sigchld sigkill sigstop signull signal } };
#line 4857
allow staff_crond_t proc_t:dir { getattr search read };
#line 4857
allow staff_crond_t proc_t:file { getattr read };
#line 4857

#line 4857
allow staff_crond_t etc_t:lnk_file read;
#line 4857

#line 4857
allow staff_crond_t locale_t:dir { read getattr lock search ioctl };
#line 4857
allow staff_crond_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 4857

#line 4857

#line 4857
allow staff_crond_t sysctl_kernel_t:dir search;
#line 4857
allow staff_crond_t sysctl_kernel_t:file { getattr read };
#line 4857
allow staff_crond_t var_spool_t:dir search;
#line 4857
allow staff_crond_t fs_t:filesystem getattr;
#line 4857

#line 4857
allow staff_crond_t devtty_t:chr_file { read write };
#line 4857

#line 4857
# Use capabilities.
#line 4857
allow staff_crond_t staff_crond_t:capability dac_override;
#line 4857

#line 4857
# Inherit and use descriptors from initrc.
#line 4857
allow staff_crond_t initrc_t:fd use;
#line 4857

#line 4857
# 
#line 4857
# Since crontab files are not directly executed,
#line 4857
# crond must ensure that the crontab file has
#line 4857
# a type that is appropriate for the domain of
#line 4857
# the user cron job.  It performs an entrypoint
#line 4857
# permission check for this purpose.
#line 4857
#
#line 4857
allow staff_crond_t staff_cron_spool_t:file entrypoint;
#line 4857

#line 4857
# Access user files and dirs.
#line 4857
allow staff_crond_t home_root_t:dir search;
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
#
#line 4857
# Allow the process to modify the directory.
#line 4857
#
#line 4857
allow staff_crond_t staff_home_dir_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4857

#line 4857
#
#line 4857
# Allow the process to create the file.
#line 4857
#
#line 4857

#line 4857
allow staff_crond_t staff_home_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4857
allow staff_crond_t staff_home_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4857

#line 4857

#line 4857
type_transition staff_crond_t staff_home_dir_t:dir staff_home_t;
#line 4857
type_transition staff_crond_t staff_home_dir_t:{ file lnk_file sock_file fifo_file } staff_home_t;
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
#
#line 4857
# Allow the process to modify the directory.
#line 4857
#
#line 4857
allow staff_crond_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4857

#line 4857
#
#line 4857
# Allow the process to create the file.
#line 4857
#
#line 4857

#line 4857
allow staff_crond_t staff_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 4857
allow staff_crond_t staff_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 4857

#line 4857

#line 4857
type_transition staff_crond_t tmp_t:dir staff_tmp_t;
#line 4857
type_transition staff_crond_t tmp_t:{ file lnk_file sock_file fifo_file } staff_tmp_t;
#line 4857

#line 4857

#line 4857

#line 4857
# Run helper programs.
#line 4857

#line 4857
allow staff_crond_t { bin_t sbin_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4857
allow staff_crond_t { bin_t sbin_t etc_t }:lnk_file { getattr read };
#line 4857

#line 4857
allow staff_crond_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4857
allow staff_crond_t lib_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_crond_t ld_so_t:file { read getattr lock execute ioctl };
#line 4857
allow staff_crond_t ld_so_t:file execute_no_trans;
#line 4857
allow staff_crond_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_crond_t shlib_t:file { read getattr lock execute ioctl };
#line 4857
allow staff_crond_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4857
allow staff_crond_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4857
allow staff_crond_t device_t:dir search;
#line 4857
allow staff_crond_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4857

#line 4857

#line 4857
allow staff_crond_t etc_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4857

#line 4857

#line 4857
allow staff_crond_t lib_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4857

#line 4857

#line 4857
allow staff_crond_t bin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4857

#line 4857

#line 4857
allow staff_crond_t sbin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4857

#line 4857

#line 4857
allow staff_crond_t exec_type:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4857

#line 4857

#line 4857

#line 4857
# Run scripts in user home directory.
#line 4857

#line 4857
allow staff_crond_t staff_home_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4857

#line 4857

#line 4857
# ps does not need to access /boot when run from cron
#line 4857
dontaudit staff_crond_t boot_t:dir search;
#line 4857
# quiet other ps operations
#line 4857
dontaudit staff_crond_t domain:dir getattr;
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
# Read the mouse.
#line 4857
allow staff_t mouse_device_t:chr_file { read getattr lock ioctl };
#line 4857
# Access other miscellaneous devices.
#line 4857
allow staff_t misc_device_t:{ file lnk_file sock_file fifo_file chr_file blk_file } { ioctl read getattr lock write append };
#line 4857

#line 4857
# Use the network.
#line 4857

#line 4857
#
#line 4857
# Allow the domain to create and use UDP and TCP sockets.
#line 4857
# Other kinds of sockets must be separately authorized for use.
#line 4857
allow staff_t self:udp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4857
allow staff_t self:tcp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4857

#line 4857
#
#line 4857
# Allow the domain to send UDP packets.
#line 4857
# Since the destination sockets type is unknown, the generic
#line 4857
# any_socket_t type is used as a placeholder.
#line 4857
#
#line 4857
allow staff_t any_socket_t:udp_socket sendto;
#line 4857

#line 4857
#
#line 4857
# Allow the domain to send using any network interface.
#line 4857
# netif_type is a type attribute for all network interface types.
#line 4857
#
#line 4857
allow staff_t netif_type:netif { tcp_send udp_send rawip_send };
#line 4857

#line 4857
#
#line 4857
# Allow packets sent by the domain to be received on any network interface.
#line 4857
#
#line 4857
allow staff_t netif_type:netif { tcp_recv udp_recv rawip_recv };
#line 4857

#line 4857
#
#line 4857
# Allow the domain to receive packets from any network interface.
#line 4857
# netmsg_type is a type attribute for all default message types.
#line 4857
#
#line 4857
allow staff_t netmsg_type:{ udp_socket tcp_socket rawip_socket } recvfrom;
#line 4857

#line 4857
#
#line 4857
# Allow the domain to initiate or accept TCP connections 
#line 4857
# on any network interface.
#line 4857
#
#line 4857
allow staff_t netmsg_type:tcp_socket { connectto acceptfrom };
#line 4857

#line 4857
#
#line 4857
# Receive resets from the TCP reset socket.
#line 4857
# The TCP reset socket is labeled with the tcp_socket_t type.
#line 4857
#
#line 4857
allow staff_t tcp_socket_t:tcp_socket recvfrom;
#line 4857

#line 4857
dontaudit staff_t tcp_socket_t:tcp_socket connectto;
#line 4857

#line 4857
#
#line 4857
# Allow the domain to send to any node.
#line 4857
# node_type is a type attribute for all node types.
#line 4857
#
#line 4857
allow staff_t node_type:node { tcp_send udp_send rawip_send };
#line 4857

#line 4857
#
#line 4857
# Allow packets sent by the domain to be received from any node.
#line 4857
#
#line 4857
allow staff_t node_type:node { tcp_recv udp_recv rawip_recv };
#line 4857

#line 4857
#
#line 4857
# Allow the domain to send NFS client requests via the socket
#line 4857
# created by mount.
#line 4857
#
#line 4857
allow staff_t mount_t:udp_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4857

#line 4857
#
#line 4857
# Bind to the default port type.
#line 4857
# Other port types must be separately authorized.
#line 4857
#
#line 4857
#allow staff_t port_t:udp_socket name_bind;
#line 4857
#allow staff_t port_t:tcp_socket name_bind;
#line 4857

#line 4857
# allow port_t name binding for UDP because it is not very usable otherwise
#line 4857
allow staff_t port_t:udp_socket name_bind;
#line 4857
allow staff_t resolv_conf_t:file { getattr read };
#line 4857
# for perl
#line 4857
dontaudit staff_t resolv_conf_t:file ioctl;
#line 4857

#line 4857
#
#line 4857
# connect_secure and sendmsg_secure calls with a 
#line 4857
# peer or destination socket SID can be enforced
#line 4857
# when using the loopback interface.  Enforcement
#line 4857
# for real network interfaces will be possible when
#line 4857
# a packet labeling mechanism is integrated.
#line 4857
#
#line 4857
allow staff_t node_lo_t:node enforce_dest;
#line 4857

#line 4857
# Communicate within the domain.
#line 4857

#line 4857
allow staff_t staff_t:udp_socket { sendto };
#line 4857
allow staff_t staff_t:udp_socket { recvfrom };
#line 4857

#line 4857

#line 4857
allow staff_t staff_t:tcp_socket { connectto recvfrom };
#line 4857
allow staff_t staff_t:tcp_socket { acceptfrom recvfrom };
#line 4857
allow staff_t tcp_socket_t:tcp_socket { recvfrom };
#line 4857
allow staff_t tcp_socket_t:tcp_socket { recvfrom };
#line 4857

#line 4857

#line 4857
# Connect to inetd.
#line 4857

#line 4857

#line 4857

#line 4857

#line 4857
# Connect data port to ftpd.
#line 4857

#line 4857

#line 4857
# Connect to portmap.
#line 4857

#line 4857

#line 4857
# Inherit and use sockets from inetd
#line 4857

#line 4857

#line 4857
# Allow system log read
#line 4857
#allow staff_t kernel_t:system syslog_read;
#line 4857
# else do not log it
#line 4857
dontaudit staff_t kernel_t:system syslog_read;
#line 4857

#line 4857
# Very permissive allowing every domain to see every type.
#line 4857
allow staff_t kernel_t:system { ipc_info };
#line 4857

#line 4857
# When the user domain runs ps, there will be a number of access
#line 4857
# denials when ps tries to search /proc.  Do not audit these denials.
#line 4857
dontaudit staff_t domain:dir { read getattr lock search ioctl };
#line 4857
dontaudit staff_t domain:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4857

#line 4857
# Some shells ask for w access to utmp, but will operate
#line 4857
# correctly without it.  Do not audit write denials to utmp.
#line 4857
dontaudit staff_t initrc_var_run_t:file { getattr read write };
#line 4857

#line 4857
# do not audit getattr on tmpfile, otherwise ls -l /tmp fills the logs
#line 4857
dontaudit staff_t tmpfile:{ dir file lnk_file sock_file fifo_file chr_file blk_file } getattr;
#line 4857

#line 4857
# do not audit getattr on disk devices, otherwise KDE fills the logs
#line 4857
dontaudit staff_t { removable_device_t fixed_disk_device_t }:blk_file getattr;
#line 4857

#line 4857

#line 4857
# Access the sound device.
#line 4857
allow staff_t sound_device_t:chr_file { getattr read write ioctl };
#line 4857

#line 4857

#line 4857

#line 4857
# Get attributes of file systems.
#line 4857
allow staff_t fs_type:filesystem getattr;
#line 4857

#line 4857
# Read and write /dev/tty and /dev/null.
#line 4857
allow staff_t devtty_t:chr_file { ioctl read getattr lock write append };
#line 4857
allow staff_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4857
allow staff_t zero_device_t:chr_file { { ioctl read getattr lock write append } execute };
#line 4857
allow staff_t random_device_t:chr_file { getattr read };
#line 4857

#line 4857
# Read the devpts root directory.
#line 4857
allow staff_t devpts_t:dir { read getattr lock search ioctl };
#line 4857

#line 4857

#line 4857
# When an ordinary user domain runs su, su may try to
#line 4857
# update the /root/.Xauthority file, and the user shell may
#line 4857
# try to update the shell history. This isnt allowed, but 
#line 4857
# we dont need to audit it.
#line 4857

#line 4857
dontaudit staff_su_t sysadm_home_t:dir  { read getattr search write add_name remove_name };
#line 4857
dontaudit staff_su_t sysadm_home_t:file { read getattr create write link unlink };
#line 4857
dontaudit staff_t    sysadm_home_t:dir { read search getattr };
#line 4857
dontaudit staff_t    sysadm_home_t:file { read getattr append };
#line 4857

#line 4857

#line 4857
# Some programs that are left in staff_t will try to connect
#line 4857
# to syslogd, but we do not want to let them generate log messages.
#line 4857
# Do not audit.
#line 4857
dontaudit staff_t devlog_t:sock_file { read write };
#line 4857
dontaudit staff_t syslogd_t:unix_dgram_socket sendto;
#line 4857

#line 4857

#line 4857
# stop warnings about "ls -l" on directories with unlabelled files
#line 4857
dontaudit staff_t file_t:{ dir file lnk_file } getattr;
#line 4857

allow staff_t unpriv_userdomain:process { sigchld sigkill sigstop signull signal };

#line 4859
allow staff_t unpriv_userdomain:dir { read getattr lock search ioctl };
#line 4859
allow staff_t unpriv_userdomain:{ file lnk_file } { read getattr lock ioctl };
#line 4859

allow staff_t { ttyfile ptyfile tty_device_t }:chr_file getattr;

# if adding new user roles make sure you edit the in_user_role macro in
# macros/user_macros.te to match

# lots of user programs accidentally search /root, and also the admin often
# logs in as UID=0 domain=user_t...
dontaudit unpriv_userdomain sysadm_home_dir_t:dir { getattr search };

# system_r is authorized for user_t as a fallback for unmodified daemons.
role system_r types user_t;

# change from role $1_r to $2_r and relabel tty appropriately
#line 4877


#line 4886

#line 4886
#
#line 4886
# Allow the user roles to transition
#line 4886
# into each other.
#line 4886

#line 4886
allow sysadm_r user_r;
#line 4886
type_change user_t sysadm_devpts_t:chr_file user_devpts_t;
#line 4886
type_change user_t sysadm_tty_device_t:chr_file user_tty_device_t;
#line 4886

#line 4886

#line 4886
allow staff_r sysadm_r;
#line 4886
type_change sysadm_t staff_devpts_t:chr_file sysadm_devpts_t;
#line 4886
type_change sysadm_t staff_tty_device_t:chr_file sysadm_tty_device_t;
#line 4886

#line 4886

#line 4886
allow sysadm_r staff_r;
#line 4886
type_change staff_t sysadm_devpts_t:chr_file staff_devpts_t;
#line 4886
type_change staff_t sysadm_tty_device_t:chr_file staff_tty_device_t;
#line 4886

#line 4886


# "ps aux" and "ls -l /dev/pts" make too much noise without this
dontaudit unpriv_userdomain ptyfile:chr_file getattr;
#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
#

#################################
#
# Rules for the kernel_t domain.
#

#
# kernel_t is the domain of kernel threads.
# It is also the target type when checking permissions in the system class.
# 
type kernel_t, domain;
role system_r types kernel_t;

#line 4905
# Access other processes in the same domain.
#line 4905
# Omits ptrace, setexec, and setfscreate.  These must be granted 
#line 4905
# separately if desired.
#line 4905
allow kernel_t self:process ~{ptrace setexec setfscreate};
#line 4905

#line 4905
# Access /proc/PID files for processes in the same domain.
#line 4905
allow kernel_t self:dir { read getattr lock search ioctl };
#line 4905
allow kernel_t self:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4905

#line 4905
# Access file descriptions, pipes, and sockets
#line 4905
# created by processes in the same domain.
#line 4905
allow kernel_t self:fd *;
#line 4905
allow kernel_t self:fifo_file { ioctl read getattr lock write append };
#line 4905
allow kernel_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 4905
allow kernel_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 4905

#line 4905
# Allow the domain to communicate with other processes in the same domain.
#line 4905
allow kernel_t self:unix_dgram_socket sendto;
#line 4905
allow kernel_t self:unix_stream_socket connectto;
#line 4905

#line 4905
# Access System V IPC objects created by processes in the same domain.
#line 4905
allow kernel_t self:sem  { associate getattr setattr create destroy read write unix_read unix_write };
#line 4905
allow kernel_t self:msg  { send receive };
#line 4905
allow kernel_t self:msgq { associate getattr setattr create destroy read write enqueue unix_read unix_write };
#line 4905
allow kernel_t self:shm  { associate getattr setattr create destroy read write lock unix_read unix_write };
#line 4905


#line 4906
# Read system information files in /proc.
#line 4906
allow kernel_t proc_t:dir { read getattr lock search ioctl };
#line 4906
allow kernel_t proc_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4906

#line 4906
# Stat /proc/kmsg and /proc/kcore.
#line 4906
allow kernel_t proc_kmsg_t:file { getattr };
#line 4906
allow kernel_t proc_kcore_t:file { getattr };
#line 4906

#line 4906
# Read system variables in /proc/sys.
#line 4906
allow kernel_t sysctl_modprobe_t:file { read getattr lock ioctl };
#line 4906
allow kernel_t sysctl_t:file { read getattr lock ioctl };
#line 4906
allow kernel_t sysctl_t:dir { read getattr lock search ioctl };
#line 4906
allow kernel_t sysctl_fs_t:file { read getattr lock ioctl };
#line 4906
allow kernel_t sysctl_fs_t:dir { read getattr lock search ioctl };
#line 4906
allow kernel_t sysctl_kernel_t:file { read getattr lock ioctl };
#line 4906
allow kernel_t sysctl_kernel_t:dir { read getattr lock search ioctl };
#line 4906
allow kernel_t sysctl_net_t:file { read getattr lock ioctl };
#line 4906
allow kernel_t sysctl_net_t:dir { read getattr lock search ioctl };
#line 4906
allow kernel_t sysctl_vm_t:file { read getattr lock ioctl };
#line 4906
allow kernel_t sysctl_vm_t:dir { read getattr lock search ioctl };
#line 4906
allow kernel_t sysctl_dev_t:file { read getattr lock ioctl };
#line 4906
allow kernel_t sysctl_dev_t:dir { read getattr lock search ioctl };
#line 4906


#line 4907
# Read /.
#line 4907
allow kernel_t root_t:dir { read getattr lock search ioctl };
#line 4907
allow kernel_t root_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4907

#line 4907
# Read /home.
#line 4907
allow kernel_t home_root_t:dir { read getattr lock search ioctl };
#line 4907

#line 4907
# Read /usr.
#line 4907
allow kernel_t usr_t:dir { read getattr lock search ioctl };
#line 4907
allow kernel_t usr_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4907

#line 4907
# Read bin and sbin directories.
#line 4907
allow kernel_t bin_t:dir { read getattr lock search ioctl };
#line 4907
allow kernel_t bin_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4907
allow kernel_t sbin_t:dir { read getattr lock search ioctl };
#line 4907
allow kernel_t sbin_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 4907


#line 4908
allow kernel_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 4908
allow kernel_t lib_t:lnk_file { read getattr lock ioctl };
#line 4908
allow kernel_t ld_so_t:file { read getattr lock execute ioctl };
#line 4908
allow kernel_t ld_so_t:file execute_no_trans;
#line 4908
allow kernel_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 4908
allow kernel_t shlib_t:file { read getattr lock execute ioctl };
#line 4908
allow kernel_t shlib_t:lnk_file { read getattr lock ioctl };
#line 4908
allow kernel_t ld_so_cache_t:file { read getattr lock ioctl };
#line 4908
allow kernel_t device_t:dir search;
#line 4908
allow kernel_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 4908


# Use capabilities.
allow kernel_t self:capability *;

# Run init in the init_t domain.

#line 4914

#line 4914

#line 4914
#
#line 4914
# Allow the process to transition to the new domain.
#line 4914
#
#line 4914
allow kernel_t init_t:process transition;
#line 4914

#line 4914
#
#line 4914
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4914
#
#line 4914
dontaudit kernel_t init_t:process noatsecure;
#line 4914

#line 4914
#
#line 4914
# Allow the process to execute the program.
#line 4914
# 
#line 4914
allow kernel_t init_exec_t:file { read { getattr execute } };
#line 4914

#line 4914
#
#line 4914
# Allow the process to reap the new domain.
#line 4914
#
#line 4914
allow init_t kernel_t:process sigchld;
#line 4914

#line 4914
#
#line 4914
# Allow the new domain to inherit and use file 
#line 4914
# descriptions from the creating process and vice versa.
#line 4914
#
#line 4914
allow init_t kernel_t:fd use;
#line 4914
allow kernel_t init_t:fd use;
#line 4914

#line 4914
#
#line 4914
# Allow the new domain to write back to the old domain via a pipe.
#line 4914
#
#line 4914
allow init_t kernel_t:fifo_file { ioctl read getattr lock write append };
#line 4914

#line 4914
#
#line 4914
# Allow the new domain to read and execute the program.
#line 4914
#
#line 4914
allow init_t init_exec_t:file { read getattr lock execute ioctl };
#line 4914

#line 4914
#
#line 4914
# Allow the new domain to be entered via the program.
#line 4914
#
#line 4914
allow init_t init_exec_t:file entrypoint;
#line 4914

#line 4914
type_transition kernel_t init_exec_t:process init_t;
#line 4914


# Share state with the init process.
allow kernel_t init_t:process share;

# Mount and unmount file systems.
allow kernel_t fs_type:filesystem { mount remount unmount getattr };

# Search the persistent label mapping.
allow kernel_t file_labels_t:dir search;

# Send signal to any process.
allow kernel_t domain:process signal;

# Access the console.
allow kernel_t device_t:dir search;
allow kernel_t console_device_t:chr_file { ioctl read getattr lock write append };

# Access the initrd filesystem.
allow kernel_t file_t:chr_file { ioctl read getattr lock write append };

#line 4934
allow kernel_t file_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4934

#line 4937

allow kernel_t self:capability sys_chroot;

allow kernel_t { unlabeled_t root_t file_t }:dir mounton;
allow kernel_t file_t:dir { read getattr lock search ioctl add_name remove_name write };
allow kernel_t file_t:blk_file { create ioctl read getattr lock write setattr append link unlink rename };
allow kernel_t { sysctl_t sysctl_kernel_t }:file { setattr { ioctl read getattr lock write append } };

# Lookup the policy.
allow kernel_t policy_config_t:dir { read getattr lock search ioctl };

# Load the policy configuration.

#line 4949
allow kernel_t security_t:dir { read search getattr };
#line 4949
allow kernel_t security_t:file { getattr read write };
#line 4949
allow kernel_t security_t:security load_policy;
#line 4949
auditallow kernel_t security_t:security load_policy;
#line 4949


#line 4955

#line 4955
# Run insmod (for kernel module loader).
#line 4955

#line 4955

#line 4955

#line 4955
#
#line 4955
# Allow the process to transition to the new domain.
#line 4955
#
#line 4955
allow kernel_t insmod_t:process transition;
#line 4955

#line 4955
#
#line 4955
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4955
#
#line 4955
dontaudit kernel_t insmod_t:process noatsecure;
#line 4955

#line 4955
#
#line 4955
# Allow the process to execute the program.
#line 4955
# 
#line 4955
allow kernel_t insmod_exec_t:file { read { getattr execute } };
#line 4955

#line 4955
#
#line 4955
# Allow the process to reap the new domain.
#line 4955
#
#line 4955
allow insmod_t kernel_t:process sigchld;
#line 4955

#line 4955
#
#line 4955
# Allow the new domain to inherit and use file 
#line 4955
# descriptions from the creating process and vice versa.
#line 4955
#
#line 4955
allow insmod_t kernel_t:fd use;
#line 4955
allow kernel_t insmod_t:fd use;
#line 4955

#line 4955
#
#line 4955
# Allow the new domain to write back to the old domain via a pipe.
#line 4955
#
#line 4955
allow insmod_t kernel_t:fifo_file { ioctl read getattr lock write append };
#line 4955

#line 4955
#
#line 4955
# Allow the new domain to read and execute the program.
#line 4955
#
#line 4955
allow insmod_t insmod_exec_t:file { read getattr lock execute ioctl };
#line 4955

#line 4955
#
#line 4955
# Allow the new domain to be entered via the program.
#line 4955
#
#line 4955
allow insmod_t insmod_exec_t:file entrypoint;
#line 4955

#line 4955
type_transition kernel_t insmod_exec_t:process insmod_t;
#line 4955

#line 4955
allow kernel_t insmod_exec_t:lnk_file read;
#line 4955


# /proc/sys/kernel/modprobe is set to /bin/true if not using modules.

#line 4958
allow kernel_t bin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 4958



#DESC Checkpolicy - SELinux policy compliler
#
# Authors:  Frank Mayer, mayerf@tresys.com
# X-Debian-Packages: checkpolicy
#

###########################
# 
# checkpolicy_t is the domain type for checkpolicy
# checkpolicy_exec_t if file type for the executable

type checkpolicy_t, domain;
role sysadm_r types checkpolicy_t;

type checkpolicy_exec_t, file_type, exec_type, sysadmfile;

##########################
# 
# Rules


#line 4981

#line 4981

#line 4981
#
#line 4981
# Allow the process to transition to the new domain.
#line 4981
#
#line 4981
allow sysadm_t checkpolicy_t:process transition;
#line 4981

#line 4981
#
#line 4981
# Do not audit when glibc secure mode is enabled upon the transition.
#line 4981
#
#line 4981
dontaudit sysadm_t checkpolicy_t:process noatsecure;
#line 4981

#line 4981
#
#line 4981
# Allow the process to execute the program.
#line 4981
# 
#line 4981
allow sysadm_t checkpolicy_exec_t:file { read { getattr execute } };
#line 4981

#line 4981
#
#line 4981
# Allow the process to reap the new domain.
#line 4981
#
#line 4981
allow checkpolicy_t sysadm_t:process sigchld;
#line 4981

#line 4981
#
#line 4981
# Allow the new domain to inherit and use file 
#line 4981
# descriptions from the creating process and vice versa.
#line 4981
#
#line 4981
allow checkpolicy_t sysadm_t:fd use;
#line 4981
allow sysadm_t checkpolicy_t:fd use;
#line 4981

#line 4981
#
#line 4981
# Allow the new domain to write back to the old domain via a pipe.
#line 4981
#
#line 4981
allow checkpolicy_t sysadm_t:fifo_file { ioctl read getattr lock write append };
#line 4981

#line 4981
#
#line 4981
# Allow the new domain to read and execute the program.
#line 4981
#
#line 4981
allow checkpolicy_t checkpolicy_exec_t:file { read getattr lock execute ioctl };
#line 4981

#line 4981
#
#line 4981
# Allow the new domain to be entered via the program.
#line 4981
#
#line 4981
allow checkpolicy_t checkpolicy_exec_t:file entrypoint;
#line 4981

#line 4981
type_transition sysadm_t checkpolicy_exec_t:process checkpolicy_t;
#line 4981


# able to create and modify binary policy files
allow checkpolicy_t policy_config_t:dir { read getattr lock search ioctl add_name remove_name write };
allow checkpolicy_t policy_config_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };

###########################
# constrain what checkpolicy can use as source files
#

# only allow read of policy source files
allow checkpolicy_t policy_src_t:dir { read getattr lock search ioctl };
allow checkpolicy_t policy_src_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };

# allow test policies to be created in src directories

#line 4996

#line 4996

#line 4996

#line 4996
#
#line 4996
# Allow the process to modify the directory.
#line 4996
#
#line 4996
allow checkpolicy_t policy_src_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 4996

#line 4996
#
#line 4996
# Allow the process to create the file.
#line 4996
#
#line 4996

#line 4996

#line 4996
allow checkpolicy_t policy_config_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 4996

#line 4996

#line 4996
type_transition checkpolicy_t policy_src_t:file policy_config_t;
#line 4996

#line 4996


# directory search permissions for path to source and binary policy files
allow checkpolicy_t root_t:dir search;
allow checkpolicy_t etc_t:dir search;

# Read the devpts root directory.  
allow checkpolicy_t devpts_t:dir { read getattr lock search ioctl };
#line 5005


# Other access
allow checkpolicy_t { initrc_devpts_t { sysadm_tty_device_t sysadm_devpts_t } }:chr_file { read write ioctl getattr };

#line 5009
allow checkpolicy_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 5009
allow checkpolicy_t lib_t:lnk_file { read getattr lock ioctl };
#line 5009
allow checkpolicy_t ld_so_t:file { read getattr lock execute ioctl };
#line 5009
allow checkpolicy_t ld_so_t:file execute_no_trans;
#line 5009
allow checkpolicy_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 5009
allow checkpolicy_t shlib_t:file { read getattr lock execute ioctl };
#line 5009
allow checkpolicy_t shlib_t:lnk_file { read getattr lock ioctl };
#line 5009
allow checkpolicy_t ld_so_cache_t:file { read getattr lock ioctl };
#line 5009
allow checkpolicy_t device_t:dir search;
#line 5009
allow checkpolicy_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 5009

allow checkpolicy_t self:capability dac_override;

allow checkpolicy_t sysadm_tmp_t:file { getattr write } ;

##########################
# Allow users to execute checkpolicy without a domain transition
# so it can be used without privilege to write real binary policy file

#line 5017
allow user_t checkpolicy_exec_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 5017


allow checkpolicy_t privfd:fd use;

#DESC Chkpwd - PAM password checking programs
# X-Debian-Packages: libpam-modules
#
# Domains for the /sbin/.*_chkpwd utilities.
#

#
# chkpwd_exec_t is the type of the /sbin/.*_chkpwd executables.
#
type chkpwd_exec_t, file_type, sysadmfile, exec_type;


#line 5032
# Derived domain based on the calling user domain and the program.
#line 5032
type system_chkpwd_t, domain, privlog, auth;
#line 5032

#line 5032
# Transition from the user domain to this domain.
#line 5032

#line 5032

#line 5032

#line 5032

#line 5032
#
#line 5032
# Allow the process to transition to the new domain.
#line 5032
#
#line 5032
allow auth_chkpwd system_chkpwd_t:process transition;
#line 5032

#line 5032
#
#line 5032
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5032
#
#line 5032
dontaudit auth_chkpwd system_chkpwd_t:process noatsecure;
#line 5032

#line 5032
#
#line 5032
# Allow the process to execute the program.
#line 5032
# 
#line 5032
allow auth_chkpwd chkpwd_exec_t:file { read { getattr execute } };
#line 5032

#line 5032
#
#line 5032
# Allow the process to reap the new domain.
#line 5032
#
#line 5032
allow system_chkpwd_t auth_chkpwd:process sigchld;
#line 5032

#line 5032
#
#line 5032
# Allow the new domain to inherit and use file 
#line 5032
# descriptions from the creating process and vice versa.
#line 5032
#
#line 5032
allow system_chkpwd_t auth_chkpwd:fd use;
#line 5032
allow auth_chkpwd system_chkpwd_t:fd use;
#line 5032

#line 5032
#
#line 5032
# Allow the new domain to write back to the old domain via a pipe.
#line 5032
#
#line 5032
allow system_chkpwd_t auth_chkpwd:fifo_file { ioctl read getattr lock write append };
#line 5032

#line 5032
#
#line 5032
# Allow the new domain to read and execute the program.
#line 5032
#
#line 5032
allow system_chkpwd_t chkpwd_exec_t:file { read getattr lock execute ioctl };
#line 5032

#line 5032
#
#line 5032
# Allow the new domain to be entered via the program.
#line 5032
#
#line 5032
allow system_chkpwd_t chkpwd_exec_t:file entrypoint;
#line 5032

#line 5032
type_transition auth_chkpwd chkpwd_exec_t:process system_chkpwd_t;
#line 5032

#line 5032
role system_r types system_chkpwd_t;
#line 5032

#line 5032

#line 5032

#line 5032
allow system_chkpwd_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 5032
allow system_chkpwd_t lib_t:lnk_file { read getattr lock ioctl };
#line 5032
allow system_chkpwd_t ld_so_t:file { read getattr lock execute ioctl };
#line 5032
allow system_chkpwd_t ld_so_t:file execute_no_trans;
#line 5032
allow system_chkpwd_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 5032
allow system_chkpwd_t shlib_t:file { read getattr lock execute ioctl };
#line 5032
allow system_chkpwd_t shlib_t:lnk_file { read getattr lock ioctl };
#line 5032
allow system_chkpwd_t ld_so_cache_t:file { read getattr lock ioctl };
#line 5032
allow system_chkpwd_t device_t:dir search;
#line 5032
allow system_chkpwd_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 5032

#line 5032
allow system_chkpwd_t etc_t:file { getattr read };
#line 5032
allow system_chkpwd_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 5032
allow system_chkpwd_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 5032

#line 5032
allow system_chkpwd_t etc_t:lnk_file read;
#line 5032

#line 5032
allow system_chkpwd_t locale_t:dir { read getattr lock search ioctl };
#line 5032
allow system_chkpwd_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 5032

#line 5032

#line 5032

#line 5032
# Use capabilities.
#line 5032
allow system_chkpwd_t self:capability setuid;
#line 5032

#line 5032
# for nscd
#line 5032
dontaudit system_chkpwd_t var_t:dir search;
#line 5032

#line 5032
dontaudit system_chkpwd_t fs_t:filesystem getattr;
#line 5032

dontaudit system_chkpwd_t privfd:fd use;

# Everything else is in the chkpwd_domain macro in
# macros/program/chkpwd_macros.te.
#DESC Crond - Crond daemon
#
# Domains for the top-level crond daemon process and
# for system cron jobs.  The domains for user cron jobs
# are in macros/program/crond_macros.te.
#
# X-Debian-Packages: cron
# Authors:  Jonathan Crowley (MITRE) <jonathan@mitre.org>,
#	    Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser
#

# Domain for crond.  It needs auth to check for locked accounts.

#line 5049

#line 5049

#line 5049
type crond_t, domain, privlog , privrole, privmail, auth, privfd;
#line 5049
type crond_exec_t, file_type, sysadmfile, exec_type;
#line 5049

#line 5049
role system_r types crond_t;
#line 5049

#line 5049
# Inherit and use descriptors from init.
#line 5049
allow crond_t init_t:fd use;
#line 5049
allow crond_t init_t:process sigchld;
#line 5049
allow crond_t self:process { { sigchld sigkill sigstop signull signal } fork };
#line 5049

#line 5049

#line 5049
allow crond_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 5049
allow crond_t lib_t:lnk_file { read getattr lock ioctl };
#line 5049
allow crond_t ld_so_t:file { read getattr lock execute ioctl };
#line 5049
allow crond_t ld_so_t:file execute_no_trans;
#line 5049
allow crond_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 5049
allow crond_t shlib_t:file { read getattr lock execute ioctl };
#line 5049
allow crond_t shlib_t:lnk_file { read getattr lock ioctl };
#line 5049
allow crond_t ld_so_cache_t:file { read getattr lock ioctl };
#line 5049
allow crond_t device_t:dir search;
#line 5049
allow crond_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 5049

#line 5049

#line 5049
allow crond_t { self proc_t }:dir { read getattr lock search ioctl };
#line 5049
allow crond_t { self proc_t }:lnk_file read;
#line 5049

#line 5049
allow crond_t device_t:dir { getattr search };
#line 5049
allow crond_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 5049
allow crond_t console_device_t:chr_file { ioctl read getattr lock write append };
#line 5049

#line 5049

#line 5049

#line 5049

#line 5049

#line 5049
#
#line 5049
# Allow the process to transition to the new domain.
#line 5049
#
#line 5049
allow initrc_t crond_t:process transition;
#line 5049

#line 5049
#
#line 5049
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5049
#
#line 5049
dontaudit initrc_t crond_t:process noatsecure;
#line 5049

#line 5049
#
#line 5049
# Allow the process to execute the program.
#line 5049
# 
#line 5049
allow initrc_t crond_exec_t:file { read { getattr execute } };
#line 5049

#line 5049
#
#line 5049
# Allow the process to reap the new domain.
#line 5049
#
#line 5049
allow crond_t initrc_t:process sigchld;
#line 5049

#line 5049
#
#line 5049
# Allow the new domain to inherit and use file 
#line 5049
# descriptions from the creating process and vice versa.
#line 5049
#
#line 5049
allow crond_t initrc_t:fd use;
#line 5049
allow initrc_t crond_t:fd use;
#line 5049

#line 5049
#
#line 5049
# Allow the new domain to write back to the old domain via a pipe.
#line 5049
#
#line 5049
allow crond_t initrc_t:fifo_file { ioctl read getattr lock write append };
#line 5049

#line 5049
#
#line 5049
# Allow the new domain to read and execute the program.
#line 5049
#
#line 5049
allow crond_t crond_exec_t:file { read getattr lock execute ioctl };
#line 5049

#line 5049
#
#line 5049
# Allow the new domain to be entered via the program.
#line 5049
#
#line 5049
allow crond_t crond_exec_t:file entrypoint;
#line 5049

#line 5049
type_transition initrc_t crond_exec_t:process crond_t;
#line 5049

#line 5049
allow crond_t privfd:fd use;
#line 5049
allow crond_t newrole_t:process sigchld;
#line 5049
allow crond_t initrc_devpts_t:chr_file { ioctl read getattr lock write append };
#line 5049

#line 5049
# Create pid file.
#line 5049
allow crond_t var_t:dir { getattr search };
#line 5049

#line 5049
type crond_var_run_t alias var_run_crond_t, file_type, sysadmfile, pidfile;
#line 5049

#line 5049

#line 5049

#line 5049

#line 5049
#
#line 5049
# Allow the process to modify the directory.
#line 5049
#
#line 5049
allow crond_t var_run_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5049

#line 5049
#
#line 5049
# Allow the process to create the file.
#line 5049
#
#line 5049

#line 5049

#line 5049
allow crond_t crond_var_run_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 5049

#line 5049

#line 5049
type_transition crond_t var_run_t:file crond_var_run_t;
#line 5049

#line 5049

#line 5049
allow crond_t crond_var_run_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5049

#line 5049

#line 5049
allow crond_t devtty_t:chr_file { ioctl read getattr lock write append };
#line 5049

#line 5049
# for daemons that look at /root on startup
#line 5049
dontaudit crond_t sysadm_home_dir_t:dir search;
#line 5049

#line 5049
# for df
#line 5049
allow crond_t fs_type:filesystem getattr;
#line 5049

#line 5049

#line 5049
allow crond_t etc_t:lnk_file read;
#line 5049

#line 5049
allow crond_t locale_t:dir { read getattr lock search ioctl };
#line 5049
allow crond_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 5049

#line 5049

#line 5049


# This domain is granted permissions common to most domains (including can_net)

#line 5052
# Access other processes in the same domain.
#line 5052
# Omits ptrace, setexec, and setfscreate.  These must be granted 
#line 5052
# separately if desired.
#line 5052
allow crond_t self:process ~{ptrace setexec setfscreate};
#line 5052

#line 5052
# Access /proc/PID files for processes in the same domain.
#line 5052
allow crond_t self:dir { read getattr lock search ioctl };
#line 5052
allow crond_t self:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 5052

#line 5052
# Access file descriptions, pipes, and sockets
#line 5052
# created by processes in the same domain.
#line 5052
allow crond_t self:fd *;
#line 5052
allow crond_t self:fifo_file { ioctl read getattr lock write append };
#line 5052
allow crond_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 5052
allow crond_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 5052

#line 5052
# Allow the domain to communicate with other processes in the same domain.
#line 5052
allow crond_t self:unix_dgram_socket sendto;
#line 5052
allow crond_t self:unix_stream_socket connectto;
#line 5052

#line 5052
# Access System V IPC objects created by processes in the same domain.
#line 5052
allow crond_t self:sem  { associate getattr setattr create destroy read write unix_read unix_write };
#line 5052
allow crond_t self:msg  { send receive };
#line 5052
allow crond_t self:msgq { associate getattr setattr create destroy read write enqueue unix_read unix_write };
#line 5052
allow crond_t self:shm  { associate getattr setattr create destroy read write lock unix_read unix_write };
#line 5052


# Type for the anacron executable.
type anacron_exec_t, file_type, sysadmfile, exec_type;

# Type for temporary files.

#line 5058
type crond_tmp_t, file_type, sysadmfile, tmpfile ;
#line 5058

#line 5058

#line 5058

#line 5058

#line 5058
#
#line 5058
# Allow the process to modify the directory.
#line 5058
#
#line 5058
allow crond_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5058

#line 5058
#
#line 5058
# Allow the process to create the file.
#line 5058
#
#line 5058

#line 5058
allow crond_t crond_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 5058
allow crond_t crond_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 5058

#line 5058

#line 5058
type_transition crond_t tmp_t:dir crond_tmp_t;
#line 5058
type_transition crond_t tmp_t:{ file lnk_file sock_file fifo_file } crond_tmp_t;
#line 5058

#line 5058

#line 5058


# Domain for system cron jobs.
type system_crond_t, domain, privlog, privmail;

# Read and write console and ttys.
allow system_crond_t devtty_t:chr_file { ioctl read getattr lock write append };

# Read system information files in /proc.
allow system_crond_t proc_t:dir { read getattr lock search ioctl };
allow system_crond_t proc_t:file { read getattr lock ioctl };
allow system_crond_t proc_t:lnk_file read;

#line 5073


# to stop killall type operations from filling our logs
dontaudit system_crond_t domain:dir search;

# read files in /etc
allow system_crond_t etc_t:{ file lnk_file } { read getattr lock ioctl };
allow system_crond_t etc_runtime_t:file read;


#line 5082
allow { crond_t system_crond_t } etc_t:lnk_file read;
#line 5082

#line 5082
allow { crond_t system_crond_t } locale_t:dir { read getattr lock search ioctl };
#line 5082
allow { crond_t system_crond_t } locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 5082

#line 5082



#line 5084
type crond_log_t, file_type, sysadmfile, logfile;
#line 5084

#line 5084

#line 5084

#line 5084

#line 5084
#
#line 5084
# Allow the process to modify the directory.
#line 5084
#
#line 5084
allow crond_t var_log_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5084

#line 5084
#
#line 5084
# Allow the process to create the file.
#line 5084
#
#line 5084

#line 5084

#line 5084
allow crond_t crond_log_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 5084

#line 5084

#line 5084
type_transition crond_t var_log_t:file crond_log_t;
#line 5084

#line 5084

#line 5084


# Use capabilities.
allow crond_t crond_t:capability { setgid setuid net_bind_service };

# Get security policy decisions.

#line 5090
allow crond_t security_t:dir { read search getattr };
#line 5090
allow crond_t security_t:file { getattr read write };
#line 5090
allow crond_t security_t:security { check_context compute_av compute_create compute_relabel compute_user };
#line 5090


# for finding binaries and /bin/sh
allow crond_t { bin_t sbin_t }:dir search;
allow crond_t bin_t:lnk_file read;

# Read from /var/spool/cron.
allow crond_t var_lib_t:dir search;
allow crond_t var_spool_t:dir { read getattr lock search ioctl };
allow crond_t cron_spool_t:dir { read getattr lock search ioctl };
allow crond_t cron_spool_t:file { read getattr lock ioctl };

# Read system crontabs
allow crond_t system_crond_script_t:file { read getattr lock ioctl };
allow crond_t system_crond_script_t:dir { read getattr lock search ioctl };

# Read /etc/security/default_contexts.
allow crond_t default_context_t:file { read getattr lock ioctl };

allow crond_t etc_t:file { getattr read };
allow crond_t etc_t:lnk_file read;

# crond tries to search /root.  Not sure why.
allow crond_t sysadm_home_dir_t:dir { read getattr lock search ioctl };

# to search /home
allow crond_t home_root_t:dir { getattr search };
allow crond_t user_home_dir_type:dir { read getattr lock search ioctl };

# Run a shell.

#line 5120
allow crond_t shell_exec_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 5120


#line 5128


# This system_r role is authorized for this domain.
role system_r types system_crond_t;


#line 5133
allow system_crond_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 5133
allow system_crond_t lib_t:lnk_file { read getattr lock ioctl };
#line 5133
allow system_crond_t ld_so_t:file { read getattr lock execute ioctl };
#line 5133
allow system_crond_t ld_so_t:file execute_no_trans;
#line 5133
allow system_crond_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 5133
allow system_crond_t shlib_t:file { read getattr lock execute ioctl };
#line 5133
allow system_crond_t shlib_t:lnk_file { read getattr lock ioctl };
#line 5133
allow system_crond_t ld_so_cache_t:file { read getattr lock ioctl };
#line 5133
allow system_crond_t device_t:dir search;
#line 5133
allow system_crond_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 5133
;

#line 5134
# Access other processes in the same domain.
#line 5134
# Omits ptrace, setexec, and setfscreate.  These must be granted 
#line 5134
# separately if desired.
#line 5134
allow system_crond_t self:process ~{ptrace setexec setfscreate};
#line 5134

#line 5134
# Access /proc/PID files for processes in the same domain.
#line 5134
allow system_crond_t self:dir { read getattr lock search ioctl };
#line 5134
allow system_crond_t self:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 5134

#line 5134
# Access file descriptions, pipes, and sockets
#line 5134
# created by processes in the same domain.
#line 5134
allow system_crond_t self:fd *;
#line 5134
allow system_crond_t self:fifo_file { ioctl read getattr lock write append };
#line 5134
allow system_crond_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 5134
allow system_crond_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 5134

#line 5134
# Allow the domain to communicate with other processes in the same domain.
#line 5134
allow system_crond_t self:unix_dgram_socket sendto;
#line 5134
allow system_crond_t self:unix_stream_socket connectto;
#line 5134

#line 5134
# Access System V IPC objects created by processes in the same domain.
#line 5134
allow system_crond_t self:sem  { associate getattr setattr create destroy read write unix_read unix_write };
#line 5134
allow system_crond_t self:msg  { send receive };
#line 5134
allow system_crond_t self:msgq { associate getattr setattr create destroy read write enqueue unix_read unix_write };
#line 5134
allow system_crond_t self:shm  { associate getattr setattr create destroy read write lock unix_read unix_write };
#line 5134
;
allow system_crond_t var_log_t:file { read getattr lock ioctl };

# Type for system crontab files.
type system_crond_script_t, file_type, sysadmfile;

# Permit crond_t to transition to this domain.
# The transition is requested explicitly by the modified crond 
# via execve_secure.  There is no way to set up an automatic
# transition, since crontabs are configuration files, not executables.

#line 5144

#line 5144
#
#line 5144
# Allow the process to transition to the new domain.
#line 5144
#
#line 5144
allow crond_t system_crond_t:process transition;
#line 5144

#line 5144
#
#line 5144
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5144
#
#line 5144
dontaudit crond_t system_crond_t:process noatsecure;
#line 5144

#line 5144
#
#line 5144
# Allow the process to execute the program.
#line 5144
# 
#line 5144
allow crond_t shell_exec_t:file { read { getattr execute } };
#line 5144

#line 5144
#
#line 5144
# Allow the process to reap the new domain.
#line 5144
#
#line 5144
allow system_crond_t crond_t:process sigchld;
#line 5144

#line 5144
#
#line 5144
# Allow the new domain to inherit and use file 
#line 5144
# descriptions from the creating process and vice versa.
#line 5144
#
#line 5144
allow system_crond_t crond_t:fd use;
#line 5144
allow crond_t system_crond_t:fd use;
#line 5144

#line 5144
#
#line 5144
# Allow the new domain to write back to the old domain via a pipe.
#line 5144
#
#line 5144
allow system_crond_t crond_t:fifo_file { ioctl read getattr lock write append };
#line 5144

#line 5144
#
#line 5144
# Allow the new domain to read and execute the program.
#line 5144
#
#line 5144
allow system_crond_t shell_exec_t:file { read getattr lock execute ioctl };
#line 5144

#line 5144
#
#line 5144
# Allow the new domain to be entered via the program.
#line 5144
#
#line 5144
allow system_crond_t shell_exec_t:file entrypoint;
#line 5144


# Set exec context.

#line 5147
allow crond_t self:process setexec;
#line 5147
allow crond_t proc_t:dir search;
#line 5147
allow crond_t proc_t:lnk_file read;
#line 5147
allow crond_t self:dir search;
#line 5147
allow crond_t self:file { read write };
#line 5147


# Transition to this domain for anacron as well.
# Still need to study anacron.

#line 5151

#line 5151

#line 5151
#
#line 5151
# Allow the process to transition to the new domain.
#line 5151
#
#line 5151
allow initrc_t system_crond_t:process transition;
#line 5151

#line 5151
#
#line 5151
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5151
#
#line 5151
dontaudit initrc_t system_crond_t:process noatsecure;
#line 5151

#line 5151
#
#line 5151
# Allow the process to execute the program.
#line 5151
# 
#line 5151
allow initrc_t anacron_exec_t:file { read { getattr execute } };
#line 5151

#line 5151
#
#line 5151
# Allow the process to reap the new domain.
#line 5151
#
#line 5151
allow system_crond_t initrc_t:process sigchld;
#line 5151

#line 5151
#
#line 5151
# Allow the new domain to inherit and use file 
#line 5151
# descriptions from the creating process and vice versa.
#line 5151
#
#line 5151
allow system_crond_t initrc_t:fd use;
#line 5151
allow initrc_t system_crond_t:fd use;
#line 5151

#line 5151
#
#line 5151
# Allow the new domain to write back to the old domain via a pipe.
#line 5151
#
#line 5151
allow system_crond_t initrc_t:fifo_file { ioctl read getattr lock write append };
#line 5151

#line 5151
#
#line 5151
# Allow the new domain to read and execute the program.
#line 5151
#
#line 5151
allow system_crond_t anacron_exec_t:file { read getattr lock execute ioctl };
#line 5151

#line 5151
#
#line 5151
# Allow the new domain to be entered via the program.
#line 5151
#
#line 5151
allow system_crond_t anacron_exec_t:file entrypoint;
#line 5151

#line 5151
type_transition initrc_t anacron_exec_t:process system_crond_t;
#line 5151


# Access log files

#line 5154

#line 5154

#line 5154

#line 5154
#
#line 5154
# Allow the process to modify the directory.
#line 5154
#
#line 5154
allow system_crond_t var_log_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5154

#line 5154
#
#line 5154
# Allow the process to create the file.
#line 5154
#
#line 5154

#line 5154

#line 5154
allow system_crond_t crond_log_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 5154

#line 5154

#line 5154
type_transition system_crond_t var_log_t:file crond_log_t;
#line 5154

#line 5154


# Inherit and use descriptors from init.
allow system_crond_t init_t:fd use;

# Inherit and use descriptors from initrc.
allow system_crond_t initrc_t:fd use;

# Write to a socket from initrc.
allow system_crond_t initrc_t:udp_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown };

# Use capabilities.
allow system_crond_t system_crond_t:capability { setgid setuid dac_override fowner net_bind_service fsetid };

# Read the system crontabs.
allow system_crond_t system_crond_script_t:file { read getattr lock ioctl };

# 
# Since crontab files are not directly executed,
# crond must ensure that the crontab file has
# a type that is appropriate for the domain of
# the system cron job.  It performs an entrypoint
# permission check for this purpose.
#
allow system_crond_t system_crond_script_t:file entrypoint;
#line 5181


# Run helper programs in the system_crond_t domain.
allow system_crond_t { bin_t sbin_t }:dir { read getattr lock search ioctl };
allow system_crond_t { bin_t sbin_t }:lnk_file read;

#line 5186
allow system_crond_t { bin_t sbin_t exec_type etc_t }:file { { read getattr lock execute ioctl } execute_no_trans };
#line 5186


# Read from /var/spool/cron.
allow system_crond_t cron_spool_t:dir { read getattr lock search ioctl };
allow system_crond_t cron_spool_t:file { read getattr lock ioctl };

# Write to /var/lib/slocate.db.
allow system_crond_t var_lib_t:dir { read getattr lock search ioctl add_name remove_name write };
allow system_crond_t var_lib_t:file { create ioctl read getattr lock write setattr append link unlink rename };

# Update whatis files.
allow system_crond_t catman_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
allow system_crond_t catman_t:file { create ioctl read getattr lock write setattr append link unlink rename };
allow system_crond_t man_t:file { read getattr lock ioctl };
allow system_crond_t man_t:lnk_file read;

# Write /var/lock/makewhatis.lock.

#line 5203
type system_crond_lock_t, file_type, sysadmfile, lockfile;
#line 5203

#line 5203

#line 5203

#line 5203

#line 5203
#
#line 5203
# Allow the process to modify the directory.
#line 5203
#
#line 5203
allow system_crond_t var_lock_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5203

#line 5203
#
#line 5203
# Allow the process to create the file.
#line 5203
#
#line 5203

#line 5203

#line 5203
allow system_crond_t system_crond_lock_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 5203

#line 5203

#line 5203
type_transition system_crond_t var_lock_t:file system_crond_lock_t;
#line 5203

#line 5203

#line 5203


# Modutils are now combined, so we can no longer distinguish them.
# Let crond run the insmod executable in the insmod_t domain.
#line 5209

#line 5209

#line 5209

#line 5209

#line 5209

#line 5209
#
#line 5209
# Allow the process to transition to the new domain.
#line 5209
#
#line 5209
allow system_crond_t insmod_t:process transition;
#line 5209

#line 5209
#
#line 5209
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5209
#
#line 5209
dontaudit system_crond_t insmod_t:process noatsecure;
#line 5209

#line 5209
#
#line 5209
# Allow the process to execute the program.
#line 5209
# 
#line 5209
allow system_crond_t insmod_exec_t:file { read { getattr execute } };
#line 5209

#line 5209
#
#line 5209
# Allow the process to reap the new domain.
#line 5209
#
#line 5209
allow insmod_t system_crond_t:process sigchld;
#line 5209

#line 5209
#
#line 5209
# Allow the new domain to inherit and use file 
#line 5209
# descriptions from the creating process and vice versa.
#line 5209
#
#line 5209
allow insmod_t system_crond_t:fd use;
#line 5209
allow system_crond_t insmod_t:fd use;
#line 5209

#line 5209
#
#line 5209
# Allow the new domain to write back to the old domain via a pipe.
#line 5209
#
#line 5209
allow insmod_t system_crond_t:fifo_file { ioctl read getattr lock write append };
#line 5209

#line 5209
#
#line 5209
# Allow the new domain to read and execute the program.
#line 5209
#
#line 5209
allow insmod_t insmod_exec_t:file { read getattr lock execute ioctl };
#line 5209

#line 5209
#
#line 5209
# Allow the new domain to be entered via the program.
#line 5209
#
#line 5209
allow insmod_t insmod_exec_t:file entrypoint;
#line 5209

#line 5209
type_transition system_crond_t insmod_exec_t:process insmod_t;
#line 5209

#line 5209
allow insmod_t crond_t:fifo_file { getattr read write ioctl };
#line 5209
# a rule for privfd may make this obsolete
#line 5209
allow insmod_t crond_t:fd use;
#line 5209
allow insmod_t crond_t:process sigchld;
#line 5209

#line 5209


# for if /var/mail is a symlink
allow crond_t mail_spool_t:lnk_file read;

# Run logrotate in the logrotate_t domain.
#line 5217

#line 5217

#line 5217

#line 5217

#line 5217

#line 5217
#
#line 5217
# Allow the process to transition to the new domain.
#line 5217
#
#line 5217
allow system_crond_t logrotate_t:process transition;
#line 5217

#line 5217
#
#line 5217
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5217
#
#line 5217
dontaudit system_crond_t logrotate_t:process noatsecure;
#line 5217

#line 5217
#
#line 5217
# Allow the process to execute the program.
#line 5217
# 
#line 5217
allow system_crond_t logrotate_exec_t:file { read { getattr execute } };
#line 5217

#line 5217
#
#line 5217
# Allow the process to reap the new domain.
#line 5217
#
#line 5217
allow logrotate_t system_crond_t:process sigchld;
#line 5217

#line 5217
#
#line 5217
# Allow the new domain to inherit and use file 
#line 5217
# descriptions from the creating process and vice versa.
#line 5217
#
#line 5217
allow logrotate_t system_crond_t:fd use;
#line 5217
allow system_crond_t logrotate_t:fd use;
#line 5217

#line 5217
#
#line 5217
# Allow the new domain to write back to the old domain via a pipe.
#line 5217
#
#line 5217
allow logrotate_t system_crond_t:fifo_file { ioctl read getattr lock write append };
#line 5217

#line 5217
#
#line 5217
# Allow the new domain to read and execute the program.
#line 5217
#
#line 5217
allow logrotate_t logrotate_exec_t:file { read getattr lock execute ioctl };
#line 5217

#line 5217
#
#line 5217
# Allow the new domain to be entered via the program.
#line 5217
#
#line 5217
allow logrotate_t logrotate_exec_t:file entrypoint;
#line 5217

#line 5217
type_transition system_crond_t logrotate_exec_t:process logrotate_t;
#line 5217

#line 5217
allow logrotate_t crond_t:fifo_file { getattr read write ioctl };
#line 5217
# a rule for privfd may make this obsolete
#line 5217
allow logrotate_t crond_t:fd use;
#line 5217
allow logrotate_t crond_t:process sigchld;
#line 5217

#line 5217


#line 5221


# Stat any file and search any directory for find.
allow system_crond_t file_type:{ file lnk_file sock_file fifo_file chr_file blk_file } getattr;
allow system_crond_t file_type:dir { read search getattr };

# Create temporary files.
type system_crond_tmp_t, file_type, sysadmfile, tmpfile;

#line 5229

#line 5229

#line 5229

#line 5229
#
#line 5229
# Allow the process to modify the directory.
#line 5229
#
#line 5229
allow system_crond_t { tmp_t crond_tmp_t }:dir { read getattr lock search ioctl add_name remove_name write };
#line 5229

#line 5229
#
#line 5229
# Allow the process to create the file.
#line 5229
#
#line 5229

#line 5229
allow system_crond_t system_crond_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 5229
allow system_crond_t system_crond_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 5229

#line 5229

#line 5229
type_transition system_crond_t { tmp_t crond_tmp_t }:dir system_crond_tmp_t;
#line 5229
type_transition system_crond_t { tmp_t crond_tmp_t }:{ file lnk_file sock_file fifo_file } system_crond_tmp_t;
#line 5229

#line 5229


# /sbin/runlevel ask for w access to utmp, but will operate
# correctly without it.  Do not audit write denials to utmp.
dontaudit system_crond_t initrc_var_run_t:file { read write };

# Access accounting summary files.
allow system_crond_t var_log_sa_t:file { create ioctl read getattr lock write setattr append link unlink rename };
allow system_crond_t var_log_sa_t:dir { read getattr lock search ioctl add_name remove_name write };

allow system_crond_t fs_t:filesystem getattr;

allow system_crond_t { sysctl_t sysctl_kernel_t }:dir search;
allow system_crond_t sysctl_kernel_t:file { getattr read };

# Access other spool directories like
# /var/spool/anacron and /var/spool/slrnpull.
allow system_crond_t var_spool_t:file { create ioctl read getattr lock write setattr append link unlink rename };
allow system_crond_t var_spool_t:dir { read getattr lock search ioctl add_name remove_name write };

# Do not audit attempts to search unlabeled directories (e.g. slocate).
dontaudit system_crond_t unlabeled_t:dir { read getattr lock search ioctl };
dontaudit system_crond_t unlabeled_t:file { read getattr lock ioctl };

#DESC Crontab - Crontab manipulation programs
#
# Domains for the crontab program.
#
# X-Debian-Packages: cron
#

# Type for the crontab executable.
type crontab_exec_t, file_type, sysadmfile, exec_type;

# Everything else is in the crontab_domain macro in
# macros/program/crontab_macros.te.
#DESC Fsadm - Disk and file system administration
#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
# X-Debian-Packages: util-linux e2fsprogs xfsprogs reiserfsprogs parted raidtools2 mount
#

#################################
#
# Rules for the fsadm_t domain.
#
# fsadm_t is the domain for disk and file system
# administration.
# fsadm_exec_t is the type of the corresponding programs.
#
type fsadm_t, domain, privlog, fs_domain;
role system_r types fsadm_t;
role sysadm_r types fsadm_t;


#line 5283
# Access other processes in the same domain.
#line 5283
# Omits ptrace, setexec, and setfscreate.  These must be granted 
#line 5283
# separately if desired.
#line 5283
allow fsadm_t self:process ~{ptrace setexec setfscreate};
#line 5283

#line 5283
# Access /proc/PID files for processes in the same domain.
#line 5283
allow fsadm_t self:dir { read getattr lock search ioctl };
#line 5283
allow fsadm_t self:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 5283

#line 5283
# Access file descriptions, pipes, and sockets
#line 5283
# created by processes in the same domain.
#line 5283
allow fsadm_t self:fd *;
#line 5283
allow fsadm_t self:fifo_file { ioctl read getattr lock write append };
#line 5283
allow fsadm_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 5283
allow fsadm_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 5283

#line 5283
# Allow the domain to communicate with other processes in the same domain.
#line 5283
allow fsadm_t self:unix_dgram_socket sendto;
#line 5283
allow fsadm_t self:unix_stream_socket connectto;
#line 5283

#line 5283
# Access System V IPC objects created by processes in the same domain.
#line 5283
allow fsadm_t self:sem  { associate getattr setattr create destroy read write unix_read unix_write };
#line 5283
allow fsadm_t self:msg  { send receive };
#line 5283
allow fsadm_t self:msgq { associate getattr setattr create destroy read write enqueue unix_read unix_write };
#line 5283
allow fsadm_t self:shm  { associate getattr setattr create destroy read write lock unix_read unix_write };
#line 5283


# Read system information files in /proc.
allow fsadm_t proc_t:dir { read getattr lock search ioctl };
allow fsadm_t proc_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };

# Read system variables in /proc/sys
allow fsadm_t sysctl_kernel_t:file { read getattr lock ioctl };
allow fsadm_t sysctl_kernel_t:dir { read getattr lock search ioctl };


#line 5293
# Read /.
#line 5293
allow fsadm_t root_t:dir { read getattr lock search ioctl };
#line 5293
allow fsadm_t root_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 5293

#line 5293
# Read /home.
#line 5293
allow fsadm_t home_root_t:dir { read getattr lock search ioctl };
#line 5293

#line 5293
# Read /usr.
#line 5293
allow fsadm_t usr_t:dir { read getattr lock search ioctl };
#line 5293
allow fsadm_t usr_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 5293

#line 5293
# Read bin and sbin directories.
#line 5293
allow fsadm_t bin_t:dir { read getattr lock search ioctl };
#line 5293
allow fsadm_t bin_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 5293
allow fsadm_t sbin_t:dir { read getattr lock search ioctl };
#line 5293
allow fsadm_t sbin_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 5293


# Read /etc.
allow fsadm_t etc_t:dir { read getattr lock search ioctl };
allow fsadm_t etc_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };

# Read module-related files.
allow fsadm_t modules_conf_t:{ file lnk_file } { read getattr lock ioctl };

# Read /dev directories and any symbolic links.
allow fsadm_t device_t:dir { read getattr lock search ioctl };
allow fsadm_t device_t:lnk_file { read getattr lock ioctl };


#line 5306
allow fsadm_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 5306
allow fsadm_t lib_t:lnk_file { read getattr lock ioctl };
#line 5306
allow fsadm_t ld_so_t:file { read getattr lock execute ioctl };
#line 5306
allow fsadm_t ld_so_t:file execute_no_trans;
#line 5306
allow fsadm_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 5306
allow fsadm_t shlib_t:file { read getattr lock execute ioctl };
#line 5306
allow fsadm_t shlib_t:lnk_file { read getattr lock ioctl };
#line 5306
allow fsadm_t ld_so_cache_t:file { read getattr lock ioctl };
#line 5306
allow fsadm_t device_t:dir search;
#line 5306
allow fsadm_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 5306


type fsadm_exec_t, file_type, sysadmfile, exec_type;

#line 5309

#line 5309

#line 5309
#
#line 5309
# Allow the process to transition to the new domain.
#line 5309
#
#line 5309
allow initrc_t fsadm_t:process transition;
#line 5309

#line 5309
#
#line 5309
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5309
#
#line 5309
dontaudit initrc_t fsadm_t:process noatsecure;
#line 5309

#line 5309
#
#line 5309
# Allow the process to execute the program.
#line 5309
# 
#line 5309
allow initrc_t fsadm_exec_t:file { read { getattr execute } };
#line 5309

#line 5309
#
#line 5309
# Allow the process to reap the new domain.
#line 5309
#
#line 5309
allow fsadm_t initrc_t:process sigchld;
#line 5309

#line 5309
#
#line 5309
# Allow the new domain to inherit and use file 
#line 5309
# descriptions from the creating process and vice versa.
#line 5309
#
#line 5309
allow fsadm_t initrc_t:fd use;
#line 5309
allow initrc_t fsadm_t:fd use;
#line 5309

#line 5309
#
#line 5309
# Allow the new domain to write back to the old domain via a pipe.
#line 5309
#
#line 5309
allow fsadm_t initrc_t:fifo_file { ioctl read getattr lock write append };
#line 5309

#line 5309
#
#line 5309
# Allow the new domain to read and execute the program.
#line 5309
#
#line 5309
allow fsadm_t fsadm_exec_t:file { read getattr lock execute ioctl };
#line 5309

#line 5309
#
#line 5309
# Allow the new domain to be entered via the program.
#line 5309
#
#line 5309
allow fsadm_t fsadm_exec_t:file entrypoint;
#line 5309

#line 5309
type_transition initrc_t fsadm_exec_t:process fsadm_t;
#line 5309


#line 5310

#line 5310

#line 5310
#
#line 5310
# Allow the process to transition to the new domain.
#line 5310
#
#line 5310
allow sysadm_t fsadm_t:process transition;
#line 5310

#line 5310
#
#line 5310
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5310
#
#line 5310
dontaudit sysadm_t fsadm_t:process noatsecure;
#line 5310

#line 5310
#
#line 5310
# Allow the process to execute the program.
#line 5310
# 
#line 5310
allow sysadm_t fsadm_exec_t:file { read { getattr execute } };
#line 5310

#line 5310
#
#line 5310
# Allow the process to reap the new domain.
#line 5310
#
#line 5310
allow fsadm_t sysadm_t:process sigchld;
#line 5310

#line 5310
#
#line 5310
# Allow the new domain to inherit and use file 
#line 5310
# descriptions from the creating process and vice versa.
#line 5310
#
#line 5310
allow fsadm_t sysadm_t:fd use;
#line 5310
allow sysadm_t fsadm_t:fd use;
#line 5310

#line 5310
#
#line 5310
# Allow the new domain to write back to the old domain via a pipe.
#line 5310
#
#line 5310
allow fsadm_t sysadm_t:fifo_file { ioctl read getattr lock write append };
#line 5310

#line 5310
#
#line 5310
# Allow the new domain to read and execute the program.
#line 5310
#
#line 5310
allow fsadm_t fsadm_exec_t:file { read getattr lock execute ioctl };
#line 5310

#line 5310
#
#line 5310
# Allow the new domain to be entered via the program.
#line 5310
#
#line 5310
allow fsadm_t fsadm_exec_t:file entrypoint;
#line 5310

#line 5310
type_transition sysadm_t fsadm_exec_t:process fsadm_t;
#line 5310



#line 5312
type fsadm_tmp_t, file_type, sysadmfile, tmpfile ;
#line 5312

#line 5312

#line 5312

#line 5312

#line 5312
#
#line 5312
# Allow the process to modify the directory.
#line 5312
#
#line 5312
allow fsadm_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5312

#line 5312
#
#line 5312
# Allow the process to create the file.
#line 5312
#
#line 5312

#line 5312
allow fsadm_t fsadm_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 5312
allow fsadm_t fsadm_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 5312

#line 5312

#line 5312
type_transition fsadm_t tmp_t:dir fsadm_tmp_t;
#line 5312
type_transition fsadm_t tmp_t:{ file lnk_file sock_file fifo_file } fsadm_tmp_t;
#line 5312

#line 5312

#line 5312


# remount file system to apply changes
allow fsadm_t fs_t:filesystem remount;

# mkreiserfs needs this
allow fsadm_t proc_t:filesystem getattr;

# mkreiserfs and other programs need this for UUID
allow fsadm_t random_device_t:chr_file { getattr read };

# Use capabilities.  ipc_lock is for losetup
allow fsadm_t self:capability { ipc_lock sys_rawio sys_admin };

# Write to /etc/mtab.

#line 5327

#line 5327

#line 5327

#line 5327
#
#line 5327
# Allow the process to modify the directory.
#line 5327
#
#line 5327
allow fsadm_t etc_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5327

#line 5327
#
#line 5327
# Allow the process to create the file.
#line 5327
#
#line 5327

#line 5327

#line 5327
allow fsadm_t etc_runtime_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 5327

#line 5327

#line 5327
type_transition fsadm_t etc_t:file etc_runtime_t;
#line 5327

#line 5327


# Inherit and use descriptors from init.
allow fsadm_t init_t:fd use;

# Run other fs admin programs in the fsadm_t domain.

#line 5333
allow fsadm_t fsadm_exec_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 5333


# Access disk devices.
allow fsadm_t fixed_disk_device_t:{ chr_file blk_file } { ioctl read getattr lock write append };
allow fsadm_t removable_device_t:{ chr_file blk_file } { ioctl read getattr lock write append };

# Access lost+found.
allow fsadm_t lost_found_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
allow fsadm_t lost_found_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };

# Recreate /mnt/cdrom. 
allow fsadm_t file_t:dir { search read getattr rmdir create };

# Recreate /dev/cdrom.
allow fsadm_t device_t:dir { read getattr lock search ioctl add_name remove_name write };
allow fsadm_t device_t:lnk_file { unlink create };

# Enable swapping to devices and files
allow fsadm_t swapfile_t:file { getattr swapon };
allow fsadm_t fixed_disk_device_t:blk_file { getattr swapon };

# XXX Why does updfstab run insmod?

#line 5355

#line 5355

#line 5355
#
#line 5355
# Allow the process to transition to the new domain.
#line 5355
#
#line 5355
allow fsadm_t insmod_t:process transition;
#line 5355

#line 5355
#
#line 5355
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5355
#
#line 5355
dontaudit fsadm_t insmod_t:process noatsecure;
#line 5355

#line 5355
#
#line 5355
# Allow the process to execute the program.
#line 5355
# 
#line 5355
allow fsadm_t insmod_exec_t:file { read { getattr execute } };
#line 5355

#line 5355
#
#line 5355
# Allow the process to reap the new domain.
#line 5355
#
#line 5355
allow insmod_t fsadm_t:process sigchld;
#line 5355

#line 5355
#
#line 5355
# Allow the new domain to inherit and use file 
#line 5355
# descriptions from the creating process and vice versa.
#line 5355
#
#line 5355
allow insmod_t fsadm_t:fd use;
#line 5355
allow fsadm_t insmod_t:fd use;
#line 5355

#line 5355
#
#line 5355
# Allow the new domain to write back to the old domain via a pipe.
#line 5355
#
#line 5355
allow insmod_t fsadm_t:fifo_file { ioctl read getattr lock write append };
#line 5355

#line 5355
#
#line 5355
# Allow the new domain to read and execute the program.
#line 5355
#
#line 5355
allow insmod_t insmod_exec_t:file { read getattr lock execute ioctl };
#line 5355

#line 5355
#
#line 5355
# Allow the new domain to be entered via the program.
#line 5355
#
#line 5355
allow insmod_t insmod_exec_t:file entrypoint;
#line 5355

#line 5355
type_transition fsadm_t insmod_exec_t:process insmod_t;
#line 5355


# Allow console log change (updfstab)
allow fsadm_t kernel_t:system syslog_console;

# Access terminals.
allow fsadm_t { sysadm_tty_device_t sysadm_devpts_t }:chr_file { ioctl read getattr lock write append };

allow fsadm_t privfd:fd use;


#line 5365
allow fsadm_t etc_t:lnk_file read;
#line 5365

#line 5365
allow fsadm_t locale_t:dir { read getattr lock search ioctl };
#line 5365
allow fsadm_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 5365

#line 5365

#DESC Getty - Manage ttys
#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
# X-Debian-Packages: util-linux fbgetty mingetty mgetty rungetty
#

#################################
#
# Rules for the getty_t domain.
#

#line 5376

#line 5376
type getty_t, domain, privlog , mlstrustedwriter, privfd;
#line 5376
type getty_exec_t, file_type, sysadmfile, exec_type;
#line 5376

#line 5376
role system_r types getty_t;
#line 5376

#line 5376
# Inherit and use descriptors from init.
#line 5376
allow getty_t init_t:fd use;
#line 5376
allow getty_t init_t:process sigchld;
#line 5376
allow getty_t self:process { { sigchld sigkill sigstop signull signal } fork };
#line 5376

#line 5376

#line 5376
allow getty_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 5376
allow getty_t lib_t:lnk_file { read getattr lock ioctl };
#line 5376
allow getty_t ld_so_t:file { read getattr lock execute ioctl };
#line 5376
allow getty_t ld_so_t:file execute_no_trans;
#line 5376
allow getty_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 5376
allow getty_t shlib_t:file { read getattr lock execute ioctl };
#line 5376
allow getty_t shlib_t:lnk_file { read getattr lock ioctl };
#line 5376
allow getty_t ld_so_cache_t:file { read getattr lock ioctl };
#line 5376
allow getty_t device_t:dir search;
#line 5376
allow getty_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 5376

#line 5376

#line 5376
allow getty_t { self proc_t }:dir { read getattr lock search ioctl };
#line 5376
allow getty_t { self proc_t }:lnk_file read;
#line 5376

#line 5376
allow getty_t device_t:dir { getattr search };
#line 5376
allow getty_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 5376
allow getty_t console_device_t:chr_file { ioctl read getattr lock write append };
#line 5376

#line 5376

#line 5376

#line 5376

#line 5376

#line 5376
#
#line 5376
# Allow the process to transition to the new domain.
#line 5376
#
#line 5376
allow init_t getty_t:process transition;
#line 5376

#line 5376
#
#line 5376
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5376
#
#line 5376
dontaudit init_t getty_t:process noatsecure;
#line 5376

#line 5376
#
#line 5376
# Allow the process to execute the program.
#line 5376
# 
#line 5376
allow init_t getty_exec_t:file { read { getattr execute } };
#line 5376

#line 5376
#
#line 5376
# Allow the process to reap the new domain.
#line 5376
#
#line 5376
allow getty_t init_t:process sigchld;
#line 5376

#line 5376
#
#line 5376
# Allow the new domain to inherit and use file 
#line 5376
# descriptions from the creating process and vice versa.
#line 5376
#
#line 5376
allow getty_t init_t:fd use;
#line 5376
allow init_t getty_t:fd use;
#line 5376

#line 5376
#
#line 5376
# Allow the new domain to write back to the old domain via a pipe.
#line 5376
#
#line 5376
allow getty_t init_t:fifo_file { ioctl read getattr lock write append };
#line 5376

#line 5376
#
#line 5376
# Allow the new domain to read and execute the program.
#line 5376
#
#line 5376
allow getty_t getty_exec_t:file { read getattr lock execute ioctl };
#line 5376

#line 5376
#
#line 5376
# Allow the new domain to be entered via the program.
#line 5376
#
#line 5376
allow getty_t getty_exec_t:file entrypoint;
#line 5376

#line 5376
type_transition init_t getty_exec_t:process getty_t;
#line 5376

#line 5376


type etc_getty_t, file_type, sysadmfile;

#line 5379
allow getty_t etc_getty_t:dir { read getattr lock search ioctl };
#line 5379
allow getty_t etc_getty_t:{ file lnk_file } { read getattr lock ioctl };
#line 5379


allow getty_t console_device_t:chr_file setattr;


#line 5383
type getty_tmp_t, file_type, sysadmfile, tmpfile ;
#line 5383

#line 5383

#line 5383

#line 5383

#line 5383
#
#line 5383
# Allow the process to modify the directory.
#line 5383
#
#line 5383
allow getty_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5383

#line 5383
#
#line 5383
# Allow the process to create the file.
#line 5383
#
#line 5383

#line 5383
allow getty_t getty_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 5383
allow getty_t getty_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 5383

#line 5383

#line 5383
type_transition getty_t tmp_t:dir getty_tmp_t;
#line 5383
type_transition getty_t tmp_t:{ file lnk_file sock_file fifo_file } getty_tmp_t;
#line 5383

#line 5383

#line 5383


#line 5384
type getty_log_t, file_type, sysadmfile, logfile;
#line 5384

#line 5384

#line 5384

#line 5384

#line 5384
#
#line 5384
# Allow the process to modify the directory.
#line 5384
#
#line 5384
allow getty_t var_log_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5384

#line 5384
#
#line 5384
# Allow the process to create the file.
#line 5384
#
#line 5384

#line 5384

#line 5384
allow getty_t getty_log_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 5384

#line 5384

#line 5384
type_transition getty_t var_log_t:file getty_log_t;
#line 5384

#line 5384

#line 5384


allow getty_t { etc_t etc_runtime_t }:file { getattr read };
allow getty_t etc_t:lnk_file read;
allow getty_t self:process { getpgid getsession };
allow getty_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
allow getty_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };

# for ldap and other authentication services
allow getty_t resolv_conf_t:file { getattr read };

# to allow w to display everyone...
#allow userdomain ttyfile:chr_file getattr;

# Use capabilities.
allow getty_t getty_t:capability { dac_override chown sys_tty_config };

# fbgetty needs fsetid for some reason
allow getty_t getty_t:capability fsetid;

# Run login in local_login_t domain.
allow getty_t bin_t:dir search;

#line 5406

#line 5406

#line 5406
#
#line 5406
# Allow the process to transition to the new domain.
#line 5406
#
#line 5406
allow getty_t local_login_t:process transition;
#line 5406

#line 5406
#
#line 5406
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5406
#
#line 5406
dontaudit getty_t local_login_t:process noatsecure;
#line 5406

#line 5406
#
#line 5406
# Allow the process to execute the program.
#line 5406
# 
#line 5406
allow getty_t login_exec_t:file { read { getattr execute } };
#line 5406

#line 5406
#
#line 5406
# Allow the process to reap the new domain.
#line 5406
#
#line 5406
allow local_login_t getty_t:process sigchld;
#line 5406

#line 5406
#
#line 5406
# Allow the new domain to inherit and use file 
#line 5406
# descriptions from the creating process and vice versa.
#line 5406
#
#line 5406
allow local_login_t getty_t:fd use;
#line 5406
allow getty_t local_login_t:fd use;
#line 5406

#line 5406
#
#line 5406
# Allow the new domain to write back to the old domain via a pipe.
#line 5406
#
#line 5406
allow local_login_t getty_t:fifo_file { ioctl read getattr lock write append };
#line 5406

#line 5406
#
#line 5406
# Allow the new domain to read and execute the program.
#line 5406
#
#line 5406
allow local_login_t login_exec_t:file { read getattr lock execute ioctl };
#line 5406

#line 5406
#
#line 5406
# Allow the new domain to be entered via the program.
#line 5406
#
#line 5406
allow local_login_t login_exec_t:file entrypoint;
#line 5406

#line 5406
type_transition getty_t login_exec_t:process local_login_t;
#line 5406


# Write to /var/run/utmp.
allow getty_t { var_t var_run_t }:dir search;
allow getty_t initrc_var_run_t:file { ioctl read getattr lock write append };

# Write to /var/log/wtmp.
allow getty_t wtmp_t:file { ioctl read getattr lock write append };

# Chown, chmod, read and write ttys.
allow getty_t tty_device_t:chr_file { setattr { ioctl read getattr lock write append } };
allow getty_t ttyfile:chr_file { setattr { ioctl read getattr lock write append } };



#line 5420
allow getty_t var_lock_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5420
allow getty_t var_lock_t:{ file lnk_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 5420

#DESC Ifconfig - Configure network interfaces
#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
# X-Debian-Packages: net-tools
#

#################################
#
# Rules for the ifconfig_t domain.
#
# ifconfig_t is the domain for the ifconfig program.
# ifconfig_exec_t is the type of the corresponding program.
#
type ifconfig_t, domain, privlog;
type ifconfig_exec_t, file_type, sysadmfile, exec_type;

role system_r types ifconfig_t;
role sysadm_r types ifconfig_t;


#line 5440
allow ifconfig_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 5440
allow ifconfig_t lib_t:lnk_file { read getattr lock ioctl };
#line 5440
allow ifconfig_t ld_so_t:file { read getattr lock execute ioctl };
#line 5440
allow ifconfig_t ld_so_t:file execute_no_trans;
#line 5440
allow ifconfig_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 5440
allow ifconfig_t shlib_t:file { read getattr lock execute ioctl };
#line 5440
allow ifconfig_t shlib_t:lnk_file { read getattr lock ioctl };
#line 5440
allow ifconfig_t ld_so_cache_t:file { read getattr lock ioctl };
#line 5440
allow ifconfig_t device_t:dir search;
#line 5440
allow ifconfig_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 5440


#line 5441
# Access other processes in the same domain.
#line 5441
# Omits ptrace, setexec, and setfscreate.  These must be granted 
#line 5441
# separately if desired.
#line 5441
allow ifconfig_t self:process ~{ptrace setexec setfscreate};
#line 5441

#line 5441
# Access /proc/PID files for processes in the same domain.
#line 5441
allow ifconfig_t self:dir { read getattr lock search ioctl };
#line 5441
allow ifconfig_t self:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 5441

#line 5441
# Access file descriptions, pipes, and sockets
#line 5441
# created by processes in the same domain.
#line 5441
allow ifconfig_t self:fd *;
#line 5441
allow ifconfig_t self:fifo_file { ioctl read getattr lock write append };
#line 5441
allow ifconfig_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 5441
allow ifconfig_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 5441

#line 5441
# Allow the domain to communicate with other processes in the same domain.
#line 5441
allow ifconfig_t self:unix_dgram_socket sendto;
#line 5441
allow ifconfig_t self:unix_stream_socket connectto;
#line 5441

#line 5441
# Access System V IPC objects created by processes in the same domain.
#line 5441
allow ifconfig_t self:sem  { associate getattr setattr create destroy read write unix_read unix_write };
#line 5441
allow ifconfig_t self:msg  { send receive };
#line 5441
allow ifconfig_t self:msgq { associate getattr setattr create destroy read write enqueue unix_read unix_write };
#line 5441
allow ifconfig_t self:shm  { associate getattr setattr create destroy read write lock unix_read unix_write };
#line 5441



#line 5443

#line 5443

#line 5443
#
#line 5443
# Allow the process to transition to the new domain.
#line 5443
#
#line 5443
allow initrc_t ifconfig_t:process transition;
#line 5443

#line 5443
#
#line 5443
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5443
#
#line 5443
dontaudit initrc_t ifconfig_t:process noatsecure;
#line 5443

#line 5443
#
#line 5443
# Allow the process to execute the program.
#line 5443
# 
#line 5443
allow initrc_t ifconfig_exec_t:file { read { getattr execute } };
#line 5443

#line 5443
#
#line 5443
# Allow the process to reap the new domain.
#line 5443
#
#line 5443
allow ifconfig_t initrc_t:process sigchld;
#line 5443

#line 5443
#
#line 5443
# Allow the new domain to inherit and use file 
#line 5443
# descriptions from the creating process and vice versa.
#line 5443
#
#line 5443
allow ifconfig_t initrc_t:fd use;
#line 5443
allow initrc_t ifconfig_t:fd use;
#line 5443

#line 5443
#
#line 5443
# Allow the new domain to write back to the old domain via a pipe.
#line 5443
#
#line 5443
allow ifconfig_t initrc_t:fifo_file { ioctl read getattr lock write append };
#line 5443

#line 5443
#
#line 5443
# Allow the new domain to read and execute the program.
#line 5443
#
#line 5443
allow ifconfig_t ifconfig_exec_t:file { read getattr lock execute ioctl };
#line 5443

#line 5443
#
#line 5443
# Allow the new domain to be entered via the program.
#line 5443
#
#line 5443
allow ifconfig_t ifconfig_exec_t:file entrypoint;
#line 5443

#line 5443
type_transition initrc_t ifconfig_exec_t:process ifconfig_t;
#line 5443


#line 5444

#line 5444

#line 5444
#
#line 5444
# Allow the process to transition to the new domain.
#line 5444
#
#line 5444
allow sysadm_t ifconfig_t:process transition;
#line 5444

#line 5444
#
#line 5444
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5444
#
#line 5444
dontaudit sysadm_t ifconfig_t:process noatsecure;
#line 5444

#line 5444
#
#line 5444
# Allow the process to execute the program.
#line 5444
# 
#line 5444
allow sysadm_t ifconfig_exec_t:file { read { getattr execute } };
#line 5444

#line 5444
#
#line 5444
# Allow the process to reap the new domain.
#line 5444
#
#line 5444
allow ifconfig_t sysadm_t:process sigchld;
#line 5444

#line 5444
#
#line 5444
# Allow the new domain to inherit and use file 
#line 5444
# descriptions from the creating process and vice versa.
#line 5444
#
#line 5444
allow ifconfig_t sysadm_t:fd use;
#line 5444
allow sysadm_t ifconfig_t:fd use;
#line 5444

#line 5444
#
#line 5444
# Allow the new domain to write back to the old domain via a pipe.
#line 5444
#
#line 5444
allow ifconfig_t sysadm_t:fifo_file { ioctl read getattr lock write append };
#line 5444

#line 5444
#
#line 5444
# Allow the new domain to read and execute the program.
#line 5444
#
#line 5444
allow ifconfig_t ifconfig_exec_t:file { read getattr lock execute ioctl };
#line 5444

#line 5444
#
#line 5444
# Allow the new domain to be entered via the program.
#line 5444
#
#line 5444
allow ifconfig_t ifconfig_exec_t:file entrypoint;
#line 5444

#line 5444
type_transition sysadm_t ifconfig_exec_t:process ifconfig_t;
#line 5444


# for /sbin/ip
allow ifconfig_t self:netlink_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
allow ifconfig_t self:tcp_socket { create ioctl };
allow ifconfig_t etc_t:file { getattr read };

# Use capabilities.
allow ifconfig_t self:capability net_admin;

# Inherit and use descriptors from init.
allow ifconfig_t init_t:fd use;

# Execute insmod.

#line 5458

#line 5458

#line 5458
#
#line 5458
# Allow the process to transition to the new domain.
#line 5458
#
#line 5458
allow ifconfig_t insmod_t:process transition;
#line 5458

#line 5458
#
#line 5458
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5458
#
#line 5458
dontaudit ifconfig_t insmod_t:process noatsecure;
#line 5458

#line 5458
#
#line 5458
# Allow the process to execute the program.
#line 5458
# 
#line 5458
allow ifconfig_t insmod_exec_t:file { read { getattr execute } };
#line 5458

#line 5458
#
#line 5458
# Allow the process to reap the new domain.
#line 5458
#
#line 5458
allow insmod_t ifconfig_t:process sigchld;
#line 5458

#line 5458
#
#line 5458
# Allow the new domain to inherit and use file 
#line 5458
# descriptions from the creating process and vice versa.
#line 5458
#
#line 5458
allow insmod_t ifconfig_t:fd use;
#line 5458
allow ifconfig_t insmod_t:fd use;
#line 5458

#line 5458
#
#line 5458
# Allow the new domain to write back to the old domain via a pipe.
#line 5458
#
#line 5458
allow insmod_t ifconfig_t:fifo_file { ioctl read getattr lock write append };
#line 5458

#line 5458
#
#line 5458
# Allow the new domain to read and execute the program.
#line 5458
#
#line 5458
allow insmod_t insmod_exec_t:file { read getattr lock execute ioctl };
#line 5458

#line 5458
#
#line 5458
# Allow the new domain to be entered via the program.
#line 5458
#
#line 5458
allow insmod_t insmod_exec_t:file entrypoint;
#line 5458

#line 5458
type_transition ifconfig_t insmod_exec_t:process insmod_t;
#line 5458


# Access /proc
allow ifconfig_t proc_t:dir { read getattr lock search ioctl };
allow ifconfig_t proc_t:file { read getattr lock ioctl };

allow ifconfig_t privfd:fd use;

# Create UDP sockets, necessary when called from dhcpc
allow ifconfig_t self:udp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };

# Access terminals.
allow ifconfig_t { initrc_devpts_t { sysadm_tty_device_t sysadm_devpts_t } }:chr_file { ioctl read getattr lock write append };


allow ifconfig_t tun_tap_device_t:chr_file { read write };

# ifconfig attempts to search some sysctl entries.
# Do not audit those attempts; comment out these rules if it is desired to
# see the denials.
dontaudit ifconfig_t { sysctl_t sysctl_net_t }:dir search;

allow ifconfig_t fs_t:filesystem getattr;


#line 5482
allow ifconfig_t etc_t:lnk_file read;
#line 5482

#line 5482
allow ifconfig_t locale_t:dir { read getattr lock search ioctl };
#line 5482
allow ifconfig_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 5482

#line 5482

#DESC Init - Process initialization
#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
# X-Debian-Packages: sysvinit
#

#################################
#
# Rules for the init_t domain.
#
# init_t is the domain of the init process.
# init_exec_t is the type of the init program.
# initctl_t is the type of the named pipe created 
# by init during initialization.  This pipe is used
# to communicate with init.
# sulogin_exec_t is the type of sulogin.
#
type init_t, domain, privlog, mlstrustedreader, mlstrustedwriter;
role system_r types init_t;

#line 5502
allow init_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 5502
allow init_t lib_t:lnk_file { read getattr lock ioctl };
#line 5502
allow init_t ld_so_t:file { read getattr lock execute ioctl };
#line 5502
allow init_t ld_so_t:file execute_no_trans;
#line 5502
allow init_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 5502
allow init_t shlib_t:file { read getattr lock execute ioctl };
#line 5502
allow init_t shlib_t:lnk_file { read getattr lock ioctl };
#line 5502
allow init_t ld_so_cache_t:file { read getattr lock ioctl };
#line 5502
allow init_t device_t:dir search;
#line 5502
allow init_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 5502
;
type init_exec_t, file_type, sysadmfile, exec_type;
type initctl_t, file_type, sysadmfile;
type sulogin_exec_t, file_type, exec_type, sysadmfile;

# for mount points
allow init_t file_t:dir search;

# Use capabilities.
allow init_t init_t:capability ~sys_module;

# Run /etc/rc.sysinit, /etc/rc, /etc/rc.local in the initrc_t domain.

#line 5514

#line 5514

#line 5514
#
#line 5514
# Allow the process to transition to the new domain.
#line 5514
#
#line 5514
allow init_t initrc_t:process transition;
#line 5514

#line 5514
#
#line 5514
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5514
#
#line 5514
dontaudit init_t initrc_t:process noatsecure;
#line 5514

#line 5514
#
#line 5514
# Allow the process to execute the program.
#line 5514
# 
#line 5514
allow init_t initrc_exec_t:file { read { getattr execute } };
#line 5514

#line 5514
#
#line 5514
# Allow the process to reap the new domain.
#line 5514
#
#line 5514
allow initrc_t init_t:process sigchld;
#line 5514

#line 5514
#
#line 5514
# Allow the new domain to inherit and use file 
#line 5514
# descriptions from the creating process and vice versa.
#line 5514
#
#line 5514
allow initrc_t init_t:fd use;
#line 5514
allow init_t initrc_t:fd use;
#line 5514

#line 5514
#
#line 5514
# Allow the new domain to write back to the old domain via a pipe.
#line 5514
#
#line 5514
allow initrc_t init_t:fifo_file { ioctl read getattr lock write append };
#line 5514

#line 5514
#
#line 5514
# Allow the new domain to read and execute the program.
#line 5514
#
#line 5514
allow initrc_t initrc_exec_t:file { read getattr lock execute ioctl };
#line 5514

#line 5514
#
#line 5514
# Allow the new domain to be entered via the program.
#line 5514
#
#line 5514
allow initrc_t initrc_exec_t:file entrypoint;
#line 5514

#line 5514
type_transition init_t initrc_exec_t:process initrc_t;
#line 5514


# Run the shell or sulogin in the sysadm_t domain for single-user mode.

#line 5517

#line 5517

#line 5517
#
#line 5517
# Allow the process to transition to the new domain.
#line 5517
#
#line 5517
allow init_t sysadm_t:process transition;
#line 5517

#line 5517
#
#line 5517
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5517
#
#line 5517
dontaudit init_t sysadm_t:process noatsecure;
#line 5517

#line 5517
#
#line 5517
# Allow the process to execute the program.
#line 5517
# 
#line 5517
allow init_t shell_exec_t:file { read { getattr execute } };
#line 5517

#line 5517
#
#line 5517
# Allow the process to reap the new domain.
#line 5517
#
#line 5517
allow sysadm_t init_t:process sigchld;
#line 5517

#line 5517
#
#line 5517
# Allow the new domain to inherit and use file 
#line 5517
# descriptions from the creating process and vice versa.
#line 5517
#
#line 5517
allow sysadm_t init_t:fd use;
#line 5517
allow init_t sysadm_t:fd use;
#line 5517

#line 5517
#
#line 5517
# Allow the new domain to write back to the old domain via a pipe.
#line 5517
#
#line 5517
allow sysadm_t init_t:fifo_file { ioctl read getattr lock write append };
#line 5517

#line 5517
#
#line 5517
# Allow the new domain to read and execute the program.
#line 5517
#
#line 5517
allow sysadm_t shell_exec_t:file { read getattr lock execute ioctl };
#line 5517

#line 5517
#
#line 5517
# Allow the new domain to be entered via the program.
#line 5517
#
#line 5517
allow sysadm_t shell_exec_t:file entrypoint;
#line 5517

#line 5517
type_transition init_t shell_exec_t:process sysadm_t;
#line 5517


#line 5518

#line 5518

#line 5518
#
#line 5518
# Allow the process to transition to the new domain.
#line 5518
#
#line 5518
allow init_t sysadm_t:process transition;
#line 5518

#line 5518
#
#line 5518
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5518
#
#line 5518
dontaudit init_t sysadm_t:process noatsecure;
#line 5518

#line 5518
#
#line 5518
# Allow the process to execute the program.
#line 5518
# 
#line 5518
allow init_t sulogin_exec_t:file { read { getattr execute } };
#line 5518

#line 5518
#
#line 5518
# Allow the process to reap the new domain.
#line 5518
#
#line 5518
allow sysadm_t init_t:process sigchld;
#line 5518

#line 5518
#
#line 5518
# Allow the new domain to inherit and use file 
#line 5518
# descriptions from the creating process and vice versa.
#line 5518
#
#line 5518
allow sysadm_t init_t:fd use;
#line 5518
allow init_t sysadm_t:fd use;
#line 5518

#line 5518
#
#line 5518
# Allow the new domain to write back to the old domain via a pipe.
#line 5518
#
#line 5518
allow sysadm_t init_t:fifo_file { ioctl read getattr lock write append };
#line 5518

#line 5518
#
#line 5518
# Allow the new domain to read and execute the program.
#line 5518
#
#line 5518
allow sysadm_t sulogin_exec_t:file { read getattr lock execute ioctl };
#line 5518

#line 5518
#
#line 5518
# Allow the new domain to be entered via the program.
#line 5518
#
#line 5518
allow sysadm_t sulogin_exec_t:file entrypoint;
#line 5518

#line 5518
type_transition init_t sulogin_exec_t:process sysadm_t;
#line 5518


# Run /sbin/update in the init_t domain.

#line 5521
allow init_t sbin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 5521


# Run init.

#line 5524
allow init_t init_exec_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 5524


# Run chroot from initrd scripts.
#line 5529


# Create /dev/initctl.

#line 5532

#line 5532

#line 5532

#line 5532
#
#line 5532
# Allow the process to modify the directory.
#line 5532
#
#line 5532
allow init_t device_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5532

#line 5532
#
#line 5532
# Allow the process to create the file.
#line 5532
#
#line 5532

#line 5532

#line 5532
allow init_t initctl_t:fifo_file { create ioctl read getattr lock write setattr append link unlink rename };
#line 5532

#line 5532

#line 5532
type_transition init_t device_t:fifo_file initctl_t;
#line 5532

#line 5532


# Create ioctl.save.

#line 5535

#line 5535

#line 5535

#line 5535
#
#line 5535
# Allow the process to modify the directory.
#line 5535
#
#line 5535
allow init_t etc_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5535

#line 5535
#
#line 5535
# Allow the process to create the file.
#line 5535
#
#line 5535

#line 5535

#line 5535
allow init_t etc_runtime_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 5535

#line 5535

#line 5535
type_transition init_t etc_t:file etc_runtime_t;
#line 5535

#line 5535


# Update /etc/ld.so.cache
allow init_t ld_so_cache_t:file { ioctl read getattr lock write append };

# Allow access to log files
allow init_t var_t:dir search;
allow init_t var_log_t:dir search;


#line 5544
allow init_t etc_t:lnk_file read;
#line 5544

#line 5544
allow init_t locale_t:dir { read getattr lock search ioctl };
#line 5544
allow init_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 5544

#line 5544


# Create unix sockets
allow init_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
allow init_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
allow init_t self:fifo_file { ioctl read getattr lock write append };

# Permissions required for system startup
allow init_t bin_t:dir { read getattr lock search ioctl };
allow init_t bin_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
allow init_t exec_type:{ file lnk_file } { read getattr lock ioctl };
allow init_t sbin_t:dir { read getattr lock search ioctl };
allow init_t sbin_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };

# allow init to fork
allow init_t self:process { fork sigchld };

# Modify utmp.
allow init_t var_run_t:file { ioctl read getattr lock write append };
allow init_t initrc_var_run_t:file { setattr { ioctl read getattr lock write append } };

# For /var/run/shutdown.pid.

#line 5566
type init_var_run_t alias var_run_init_t, file_type, sysadmfile, pidfile;
#line 5566

#line 5566

#line 5566

#line 5566

#line 5566
#
#line 5566
# Allow the process to modify the directory.
#line 5566
#
#line 5566
allow init_t var_run_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5566

#line 5566
#
#line 5566
# Allow the process to create the file.
#line 5566
#
#line 5566

#line 5566

#line 5566
allow init_t init_var_run_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 5566

#line 5566

#line 5566
type_transition init_t var_run_t:file init_var_run_t;
#line 5566

#line 5566

#line 5566
allow init_t init_var_run_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5566


# Shutdown permissions
allow init_t proc_t:dir { read getattr lock search ioctl };
allow init_t proc_t:lnk_file { read getattr lock ioctl };
allow init_t self:dir { read getattr lock search ioctl };
allow init_t self:lnk_file { read getattr lock ioctl };
allow init_t devpts_t:dir { read getattr lock ioctl };

# Modify wtmp.
allow init_t wtmp_t:file { ioctl read getattr lock write append };

# Kill all processes.
allow init_t domain:process { sigchld sigkill sigstop signull signal };

# Allow all processes to send SIGCHLD to init.
allow domain init_t:process { sigchld signull };

# If you load a new policy that removes active domains, processes can
# get stuck if you do not allow unlabeled processes to signal init
# If you load an incompatible policy, you should probably reboot,
# since you may have compromised system security.
allow unlabeled_t init_t:process sigchld;

# Read and write the console and ttys.
allow init_t console_device_t:chr_file { ioctl read getattr lock write append };
allow init_t tty_device_t:chr_file { ioctl read getattr lock write append };
allow init_t ttyfile:chr_file { ioctl read getattr lock write append };
allow init_t ptyfile:chr_file { ioctl read getattr lock write append };

# Run system executables.

#line 5597
allow init_t bin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 5597


# Run /etc/X11/prefdm.

#line 5600
allow init_t etc_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 5600


# for initrd pivot_root seems to access this
dontaudit init_t file_labels_t:dir { search };
#DESC Initrc - System initialization scripts
#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
# X-Debian-Packages: sysvinit policycoreutils
#

#################################
#
# Rules for the initrc_t domain.
#
# initrc_t is the domain of the init rc scripts.
# initrc_exec_t is the type of the init program.
#
#line 5622

#line 5622
type initrc_t, domain, privlog, privowner, privmail;
#line 5622

role system_r types initrc_t;

#line 5624
allow initrc_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 5624
allow initrc_t lib_t:lnk_file { read getattr lock ioctl };
#line 5624
allow initrc_t ld_so_t:file { read getattr lock execute ioctl };
#line 5624
allow initrc_t ld_so_t:file execute_no_trans;
#line 5624
allow initrc_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 5624
allow initrc_t shlib_t:file { read getattr lock execute ioctl };
#line 5624
allow initrc_t shlib_t:lnk_file { read getattr lock ioctl };
#line 5624
allow initrc_t ld_so_cache_t:file { read getattr lock ioctl };
#line 5624
allow initrc_t device_t:dir search;
#line 5624
allow initrc_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 5624
;
type initrc_exec_t, file_type, sysadmfile, exec_type;

# for halt to down interfaces
allow initrc_t self:udp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };

# read files in /etc/init.d
allow initrc_t etc_t:lnk_file { read getattr lock ioctl };


#line 5633
allow initrc_t etc_t:lnk_file read;
#line 5633

#line 5633
allow initrc_t locale_t:dir { read getattr lock search ioctl };
#line 5633
allow initrc_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 5633

#line 5633


# Read system information files in /proc.
allow initrc_t proc_t:dir { read getattr lock search ioctl };
allow initrc_t proc_t:{ file lnk_file } { read getattr lock ioctl };

# Allow IPC with self
allow initrc_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
allow initrc_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
allow initrc_t self:fifo_file { ioctl read getattr lock write append };

# Read the root directory of a usbdevfs filesystem, and
# the devices and drivers files.  Permit stating of the
# device nodes, but nothing else.
allow initrc_t usbdevfs_t:dir { read getattr lock search ioctl };
allow initrc_t usbdevfs_t:lnk_file { read getattr lock ioctl };
allow initrc_t usbdevfs_t:file getattr;

# allow initrc to fork and renice itself
allow initrc_t self:process { fork sigchld setsched };

# Can create ptys for open_init_pty

#line 5655

#line 5655
# Access the pty master multiplexer.
#line 5655
allow initrc_t ptmx_t:chr_file { ioctl read getattr lock write append };
#line 5655

#line 5655

#line 5655
allow initrc_t devpts_t:filesystem getattr;
#line 5655

#line 5655
# allow searching /dev/pts
#line 5655
allow initrc_t devpts_t:dir { getattr read search };
#line 5655

#line 5655

#line 5655
type initrc_devpts_t, file_type, sysadmfile, ptyfile ;
#line 5655

#line 5655
# Allow the pty to be associated with the file system.
#line 5655
allow initrc_devpts_t devpts_t:filesystem associate;
#line 5655

#line 5655
# Label pty files with a derived type.
#line 5655
type_transition initrc_t devpts_t:chr_file initrc_devpts_t;
#line 5655

#line 5655
# Read and write my pty files.
#line 5655
allow initrc_t initrc_devpts_t:chr_file { setattr { ioctl read getattr lock write append } };
#line 5655

#line 5655



#line 5657
type initrc_tmp_t, file_type, sysadmfile, tmpfile ;
#line 5657

#line 5657

#line 5657

#line 5657

#line 5657
#
#line 5657
# Allow the process to modify the directory.
#line 5657
#
#line 5657
allow initrc_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5657

#line 5657
#
#line 5657
# Allow the process to create the file.
#line 5657
#
#line 5657

#line 5657
allow initrc_t initrc_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 5657
allow initrc_t initrc_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 5657

#line 5657

#line 5657
type_transition initrc_t tmp_t:dir initrc_tmp_t;
#line 5657
type_transition initrc_t tmp_t:{ file lnk_file sock_file fifo_file } initrc_tmp_t;
#line 5657

#line 5657

#line 5657



#line 5659
type initrc_var_run_t alias var_run_initrc_t, file_type, sysadmfile, pidfile;
#line 5659

#line 5659

#line 5659

#line 5659

#line 5659
#
#line 5659
# Allow the process to modify the directory.
#line 5659
#
#line 5659
allow initrc_t var_run_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5659

#line 5659
#
#line 5659
# Allow the process to create the file.
#line 5659
#
#line 5659

#line 5659

#line 5659
allow initrc_t initrc_var_run_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 5659

#line 5659

#line 5659
type_transition initrc_t var_run_t:file initrc_var_run_t;
#line 5659

#line 5659

#line 5659
allow initrc_t initrc_var_run_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5659

allow initrc_t var_run_t:{ file sock_file lnk_file } unlink;

allow initrc_t framebuf_device_t:chr_file { read getattr lock ioctl };

# Use capabilities.
allow initrc_t initrc_t:capability ~sys_module;

# Use system operations.
allow initrc_t kernel_t:system *;

# Allow initrc_t to set the enforcing flag.
# The initrc_t domain is granted this permission for 
# people who want to use a development kernel and toggle
# into enforcing mode from an /etc/rc.d script.

#line 5674
allow initrc_t security_t:dir { read search getattr };
#line 5674
allow initrc_t security_t:file { getattr read write };
#line 5674
allow initrc_t security_t:security setenforce;
#line 5674
auditallow initrc_t security_t:security setenforce;
#line 5674


# Set values in /proc/sys.

#line 5677
allow initrc_t sysctl_t:dir { read getattr lock search ioctl };
#line 5677
allow initrc_t sysctl_t:file { setattr { ioctl read getattr lock write append } };
#line 5677
allow initrc_t sysctl_fs_t:dir { read getattr lock search ioctl };
#line 5677
allow initrc_t sysctl_fs_t:file { setattr { ioctl read getattr lock write append } };
#line 5677
allow initrc_t sysctl_kernel_t:dir { read getattr lock search ioctl };
#line 5677
allow initrc_t sysctl_kernel_t:file { setattr { ioctl read getattr lock write append } };
#line 5677
allow initrc_t sysctl_net_t:dir { read getattr lock search ioctl };
#line 5677
allow initrc_t sysctl_net_t:file { setattr { ioctl read getattr lock write append } };
#line 5677
allow initrc_t sysctl_net_unix_t:dir { read getattr lock search ioctl };
#line 5677
allow initrc_t sysctl_net_unix_t:file { setattr { ioctl read getattr lock write append } };
#line 5677
allow initrc_t sysctl_vm_t:dir { read getattr lock search ioctl };
#line 5677
allow initrc_t sysctl_vm_t:file { setattr { ioctl read getattr lock write append } };
#line 5677
allow initrc_t sysctl_dev_t:dir { read getattr lock search ioctl };
#line 5677
allow initrc_t sysctl_dev_t:file { setattr { ioctl read getattr lock write append } };
#line 5677
allow initrc_t sysctl_modprobe_t:file { setattr { ioctl read getattr lock write append } };
#line 5677


# Run helper programs in the initrc_t domain.
allow initrc_t {bin_t sbin_t }:dir { read getattr lock search ioctl };
allow initrc_t {bin_t sbin_t }:lnk_file read;

#line 5682
allow initrc_t etc_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 5682


#line 5683
allow initrc_t lib_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 5683


#line 5684
allow initrc_t bin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 5684


#line 5685
allow initrc_t sbin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 5685


#line 5686
allow initrc_t exec_type:file { { read getattr lock execute ioctl } execute_no_trans };
#line 5686



# Read conf.modules.
allow initrc_t modules_conf_t:file { read getattr lock ioctl };

# Run other rc scripts in the initrc_t domain.

#line 5693
allow initrc_t initrc_exec_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 5693


# Run init (telinit) in the initrc_t domain.

#line 5696
allow initrc_t init_exec_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 5696


# Communicate with the init process.
allow initrc_t initctl_t:fifo_file { ioctl read getattr lock write append };

# Send messages to portmap and ypbind.



# Search persistent label mappings.
allow initrc_t file_labels_t:dir { read getattr lock search ioctl };
allow initrc_t file_labels_t:file { getattr };

# Read /proc/PID directories for all domains.

#line 5710
allow initrc_t domain:dir { read getattr lock search ioctl };
#line 5710
allow initrc_t domain:{ file lnk_file } { read getattr lock ioctl };
#line 5710


# Mount and unmount file systems.
allow initrc_t fs_type:filesystem { mount remount unmount getattr };
allow initrc_t file_t:dir { read search getattr mounton };

# Create runtime files in /etc, e.g. /etc/mtab, /etc/HOSTNAME.

#line 5717

#line 5717

#line 5717

#line 5717
#
#line 5717
# Allow the process to modify the directory.
#line 5717
#
#line 5717
allow initrc_t etc_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5717

#line 5717
#
#line 5717
# Allow the process to create the file.
#line 5717
#
#line 5717

#line 5717

#line 5717
allow initrc_t etc_runtime_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 5717

#line 5717

#line 5717
type_transition initrc_t etc_t:file etc_runtime_t;
#line 5717

#line 5717


# Update /etc/ld.so.cache.
allow initrc_t ld_so_cache_t:file { ioctl read getattr lock write append };

#line 5725


#line 5731


# Update /var/log/wtmp and /var/log/dmesg.
allow initrc_t wtmp_t:file { setattr { ioctl read getattr lock write append } };
allow initrc_t var_log_t:file { setattr { ioctl read getattr lock write append } };
allow initrc_t lastlog_t:file { setattr { ioctl read getattr lock write append } };

# remove old locks
allow initrc_t lockfile:dir { read getattr lock search ioctl add_name remove_name write };
allow initrc_t lockfile:file { getattr unlink };

# Access /var/lib/random-seed.
allow initrc_t var_lib_t:file { ioctl read getattr lock write append };
allow initrc_t var_lib_t:file unlink;

# Create lock file.
allow initrc_t var_lock_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
allow initrc_t var_lock_t:file { create ioctl read getattr lock write setattr append link unlink rename };

# Set the clock.
allow initrc_t clock_device_t:{ chr_file blk_file } { ioctl read getattr lock write append };

# Kill all processes.
allow initrc_t domain:process { sigchld sigkill sigstop signull signal };

# Read and unlink /var/run/*.pid files.
allow initrc_t pidfile:file { getattr read unlink };

# Write to /dev/urandom.
allow initrc_t random_device_t:chr_file { ioctl read getattr lock write append };

# Access /dev/psaux (for kudzu).
allow initrc_t psaux_t:chr_file { ioctl read getattr lock write append };

# Set device ownerships/modes.
allow initrc_t framebuf_device_t:lnk_file read;
allow initrc_t framebuf_device_t:{ chr_file blk_file } setattr;
allow initrc_t misc_device_t:{ chr_file blk_file } setattr;
allow initrc_t device_t:{ chr_file blk_file } setattr;
allow initrc_t fixed_disk_device_t:{ chr_file blk_file } setattr;
allow initrc_t removable_device_t:{ chr_file blk_file } setattr;

# Stat any file.
allow initrc_t file_type:{ file lnk_file sock_file fifo_file chr_file blk_file } getattr;
allow initrc_t file_type:dir { search getattr };

# Read and write console and ttys.
allow initrc_t devtty_t:chr_file { ioctl read getattr lock write append };
allow initrc_t console_device_t:chr_file { ioctl read getattr lock write append };
allow initrc_t tty_device_t:chr_file { ioctl read getattr lock write append };
allow initrc_t ttyfile:chr_file { ioctl read getattr lock write append };
allow initrc_t ptyfile:chr_file { ioctl read getattr lock write append };

# Reset tty labels.
allow initrc_t ttyfile:chr_file relabelfrom;
allow initrc_t tty_device_t:chr_file relabelto;

#line 5797


allow initrc_t system_map_t:{ file lnk_file } { read getattr lock ioctl };

# Unlink /halt.
allow initrc_t root_t:dir { search write remove_name };
allow initrc_t root_t:file { unlink write };



allow initrc_t var_spool_t:file { ioctl read getattr lock write append };

#
# quota control
#
allow initrc_t fs_type:filesystem { quotamod quotaget };

# Access the mouse (for kudzu).
allow initrc_t mouse_device_t:chr_file { ioctl read getattr lock write append };

# Allow access to the sysadm TTYs. Note that this will give access to the 
# TTYs to any process in the initrc_t domain. Therefore, daemons and such
# started from init should be placed in their own domain.
allow initrc_t { sysadm_tty_device_t sysadm_devpts_t }:chr_file { ioctl read getattr lock write append };

# Access sound device and files.
allow initrc_t sound_device_t:chr_file { setattr ioctl read write };


#line 5830


# Update /var/log/ksyms.*.
# badly named type, /var/log/boot gets the same name too which is confusing

#line 5834

#line 5834

#line 5834

#line 5834
#
#line 5834
# Allow the process to modify the directory.
#line 5834
#
#line 5834
allow initrc_t var_log_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5834

#line 5834
#
#line 5834
# Allow the process to create the file.
#line 5834
#
#line 5834

#line 5834

#line 5834
allow initrc_t var_log_ksyms_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 5834

#line 5834

#line 5834
type_transition initrc_t var_log_t:file var_log_ksyms_t;
#line 5834

#line 5834


#line 5838


# Access /dev/fd0 (for kudzu). Need a separate domain for kudzu?
allow initrc_t removable_device_t:blk_file { ioctl read getattr lock write append };

#line 5846


# Create and delete /.autofsck
allow initrc_t root_t:dir { search write add_name };
allow initrc_t root_t:file { create setattr unlink getattr };
allow initrc_t file_t:file { unlink getattr };

# Read user home directories.
allow initrc_t { home_root_t home_type }:dir { read getattr lock search ioctl };
allow initrc_t home_type:file { read getattr lock ioctl };

# for system start scripts
allow initrc_t pidfile:dir { read getattr lock search ioctl add_name remove_name write };
allow initrc_t pidfile:sock_file unlink;
allow initrc_t tmpfile:sock_file unlink;

#line 5861
allow initrc_t var_lib_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5861
allow initrc_t var_lib_t:{ file lnk_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 5861


# allow start scripts to clean /tmp
allow initrc_t tmpfile:dir { { read getattr lock search ioctl add_name remove_name write } rmdir };
allow initrc_t tmpfile:{ file lnk_file sock_file fifo_file } { getattr unlink };

#################################
#
# Rules for the run_init_t domain.
#

#line 5871
type run_init_exec_t, file_type, exec_type, sysadmfile;
#line 5871

#line 5871
# domain for program to run in, needs to change role (privrole), change
#line 5871
# identity to system_u (privuser), log failures to syslog (privlog) and
#line 5871
# authenticate users (auth)
#line 5871
type run_init_t, domain, privrole, privuser, privlog, auth;
#line 5871

#line 5871

#line 5871

#line 5871
#
#line 5871
# Allow the process to transition to the new domain.
#line 5871
#
#line 5871
allow sysadm_t run_init_t:process transition;
#line 5871

#line 5871
#
#line 5871
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5871
#
#line 5871
dontaudit sysadm_t run_init_t:process noatsecure;
#line 5871

#line 5871
#
#line 5871
# Allow the process to execute the program.
#line 5871
# 
#line 5871
allow sysadm_t run_init_exec_t:file { read { getattr execute } };
#line 5871

#line 5871
#
#line 5871
# Allow the process to reap the new domain.
#line 5871
#
#line 5871
allow run_init_t sysadm_t:process sigchld;
#line 5871

#line 5871
#
#line 5871
# Allow the new domain to inherit and use file 
#line 5871
# descriptions from the creating process and vice versa.
#line 5871
#
#line 5871
allow run_init_t sysadm_t:fd use;
#line 5871
allow sysadm_t run_init_t:fd use;
#line 5871

#line 5871
#
#line 5871
# Allow the new domain to write back to the old domain via a pipe.
#line 5871
#
#line 5871
allow run_init_t sysadm_t:fifo_file { ioctl read getattr lock write append };
#line 5871

#line 5871
#
#line 5871
# Allow the new domain to read and execute the program.
#line 5871
#
#line 5871
allow run_init_t run_init_exec_t:file { read getattr lock execute ioctl };
#line 5871

#line 5871
#
#line 5871
# Allow the new domain to be entered via the program.
#line 5871
#
#line 5871
allow run_init_t run_init_exec_t:file entrypoint;
#line 5871

#line 5871
type_transition sysadm_t run_init_exec_t:process run_init_t;
#line 5871

#line 5871
role sysadm_r types run_init_t;
#line 5871

#line 5871
# for utmp
#line 5871
allow run_init_t initrc_var_run_t:file { ioctl read getattr lock write append };
#line 5871
allow run_init_t { sysadm_tty_device_t sysadm_devpts_t }:chr_file { ioctl read getattr lock write append };
#line 5871

#line 5871
dontaudit run_init_t devpts_t:dir { getattr read };
#line 5871
dontaudit run_init_t device_t:dir read;
#line 5871

#line 5871
# often the administrator runs such programs from a directory that is owned
#line 5871
# by a different user or has restrictive SE permissions, do not want to audit
#line 5871
# the failed access to the current directory
#line 5871
dontaudit run_init_t file_type:dir search;
#line 5871
dontaudit run_init_t self:capability { dac_override dac_read_search };
#line 5871

#line 5871
allow run_init_t bin_t:lnk_file read;
#line 5871

#line 5871
allow run_init_t { bin_t chkpwd_exec_t shell_exec_t }:file { { read getattr lock execute ioctl } execute_no_trans };
#line 5871

#line 5871

#line 5871

#line 5871

#line 5871
#
#line 5871
# Allow the process to transition to the new domain.
#line 5871
#
#line 5871
allow run_init_t initrc_t:process transition;
#line 5871

#line 5871
#
#line 5871
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5871
#
#line 5871
dontaudit run_init_t initrc_t:process noatsecure;
#line 5871

#line 5871
#
#line 5871
# Allow the process to execute the program.
#line 5871
# 
#line 5871
allow run_init_t initrc_exec_t:file { read { getattr execute } };
#line 5871

#line 5871
#
#line 5871
# Allow the process to reap the new domain.
#line 5871
#
#line 5871
allow initrc_t run_init_t:process sigchld;
#line 5871

#line 5871
#
#line 5871
# Allow the new domain to inherit and use file 
#line 5871
# descriptions from the creating process and vice versa.
#line 5871
#
#line 5871
allow initrc_t run_init_t:fd use;
#line 5871
allow run_init_t initrc_t:fd use;
#line 5871

#line 5871
#
#line 5871
# Allow the new domain to write back to the old domain via a pipe.
#line 5871
#
#line 5871
allow initrc_t run_init_t:fifo_file { ioctl read getattr lock write append };
#line 5871

#line 5871
#
#line 5871
# Allow the new domain to read and execute the program.
#line 5871
#
#line 5871
allow initrc_t initrc_exec_t:file { read getattr lock execute ioctl };
#line 5871

#line 5871
#
#line 5871
# Allow the new domain to be entered via the program.
#line 5871
#
#line 5871
allow initrc_t initrc_exec_t:file entrypoint;
#line 5871

#line 5871

#line 5871
allow run_init_t self:process setexec;
#line 5871
allow run_init_t proc_t:dir search;
#line 5871
allow run_init_t proc_t:lnk_file read;
#line 5871
allow run_init_t self:dir search;
#line 5871
allow run_init_t self:file { read write };
#line 5871

#line 5871

#line 5871
allow run_init_t privfd:fd use;
#line 5871

#line 5871
allow run_init_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 5871
allow run_init_t lib_t:lnk_file { read getattr lock ioctl };
#line 5871
allow run_init_t ld_so_t:file { read getattr lock execute ioctl };
#line 5871
allow run_init_t ld_so_t:file execute_no_trans;
#line 5871
allow run_init_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 5871
allow run_init_t shlib_t:file { read getattr lock execute ioctl };
#line 5871
allow run_init_t shlib_t:lnk_file { read getattr lock ioctl };
#line 5871
allow run_init_t ld_so_cache_t:file { read getattr lock ioctl };
#line 5871
allow run_init_t device_t:dir search;
#line 5871
allow run_init_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 5871

#line 5871

#line 5871
allow run_init_t security_t:dir { read search getattr };
#line 5871
allow run_init_t security_t:file { getattr read write };
#line 5871
allow run_init_t security_t:security { check_context compute_av compute_create compute_relabel compute_user };
#line 5871

#line 5871
allow run_init_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 5871
allow run_init_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 5871
allow run_init_t etc_t:file { getattr read };
#line 5871

#line 5871
allow run_init_t etc_t:lnk_file read;
#line 5871

#line 5871
allow run_init_t locale_t:dir { read getattr lock search ioctl };
#line 5871
allow run_init_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 5871

#line 5871

#line 5871
allow run_init_t fs_t:filesystem getattr;
#line 5871
allow run_init_t { bin_t sbin_t }:dir search;
#line 5871
dontaudit run_init_t { proc_t device_t }:dir { getattr search };
#line 5871

allow initrc_t privfd:fd use;
#DESC Klogd - Kernel log daemon
#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
# X-Debian-Packages: klogd
#

#################################
#
# Rules for the klogd_t domain.
#

#line 5883

#line 5883

#line 5883
type klogd_t, domain, privlog , privmem;
#line 5883
type klogd_exec_t, file_type, sysadmfile, exec_type;
#line 5883

#line 5883
role system_r types klogd_t;
#line 5883

#line 5883
# Inherit and use descriptors from init.
#line 5883
allow klogd_t init_t:fd use;
#line 5883
allow klogd_t init_t:process sigchld;
#line 5883
allow klogd_t self:process { { sigchld sigkill sigstop signull signal } fork };
#line 5883

#line 5883

#line 5883
allow klogd_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 5883
allow klogd_t lib_t:lnk_file { read getattr lock ioctl };
#line 5883
allow klogd_t ld_so_t:file { read getattr lock execute ioctl };
#line 5883
allow klogd_t ld_so_t:file execute_no_trans;
#line 5883
allow klogd_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 5883
allow klogd_t shlib_t:file { read getattr lock execute ioctl };
#line 5883
allow klogd_t shlib_t:lnk_file { read getattr lock ioctl };
#line 5883
allow klogd_t ld_so_cache_t:file { read getattr lock ioctl };
#line 5883
allow klogd_t device_t:dir search;
#line 5883
allow klogd_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 5883

#line 5883

#line 5883
allow klogd_t { self proc_t }:dir { read getattr lock search ioctl };
#line 5883
allow klogd_t { self proc_t }:lnk_file read;
#line 5883

#line 5883
allow klogd_t device_t:dir { getattr search };
#line 5883
allow klogd_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 5883
allow klogd_t console_device_t:chr_file { ioctl read getattr lock write append };
#line 5883

#line 5883

#line 5883

#line 5883

#line 5883

#line 5883
#
#line 5883
# Allow the process to transition to the new domain.
#line 5883
#
#line 5883
allow initrc_t klogd_t:process transition;
#line 5883

#line 5883
#
#line 5883
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5883
#
#line 5883
dontaudit initrc_t klogd_t:process noatsecure;
#line 5883

#line 5883
#
#line 5883
# Allow the process to execute the program.
#line 5883
# 
#line 5883
allow initrc_t klogd_exec_t:file { read { getattr execute } };
#line 5883

#line 5883
#
#line 5883
# Allow the process to reap the new domain.
#line 5883
#
#line 5883
allow klogd_t initrc_t:process sigchld;
#line 5883

#line 5883
#
#line 5883
# Allow the new domain to inherit and use file 
#line 5883
# descriptions from the creating process and vice versa.
#line 5883
#
#line 5883
allow klogd_t initrc_t:fd use;
#line 5883
allow initrc_t klogd_t:fd use;
#line 5883

#line 5883
#
#line 5883
# Allow the new domain to write back to the old domain via a pipe.
#line 5883
#
#line 5883
allow klogd_t initrc_t:fifo_file { ioctl read getattr lock write append };
#line 5883

#line 5883
#
#line 5883
# Allow the new domain to read and execute the program.
#line 5883
#
#line 5883
allow klogd_t klogd_exec_t:file { read getattr lock execute ioctl };
#line 5883

#line 5883
#
#line 5883
# Allow the new domain to be entered via the program.
#line 5883
#
#line 5883
allow klogd_t klogd_exec_t:file entrypoint;
#line 5883

#line 5883
type_transition initrc_t klogd_exec_t:process klogd_t;
#line 5883

#line 5883
allow klogd_t privfd:fd use;
#line 5883
allow klogd_t newrole_t:process sigchld;
#line 5883
allow klogd_t initrc_devpts_t:chr_file { ioctl read getattr lock write append };
#line 5883

#line 5883
# Create pid file.
#line 5883
allow klogd_t var_t:dir { getattr search };
#line 5883

#line 5883
type klogd_var_run_t alias var_run_klogd_t, file_type, sysadmfile, pidfile;
#line 5883

#line 5883

#line 5883

#line 5883

#line 5883
#
#line 5883
# Allow the process to modify the directory.
#line 5883
#
#line 5883
allow klogd_t var_run_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5883

#line 5883
#
#line 5883
# Allow the process to create the file.
#line 5883
#
#line 5883

#line 5883

#line 5883
allow klogd_t klogd_var_run_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 5883

#line 5883

#line 5883
type_transition klogd_t var_run_t:file klogd_var_run_t;
#line 5883

#line 5883

#line 5883
allow klogd_t klogd_var_run_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5883

#line 5883

#line 5883
allow klogd_t devtty_t:chr_file { ioctl read getattr lock write append };
#line 5883

#line 5883
# for daemons that look at /root on startup
#line 5883
dontaudit klogd_t sysadm_home_dir_t:dir search;
#line 5883

#line 5883
# for df
#line 5883
allow klogd_t fs_type:filesystem getattr;
#line 5883

#line 5883

#line 5883
allow klogd_t etc_t:lnk_file read;
#line 5883

#line 5883
allow klogd_t locale_t:dir { read getattr lock search ioctl };
#line 5883
allow klogd_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 5883

#line 5883

#line 5883



#line 5885
type klogd_tmp_t, file_type, sysadmfile, tmpfile ;
#line 5885

#line 5885

#line 5885

#line 5885

#line 5885
#
#line 5885
# Allow the process to modify the directory.
#line 5885
#
#line 5885
allow klogd_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5885

#line 5885
#
#line 5885
# Allow the process to create the file.
#line 5885
#
#line 5885

#line 5885
allow klogd_t klogd_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 5885
allow klogd_t klogd_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 5885

#line 5885

#line 5885
type_transition klogd_t tmp_t:dir klogd_tmp_t;
#line 5885
type_transition klogd_t tmp_t:{ file lnk_file sock_file fifo_file } klogd_tmp_t;
#line 5885

#line 5885

#line 5885

allow klogd_t proc_t:dir { read getattr lock search ioctl };
allow klogd_t proc_t:lnk_file { read getattr lock ioctl };
allow klogd_t proc_t:file { getattr read };
allow klogd_t self:dir { read getattr lock search ioctl };
allow klogd_t self:lnk_file { read getattr lock ioctl };

# read /etc/nsswitch.conf
allow klogd_t etc_t:lnk_file read;
allow klogd_t etc_t:file { read getattr lock ioctl };


#line 5896
allow klogd_t etc_t:lnk_file read;
#line 5896

#line 5896
allow klogd_t locale_t:dir { read getattr lock search ioctl };
#line 5896
allow klogd_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 5896

#line 5896


allow klogd_t etc_runtime_t:file { getattr read };

# Create unix sockets
allow klogd_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };

# Use the sys_admin and sys_rawio capabilities.
allow klogd_t klogd_t:capability { sys_admin sys_rawio };

# Read /proc/kmsg and /dev/mem.
allow klogd_t proc_kmsg_t:file { read getattr lock ioctl };
allow klogd_t memory_device_t:chr_file { read getattr lock ioctl };

# Control syslog and console logging
allow klogd_t kernel_t:system { syslog_mod syslog_console };

# Read /boot/System.map*
allow klogd_t system_map_t:file { read getattr lock ioctl };
allow klogd_t boot_t:dir { read getattr lock search ioctl };
#DESC Ldconfig - Configure dynamic linker bindings
#
# Author:  Russell Coker <russell@coker.com.au>
# X-Debian-Packages: libc6
#

#################################
#
# Rules for the ldconfig_t domain.
#
type ldconfig_t, domain, privlog;
type ldconfig_exec_t, file_type, sysadmfile, exec_type;

role sysadm_r types ldconfig_t;
role system_r types ldconfig_t;


#line 5932

#line 5932

#line 5932
#
#line 5932
# Allow the process to transition to the new domain.
#line 5932
#
#line 5932
allow { sysadm_t initrc_t  } ldconfig_t:process transition;
#line 5932

#line 5932
#
#line 5932
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5932
#
#line 5932
dontaudit { sysadm_t initrc_t  } ldconfig_t:process noatsecure;
#line 5932

#line 5932
#
#line 5932
# Allow the process to execute the program.
#line 5932
# 
#line 5932
allow { sysadm_t initrc_t  } ldconfig_exec_t:file { read { getattr execute } };
#line 5932

#line 5932
#
#line 5932
# Allow the process to reap the new domain.
#line 5932
#
#line 5932
allow ldconfig_t { sysadm_t initrc_t  }:process sigchld;
#line 5932

#line 5932
#
#line 5932
# Allow the new domain to inherit and use file 
#line 5932
# descriptions from the creating process and vice versa.
#line 5932
#
#line 5932
allow ldconfig_t { sysadm_t initrc_t  }:fd use;
#line 5932
allow { sysadm_t initrc_t  } ldconfig_t:fd use;
#line 5932

#line 5932
#
#line 5932
# Allow the new domain to write back to the old domain via a pipe.
#line 5932
#
#line 5932
allow ldconfig_t { sysadm_t initrc_t  }:fifo_file { ioctl read getattr lock write append };
#line 5932

#line 5932
#
#line 5932
# Allow the new domain to read and execute the program.
#line 5932
#
#line 5932
allow ldconfig_t ldconfig_exec_t:file { read getattr lock execute ioctl };
#line 5932

#line 5932
#
#line 5932
# Allow the new domain to be entered via the program.
#line 5932
#
#line 5932
allow ldconfig_t ldconfig_exec_t:file entrypoint;
#line 5932

#line 5932
type_transition { sysadm_t initrc_t  } ldconfig_exec_t:process ldconfig_t;
#line 5932

dontaudit ldconfig_t device_t:dir search;
allow ldconfig_t { initrc_devpts_t { sysadm_tty_device_t sysadm_devpts_t } }:chr_file { ioctl read getattr lock write append };
allow ldconfig_t privfd:fd use;


#line 5937
allow ldconfig_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 5937
allow ldconfig_t lib_t:lnk_file { read getattr lock ioctl };
#line 5937
allow ldconfig_t ld_so_t:file { read getattr lock execute ioctl };
#line 5937
allow ldconfig_t ld_so_t:file execute_no_trans;
#line 5937
allow ldconfig_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 5937
allow ldconfig_t shlib_t:file { read getattr lock execute ioctl };
#line 5937
allow ldconfig_t shlib_t:lnk_file { read getattr lock ioctl };
#line 5937
allow ldconfig_t ld_so_cache_t:file { read getattr lock ioctl };
#line 5937
allow ldconfig_t device_t:dir search;
#line 5937
allow ldconfig_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 5937



#line 5939

#line 5939

#line 5939

#line 5939
#
#line 5939
# Allow the process to modify the directory.
#line 5939
#
#line 5939
allow ldconfig_t etc_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5939

#line 5939
#
#line 5939
# Allow the process to create the file.
#line 5939
#
#line 5939

#line 5939

#line 5939
allow ldconfig_t ld_so_cache_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 5939

#line 5939

#line 5939
type_transition ldconfig_t etc_t:file ld_so_cache_t;
#line 5939

#line 5939


#line 5940

#line 5940

#line 5940

#line 5940
#
#line 5940
# Allow the process to modify the directory.
#line 5940
#
#line 5940
allow ldconfig_t lib_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 5940

#line 5940
#
#line 5940
# Allow the process to create the file.
#line 5940
#
#line 5940

#line 5940
allow ldconfig_t shlib_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 5940
allow ldconfig_t shlib_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 5940

#line 5940

#line 5940
type_transition ldconfig_t lib_t:dir shlib_t;
#line 5940
type_transition ldconfig_t lib_t:{ file lnk_file sock_file fifo_file } shlib_t;
#line 5940

#line 5940

# allow removing mis-labelled links
allow ldconfig_t lib_t:lnk_file unlink;

allow ldconfig_t userdomain:fd use;
allow ldconfig_t etc_t:file { getattr read };
allow ldconfig_t etc_t:lnk_file read;

allow ldconfig_t fs_t:filesystem getattr;
#DESC LoadPolicy - SELinux policy loading utilities
#
# Authors:  Frank Mayer, mayerf@tresys.com
# X-Debian-Packages: policycoreutils
#

###########################
# load_policy_t is the domain type for load_policy 
# load_policy_exec_t is the file type for the executable


type load_policy_t, domain;
role sysadm_r types load_policy_t;

type load_policy_exec_t, file_type, exec_type, sysadmfile;

##########################
# 
# Rules


#line 5969

#line 5969

#line 5969
#
#line 5969
# Allow the process to transition to the new domain.
#line 5969
#
#line 5969
allow sysadm_t load_policy_t:process transition;
#line 5969

#line 5969
#
#line 5969
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5969
#
#line 5969
dontaudit sysadm_t load_policy_t:process noatsecure;
#line 5969

#line 5969
#
#line 5969
# Allow the process to execute the program.
#line 5969
# 
#line 5969
allow sysadm_t load_policy_exec_t:file { read { getattr execute } };
#line 5969

#line 5969
#
#line 5969
# Allow the process to reap the new domain.
#line 5969
#
#line 5969
allow load_policy_t sysadm_t:process sigchld;
#line 5969

#line 5969
#
#line 5969
# Allow the new domain to inherit and use file 
#line 5969
# descriptions from the creating process and vice versa.
#line 5969
#
#line 5969
allow load_policy_t sysadm_t:fd use;
#line 5969
allow sysadm_t load_policy_t:fd use;
#line 5969

#line 5969
#
#line 5969
# Allow the new domain to write back to the old domain via a pipe.
#line 5969
#
#line 5969
allow load_policy_t sysadm_t:fifo_file { ioctl read getattr lock write append };
#line 5969

#line 5969
#
#line 5969
# Allow the new domain to read and execute the program.
#line 5969
#
#line 5969
allow load_policy_t load_policy_exec_t:file { read getattr lock execute ioctl };
#line 5969

#line 5969
#
#line 5969
# Allow the new domain to be entered via the program.
#line 5969
#
#line 5969
allow load_policy_t load_policy_exec_t:file entrypoint;
#line 5969

#line 5969
type_transition sysadm_t load_policy_exec_t:process load_policy_t;
#line 5969


# for running it from an init script

#line 5972

#line 5972

#line 5972
#
#line 5972
# Allow the process to transition to the new domain.
#line 5972
#
#line 5972
allow initrc_t load_policy_t:process transition;
#line 5972

#line 5972
#
#line 5972
# Do not audit when glibc secure mode is enabled upon the transition.
#line 5972
#
#line 5972
dontaudit initrc_t load_policy_t:process noatsecure;
#line 5972

#line 5972
#
#line 5972
# Allow the process to execute the program.
#line 5972
# 
#line 5972
allow initrc_t load_policy_exec_t:file { read { getattr execute } };
#line 5972

#line 5972
#
#line 5972
# Allow the process to reap the new domain.
#line 5972
#
#line 5972
allow load_policy_t initrc_t:process sigchld;
#line 5972

#line 5972
#
#line 5972
# Allow the new domain to inherit and use file 
#line 5972
# descriptions from the creating process and vice versa.
#line 5972
#
#line 5972
allow load_policy_t initrc_t:fd use;
#line 5972
allow initrc_t load_policy_t:fd use;
#line 5972

#line 5972
#
#line 5972
# Allow the new domain to write back to the old domain via a pipe.
#line 5972
#
#line 5972
allow load_policy_t initrc_t:fifo_file { ioctl read getattr lock write append };
#line 5972

#line 5972
#
#line 5972
# Allow the new domain to read and execute the program.
#line 5972
#
#line 5972
allow load_policy_t load_policy_exec_t:file { read getattr lock execute ioctl };
#line 5972

#line 5972
#
#line 5972
# Allow the new domain to be entered via the program.
#line 5972
#
#line 5972
allow load_policy_t load_policy_exec_t:file entrypoint;
#line 5972

#line 5972
type_transition initrc_t load_policy_exec_t:process load_policy_t;
#line 5972

allow load_policy_t init_t:fd use;
allow load_policy_t console_device_t:chr_file { read write };
role system_r types load_policy_t;

#line 5979


# Reload the policy configuration (sysadm_t no longer has this ability)

#line 5982
allow load_policy_t security_t:dir { read search getattr };
#line 5982
allow load_policy_t security_t:file { getattr read write };
#line 5982
allow load_policy_t security_t:security load_policy;
#line 5982
auditallow load_policy_t security_t:security load_policy;
#line 5982



###########################
# constrain from where load_policy can load a policy, specifically 
# policy_config_t files 
#

# only allow read of policy config files
allow load_policy_t policy_config_t:dir { read getattr lock search ioctl };
allow load_policy_t policy_config_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };

# directory search permissions for path to binary policy files
allow load_policy_t root_t:dir search;
allow load_policy_t etc_t:dir search;

# Read the devpts root directory (needed?)  
allow load_policy_t devpts_t:dir { read getattr lock search ioctl };

# Other access
allow load_policy_t { initrc_devpts_t { sysadm_tty_device_t sysadm_devpts_t } }:chr_file { read write ioctl getattr };

#line 6003
allow load_policy_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 6003
allow load_policy_t lib_t:lnk_file { read getattr lock ioctl };
#line 6003
allow load_policy_t ld_so_t:file { read getattr lock execute ioctl };
#line 6003
allow load_policy_t ld_so_t:file execute_no_trans;
#line 6003
allow load_policy_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 6003
allow load_policy_t shlib_t:file { read getattr lock execute ioctl };
#line 6003
allow load_policy_t shlib_t:lnk_file { read getattr lock ioctl };
#line 6003
allow load_policy_t ld_so_cache_t:file { read getattr lock ioctl };
#line 6003
allow load_policy_t device_t:dir search;
#line 6003
allow load_policy_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 6003

allow load_policy_t self:capability dac_override;

allow load_policy_t { initrc_t privfd }:fd use;

allow load_policy_t fs_t:filesystem getattr;

allow load_policy_t sysadm_tmp_t:file { getattr write } ;

#DESC Login - Local/remote login utilities
#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
# Macroised by Russell Coker <russell@coker.com.au>
# X-Debian-Packages: login
#

#################################
# 
# Rules for the local_login_t domain
# and the remote_login_t domain.
#

# $1 is the name of the domain (local or remote)
# I added "mlstrustedreader, mlstrustedwriter, mlstrustedobject" to
# remote_login_t, not sure if this is right
#line 6109


#################################
#
# Rules for the local_login_t domain.
#
# local_login_t is the domain of a login process 
# spawned by getty.
#
# remote_login_t is the domain of a login process 
# spawned by rlogind.
#
# login_exec_t is the type of the login program
#
type login_exec_t, file_type, sysadmfile, exec_type;


#line 6125
type local_login_t, domain, privuser, privrole, privlog, auth, privowner, mlstrustedreader, mlstrustedwriter, mlstrustedobject, privfd;
#line 6125
role system_r types local_login_t;
#line 6125

#line 6125
dontaudit local_login_t shadow_t:file { getattr read };
#line 6125

#line 6125

#line 6125
# Access other processes in the same domain.
#line 6125
# Omits ptrace, setexec, and setfscreate.  These must be granted 
#line 6125
# separately if desired.
#line 6125
allow local_login_t self:process ~{ptrace setexec setfscreate};
#line 6125

#line 6125
# Access /proc/PID files for processes in the same domain.
#line 6125
allow local_login_t self:dir { read getattr lock search ioctl };
#line 6125
allow local_login_t self:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 6125

#line 6125
# Access file descriptions, pipes, and sockets
#line 6125
# created by processes in the same domain.
#line 6125
allow local_login_t self:fd *;
#line 6125
allow local_login_t self:fifo_file { ioctl read getattr lock write append };
#line 6125
allow local_login_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 6125
allow local_login_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 6125

#line 6125
# Allow the domain to communicate with other processes in the same domain.
#line 6125
allow local_login_t self:unix_dgram_socket sendto;
#line 6125
allow local_login_t self:unix_stream_socket connectto;
#line 6125

#line 6125
# Access System V IPC objects created by processes in the same domain.
#line 6125
allow local_login_t self:sem  { associate getattr setattr create destroy read write unix_read unix_write };
#line 6125
allow local_login_t self:msg  { send receive };
#line 6125
allow local_login_t self:msgq { associate getattr setattr create destroy read write enqueue unix_read unix_write };
#line 6125
allow local_login_t self:shm  { associate getattr setattr create destroy read write lock unix_read unix_write };
#line 6125
;
#line 6125

#line 6125
# Read system information files in /proc.
#line 6125
allow local_login_t proc_t:dir { read getattr lock search ioctl };
#line 6125
allow local_login_t proc_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 6125

#line 6125

#line 6125
# Read /.
#line 6125
allow local_login_t root_t:dir { read getattr lock search ioctl };
#line 6125
allow local_login_t root_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 6125

#line 6125
# Read /home.
#line 6125
allow local_login_t home_root_t:dir { read getattr lock search ioctl };
#line 6125

#line 6125
# Read /usr.
#line 6125
allow local_login_t usr_t:dir { read getattr lock search ioctl };
#line 6125
allow local_login_t usr_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 6125

#line 6125
# Read bin and sbin directories.
#line 6125
allow local_login_t bin_t:dir { read getattr lock search ioctl };
#line 6125
allow local_login_t bin_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 6125
allow local_login_t sbin_t:dir { read getattr lock search ioctl };
#line 6125
allow local_login_t sbin_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 6125

#line 6125

#line 6125
# Read directories and files with the readable_t type.
#line 6125
# This type is a general type for "world"-readable files.
#line 6125
allow local_login_t readable_t:dir { read getattr lock search ioctl };
#line 6125
allow local_login_t readable_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 6125

#line 6125
# Read /var, /var/spool
#line 6125
allow local_login_t { var_t var_spool_t }:dir search;
#line 6125

#line 6125
# for when /var/mail is a sym-link
#line 6125
allow local_login_t var_t:lnk_file read;
#line 6125

#line 6125
# Read /etc.
#line 6125
allow local_login_t etc_t:dir { read getattr lock search ioctl };
#line 6125
allow local_login_t etc_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 6125
allow local_login_t etc_runtime_t:{ file lnk_file } { read getattr lock ioctl };
#line 6125

#line 6125

#line 6125
allow local_login_t etc_t:lnk_file read;
#line 6125

#line 6125
allow local_login_t locale_t:dir { read getattr lock search ioctl };
#line 6125
allow local_login_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 6125

#line 6125

#line 6125

#line 6125
# Read executable types.
#line 6125
allow local_login_t exec_type:{ file lnk_file } { read getattr lock ioctl };
#line 6125

#line 6125
# Read /dev directories and any symbolic links.
#line 6125
allow local_login_t device_t:dir { read getattr lock search ioctl };
#line 6125
allow local_login_t device_t:lnk_file { read getattr lock ioctl };
#line 6125

#line 6125

#line 6125
allow local_login_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 6125
allow local_login_t lib_t:lnk_file { read getattr lock ioctl };
#line 6125
allow local_login_t ld_so_t:file { read getattr lock execute ioctl };
#line 6125
allow local_login_t ld_so_t:file execute_no_trans;
#line 6125
allow local_login_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 6125
allow local_login_t shlib_t:file { read getattr lock execute ioctl };
#line 6125
allow local_login_t shlib_t:lnk_file { read getattr lock ioctl };
#line 6125
allow local_login_t ld_so_cache_t:file { read getattr lock ioctl };
#line 6125
allow local_login_t device_t:dir search;
#line 6125
allow local_login_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 6125
;
#line 6125

#line 6125

#line 6125
type local_login_tmp_t, file_type, sysadmfile, tmpfile ;
#line 6125

#line 6125

#line 6125

#line 6125

#line 6125
#
#line 6125
# Allow the process to modify the directory.
#line 6125
#
#line 6125
allow local_login_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 6125

#line 6125
#
#line 6125
# Allow the process to create the file.
#line 6125
#
#line 6125

#line 6125
allow local_login_t local_login_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 6125
allow local_login_t local_login_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 6125

#line 6125

#line 6125
type_transition local_login_t tmp_t:dir local_login_tmp_t;
#line 6125
type_transition local_login_t tmp_t:{ file lnk_file sock_file fifo_file } local_login_tmp_t;
#line 6125

#line 6125

#line 6125

#line 6125

#line 6125
# Use capabilities
#line 6125
allow local_login_t self:capability { setuid setgid chown fowner fsetid net_bind_service sys_tty_config dac_override sys_nice sys_resource };
#line 6125

#line 6125
# Run shells in user_t by default.
#line 6125

#line 6125

#line 6125

#line 6125
#
#line 6125
# Allow the process to transition to the new domain.
#line 6125
#
#line 6125
allow local_login_t user_t:process transition;
#line 6125

#line 6125
#
#line 6125
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6125
#
#line 6125
dontaudit local_login_t user_t:process noatsecure;
#line 6125

#line 6125
#
#line 6125
# Allow the process to execute the program.
#line 6125
# 
#line 6125
allow local_login_t shell_exec_t:file { read { getattr execute } };
#line 6125

#line 6125
#
#line 6125
# Allow the process to reap the new domain.
#line 6125
#
#line 6125
allow user_t local_login_t:process sigchld;
#line 6125

#line 6125
#
#line 6125
# Allow the new domain to inherit and use file 
#line 6125
# descriptions from the creating process and vice versa.
#line 6125
#
#line 6125
allow user_t local_login_t:fd use;
#line 6125
allow local_login_t user_t:fd use;
#line 6125

#line 6125
#
#line 6125
# Allow the new domain to write back to the old domain via a pipe.
#line 6125
#
#line 6125
allow user_t local_login_t:fifo_file { ioctl read getattr lock write append };
#line 6125

#line 6125
#
#line 6125
# Allow the new domain to read and execute the program.
#line 6125
#
#line 6125
allow user_t shell_exec_t:file { read getattr lock execute ioctl };
#line 6125

#line 6125
#
#line 6125
# Allow the new domain to be entered via the program.
#line 6125
#
#line 6125
allow user_t shell_exec_t:file entrypoint;
#line 6125

#line 6125
type_transition local_login_t shell_exec_t:process user_t;
#line 6125

#line 6125

#line 6125
# Set exec context.
#line 6125

#line 6125
allow local_login_t self:process setexec;
#line 6125
allow local_login_t proc_t:dir search;
#line 6125
allow local_login_t proc_t:lnk_file read;
#line 6125
allow local_login_t self:dir search;
#line 6125
allow local_login_t self:file { read write };
#line 6125

#line 6125

#line 6125
# Permit login to search the user home directories.
#line 6125
allow local_login_t home_root_t:dir search;
#line 6125
allow local_login_t home_dir_type:dir search;
#line 6125

#line 6125
# Write to /var/run/utmp.
#line 6125
allow local_login_t var_run_t:dir search;
#line 6125
allow local_login_t initrc_var_run_t:file { ioctl read getattr lock write append };
#line 6125

#line 6125
# Write to /var/log/wtmp.
#line 6125
allow local_login_t var_log_t:dir search;
#line 6125
allow local_login_t wtmp_t:file { ioctl read getattr lock write append };
#line 6125

#line 6125
# Write to /var/log/lastlog.
#line 6125
allow local_login_t lastlog_t:file { ioctl read getattr lock write append };
#line 6125

#line 6125
# Write to /var/log/btmp
#line 6125
allow local_login_t faillog_t:file { append read write };
#line 6125

#line 6125
# Search for mail spool file.
#line 6125
allow local_login_t mail_spool_t:dir { read getattr lock search ioctl };
#line 6125
allow local_login_t mail_spool_t:file getattr;
#line 6125
allow local_login_t mail_spool_t:lnk_file read;
#line 6125

#line 6125
# Get security policy decisions.
#line 6125

#line 6125
allow local_login_t security_t:dir { read search getattr };
#line 6125
allow local_login_t security_t:file { getattr read write };
#line 6125
allow local_login_t security_t:security { check_context compute_av compute_create compute_relabel compute_user };
#line 6125

#line 6125

#line 6125
# allow read access to default_contexts in /etc/security
#line 6125
allow local_login_t default_context_t:file { read getattr lock ioctl };
#line 6125

#line 6125


# But also permit other user domains to be entered by login.

#line 6128

#line 6128
#
#line 6128
# Allow the process to transition to the new domain.
#line 6128
#
#line 6128
allow local_login_t userdomain:process transition;
#line 6128

#line 6128
#
#line 6128
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6128
#
#line 6128
dontaudit local_login_t userdomain:process noatsecure;
#line 6128

#line 6128
#
#line 6128
# Allow the process to execute the program.
#line 6128
# 
#line 6128
allow local_login_t shell_exec_t:file { read { getattr execute } };
#line 6128

#line 6128
#
#line 6128
# Allow the process to reap the new domain.
#line 6128
#
#line 6128
allow userdomain local_login_t:process sigchld;
#line 6128

#line 6128
#
#line 6128
# Allow the new domain to inherit and use file 
#line 6128
# descriptions from the creating process and vice versa.
#line 6128
#
#line 6128
allow userdomain local_login_t:fd use;
#line 6128
allow local_login_t userdomain:fd use;
#line 6128

#line 6128
#
#line 6128
# Allow the new domain to write back to the old domain via a pipe.
#line 6128
#
#line 6128
allow userdomain local_login_t:fifo_file { ioctl read getattr lock write append };
#line 6128

#line 6128
#
#line 6128
# Allow the new domain to read and execute the program.
#line 6128
#
#line 6128
allow userdomain shell_exec_t:file { read getattr lock execute ioctl };
#line 6128

#line 6128
#
#line 6128
# Allow the new domain to be entered via the program.
#line 6128
#
#line 6128
allow userdomain shell_exec_t:file entrypoint;
#line 6128


# Do not audit denied attempts to access devices.
dontaudit local_login_t fixed_disk_device_t:blk_file { getattr setattr };
dontaudit local_login_t removable_device_t:blk_file { getattr setattr };
dontaudit local_login_t device_t:{ chr_file blk_file lnk_file } { getattr setattr };
dontaudit local_login_t misc_device_t:{ chr_file blk_file lnk_file } { getattr setattr };
dontaudit local_login_t framebuf_device_t:{ chr_file blk_file lnk_file } { getattr setattr read };
dontaudit local_login_t apm_bios_t:chr_file { getattr setattr };
dontaudit local_login_t v4l_device_t:{ chr_file blk_file lnk_file } { getattr setattr read };
dontaudit local_login_t v4l_device_t:dir { read search getattr };

# Do not audit denied attempts to access /mnt.
dontaudit local_login_t file_t:dir { read getattr lock search ioctl };


# Create lock file.
allow local_login_t var_lock_t:dir { read getattr lock search ioctl add_name remove_name write };
allow local_login_t var_lock_t:file { create ioctl read getattr lock write setattr append link unlink rename };


# Read and write ttys.
allow local_login_t tty_device_t:chr_file { setattr { ioctl read getattr lock write append } };
allow local_login_t ttyfile:chr_file { setattr { ioctl read getattr lock write append } };

# Relabel ttys.
allow local_login_t tty_device_t:chr_file { getattr relabelfrom relabelto };
allow local_login_t ttyfile:chr_file { getattr relabelfrom relabelto };

#line 6158


# Allow setting of attributes on sound devices.
allow local_login_t sound_device_t:chr_file { getattr setattr };

# Allow access to /var/run/console and /var/run/console.lock.  Need a separate type?
allow local_login_t var_run_t:dir { read getattr lock search ioctl add_name remove_name write };
allow local_login_t var_run_t:file { create ioctl read getattr lock write setattr append link unlink rename };

#################################
#
# Rules for the remote_login_t domain.
#


#line 6172
type remote_login_t, domain, privuser, privrole, privlog, auth, privowner, mlstrustedreader, mlstrustedwriter, mlstrustedobject, privfd;
#line 6172
role system_r types remote_login_t;
#line 6172

#line 6172
dontaudit remote_login_t shadow_t:file { getattr read };
#line 6172

#line 6172

#line 6172
# Access other processes in the same domain.
#line 6172
# Omits ptrace, setexec, and setfscreate.  These must be granted 
#line 6172
# separately if desired.
#line 6172
allow remote_login_t self:process ~{ptrace setexec setfscreate};
#line 6172

#line 6172
# Access /proc/PID files for processes in the same domain.
#line 6172
allow remote_login_t self:dir { read getattr lock search ioctl };
#line 6172
allow remote_login_t self:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 6172

#line 6172
# Access file descriptions, pipes, and sockets
#line 6172
# created by processes in the same domain.
#line 6172
allow remote_login_t self:fd *;
#line 6172
allow remote_login_t self:fifo_file { ioctl read getattr lock write append };
#line 6172
allow remote_login_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 6172
allow remote_login_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 6172

#line 6172
# Allow the domain to communicate with other processes in the same domain.
#line 6172
allow remote_login_t self:unix_dgram_socket sendto;
#line 6172
allow remote_login_t self:unix_stream_socket connectto;
#line 6172

#line 6172
# Access System V IPC objects created by processes in the same domain.
#line 6172
allow remote_login_t self:sem  { associate getattr setattr create destroy read write unix_read unix_write };
#line 6172
allow remote_login_t self:msg  { send receive };
#line 6172
allow remote_login_t self:msgq { associate getattr setattr create destroy read write enqueue unix_read unix_write };
#line 6172
allow remote_login_t self:shm  { associate getattr setattr create destroy read write lock unix_read unix_write };
#line 6172
;
#line 6172

#line 6172
# Read system information files in /proc.
#line 6172
allow remote_login_t proc_t:dir { read getattr lock search ioctl };
#line 6172
allow remote_login_t proc_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 6172

#line 6172

#line 6172
# Read /.
#line 6172
allow remote_login_t root_t:dir { read getattr lock search ioctl };
#line 6172
allow remote_login_t root_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 6172

#line 6172
# Read /home.
#line 6172
allow remote_login_t home_root_t:dir { read getattr lock search ioctl };
#line 6172

#line 6172
# Read /usr.
#line 6172
allow remote_login_t usr_t:dir { read getattr lock search ioctl };
#line 6172
allow remote_login_t usr_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 6172

#line 6172
# Read bin and sbin directories.
#line 6172
allow remote_login_t bin_t:dir { read getattr lock search ioctl };
#line 6172
allow remote_login_t bin_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 6172
allow remote_login_t sbin_t:dir { read getattr lock search ioctl };
#line 6172
allow remote_login_t sbin_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 6172

#line 6172

#line 6172
# Read directories and files with the readable_t type.
#line 6172
# This type is a general type for "world"-readable files.
#line 6172
allow remote_login_t readable_t:dir { read getattr lock search ioctl };
#line 6172
allow remote_login_t readable_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 6172

#line 6172
# Read /var, /var/spool
#line 6172
allow remote_login_t { var_t var_spool_t }:dir search;
#line 6172

#line 6172
# for when /var/mail is a sym-link
#line 6172
allow remote_login_t var_t:lnk_file read;
#line 6172

#line 6172
# Read /etc.
#line 6172
allow remote_login_t etc_t:dir { read getattr lock search ioctl };
#line 6172
allow remote_login_t etc_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 6172
allow remote_login_t etc_runtime_t:{ file lnk_file } { read getattr lock ioctl };
#line 6172

#line 6172

#line 6172
allow remote_login_t etc_t:lnk_file read;
#line 6172

#line 6172
allow remote_login_t locale_t:dir { read getattr lock search ioctl };
#line 6172
allow remote_login_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 6172

#line 6172

#line 6172

#line 6172
# Read executable types.
#line 6172
allow remote_login_t exec_type:{ file lnk_file } { read getattr lock ioctl };
#line 6172

#line 6172
# Read /dev directories and any symbolic links.
#line 6172
allow remote_login_t device_t:dir { read getattr lock search ioctl };
#line 6172
allow remote_login_t device_t:lnk_file { read getattr lock ioctl };
#line 6172

#line 6172

#line 6172
allow remote_login_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 6172
allow remote_login_t lib_t:lnk_file { read getattr lock ioctl };
#line 6172
allow remote_login_t ld_so_t:file { read getattr lock execute ioctl };
#line 6172
allow remote_login_t ld_so_t:file execute_no_trans;
#line 6172
allow remote_login_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 6172
allow remote_login_t shlib_t:file { read getattr lock execute ioctl };
#line 6172
allow remote_login_t shlib_t:lnk_file { read getattr lock ioctl };
#line 6172
allow remote_login_t ld_so_cache_t:file { read getattr lock ioctl };
#line 6172
allow remote_login_t device_t:dir search;
#line 6172
allow remote_login_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 6172
;
#line 6172

#line 6172

#line 6172
type remote_login_tmp_t, file_type, sysadmfile, tmpfile ;
#line 6172

#line 6172

#line 6172

#line 6172

#line 6172
#
#line 6172
# Allow the process to modify the directory.
#line 6172
#
#line 6172
allow remote_login_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 6172

#line 6172
#
#line 6172
# Allow the process to create the file.
#line 6172
#
#line 6172

#line 6172
allow remote_login_t remote_login_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 6172
allow remote_login_t remote_login_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 6172

#line 6172

#line 6172
type_transition remote_login_t tmp_t:dir remote_login_tmp_t;
#line 6172
type_transition remote_login_t tmp_t:{ file lnk_file sock_file fifo_file } remote_login_tmp_t;
#line 6172

#line 6172

#line 6172

#line 6172

#line 6172
# Use capabilities
#line 6172
allow remote_login_t self:capability { setuid setgid chown fowner fsetid net_bind_service sys_tty_config dac_override sys_nice sys_resource };
#line 6172

#line 6172
# Run shells in user_t by default.
#line 6172

#line 6172

#line 6172

#line 6172
#
#line 6172
# Allow the process to transition to the new domain.
#line 6172
#
#line 6172
allow remote_login_t user_t:process transition;
#line 6172

#line 6172
#
#line 6172
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6172
#
#line 6172
dontaudit remote_login_t user_t:process noatsecure;
#line 6172

#line 6172
#
#line 6172
# Allow the process to execute the program.
#line 6172
# 
#line 6172
allow remote_login_t shell_exec_t:file { read { getattr execute } };
#line 6172

#line 6172
#
#line 6172
# Allow the process to reap the new domain.
#line 6172
#
#line 6172
allow user_t remote_login_t:process sigchld;
#line 6172

#line 6172
#
#line 6172
# Allow the new domain to inherit and use file 
#line 6172
# descriptions from the creating process and vice versa.
#line 6172
#
#line 6172
allow user_t remote_login_t:fd use;
#line 6172
allow remote_login_t user_t:fd use;
#line 6172

#line 6172
#
#line 6172
# Allow the new domain to write back to the old domain via a pipe.
#line 6172
#
#line 6172
allow user_t remote_login_t:fifo_file { ioctl read getattr lock write append };
#line 6172

#line 6172
#
#line 6172
# Allow the new domain to read and execute the program.
#line 6172
#
#line 6172
allow user_t shell_exec_t:file { read getattr lock execute ioctl };
#line 6172

#line 6172
#
#line 6172
# Allow the new domain to be entered via the program.
#line 6172
#
#line 6172
allow user_t shell_exec_t:file entrypoint;
#line 6172

#line 6172
type_transition remote_login_t shell_exec_t:process user_t;
#line 6172

#line 6172

#line 6172
# Set exec context.
#line 6172

#line 6172
allow remote_login_t self:process setexec;
#line 6172
allow remote_login_t proc_t:dir search;
#line 6172
allow remote_login_t proc_t:lnk_file read;
#line 6172
allow remote_login_t self:dir search;
#line 6172
allow remote_login_t self:file { read write };
#line 6172

#line 6172

#line 6172
# Permit login to search the user home directories.
#line 6172
allow remote_login_t home_root_t:dir search;
#line 6172
allow remote_login_t home_dir_type:dir search;
#line 6172

#line 6172
# Write to /var/run/utmp.
#line 6172
allow remote_login_t var_run_t:dir search;
#line 6172
allow remote_login_t initrc_var_run_t:file { ioctl read getattr lock write append };
#line 6172

#line 6172
# Write to /var/log/wtmp.
#line 6172
allow remote_login_t var_log_t:dir search;
#line 6172
allow remote_login_t wtmp_t:file { ioctl read getattr lock write append };
#line 6172

#line 6172
# Write to /var/log/lastlog.
#line 6172
allow remote_login_t lastlog_t:file { ioctl read getattr lock write append };
#line 6172

#line 6172
# Write to /var/log/btmp
#line 6172
allow remote_login_t faillog_t:file { append read write };
#line 6172

#line 6172
# Search for mail spool file.
#line 6172
allow remote_login_t mail_spool_t:dir { read getattr lock search ioctl };
#line 6172
allow remote_login_t mail_spool_t:file getattr;
#line 6172
allow remote_login_t mail_spool_t:lnk_file read;
#line 6172

#line 6172
# Get security policy decisions.
#line 6172

#line 6172
allow remote_login_t security_t:dir { read search getattr };
#line 6172
allow remote_login_t security_t:file { getattr read write };
#line 6172
allow remote_login_t security_t:security { check_context compute_av compute_create compute_relabel compute_user };
#line 6172

#line 6172

#line 6172
# allow read access to default_contexts in /etc/security
#line 6172
allow remote_login_t default_context_t:file { read getattr lock ioctl };
#line 6172

#line 6172


# Only permit unprivileged user domains to be entered via rlogin,
# since very weak authentication is used.

#line 6176

#line 6176
#
#line 6176
# Allow the process to transition to the new domain.
#line 6176
#
#line 6176
allow remote_login_t unpriv_userdomain:process transition;
#line 6176

#line 6176
#
#line 6176
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6176
#
#line 6176
dontaudit remote_login_t unpriv_userdomain:process noatsecure;
#line 6176

#line 6176
#
#line 6176
# Allow the process to execute the program.
#line 6176
# 
#line 6176
allow remote_login_t shell_exec_t:file { read { getattr execute } };
#line 6176

#line 6176
#
#line 6176
# Allow the process to reap the new domain.
#line 6176
#
#line 6176
allow unpriv_userdomain remote_login_t:process sigchld;
#line 6176

#line 6176
#
#line 6176
# Allow the new domain to inherit and use file 
#line 6176
# descriptions from the creating process and vice versa.
#line 6176
#
#line 6176
allow unpriv_userdomain remote_login_t:fd use;
#line 6176
allow remote_login_t unpriv_userdomain:fd use;
#line 6176

#line 6176
#
#line 6176
# Allow the new domain to write back to the old domain via a pipe.
#line 6176
#
#line 6176
allow unpriv_userdomain remote_login_t:fifo_file { ioctl read getattr lock write append };
#line 6176

#line 6176
#
#line 6176
# Allow the new domain to read and execute the program.
#line 6176
#
#line 6176
allow unpriv_userdomain shell_exec_t:file { read getattr lock execute ioctl };
#line 6176

#line 6176
#
#line 6176
# Allow the new domain to be entered via the program.
#line 6176
#
#line 6176
allow unpriv_userdomain shell_exec_t:file entrypoint;
#line 6176


allow remote_login_t devpts_t:dir search;

# Use the pty created by rlogind.
#line 6186

allow remote_login_t ptyfile:chr_file { getattr relabelfrom relabelto };

#DESC Logrotate - Rotate log files
#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
# X-Debian-Packages: logrotate
#

#################################
#
# Rules for the logrotate_t domain.
#
# logrotate_t is the domain for the logrotate program.
# logrotate_exec_t is the type of the corresponding program.
#
type logrotate_t, domain, privowner, privmail;
role system_r types logrotate_t;
role sysadm_r types logrotate_t;

#line 6205
allow logrotate_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 6205
allow logrotate_t lib_t:lnk_file { read getattr lock ioctl };
#line 6205
allow logrotate_t ld_so_t:file { read getattr lock execute ioctl };
#line 6205
allow logrotate_t ld_so_t:file execute_no_trans;
#line 6205
allow logrotate_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 6205
allow logrotate_t shlib_t:file { read getattr lock execute ioctl };
#line 6205
allow logrotate_t shlib_t:lnk_file { read getattr lock ioctl };
#line 6205
allow logrotate_t ld_so_cache_t:file { read getattr lock ioctl };
#line 6205
allow logrotate_t device_t:dir search;
#line 6205
allow logrotate_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 6205
;

#line 6206
# Access other processes in the same domain.
#line 6206
# Omits ptrace, setexec, and setfscreate.  These must be granted 
#line 6206
# separately if desired.
#line 6206
allow logrotate_t self:process ~{ptrace setexec setfscreate};
#line 6206

#line 6206
# Access /proc/PID files for processes in the same domain.
#line 6206
allow logrotate_t self:dir { read getattr lock search ioctl };
#line 6206
allow logrotate_t self:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 6206

#line 6206
# Access file descriptions, pipes, and sockets
#line 6206
# created by processes in the same domain.
#line 6206
allow logrotate_t self:fd *;
#line 6206
allow logrotate_t self:fifo_file { ioctl read getattr lock write append };
#line 6206
allow logrotate_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 6206
allow logrotate_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 6206

#line 6206
# Allow the domain to communicate with other processes in the same domain.
#line 6206
allow logrotate_t self:unix_dgram_socket sendto;
#line 6206
allow logrotate_t self:unix_stream_socket connectto;
#line 6206

#line 6206
# Access System V IPC objects created by processes in the same domain.
#line 6206
allow logrotate_t self:sem  { associate getattr setattr create destroy read write unix_read unix_write };
#line 6206
allow logrotate_t self:msg  { send receive };
#line 6206
allow logrotate_t self:msgq { associate getattr setattr create destroy read write enqueue unix_read unix_write };
#line 6206
allow logrotate_t self:shm  { associate getattr setattr create destroy read write lock unix_read unix_write };
#line 6206
;
type logrotate_exec_t, file_type, sysadmfile, exec_type;


#line 6209

#line 6209

#line 6209

#line 6209
#
#line 6209
# Allow the process to transition to the new domain.
#line 6209
#
#line 6209
allow system_crond_t logrotate_t:process transition;
#line 6209

#line 6209
#
#line 6209
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6209
#
#line 6209
dontaudit system_crond_t logrotate_t:process noatsecure;
#line 6209

#line 6209
#
#line 6209
# Allow the process to execute the program.
#line 6209
# 
#line 6209
allow system_crond_t logrotate_exec_t:file { read { getattr execute } };
#line 6209

#line 6209
#
#line 6209
# Allow the process to reap the new domain.
#line 6209
#
#line 6209
allow logrotate_t system_crond_t:process sigchld;
#line 6209

#line 6209
#
#line 6209
# Allow the new domain to inherit and use file 
#line 6209
# descriptions from the creating process and vice versa.
#line 6209
#
#line 6209
allow logrotate_t system_crond_t:fd use;
#line 6209
allow system_crond_t logrotate_t:fd use;
#line 6209

#line 6209
#
#line 6209
# Allow the new domain to write back to the old domain via a pipe.
#line 6209
#
#line 6209
allow logrotate_t system_crond_t:fifo_file { ioctl read getattr lock write append };
#line 6209

#line 6209
#
#line 6209
# Allow the new domain to read and execute the program.
#line 6209
#
#line 6209
allow logrotate_t logrotate_exec_t:file { read getattr lock execute ioctl };
#line 6209

#line 6209
#
#line 6209
# Allow the new domain to be entered via the program.
#line 6209
#
#line 6209
allow logrotate_t logrotate_exec_t:file entrypoint;
#line 6209

#line 6209
type_transition system_crond_t logrotate_exec_t:process logrotate_t;
#line 6209

#line 6209
allow logrotate_t crond_t:fifo_file { getattr read write ioctl };
#line 6209
# a rule for privfd may make this obsolete
#line 6209
allow logrotate_t crond_t:fd use;
#line 6209
allow logrotate_t crond_t:process sigchld;
#line 6209


#line 6210

#line 6210

#line 6210
#
#line 6210
# Allow the process to transition to the new domain.
#line 6210
#
#line 6210
allow sysadm_t logrotate_t:process transition;
#line 6210

#line 6210
#
#line 6210
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6210
#
#line 6210
dontaudit sysadm_t logrotate_t:process noatsecure;
#line 6210

#line 6210
#
#line 6210
# Allow the process to execute the program.
#line 6210
# 
#line 6210
allow sysadm_t logrotate_exec_t:file { read { getattr execute } };
#line 6210

#line 6210
#
#line 6210
# Allow the process to reap the new domain.
#line 6210
#
#line 6210
allow logrotate_t sysadm_t:process sigchld;
#line 6210

#line 6210
#
#line 6210
# Allow the new domain to inherit and use file 
#line 6210
# descriptions from the creating process and vice versa.
#line 6210
#
#line 6210
allow logrotate_t sysadm_t:fd use;
#line 6210
allow sysadm_t logrotate_t:fd use;
#line 6210

#line 6210
#
#line 6210
# Allow the new domain to write back to the old domain via a pipe.
#line 6210
#
#line 6210
allow logrotate_t sysadm_t:fifo_file { ioctl read getattr lock write append };
#line 6210

#line 6210
#
#line 6210
# Allow the new domain to read and execute the program.
#line 6210
#
#line 6210
allow logrotate_t logrotate_exec_t:file { read getattr lock execute ioctl };
#line 6210

#line 6210
#
#line 6210
# Allow the new domain to be entered via the program.
#line 6210
#
#line 6210
allow logrotate_t logrotate_exec_t:file entrypoint;
#line 6210

#line 6210
type_transition sysadm_t logrotate_exec_t:process logrotate_t;
#line 6210

allow logrotate_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
allow logrotate_t devtty_t:chr_file { ioctl read getattr lock write append };

# access files in /etc
allow logrotate_t etc_t:file { getattr read ioctl };
allow logrotate_t etc_t:lnk_file read;
allow logrotate_t etc_runtime_t:file { read getattr lock ioctl };

# it should not require this
allow logrotate_t sysadm_home_dir_t:dir { read getattr search };

# create lock files

#line 6223
allow logrotate_t var_lock_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 6223
allow logrotate_t var_lock_t:{ file lnk_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 6223


# Create temporary files.

#line 6226
type logrotate_tmp_t, file_type, sysadmfile, tmpfile ;
#line 6226

#line 6226

#line 6226

#line 6226

#line 6226
#
#line 6226
# Allow the process to modify the directory.
#line 6226
#
#line 6226
allow logrotate_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 6226

#line 6226
#
#line 6226
# Allow the process to create the file.
#line 6226
#
#line 6226

#line 6226
allow logrotate_t logrotate_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 6226
allow logrotate_t logrotate_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 6226

#line 6226

#line 6226
type_transition logrotate_t tmp_t:dir logrotate_tmp_t;
#line 6226
type_transition logrotate_t tmp_t:{ file lnk_file sock_file fifo_file } logrotate_tmp_t;
#line 6226

#line 6226

#line 6226


# Run helper programs.
allow logrotate_t { bin_t sbin_t }:dir { read getattr lock search ioctl };
allow logrotate_t { bin_t sbin_t }:lnk_file read;

#line 6231
allow logrotate_t { bin_t sbin_t shell_exec_t initrc_exec_t ls_exec_t }:file { { read getattr lock execute ioctl } execute_no_trans };
#line 6231
;

# Read PID files.
allow logrotate_t pidfile:file { read getattr lock ioctl };

# Read /proc/PID directories for all domains.
allow logrotate_t proc_t:dir { read getattr lock search ioctl };
allow logrotate_t proc_t:{ file lnk_file } { read getattr lock ioctl };
allow logrotate_t { sysctl_t sysctl_kernel_t }:dir search;
allow logrotate_t sysctl_kernel_t:file { getattr read };
allow logrotate_t domain:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
allow logrotate_t domain:dir { read getattr lock search ioctl };
allow logrotate_t exec_type:file getattr;

# Read /dev directories and any symbolic links.
allow logrotate_t device_t:dir { read getattr lock search ioctl };
allow logrotate_t device_t:lnk_file { read getattr lock ioctl };

# Signal processes.
allow logrotate_t domain:process signal;

# Modify /var/log and other log dirs.
allow logrotate_t var_t:dir { read getattr lock search ioctl };
allow logrotate_t logfile:dir { read getattr lock search ioctl add_name remove_name write };
allow logrotate_t logfile:lnk_file read;

# Create, rename, and truncate log files.
allow logrotate_t logfile:file { create ioctl read getattr lock write setattr append link unlink rename };
allow logrotate_t wtmp_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 6265


# Set a context other than the default one for newly created files.

#line 6268
allow logrotate_t self:process setfscreate;
#line 6268
allow logrotate_t proc_t:dir search;
#line 6268
allow logrotate_t proc_t:lnk_file read;
#line 6268
allow logrotate_t self:dir search;
#line 6268
allow logrotate_t self:file { read write };
#line 6268


# Change ownership on log files.
allow logrotate_t self:capability { chown dac_override dac_read_search kill fsetid fowner };
# for mailx
dontaudit logrotate_t self:capability { setuid setgid };

#line 6277


# Access /var/run
allow logrotate_t var_run_t:dir { read getattr lock search ioctl };

# for /var/lib/logrotate.status and /var/lib/logcheck

#line 6283
type logrotate_var_lib_t alias var_lib_logrotate_t, file_type, sysadmfile;
#line 6283

#line 6283

#line 6283

#line 6283

#line 6283
#
#line 6283
# Allow the process to modify the directory.
#line 6283
#
#line 6283
allow logrotate_t var_lib_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 6283

#line 6283
#
#line 6283
# Allow the process to create the file.
#line 6283
#
#line 6283

#line 6283

#line 6283
allow logrotate_t logrotate_var_lib_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 6283

#line 6283

#line 6283
type_transition logrotate_t var_lib_t:file logrotate_var_lib_t;
#line 6283

#line 6283

#line 6283
allow logrotate_t logrotate_var_lib_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 6283


# Write to /var/spool/slrnpull - should be moved into its own type.
allow logrotate_t var_spool_t:dir { search write add_name remove_name };
allow logrotate_t var_spool_t:file { rename create setattr unlink };

# Access terminals.
allow logrotate_t { sysadm_tty_device_t sysadm_devpts_t }:chr_file { ioctl read getattr lock write append };


# for /var/backups on Debian
#line 6296



#line 6298
allow logrotate_t etc_t:lnk_file read;
#line 6298

#line 6298
allow logrotate_t locale_t:dir { read getattr lock search ioctl };
#line 6298
allow logrotate_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 6298

#line 6298


allow logrotate_t fs_t:filesystem getattr;

#line 6301
allow logrotate_t shell_exec_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 6301

#DESC Modutil - Dynamic module utilities
#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
# X-Debian-Packages: modutils
#

#################################
#
# Rules for the module utility domains.
#
type modules_dep_t, file_type, sysadmfile;
type modules_conf_t, file_type, sysadmfile;
type modules_object_t, file_type, sysadmfile;


#################################
#
# Rules for the depmod_t domain.
#
type depmod_t, domain;
role system_r types depmod_t;
role sysadm_r types depmod_t;


#line 6325
allow depmod_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 6325
allow depmod_t lib_t:lnk_file { read getattr lock ioctl };
#line 6325
allow depmod_t ld_so_t:file { read getattr lock execute ioctl };
#line 6325
allow depmod_t ld_so_t:file execute_no_trans;
#line 6325
allow depmod_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 6325
allow depmod_t shlib_t:file { read getattr lock execute ioctl };
#line 6325
allow depmod_t shlib_t:lnk_file { read getattr lock ioctl };
#line 6325
allow depmod_t ld_so_cache_t:file { read getattr lock ioctl };
#line 6325
allow depmod_t device_t:dir search;
#line 6325
allow depmod_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 6325


type depmod_exec_t, file_type, exec_type, sysadmfile;

#line 6328

#line 6328

#line 6328
#
#line 6328
# Allow the process to transition to the new domain.
#line 6328
#
#line 6328
allow initrc_t depmod_t:process transition;
#line 6328

#line 6328
#
#line 6328
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6328
#
#line 6328
dontaudit initrc_t depmod_t:process noatsecure;
#line 6328

#line 6328
#
#line 6328
# Allow the process to execute the program.
#line 6328
# 
#line 6328
allow initrc_t depmod_exec_t:file { read { getattr execute } };
#line 6328

#line 6328
#
#line 6328
# Allow the process to reap the new domain.
#line 6328
#
#line 6328
allow depmod_t initrc_t:process sigchld;
#line 6328

#line 6328
#
#line 6328
# Allow the new domain to inherit and use file 
#line 6328
# descriptions from the creating process and vice versa.
#line 6328
#
#line 6328
allow depmod_t initrc_t:fd use;
#line 6328
allow initrc_t depmod_t:fd use;
#line 6328

#line 6328
#
#line 6328
# Allow the new domain to write back to the old domain via a pipe.
#line 6328
#
#line 6328
allow depmod_t initrc_t:fifo_file { ioctl read getattr lock write append };
#line 6328

#line 6328
#
#line 6328
# Allow the new domain to read and execute the program.
#line 6328
#
#line 6328
allow depmod_t depmod_exec_t:file { read getattr lock execute ioctl };
#line 6328

#line 6328
#
#line 6328
# Allow the new domain to be entered via the program.
#line 6328
#
#line 6328
allow depmod_t depmod_exec_t:file entrypoint;
#line 6328

#line 6328
type_transition initrc_t depmod_exec_t:process depmod_t;
#line 6328

allow depmod_t { bin_t sbin_t }:dir search;

#line 6330
allow depmod_t depmod_exec_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 6330


#line 6331

#line 6331

#line 6331
#
#line 6331
# Allow the process to transition to the new domain.
#line 6331
#
#line 6331
allow sysadm_t depmod_t:process transition;
#line 6331

#line 6331
#
#line 6331
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6331
#
#line 6331
dontaudit sysadm_t depmod_t:process noatsecure;
#line 6331

#line 6331
#
#line 6331
# Allow the process to execute the program.
#line 6331
# 
#line 6331
allow sysadm_t depmod_exec_t:file { read { getattr execute } };
#line 6331

#line 6331
#
#line 6331
# Allow the process to reap the new domain.
#line 6331
#
#line 6331
allow depmod_t sysadm_t:process sigchld;
#line 6331

#line 6331
#
#line 6331
# Allow the new domain to inherit and use file 
#line 6331
# descriptions from the creating process and vice versa.
#line 6331
#
#line 6331
allow depmod_t sysadm_t:fd use;
#line 6331
allow sysadm_t depmod_t:fd use;
#line 6331

#line 6331
#
#line 6331
# Allow the new domain to write back to the old domain via a pipe.
#line 6331
#
#line 6331
allow depmod_t sysadm_t:fifo_file { ioctl read getattr lock write append };
#line 6331

#line 6331
#
#line 6331
# Allow the new domain to read and execute the program.
#line 6331
#
#line 6331
allow depmod_t depmod_exec_t:file { read getattr lock execute ioctl };
#line 6331

#line 6331
#
#line 6331
# Allow the new domain to be entered via the program.
#line 6331
#
#line 6331
allow depmod_t depmod_exec_t:file entrypoint;
#line 6331

#line 6331
type_transition sysadm_t depmod_exec_t:process depmod_t;
#line 6331


# Inherit and use descriptors from init and login programs.
allow depmod_t { init_t privfd }:fd use;

allow depmod_t { etc_t etc_runtime_t }:file { getattr read };
allow depmod_t { device_t proc_t }:dir search;
allow depmod_t proc_t:file { getattr read };
allow depmod_t fs_t:filesystem getattr;

# read system.map
allow depmod_t boot_t:dir search;
allow depmod_t system_map_t:file { getattr read };

# Read conf.modules.
allow depmod_t modules_conf_t:file { read getattr lock ioctl };

# Create modules.dep.

#line 6349

#line 6349

#line 6349

#line 6349
#
#line 6349
# Allow the process to modify the directory.
#line 6349
#
#line 6349
allow depmod_t modules_object_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 6349

#line 6349
#
#line 6349
# Allow the process to create the file.
#line 6349
#
#line 6349

#line 6349

#line 6349
allow depmod_t modules_dep_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 6349

#line 6349

#line 6349
type_transition depmod_t modules_object_t:file modules_dep_t;
#line 6349

#line 6349


# Read module objects.
allow depmod_t modules_object_t:dir { read getattr lock search ioctl };
allow depmod_t modules_object_t:{ file lnk_file } { read getattr lock ioctl };

# Access terminals.
allow depmod_t { console_device_t initrc_devpts_t { sysadm_tty_device_t sysadm_devpts_t } }:chr_file { ioctl read getattr lock write append };


# Read System.map from home directories.
allow depmod_t { home_root_t staff_home_dir_t sysadm_home_dir_t }:dir { read getattr lock search ioctl };

#line 6361
allow depmod_t { staff_home_t sysadm_home_t }:dir { read getattr lock search ioctl };
#line 6361
allow depmod_t { staff_home_t sysadm_home_t }:{ file lnk_file } { read getattr lock ioctl };
#line 6361


#################################
#
# Rules for the insmod_t domain.
#

type insmod_t, domain, privlog;
role system_r types insmod_t;
role sysadm_r types insmod_t;


#line 6372
allow insmod_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 6372
allow insmod_t lib_t:lnk_file { read getattr lock ioctl };
#line 6372
allow insmod_t ld_so_t:file { read getattr lock execute ioctl };
#line 6372
allow insmod_t ld_so_t:file execute_no_trans;
#line 6372
allow insmod_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 6372
allow insmod_t shlib_t:file { read getattr lock execute ioctl };
#line 6372
allow insmod_t shlib_t:lnk_file { read getattr lock ioctl };
#line 6372
allow insmod_t ld_so_cache_t:file { read getattr lock ioctl };
#line 6372
allow insmod_t device_t:dir search;
#line 6372
allow insmod_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 6372


#line 6373
allow insmod_t etc_t:lnk_file read;
#line 6373

#line 6373
allow insmod_t locale_t:dir { read getattr lock search ioctl };
#line 6373
allow insmod_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 6373

#line 6373


allow insmod_t self:udp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };

type insmod_exec_t, file_type, exec_type, sysadmfile;

#line 6378

#line 6378

#line 6378
#
#line 6378
# Allow the process to transition to the new domain.
#line 6378
#
#line 6378
allow { initrc_t kernel_t } insmod_t:process transition;
#line 6378

#line 6378
#
#line 6378
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6378
#
#line 6378
dontaudit { initrc_t kernel_t } insmod_t:process noatsecure;
#line 6378

#line 6378
#
#line 6378
# Allow the process to execute the program.
#line 6378
# 
#line 6378
allow { initrc_t kernel_t } insmod_exec_t:file { read { getattr execute } };
#line 6378

#line 6378
#
#line 6378
# Allow the process to reap the new domain.
#line 6378
#
#line 6378
allow insmod_t { initrc_t kernel_t }:process sigchld;
#line 6378

#line 6378
#
#line 6378
# Allow the new domain to inherit and use file 
#line 6378
# descriptions from the creating process and vice versa.
#line 6378
#
#line 6378
allow insmod_t { initrc_t kernel_t }:fd use;
#line 6378
allow { initrc_t kernel_t } insmod_t:fd use;
#line 6378

#line 6378
#
#line 6378
# Allow the new domain to write back to the old domain via a pipe.
#line 6378
#
#line 6378
allow insmod_t { initrc_t kernel_t }:fifo_file { ioctl read getattr lock write append };
#line 6378

#line 6378
#
#line 6378
# Allow the new domain to read and execute the program.
#line 6378
#
#line 6378
allow insmod_t insmod_exec_t:file { read getattr lock execute ioctl };
#line 6378

#line 6378
#
#line 6378
# Allow the new domain to be entered via the program.
#line 6378
#
#line 6378
allow insmod_t insmod_exec_t:file entrypoint;
#line 6378

#line 6378
type_transition { initrc_t kernel_t } insmod_exec_t:process insmod_t;
#line 6378

allow initrc_t insmod_exec_t:lnk_file read;

#line 6380
allow insmod_t insmod_exec_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 6380

allow insmod_t { bin_t sbin_t }:dir search;
allow insmod_t sbin_t:lnk_file read;
allow insmod_t init_t:fd use;

#line 6384

#line 6384

#line 6384
#
#line 6384
# Allow the process to transition to the new domain.
#line 6384
#
#line 6384
allow sysadm_t insmod_t:process transition;
#line 6384

#line 6384
#
#line 6384
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6384
#
#line 6384
dontaudit sysadm_t insmod_t:process noatsecure;
#line 6384

#line 6384
#
#line 6384
# Allow the process to execute the program.
#line 6384
# 
#line 6384
allow sysadm_t insmod_exec_t:file { read { getattr execute } };
#line 6384

#line 6384
#
#line 6384
# Allow the process to reap the new domain.
#line 6384
#
#line 6384
allow insmod_t sysadm_t:process sigchld;
#line 6384

#line 6384
#
#line 6384
# Allow the new domain to inherit and use file 
#line 6384
# descriptions from the creating process and vice versa.
#line 6384
#
#line 6384
allow insmod_t sysadm_t:fd use;
#line 6384
allow sysadm_t insmod_t:fd use;
#line 6384

#line 6384
#
#line 6384
# Allow the new domain to write back to the old domain via a pipe.
#line 6384
#
#line 6384
allow insmod_t sysadm_t:fifo_file { ioctl read getattr lock write append };
#line 6384

#line 6384
#
#line 6384
# Allow the new domain to read and execute the program.
#line 6384
#
#line 6384
allow insmod_t insmod_exec_t:file { read getattr lock execute ioctl };
#line 6384

#line 6384
#
#line 6384
# Allow the new domain to be entered via the program.
#line 6384
#
#line 6384
allow insmod_t insmod_exec_t:file entrypoint;
#line 6384

#line 6384
type_transition sysadm_t insmod_exec_t:process insmod_t;
#line 6384


# Read module config and dependency information
allow insmod_t fs_t:filesystem getattr;
allow insmod_t { modules_conf_t modules_dep_t }:file { getattr read };

# Read module objects.
allow insmod_t modules_object_t:dir { read getattr lock search ioctl };
allow insmod_t modules_object_t:{ file lnk_file } { read getattr lock ioctl };

allow insmod_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
allow insmod_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };

# Use the sys_module capability.
allow insmod_t self:capability { sys_module kill };

# for ipv6
allow insmod_t self:capability net_raw;

# Inherit and use descriptors from init.
allow insmod_t privfd:fd use;

# I do not know why insmod sends signals or what signals it sends
allow insmod_t domain:process signal;

# Rules for /proc/sys/kernel/tainted
allow insmod_t { proc_t sysctl_t sysctl_kernel_t }:dir search;
allow insmod_t sysctl_kernel_t:file { setattr { ioctl read getattr lock write append } };
allow insmod_t sysctl_t:file write;
allow insmod_t proc_t:file { getattr read };

# /var/log/ksymoops/*
allow insmod_t var_t:dir { read getattr lock search ioctl };
allow insmod_t var_log_t:dir { read getattr lock search ioctl };
allow insmod_t var_log_ksyms_t:file { create ioctl read getattr lock write setattr append link unlink rename };
allow insmod_t var_log_ksyms_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };

#line 6423

#line 6423

#line 6423
allow system_crond_t var_log_ksyms_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 6423
allow system_crond_t var_log_ksyms_t:{ file lnk_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 6423

#line 6423


#line 6427


allow insmod_t device_t:dir search;
allow insmod_t etc_runtime_t:file { getattr read };
allow insmod_t self:process { fork { sigchld sigkill sigstop signull signal } };

# Access terminals.
allow insmod_t { initrc_devpts_t { sysadm_tty_device_t sysadm_devpts_t } }:chr_file { ioctl read getattr lock write append };



#line 6437
allow insmod_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 6437
allow insmod_t lib_t:lnk_file { read getattr lock ioctl };
#line 6437
allow insmod_t ld_so_t:file { read getattr lock execute ioctl };
#line 6437
allow insmod_t ld_so_t:file execute_no_trans;
#line 6437
allow insmod_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 6437
allow insmod_t shlib_t:file { read getattr lock execute ioctl };
#line 6437
allow insmod_t shlib_t:lnk_file { read getattr lock ioctl };
#line 6437
allow insmod_t ld_so_cache_t:file { read getattr lock ioctl };
#line 6437
allow insmod_t device_t:dir search;
#line 6437
allow insmod_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 6437


# for when /var is not mounted early in the boot
dontaudit insmod_t file_t:dir search;

#################################
#
# Rules for the update_modules_t domain.
#
type update_modules_t, domain, privlog;
type update_modules_exec_t, file_type, exec_type, sysadmfile;

role system_r types update_modules_t;
role sysadm_r types update_modules_t;


#line 6452

#line 6452

#line 6452
#
#line 6452
# Allow the process to transition to the new domain.
#line 6452
#
#line 6452
allow { initrc_t sysadm_t } update_modules_t:process transition;
#line 6452

#line 6452
#
#line 6452
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6452
#
#line 6452
dontaudit { initrc_t sysadm_t } update_modules_t:process noatsecure;
#line 6452

#line 6452
#
#line 6452
# Allow the process to execute the program.
#line 6452
# 
#line 6452
allow { initrc_t sysadm_t } update_modules_exec_t:file { read { getattr execute } };
#line 6452

#line 6452
#
#line 6452
# Allow the process to reap the new domain.
#line 6452
#
#line 6452
allow update_modules_t { initrc_t sysadm_t }:process sigchld;
#line 6452

#line 6452
#
#line 6452
# Allow the new domain to inherit and use file 
#line 6452
# descriptions from the creating process and vice versa.
#line 6452
#
#line 6452
allow update_modules_t { initrc_t sysadm_t }:fd use;
#line 6452
allow { initrc_t sysadm_t } update_modules_t:fd use;
#line 6452

#line 6452
#
#line 6452
# Allow the new domain to write back to the old domain via a pipe.
#line 6452
#
#line 6452
allow update_modules_t { initrc_t sysadm_t }:fifo_file { ioctl read getattr lock write append };
#line 6452

#line 6452
#
#line 6452
# Allow the new domain to read and execute the program.
#line 6452
#
#line 6452
allow update_modules_t update_modules_exec_t:file { read getattr lock execute ioctl };
#line 6452

#line 6452
#
#line 6452
# Allow the new domain to be entered via the program.
#line 6452
#
#line 6452
allow update_modules_t update_modules_exec_t:file entrypoint;
#line 6452

#line 6452
type_transition { initrc_t sysadm_t } update_modules_exec_t:process update_modules_t;
#line 6452

allow update_modules_t privfd:fd use;
allow update_modules_t init_t:fd use;

allow update_modules_t device_t:dir { getattr search };
allow update_modules_t { console_device_t devtty_t }:chr_file { ioctl read getattr lock write append };
allow update_modules_t { initrc_devpts_t { sysadm_tty_device_t sysadm_devpts_t } }:chr_file { ioctl read getattr lock write append };

dontaudit update_modules_t sysadm_home_dir_t:dir search;


#line 6462
allow update_modules_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 6462
allow update_modules_t lib_t:lnk_file { read getattr lock ioctl };
#line 6462
allow update_modules_t ld_so_t:file { read getattr lock execute ioctl };
#line 6462
allow update_modules_t ld_so_t:file execute_no_trans;
#line 6462
allow update_modules_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 6462
allow update_modules_t shlib_t:file { read getattr lock execute ioctl };
#line 6462
allow update_modules_t shlib_t:lnk_file { read getattr lock ioctl };
#line 6462
allow update_modules_t ld_so_cache_t:file { read getattr lock ioctl };
#line 6462
allow update_modules_t device_t:dir search;
#line 6462
allow update_modules_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 6462

allow update_modules_t self:process { fork sigchld };
allow update_modules_t self:fifo_file { ioctl read getattr lock write append };
allow update_modules_t modules_dep_t:file { ioctl read getattr lock write append };

#line 6466

#line 6466

#line 6466

#line 6466
#
#line 6466
# Allow the process to modify the directory.
#line 6466
#
#line 6466
allow update_modules_t modules_object_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 6466

#line 6466
#
#line 6466
# Allow the process to create the file.
#line 6466
#
#line 6466

#line 6466

#line 6466
allow update_modules_t modules_conf_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 6466

#line 6466

#line 6466
type_transition update_modules_t modules_object_t:file modules_conf_t;
#line 6466

#line 6466


#line 6467

#line 6467

#line 6467
#
#line 6467
# Allow the process to transition to the new domain.
#line 6467
#
#line 6467
allow update_modules_t depmod_t:process transition;
#line 6467

#line 6467
#
#line 6467
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6467
#
#line 6467
dontaudit update_modules_t depmod_t:process noatsecure;
#line 6467

#line 6467
#
#line 6467
# Allow the process to execute the program.
#line 6467
# 
#line 6467
allow update_modules_t depmod_exec_t:file { read { getattr execute } };
#line 6467

#line 6467
#
#line 6467
# Allow the process to reap the new domain.
#line 6467
#
#line 6467
allow depmod_t update_modules_t:process sigchld;
#line 6467

#line 6467
#
#line 6467
# Allow the new domain to inherit and use file 
#line 6467
# descriptions from the creating process and vice versa.
#line 6467
#
#line 6467
allow depmod_t update_modules_t:fd use;
#line 6467
allow update_modules_t depmod_t:fd use;
#line 6467

#line 6467
#
#line 6467
# Allow the new domain to write back to the old domain via a pipe.
#line 6467
#
#line 6467
allow depmod_t update_modules_t:fifo_file { ioctl read getattr lock write append };
#line 6467

#line 6467
#
#line 6467
# Allow the new domain to read and execute the program.
#line 6467
#
#line 6467
allow depmod_t depmod_exec_t:file { read getattr lock execute ioctl };
#line 6467

#line 6467
#
#line 6467
# Allow the new domain to be entered via the program.
#line 6467
#
#line 6467
allow depmod_t depmod_exec_t:file entrypoint;
#line 6467

#line 6467
type_transition update_modules_t depmod_exec_t:process depmod_t;
#line 6467


#line 6468
allow update_modules_t { shell_exec_t bin_t sbin_t update_modules_exec_t etc_t }:file { { read getattr lock execute ioctl } execute_no_trans };
#line 6468

allow update_modules_t bin_t:lnk_file read;
allow update_modules_t { sbin_t bin_t }:dir search;
allow update_modules_t { etc_t etc_runtime_t }:file { read getattr lock ioctl };
allow update_modules_t etc_t:lnk_file read;
allow update_modules_t fs_t:filesystem getattr;

allow update_modules_t proc_t:dir search;
allow update_modules_t proc_t:file { read getattr lock ioctl };
allow update_modules_t { self proc_t }:lnk_file read;
allow update_modules_t { sysctl_t sysctl_kernel_t }:dir search;
allow update_modules_t sysctl_kernel_t:file { getattr read };
allow update_modules_t self:dir search;
allow update_modules_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };


#line 6483

#line 6483

#line 6483

#line 6483
#
#line 6483
# Allow the process to modify the directory.
#line 6483
#
#line 6483
allow update_modules_t etc_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 6483

#line 6483
#
#line 6483
# Allow the process to create the file.
#line 6483
#
#line 6483

#line 6483

#line 6483
allow update_modules_t modules_conf_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 6483

#line 6483

#line 6483
type_transition update_modules_t etc_t:file modules_conf_t;
#line 6483

#line 6483


# for when /etc/modules.conf gets the wrong type
allow update_modules_t etc_t:file unlink;


#line 6488
type update_modules_tmp_t, file_type, sysadmfile, tmpfile ;
#line 6488

#line 6488

#line 6488

#line 6488

#line 6488
#
#line 6488
# Allow the process to modify the directory.
#line 6488
#
#line 6488
allow update_modules_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 6488

#line 6488
#
#line 6488
# Allow the process to create the file.
#line 6488
#
#line 6488

#line 6488
allow update_modules_t update_modules_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 6488
allow update_modules_t update_modules_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 6488

#line 6488

#line 6488
type_transition update_modules_t tmp_t:dir update_modules_tmp_t;
#line 6488
type_transition update_modules_t tmp_t:{ file lnk_file sock_file fifo_file } update_modules_tmp_t;
#line 6488

#line 6488

#line 6488

#DESC Mount - Filesystem mount utilities
#
# Macros for mount
#
# Author:  Brian May <bam@snoopy.apana.org.au>
# X-Debian-Packages: mount
#
# based on the work of:
#          Mark Westerman mark.westerman@csoconline.com
#

type mount_exec_t, file_type, sysadmfile, exec_type;


#line 6502
#
#line 6502
# Rules for the mount_t domain, used by the sysadm_t domain.
#line 6502
#
#line 6502
# mount_t is the domain for the mount process.
#line 6502
#
#line 6502
# This macro will not be included by all users and it may be included twice if
#line 6502
# called from other macros, so we need protection for this do not call this
#line 6502
# macro if mount_def is defined
#line 6502

#line 6502
#
#line 6502
type mount_t, domain, privlog , fs_domain;
#line 6502

#line 6502

#line 6502
allow mount_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 6502
allow mount_t lib_t:lnk_file { read getattr lock ioctl };
#line 6502
allow mount_t ld_so_t:file { read getattr lock execute ioctl };
#line 6502
allow mount_t ld_so_t:file execute_no_trans;
#line 6502
allow mount_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 6502
allow mount_t shlib_t:file { read getattr lock execute ioctl };
#line 6502
allow mount_t shlib_t:lnk_file { read getattr lock ioctl };
#line 6502
allow mount_t ld_so_cache_t:file { read getattr lock ioctl };
#line 6502
allow mount_t device_t:dir search;
#line 6502
allow mount_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 6502

#line 6502

#line 6502
# when mount is run by sysadm goto mount_t domain
#line 6502

#line 6502

#line 6502

#line 6502
#
#line 6502
# Allow the process to transition to the new domain.
#line 6502
#
#line 6502
allow sysadm_t mount_t:process transition;
#line 6502

#line 6502
#
#line 6502
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6502
#
#line 6502
dontaudit sysadm_t mount_t:process noatsecure;
#line 6502

#line 6502
#
#line 6502
# Allow the process to execute the program.
#line 6502
# 
#line 6502
allow sysadm_t mount_exec_t:file { read { getattr execute } };
#line 6502

#line 6502
#
#line 6502
# Allow the process to reap the new domain.
#line 6502
#
#line 6502
allow mount_t sysadm_t:process sigchld;
#line 6502

#line 6502
#
#line 6502
# Allow the new domain to inherit and use file 
#line 6502
# descriptions from the creating process and vice versa.
#line 6502
#
#line 6502
allow mount_t sysadm_t:fd use;
#line 6502
allow sysadm_t mount_t:fd use;
#line 6502

#line 6502
#
#line 6502
# Allow the new domain to write back to the old domain via a pipe.
#line 6502
#
#line 6502
allow mount_t sysadm_t:fifo_file { ioctl read getattr lock write append };
#line 6502

#line 6502
#
#line 6502
# Allow the new domain to read and execute the program.
#line 6502
#
#line 6502
allow mount_t mount_exec_t:file { read getattr lock execute ioctl };
#line 6502

#line 6502
#
#line 6502
# Allow the new domain to be entered via the program.
#line 6502
#
#line 6502
allow mount_t mount_exec_t:file entrypoint;
#line 6502

#line 6502
type_transition sysadm_t mount_exec_t:process mount_t;
#line 6502

#line 6502

#line 6502
allow mount_t proc_t:dir search;
#line 6502
allow mount_t proc_t:file { getattr read };
#line 6502

#line 6502

#line 6502
type mount_tmp_t, file_type, sysadmfile, tmpfile ;
#line 6502

#line 6502

#line 6502

#line 6502

#line 6502
#
#line 6502
# Allow the process to modify the directory.
#line 6502
#
#line 6502
allow mount_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 6502

#line 6502
#
#line 6502
# Allow the process to create the file.
#line 6502
#
#line 6502

#line 6502
allow mount_t mount_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 6502
allow mount_t mount_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 6502

#line 6502

#line 6502
type_transition mount_t tmp_t:dir mount_tmp_t;
#line 6502
type_transition mount_t tmp_t:{ file lnk_file sock_file fifo_file } mount_tmp_t;
#line 6502

#line 6502

#line 6502

#line 6502

#line 6502
# Use capabilities.
#line 6502
allow mount_t self:capability { net_bind_service sys_rawio sys_admin };
#line 6502

#line 6502
# Create and modify /etc/mtab.
#line 6502

#line 6502

#line 6502

#line 6502

#line 6502
#
#line 6502
# Allow the process to modify the directory.
#line 6502
#
#line 6502
allow mount_t etc_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 6502

#line 6502
#
#line 6502
# Allow the process to create the file.
#line 6502
#
#line 6502

#line 6502

#line 6502
allow mount_t etc_runtime_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 6502

#line 6502

#line 6502
type_transition mount_t etc_t:file etc_runtime_t;
#line 6502

#line 6502

#line 6502

#line 6502
allow mount_t etc_t:file { getattr read };
#line 6502

#line 6502

#line 6502
allow mount_t etc_t:lnk_file read;
#line 6502

#line 6502
allow mount_t locale_t:dir { read getattr lock search ioctl };
#line 6502
allow mount_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 6502

#line 6502

#line 6502

#line 6502
# Access the terminal.
#line 6502
allow mount_t sysadm_tty_device_t:chr_file { getattr read write ioctl };
#line 6502
allow mount_t sysadm_devpts_t:chr_file { getattr read write };
#line 6502

#line 6502

role sysadm_r types mount_t;
role system_r types mount_t;


#line 6506

#line 6506

#line 6506
#
#line 6506
# Allow the process to transition to the new domain.
#line 6506
#
#line 6506
allow initrc_t mount_t:process transition;
#line 6506

#line 6506
#
#line 6506
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6506
#
#line 6506
dontaudit initrc_t mount_t:process noatsecure;
#line 6506

#line 6506
#
#line 6506
# Allow the process to execute the program.
#line 6506
# 
#line 6506
allow initrc_t mount_exec_t:file { read { getattr execute } };
#line 6506

#line 6506
#
#line 6506
# Allow the process to reap the new domain.
#line 6506
#
#line 6506
allow mount_t initrc_t:process sigchld;
#line 6506

#line 6506
#
#line 6506
# Allow the new domain to inherit and use file 
#line 6506
# descriptions from the creating process and vice versa.
#line 6506
#
#line 6506
allow mount_t initrc_t:fd use;
#line 6506
allow initrc_t mount_t:fd use;
#line 6506

#line 6506
#
#line 6506
# Allow the new domain to write back to the old domain via a pipe.
#line 6506
#
#line 6506
allow mount_t initrc_t:fifo_file { ioctl read getattr lock write append };
#line 6506

#line 6506
#
#line 6506
# Allow the new domain to read and execute the program.
#line 6506
#
#line 6506
allow mount_t mount_exec_t:file { read getattr lock execute ioctl };
#line 6506

#line 6506
#
#line 6506
# Allow the new domain to be entered via the program.
#line 6506
#
#line 6506
allow mount_t mount_exec_t:file entrypoint;
#line 6506

#line 6506
type_transition initrc_t mount_exec_t:process mount_t;
#line 6506

allow mount_t init_t:fd use;
allow mount_t privfd:fd use;

allow mount_t self:capability { ipc_lock dac_override };
allow mount_t self:process { fork { sigchld sigkill sigstop signull signal } };

allow mount_t file_type:dir search;

# Access disk devices.
allow mount_t fixed_disk_device_t:{ chr_file blk_file } { ioctl read getattr lock write append };
allow mount_t removable_device_t:{ chr_file blk_file } { ioctl read getattr lock write append };

# Mount, remount and unmount file systems.
allow mount_t fs_type:filesystem { mount remount unmount getattr };
allow mount_t file_t:dir mounton;
allow mount_t usr_t:dir mounton;
allow mount_t proc_t:dir mounton;
allow mount_t root_t:dir mounton;
allow mount_t home_root_t:dir mounton;
allow mount_t tmp_t:dir mounton;
allow mount_t devpts_t:dir mounton;
# On some RedHat systems, /boot is a mount point
allow mount_t boot_t:dir mounton;
allow mount_t device_t:dir mounton;
#line 6533

allow mount_t root_t:filesystem unmount;

#line 6542

#DESC Netutils - Network utilities
#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil>
# X-Debian-Packages: netbase iputils arping tcpdump 
#

#
# Rules for the netutils_t domain.
# This domain is for network utilities that require access to
# special protocol families.
#
type netutils_t, domain, privlog;
type netutils_exec_t, file_type, sysadmfile, exec_type;
role system_r types netutils_t;
role sysadm_r types netutils_t;


#line 6559
allow netutils_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 6559
allow netutils_t lib_t:lnk_file { read getattr lock ioctl };
#line 6559
allow netutils_t ld_so_t:file { read getattr lock execute ioctl };
#line 6559
allow netutils_t ld_so_t:file execute_no_trans;
#line 6559
allow netutils_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 6559
allow netutils_t shlib_t:file { read getattr lock execute ioctl };
#line 6559
allow netutils_t shlib_t:lnk_file { read getattr lock ioctl };
#line 6559
allow netutils_t ld_so_cache_t:file { read getattr lock ioctl };
#line 6559
allow netutils_t device_t:dir search;
#line 6559
allow netutils_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 6559


#line 6560
#
#line 6560
# Allow the domain to create and use UDP and TCP sockets.
#line 6560
# Other kinds of sockets must be separately authorized for use.
#line 6560
allow netutils_t self:udp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 6560
allow netutils_t self:tcp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 6560

#line 6560
#
#line 6560
# Allow the domain to send UDP packets.
#line 6560
# Since the destination sockets type is unknown, the generic
#line 6560
# any_socket_t type is used as a placeholder.
#line 6560
#
#line 6560
allow netutils_t any_socket_t:udp_socket sendto;
#line 6560

#line 6560
#
#line 6560
# Allow the domain to send using any network interface.
#line 6560
# netif_type is a type attribute for all network interface types.
#line 6560
#
#line 6560
allow netutils_t netif_type:netif { tcp_send udp_send rawip_send };
#line 6560

#line 6560
#
#line 6560
# Allow packets sent by the domain to be received on any network interface.
#line 6560
#
#line 6560
allow netutils_t netif_type:netif { tcp_recv udp_recv rawip_recv };
#line 6560

#line 6560
#
#line 6560
# Allow the domain to receive packets from any network interface.
#line 6560
# netmsg_type is a type attribute for all default message types.
#line 6560
#
#line 6560
allow netutils_t netmsg_type:{ udp_socket tcp_socket rawip_socket } recvfrom;
#line 6560

#line 6560
#
#line 6560
# Allow the domain to initiate or accept TCP connections 
#line 6560
# on any network interface.
#line 6560
#
#line 6560
allow netutils_t netmsg_type:tcp_socket { connectto acceptfrom };
#line 6560

#line 6560
#
#line 6560
# Receive resets from the TCP reset socket.
#line 6560
# The TCP reset socket is labeled with the tcp_socket_t type.
#line 6560
#
#line 6560
allow netutils_t tcp_socket_t:tcp_socket recvfrom;
#line 6560

#line 6560
dontaudit netutils_t tcp_socket_t:tcp_socket connectto;
#line 6560

#line 6560
#
#line 6560
# Allow the domain to send to any node.
#line 6560
# node_type is a type attribute for all node types.
#line 6560
#
#line 6560
allow netutils_t node_type:node { tcp_send udp_send rawip_send };
#line 6560

#line 6560
#
#line 6560
# Allow packets sent by the domain to be received from any node.
#line 6560
#
#line 6560
allow netutils_t node_type:node { tcp_recv udp_recv rawip_recv };
#line 6560

#line 6560
#
#line 6560
# Allow the domain to send NFS client requests via the socket
#line 6560
# created by mount.
#line 6560
#
#line 6560
allow netutils_t mount_t:udp_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 6560

#line 6560
#
#line 6560
# Bind to the default port type.
#line 6560
# Other port types must be separately authorized.
#line 6560
#
#line 6560
#allow netutils_t port_t:udp_socket name_bind;
#line 6560
#allow netutils_t port_t:tcp_socket name_bind;
#line 6560



#line 6562

#line 6562

#line 6562
#
#line 6562
# Allow the process to transition to the new domain.
#line 6562
#
#line 6562
allow initrc_t netutils_t:process transition;
#line 6562

#line 6562
#
#line 6562
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6562
#
#line 6562
dontaudit initrc_t netutils_t:process noatsecure;
#line 6562

#line 6562
#
#line 6562
# Allow the process to execute the program.
#line 6562
# 
#line 6562
allow initrc_t netutils_exec_t:file { read { getattr execute } };
#line 6562

#line 6562
#
#line 6562
# Allow the process to reap the new domain.
#line 6562
#
#line 6562
allow netutils_t initrc_t:process sigchld;
#line 6562

#line 6562
#
#line 6562
# Allow the new domain to inherit and use file 
#line 6562
# descriptions from the creating process and vice versa.
#line 6562
#
#line 6562
allow netutils_t initrc_t:fd use;
#line 6562
allow initrc_t netutils_t:fd use;
#line 6562

#line 6562
#
#line 6562
# Allow the new domain to write back to the old domain via a pipe.
#line 6562
#
#line 6562
allow netutils_t initrc_t:fifo_file { ioctl read getattr lock write append };
#line 6562

#line 6562
#
#line 6562
# Allow the new domain to read and execute the program.
#line 6562
#
#line 6562
allow netutils_t netutils_exec_t:file { read getattr lock execute ioctl };
#line 6562

#line 6562
#
#line 6562
# Allow the new domain to be entered via the program.
#line 6562
#
#line 6562
allow netutils_t netutils_exec_t:file entrypoint;
#line 6562

#line 6562
type_transition initrc_t netutils_exec_t:process netutils_t;
#line 6562


#line 6563

#line 6563

#line 6563
#
#line 6563
# Allow the process to transition to the new domain.
#line 6563
#
#line 6563
allow sysadm_t netutils_t:process transition;
#line 6563

#line 6563
#
#line 6563
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6563
#
#line 6563
dontaudit sysadm_t netutils_t:process noatsecure;
#line 6563

#line 6563
#
#line 6563
# Allow the process to execute the program.
#line 6563
# 
#line 6563
allow sysadm_t netutils_exec_t:file { read { getattr execute } };
#line 6563

#line 6563
#
#line 6563
# Allow the process to reap the new domain.
#line 6563
#
#line 6563
allow netutils_t sysadm_t:process sigchld;
#line 6563

#line 6563
#
#line 6563
# Allow the new domain to inherit and use file 
#line 6563
# descriptions from the creating process and vice versa.
#line 6563
#
#line 6563
allow netutils_t sysadm_t:fd use;
#line 6563
allow sysadm_t netutils_t:fd use;
#line 6563

#line 6563
#
#line 6563
# Allow the new domain to write back to the old domain via a pipe.
#line 6563
#
#line 6563
allow netutils_t sysadm_t:fifo_file { ioctl read getattr lock write append };
#line 6563

#line 6563
#
#line 6563
# Allow the new domain to read and execute the program.
#line 6563
#
#line 6563
allow netutils_t netutils_exec_t:file { read getattr lock execute ioctl };
#line 6563

#line 6563
#
#line 6563
# Allow the new domain to be entered via the program.
#line 6563
#
#line 6563
allow netutils_t netutils_exec_t:file entrypoint;
#line 6563

#line 6563
type_transition sysadm_t netutils_exec_t:process netutils_t;
#line 6563


# Inherit and use descriptors from init.
allow netutils_t init_t:fd use;

allow netutils_t self:process { fork { sigchld sigkill sigstop signull signal } };

# Perform network administration operations and have raw access to the network.
allow netutils_t self:capability { net_admin net_raw setuid setgid };

# Create and use netlink sockets.
allow netutils_t self:netlink_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };

# Create and use packet sockets.
allow netutils_t self:packet_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };

# Create and use UDP sockets.
allow netutils_t self:udp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };

# Create and use TCP sockets.
allow netutils_t self:tcp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };

allow netutils_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };

# Read certain files in /etc
allow netutils_t etc_t:file { read getattr lock ioctl };
allow netutils_t resolv_conf_t:file { read getattr lock ioctl };

#line 6590
allow netutils_t etc_t:lnk_file read;
#line 6590

#line 6590
allow netutils_t locale_t:dir { read getattr lock search ioctl };
#line 6590
allow netutils_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 6590

#line 6590


allow netutils_t fs_t:filesystem getattr;

# Access terminals.
allow netutils_t privfd:fd use;
allow netutils_t { sysadm_tty_device_t sysadm_devpts_t }:chr_file { ioctl read getattr lock write append };

#DESC Newrole - SELinux utility to run a shell with a new role
#
# Authors:  Anthony Colatrella (NSA) 
# Maintained by Stephen Smalley <sds@epoch.ncsc.mil>
# X-Debian-Packages: policycoreutils
#

#################################
#
# Rules for the newrole_t domain.
#
# newrole_t is the domain for the newrole program.
# newrole_exec_t is the type of the newrole executable.
#
type newrole_t, domain, privrole, privowner, privlog, auth, privfd;

#line 6613
role user_r types newrole_t;
#line 6613
role staff_r types newrole_t;
#line 6613

role sysadm_r types newrole_t;


#line 6616
# Access other processes in the same domain.
#line 6616
# Omits ptrace, setexec, and setfscreate.  These must be granted 
#line 6616
# separately if desired.
#line 6616
allow newrole_t self:process ~{ptrace setexec setfscreate};
#line 6616

#line 6616
# Access /proc/PID files for processes in the same domain.
#line 6616
allow newrole_t self:dir { read getattr lock search ioctl };
#line 6616
allow newrole_t self:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 6616

#line 6616
# Access file descriptions, pipes, and sockets
#line 6616
# created by processes in the same domain.
#line 6616
allow newrole_t self:fd *;
#line 6616
allow newrole_t self:fifo_file { ioctl read getattr lock write append };
#line 6616
allow newrole_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 6616
allow newrole_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 6616

#line 6616
# Allow the domain to communicate with other processes in the same domain.
#line 6616
allow newrole_t self:unix_dgram_socket sendto;
#line 6616
allow newrole_t self:unix_stream_socket connectto;
#line 6616

#line 6616
# Access System V IPC objects created by processes in the same domain.
#line 6616
allow newrole_t self:sem  { associate getattr setattr create destroy read write unix_read unix_write };
#line 6616
allow newrole_t self:msg  { send receive };
#line 6616
allow newrole_t self:msgq { associate getattr setattr create destroy read write enqueue unix_read unix_write };
#line 6616
allow newrole_t self:shm  { associate getattr setattr create destroy read write lock unix_read unix_write };
#line 6616
;


#line 6618
allow newrole_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 6618
allow newrole_t lib_t:lnk_file { read getattr lock ioctl };
#line 6618
allow newrole_t ld_so_t:file { read getattr lock execute ioctl };
#line 6618
allow newrole_t ld_so_t:file execute_no_trans;
#line 6618
allow newrole_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 6618
allow newrole_t shlib_t:file { read getattr lock execute ioctl };
#line 6618
allow newrole_t shlib_t:lnk_file { read getattr lock ioctl };
#line 6618
allow newrole_t ld_so_cache_t:file { read getattr lock ioctl };
#line 6618
allow newrole_t device_t:dir search;
#line 6618
allow newrole_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 6618


#line 6619
allow newrole_t etc_t:lnk_file read;
#line 6619

#line 6619
allow newrole_t locale_t:dir { read getattr lock search ioctl };
#line 6619
allow newrole_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 6619

#line 6619


# for when the user types "exec newrole" at the command line
allow newrole_t privfd:process sigchld;

type newrole_exec_t, file_type, exec_type, sysadmfile;

#line 6625

#line 6625

#line 6625
#
#line 6625
# Allow the process to transition to the new domain.
#line 6625
#
#line 6625
allow userdomain newrole_t:process transition;
#line 6625

#line 6625
#
#line 6625
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6625
#
#line 6625
dontaudit userdomain newrole_t:process noatsecure;
#line 6625

#line 6625
#
#line 6625
# Allow the process to execute the program.
#line 6625
# 
#line 6625
allow userdomain newrole_exec_t:file { read { getattr execute } };
#line 6625

#line 6625
#
#line 6625
# Allow the process to reap the new domain.
#line 6625
#
#line 6625
allow newrole_t userdomain:process sigchld;
#line 6625

#line 6625
#
#line 6625
# Allow the new domain to inherit and use file 
#line 6625
# descriptions from the creating process and vice versa.
#line 6625
#
#line 6625
allow newrole_t userdomain:fd use;
#line 6625
allow userdomain newrole_t:fd use;
#line 6625

#line 6625
#
#line 6625
# Allow the new domain to write back to the old domain via a pipe.
#line 6625
#
#line 6625
allow newrole_t userdomain:fifo_file { ioctl read getattr lock write append };
#line 6625

#line 6625
#
#line 6625
# Allow the new domain to read and execute the program.
#line 6625
#
#line 6625
allow newrole_t newrole_exec_t:file { read getattr lock execute ioctl };
#line 6625

#line 6625
#
#line 6625
# Allow the new domain to be entered via the program.
#line 6625
#
#line 6625
allow newrole_t newrole_exec_t:file entrypoint;
#line 6625

#line 6625
type_transition userdomain newrole_exec_t:process newrole_t;
#line 6625


# Inherit descriptors from the current session.
allow newrole_t privfd:fd use;

# Execute /sbin/pwdb_chkpwd to check the password.
allow newrole_t sbin_t:dir { read getattr lock search ioctl };

#line 6632
allow newrole_t chkpwd_exec_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 6632


# Execute shells
allow newrole_t bin_t:dir { read getattr lock search ioctl };
allow newrole_t bin_t:lnk_file read;
allow newrole_t shell_exec_t:file { read getattr lock ioctl };

# Allow newrole_t to transition to user domains.

#line 6640

#line 6640
#
#line 6640
# Allow the process to transition to the new domain.
#line 6640
#
#line 6640
allow newrole_t userdomain:process transition;
#line 6640

#line 6640
#
#line 6640
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6640
#
#line 6640
dontaudit newrole_t userdomain:process noatsecure;
#line 6640

#line 6640
#
#line 6640
# Allow the process to execute the program.
#line 6640
# 
#line 6640
allow newrole_t shell_exec_t:file { read { getattr execute } };
#line 6640

#line 6640
#
#line 6640
# Allow the process to reap the new domain.
#line 6640
#
#line 6640
allow userdomain newrole_t:process sigchld;
#line 6640

#line 6640
#
#line 6640
# Allow the new domain to inherit and use file 
#line 6640
# descriptions from the creating process and vice versa.
#line 6640
#
#line 6640
allow userdomain newrole_t:fd use;
#line 6640
allow newrole_t userdomain:fd use;
#line 6640

#line 6640
#
#line 6640
# Allow the new domain to write back to the old domain via a pipe.
#line 6640
#
#line 6640
allow userdomain newrole_t:fifo_file { ioctl read getattr lock write append };
#line 6640

#line 6640
#
#line 6640
# Allow the new domain to read and execute the program.
#line 6640
#
#line 6640
allow userdomain shell_exec_t:file { read getattr lock execute ioctl };
#line 6640

#line 6640
#
#line 6640
# Allow the new domain to be entered via the program.
#line 6640
#
#line 6640
allow userdomain shell_exec_t:file entrypoint;
#line 6640


#line 6641
allow newrole_t self:process setexec;
#line 6641
allow newrole_t proc_t:dir search;
#line 6641
allow newrole_t proc_t:lnk_file read;
#line 6641
allow newrole_t self:dir search;
#line 6641
allow newrole_t self:file { read write };
#line 6641


# Use capabilities.
allow newrole_t self:capability { setuid setgid net_bind_service dac_override };

# Write to utmp.
allow newrole_t var_run_t:dir { read getattr lock search ioctl };
allow newrole_t initrc_var_run_t:file { ioctl read getattr lock write append };

# Read the devpts root directory.
allow newrole_t devpts_t:dir { read getattr lock search ioctl };

# Read the /etc/security/default_type file
allow newrole_t etc_t:file { read getattr lock ioctl };

# Read /var.
allow newrole_t var_t:dir { read getattr lock search ioctl };
allow newrole_t var_t:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };

# Read /dev directories and any symbolic links.
allow newrole_t device_t:dir { read getattr lock search ioctl };

# Relabel terminals.
allow newrole_t { ttyfile ptyfile }:chr_file { relabelfrom relabelto };

# Access terminals.
allow newrole_t { ttyfile ptyfile devtty_t }:chr_file { ioctl read getattr lock write append };


#line 6673


#
# Allow newrole to obtain contexts to relabel TTYs
#

#line 6678
allow newrole_t security_t:dir { read search getattr };
#line 6678
allow newrole_t security_t:file { getattr read write };
#line 6678
allow newrole_t security_t:security { check_context compute_av compute_create compute_relabel compute_user };
#line 6678


allow newrole_t fs_t:filesystem getattr;

# for some PAM modules and for cwd
dontaudit newrole_t { home_root_t home_type }:dir search;

# Failed reads to /proc cause no harm, so do not audit them
dontaudit newrole_t proc_t:dir search;

# for when the network connection is killed
dontaudit unpriv_userdomain newrole_t:process signal;
#DESC Passwd - Password utilities
#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
# X-Debian-Packages: passwd
#

#################################
#
# Rules for the passwd_t domain.
#
# passwd_t is the domain of the passwd process.
# passwd_exec_t is the type of the passwd program.
# This domain and type is also used for chfn and chsh.
#
#line 6761



#line 6763
type passwd_t, domain, privlog, auth_write, privowner;
#line 6763

#line 6763

#line 6763
# Access other processes in the same domain.
#line 6763
# Omits ptrace, setexec, and setfscreate.  These must be granted 
#line 6763
# separately if desired.
#line 6763
allow passwd_t self:process ~{ptrace setexec setfscreate};
#line 6763

#line 6763
# Access /proc/PID files for processes in the same domain.
#line 6763
allow passwd_t self:dir { read getattr lock search ioctl };
#line 6763
allow passwd_t self:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 6763

#line 6763
# Access file descriptions, pipes, and sockets
#line 6763
# created by processes in the same domain.
#line 6763
allow passwd_t self:fd *;
#line 6763
allow passwd_t self:fifo_file { ioctl read getattr lock write append };
#line 6763
allow passwd_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 6763
allow passwd_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 6763

#line 6763
# Allow the domain to communicate with other processes in the same domain.
#line 6763
allow passwd_t self:unix_dgram_socket sendto;
#line 6763
allow passwd_t self:unix_stream_socket connectto;
#line 6763

#line 6763
# Access System V IPC objects created by processes in the same domain.
#line 6763
allow passwd_t self:sem  { associate getattr setattr create destroy read write unix_read unix_write };
#line 6763
allow passwd_t self:msg  { send receive };
#line 6763
allow passwd_t self:msgq { associate getattr setattr create destroy read write enqueue unix_read unix_write };
#line 6763
allow passwd_t self:shm  { associate getattr setattr create destroy read write lock unix_read unix_write };
#line 6763
;
#line 6763

#line 6763
allow passwd_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 6763
allow passwd_t lib_t:lnk_file { read getattr lock ioctl };
#line 6763
allow passwd_t ld_so_t:file { read getattr lock execute ioctl };
#line 6763
allow passwd_t ld_so_t:file execute_no_trans;
#line 6763
allow passwd_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 6763
allow passwd_t shlib_t:file { read getattr lock execute ioctl };
#line 6763
allow passwd_t shlib_t:lnk_file { read getattr lock ioctl };
#line 6763
allow passwd_t ld_so_cache_t:file { read getattr lock ioctl };
#line 6763
allow passwd_t device_t:dir search;
#line 6763
allow passwd_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 6763
;
#line 6763

#line 6763
# Inherit and use descriptors from login.
#line 6763
allow passwd_t privfd:fd use;
#line 6763

#line 6763

#line 6763
# Execute /usr/bin/{passwd,chfn,chsh} and /usr/sbin/{useradd,vipw}
#line 6763
allow passwd_t { bin_t sbin_t }:dir { read getattr lock search ioctl };
#line 6763

#line 6763
allow passwd_t { bin_t sbin_t shell_exec_t }:file { { read getattr lock execute ioctl } execute_no_trans };
#line 6763

#line 6763
allow passwd_t bin_t:lnk_file read;
#line 6763

#line 6763

#line 6763
allow passwd_t etc_t:lnk_file read;
#line 6763

#line 6763
allow passwd_t locale_t:dir { read getattr lock search ioctl };
#line 6763
allow passwd_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 6763

#line 6763

#line 6763

#line 6763
allow passwd_t fs_t:filesystem getattr;
#line 6763

#line 6763
# allow checking if a shell is executable
#line 6763
allow passwd_t shell_exec_t:file execute;
#line 6763

#line 6763
# Obtain contexts
#line 6763

#line 6763
allow passwd_t security_t:dir { read search getattr };
#line 6763
allow passwd_t security_t:file { getattr read write };
#line 6763
allow passwd_t security_t:security { check_context compute_av compute_create compute_relabel compute_user };
#line 6763

#line 6763

#line 6763
# Update /etc/shadow and /etc/passwd
#line 6763

#line 6763

#line 6763

#line 6763

#line 6763
#
#line 6763
# Allow the process to modify the directory.
#line 6763
#
#line 6763
allow passwd_t etc_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 6763

#line 6763
#
#line 6763
# Allow the process to create the file.
#line 6763
#
#line 6763

#line 6763

#line 6763
allow passwd_t shadow_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 6763

#line 6763

#line 6763
type_transition passwd_t etc_t:file shadow_t;
#line 6763

#line 6763

#line 6763
allow passwd_t etc_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 6763
allow passwd_t { etc_t shadow_t }:file { relabelfrom relabelto };
#line 6763

#line 6763
allow passwd_t self:process setfscreate;
#line 6763
allow passwd_t proc_t:dir search;
#line 6763
allow passwd_t proc_t:lnk_file read;
#line 6763
allow passwd_t self:dir search;
#line 6763
allow passwd_t self:file { read write };
#line 6763

#line 6763

#line 6763
# Allow etc_t symlinks for /etc/alternatives on Debian.
#line 6763
allow passwd_t etc_t:lnk_file read;
#line 6763

#line 6763
# Use capabilities.
#line 6763
allow passwd_t self:capability { chown dac_override fsetid setuid sys_resource };
#line 6763

#line 6763
# Access terminals.
#line 6763
allow passwd_t { ttyfile ptyfile }:chr_file { ioctl read getattr lock write append };
#line 6763
allow passwd_t devtty_t:chr_file { ioctl read getattr lock write append };
#line 6763

#line 6763
dontaudit passwd_t devpts_t:dir getattr;
#line 6763

#line 6763
# /usr/bin/passwd asks for w access to utmp, but it will operate
#line 6763
# correctly without it.  Do not audit write denials to utmp.
#line 6763
dontaudit passwd_t initrc_var_run_t:file { read write };
#line 6763

#line 6763
# user generally runs this from their home directory, so do not audit a search
#line 6763
# on user home dir
#line 6763
dontaudit passwd_t { user_home_dir_type user_home_type }:dir search;
#line 6763

#line 6763
# When the wrong current passwd is entered, passwd, for some reason, 
#line 6763
# attempts to access /proc and /dev, but fails appropriately. So dont
#line 6763
# audit those denials.
#line 6763
dontaudit passwd_t { proc_t device_t }:dir { search read };
#line 6763

#line 6763
allow passwd_t device_t:dir getattr;
#line 6763


#line 6764
type sysadm_passwd_t, domain, privlog, auth_write, privowner;
#line 6764

#line 6764

#line 6764
# Access other processes in the same domain.
#line 6764
# Omits ptrace, setexec, and setfscreate.  These must be granted 
#line 6764
# separately if desired.
#line 6764
allow sysadm_passwd_t self:process ~{ptrace setexec setfscreate};
#line 6764

#line 6764
# Access /proc/PID files for processes in the same domain.
#line 6764
allow sysadm_passwd_t self:dir { read getattr lock search ioctl };
#line 6764
allow sysadm_passwd_t self:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 6764

#line 6764
# Access file descriptions, pipes, and sockets
#line 6764
# created by processes in the same domain.
#line 6764
allow sysadm_passwd_t self:fd *;
#line 6764
allow sysadm_passwd_t self:fifo_file { ioctl read getattr lock write append };
#line 6764
allow sysadm_passwd_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 6764
allow sysadm_passwd_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 6764

#line 6764
# Allow the domain to communicate with other processes in the same domain.
#line 6764
allow sysadm_passwd_t self:unix_dgram_socket sendto;
#line 6764
allow sysadm_passwd_t self:unix_stream_socket connectto;
#line 6764

#line 6764
# Access System V IPC objects created by processes in the same domain.
#line 6764
allow sysadm_passwd_t self:sem  { associate getattr setattr create destroy read write unix_read unix_write };
#line 6764
allow sysadm_passwd_t self:msg  { send receive };
#line 6764
allow sysadm_passwd_t self:msgq { associate getattr setattr create destroy read write enqueue unix_read unix_write };
#line 6764
allow sysadm_passwd_t self:shm  { associate getattr setattr create destroy read write lock unix_read unix_write };
#line 6764
;
#line 6764

#line 6764
allow sysadm_passwd_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 6764
allow sysadm_passwd_t lib_t:lnk_file { read getattr lock ioctl };
#line 6764
allow sysadm_passwd_t ld_so_t:file { read getattr lock execute ioctl };
#line 6764
allow sysadm_passwd_t ld_so_t:file execute_no_trans;
#line 6764
allow sysadm_passwd_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 6764
allow sysadm_passwd_t shlib_t:file { read getattr lock execute ioctl };
#line 6764
allow sysadm_passwd_t shlib_t:lnk_file { read getattr lock ioctl };
#line 6764
allow sysadm_passwd_t ld_so_cache_t:file { read getattr lock ioctl };
#line 6764
allow sysadm_passwd_t device_t:dir search;
#line 6764
allow sysadm_passwd_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 6764
;
#line 6764

#line 6764
# Inherit and use descriptors from login.
#line 6764
allow sysadm_passwd_t privfd:fd use;
#line 6764

#line 6764

#line 6764
# Execute /usr/bin/{passwd,chfn,chsh} and /usr/sbin/{useradd,vipw}
#line 6764
allow sysadm_passwd_t { bin_t sbin_t }:dir { read getattr lock search ioctl };
#line 6764

#line 6764
allow sysadm_passwd_t { bin_t sbin_t shell_exec_t }:file { { read getattr lock execute ioctl } execute_no_trans };
#line 6764

#line 6764
allow sysadm_passwd_t bin_t:lnk_file read;
#line 6764

#line 6764

#line 6764
allow sysadm_passwd_t etc_t:lnk_file read;
#line 6764

#line 6764
allow sysadm_passwd_t locale_t:dir { read getattr lock search ioctl };
#line 6764
allow sysadm_passwd_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 6764

#line 6764

#line 6764

#line 6764
allow sysadm_passwd_t fs_t:filesystem getattr;
#line 6764

#line 6764
# allow checking if a shell is executable
#line 6764
allow sysadm_passwd_t shell_exec_t:file execute;
#line 6764

#line 6764
# Obtain contexts
#line 6764

#line 6764
allow sysadm_passwd_t security_t:dir { read search getattr };
#line 6764
allow sysadm_passwd_t security_t:file { getattr read write };
#line 6764
allow sysadm_passwd_t security_t:security { check_context compute_av compute_create compute_relabel compute_user };
#line 6764

#line 6764

#line 6764
# Update /etc/shadow and /etc/passwd
#line 6764

#line 6764

#line 6764

#line 6764

#line 6764
#
#line 6764
# Allow the process to modify the directory.
#line 6764
#
#line 6764
allow sysadm_passwd_t etc_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 6764

#line 6764
#
#line 6764
# Allow the process to create the file.
#line 6764
#
#line 6764

#line 6764

#line 6764
allow sysadm_passwd_t shadow_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 6764

#line 6764

#line 6764
type_transition sysadm_passwd_t etc_t:file shadow_t;
#line 6764

#line 6764

#line 6764
allow sysadm_passwd_t etc_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 6764
allow sysadm_passwd_t { etc_t shadow_t }:file { relabelfrom relabelto };
#line 6764

#line 6764
allow sysadm_passwd_t self:process setfscreate;
#line 6764
allow sysadm_passwd_t proc_t:dir search;
#line 6764
allow sysadm_passwd_t proc_t:lnk_file read;
#line 6764
allow sysadm_passwd_t self:dir search;
#line 6764
allow sysadm_passwd_t self:file { read write };
#line 6764

#line 6764

#line 6764
# Allow etc_t symlinks for /etc/alternatives on Debian.
#line 6764
allow sysadm_passwd_t etc_t:lnk_file read;
#line 6764

#line 6764
# Use capabilities.
#line 6764
allow sysadm_passwd_t self:capability { chown dac_override fsetid setuid sys_resource };
#line 6764

#line 6764
# Access terminals.
#line 6764
allow sysadm_passwd_t { ttyfile ptyfile }:chr_file { ioctl read getattr lock write append };
#line 6764
allow sysadm_passwd_t devtty_t:chr_file { ioctl read getattr lock write append };
#line 6764

#line 6764
dontaudit sysadm_passwd_t devpts_t:dir getattr;
#line 6764

#line 6764
# /usr/bin/passwd asks for w access to utmp, but it will operate
#line 6764
# correctly without it.  Do not audit write denials to utmp.
#line 6764
dontaudit sysadm_passwd_t initrc_var_run_t:file { read write };
#line 6764

#line 6764
# user generally runs this from their home directory, so do not audit a search
#line 6764
# on user home dir
#line 6764
dontaudit sysadm_passwd_t { user_home_dir_type user_home_type }:dir search;
#line 6764

#line 6764
# When the wrong current passwd is entered, passwd, for some reason, 
#line 6764
# attempts to access /proc and /dev, but fails appropriately. So dont
#line 6764
# audit those denials.
#line 6764
dontaudit sysadm_passwd_t { proc_t device_t }:dir { search read };
#line 6764

#line 6764
allow sysadm_passwd_t device_t:dir getattr;
#line 6764



#line 6766
role user_r types passwd_t;
#line 6766
role staff_r types passwd_t;
#line 6766

role sysadm_r types passwd_t;
role sysadm_r types sysadm_passwd_t;

type admin_passwd_exec_t, file_type, sysadmfile;
type passwd_exec_t, file_type, sysadmfile, exec_type;


#line 6773

#line 6773

#line 6773
#
#line 6773
# Allow the process to transition to the new domain.
#line 6773
#
#line 6773
allow userdomain passwd_t:process transition;
#line 6773

#line 6773
#
#line 6773
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6773
#
#line 6773
dontaudit userdomain passwd_t:process noatsecure;
#line 6773

#line 6773
#
#line 6773
# Allow the process to execute the program.
#line 6773
# 
#line 6773
allow userdomain passwd_exec_t:file { read { getattr execute } };
#line 6773

#line 6773
#
#line 6773
# Allow the process to reap the new domain.
#line 6773
#
#line 6773
allow passwd_t userdomain:process sigchld;
#line 6773

#line 6773
#
#line 6773
# Allow the new domain to inherit and use file 
#line 6773
# descriptions from the creating process and vice versa.
#line 6773
#
#line 6773
allow passwd_t userdomain:fd use;
#line 6773
allow userdomain passwd_t:fd use;
#line 6773

#line 6773
#
#line 6773
# Allow the new domain to write back to the old domain via a pipe.
#line 6773
#
#line 6773
allow passwd_t userdomain:fifo_file { ioctl read getattr lock write append };
#line 6773

#line 6773
#
#line 6773
# Allow the new domain to read and execute the program.
#line 6773
#
#line 6773
allow passwd_t passwd_exec_t:file { read getattr lock execute ioctl };
#line 6773

#line 6773
#
#line 6773
# Allow the new domain to be entered via the program.
#line 6773
#
#line 6773
allow passwd_t passwd_exec_t:file entrypoint;
#line 6773

#line 6773
type_transition userdomain passwd_exec_t:process passwd_t;
#line 6773


#line 6774

#line 6774

#line 6774
#
#line 6774
# Allow the process to transition to the new domain.
#line 6774
#
#line 6774
allow sysadm_t sysadm_passwd_t:process transition;
#line 6774

#line 6774
#
#line 6774
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6774
#
#line 6774
dontaudit sysadm_t sysadm_passwd_t:process noatsecure;
#line 6774

#line 6774
#
#line 6774
# Allow the process to execute the program.
#line 6774
# 
#line 6774
allow sysadm_t admin_passwd_exec_t:file { read { getattr execute } };
#line 6774

#line 6774
#
#line 6774
# Allow the process to reap the new domain.
#line 6774
#
#line 6774
allow sysadm_passwd_t sysadm_t:process sigchld;
#line 6774

#line 6774
#
#line 6774
# Allow the new domain to inherit and use file 
#line 6774
# descriptions from the creating process and vice versa.
#line 6774
#
#line 6774
allow sysadm_passwd_t sysadm_t:fd use;
#line 6774
allow sysadm_t sysadm_passwd_t:fd use;
#line 6774

#line 6774
#
#line 6774
# Allow the new domain to write back to the old domain via a pipe.
#line 6774
#
#line 6774
allow sysadm_passwd_t sysadm_t:fifo_file { ioctl read getattr lock write append };
#line 6774

#line 6774
#
#line 6774
# Allow the new domain to read and execute the program.
#line 6774
#
#line 6774
allow sysadm_passwd_t admin_passwd_exec_t:file { read getattr lock execute ioctl };
#line 6774

#line 6774
#
#line 6774
# Allow the new domain to be entered via the program.
#line 6774
#
#line 6774
allow sysadm_passwd_t admin_passwd_exec_t:file entrypoint;
#line 6774

#line 6774
type_transition sysadm_t admin_passwd_exec_t:process sysadm_passwd_t;
#line 6774


#line 6783

#line 6783
dontaudit passwd_t var_t:dir search;
#line 6783


# allow vipw to exec the editor
allow sysadm_passwd_t { root_t usr_t bin_t }:dir search;
allow sysadm_passwd_t { bin_t }:lnk_file read;

#line 6788
allow sysadm_passwd_t bin_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 6788


# allow vipw to create temporary files under /var/tmp/vi.recover
allow sysadm_passwd_t var_t:dir search;

#line 6792
type sysadm_passwd_tmp_t, file_type, sysadmfile, tmpfile ;
#line 6792

#line 6792

#line 6792

#line 6792

#line 6792
#
#line 6792
# Allow the process to modify the directory.
#line 6792
#
#line 6792
allow sysadm_passwd_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 6792

#line 6792
#
#line 6792
# Allow the process to create the file.
#line 6792
#
#line 6792

#line 6792
allow sysadm_passwd_t sysadm_passwd_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 6792
allow sysadm_passwd_t sysadm_passwd_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 6792

#line 6792

#line 6792
type_transition sysadm_passwd_t tmp_t:dir sysadm_passwd_tmp_t;
#line 6792
type_transition sysadm_passwd_t tmp_t:{ file lnk_file sock_file fifo_file } sysadm_passwd_tmp_t;
#line 6792

#line 6792

#line 6792

# for vipw - vi looks in the root home directory for config
dontaudit sysadm_passwd_t sysadm_home_dir_t:dir { getattr search };
# for /etc/alternatives/vi
allow sysadm_passwd_t etc_t:lnk_file read;

# for nscd lookups
dontaudit sysadm_passwd_t var_run_t:dir search;

# make sure that getcon succeeds
allow passwd_t user_t:dir search;
allow passwd_t user_t:file read;
allow passwd_t user_t:process getattr;

#DESC Setfiles - SELinux filesystem labeling utilities
#
# Authors:  Russell Coker <russell@coker.com.au>
# X-Debian-Packages: policycoreutils
#

#################################
#
# Rules for the setfiles_t domain.
#
# setfiles_exec_t is the type of the setfiles executable.
#
# needs auth_write attribute because it has relabelfrom/relabelto
# access to shadow_t
type setfiles_t, domain, privlog, privowner, auth_write;
type setfiles_exec_t, file_type, sysadmfile, exec_type;

role system_r types setfiles_t;
role sysadm_r types setfiles_t;

allow setfiles_t initrc_devpts_t:chr_file { read write ioctl };
allow setfiles_t { tty_device_t { sysadm_tty_device_t sysadm_devpts_t } }:chr_file { read write ioctl };


#line 6829

#line 6829

#line 6829
#
#line 6829
# Allow the process to transition to the new domain.
#line 6829
#
#line 6829
allow { initrc_t sysadm_t } setfiles_t:process transition;
#line 6829

#line 6829
#
#line 6829
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6829
#
#line 6829
dontaudit { initrc_t sysadm_t } setfiles_t:process noatsecure;
#line 6829

#line 6829
#
#line 6829
# Allow the process to execute the program.
#line 6829
# 
#line 6829
allow { initrc_t sysadm_t } setfiles_exec_t:file { read { getattr execute } };
#line 6829

#line 6829
#
#line 6829
# Allow the process to reap the new domain.
#line 6829
#
#line 6829
allow setfiles_t { initrc_t sysadm_t }:process sigchld;
#line 6829

#line 6829
#
#line 6829
# Allow the new domain to inherit and use file 
#line 6829
# descriptions from the creating process and vice versa.
#line 6829
#
#line 6829
allow setfiles_t { initrc_t sysadm_t }:fd use;
#line 6829
allow { initrc_t sysadm_t } setfiles_t:fd use;
#line 6829

#line 6829
#
#line 6829
# Allow the new domain to write back to the old domain via a pipe.
#line 6829
#
#line 6829
allow setfiles_t { initrc_t sysadm_t }:fifo_file { ioctl read getattr lock write append };
#line 6829

#line 6829
#
#line 6829
# Allow the new domain to read and execute the program.
#line 6829
#
#line 6829
allow setfiles_t setfiles_exec_t:file { read getattr lock execute ioctl };
#line 6829

#line 6829
#
#line 6829
# Allow the new domain to be entered via the program.
#line 6829
#
#line 6829
allow setfiles_t setfiles_exec_t:file entrypoint;
#line 6829

#line 6829
type_transition { initrc_t sysadm_t } setfiles_exec_t:process setfiles_t;
#line 6829

allow setfiles_t init_t:fd use;
allow setfiles_t privfd:fd use;


#line 6833
allow setfiles_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 6833
allow setfiles_t lib_t:lnk_file { read getattr lock ioctl };
#line 6833
allow setfiles_t ld_so_t:file { read getattr lock execute ioctl };
#line 6833
allow setfiles_t ld_so_t:file execute_no_trans;
#line 6833
allow setfiles_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 6833
allow setfiles_t shlib_t:file { read getattr lock execute ioctl };
#line 6833
allow setfiles_t shlib_t:lnk_file { read getattr lock ioctl };
#line 6833
allow setfiles_t ld_so_cache_t:file { read getattr lock ioctl };
#line 6833
allow setfiles_t device_t:dir search;
#line 6833
allow setfiles_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 6833

allow setfiles_t self:capability { dac_override dac_read_search };

# for upgrading glibc - without this the glibc upgrade scripts will put things
# in a state such that setfiles can not be run!
allow setfiles_t lib_t:file execute;

# Get security policy decisions.

#line 6841
allow setfiles_t security_t:dir { read search getattr };
#line 6841
allow setfiles_t security_t:file { getattr read write };
#line 6841
allow setfiles_t security_t:security { check_context compute_av compute_create compute_relabel compute_user };
#line 6841


allow setfiles_t policy_src_t:file { read getattr lock ioctl };

allow setfiles_t file_type:dir { read getattr lock search ioctl };
allow setfiles_t file_type:lnk_file { read getattr lock ioctl };
allow setfiles_t file_type:{ dir file lnk_file sock_file fifo_file chr_file blk_file } { getattr relabelfrom relabelto };

allow setfiles_t file_labels_t:dir { read getattr lock search ioctl add_name remove_name write };
allow setfiles_t file_labels_t:file { create ioctl read getattr lock write setattr append link unlink rename };

allow setfiles_t fs_t:filesystem getattr;
allow setfiles_t fs_type:dir { read getattr lock search ioctl };

allow setfiles_t etc_runtime_t:file read;
allow setfiles_t etc_t:file read;
allow setfiles_t proc_t:file { getattr read };
dontaudit setfiles_t proc_t:lnk_file { getattr read };

# for config files in a home directory
allow setfiles_t home_type:file { read getattr lock ioctl };
#DESC SSH - SSH daemon
#
# Authors:  Anthony Colatrella (NSA) <amcolat@epoch.ncsc.mil>
#           Stephen Smalley <sds@epoch.ncsc.mil>
#           Russell Coker <russell@coker.com.au>
# X-Debian-Packages: ssh
#

# sshd_exec_t is the type of the sshd executable.
# sshd_key_t is the type of the ssh private key files
type sshd_exec_t, file_type, exec_type, sysadmfile;
type sshd_key_t, file_type, sysadmfile;

type ssh_port_t, port_type;

#line 6881


#line 6959

# macro for defining which domains a sshd can spawn
# $1_t is the domain of the sshd, $2 is the domain to be spawned, $3 is the
# type of the pty for the child
#line 6980


#################################
#
# Rules for the sshd_t domain, et al.
#
# sshd_t is the domain for the sshd program.
# sshd_extern_t is the domain for ssh from outside our network
#

#line 6989
# privowner is for changing the identity on the terminal device
#line 6989
# privfd is for passing the terminal file handle to the user process
#line 6989
# auth is for /etc/shadow
#line 6989
type sshd_t, domain, privuser, privrole, privlog, privowner, privfd, auth, auth_chkpwd;
#line 6989
role system_r types sshd_t;
#line 6989
dontaudit sshd_t shadow_t:file { getattr read };
#line 6989

#line 6989
allow sshd_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 6989
allow sshd_t lib_t:lnk_file { read getattr lock ioctl };
#line 6989
allow sshd_t ld_so_t:file { read getattr lock execute ioctl };
#line 6989
allow sshd_t ld_so_t:file execute_no_trans;
#line 6989
allow sshd_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 6989
allow sshd_t shlib_t:file { read getattr lock execute ioctl };
#line 6989
allow sshd_t shlib_t:lnk_file { read getattr lock ioctl };
#line 6989
allow sshd_t ld_so_cache_t:file { read getattr lock ioctl };
#line 6989
allow sshd_t device_t:dir search;
#line 6989
allow sshd_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 6989

#line 6989
allow sshd_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 6989
allow sshd_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 6989
allow sshd_t self:fifo_file { ioctl read getattr lock write append };
#line 6989
allow sshd_t self:process { fork sigchld setsched };
#line 6989

#line 6989
dontaudit sshd_t self:lnk_file read;
#line 6989

#line 6989
# do not allow statfs()
#line 6989
dontaudit sshd_t fs_type:filesystem getattr;
#line 6989

#line 6989
allow sshd_t bin_t:dir search;
#line 6989
allow sshd_t bin_t:lnk_file read;
#line 6989

#line 6989
# Read /var.
#line 6989
allow sshd_t var_t:dir { getattr search };
#line 6989

#line 6989
# Read /var/log.
#line 6989
allow sshd_t var_log_t:dir search;
#line 6989

#line 6989
# Read /etc.
#line 6989
allow sshd_t etc_t:dir search;
#line 6989
allow sshd_t etc_t:{ file lnk_file } { getattr read };
#line 6989
allow sshd_t etc_runtime_t:file { getattr read };
#line 6989
allow sshd_t resolv_conf_t:file { getattr read };
#line 6989

#line 6989
# Read and write /dev/tty and /dev/null.
#line 6989
allow sshd_t devtty_t:chr_file { ioctl read getattr lock write append };
#line 6989
allow sshd_t { null_device_t zero_device_t }:chr_file { ioctl read getattr lock write append };
#line 6989

#line 6989
# Read /dev/random and /dev/zero.
#line 6989
allow sshd_t random_device_t:chr_file { read getattr lock ioctl };
#line 6989

#line 6989

#line 6989
#
#line 6989
# Allow the domain to create and use UDP and TCP sockets.
#line 6989
# Other kinds of sockets must be separately authorized for use.
#line 6989
allow sshd_t self:udp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 6989
allow sshd_t self:tcp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 6989

#line 6989
#
#line 6989
# Allow the domain to send UDP packets.
#line 6989
# Since the destination sockets type is unknown, the generic
#line 6989
# any_socket_t type is used as a placeholder.
#line 6989
#
#line 6989
allow sshd_t any_socket_t:udp_socket sendto;
#line 6989

#line 6989
#
#line 6989
# Allow the domain to send using any network interface.
#line 6989
# netif_type is a type attribute for all network interface types.
#line 6989
#
#line 6989
allow sshd_t netif_type:netif { tcp_send udp_send rawip_send };
#line 6989

#line 6989
#
#line 6989
# Allow packets sent by the domain to be received on any network interface.
#line 6989
#
#line 6989
allow sshd_t netif_type:netif { tcp_recv udp_recv rawip_recv };
#line 6989

#line 6989
#
#line 6989
# Allow the domain to receive packets from any network interface.
#line 6989
# netmsg_type is a type attribute for all default message types.
#line 6989
#
#line 6989
allow sshd_t netmsg_type:{ udp_socket tcp_socket rawip_socket } recvfrom;
#line 6989

#line 6989
#
#line 6989
# Allow the domain to initiate or accept TCP connections 
#line 6989
# on any network interface.
#line 6989
#
#line 6989
allow sshd_t netmsg_type:tcp_socket { connectto acceptfrom };
#line 6989

#line 6989
#
#line 6989
# Receive resets from the TCP reset socket.
#line 6989
# The TCP reset socket is labeled with the tcp_socket_t type.
#line 6989
#
#line 6989
allow sshd_t tcp_socket_t:tcp_socket recvfrom;
#line 6989

#line 6989
dontaudit sshd_t tcp_socket_t:tcp_socket connectto;
#line 6989

#line 6989
#
#line 6989
# Allow the domain to send to any node.
#line 6989
# node_type is a type attribute for all node types.
#line 6989
#
#line 6989
allow sshd_t node_type:node { tcp_send udp_send rawip_send };
#line 6989

#line 6989
#
#line 6989
# Allow packets sent by the domain to be received from any node.
#line 6989
#
#line 6989
allow sshd_t node_type:node { tcp_recv udp_recv rawip_recv };
#line 6989

#line 6989
#
#line 6989
# Allow the domain to send NFS client requests via the socket
#line 6989
# created by mount.
#line 6989
#
#line 6989
allow sshd_t mount_t:udp_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 6989

#line 6989
#
#line 6989
# Bind to the default port type.
#line 6989
# Other port types must be separately authorized.
#line 6989
#
#line 6989
#allow sshd_t port_t:udp_socket name_bind;
#line 6989
#allow sshd_t port_t:tcp_socket name_bind;
#line 6989

#line 6989

#line 6989
allow sshd_t self:capability { sys_chroot sys_resource chown dac_override fowner fsetid setgid setuid sys_tty_config };
#line 6989
allow sshd_t { home_root_t user_home_dir_type sysadm_home_dir_t }:dir { search getattr };
#line 6989

#line 6989
# Set exec context.
#line 6989

#line 6989
allow sshd_t self:process setexec;
#line 6989
allow sshd_t proc_t:dir search;
#line 6989
allow sshd_t proc_t:lnk_file read;
#line 6989
allow sshd_t self:dir search;
#line 6989
allow sshd_t self:file { read write };
#line 6989

#line 6989

#line 6989
# Allow shells to be run in sysadm_t as well.
#line 6989
# Commented out.  Use newrole rather than directly entering sysadm_t.
#line 6989
#domain_trans(sshd_t, shell_exec_t, sysadm_t)
#line 6989

#line 6989
# Update utmp.
#line 6989
allow sshd_t initrc_var_run_t:file { ioctl read getattr lock write append };
#line 6989

#line 6989
# Update wtmp.
#line 6989
allow sshd_t wtmp_t:file { ioctl read getattr lock write append };
#line 6989

#line 6989
# Get security policy decisions.
#line 6989

#line 6989
allow sshd_t security_t:dir { read search getattr };
#line 6989
allow sshd_t security_t:file { getattr read write };
#line 6989
allow sshd_t security_t:security { check_context compute_av compute_create compute_relabel compute_user };
#line 6989

#line 6989

#line 6989
# Allow read access to login context
#line 6989
allow sshd_t default_context_t:file { read getattr lock ioctl };
#line 6989

#line 6989
# Access key files
#line 6989
allow sshd_t sshd_key_t:file { getattr read };
#line 6989

#line 6989
# Update /var/log/lastlog.
#line 6989
allow sshd_t lastlog_t:file { ioctl read getattr lock write append };
#line 6989

#line 6989

#line 6989
allow sshd_t etc_t:lnk_file read;
#line 6989

#line 6989
allow sshd_t locale_t:dir { read getattr lock search ioctl };
#line 6989
allow sshd_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 6989

#line 6989

#line 6989

#line 6989
# Can create ptys
#line 6989

#line 6989

#line 6989
# Access the pty master multiplexer.
#line 6989
allow sshd_t ptmx_t:chr_file { ioctl read getattr lock write append };
#line 6989

#line 6989

#line 6989
allow sshd_t devpts_t:filesystem getattr;
#line 6989

#line 6989
# allow searching /dev/pts
#line 6989
allow sshd_t devpts_t:dir { getattr read search };
#line 6989

#line 6989

#line 6989
type sshd_devpts_t, file_type, sysadmfile, ptyfile , server_pty;
#line 6989

#line 6989
# Allow the pty to be associated with the file system.
#line 6989
allow sshd_devpts_t devpts_t:filesystem associate;
#line 6989

#line 6989
# Label pty files with a derived type.
#line 6989
type_transition sshd_t devpts_t:chr_file sshd_devpts_t;
#line 6989

#line 6989
# Read and write my pty files.
#line 6989
allow sshd_t sshd_devpts_t:chr_file { setattr { ioctl read getattr lock write append } };
#line 6989

#line 6989

#line 6989
allow sshd_t sshd_devpts_t:chr_file { setattr getattr relabelfrom };
#line 6989


#line 6990

#line 6990

#line 6990
#
#line 6990
# Allow the process to transition to the new domain.
#line 6990
#
#line 6990
allow sshd_t unpriv_userdomain:process transition;
#line 6990

#line 6990
#
#line 6990
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6990
#
#line 6990
dontaudit sshd_t unpriv_userdomain:process noatsecure;
#line 6990

#line 6990
#
#line 6990
# Allow the process to execute the program.
#line 6990
# 
#line 6990
allow sshd_t shell_exec_t:file { read { getattr execute } };
#line 6990

#line 6990
#
#line 6990
# Allow the process to reap the new domain.
#line 6990
#
#line 6990
allow unpriv_userdomain sshd_t:process sigchld;
#line 6990

#line 6990
#
#line 6990
# Allow the new domain to inherit and use file 
#line 6990
# descriptions from the creating process and vice versa.
#line 6990
#
#line 6990
allow unpriv_userdomain sshd_t:fd use;
#line 6990
allow sshd_t unpriv_userdomain:fd use;
#line 6990

#line 6990
#
#line 6990
# Allow the new domain to write back to the old domain via a pipe.
#line 6990
#
#line 6990
allow unpriv_userdomain sshd_t:fifo_file { ioctl read getattr lock write append };
#line 6990

#line 6990
#
#line 6990
# Allow the new domain to read and execute the program.
#line 6990
#
#line 6990
allow unpriv_userdomain shell_exec_t:file { read getattr lock execute ioctl };
#line 6990

#line 6990
#
#line 6990
# Allow the new domain to be entered via the program.
#line 6990
#
#line 6990
allow unpriv_userdomain shell_exec_t:file entrypoint;
#line 6990

#line 6990

#line 6990

#line 6990
# Signal the user domains.
#line 6990
allow sshd_t unpriv_userdomain:process signal;
#line 6990

#line 6990
# Relabel and access ptys created by sshd
#line 6990
# ioctl is necessary for logout() processing for utmp entry and for w to
#line 6990
# display the tty.
#line 6990
allow sshd_t userpty_type:chr_file { relabelto read write getattr ioctl setattr };
#line 6990

#line 6990
# inheriting stream sockets is needed for "ssh host command" as no pty
#line 6990
# is allocated
#line 6990
allow unpriv_userdomain sshd_t:unix_stream_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 6990


#line 6995



#line 6997
# privowner is for changing the identity on the terminal device
#line 6997
# privfd is for passing the terminal file handle to the user process
#line 6997
# auth is for /etc/shadow
#line 6997
type sshd_extern_t, domain, privuser, privrole, privlog, privowner, privfd, auth, auth_chkpwd;
#line 6997
role system_r types sshd_extern_t;
#line 6997
dontaudit sshd_extern_t shadow_t:file { getattr read };
#line 6997

#line 6997
allow sshd_extern_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 6997
allow sshd_extern_t lib_t:lnk_file { read getattr lock ioctl };
#line 6997
allow sshd_extern_t ld_so_t:file { read getattr lock execute ioctl };
#line 6997
allow sshd_extern_t ld_so_t:file execute_no_trans;
#line 6997
allow sshd_extern_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 6997
allow sshd_extern_t shlib_t:file { read getattr lock execute ioctl };
#line 6997
allow sshd_extern_t shlib_t:lnk_file { read getattr lock ioctl };
#line 6997
allow sshd_extern_t ld_so_cache_t:file { read getattr lock ioctl };
#line 6997
allow sshd_extern_t device_t:dir search;
#line 6997
allow sshd_extern_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 6997

#line 6997
allow sshd_extern_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 6997
allow sshd_extern_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 6997
allow sshd_extern_t self:fifo_file { ioctl read getattr lock write append };
#line 6997
allow sshd_extern_t self:process { fork sigchld setsched };
#line 6997

#line 6997
dontaudit sshd_extern_t self:lnk_file read;
#line 6997

#line 6997
# do not allow statfs()
#line 6997
dontaudit sshd_extern_t fs_type:filesystem getattr;
#line 6997

#line 6997
allow sshd_extern_t bin_t:dir search;
#line 6997
allow sshd_extern_t bin_t:lnk_file read;
#line 6997

#line 6997
# Read /var.
#line 6997
allow sshd_extern_t var_t:dir { getattr search };
#line 6997

#line 6997
# Read /var/log.
#line 6997
allow sshd_extern_t var_log_t:dir search;
#line 6997

#line 6997
# Read /etc.
#line 6997
allow sshd_extern_t etc_t:dir search;
#line 6997
allow sshd_extern_t etc_t:{ file lnk_file } { getattr read };
#line 6997
allow sshd_extern_t etc_runtime_t:file { getattr read };
#line 6997
allow sshd_extern_t resolv_conf_t:file { getattr read };
#line 6997

#line 6997
# Read and write /dev/tty and /dev/null.
#line 6997
allow sshd_extern_t devtty_t:chr_file { ioctl read getattr lock write append };
#line 6997
allow sshd_extern_t { null_device_t zero_device_t }:chr_file { ioctl read getattr lock write append };
#line 6997

#line 6997
# Read /dev/random and /dev/zero.
#line 6997
allow sshd_extern_t random_device_t:chr_file { read getattr lock ioctl };
#line 6997

#line 6997

#line 6997
#
#line 6997
# Allow the domain to create and use UDP and TCP sockets.
#line 6997
# Other kinds of sockets must be separately authorized for use.
#line 6997
allow sshd_extern_t self:udp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 6997
allow sshd_extern_t self:tcp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 6997

#line 6997
#
#line 6997
# Allow the domain to send UDP packets.
#line 6997
# Since the destination sockets type is unknown, the generic
#line 6997
# any_socket_t type is used as a placeholder.
#line 6997
#
#line 6997
allow sshd_extern_t any_socket_t:udp_socket sendto;
#line 6997

#line 6997
#
#line 6997
# Allow the domain to send using any network interface.
#line 6997
# netif_type is a type attribute for all network interface types.
#line 6997
#
#line 6997
allow sshd_extern_t netif_type:netif { tcp_send udp_send rawip_send };
#line 6997

#line 6997
#
#line 6997
# Allow packets sent by the domain to be received on any network interface.
#line 6997
#
#line 6997
allow sshd_extern_t netif_type:netif { tcp_recv udp_recv rawip_recv };
#line 6997

#line 6997
#
#line 6997
# Allow the domain to receive packets from any network interface.
#line 6997
# netmsg_type is a type attribute for all default message types.
#line 6997
#
#line 6997
allow sshd_extern_t netmsg_type:{ udp_socket tcp_socket rawip_socket } recvfrom;
#line 6997

#line 6997
#
#line 6997
# Allow the domain to initiate or accept TCP connections 
#line 6997
# on any network interface.
#line 6997
#
#line 6997
allow sshd_extern_t netmsg_type:tcp_socket { connectto acceptfrom };
#line 6997

#line 6997
#
#line 6997
# Receive resets from the TCP reset socket.
#line 6997
# The TCP reset socket is labeled with the tcp_socket_t type.
#line 6997
#
#line 6997
allow sshd_extern_t tcp_socket_t:tcp_socket recvfrom;
#line 6997

#line 6997
dontaudit sshd_extern_t tcp_socket_t:tcp_socket connectto;
#line 6997

#line 6997
#
#line 6997
# Allow the domain to send to any node.
#line 6997
# node_type is a type attribute for all node types.
#line 6997
#
#line 6997
allow sshd_extern_t node_type:node { tcp_send udp_send rawip_send };
#line 6997

#line 6997
#
#line 6997
# Allow packets sent by the domain to be received from any node.
#line 6997
#
#line 6997
allow sshd_extern_t node_type:node { tcp_recv udp_recv rawip_recv };
#line 6997

#line 6997
#
#line 6997
# Allow the domain to send NFS client requests via the socket
#line 6997
# created by mount.
#line 6997
#
#line 6997
allow sshd_extern_t mount_t:udp_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 6997

#line 6997
#
#line 6997
# Bind to the default port type.
#line 6997
# Other port types must be separately authorized.
#line 6997
#
#line 6997
#allow sshd_extern_t port_t:udp_socket name_bind;
#line 6997
#allow sshd_extern_t port_t:tcp_socket name_bind;
#line 6997

#line 6997

#line 6997
allow sshd_extern_t self:capability { sys_chroot sys_resource chown dac_override fowner fsetid setgid setuid sys_tty_config };
#line 6997
allow sshd_extern_t { home_root_t user_home_dir_type sysadm_home_dir_t }:dir { search getattr };
#line 6997

#line 6997
# Set exec context.
#line 6997

#line 6997
allow sshd_extern_t self:process setexec;
#line 6997
allow sshd_extern_t proc_t:dir search;
#line 6997
allow sshd_extern_t proc_t:lnk_file read;
#line 6997
allow sshd_extern_t self:dir search;
#line 6997
allow sshd_extern_t self:file { read write };
#line 6997

#line 6997

#line 6997
# Allow shells to be run in sysadm_t as well.
#line 6997
# Commented out.  Use newrole rather than directly entering sysadm_t.
#line 6997
#domain_trans(sshd_extern_t, shell_exec_t, sysadm_t)
#line 6997

#line 6997
# Update utmp.
#line 6997
allow sshd_extern_t initrc_var_run_t:file { ioctl read getattr lock write append };
#line 6997

#line 6997
# Update wtmp.
#line 6997
allow sshd_extern_t wtmp_t:file { ioctl read getattr lock write append };
#line 6997

#line 6997
# Get security policy decisions.
#line 6997

#line 6997
allow sshd_extern_t security_t:dir { read search getattr };
#line 6997
allow sshd_extern_t security_t:file { getattr read write };
#line 6997
allow sshd_extern_t security_t:security { check_context compute_av compute_create compute_relabel compute_user };
#line 6997

#line 6997

#line 6997
# Allow read access to login context
#line 6997
allow sshd_extern_t default_context_t:file { read getattr lock ioctl };
#line 6997

#line 6997
# Access key files
#line 6997
allow sshd_extern_t sshd_key_t:file { getattr read };
#line 6997

#line 6997
# Update /var/log/lastlog.
#line 6997
allow sshd_extern_t lastlog_t:file { ioctl read getattr lock write append };
#line 6997

#line 6997

#line 6997
allow sshd_extern_t etc_t:lnk_file read;
#line 6997

#line 6997
allow sshd_extern_t locale_t:dir { read getattr lock search ioctl };
#line 6997
allow sshd_extern_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 6997

#line 6997

#line 6997

#line 6997
# Can create ptys
#line 6997

#line 6997

#line 6997
# Access the pty master multiplexer.
#line 6997
allow sshd_extern_t ptmx_t:chr_file { ioctl read getattr lock write append };
#line 6997

#line 6997

#line 6997
allow sshd_extern_t devpts_t:filesystem getattr;
#line 6997

#line 6997
# allow searching /dev/pts
#line 6997
allow sshd_extern_t devpts_t:dir { getattr read search };
#line 6997

#line 6997

#line 6997
type sshd_extern_devpts_t, file_type, sysadmfile, ptyfile , server_pty;
#line 6997

#line 6997
# Allow the pty to be associated with the file system.
#line 6997
allow sshd_extern_devpts_t devpts_t:filesystem associate;
#line 6997

#line 6997
# Label pty files with a derived type.
#line 6997
type_transition sshd_extern_t devpts_t:chr_file sshd_extern_devpts_t;
#line 6997

#line 6997
# Read and write my pty files.
#line 6997
allow sshd_extern_t sshd_extern_devpts_t:chr_file { setattr { ioctl read getattr lock write append } };
#line 6997

#line 6997

#line 6997
allow sshd_extern_t sshd_extern_devpts_t:chr_file { setattr getattr relabelfrom };
#line 6997


#line 6998

#line 6998

#line 6998
#
#line 6998
# Allow the process to transition to the new domain.
#line 6998
#
#line 6998
allow sshd_extern_t user_mini_domain:process transition;
#line 6998

#line 6998
#
#line 6998
# Do not audit when glibc secure mode is enabled upon the transition.
#line 6998
#
#line 6998
dontaudit sshd_extern_t user_mini_domain:process noatsecure;
#line 6998

#line 6998
#
#line 6998
# Allow the process to execute the program.
#line 6998
# 
#line 6998
allow sshd_extern_t shell_exec_t:file { read { getattr execute } };
#line 6998

#line 6998
#
#line 6998
# Allow the process to reap the new domain.
#line 6998
#
#line 6998
allow user_mini_domain sshd_extern_t:process sigchld;
#line 6998

#line 6998
#
#line 6998
# Allow the new domain to inherit and use file 
#line 6998
# descriptions from the creating process and vice versa.
#line 6998
#
#line 6998
allow user_mini_domain sshd_extern_t:fd use;
#line 6998
allow sshd_extern_t user_mini_domain:fd use;
#line 6998

#line 6998
#
#line 6998
# Allow the new domain to write back to the old domain via a pipe.
#line 6998
#
#line 6998
allow user_mini_domain sshd_extern_t:fifo_file { ioctl read getattr lock write append };
#line 6998

#line 6998
#
#line 6998
# Allow the new domain to read and execute the program.
#line 6998
#
#line 6998
allow user_mini_domain shell_exec_t:file { read getattr lock execute ioctl };
#line 6998

#line 6998
#
#line 6998
# Allow the new domain to be entered via the program.
#line 6998
#
#line 6998
allow user_mini_domain shell_exec_t:file entrypoint;
#line 6998

#line 6998

#line 6998

#line 6998
# Signal the user domains.
#line 6998
allow sshd_extern_t user_mini_domain:process signal;
#line 6998

#line 6998
# Relabel and access ptys created by sshd
#line 6998
# ioctl is necessary for logout() processing for utmp entry and for w to
#line 6998
# display the tty.
#line 6998
allow sshd_extern_t mini_pty_type:chr_file { relabelto read write getattr ioctl setattr };
#line 6998

#line 6998
# inheriting stream sockets is needed for "ssh host command" as no pty
#line 6998
# is allocated
#line 6998
allow user_mini_domain sshd_extern_t:unix_stream_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 6998


# for when the network connection breaks after running newrole -r sysadm_r
dontaudit sshd_t sysadm_devpts_t:chr_file setattr;

# Allow checking users mail at login
allow sshd_t { var_spool_t mail_spool_t }:dir search;
allow sshd_t mail_spool_t:lnk_file read;
allow sshd_t mail_spool_t:file getattr;

#line 7027

#line 7027
allow { sshd_t sshd_extern_t } initrc_devpts_t:chr_file { ioctl read getattr lock write append };
#line 7027
allow { sshd_t sshd_extern_t } self:capability net_bind_service;
#line 7027
allow { sshd_t sshd_extern_t } ssh_port_t:tcp_socket name_bind;
#line 7027

#line 7027

#line 7027

#line 7027
#
#line 7027
# Allow the process to transition to the new domain.
#line 7027
#
#line 7027
allow initrc_t sshd_t:process transition;
#line 7027

#line 7027
#
#line 7027
# Do not audit when glibc secure mode is enabled upon the transition.
#line 7027
#
#line 7027
dontaudit initrc_t sshd_t:process noatsecure;
#line 7027

#line 7027
#
#line 7027
# Allow the process to execute the program.
#line 7027
# 
#line 7027
allow initrc_t sshd_exec_t:file { read { getattr execute } };
#line 7027

#line 7027
#
#line 7027
# Allow the process to reap the new domain.
#line 7027
#
#line 7027
allow sshd_t initrc_t:process sigchld;
#line 7027

#line 7027
#
#line 7027
# Allow the new domain to inherit and use file 
#line 7027
# descriptions from the creating process and vice versa.
#line 7027
#
#line 7027
allow sshd_t initrc_t:fd use;
#line 7027
allow initrc_t sshd_t:fd use;
#line 7027

#line 7027
#
#line 7027
# Allow the new domain to write back to the old domain via a pipe.
#line 7027
#
#line 7027
allow sshd_t initrc_t:fifo_file { ioctl read getattr lock write append };
#line 7027

#line 7027
#
#line 7027
# Allow the new domain to read and execute the program.
#line 7027
#
#line 7027
allow sshd_t sshd_exec_t:file { read getattr lock execute ioctl };
#line 7027

#line 7027
#
#line 7027
# Allow the new domain to be entered via the program.
#line 7027
#
#line 7027
allow sshd_t sshd_exec_t:file entrypoint;
#line 7027

#line 7027
type_transition initrc_t sshd_exec_t:process sshd_t;
#line 7027

#line 7027

#line 7027

#line 7027
#
#line 7027
# Allow the process to transition to the new domain.
#line 7027
#
#line 7027
allow initrc_t sshd_extern_t:process transition;
#line 7027

#line 7027
#
#line 7027
# Do not audit when glibc secure mode is enabled upon the transition.
#line 7027
#
#line 7027
dontaudit initrc_t sshd_extern_t:process noatsecure;
#line 7027

#line 7027
#
#line 7027
# Allow the process to execute the program.
#line 7027
# 
#line 7027
allow initrc_t sshd_exec_t:file { read { getattr execute } };
#line 7027

#line 7027
#
#line 7027
# Allow the process to reap the new domain.
#line 7027
#
#line 7027
allow sshd_extern_t initrc_t:process sigchld;
#line 7027

#line 7027
#
#line 7027
# Allow the new domain to inherit and use file 
#line 7027
# descriptions from the creating process and vice versa.
#line 7027
#
#line 7027
allow sshd_extern_t initrc_t:fd use;
#line 7027
allow initrc_t sshd_extern_t:fd use;
#line 7027

#line 7027
#
#line 7027
# Allow the new domain to write back to the old domain via a pipe.
#line 7027
#
#line 7027
allow sshd_extern_t initrc_t:fifo_file { ioctl read getattr lock write append };
#line 7027

#line 7027
#
#line 7027
# Allow the new domain to read and execute the program.
#line 7027
#
#line 7027
allow sshd_extern_t sshd_exec_t:file { read getattr lock execute ioctl };
#line 7027

#line 7027
#
#line 7027
# Allow the new domain to be entered via the program.
#line 7027
#
#line 7027
allow sshd_extern_t sshd_exec_t:file entrypoint;
#line 7027

#line 7027

#line 7027
# Inherit and use descriptors from init.
#line 7027
allow { sshd_t sshd_extern_t } init_t:fd use;
#line 7027

#line 7027
# Create /var/run/sshd.pid
#line 7027

#line 7027
type sshd_var_run_t alias var_run_sshd_t, file_type, sysadmfile, pidfile;
#line 7027

#line 7027

#line 7027

#line 7027

#line 7027
#
#line 7027
# Allow the process to modify the directory.
#line 7027
#
#line 7027
allow sshd_t var_run_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 7027

#line 7027
#
#line 7027
# Allow the process to create the file.
#line 7027
#
#line 7027

#line 7027

#line 7027
allow sshd_t sshd_var_run_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 7027

#line 7027

#line 7027
type_transition sshd_t var_run_t:file sshd_var_run_t;
#line 7027

#line 7027

#line 7027
allow sshd_t sshd_var_run_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 7027

#line 7027

#line 7027
type sshd_extern_var_run_t alias var_run_sshd_extern_t, file_type, sysadmfile, pidfile;
#line 7027

#line 7027

#line 7027

#line 7027

#line 7027
#
#line 7027
# Allow the process to modify the directory.
#line 7027
#
#line 7027
allow sshd_extern_t var_run_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 7027

#line 7027
#
#line 7027
# Allow the process to create the file.
#line 7027
#
#line 7027

#line 7027

#line 7027
allow sshd_extern_t sshd_extern_var_run_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 7027

#line 7027

#line 7027
type_transition sshd_extern_t var_run_t:file sshd_extern_var_run_t;
#line 7027

#line 7027

#line 7027
allow sshd_extern_t sshd_extern_var_run_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 7027

#line 7027




# so a tunnel can point to another ssh tunnel...

#line 7032
allow sshd_t sshd_t:tcp_socket { connectto recvfrom };
#line 7032
allow sshd_t sshd_t:tcp_socket { acceptfrom recvfrom };
#line 7032
allow sshd_t tcp_socket_t:tcp_socket { recvfrom };
#line 7032
allow sshd_t tcp_socket_t:tcp_socket { recvfrom };
#line 7032



#line 7034
type sshd_tmp_t, file_type, sysadmfile, tmpfile ;
#line 7034

#line 7034

#line 7034

#line 7034

#line 7034
#
#line 7034
# Allow the process to modify the directory.
#line 7034
#
#line 7034
allow sshd_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 7034

#line 7034
#
#line 7034
# Allow the process to create the file.
#line 7034
#
#line 7034

#line 7034
allow sshd_t sshd_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 7034
allow sshd_t sshd_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 7034

#line 7034

#line 7034
type_transition sshd_t tmp_t:dir sshd_tmp_t;
#line 7034
type_transition sshd_t tmp_t:{ file lnk_file sock_file fifo_file } sshd_tmp_t;
#line 7034

#line 7034

#line 7034





# Type for the ssh executable.
type ssh_exec_t, file_type, exec_type, sysadmfile;

# Everything else is in the ssh_domain macro in
# macros/program/ssh_macros.te.

#DESC Su - Run shells with substitute user and group
#
# Domains for the su program.
# X-Debian-Packages: login

#
# su_exec_t is the type of the su executable.
#
type su_exec_t, file_type, sysadmfile, exec_type;

allow sysadm_su_t user_home_dir_type:dir search;

# Everything else is in the su_domain macro in
# macros/program/su_macros.te.
#DESC Syslogd - System log daemon
#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
# X-Debian-Packages: sysklogd syslog-ng
#

#################################
#
# Rules for the syslogd_t domain.
#
# syslogd_t is the domain of syslogd.
# syslogd_exec_t is the type of the syslogd executable.
# devlog_t is the type of the Unix domain socket created 
# by syslogd.
#
#line 7078

#line 7078

#line 7078

#line 7078

#line 7078
type syslogd_t, domain, privlog ;
#line 7078
type syslogd_exec_t, file_type, sysadmfile, exec_type;
#line 7078

#line 7078
role system_r types syslogd_t;
#line 7078

#line 7078
# Inherit and use descriptors from init.
#line 7078
allow syslogd_t init_t:fd use;
#line 7078
allow syslogd_t init_t:process sigchld;
#line 7078
allow syslogd_t self:process { { sigchld sigkill sigstop signull signal } fork };
#line 7078

#line 7078

#line 7078
allow syslogd_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 7078
allow syslogd_t lib_t:lnk_file { read getattr lock ioctl };
#line 7078
allow syslogd_t ld_so_t:file { read getattr lock execute ioctl };
#line 7078
allow syslogd_t ld_so_t:file execute_no_trans;
#line 7078
allow syslogd_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 7078
allow syslogd_t shlib_t:file { read getattr lock execute ioctl };
#line 7078
allow syslogd_t shlib_t:lnk_file { read getattr lock ioctl };
#line 7078
allow syslogd_t ld_so_cache_t:file { read getattr lock ioctl };
#line 7078
allow syslogd_t device_t:dir search;
#line 7078
allow syslogd_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 7078

#line 7078

#line 7078
allow syslogd_t { self proc_t }:dir { read getattr lock search ioctl };
#line 7078
allow syslogd_t { self proc_t }:lnk_file read;
#line 7078

#line 7078
allow syslogd_t device_t:dir { getattr search };
#line 7078
allow syslogd_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 7078
allow syslogd_t console_device_t:chr_file { ioctl read getattr lock write append };
#line 7078

#line 7078

#line 7078

#line 7078

#line 7078

#line 7078
#
#line 7078
# Allow the process to transition to the new domain.
#line 7078
#
#line 7078
allow initrc_t syslogd_t:process transition;
#line 7078

#line 7078
#
#line 7078
# Do not audit when glibc secure mode is enabled upon the transition.
#line 7078
#
#line 7078
dontaudit initrc_t syslogd_t:process noatsecure;
#line 7078

#line 7078
#
#line 7078
# Allow the process to execute the program.
#line 7078
# 
#line 7078
allow initrc_t syslogd_exec_t:file { read { getattr execute } };
#line 7078

#line 7078
#
#line 7078
# Allow the process to reap the new domain.
#line 7078
#
#line 7078
allow syslogd_t initrc_t:process sigchld;
#line 7078

#line 7078
#
#line 7078
# Allow the new domain to inherit and use file 
#line 7078
# descriptions from the creating process and vice versa.
#line 7078
#
#line 7078
allow syslogd_t initrc_t:fd use;
#line 7078
allow initrc_t syslogd_t:fd use;
#line 7078

#line 7078
#
#line 7078
# Allow the new domain to write back to the old domain via a pipe.
#line 7078
#
#line 7078
allow syslogd_t initrc_t:fifo_file { ioctl read getattr lock write append };
#line 7078

#line 7078
#
#line 7078
# Allow the new domain to read and execute the program.
#line 7078
#
#line 7078
allow syslogd_t syslogd_exec_t:file { read getattr lock execute ioctl };
#line 7078

#line 7078
#
#line 7078
# Allow the new domain to be entered via the program.
#line 7078
#
#line 7078
allow syslogd_t syslogd_exec_t:file entrypoint;
#line 7078

#line 7078
type_transition initrc_t syslogd_exec_t:process syslogd_t;
#line 7078

#line 7078
allow syslogd_t privfd:fd use;
#line 7078
allow syslogd_t newrole_t:process sigchld;
#line 7078
allow syslogd_t initrc_devpts_t:chr_file { ioctl read getattr lock write append };
#line 7078

#line 7078
# Create pid file.
#line 7078
allow syslogd_t var_t:dir { getattr search };
#line 7078

#line 7078
type syslogd_var_run_t alias var_run_syslogd_t, file_type, sysadmfile, pidfile;
#line 7078

#line 7078

#line 7078

#line 7078

#line 7078
#
#line 7078
# Allow the process to modify the directory.
#line 7078
#
#line 7078
allow syslogd_t var_run_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 7078

#line 7078
#
#line 7078
# Allow the process to create the file.
#line 7078
#
#line 7078

#line 7078

#line 7078
allow syslogd_t syslogd_var_run_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 7078

#line 7078

#line 7078
type_transition syslogd_t var_run_t:file syslogd_var_run_t;
#line 7078

#line 7078

#line 7078
allow syslogd_t syslogd_var_run_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 7078

#line 7078

#line 7078
allow syslogd_t devtty_t:chr_file { ioctl read getattr lock write append };
#line 7078

#line 7078
# for daemons that look at /root on startup
#line 7078
dontaudit syslogd_t sysadm_home_dir_t:dir search;
#line 7078

#line 7078
# for df
#line 7078
allow syslogd_t fs_type:filesystem getattr;
#line 7078

#line 7078

#line 7078
allow syslogd_t etc_t:lnk_file read;
#line 7078

#line 7078
allow syslogd_t locale_t:dir { read getattr lock search ioctl };
#line 7078
allow syslogd_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 7078

#line 7078

#line 7078

#line 7078


# can_network is for the UDP socket

#line 7081
#
#line 7081
# Allow the domain to create and use UDP and TCP sockets.
#line 7081
# Other kinds of sockets must be separately authorized for use.
#line 7081
allow syslogd_t self:udp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 7081
allow syslogd_t self:tcp_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 7081

#line 7081
#
#line 7081
# Allow the domain to send UDP packets.
#line 7081
# Since the destination sockets type is unknown, the generic
#line 7081
# any_socket_t type is used as a placeholder.
#line 7081
#
#line 7081
allow syslogd_t any_socket_t:udp_socket sendto;
#line 7081

#line 7081
#
#line 7081
# Allow the domain to send using any network interface.
#line 7081
# netif_type is a type attribute for all network interface types.
#line 7081
#
#line 7081
allow syslogd_t netif_type:netif { tcp_send udp_send rawip_send };
#line 7081

#line 7081
#
#line 7081
# Allow packets sent by the domain to be received on any network interface.
#line 7081
#
#line 7081
allow syslogd_t netif_type:netif { tcp_recv udp_recv rawip_recv };
#line 7081

#line 7081
#
#line 7081
# Allow the domain to receive packets from any network interface.
#line 7081
# netmsg_type is a type attribute for all default message types.
#line 7081
#
#line 7081
allow syslogd_t netmsg_type:{ udp_socket tcp_socket rawip_socket } recvfrom;
#line 7081

#line 7081
#
#line 7081
# Allow the domain to initiate or accept TCP connections 
#line 7081
# on any network interface.
#line 7081
#
#line 7081
allow syslogd_t netmsg_type:tcp_socket { connectto acceptfrom };
#line 7081

#line 7081
#
#line 7081
# Receive resets from the TCP reset socket.
#line 7081
# The TCP reset socket is labeled with the tcp_socket_t type.
#line 7081
#
#line 7081
allow syslogd_t tcp_socket_t:tcp_socket recvfrom;
#line 7081

#line 7081
dontaudit syslogd_t tcp_socket_t:tcp_socket connectto;
#line 7081

#line 7081
#
#line 7081
# Allow the domain to send to any node.
#line 7081
# node_type is a type attribute for all node types.
#line 7081
#
#line 7081
allow syslogd_t node_type:node { tcp_send udp_send rawip_send };
#line 7081

#line 7081
#
#line 7081
# Allow packets sent by the domain to be received from any node.
#line 7081
#
#line 7081
allow syslogd_t node_type:node { tcp_recv udp_recv rawip_recv };
#line 7081

#line 7081
#
#line 7081
# Allow the domain to send NFS client requests via the socket
#line 7081
# created by mount.
#line 7081
#
#line 7081
allow syslogd_t mount_t:udp_socket { ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 7081

#line 7081
#
#line 7081
# Bind to the default port type.
#line 7081
# Other port types must be separately authorized.
#line 7081
#
#line 7081
#allow syslogd_t port_t:udp_socket name_bind;
#line 7081
#allow syslogd_t port_t:tcp_socket name_bind;
#line 7081


type devlog_t, file_type, sysadmfile;

# if something can log to syslog they should be able to log to the console
allow privlog console_device_t:chr_file { ioctl read write getattr };


#line 7088
type syslogd_tmp_t, file_type, sysadmfile, tmpfile ;
#line 7088

#line 7088

#line 7088

#line 7088

#line 7088
#
#line 7088
# Allow the process to modify the directory.
#line 7088
#
#line 7088
allow syslogd_t tmp_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 7088

#line 7088
#
#line 7088
# Allow the process to create the file.
#line 7088
#
#line 7088

#line 7088
allow syslogd_t syslogd_tmp_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 7088
allow syslogd_t syslogd_tmp_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 7088

#line 7088

#line 7088
type_transition syslogd_t tmp_t:dir syslogd_tmp_t;
#line 7088
type_transition syslogd_t tmp_t:{ file lnk_file sock_file fifo_file } syslogd_tmp_t;
#line 7088

#line 7088

#line 7088


# read files in /etc
allow syslogd_t etc_t:file { read getattr lock ioctl };
allow syslogd_t resolv_conf_t:{ file lnk_file } { read getattr lock ioctl };

# Use capabilities.
allow syslogd_t syslogd_t:capability { net_bind_service dac_override };

# Inherit and use descriptors from init.
allow syslogd_t init_t:fd use;
allow syslogd_t { initrc_devpts_t console_device_t }:chr_file { read write };

# Modify/create log files.

#line 7102
allow syslogd_t var_log_t:dir { read getattr search add_name write };
#line 7102
allow syslogd_t var_log_t:file { create ioctl getattr setattr append link };
#line 7102


# Create and bind to /dev/log or /var/run/log.

#line 7105

#line 7105

#line 7105

#line 7105
#
#line 7105
# Allow the process to modify the directory.
#line 7105
#
#line 7105
allow syslogd_t { device_t var_run_t }:dir { read getattr lock search ioctl add_name remove_name write };
#line 7105

#line 7105
#
#line 7105
# Allow the process to create the file.
#line 7105
#
#line 7105

#line 7105

#line 7105
allow syslogd_t devlog_t:sock_file { create ioctl read getattr lock write setattr append link unlink rename };
#line 7105

#line 7105

#line 7105
type_transition syslogd_t { device_t var_run_t }:sock_file devlog_t;
#line 7105

#line 7105

allow syslogd_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
allow syslogd_t self:unix_dgram_socket { sendto };
allow syslogd_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
allow syslogd_t self:fifo_file { ioctl read getattr lock write append };
allow syslogd_t devlog_t:unix_stream_socket name_bind;
allow syslogd_t devlog_t:unix_dgram_socket name_bind;

# Domains with the privlog attribute may log to syslogd.
allow privlog devlog_t:sock_file { ioctl read getattr lock write append };

#line 7115
allow privlog syslogd_t:unix_dgram_socket sendto;
#line 7115


#line 7116
allow privlog syslogd_t:unix_stream_socket connectto;
#line 7116

# allow /dev/log to be a link elsewhere for chroot setup
allow privlog devlog_t:lnk_file read;

#line 7123

#line 7123
# Write to the cron log.
#line 7123
allow syslogd_t crond_log_t:file { ioctl read getattr lock write append };
#line 7123


#line 7127

#line 7127
allow logrotate_t syslogd_exec_t:file { read getattr lock ioctl };
#line 7127


# uncomment this to allow syslogd to log to virtual consoles
#allow syslogd_t tty_device_t:chr_file rw_file_perms;

#line 7137

#DESC Tmpreaper - Monitor and maintain temporary files
#
# Author:  Russell Coker <russell@coker.com.au>
# X-Debian-Packages: tmpreaper
#

#################################
#
# Rules for the tmpreaper_t domain.
#
type tmpreaper_t, domain, privlog;
type tmpreaper_exec_t, file_type, sysadmfile, exec_type;

role system_r types tmpreaper_t;


#line 7153

#line 7153

#line 7153

#line 7153
#
#line 7153
# Allow the process to transition to the new domain.
#line 7153
#
#line 7153
allow system_crond_t tmpreaper_t:process transition;
#line 7153

#line 7153
#
#line 7153
# Do not audit when glibc secure mode is enabled upon the transition.
#line 7153
#
#line 7153
dontaudit system_crond_t tmpreaper_t:process noatsecure;
#line 7153

#line 7153
#
#line 7153
# Allow the process to execute the program.
#line 7153
# 
#line 7153
allow system_crond_t tmpreaper_exec_t:file { read { getattr execute } };
#line 7153

#line 7153
#
#line 7153
# Allow the process to reap the new domain.
#line 7153
#
#line 7153
allow tmpreaper_t system_crond_t:process sigchld;
#line 7153

#line 7153
#
#line 7153
# Allow the new domain to inherit and use file 
#line 7153
# descriptions from the creating process and vice versa.
#line 7153
#
#line 7153
allow tmpreaper_t system_crond_t:fd use;
#line 7153
allow system_crond_t tmpreaper_t:fd use;
#line 7153

#line 7153
#
#line 7153
# Allow the new domain to write back to the old domain via a pipe.
#line 7153
#
#line 7153
allow tmpreaper_t system_crond_t:fifo_file { ioctl read getattr lock write append };
#line 7153

#line 7153
#
#line 7153
# Allow the new domain to read and execute the program.
#line 7153
#
#line 7153
allow tmpreaper_t tmpreaper_exec_t:file { read getattr lock execute ioctl };
#line 7153

#line 7153
#
#line 7153
# Allow the new domain to be entered via the program.
#line 7153
#
#line 7153
allow tmpreaper_t tmpreaper_exec_t:file entrypoint;
#line 7153

#line 7153
type_transition system_crond_t tmpreaper_exec_t:process tmpreaper_t;
#line 7153

#line 7153
allow tmpreaper_t crond_t:fifo_file { getattr read write ioctl };
#line 7153
# a rule for privfd may make this obsolete
#line 7153
allow tmpreaper_t crond_t:fd use;
#line 7153
allow tmpreaper_t crond_t:process sigchld;
#line 7153


#line 7154
allow tmpreaper_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 7154
allow tmpreaper_t lib_t:lnk_file { read getattr lock ioctl };
#line 7154
allow tmpreaper_t ld_so_t:file { read getattr lock execute ioctl };
#line 7154
allow tmpreaper_t ld_so_t:file execute_no_trans;
#line 7154
allow tmpreaper_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 7154
allow tmpreaper_t shlib_t:file { read getattr lock execute ioctl };
#line 7154
allow tmpreaper_t shlib_t:lnk_file { read getattr lock ioctl };
#line 7154
allow tmpreaper_t ld_so_cache_t:file { read getattr lock ioctl };
#line 7154
allow tmpreaper_t device_t:dir search;
#line 7154
allow tmpreaper_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 7154

allow tmpreaper_t tmpfile:dir { { read getattr lock search ioctl add_name remove_name write } rmdir };
allow tmpreaper_t tmpfile:{ file lnk_file sock_file fifo_file } { getattr unlink };
allow tmpreaper_t home_type:{ file lnk_file sock_file fifo_file } { getattr unlink };
allow tmpreaper_t self:process { fork sigchld };
allow tmpreaper_t self:capability { dac_override dac_read_search fowner };
allow tmpreaper_t fs_t:filesystem getattr;


#line 7162
allow tmpreaper_t etc_t:dir { read getattr lock search ioctl };
#line 7162
allow tmpreaper_t etc_t:{ file lnk_file } { read getattr lock ioctl };
#line 7162

allow tmpreaper_t var_t:dir { getattr search };

#line 7164
allow tmpreaper_t var_lib_t:dir { read getattr lock search ioctl };
#line 7164
allow tmpreaper_t var_lib_t:{ file lnk_file } { read getattr lock ioctl };
#line 7164

allow tmpreaper_t device_t:dir { getattr search };
allow tmpreaper_t random_device_t:chr_file { getattr read };

#line 7171

#DESC Useradd - Manage system user accounts
#
# Authors:  Chris Vance <cvance@tislabs.com>  David Caplan <dac@tresys.com>
#           Russell Coker <russell@coker.com.au>
# X-Debian-Packages: passwd
#

#################################
#
# Rules for the useradd_t and groupadd_t domains.
#
# useradd_t is the domain of the useradd/userdel programs.
# groupadd_t is for adding groups (can not create home dirs)
#
#line 7234


#line 7235
type useradd_t, domain, privlog, auth_write, privowner;
#line 7235
role sysadm_r types useradd_t;
#line 7235

#line 7235

#line 7235
# Access other processes in the same domain.
#line 7235
# Omits ptrace, setexec, and setfscreate.  These must be granted 
#line 7235
# separately if desired.
#line 7235
allow useradd_t self:process ~{ptrace setexec setfscreate};
#line 7235

#line 7235
# Access /proc/PID files for processes in the same domain.
#line 7235
allow useradd_t self:dir { read getattr lock search ioctl };
#line 7235
allow useradd_t self:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 7235

#line 7235
# Access file descriptions, pipes, and sockets
#line 7235
# created by processes in the same domain.
#line 7235
allow useradd_t self:fd *;
#line 7235
allow useradd_t self:fifo_file { ioctl read getattr lock write append };
#line 7235
allow useradd_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 7235
allow useradd_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 7235

#line 7235
# Allow the domain to communicate with other processes in the same domain.
#line 7235
allow useradd_t self:unix_dgram_socket sendto;
#line 7235
allow useradd_t self:unix_stream_socket connectto;
#line 7235

#line 7235
# Access System V IPC objects created by processes in the same domain.
#line 7235
allow useradd_t self:sem  { associate getattr setattr create destroy read write unix_read unix_write };
#line 7235
allow useradd_t self:msg  { send receive };
#line 7235
allow useradd_t self:msgq { associate getattr setattr create destroy read write enqueue unix_read unix_write };
#line 7235
allow useradd_t self:shm  { associate getattr setattr create destroy read write lock unix_read unix_write };
#line 7235

#line 7235

#line 7235
allow useradd_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 7235
allow useradd_t lib_t:lnk_file { read getattr lock ioctl };
#line 7235
allow useradd_t ld_so_t:file { read getattr lock execute ioctl };
#line 7235
allow useradd_t ld_so_t:file execute_no_trans;
#line 7235
allow useradd_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 7235
allow useradd_t shlib_t:file { read getattr lock execute ioctl };
#line 7235
allow useradd_t shlib_t:lnk_file { read getattr lock ioctl };
#line 7235
allow useradd_t ld_so_cache_t:file { read getattr lock ioctl };
#line 7235
allow useradd_t device_t:dir search;
#line 7235
allow useradd_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 7235

#line 7235

#line 7235
type useradd_exec_t, file_type, sysadmfile, exec_type;
#line 7235

#line 7235

#line 7235

#line 7235
#
#line 7235
# Allow the process to transition to the new domain.
#line 7235
#
#line 7235
allow sysadm_t useradd_t:process transition;
#line 7235

#line 7235
#
#line 7235
# Do not audit when glibc secure mode is enabled upon the transition.
#line 7235
#
#line 7235
dontaudit sysadm_t useradd_t:process noatsecure;
#line 7235

#line 7235
#
#line 7235
# Allow the process to execute the program.
#line 7235
# 
#line 7235
allow sysadm_t useradd_exec_t:file { read { getattr execute } };
#line 7235

#line 7235
#
#line 7235
# Allow the process to reap the new domain.
#line 7235
#
#line 7235
allow useradd_t sysadm_t:process sigchld;
#line 7235

#line 7235
#
#line 7235
# Allow the new domain to inherit and use file 
#line 7235
# descriptions from the creating process and vice versa.
#line 7235
#
#line 7235
allow useradd_t sysadm_t:fd use;
#line 7235
allow sysadm_t useradd_t:fd use;
#line 7235

#line 7235
#
#line 7235
# Allow the new domain to write back to the old domain via a pipe.
#line 7235
#
#line 7235
allow useradd_t sysadm_t:fifo_file { ioctl read getattr lock write append };
#line 7235

#line 7235
#
#line 7235
# Allow the new domain to read and execute the program.
#line 7235
#
#line 7235
allow useradd_t useradd_exec_t:file { read getattr lock execute ioctl };
#line 7235

#line 7235
#
#line 7235
# Allow the new domain to be entered via the program.
#line 7235
#
#line 7235
allow useradd_t useradd_exec_t:file entrypoint;
#line 7235

#line 7235
type_transition sysadm_t useradd_exec_t:process useradd_t;
#line 7235

#line 7235

#line 7235
# Use capabilities.
#line 7235
allow useradd_t self:capability { dac_override chown };
#line 7235

#line 7235
# Allow access to context for shadow file
#line 7235

#line 7235
allow useradd_t security_t:dir { read search getattr };
#line 7235
allow useradd_t security_t:file { getattr read write };
#line 7235
allow useradd_t security_t:security { check_context compute_av compute_create compute_relabel compute_user };
#line 7235

#line 7235

#line 7235
# Inherit and use descriptors from login.
#line 7235
allow useradd_t privfd:fd use;
#line 7235

#line 7235
# Execute /usr/bin/{passwd,chfn,chsh} and /usr/sbin/{useradd,vipw}.
#line 7235
allow useradd_t { bin_t sbin_t }:dir { read getattr lock search ioctl };
#line 7235

#line 7235
allow useradd_t { bin_t sbin_t }:file { { read getattr lock execute ioctl } execute_no_trans };
#line 7235

#line 7235

#line 7235
# Update /etc/shadow and /etc/passwd
#line 7235

#line 7235

#line 7235

#line 7235

#line 7235
#
#line 7235
# Allow the process to modify the directory.
#line 7235
#
#line 7235
allow useradd_t etc_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 7235

#line 7235
#
#line 7235
# Allow the process to create the file.
#line 7235
#
#line 7235

#line 7235

#line 7235
allow useradd_t shadow_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 7235

#line 7235

#line 7235
type_transition useradd_t etc_t:file shadow_t;
#line 7235

#line 7235

#line 7235
allow useradd_t etc_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 7235

#line 7235
# Set fscreate context.
#line 7235

#line 7235
allow useradd_t self:process setfscreate;
#line 7235
allow useradd_t proc_t:dir search;
#line 7235
allow useradd_t proc_t:lnk_file read;
#line 7235
allow useradd_t self:dir search;
#line 7235
allow useradd_t self:file { read write };
#line 7235

#line 7235

#line 7235
allow useradd_t { etc_t shadow_t }:file { relabelfrom relabelto };
#line 7235

#line 7235

#line 7235
allow useradd_t etc_t:lnk_file read;
#line 7235

#line 7235
allow useradd_t locale_t:dir { read getattr lock search ioctl };
#line 7235
allow useradd_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 7235

#line 7235

#line 7235

#line 7235
# useradd/userdel request read/write for /var/log/lastlog, and read of /dev, 
#line 7235
# but will operate without them.
#line 7235
dontaudit useradd_t { device_t var_t var_log_t }:dir search;
#line 7235

#line 7235
# For userdel and groupadd
#line 7235
allow useradd_t fs_t:filesystem getattr;
#line 7235

#line 7235
# Access terminals.
#line 7235
allow useradd_t ttyfile:chr_file { ioctl read getattr lock write append };
#line 7235
allow useradd_t ptyfile:chr_file { ioctl read getattr lock write append };
#line 7235

#line 7235

#line 7235
# for when /root is the cwd
#line 7235
dontaudit useradd_t sysadm_home_dir_t:dir search;
#line 7235


# Add/remove user home directories

#line 7238

#line 7238

#line 7238

#line 7238
#
#line 7238
# Allow the process to modify the directory.
#line 7238
#
#line 7238
allow useradd_t home_root_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 7238

#line 7238
#
#line 7238
# Allow the process to create the file.
#line 7238
#
#line 7238

#line 7238

#line 7238
allow useradd_t user_home_dir_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 7238

#line 7238

#line 7238
type_transition useradd_t home_root_t:dir user_home_dir_t;
#line 7238

#line 7238


#line 7239

#line 7239

#line 7239

#line 7239
#
#line 7239
# Allow the process to modify the directory.
#line 7239
#
#line 7239
allow useradd_t user_home_dir_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 7239

#line 7239
#
#line 7239
# Allow the process to create the file.
#line 7239
#
#line 7239

#line 7239
allow useradd_t user_home_t:{ file lnk_file sock_file fifo_file } { create ioctl read getattr lock write setattr append link unlink rename };
#line 7239
allow useradd_t user_home_t:dir { create read getattr lock setattr link unlink rename search add_name remove_name reparent write rmdir };
#line 7239

#line 7239

#line 7239
type_transition useradd_t user_home_dir_t:dir user_home_t;
#line 7239
type_transition useradd_t user_home_dir_t:{ file lnk_file sock_file fifo_file } user_home_t;
#line 7239

#line 7239


# create/delete mail spool file in /var/mail
allow useradd_t var_spool_t:dir search;
allow useradd_t mail_spool_t:dir { search write add_name remove_name };
allow useradd_t mail_spool_t:file { create setattr getattr unlink };
# /var/mail is a link to /var/spool/mail
allow useradd_t mail_spool_t:lnk_file read;

allow useradd_t self:capability { fowner fsetid setuid sys_resource };

#line 7249
allow useradd_t shell_exec_t:file { { read getattr lock execute ioctl } execute_no_trans };
#line 7249


# /usr/bin/userdel locks the user being deleted, allow write access to utmp
allow useradd_t initrc_var_run_t:file { read write lock };


#line 7254
type groupadd_t, domain, privlog, auth_write, privowner;
#line 7254
role sysadm_r types groupadd_t;
#line 7254

#line 7254

#line 7254
# Access other processes in the same domain.
#line 7254
# Omits ptrace, setexec, and setfscreate.  These must be granted 
#line 7254
# separately if desired.
#line 7254
allow groupadd_t self:process ~{ptrace setexec setfscreate};
#line 7254

#line 7254
# Access /proc/PID files for processes in the same domain.
#line 7254
allow groupadd_t self:dir { read getattr lock search ioctl };
#line 7254
allow groupadd_t self:{ file lnk_file sock_file fifo_file } { read getattr lock ioctl };
#line 7254

#line 7254
# Access file descriptions, pipes, and sockets
#line 7254
# created by processes in the same domain.
#line 7254
allow groupadd_t self:fd *;
#line 7254
allow groupadd_t self:fifo_file { ioctl read getattr lock write append };
#line 7254
allow groupadd_t self:unix_dgram_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown };
#line 7254
allow groupadd_t self:unix_stream_socket { create ioctl read getattr write setattr append bind connect getopt setopt shutdown listen accept };
#line 7254

#line 7254
# Allow the domain to communicate with other processes in the same domain.
#line 7254
allow groupadd_t self:unix_dgram_socket sendto;
#line 7254
allow groupadd_t self:unix_stream_socket connectto;
#line 7254

#line 7254
# Access System V IPC objects created by processes in the same domain.
#line 7254
allow groupadd_t self:sem  { associate getattr setattr create destroy read write unix_read unix_write };
#line 7254
allow groupadd_t self:msg  { send receive };
#line 7254
allow groupadd_t self:msgq { associate getattr setattr create destroy read write enqueue unix_read unix_write };
#line 7254
allow groupadd_t self:shm  { associate getattr setattr create destroy read write lock unix_read unix_write };
#line 7254

#line 7254

#line 7254
allow groupadd_t { root_t usr_t lib_t etc_t }:dir { read getattr lock search ioctl };
#line 7254
allow groupadd_t lib_t:lnk_file { read getattr lock ioctl };
#line 7254
allow groupadd_t ld_so_t:file { read getattr lock execute ioctl };
#line 7254
allow groupadd_t ld_so_t:file execute_no_trans;
#line 7254
allow groupadd_t ld_so_t:lnk_file { read getattr lock ioctl };
#line 7254
allow groupadd_t shlib_t:file { read getattr lock execute ioctl };
#line 7254
allow groupadd_t shlib_t:lnk_file { read getattr lock ioctl };
#line 7254
allow groupadd_t ld_so_cache_t:file { read getattr lock ioctl };
#line 7254
allow groupadd_t device_t:dir search;
#line 7254
allow groupadd_t null_device_t:chr_file { ioctl read getattr lock write append };
#line 7254

#line 7254

#line 7254
type groupadd_exec_t, file_type, sysadmfile, exec_type;
#line 7254

#line 7254

#line 7254

#line 7254
#
#line 7254
# Allow the process to transition to the new domain.
#line 7254
#
#line 7254
allow sysadm_t groupadd_t:process transition;
#line 7254

#line 7254
#
#line 7254
# Do not audit when glibc secure mode is enabled upon the transition.
#line 7254
#
#line 7254
dontaudit sysadm_t groupadd_t:process noatsecure;
#line 7254

#line 7254
#
#line 7254
# Allow the process to execute the program.
#line 7254
# 
#line 7254
allow sysadm_t groupadd_exec_t:file { read { getattr execute } };
#line 7254

#line 7254
#
#line 7254
# Allow the process to reap the new domain.
#line 7254
#
#line 7254
allow groupadd_t sysadm_t:process sigchld;
#line 7254

#line 7254
#
#line 7254
# Allow the new domain to inherit and use file 
#line 7254
# descriptions from the creating process and vice versa.
#line 7254
#
#line 7254
allow groupadd_t sysadm_t:fd use;
#line 7254
allow sysadm_t groupadd_t:fd use;
#line 7254

#line 7254
#
#line 7254
# Allow the new domain to write back to the old domain via a pipe.
#line 7254
#
#line 7254
allow groupadd_t sysadm_t:fifo_file { ioctl read getattr lock write append };
#line 7254

#line 7254
#
#line 7254
# Allow the new domain to read and execute the program.
#line 7254
#
#line 7254
allow groupadd_t groupadd_exec_t:file { read getattr lock execute ioctl };
#line 7254

#line 7254
#
#line 7254
# Allow the new domain to be entered via the program.
#line 7254
#
#line 7254
allow groupadd_t groupadd_exec_t:file entrypoint;
#line 7254

#line 7254
type_transition sysadm_t groupadd_exec_t:process groupadd_t;
#line 7254

#line 7254

#line 7254
# Use capabilities.
#line 7254
allow groupadd_t self:capability { dac_override chown };
#line 7254

#line 7254
# Allow access to context for shadow file
#line 7254

#line 7254
allow groupadd_t security_t:dir { read search getattr };
#line 7254
allow groupadd_t security_t:file { getattr read write };
#line 7254
allow groupadd_t security_t:security { check_context compute_av compute_create compute_relabel compute_user };
#line 7254

#line 7254

#line 7254
# Inherit and use descriptors from login.
#line 7254
allow groupadd_t privfd:fd use;
#line 7254

#line 7254
# Execute /usr/bin/{passwd,chfn,chsh} and /usr/sbin/{useradd,vipw}.
#line 7254
allow groupadd_t { bin_t sbin_t }:dir { read getattr lock search ioctl };
#line 7254

#line 7254
allow groupadd_t { bin_t sbin_t }:file { { read getattr lock execute ioctl } execute_no_trans };
#line 7254

#line 7254

#line 7254
# Update /etc/shadow and /etc/passwd
#line 7254

#line 7254

#line 7254

#line 7254

#line 7254
#
#line 7254
# Allow the process to modify the directory.
#line 7254
#
#line 7254
allow groupadd_t etc_t:dir { read getattr lock search ioctl add_name remove_name write };
#line 7254

#line 7254
#
#line 7254
# Allow the process to create the file.
#line 7254
#
#line 7254

#line 7254

#line 7254
allow groupadd_t shadow_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 7254

#line 7254

#line 7254
type_transition groupadd_t etc_t:file shadow_t;
#line 7254

#line 7254

#line 7254
allow groupadd_t etc_t:file { create ioctl read getattr lock write setattr append link unlink rename };
#line 7254

#line 7254
# Set fscreate context.
#line 7254

#line 7254
allow groupadd_t self:process setfscreate;
#line 7254
allow groupadd_t proc_t:dir search;
#line 7254
allow groupadd_t proc_t:lnk_file read;
#line 7254
allow groupadd_t self:dir search;
#line 7254
allow groupadd_t self:file { read write };
#line 7254

#line 7254

#line 7254
allow groupadd_t { etc_t shadow_t }:file { relabelfrom relabelto };
#line 7254

#line 7254

#line 7254
allow groupadd_t etc_t:lnk_file read;
#line 7254

#line 7254
allow groupadd_t locale_t:dir { read getattr lock search ioctl };
#line 7254
allow groupadd_t locale_t:{ file lnk_file } { read getattr lock ioctl };
#line 7254

#line 7254

#line 7254

#line 7254
# useradd/userdel request read/write for /var/log/lastlog, and read of /dev, 
#line 7254
# but will operate without them.
#line 7254
dontaudit groupadd_t { device_t var_t var_log_t }:dir search;
#line 7254

#line 7254
# For userdel and groupadd
#line 7254
allow groupadd_t fs_t:filesystem getattr;
#line 7254

#line 7254
# Access terminals.
#line 7254
allow groupadd_t ttyfile:chr_file { ioctl read getattr lock write append };
#line 7254
allow groupadd_t ptyfile:chr_file { ioctl read getattr lock write append };
#line 7254

#line 7254

#line 7254
# for when /root is the cwd
#line 7254
dontaudit groupadd_t sysadm_home_dir_t:dir search;
#line 7254


# some apps ask for these accesses, but seems to work regardless
dontaudit groupadd_t initrc_var_run_t:file write;
dontaudit groupadd_t var_run_t:dir search;
dontaudit groupadd_t self:capability fsetid;
##############################
#
# Assertions for the type enforcement (TE) configuration.
#

#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
#

##################################
#
# Access vector assertions.
#
# An access vector assertion specifies permissions that should not be in
# an access vector based on a source type, a target type, and a class.
# If any of the specified permissions are in the corresponding access
# vector, then the policy compiler will reject the policy configuration.
# Currently, there is only one kind of access vector assertion, neverallow, 
# but support for the other kinds of vectors could be easily added.  Access 
# vector assertions use the same syntax as access vector rules.
#

#
# Verify that every type that can be entered by
# a domain is also tagged as a domain.
#
neverallow domain ~domain:process transition;

#
# Verify that only the insmod_t and kernel_t domains 
# have the sys_module capability.
#
neverallow ~{ insmod_t kernel_t } self:capability sys_module;

#
# Verify that executable types, the system dynamic loaders, and the
# system shared libraries can only be modified by administrators.
#
neverallow ~{ ldconfig_t admin} { exec_type ld_so_t shlib_t }:file { write append unlink rename };
neverallow ~{ ldconfig_t setfiles_t admin } { exec_type ld_so_t shlib_t }:file relabelto;

#
# Verify that only appropriate domains can access /etc/shadow
neverallow ~{ auth auth_write } shadow_t:file ~getattr;
neverallow ~auth_write shadow_t:file ~{ read getattr lock ioctl };

#
# Verify that other system software can only be modified by administrators.
#
neverallow ~{ ldconfig_t admin } { lib_t bin_t sbin_t }:dir { add_name remove_name rename };
neverallow ~admin { lib_t bin_t sbin_t }:file { write append unlink rename };

#
# Verify that only certain domains have access to the raw disk devices.
#
neverallow ~fs_domain fixed_disk_device_t:{ chr_file blk_file } { read write append };

#
# Verify that only the X server and klogd have access to memory devices.
#
neverallow ~privmem memory_device_t:{ chr_file blk_file } { read write append };

#
# Verify that /proc/kmsg is only accessible to klogd.
#
#line 7331

#line 7331
neverallow ~klogd_t proc_kmsg_t:file ~{ getattr };

#
# Verify that /proc/kcore is inaccessible.
#
neverallow * proc_kcore_t:file ~{ getattr };

#
# Verify that sysctl variables are only changeable
# by initrc and administrators.
#
neverallow ~{ initrc_t admin kernel_t insmod_t } sysctl_t:file { write append };
neverallow ~{ initrc_t admin } sysctl_fs_t:file { write append };
neverallow ~{ init_t initrc_t admin kernel_t insmod_t } sysctl_kernel_t:file { write append };
neverallow ~{ initrc_t admin } sysctl_net_t:file { write append };
neverallow ~{ initrc_t admin } sysctl_net_unix_t:file { write append };
neverallow ~{ initrc_t admin } sysctl_vm_t:file { write append };
neverallow ~{ initrc_t admin } sysctl_dev_t:file { write append };
neverallow ~{ initrc_t admin } sysctl_modprobe_t:file { write append };

#
# Verify that certain domains are limited to only being
# entered by their entrypoint types and to only executing
# the dynamic loader without a transition to another domain.
#

#line 7361



#line 7363
    neverallow getty_t ~getty_exec_t:file entrypoint; neverallow getty_t ~{ getty_exec_t ld_so_t }:file execute_no_trans;

#line 7364
    neverallow klogd_t ~klogd_exec_t:file entrypoint; neverallow klogd_t ~{ klogd_exec_t ld_so_t }:file execute_no_trans;




#line 7368
    neverallow syslogd_t ~syslogd_exec_t:file entrypoint; neverallow syslogd_t ~{ syslogd_exec_t ld_so_t }:file execute_no_trans;






#line 7378

#line 7378
neverallow { local_login_t remote_login_t } ~login_exec_t:file entrypoint;
#line 7378
neverallow { local_login_t remote_login_t } ~ld_so_t:file execute_no_trans;
#line 7378


#
# Verify that the passwd domain can only be entered by its
# entrypoint type and can only execute the dynamic loader
# and the ordinary passwd program without a transition to another domain.
#
#line 7389

#line 7389
neverallow passwd_t ~{ passwd_exec_t }:file entrypoint;
#line 7389
neverallow sysadm_passwd_t ~{ admin_passwd_exec_t }:file entrypoint;
#line 7389
neverallow { passwd_t sysadm_passwd_t } ~{ bin_t sbin_t shell_exec_t ld_so_t }:file execute_no_trans;
#line 7389


#
# Verify that only the admin domains and initrc_t have setenforce.
#
neverallow ~{ admin initrc_t } security_t:security setenforce;

#
# Verify that only the kernel and load_policy_t have load_policy.
#
neverallow ~{ kernel_t load_policy_t } security_t:security load_policy;

#
# for gross mistakes in policy
neverallow * domain:dir ~{ read getattr lock search ioctl };
neverallow * domain:{ file lnk_file sock_file fifo_file chr_file blk_file } ~{ ioctl read getattr lock write append };
neverallow ~{ domain unlabeled_t } *:process *;
#line 1 "rbac"
################################################
#
# Role-based access control (RBAC) configuration.
#

#line 9

#line 13

#line 15

########################################
#
# Role allow rules.
#
# A role allow rule specifies the allowable
# transitions between roles on an execve.
# If no rule is specified, then the change in
# roles will not be permitted.  Additional
# controls over role transitions based on the
# type of the process may be specified through
# the constraints file.
#
# The syntax of a role allow rule is:
# 	allow current_role new_role ;
#

#
# Allow the system_r role to transition 
# into the sysadm_r role.
#
allow system_r sysadm_r;

#
# Allow the user and admin role to transition to httpd_admin_r
#
#line 44


# 
# Allow the admin role to transition to the system
# role for run_init.
#
allow sysadm_r system_r;
