// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.shadervm;

import static net.cellcomputing.himawari.library.EqIntIndex.SHD_var_uniform_matrix;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.IqShaderData;
import net.cellcomputing.himawari.library.types.CqMatrix;

/**
 * CqShaderVaribaleUniformpA
 * CqMatrix^̕ϐShaderData
 * @author NTT DATA Corporation
 */
public strictfp class CqShaderVariableUniformMatrix extends CqShaderVariableUniform<CqMatrix> {
	
	/**
	 * RXgN^
	 *
	 */
	public CqShaderVariableUniformMatrix()
	{
		super(new EqVariableType(EqVariableType.type_matrix));
		m_Value = new CqMatrix();
		CqStats.STATS_INC( SHD_var_uniform_matrix );
	}
	
	/**
	 * RXgN^
	 * @param strName
	 * @param fParameter
	 */
	public CqShaderVariableUniformMatrix( final String strName, boolean fParameter)
	{
		super( strName, fParameter ,new EqVariableType(EqVariableType.type_matrix));
		m_Value = new CqMatrix();
		CqStats.STATS_INC( SHD_var_uniform_matrix );
	}
	
	/**
	 * RXgN^
	 * 
	 * @param strName
	 */
	public CqShaderVariableUniformMatrix( final String strName){
		this(strName,false);
	}
	/**
	 * Rs[RXgN^
	 * @param val Rs[
	 */
	public CqShaderVariableUniformMatrix(CqShaderVariableUniformMatrix val){
		super(val,new EqVariableType(EqVariableType.type_matrix));
	}
	/**
	 * ShaderData̎CqMatrix̒l擾
	 * @param res 擾li[ϐ
	 * @param index gpȂ
	 */	
	public	void	GetMatrix( CqMatrix res, int index )
	{
		res.assignment(m_Value);
	}
	/**
	 * ShaderData̎ACqMatrix̃|C^擾B
	 * 
	 * @param res ʂi[BgύXShaderDataȂ̒le󂯂
	 */
	public	void	GetMatrixPtr( final STLVector<CqMatrix> res )
	{
		if(res.size() < 1)
			res.add(m_Value);
		else
			res.setElementAt(m_Value,0);
	}
	/**
	 * ShaderData̒lύXB
	 * 
	 * @param c ύXl
	 */
	public	void	SetMatrix( final CqMatrix c )
	{
		m_Value.assignment(c);
	}
	/** 
	 * Copy the values from the passed variable into this, taking into account any class differences.
	 * œnꂽϐ̒lRs[B
	 * 
	 * @param pVal Rs[̕ϐ. The variable to copy from.
	 */
	public	void	SetValueFromVariable( final IqShaderData pVal )
	{
		pVal.GetMatrix( m_Value );
	}

	/**
	 * ƓlCX^XԂ
	 * 
	 * @return g̃Rs[
	 */
	public	IqShaderData Clone()
	{
		CqShaderVariableUniformMatrix newVar = new CqShaderVariableUniformMatrix( this );
		newVar.SetSize( (int)Size() );
		newVar.SetValueFromVariable( this );
		return ( newVar );
	}
}
