package net.cellcomputing.himawari.parser.keywords;

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
import java.lang.reflect.Method;

import net.cellcomputing.himawari.library.RendermanInterface;
import net.cellcomputing.himawari.parser.Global;
import net.cellcomputing.himawari.parser.Tokenizer;

public strictfp class KeywordMakeBump extends AbstractKeywordParser {

	  public void parse(Tokenizer st) throws Exception {
		  
	        // Expect picturename
	        match(st, TK_STRING);
	        String imagefile = st.sval;

	        // Expect bumpfile
	        match(st, TK_STRING);
	        String bumpfile = st.sval;

	        // Expect swrap
	        match(st, TK_STRING);
	        String swrap = st.sval;
	        
	        // Expect twrap 
	        match(st, TK_STRING);
	        String twrap = st.sval;
	        
	        // Expect filter
	        match(st, TK_STRING);
	        String filtername = Global.GetFilterFunction( st.sval ); 
	        Method filterfunc = RendermanInterface.class.getMethod( filtername, float.class, float.class, float.class, float.class);
		      
	        // Expect swidth
	        match(st, TK_NUMBER);
	        float swidth = (float)st.nval;

	        // Expect twidth
	        match(st, TK_NUMBER);
	        float twidth = (float)st.nval;

	        // Expect parameter list
	        parseParameterList(st);
	        
	        
	       RendermanInterface.RiMakeBumpV( imagefile, bumpfile, swrap, twrap, filterfunc, swidth, twidth, 
	        										count(), tokens(), values() );
	       
	    }
}
