// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.types;


/**
 * 
 * 3xNg<br>
 * 2/4xNg̕ϊAPʃxNg郁\bhB
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqVector3D {
	
	private static final long serialVersionUID = 4782309621216697640L;
	public float	x;	///< X component.
	public float	y;	///< Y component.
	public float	z;
	//************************************************************************//
	//*** RXgN^̒`
	//************************************************************************//
	
	/**
	 * ftHgRXgN^͉Ȃ
	 */
	public CqVector3D() {}
	
	/**
	 * Rs[RXgN^
	 * @param From	Rs[
	 */
	public CqVector3D( CqVector3D From ){
//		this.assignment( From );
		x = From.x;
		y = From.y;
		z = From.z;
	}
	
	/**
	 * QxNgƂɏBevfRs[ARvfɂ͂OB
	 * @param From	QxNg
	 */
	public CqVector3D( final CqVector2D From ){
		this.x = From.x;
		this.y = From.y;
		this.z = 0.0f;
	}
	
	/**
	 * RGBJ[ƂɏBevfRs[B<br>
	 * Iɂ́APvfRGB̏ԂŃRs[sB
	 * @param From	
	 */
	public CqVector3D( final CqColor From ){
//		this.assignment(From);
		x = From.m_fRed;
		y = From.m_fGreen;
		z = From.m_fBlue;
		
	}
	
	/**
	 * floaẗlƂɂRxNg쐬B
	 * @param x	s̑Pvf
	 * @param y	s̑Qvf
	 * @param z	s̑Rvf
	 */
	public CqVector3D( float x, float y, float z ){
		this.x = x;
		this.y = y;
		this.z = z;
	}
	
	/**
	 * floaẗlSvfƂĂRxNg쐬B
	 * @param f	s̑Svf̒l
	 */
	public CqVector3D( float f ){
		this.x = f;
		this.y = f;
		this.z = f;
	}
	
	/**
	 * SxNg̑P`RvfꂼSvfŊÃIuWFNg̊evfɑB
	 * @param From	CqVector4D
	 */
	public CqVector3D( final CqVector4D From ){
//		this.assignment(From);
		if( From.w != 1.0 )
		{
			x = From.x / From.w;
			y = From.y / From.w;
			z = From.z / From.w;
		}
		else
		{
			x = From.x;
			y = From.y;
			z = From.z;
		}
	}
	
	/**
	 * RzƂɏBevfRs[
	 * @param array	float^Rz
	 */
	public CqVector3D( final float[] array ){
		this.x = array[0];
		this.y = array[1];
		this.z = array[2];
	}
	
	//************************************************************************//
	//*** \bh̒`
	//************************************************************************//
	
	/**
	 * Pvf̃Zb^
	 * @param x	Pvf
	 */
	public void x( float x ){
		this.x = x;
	}
	
	/**
	 * Qvf̃Zb^
	 * @param y	Qvf
	 */
	public void y( float y ){
		this.y = y;
	}
	
	/**
	 * Rvf̃Zb^
	 * @param z	Rvf
	 */
	public void z( float z ){
		this.z = z;
	}
	
	/**
	 * xNĝQԂ
	 * @return	xNĝQ
	 */
	public float Magnitude2()
	{
//		return this.lengthSquared();
        return ( ( x * x ) + ( y * y ) + ( z * z ) );

	}
	
	/**
	 * xNg̒Ԃ
	 * @return	xNg̒
	 */
	public float Magnitude()
	{
//		return (this.Magnitude2() <= 0) ? 0.0f: this.length();
		float mag2 = Magnitude2();
        return ( mag2<=0.0f? 0.0f : (float)(Math.sqrt( mag2 )) );

	}
	
	/**
	 * Pʉ 
	 * @return	Pʉꂽg
	 */
	public CqVector3D Unit()
	{
		float Mag = Magnitude();
		if( Mag > 0.0f )
		{
			x /= Mag;
			y /= Mag;
			z /= Mag;
		}
		return this;
	}
	
	//************************************************************************//
	//*** Zq̃I[o[[h
	//************************************************************************//
	
	/**
	 * zQƉZqB
	 * 0,1,2ꂼx,y,zɑBȊO̒l̏ꍇzԂB
	 * 
	 * @param i	0,1,2̐
	 * @return	x,y,z
	 */
	public float valueAt( int i ){
		switch ( i )
		{
		case 0:		return ( x );
		case 1:		return ( y );
		case 2:		return ( z );
		default:	return ( z );
		}
	}
	
	//nttdata 
	/**
	 * ZqB
	 * CqVector3DSvf̃xNg̊evfփRs[B 
	 * 
	 * @param From	CqVector3DIuWFNg
	 * @return	vZʁihtisj
	 */
	public CqVector3D assignment( final float a_x,final float a_y ){
		
		x = a_x;
		y = a_y;
		z = 0.0f;
		
		return this;
	}
	/**
	 * ZqB
	 * CqVector3DSvf̃xNg̊evfփRs[B 
	 * 
	 * @param From	CqVector3DIuWFNg
	 * @return	vZʁihtisj
	 */
	public CqVector3D assignment( final float a_x,final float a_y, final float a_z ){
		
		x = a_x;
		y = a_y;
		z = a_z;
		
		return this;
	}
	// ܂
	/**
	 * ZqB
	 * CqVector3DSvf̃xNg̊evfփRs[B 
	 * 
	 * @param From	CqVector3DIuWFNg
	 * @return	vZʁihtisj
	 */
	public CqVector3D assignment( final CqVector2D From ){
		
		x = From.x;
		y = From.y;
		z = 0.0f;
		
		return this;
	}
	/**
	 * ZqB
	 * CqVector3DSvf̃xNg̊evfփRs[B 
	 * 
	 * @param From	CqVector3DIuWFNg
	 * @return	vZʁihtisj
	 */
	public CqVector3D assignment( final CqVector3D From ){
		
		x = From.x;
		y = From.y;
		z = From.z;
		
		return this;
	}
	
	/**
	 * ZqB
	 * SxNg̑B <br>
	 * SxNg̑P`RvfꂼSvfŊÃIuWFNg̊evfɑB
	 * 
	 * @param From	CqVector4DIuWFNg
	 * @return	ʁithisj
	 */
	public CqVector3D assignment( final CqVector4D From ){
		
		if( From.w != 1.0 )
		{
			x = From.x / From.w;
			y = From.y / From.w;
			z = From.z / From.w;
		}
		else
		{
			x = From.x;
			y = From.y;
			z = From.z;
		}
		
		return this;
	}
	
	/**
	 * ZqB
	 * CqColorRBG̃xNg̊evfփRs[B 
	 * 
	 * @param From	CqColorIuWFNg
	 * @return	vZʁihtisj
	 */
	public CqVector3D assignment( final CqColor From ){
		
//		x = From.fRed();
//		y = From.fGreen();
//		z = From.fBlue();
		x = From.m_fRed;
		y = From.m_fGreen;
		z = From.m_fBlue;
		return this;
	}
	
	/**
	 * ZB
	 * CqVector3Dm̊evfꂼɉZsB
	 * 
	 * @param From	ZCqVector3D
	 * @return	vZʁithisj
	 */
	public CqVector3D assignAdd( final CqVector3D From ){
		
		//this.add( this, From );
		this.x += From.x;
		this.y += From.y;
		this.z += From.z;
		
		return this;
	}
	
	
	/**
	 * ZB
	 * ̃xNg̑Svfɑ΂fZB
	 * 
	 * @param f	Zl
	 * @return	vZʁithisj
	 */
	public CqVector3D assignAdd( final float f ){
		
		this.x += f;
		this.y += f;
		this.z += f;
		return this;
	}
	
	/**
	 * ZB
	 * CqVector3Dm̊evfꂼɌZsB
	 * 
	 * @param From	ZCqVector3D
	 * @return	vZʁithisj
	 */
	public CqVector3D assignSub( final CqVector3D From ){
		
//		this.sub( this, From );
		this.x -= From.x;
		this.y -= From.y;
		this.z -= From.z;
		
		return this;
	}
	
	/**
	 * ZB
	 * ̃xNg̑Svfɑ΂fZB
	 * 
	 * @param f	Zl
	 * @return	vZʁithisj
	 */
	public CqVector3D assignSub( final float f ){
		
		this.x -= f;
		this.y -= f;
		this.z -= f;
		return this;
	}
	
	/**
	 * ]ZB
	 * ACqVector3Dł͏]Z(%)́uOρvZƂĈB
	 * 
	 * @param From	OϑΏۂCqVector3D
	 * @return	vZʁithisj
	 */
	public CqVector3D assignMod( final CqVector3D From ){
		
//		this.cross( this, From );
		CqVector3D vecTemp  = new CqVector3D(this);
	    x = ( vecTemp.y * From.z ) - ( vecTemp.z * From.y );
	    y = ( vecTemp.z * From.x ) - ( vecTemp.x * From.z );
	    z = ( vecTemp.x * From.y ) - ( vecTemp.y * From.x );
		return this;
	}
	
	/**
	 * ZB
	 * xN^̃XJ{vZB
	 * 
	 * @param f	XJl
	 * @return	vZʁithisj
	 */
	public CqVector3D assignMul( float f ){
//		this.scale(f);
		this.x *= f;
		this.y *= f;
		this.z *= f;
		
		return this;
	}
	
	/**
	 * ZB
	 * xN^m̊evf|킹B
	 * 
	 * @param Scale	ZCqVector3D
	 * @return	vZʁithisj
	 */
	public CqVector3D assignMul(final CqVector3D Scale ){
		
		this.x *= Scale.x;
		this.y *= Scale.y;
		this.z *= Scale.z;
		return this;
	}
	
	/**
	 * ZB
	 * xN^m̊evfB
	 * 
	 * @param Scale	ZCqVector3D
	 * @return	vZʁithisj
	 */
	public CqVector3D assignDiv( final CqVector3D Scale ){
		
		this.x /= Scale.x;
		this.y /= Scale.y;
		this.z /= Scale.z;
		return this;
	}
	
	/**
	 * ZB
	 * xN^̊evfw肵XJlŊB
	 * 	
	 * @param Scale	Zl
	 * @return	vZʁithisj
	 */
	public CqVector3D assignDiv( float Scale ){
		
		this.x /= Scale;
		this.y /= Scale;
		this.z /= Scale;
		return this;
	}
	
	/**
	* rZqB
	* SĂ̗vfƂtrueԂB
	* 
	* @param Cmp	rΏۂCqVector3D
	* @return	true:  SĂ̗vf<br>
	* 			false: ꂩ̗vfȂ
	*/
	public boolean equals( final CqVector3D Cmp ){
		return ( ( x == Cmp.x ) && ( y == Cmp.y ) && ( z == Cmp.z ) );
//		return this.equals(Cmp);
	}
	
	/**
	 * ErZqB@<br>
	 * SvfrASĂ̂傫trueԂB
	 * 
	 * @param Cmp	rΏۂCqVector3D
	 * @return	trueF	Svf傫<br>
	 * 			falseF	ꂩ̗vf
	 */
	public boolean ge( final CqVector3D Cmp )
	{
		return ( ( x >= Cmp.x ) && ( y >= Cmp.y ) && ( z >= Cmp.z ) );
	}
	
	/**
	 * rZqB@<br>
	 * SvfrASĂ̂菬trueԂB
	 * 
	 * @param Cmp	rΏۂCqVector3D
	 * @return	trueF	Svf<br>
	 * 			falseF	ꂩ̗vf傫
	 */
	public boolean le( final CqVector3D Cmp )
	{
		return ( ( x <= Cmp.x ) && ( y <= Cmp.y ) && ( z <= Cmp.z ) );
	}
	
	/**
	 * ErZqB@<br>
	 * SvfrASĂ̂傫trueԂB
	 * 
	 * @param Cmp	rΏۂCqVector3D
	 * @return	trueF	Svf傫<br>
	 * 			falseF	ꂩ̗vf
	 */
	public boolean gt( final CqVector3D Cmp ) 
	{
		return ( ( x > Cmp.x ) && ( y > Cmp.y ) && ( z > Cmp.z ) );
	}
	
	/**
	 * rZqB@<br>
	 * SvfrASĂ̂菬trueԂB
	 * 
	 * @param Cmp	rΏۂCqVector3D
	 * @return	trueF	Svf<br>
	 * 			falseF	ꂩ̗vf傫
	 */
	public boolean lt( final CqVector3D Cmp )
	{
		return ( ( x < Cmp.x ) && ( y < Cmp.y ) && ( z < Cmp.z ) );
	}
	
	/**
	 * ZZqB
	 * SvfꂼfZB
	 * 
	 * @param f	Zl
	 * @return	vZ
	 */
	public CqVector3D add( float f )
	{
		CqVector3D r = new CqVector3D( x,y,z );
		return r.assignAdd(f);	
	}
	
	/**
	 * ZZqB
	 * SvfꂼꂩfZB
	 * 
	 * @param f	Zl
	 * @return	vZ
	 */
	public CqVector3D sub( float f )
	{
		CqVector3D r = new CqVector3D( x,y,z );
		return r.assignSub(f);	
	}
	
	/**
	 * tZZqB
	 * Svfꂼf猸ZB
	 * 
	 * @param f	Zl
	 * @return	vZ
	 */
	public CqVector3D subInv( float f )
	{
		return new CqVector3D( f - this.x, f - this.y, f - this.z );	
	}
	
	/**
	 * ZZqB
	 * SvfꂼfZB
	 * 
	 * @param f	Zl
	 * @return	vZ
	 */
	public CqVector3D mul( float f )
	{
		CqVector3D r = new CqVector3D( x,y,z );
		return r.assignMul(f);	
	}
	
	/**
	 * ZZqB
	 * SvfꂼꂩfZB(v/f)
	 * 
	 * @param f	Zl
	 * @return	vZ
	 */
	public CqVector3D div( float f )
	{
		CqVector3D r = new CqVector3D( x,y,z );
		return r.assignDiv(f);	
	}
	
	/**
	 * tZZqB
	 * Svfꂼf珜ZB(f/v)
	 * 
	 * @param f	Zl
	 * @return	vZ
	 */
	public CqVector3D divInv( float f )
	{
		return new CqVector3D( f / this.x, f / this.y, f / this.z );	
	}
	
	/**
	 * ZZqB
	 * evfꂼZB
	 * 
	 * @param b	ZCqVector3D
	 * @return	vZ
	 */
	public CqVector3D add( final CqVector3D b ){
		CqVector3D r = new CqVector3D( x,y,z );
		return r.assignAdd(b);
	}
	
	/**
	 * ZZqB
	 * evfꂼZB
	 * 
	 * @param b	ZCqVector3D
	 * @return	vZ
	 */
	public CqVector3D sub( final CqVector3D b ){
		CqVector3D r = new CqVector3D( x,y,z );
		return r.assignSub(b);
	}
	
	/**
	 * ZZqB
	 * evfꂼZB
	 * 
	 * @param b	ZCqVector3D
	 * @return	vZ
	 */
	public CqVector3D div( final CqVector3D b ){
		CqVector3D r = new CqVector3D( x,y,z );
		return r.assignDiv(b);
	}
	
	/**
	 * ZZqB
	 * ACqVector3Dł͏Z(*)́uρvZƂĈB
	 * 
	 * @param b	ϑΏۂCqVector3D
	 * @return	vZ
	 */
	public float mul( final CqVector3D b ){
//		return this.dot(b);
		return (x * b.x + y * b.y + z * b.z);
	}
	
	/**
	 * ]ZZqB
	 * ACqVector3Dł͏]Z(%)́uOρvZƂĈB
	 * 
	 * @param b	OϑΏۂCqVector3D
	 * @return	vZ
	 */
	public CqVector3D mod( final CqVector3D b ){
//		CqVector3D r =  new CqVector3D();
//		r.cross( this, b );
//		return r;
	    return ( new CqVector3D( ( y * b.z ) - ( z * b.y ),
                ( z * b.x ) - ( x * b.z ),
                ( x * b.y ) - ( y * b.x ) ) );

	}
	
	/**
	 * ]B <br>
	 * Svf̕𔽓]lŐVCqVector3DIuWFNg쐬ĕԂ
	 * 
	 * @return	t̐VCqVector3DIuWFNg
	 */
	public CqVector3D negative()
	{
//		CqVector3D r =  new CqVector3D(this);
//		r.negate();
//		return  r;
        return (new  CqVector3D( -x, -y, -z ) );

	}
	
	/**
	 * 2̃xNg̊Oς߂
	 * modƈقȂQ̊OόvZʂgɔf
	 * @param r xNg1
	 * @param v xNg2
	 */
	public void exterior(final CqVector3D r,final CqVector3D v){
        double x,y;

        x = r.y*v.z - r.z*v.y;
        y = v.x*r.z - v.z*r.x;
        this.z = r.x*v.y - r.y*v.x;
        this.x = (float)x;
        this.y = (float)y;
	}
}
