// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.types;

import static java.lang.Math.acos;
import static java.lang.Math.cos;
import static java.lang.Math.sin;
import static java.lang.Math.sqrt;
import static java.lang.Math.tan;

import java.util.logging.Logger;


import net.cellcomputing.himawari.util.HimawariLogger;


/**
 * 4x4̍sB<br>
 * 
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqMatrix {

	private static final long serialVersionUID = -1422529258858713988L;
	
	private static final float PI = (float)Math.PI;
    public float	m_aaElement[ ][ ] = new float[4][4];		///< The 4x4 array of float values.

	
	/**
	 * Pʍs񂩂ǂ\킷tO
	 */
//	protected boolean m_fIdentity = false;
	public boolean m_fIdentity = false;
	
	//************************************************************************//
	//*** RXgN^̒`
	//************************************************************************//
	
	/**
	 * PʍsŏRXgN^
	 */
	public CqMatrix(){
		super();
		Identity();
	}
	
//	public CqMatrix( int NoInit ){
//		
//	}
	
	/**
	 * XP[w肷RXgN^<br>
	 * Scale matrix constructor
	 * @param xs	x̃XP[
	 * @param ys	ỹXP[
	 * @param zs	z̃XP[
	 */
	public CqMatrix( float xs, float ys, float zs ){
		
	    Identity();

	    if ( xs == 1.0f && ys == 1.0f && zs == 1.0f )
	        m_fIdentity = true;
	    else
	    {
	    	m_aaElement[0][0] = xs;
	    	m_aaElement[1][1] = ys;
	    	m_aaElement[2][2] = zs;
	    	m_aaElement[3][3] = 1.0f;

	        m_fIdentity = false;
	    }
	}
	
	/**
	 * sړw肷RXgN^<br>
	 * @param Trans	sړ\킷RxNg
	 */
	public CqMatrix( CqVector3D Trans ){
		
		Identity();

	    if ( Trans.x == 0.0f && Trans.y == 0.0f && Trans.z == 0.0f )
	        m_fIdentity = true;
	    else
	    {
	        m_fIdentity = false;

	        m_aaElement[3][0] = Trans.x;
	        m_aaElement[3][1] = Trans.y;
	        m_aaElement[3][2] = Trans.z;
	    }
	}
	
	/**
	 * ̉]w肷RXgN^<br>
	 * @param Angle	]piO`Q΁j
	 * @param Axis		]\킷CqVector3DIuWFNg
	 */
	public CqMatrix( float Angle, CqVector3D Axis ){
		
		Identity();
		
		if ( Angle != 0.0f && Axis.Magnitude() != 0.0f ){
			Rotate( Angle, Axis );
		}
		
		
	}
	
	/**
	 * cȂw肷RXgN^<br>
	 * @param angle	pxiO`Q΁j
	 * @param dx1		xNgP̑Pvf
	 * @param dy1		xNgP̑Qvf
	 * @param dz1		xNgP̑Rvf
	 * @param dx2		xNgQ̑Pvf
	 * @param dy2		xNgQ̑Qvf
	 * @param dz2		xNgQ̑Rvf
	 */
	public CqMatrix( float angle, 
					  float dx1, float dy1, float dz1, 
					  float dx2, float dy2, float dz2 ){
		
	    // Normalize the two vectors, and construct a third perpendicular
	    CqVector3D d1 = new CqVector3D( dx1, dy1, dz1 );
	    CqVector3D d2 = new CqVector3D( dx2, dy2, dz2 );
	    d1.Unit();
	    d2.Unit();

	    // Assumes angle already changed to radians.

	    float d1d2dot = d1.mul(d2);
	    float axisangle = (float)acos( d1d2dot );
	    
	    if ( angle >= axisangle || angle <= ( axisangle - PI ) )
	    {
	        // Skewed past the axes -- issue error, then just use identity matrix.
	        // No access to CqBasicError from here, so this will have to be down
	        //   in RiSkew.  That would duplicate the above math calculations
	        //   unless they were passed to this constructor which would be odd
	        //   looking:
	        // CqBasicError(0,Severity_Normal,"RiSkew angle invalid.");
	        Identity();
	    }
	    else
	    {
	    	CqVector3D right = new CqVector3D();
	    	right.assignment( d1.mod(d2) );
	        right.Unit();

	        // d1ortho will be perpendicular to <d2> and <right> and can be
	        // used to construct a rotation matrix
	        CqVector3D d1ortho = new CqVector3D();
	        d1ortho.assignment( d2.mod(right) );

	        // 1) Rotate to a space where the skew operation is in a major plane.
	        // 2) Bend the y axis towards the z axis causing a skew.
	        // 3) Rotate back.
	        CqMatrix Rot = new CqMatrix(	right.x, d1ortho.x, d2.x, 0,
	                      					right.y, d1ortho.y, d2.y, 0,
	                      					right.z, d1ortho.z, d2.z, 0,
	                      					      0,         0,    0, 1 );
	        float par = d1d2dot;  // Amount of d1 parallel to d2
	        float perp = (float)(sqrt( 1.0 - par * par ));   // Amount perpendicular
	        float s = (float)(tan( angle + acos( perp ) ) * perp - par);
	        CqMatrix Skw = new CqMatrix(	1, 0, 0, 0,
	                      					0, 1, s, 0,
	                      					0, 0, 1, 0,
	                      					0, 0, 0, 1 );
	        
	        // Note the Inverse of a rotation matrix is its Transpose.
//	        this = Rot.Transpose() * Skw * Rot;
	        this.assignment(Rot.Transpose());
	        this.assignMul(Skw);
	        this.assignMul(Rot);
	        
//	        System.err.println( "-----01-----\n" + this);
//	        this.assignment(Rot.Transpose());
//	        System.err.println( "-----02-----\n" + this);
//	        this.assignMultiply(Skw);
//	        System.err.println( "-----03-----\n" + this);
//	        this.assignMultiply(Rot);
//	        System.err.println( "-----04-----\n" + this);
	        
	    }
	}
	
	/**
	 * Rs[RXgN^
	 * @param from	Rs[
	 */
	public CqMatrix( CqMatrix from ){
		this.assignment(from);
		this.m_fIdentity = from.m_fIdentity;
	}
	
	/**
	 * evfw肷RXgN^
	 * @param r1c1	PsPڂ̗vf
	 * @param r1c2	PsQڂ̗vf
	 * @param r1c3	PsRڂ̗vf
	 * @param r1c4	PsSڂ̗vf
	 * @param r2c1	QsPڂ̗vf
	 * @param r2c2	QsQڂ̗vf
	 * @param r2c3	QsRڂ̗vf
	 * @param r2c4	QsSڂ̗vf
	 * @param r3c1	RsPڂ̗vf
	 * @param r3c2	RsQڂ̗vf
	 * @param r3c3	RsRڂ̗vf
	 * @param r3c4	RsSڂ̗vf
	 * @param r4c1	SsPڂ̗vf
	 * @param r4c2	SsQڂ̗vf
	 * @param r4c3	SsRڂ̗vf
	 * @param r4c4	SsSڂ̗vf
	 */
	public CqMatrix(
			float r1c1, float r1c2, float r1c3, float r1c4, 
			float r2c1, float r2c2, float r2c3, float r2c4, 
			float r3c1, float r3c2, float r3c3, float r3c4,
			float r4c1, float r4c2, float r4c3, float r4c4 ){
        m_aaElement[ 0 ][ 0 ] = r1c1; m_aaElement[ 0 ][ 1 ] = r1c2; m_aaElement[ 0 ][ 2 ] = r1c3; m_aaElement[ 0 ][ 3 ] = r1c4;
        m_aaElement[ 1 ][ 0 ] = r2c1; m_aaElement[ 1 ][ 1 ] = r2c2; m_aaElement[ 1 ][ 2 ] = r2c3; m_aaElement[ 1 ][ 3 ] = r2c4;
        m_aaElement[ 2 ][ 0 ] = r3c1; m_aaElement[ 2 ][ 1 ] = r3c2; m_aaElement[ 2 ][ 2 ] = r3c3; m_aaElement[ 2 ][ 3 ] = r3c4;
        m_aaElement[ 3 ][ 0 ] = r4c1; m_aaElement[ 3 ][ 1 ] = r4c2; m_aaElement[ 3 ][ 2 ] = r4c3; m_aaElement[ 3 ][ 3 ] = r4c4;
        m_fIdentity = false;

	}
	
	/**
	 * float[4][4]ŏRXgN^
	 * @param From	4x4̂Qz
	 */
	public CqMatrix( float From[][] ){
		m_aaElement[0][0] = From[0][0];	m_aaElement[0][1] = From[0][1];	m_aaElement[0][2] = From[0][2];	m_aaElement[0][3] = From[0][3];
		m_aaElement[1][0] = From[1][0];	m_aaElement[1][1] = From[1][1];	m_aaElement[1][2] = From[1][2];	m_aaElement[1][3] = From[1][3];
		m_aaElement[2][0] = From[2][0];	m_aaElement[2][1] = From[2][1];	m_aaElement[2][2] = From[2][2];	m_aaElement[2][3] = From[2][3];
		m_aaElement[3][0] = From[3][0];	m_aaElement[3][1] = From[3][1];	m_aaElement[3][2] = From[3][2];	m_aaElement[3][3] = From[3][3];
	}

	/**
	 * float[16]ŏRXgN^
	 * @param From@16vf̂Pz
	 */
	public CqMatrix( float From[] ){
	    m_aaElement[ 0 ][ 0 ] = From[ 0 ];
	    m_aaElement[ 0 ][ 1 ] = From[ 1 ];
	    m_aaElement[ 0 ][ 2 ] = From[ 2 ];
	    m_aaElement[ 0 ][ 3 ] = From[ 3 ];
	    m_aaElement[ 1 ][ 0 ] = From[ 4 ];
	    m_aaElement[ 1 ][ 1 ] = From[ 5 ];
	    m_aaElement[ 1 ][ 2 ] = From[ 6 ];
	    m_aaElement[ 1 ][ 3 ] = From[ 7 ];
	    m_aaElement[ 2 ][ 0 ] = From[ 8 ];
	    m_aaElement[ 2 ][ 1 ] = From[ 9 ];
	    m_aaElement[ 2 ][ 2 ] = From[ 10 ];
	    m_aaElement[ 2 ][ 3 ] = From[ 11 ];
	    m_aaElement[ 3 ][ 0 ] = From[ 12 ];
	    m_aaElement[ 3 ][ 1 ] = From[ 13 ];
	    m_aaElement[ 3 ][ 2 ] = From[ 14 ];
	    m_aaElement[ 3 ][ 3 ] = From[ 15 ];
	    m_fIdentity = false;
	}
	
	/**
	 * ׂĂ̗vffɂRXgN^
	 * @param f	ׂĂ̗vfɑl
	 */
	public CqMatrix( float f ){
		m_aaElement[0][0] = m_aaElement[0][1] = m_aaElement[0][2] = m_aaElement[0][3] = f;
		m_aaElement[1][0] = m_aaElement[1][1] = m_aaElement[1][2] = m_aaElement[1][3] = f;
		m_aaElement[2][0] = m_aaElement[2][1] = m_aaElement[2][2] = m_aaElement[2][3] = f;
		m_aaElement[3][0] = m_aaElement[3][1] = m_aaElement[3][2] = m_aaElement[3][3] = f;
	}
	
	/**
	 * SxNgƂɕsړw肵ďRXgN^
	 * @param From	SxNg
	 */
	public CqMatrix( CqVector4D From ){
		this( new CqVector3D( From.x/From.w, From.y/From.w, From.z/From.w ) );
	}
	
	
	//************************************************************************//
	//*** \bh̒`
	//************************************************************************//
	
	/**
	 * Pʉ
	 */
	public void Identity(){
	    m_aaElement[ 0 ][ 1 ] =
	        m_aaElement[ 0 ][ 2 ] =
	            m_aaElement[ 0 ][ 3 ] =
	                m_aaElement[ 1 ][ 0 ] =
	                    m_aaElement[ 1 ][ 2 ] =
	                        m_aaElement[ 1 ][ 3 ] =
	                            m_aaElement[ 2 ][ 0 ] =
	                                m_aaElement[ 2 ][ 1 ] =
	                                    m_aaElement[ 2 ][ 3 ] =
	                                        m_aaElement[ 3 ][ 0 ] =
	                                            m_aaElement[ 3 ][ 1 ] =
	                                                m_aaElement[ 3 ][ 2 ] = 0.0f;

	    m_aaElement[ 0 ][ 0 ] =
	        m_aaElement[ 1 ][ 1 ] =
	            m_aaElement[ 2 ][ 2 ] =
	                m_aaElement[ 3 ][ 3 ] = 1.0f;
	    m_fIdentity = true;
    
	}
	
    /**
     * PʍstOݒ肷B
     * 
     * @param f	Pʍs񂩂ǂtO
     */
    public void SetfIdentity( boolean f )
    {
        m_fIdentity = f;
    }
	
	/**
	 * Pʍs񂩂ǂ 
	 * @return	true:Pʍsł
	 */
	public boolean fIdentity(){
		return m_fIdentity;
	}
	
	/**
	 * XP[ݒ肷
	 * 
	 * @param S	XP[
	 */
	public void Scale( float S ){
	    if ( S != 1.0f ){
	    	Scale( S, S, S );
	    }
	}
	
	/**
	 * XP[ݒ肷
	 * 
	 * @param xs	XXP[
	 * @param ys	YXP[
	 * @param zs	ZXP[
	 */
	public void Scale( float xs, float ys, float zs ){
		
		CqMatrix Scale = new CqMatrix( xs, ys, zs );
		
		this.PreMultiply( Scale );
	}
	
	/**
	 * CqMatrix]B
	 * 
	 * @param Angle	]piO`Q΁j
	 * @param Axis		]\킷CqVector3DIuWFNg
	 */
	public void Rotate( float Angle, CqVector3D Axis ){
		
		if ( Angle != 0.0f )
		{
			CqMatrix	R = new CqMatrix();
			R.Identity();
			CqVector3D	RotAxis = Axis;
			R.m_fIdentity = false;
			
			RotAxis.Unit();
			
			float	s = (float)( sin( Angle ) );
			float	c = (float)( cos( Angle ) );
			float	t = 1.0f - c;
			
			R.m_aaElement[0][0] = t * RotAxis.x * RotAxis.x + c;
			R.m_aaElement[1][1] = t * RotAxis.y * RotAxis.y + c;
			R.m_aaElement[2][2] = t * RotAxis.z * RotAxis.z + c;
			
			float	txy = t * RotAxis.x * RotAxis.y;
			float	sz = s * RotAxis.z;
			
			R.m_aaElement[0][1] = txy + sz;
			R.m_aaElement[1][0] = txy - sz;
			
			float	txz = t * RotAxis.x * RotAxis.z;
			float	sy = s * RotAxis.y;
			
			R.m_aaElement[0][2] = txz - sy;
			R.m_aaElement[2][0] = txz + sy;
			
			float	tyz = t * RotAxis.y * RotAxis.z;
			float	sx = s * RotAxis.x;
			
			R.m_aaElement[1][2] = tyz + sx;
			R.m_aaElement[2][1] = tyz - sx;
			
			this.PreMultiply( R );
		}
	}
	
	/**
	 * CqMatrix𕽍sړ
	 * 
	 * @param Trans	sړ\킷CqVector3D
	 */
	public void Translate( CqVector3D Trans ){
	    CqMatrix matTrans = new CqMatrix( Trans );
	    this.PreMultiply( matTrans );
	}
	
	/**
	 * CqMatrix𕽍sړ
	 * 
	 * @param xt	̕sړ
	 * @param yt	̕sړ
	 * @param zt	̕sړ
	 */
	public void Translate( float xt, float yt, float zt ){
	    if ( xt != 0.0f || yt != 0.0f || zt != 0.0f ){
	        Translate( new CqVector3D( xt, yt, zt ) );
	    }
	}
	
	/**
	 * V[Oifjs
	 * 
	 * @param yh	V[OYvf
	 * @param zh	V[OZvf
	 */
	public void ShearX( float yh, float zh ){
	    CqMatrix Shear = new CqMatrix();
	    Shear.m_fIdentity = false;

	    Shear.m_aaElement[0][1] = yh;
	    Shear.m_aaElement[0][2] = zh;

	    this.PreMultiply( Shear );
	}
	
	/**
	 * V[Oifjs
	 * 
	 * @param xh	V[OXvf
	 * @param zh	V[OZvf
	 */
	public void ShearY( float xh, float zh ){
	    CqMatrix Shear = new CqMatrix();;
	    Shear.m_fIdentity = false;

	    Shear.m_aaElement[1][0] = xh;
	    Shear.m_aaElement[1][2] = zh;

	    this.PreMultiply( Shear );
	}
	
	/**
	 * V[Oifjs
	 * 
	 * @param xh	V[OXvf
	 * @param yh	V[OYvf
	 */
	public void ShearZ( float xh, float yh ){
	    CqMatrix Shear = new CqMatrix();;
	    Shear.m_fIdentity = false;

	    Shear.m_aaElement[2][0] = xh;
	    Shear.m_aaElement[2][1] = yh;

	    this.PreMultiply( Shear );
	}
	
	/**
	 * cȂsiSkewj 
	 * 
	 * @param angle	pxiO`Q΁j
	 * @param dx1		xNgP̑Pvf
	 * @param dy1		xNgP̑Qvf
	 * @param dz1		xNgP̑Rvf
	 * @param dx2		xNgQ̑Pvf
	 * @param dy2		xNgQ̑Qvf
	 * @param dz2		xNgQ̑Rvf
	 */
	public void Skew( float angle,
            float dx1, float dy1, float dz1,
            float dx2, float dy2, float dz2 ){
		
	    CqMatrix Skew = new CqMatrix( angle, dx1, dy1, dz1, dx2, dy2, dz2 );

	    this.PreMultiply( Skew );
	}
	
	/**
	 * K
	 */
	public void Normalise(){
	    for ( int i = 0; i < 4; i++ )
	    {
	        for ( int j = 0; j < 4; j++ )
	        {
	            m_aaElement[ i ][ j ] /= m_aaElement[ 3 ][ 3 ];
//	        	this.setElement( i, j, getElement(i,j)/m33 );
	        }
	    }
	}
	
	
	
	/**
	 * EɂρiA' = ABj. <br>
	 * gɌvZʂB
	 * 
	 * @param From	ZCqMatrix
	 * @return	vZʁithisj
	 */
	public CqMatrix PreMultiply( CqMatrix From ){
		
	    if ( m_fIdentity ){
	    	this.assignment( From );
	    	return this;
	    }
	    else if ( From.m_fIdentity ){
	        return ( this );
	    }
	    
	    CqMatrix A = new CqMatrix( this );

	    m_aaElement[ 0 ][ 0 ] = A.m_aaElement[ 0 ][ 0 ] * From.m_aaElement[ 0 ][ 0 ]
	                            + A.m_aaElement[ 0 ][ 1 ] * From.m_aaElement[ 1 ][ 0 ]
	                            + A.m_aaElement[ 0 ][ 2 ] * From.m_aaElement[ 2 ][ 0 ]
	                            + A.m_aaElement[ 0 ][ 3 ] * From.m_aaElement[ 3 ][ 0 ];
	    m_aaElement[ 0 ][ 1 ] = A.m_aaElement[ 0 ][ 0 ] * From.m_aaElement[ 0 ][ 1 ]
	                            + A.m_aaElement[ 0 ][ 1 ] * From.m_aaElement[ 1 ][ 1 ]
	                            + A.m_aaElement[ 0 ][ 2 ] * From.m_aaElement[ 2 ][ 1 ]
	                            + A.m_aaElement[ 0 ][ 3 ] * From.m_aaElement[ 3 ][ 1 ];
	    m_aaElement[ 0 ][ 2 ] = A.m_aaElement[ 0 ][ 0 ] * From.m_aaElement[ 0 ][ 2 ]
	                            + A.m_aaElement[ 0 ][ 1 ] * From.m_aaElement[ 1 ][ 2 ]
	                            + A.m_aaElement[ 0 ][ 2 ] * From.m_aaElement[ 2 ][ 2 ]
	                            + A.m_aaElement[ 0 ][ 3 ] * From.m_aaElement[ 3 ][ 2 ];
	    m_aaElement[ 0 ][ 3 ] = A.m_aaElement[ 0 ][ 0 ] * From.m_aaElement[ 0 ][ 3 ]
	                            + A.m_aaElement[ 0 ][ 1 ] * From.m_aaElement[ 1 ][ 3 ]
	                            + A.m_aaElement[ 0 ][ 2 ] * From.m_aaElement[ 2 ][ 3 ]
	                            + A.m_aaElement[ 0 ][ 3 ] * From.m_aaElement[ 3 ][ 3 ];

	    m_aaElement[ 1 ][ 0 ] = A.m_aaElement[ 1 ][ 0 ] * From.m_aaElement[ 0 ][ 0 ]
	                            + A.m_aaElement[ 1 ][ 1 ] * From.m_aaElement[ 1 ][ 0 ]
	                            + A.m_aaElement[ 1 ][ 2 ] * From.m_aaElement[ 2 ][ 0 ]
	                            + A.m_aaElement[ 1 ][ 3 ] * From.m_aaElement[ 3 ][ 0 ];
	    m_aaElement[ 1 ][ 1 ] = A.m_aaElement[ 1 ][ 0 ] * From.m_aaElement[ 0 ][ 1 ]
	                            + A.m_aaElement[ 1 ][ 1 ] * From.m_aaElement[ 1 ][ 1 ]
	                            + A.m_aaElement[ 1 ][ 2 ] * From.m_aaElement[ 2 ][ 1 ]
	                            + A.m_aaElement[ 1 ][ 3 ] * From.m_aaElement[ 3 ][ 1 ];
	    m_aaElement[ 1 ][ 2 ] = A.m_aaElement[ 1 ][ 0 ] * From.m_aaElement[ 0 ][ 2 ]
	                            + A.m_aaElement[ 1 ][ 1 ] * From.m_aaElement[ 1 ][ 2 ]
	                            + A.m_aaElement[ 1 ][ 2 ] * From.m_aaElement[ 2 ][ 2 ]
	                            + A.m_aaElement[ 1 ][ 3 ] * From.m_aaElement[ 3 ][ 2 ];
	    m_aaElement[ 1 ][ 3 ] = A.m_aaElement[ 1 ][ 0 ] * From.m_aaElement[ 0 ][ 3 ]
	                            + A.m_aaElement[ 1 ][ 1 ] * From.m_aaElement[ 1 ][ 3 ]
	                            + A.m_aaElement[ 1 ][ 2 ] * From.m_aaElement[ 2 ][ 3 ]
	                            + A.m_aaElement[ 1 ][ 3 ] * From.m_aaElement[ 3 ][ 3 ];

	    m_aaElement[ 2 ][ 0 ] = A.m_aaElement[ 2 ][ 0 ] * From.m_aaElement[ 0 ][ 0 ]
	                            + A.m_aaElement[ 2 ][ 1 ] * From.m_aaElement[ 1 ][ 0 ]
	                            + A.m_aaElement[ 2 ][ 2 ] * From.m_aaElement[ 2 ][ 0 ]
	                            + A.m_aaElement[ 2 ][ 3 ] * From.m_aaElement[ 3 ][ 0 ];
	    m_aaElement[ 2 ][ 1 ] = A.m_aaElement[ 2 ][ 0 ] * From.m_aaElement[ 0 ][ 1 ]
	                            + A.m_aaElement[ 2 ][ 1 ] * From.m_aaElement[ 1 ][ 1 ]
	                            + A.m_aaElement[ 2 ][ 2 ] * From.m_aaElement[ 2 ][ 1 ]
	                            + A.m_aaElement[ 2 ][ 3 ] * From.m_aaElement[ 3 ][ 1 ];
	    m_aaElement[ 2 ][ 2 ] = A.m_aaElement[ 2 ][ 0 ] * From.m_aaElement[ 0 ][ 2 ]
	                            + A.m_aaElement[ 2 ][ 1 ] * From.m_aaElement[ 1 ][ 2 ]
	                            + A.m_aaElement[ 2 ][ 2 ] * From.m_aaElement[ 2 ][ 2 ]
	                            + A.m_aaElement[ 2 ][ 3 ] * From.m_aaElement[ 3 ][ 2 ];
	    m_aaElement[ 2 ][ 3 ] = A.m_aaElement[ 2 ][ 0 ] * From.m_aaElement[ 0 ][ 3 ]
	                            + A.m_aaElement[ 2 ][ 1 ] * From.m_aaElement[ 1 ][ 3 ]
	                            + A.m_aaElement[ 2 ][ 2 ] * From.m_aaElement[ 2 ][ 3 ]
	                            + A.m_aaElement[ 2 ][ 3 ] * From.m_aaElement[ 3 ][ 3 ];

	    m_aaElement[ 3 ][ 0 ] = A.m_aaElement[ 3 ][ 0 ] * From.m_aaElement[ 0 ][ 0 ]
	                            + A.m_aaElement[ 3 ][ 1 ] * From.m_aaElement[ 1 ][ 0 ]
	                            + A.m_aaElement[ 3 ][ 2 ] * From.m_aaElement[ 2 ][ 0 ]
	                            + A.m_aaElement[ 3 ][ 3 ] * From.m_aaElement[ 3 ][ 0 ];
	    m_aaElement[ 3 ][ 1 ] = A.m_aaElement[ 3 ][ 0 ] * From.m_aaElement[ 0 ][ 1 ]
	                            + A.m_aaElement[ 3 ][ 1 ] * From.m_aaElement[ 1 ][ 1 ]
	                            + A.m_aaElement[ 3 ][ 2 ] * From.m_aaElement[ 2 ][ 1 ]
	                            + A.m_aaElement[ 3 ][ 3 ] * From.m_aaElement[ 3 ][ 1 ];
	    m_aaElement[ 3 ][ 2 ] = A.m_aaElement[ 3 ][ 0 ] * From.m_aaElement[ 0 ][ 2 ]
	                            + A.m_aaElement[ 3 ][ 1 ] * From.m_aaElement[ 1 ][ 2 ]
	                            + A.m_aaElement[ 3 ][ 2 ] * From.m_aaElement[ 2 ][ 2 ]
	                            + A.m_aaElement[ 3 ][ 3 ] * From.m_aaElement[ 3 ][ 2 ];
	    m_aaElement[ 3 ][ 3 ] = A.m_aaElement[ 3 ][ 0 ] * From.m_aaElement[ 0 ][ 3 ]
	                            + A.m_aaElement[ 3 ][ 1 ] * From.m_aaElement[ 1 ][ 3 ]
	                            + A.m_aaElement[ 3 ][ 2 ] * From.m_aaElement[ 2 ][ 3 ]
	                            + A.m_aaElement[ 3 ][ 3 ] * From.m_aaElement[ 3 ][ 3 ];

	    m_fIdentity = false;
	    return this;
	}
	
	/**
	 * EɂASxNgƂ̐ρiv = Mvj<br>
	 * 
	 * @param Vector	ZCqVector4D
	 * @return	vZʂCqVector4DIuWFNg
	 */
	public CqVector4D PreMultiply( CqVector4D Vector ){
		
		if ( m_fIdentity ){
			return ( Vector );
		}
		
		CqVector4D Result = new CqVector4D();
		
	    Result.x( m_aaElement[ 0 ][ 0 ] * Vector.x
	              + m_aaElement[ 0 ][ 1 ] * Vector.y
	              + m_aaElement[ 0 ][ 2 ] * Vector.z
	              + m_aaElement[ 0 ][ 3 ] * Vector.w );

	    Result.y( m_aaElement[ 1 ][ 0 ] * Vector.x
	              + m_aaElement[ 1 ][ 1 ] * Vector.y
	              + m_aaElement[ 1 ][ 2 ] * Vector.z
	              + m_aaElement[ 1 ][ 3 ] * Vector.w );

	    Result.z( m_aaElement[ 2 ][ 0 ] * Vector.x
	              + m_aaElement[ 2 ][ 1 ] * Vector.y
	              + m_aaElement[ 2 ][ 2 ] * Vector.z
	              + m_aaElement[ 2 ][ 3 ] * Vector.w );

	    Result.h( m_aaElement[ 3 ][ 0 ] * Vector.x
	              + m_aaElement[ 3 ][ 1 ] * Vector.y
	              + m_aaElement[ 3 ][ 2 ] * Vector.z
	              + m_aaElement[ 3 ][ 3 ] * Vector.w );
		return Result;
	}
	
	/**
	 * tsԂB<br>
	 * A̍s̍s񎮂ȌꍇA̍s񎩐gAB
	 * 
	 * @return	ts
	 */
	public CqMatrix Inverse(){
//		CqMatrix b = new CqMatrix(this);
////		b.invert();
////2007/05/14 watanabei ExceptionLb`悤ɕύX
//		try{
//			b.invert();
//		}catch(SingularMatrixException sme){
//			HimawariLogger.outputException(sme);
//		}
////
		if(this.Determinant() == 0 )
			return this;
	    CqMatrix b = new CqMatrix();		// b evolves from identity into inverse(a)

	    if ( m_fIdentity )
	    {
	        b.assignment(this);
	    }
	    else
	    {
	        b.Identity();
	        b.m_fIdentity = false;

	        int i;
	        int j;
	        int i1;
	    //{xł̌vZɕύX 2007/11/26
	    double[][] aa = new double[4][4];
	    double[][] bb = new double[4][4];
	    bb[0][0] = bb[1][1] = bb[2][2] = bb[3][3] = 1;

	    for(i = 0; i<4 ;i++){
	    	for(j=0; j <4 ;j++){
	    		aa[i][j] = this.m_aaElement[i][j];
	    	}
	    }
	        for ( j = 0; j < 4; j++ )    	// Find largest pivot in column j among rows j..3
	        {
	            i1 = j;
	            for ( i = j + 1; i < 4; i++ )
	            {
	                if ( Math.abs( aa[ i ][ j ] ) > Math.abs( aa[ i1 ][ j ] ) )
	                {
	                    i1 = i;
	                }
	            }

	            if ( i1 != j )
	            {
	                // Swap rows i1 and j in a and b to put pivot on diagonal
	                double temp;

	                temp = aa[ i1 ][ 0 ];
	                aa[ i1 ][ 0 ] = aa[ j ][ 0 ];
	                aa[ j ][ 0 ] = temp;
	                temp = aa[ i1 ][ 1 ];
	                aa[ i1 ][ 1 ] = aa[ j ][ 1 ];
	                aa[ j ][ 1 ] = temp;
	                temp = aa[ i1 ][ 2 ];
	                aa[ i1 ][ 2 ] = aa[ j ][ 2 ];
	                aa[ j ][ 2 ] = temp;
	                temp = aa[ i1 ][ 3 ];
	                aa[ i1 ][ 3 ] = aa[ j ][ 3 ];
	                aa[ j ][ 3 ] = temp;

	                temp = bb[ i1 ][ 0 ];
	                bb[ i1 ][ 0 ] = bb[ j ][ 0 ];
	                bb[ j ][ 0 ] = temp;
	                temp = bb[ i1 ][ 1 ];
	                bb[ i1 ][ 1 ] = bb[ j ][ 1 ];
	                bb[ j ][ 1 ] = temp;
	                temp = bb[ i1 ][ 2 ];
	                bb[ i1 ][ 2 ] = bb[ j ][ 2 ];
	                bb[ j ][ 2 ] = temp;
	                temp = bb[ i1 ][ 3 ];
	                bb[ i1 ][ 3 ] = bb[ j ][ 3 ];
	                bb[ j ][ 3 ] = temp;
	            }

	            // Scale row j to have a unit diagonal
	            if ( aa[ j ][ j ] == 0.0f )
	            {
	                // Can't invert a singular matrix!
	                //				throw XssMatrix(MatrixErr_Singular, __LINE__, ssMakeWide(__FILE__));
	            }
	            double scale = 1.0f / aa[ j ][ j ];
	            bb[ j ][ 0 ] *= scale;
	            bb[ j ][ 1 ] *= scale;
	            bb[ j ][ 2 ] *= scale;
	            bb[ j ][ 3 ] *= scale;
	            // all elements to left of a[j][j] are already zero
	            for ( i1 = j + 1; i1 < 4; i1++ )
	            {
	                aa[ j ][ i1 ] *= scale;
	            }
	            aa[ j ][ j ] = 1.0f;

	            // Eliminate off-diagonal elements in column j of a, doing identical ops to b
	            for ( i = 0; i < 4; i++ )
	            {
	                if ( i != j )
	                {
	                    scale = aa[ i ][ j ];
	                    bb[ i ][ 0 ] -= scale * bb[ j ][ 0 ];
	                    bb[ i ][ 1 ] -= scale * bb[ j ][ 1 ];
	                    bb[ i ][ 2 ] -= scale * bb[ j ][ 2 ];
	                    bb[ i ][ 3 ] -= scale * bb[ j ][ 3 ];

	                    // all elements to left of a[j][j] are zero
	                    // a[j][j] is 1.0
	                    for ( i1 = j + 1; i1 < 4; i1++ )
	                    {
	                        aa[ i ][ i1 ] -= scale * aa[ j ][ i1 ];
	                    }
	                    aa[ i ][ j ] = 0.0f;
	                }
	            }
	        }
	        for(i = 0; i < 4 ;i++){
	        	for(j = 0 ; j < 4 ; j++){
	        		b.m_aaElement[i][j] =(float) bb[i][j];
	        	}
	        }
	    }//܂
		return b;
	}

	/**
	 * ]usԂ
	 * 
	 * @return	̍s̓]us
	 */
	public CqMatrix Transpose(){
		CqMatrix Temp;
		
	    if ( m_fIdentity )
	    {
	        Temp = new CqMatrix(this);
	    }
	    else{
	    	Temp = new CqMatrix(this);
	        Temp.m_aaElement[ 0 ][ 0 ] = m_aaElement[ 0 ][ 0 ];
	        Temp.m_aaElement[ 0 ][ 1 ] = m_aaElement[ 1 ][ 0 ];
	        Temp.m_aaElement[ 0 ][ 2 ] = m_aaElement[ 2 ][ 0 ];
	        Temp.m_aaElement[ 0 ][ 3 ] = m_aaElement[ 3 ][ 0 ];
	        Temp.m_aaElement[ 1 ][ 0 ] = m_aaElement[ 0 ][ 1 ];
	        Temp.m_aaElement[ 1 ][ 1 ] = m_aaElement[ 1 ][ 1 ];
	        Temp.m_aaElement[ 1 ][ 2 ] = m_aaElement[ 2 ][ 1 ];
	        Temp.m_aaElement[ 1 ][ 3 ] = m_aaElement[ 3 ][ 1 ];
	        Temp.m_aaElement[ 2 ][ 0 ] = m_aaElement[ 0 ][ 2 ];
	        Temp.m_aaElement[ 2 ][ 1 ] = m_aaElement[ 1 ][ 2 ];
	        Temp.m_aaElement[ 2 ][ 2 ] = m_aaElement[ 2 ][ 2 ];
	        Temp.m_aaElement[ 2 ][ 3 ] = m_aaElement[ 3 ][ 2 ];
	        Temp.m_aaElement[ 3 ][ 0 ] = m_aaElement[ 0 ][ 3 ];
	        Temp.m_aaElement[ 3 ][ 1 ] = m_aaElement[ 1 ][ 3 ];
	        Temp.m_aaElement[ 3 ][ 2 ] = m_aaElement[ 2 ][ 3 ];
	        Temp.m_aaElement[ 3 ][ 3 ] = m_aaElement[ 3 ][ 3 ];

	        Temp.m_fIdentity = false;
	    }
		
		return Temp;
	}
	
	/**
	 * s񎮂̉Z
	 * 
	 * @return	s
	 */
	public float Determinant(){
	    // Assign to individual variable names to aid selecting correct elements
	    float a1 = m_aaElement[ 0 ][ 0 ];
	    float b1 = m_aaElement[ 0 ][ 1 ];
	    float c1 = m_aaElement[ 0 ][ 2 ];
	    float d1 = m_aaElement[ 0 ][ 3 ];

	    float a2 = m_aaElement[ 1 ][ 0 ];
	    float b2 = m_aaElement[ 1 ][ 1 ];
	    float c2 = m_aaElement[ 1 ][ 2 ];
	    float d2 = m_aaElement[ 1 ][ 3 ];

	    float a3 = m_aaElement[ 2 ][ 0 ];
	    float b3 = m_aaElement[ 2 ][ 1 ];
	    float c3 = m_aaElement[ 2 ][ 2 ];
	    float d3 = m_aaElement[ 2 ][ 3 ];

	    float a4 = m_aaElement[ 3 ][ 0 ];
	    float b4 = m_aaElement[ 3 ][ 1 ];
	    float c4 = m_aaElement[ 3 ][ 2 ];
	    float d4 = m_aaElement[ 3 ][ 3 ];

	    return a1 * det3x3( b2, b3, b4, c2, c3, c4, d2, d3, d4 ) -
	           b1 * det3x3( a2, a3, a4, c2, c3, c4, d2, d3, d4 ) +
	           c1 * det3x3( a2, a3, a4, b2, b3, b4, d2, d3, d4 ) -
	           d1 * det3x3( a2, a3, a4, b2, b3, b4, c2, c3, c4 );

	}
	
//	public float Element( int iRow, int iColumn )
//    {
//        return ( m_aaElement[ iRow ][ iColumn ] );
//    }
//	
//    void	SetElement( int iRow, int iColumn, float fValue )
//    {
//        m_aaElement[ iRow ][ iColumn ] = fValue;
//    }
	
	//************************************************************************//
	//*** Zq̃I[o[[h
	//************************************************************************//
	
	/**
	 * ZZqB
	 * s̐ςԂBɂŽvZiM = BAj
	 * 
	 * @param From	ZCqMatrix
	 * @return	vZ
	 */
	public CqMatrix multiply( final CqMatrix From ){
		
	    CqMatrix Temp = new CqMatrix(this);
	    Temp.assignMul( From );
	    
	    return Temp ;
	}
	
	/**
	 * ZB
	 * s̐ςgɑBɂŽvZiA' = BAj
	 * 
	 * @param From	ZCqMatrix
	 * @return	vZʁithisj
	 */
	public CqMatrix assignMul( final CqMatrix From ){
		
	    if ( m_fIdentity ){
	    	this.assignment( From );
	    	return this;
	    }
	    else if ( From.m_fIdentity ){
	        return ( this );
	    }
	    
	    CqMatrix A = new CqMatrix(this );

	    m_aaElement[ 0 ][ 0 ] = From.m_aaElement[ 0 ][ 0 ] * A.m_aaElement[ 0 ][ 0 ]
	                            + From.m_aaElement[ 0 ][ 1 ] * A.m_aaElement[ 1 ][ 0 ]
	                            + From.m_aaElement[ 0 ][ 2 ] * A.m_aaElement[ 2 ][ 0 ]
	                            + From.m_aaElement[ 0 ][ 3 ] * A.m_aaElement[ 3 ][ 0 ];
	    m_aaElement[ 0 ][ 1 ] = From.m_aaElement[ 0 ][ 0 ] * A.m_aaElement[ 0 ][ 1 ]
	                            + From.m_aaElement[ 0 ][ 1 ] * A.m_aaElement[ 1 ][ 1 ]
	                            + From.m_aaElement[ 0 ][ 2 ] * A.m_aaElement[ 2 ][ 1 ]
	                            + From.m_aaElement[ 0 ][ 3 ] * A.m_aaElement[ 3 ][ 1 ];
	    m_aaElement[ 0 ][ 2 ] = From.m_aaElement[ 0 ][ 0 ] * A.m_aaElement[ 0 ][ 2 ]
	                            + From.m_aaElement[ 0 ][ 1 ] * A.m_aaElement[ 1 ][ 2 ]
	                            + From.m_aaElement[ 0 ][ 2 ] * A.m_aaElement[ 2 ][ 2 ]
	                            + From.m_aaElement[ 0 ][ 3 ] * A.m_aaElement[ 3 ][ 2 ];
	    m_aaElement[ 0 ][ 3 ] = From.m_aaElement[ 0 ][ 0 ] * A.m_aaElement[ 0 ][ 3 ]
	                            + From.m_aaElement[ 0 ][ 1 ] * A.m_aaElement[ 1 ][ 3 ]
	                            + From.m_aaElement[ 0 ][ 2 ] * A.m_aaElement[ 2 ][ 3 ]
	                            + From.m_aaElement[ 0 ][ 3 ] * A.m_aaElement[ 3 ][ 3 ];

	    m_aaElement[ 1 ][ 0 ] = From.m_aaElement[ 1 ][ 0 ] * A.m_aaElement[ 0 ][ 0 ]
	                            + From.m_aaElement[ 1 ][ 1 ] * A.m_aaElement[ 1 ][ 0 ]
	                            + From.m_aaElement[ 1 ][ 2 ] * A.m_aaElement[ 2 ][ 0 ]
	                            + From.m_aaElement[ 1 ][ 3 ] * A.m_aaElement[ 3 ][ 0 ];
	    m_aaElement[ 1 ][ 1 ] = From.m_aaElement[ 1 ][ 0 ] * A.m_aaElement[ 0 ][ 1 ]
	                            + From.m_aaElement[ 1 ][ 1 ] * A.m_aaElement[ 1 ][ 1 ]
	                            + From.m_aaElement[ 1 ][ 2 ] * A.m_aaElement[ 2 ][ 1 ]
	                            + From.m_aaElement[ 1 ][ 3 ] * A.m_aaElement[ 3 ][ 1 ];
	    m_aaElement[ 1 ][ 2 ] = From.m_aaElement[ 1 ][ 0 ] * A.m_aaElement[ 0 ][ 2 ]
	                            + From.m_aaElement[ 1 ][ 1 ] * A.m_aaElement[ 1 ][ 2 ]
	                            + From.m_aaElement[ 1 ][ 2 ] * A.m_aaElement[ 2 ][ 2 ]
	                            + From.m_aaElement[ 1 ][ 3 ] * A.m_aaElement[ 3 ][ 2 ];
	    m_aaElement[ 1 ][ 3 ] = From.m_aaElement[ 1 ][ 0 ] * A.m_aaElement[ 0 ][ 3 ]
	                            + From.m_aaElement[ 1 ][ 1 ] * A.m_aaElement[ 1 ][ 3 ]
	                            + From.m_aaElement[ 1 ][ 2 ] * A.m_aaElement[ 2 ][ 3 ]
	                            + From.m_aaElement[ 1 ][ 3 ] * A.m_aaElement[ 3 ][ 3 ];

	    m_aaElement[ 2 ][ 0 ] = From.m_aaElement[ 2 ][ 0 ] * A.m_aaElement[ 0 ][ 0 ]
	                            + From.m_aaElement[ 2 ][ 1 ] * A.m_aaElement[ 1 ][ 0 ]
	                            + From.m_aaElement[ 2 ][ 2 ] * A.m_aaElement[ 2 ][ 0 ]
	                            + From.m_aaElement[ 2 ][ 3 ] * A.m_aaElement[ 3 ][ 0 ];
	    m_aaElement[ 2 ][ 1 ] = From.m_aaElement[ 2 ][ 0 ] * A.m_aaElement[ 0 ][ 1 ]
	                            + From.m_aaElement[ 2 ][ 1 ] * A.m_aaElement[ 1 ][ 1 ]
	                            + From.m_aaElement[ 2 ][ 2 ] * A.m_aaElement[ 2 ][ 1 ]
	                            + From.m_aaElement[ 2 ][ 3 ] * A.m_aaElement[ 3 ][ 1 ];
	    m_aaElement[ 2 ][ 2 ] = From.m_aaElement[ 2 ][ 0 ] * A.m_aaElement[ 0 ][ 2 ]
	                            + From.m_aaElement[ 2 ][ 1 ] * A.m_aaElement[ 1 ][ 2 ]
	                            + From.m_aaElement[ 2 ][ 2 ] * A.m_aaElement[ 2 ][ 2 ]
	                            + From.m_aaElement[ 2 ][ 3 ] * A.m_aaElement[ 3 ][ 2 ];
	    m_aaElement[ 2 ][ 3 ] = From.m_aaElement[ 2 ][ 0 ] * A.m_aaElement[ 0 ][ 3 ]
	                            + From.m_aaElement[ 2 ][ 1 ] * A.m_aaElement[ 1 ][ 3 ]
	                            + From.m_aaElement[ 2 ][ 2 ] * A.m_aaElement[ 2 ][ 3 ]
	                            + From.m_aaElement[ 2 ][ 3 ] * A.m_aaElement[ 3 ][ 3 ];

	    m_aaElement[ 3 ][ 0 ] = From.m_aaElement[ 3 ][ 0 ] * A.m_aaElement[ 0 ][ 0 ]
	                            + From.m_aaElement[ 3 ][ 1 ] * A.m_aaElement[ 1 ][ 0 ]
	                            + From.m_aaElement[ 3 ][ 2 ] * A.m_aaElement[ 2 ][ 0 ]
	                            + From.m_aaElement[ 3 ][ 3 ] * A.m_aaElement[ 3 ][ 0 ];
	    m_aaElement[ 3 ][ 1 ] = From.m_aaElement[ 3 ][ 0 ] * A.m_aaElement[ 0 ][ 1 ]
	                            + From.m_aaElement[ 3 ][ 1 ] * A.m_aaElement[ 1 ][ 1 ]
	                            + From.m_aaElement[ 3 ][ 2 ] * A.m_aaElement[ 2 ][ 1 ]
	                            + From.m_aaElement[ 3 ][ 3 ] * A.m_aaElement[ 3 ][ 1 ];
	    m_aaElement[ 3 ][ 2 ] = From.m_aaElement[ 3 ][ 0 ] * A.m_aaElement[ 0 ][ 2 ]
	                            + From.m_aaElement[ 3 ][ 1 ] * A.m_aaElement[ 1 ][ 2 ]
	                            + From.m_aaElement[ 3 ][ 2 ] * A.m_aaElement[ 2 ][ 2 ]
	                            + From.m_aaElement[ 3 ][ 3 ] * A.m_aaElement[ 3 ][ 2 ];
	    m_aaElement[ 3 ][ 3 ] = From.m_aaElement[ 3 ][ 0 ] * A.m_aaElement[ 0 ][ 3 ]
	                            + From.m_aaElement[ 3 ][ 1 ] * A.m_aaElement[ 1 ][ 3 ]
	                            + From.m_aaElement[ 3 ][ 2 ] * A.m_aaElement[ 2 ][ 3 ]
	                            + From.m_aaElement[ 3 ][ 3 ] * A.m_aaElement[ 3 ][ 3 ];

	    m_fIdentity = false;
	    
	    return this;
	}
	
	/**
	 * ZZqB
	 * l̃XP[̍s쐬AƂ̐ςԂB
	 * 
	 * @param S	XP[
	 * @return	vZ
	 */
	public CqMatrix multiply( final float S ){
		
	    CqMatrix Temp = new CqMatrix(this);
	    Temp.assignMul(S);
	    
	    return Temp ;
	}
	
	/**
	 * ZZqB
	 * l̃XP[̍s쐬AƂ̐ςgɑB
	 * 
	 * @param S	XP[
	 * @return	vZʁithis)
	 */
	public CqMatrix assignMul( final float S  ){

	    CqMatrix ScaleMatrix = new CqMatrix( S, S, S );

	    this.PreMultiply( ScaleMatrix );

	    return this;
	}
	
	/**
	 * ZZqB
	 * 1x4̃xNg|ςvZԂiv'=vMj
	 * 
	 * @param Vector	ZCqVector4D
	 * @return	vZʂCqVector4Di1x4xNgj
	 */
	public 	CqVector4D multiply( final CqVector4D Vector ){
		
	    if ( m_fIdentity ){
	        return ( Vector );
	    }

	    CqVector4D	Result = new CqVector4D();

	    Result.x =( m_aaElement[0][0] * Vector.x
	              + m_aaElement[1][0] * Vector.y
	              + m_aaElement[2][0] * Vector.z
	              + m_aaElement[3][0] * Vector.w );

	    Result.y =( m_aaElement[0][1] * Vector.x
	              + m_aaElement[1][1] * Vector.y
	              + m_aaElement[2][1] * Vector.z
	              + m_aaElement[3][1] * Vector.w );

	    Result.z =( m_aaElement[0][2] * Vector.x
	              + m_aaElement[1][2] * Vector.y
	              + m_aaElement[2][2] * Vector.z
	              + m_aaElement[3][2] * Vector.w );

	    Result.w =( m_aaElement[0][3] * Vector.x
	              + m_aaElement[1][3] * Vector.y
	              + m_aaElement[2][3] * Vector.z
	              + m_aaElement[3][3] * Vector.w );

	    return ( Result );
	}
	
	/**
	 * ZZqB
	 * RxNgƂ̐ςԂB
	 * 
	 * @param Vector	ZCqVector3D
	 * @return		vZʂCqVector3D
	 */
	public CqVector3D multiply( final CqVector3D Vector )
	{
	    if ( m_fIdentity ){
	        return ( Vector );
	    }

	    CqVector3D	Result = new CqVector3D();

	    float h = ( m_aaElement[0][3] * Vector.x
	                  + m_aaElement[1][3] * Vector.y
	                  + m_aaElement[2][3] * Vector.z
	                  + m_aaElement[3][3] );

	    Result.x =  ( m_aaElement[0][0] * Vector.x
	                + m_aaElement[1][0] * Vector.y
	                + m_aaElement[2][0] * Vector.z
	                + m_aaElement[3][0] ) / h;

	    Result.y =  ( m_aaElement[0][1] * Vector.x
	                + m_aaElement[1][1] * Vector.y
	                + m_aaElement[2][1] * Vector.z
	                + m_aaElement[3][1] ) / h;

	    Result.z =  ( m_aaElement[0][2] * Vector.x
	                + m_aaElement[1][2] * Vector.y
	                + m_aaElement[2][2] * Vector.z
	                + m_aaElement[3][2] ) / h;


	    return ( Result );
	}
	
	/**
	 * ZZqB
	 * SxNgƂɕsړ̂RxNg߁AgƂ̐ςԂB
	 * 
	 * @param Vector	ZSxNg
	 * @return	vZ
	 */
	public CqMatrix add( final CqVector4D Vector )
	{
	    CqMatrix Temp = new CqMatrix(this);
	    Temp.assignAdd( Vector );
	    return ( Temp );
	}
	
	/**
	 * ZB
	 * SxNgƂɕsړ̂RxNg߁AgƂ̐ςԂB
	 * 
	 * @param Vector	ZSxNg
	 * @return	vZʁithisj
	 */
	public CqMatrix assignAdd( final CqVector4D Vector )
	{
	    CqMatrix Trans = new CqMatrix( Vector );

	    this.PreMultiply( Trans );

	    return ( this );
	}
	
	/**
	 * ZZqB
	 * SxNgƂɕsړ̂RxNg߁AgƂ̐ςԂB<br>
	 * ̍ہAP`Rvf̕tɂċ߂B
	 * 
	 * @param Vector	ZSxNg
	 * @return	vZ
	 */
	public CqMatrix sub( final CqVector4D Vector )
	{
	    CqMatrix Temp = new CqMatrix( this );
	    Temp.assignSub( Vector );
	    return ( Temp );
	}

	/**
	 * ZB
	 * SxNgƂɕsړ̂RxNg߁AgƂ̐ςԂB<br>
	 * ̍ہAP`Rvf̕tɂċ߂B
	 * 
	 * @param Vector	ZSxNg
	 * @return	vZʁithisj
	 */
	public CqMatrix assignSub( final CqVector4D Vector )
	{
	    CqVector4D Temp = new CqVector4D( Vector );

	    Temp.x = -Temp.x;
	    Temp.y = -Temp.y;
	    Temp.z = -Temp.z;
	    
	    CqMatrix Trans = new CqMatrix( Temp );

	    this.PreMultiply( Trans );

	    return ( this );
	}
	
	
	/**
	 * ZZqB
	 * 4x4s񓯎m̑Z 
	 * 
	 * @param From	ZCqMatrix
	 * @return	vZ
	 */
	public CqMatrix add( final CqMatrix From )
	{
	    CqMatrix Temp = new CqMatrix( this );
	    Temp.assignAdd( From );
	    return ( Temp );
	}
	

	/**
	 * ZB
	 * 4x4mZAvZʂgƂB
	 * 
	 * @param From	ZCqMatrix
	 * @return	vZʁithisj
	 */
	public CqMatrix assignAdd( final CqMatrix From )
	{
	    m_aaElement[ 0 ][ 0 ] += From.m_aaElement[ 0 ][ 0 ];
	    m_aaElement[ 1 ][ 0 ] += From.m_aaElement[ 1 ][ 0 ];
	    m_aaElement[ 2 ][ 0 ] += From.m_aaElement[ 2 ][ 0 ];
	    m_aaElement[ 3 ][ 0 ] += From.m_aaElement[ 3 ][ 0 ];
	    m_aaElement[ 0 ][ 1 ] += From.m_aaElement[ 0 ][ 1 ];
	    m_aaElement[ 1 ][ 1 ] += From.m_aaElement[ 1 ][ 1 ];
	    m_aaElement[ 2 ][ 1 ] += From.m_aaElement[ 2 ][ 1 ];
	    m_aaElement[ 3 ][ 1 ] += From.m_aaElement[ 3 ][ 1 ];
	    m_aaElement[ 0 ][ 2 ] += From.m_aaElement[ 0 ][ 2 ];
	    m_aaElement[ 1 ][ 2 ] += From.m_aaElement[ 1 ][ 2 ];
	    m_aaElement[ 2 ][ 2 ] += From.m_aaElement[ 2 ][ 2 ];
	    m_aaElement[ 3 ][ 2 ] += From.m_aaElement[ 3 ][ 2 ];
	    m_aaElement[ 0 ][ 3 ] += From.m_aaElement[ 0 ][ 3 ];
	    m_aaElement[ 1 ][ 3 ] += From.m_aaElement[ 1 ][ 3 ];
	    m_aaElement[ 2 ][ 3 ] += From.m_aaElement[ 2 ][ 3 ];
	    m_aaElement[ 3 ][ 3 ] += From.m_aaElement[ 3 ][ 3 ];
		    
	    m_fIdentity = false;

	    return ( this );
	}
	
	/**
	 * ZZqB
	 * 4x4s񓯎m̑Z 
	 * 
	 * @param From	ZCqMatrix
	 * @return	vZ
	 */
	public CqMatrix sub( final CqMatrix From )
	{
	    CqMatrix Temp = new CqMatrix( this );
	    Temp.assignSub( From );
	    return ( Temp );
	}
	
	/**
	 * ZB
	 * 4x4mZAvZʂgƂB
	 * 
	 * @param From	ZCqMatrix
	 * @return	vZʁithisj
	 */
	public CqMatrix assignSub( final CqMatrix From )
	{
	    m_aaElement[ 0 ][ 0 ] -= From.m_aaElement[ 0 ][ 0 ];
	    m_aaElement[ 1 ][ 0 ] -= From.m_aaElement[ 1 ][ 0 ];
	    m_aaElement[ 2 ][ 0 ] -= From.m_aaElement[ 2 ][ 0 ];
	    m_aaElement[ 3 ][ 0 ] -= From.m_aaElement[ 3 ][ 0 ];
	    m_aaElement[ 0 ][ 1 ] -= From.m_aaElement[ 0 ][ 1 ];
	    m_aaElement[ 1 ][ 1 ] -= From.m_aaElement[ 1 ][ 1 ];
	    m_aaElement[ 2 ][ 1 ] -= From.m_aaElement[ 2 ][ 1 ];
	    m_aaElement[ 3 ][ 1 ] -= From.m_aaElement[ 3 ][ 1 ];
	    m_aaElement[ 0 ][ 2 ] -= From.m_aaElement[ 0 ][ 2 ];
	    m_aaElement[ 1 ][ 2 ] -= From.m_aaElement[ 1 ][ 2 ];
	    m_aaElement[ 2 ][ 2 ] -= From.m_aaElement[ 2 ][ 2 ];
	    m_aaElement[ 3 ][ 2 ] -= From.m_aaElement[ 3 ][ 2 ];
	    m_aaElement[ 0 ][ 3 ] -= From.m_aaElement[ 0 ][ 3 ];
	    m_aaElement[ 1 ][ 3 ] -= From.m_aaElement[ 1 ][ 3 ];
	    m_aaElement[ 2 ][ 3 ] -= From.m_aaElement[ 2 ][ 3 ];
	    m_aaElement[ 3 ][ 3 ] -= From.m_aaElement[ 3 ][ 3 ];
		
	    m_fIdentity = false;

	    return ( this );
	}
		
	/**
	 * ZqB
	 * ̍sgƂB
	 * 
	 * @param From	CqMatrix
	 * @return	vZʁithisj
	 */
	public CqMatrix assignment( final CqMatrix From )
	{
	    m_aaElement[ 0 ][ 0 ] = From.m_aaElement[ 0 ][ 0 ];
	    m_aaElement[ 1 ][ 0 ] = From.m_aaElement[ 1 ][ 0 ];
	    m_aaElement[ 2 ][ 0 ] = From.m_aaElement[ 2 ][ 0 ];
	    m_aaElement[ 3 ][ 0 ] = From.m_aaElement[ 3 ][ 0 ];
	    m_aaElement[ 0 ][ 1 ] = From.m_aaElement[ 0 ][ 1 ];
	    m_aaElement[ 1 ][ 1 ] = From.m_aaElement[ 1 ][ 1 ];
	    m_aaElement[ 2 ][ 1 ] = From.m_aaElement[ 2 ][ 1 ];
	    m_aaElement[ 3 ][ 1 ] = From.m_aaElement[ 3 ][ 1 ];
	    m_aaElement[ 0 ][ 2 ] = From.m_aaElement[ 0 ][ 2 ];
	    m_aaElement[ 1 ][ 2 ] = From.m_aaElement[ 1 ][ 2 ];
	    m_aaElement[ 2 ][ 2 ] = From.m_aaElement[ 2 ][ 2 ];
	    m_aaElement[ 3 ][ 2 ] = From.m_aaElement[ 3 ][ 2 ];
	    m_aaElement[ 0 ][ 3 ] = From.m_aaElement[ 0 ][ 3 ];
	    m_aaElement[ 1 ][ 3 ] = From.m_aaElement[ 1 ][ 3 ];
	    m_aaElement[ 2 ][ 3 ] = From.m_aaElement[ 2 ][ 3 ];
	    m_aaElement[ 3 ][ 3 ] = From.m_aaElement[ 3 ][ 3 ];

		this.m_fIdentity = From.m_fIdentity;
		return this;
	}
	
	/**
	 * ZqB
	 * 4x4floatzgƂB
	 * 
	 * @param From	float[4][4]
	 * @return	vZʁithisj
	 */
	public CqMatrix assignment( float[][] From )
	{
	    m_aaElement[ 0 ][ 0 ] = From[ 0 ][ 0 ];
	    m_aaElement[ 1 ][ 0 ] = From[ 1 ][ 0 ];
	    m_aaElement[ 2 ][ 0 ] = From[ 2 ][ 0 ];
	    m_aaElement[ 3 ][ 0 ] = From[ 3 ][ 0 ];
	    m_aaElement[ 0 ][ 1 ] = From[ 0 ][ 1 ];
	    m_aaElement[ 1 ][ 1 ] = From[ 1 ][ 1 ];
	    m_aaElement[ 2 ][ 1 ] = From[ 2 ][ 1 ];
	    m_aaElement[ 3 ][ 1 ] = From[ 3 ][ 1 ];
	    m_aaElement[ 0 ][ 2 ] = From[ 0 ][ 2 ];
	    m_aaElement[ 1 ][ 2 ] = From[ 1 ][ 2 ];
	    m_aaElement[ 2 ][ 2 ] = From[ 2 ][ 2 ];
	    m_aaElement[ 3 ][ 2 ] = From[ 3 ][ 2 ];
	    m_aaElement[ 0 ][ 3 ] = From[ 0 ][ 3 ];
	    m_aaElement[ 1 ][ 3 ] = From[ 1 ][ 3 ];
	    m_aaElement[ 2 ][ 3 ] = From[ 2 ][ 3 ];
	    m_aaElement[ 3 ][ 3 ] = From[ 3 ][ 3 ];
		
		this.m_fIdentity = false;
		return this;
	}
	
	
	/**
	 * ZqB
	 * 1x16floatzgƂB
	 * 
	 * @param From	float[16]
	 * @return	vZʁithisj
	 */
	public CqMatrix assignment( float[] From )
	{
	    m_aaElement[ 0 ][ 0 ] = From[ 0 ];
	    m_aaElement[ 0 ][ 1 ] = From[ 1 ];
	    m_aaElement[ 0 ][ 2 ] = From[ 2 ];
	    m_aaElement[ 0 ][ 3 ] = From[ 3 ];
	    m_aaElement[ 1 ][ 0 ] = From[ 4 ];
	    m_aaElement[ 1 ][ 1 ] = From[ 5 ];
	    m_aaElement[ 1 ][ 2 ] = From[ 6 ];
	    m_aaElement[ 1 ][ 3 ] = From[ 7 ];
	    m_aaElement[ 2 ][ 0 ] = From[ 8 ];
	    m_aaElement[ 2 ][ 1 ] = From[ 9 ];
	    m_aaElement[ 2 ][ 2 ] = From[ 10 ];
	    m_aaElement[ 2 ][ 3 ] = From[ 11 ];
	    m_aaElement[ 3 ][ 0 ] = From[ 12 ];
	    m_aaElement[ 3 ][ 1 ] = From[ 13 ];
	    m_aaElement[ 3 ][ 2 ] = From[ 14 ];
	    m_aaElement[ 3 ][ 3 ] = From[ 15 ];

		
		this.m_fIdentity = false;
		return this;
	}
	

	
	/**
	 * tZZqB
	 * XJ|ꍇ̌vZB<br>
	 * XJƂ̏ŹA|ƃXJ{AE炾Scale\킷B
	 * 
	 * @param S	XJl
	 * @return	vZ
	 */
	public CqMatrix mulInv( float S )
	{
	    CqMatrix Temp = new CqMatrix( this );
	    Temp.m_aaElement[ 0 ][ 0 ] *= S;
	    Temp.m_aaElement[ 1 ][ 0 ] *= S;
	    Temp.m_aaElement[ 2 ][ 0 ] *= S;
	    Temp.m_aaElement[ 3 ][ 0 ] *= S;

	    Temp.m_aaElement[ 0 ][ 1 ] *= S;
	    Temp.m_aaElement[ 1 ][ 1 ] *= S;
	    Temp.m_aaElement[ 2 ][ 1 ] *= S;
	    Temp.m_aaElement[ 3 ][ 1 ] *= S;

	    Temp.m_aaElement[ 0 ][ 2 ] *= S;
	    Temp.m_aaElement[ 1 ][ 2 ] *= S;
	    Temp.m_aaElement[ 2 ][ 2 ] *= S;
	    Temp.m_aaElement[ 3 ][ 2 ] *= S;

	    Temp.m_aaElement[ 0 ][ 3 ] *= S;
	    Temp.m_aaElement[ 1 ][ 3 ] *= S;
	    Temp.m_aaElement[ 2 ][ 3 ] *= S;
	    Temp.m_aaElement[ 3 ][ 3 ] *= S;
	    return ( Temp );
	}

	/**
	 * Matrixm̔r<br>
	 * CqRendermemcmp̑ɎgpB<br>
	 * SĂ̗vftrue<br>
	 * ȊOłfalseԂB<br>
	 * 
	 * @param mtx@rMatrix
	 * @return@true:SĂ̗vf false:ȊO
	 */
	public boolean equals(CqMatrix mtx)
	{
		if(this.m_aaElement[0][0] != mtx.m_aaElement[0][0])return false;
		if(this.m_aaElement[0][1] != mtx.m_aaElement[0][1])return false;
		if(this.m_aaElement[0][2] != mtx.m_aaElement[0][2])return false;
		if(this.m_aaElement[0][3] != mtx.m_aaElement[0][3])return false;
		
		if(this.m_aaElement[1][0] != mtx.m_aaElement[1][0])return false;
		if(this.m_aaElement[1][1] != mtx.m_aaElement[1][1])return false;
		if(this.m_aaElement[1][2] != mtx.m_aaElement[1][2])return false;
		if(this.m_aaElement[1][3] != mtx.m_aaElement[1][3])return false;
		
		if(this.m_aaElement[2][0] != mtx.m_aaElement[2][0])return false;
		if(this.m_aaElement[2][1] != mtx.m_aaElement[2][1])return false;
		if(this.m_aaElement[2][2] != mtx.m_aaElement[2][2])return false;
		if(this.m_aaElement[2][3] != mtx.m_aaElement[2][3])return false;
		
		if(this.m_aaElement[3][0] != mtx.m_aaElement[3][0])return false;
		if(this.m_aaElement[3][1] != mtx.m_aaElement[3][1])return false;
		if(this.m_aaElement[3][2] != mtx.m_aaElement[3][2])return false;
		if(this.m_aaElement[3][3] != mtx.m_aaElement[3][3])return false;
		
		return true;
	}
	
// 2005.07.05 ͍s񎮌vZɂ̂ݗpĂ̂ō폜Bisawa
//
//	//************************************************************************//
//	//*** L֐ƂẴX^eBbN\bh
//	//************************************************************************//
//	
	public static float det2x2( float a, float b, float c, float d )
	{
		return a * d - b * c;
	}
	
	public static float det3x3( float a1, float a2, float a3,
			float b1, float b2, float b3,
			float c1, float c2, float c3 )
	{
		return a1 * det2x2( b2, b3, c2, c3 ) -
		b1 * det2x2( a2, a3, c2, c3 ) +
		c1 * det2x2( a2, a3, b2, b3 );
	}
	

}
