// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.types;

/**
 * 
 * CӒ̃rbgz񋟂NX
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqBitVector {
	
	
	private byte[]	m_aBits;			///< the array of bytes to store the byte vector.
	private int	m_cLength;			///< the size of the bitvector in bits.
	private int	m_cNumInts;			///< the size of the array in bytes.
	
	//}N
	private static final byte CHAR_BIT = 8;
	
	//gp̔z
	private static final int[] bitcount = new int[]
	{
		0, 1, 1, 2, 1, 2, 2, 3, 1, 
		2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 
		4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 
		3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 
		3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 
		4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 
		5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 
		2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 
		4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 
		4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 
		6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 
		4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 
		5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 
		6, 6, 7, 6, 7, 7, 8
	};
	
	/**
	 * ftHgRXgN^
	 */
	public CqBitVector()
	{
		m_aBits = null; m_cLength = 0; m_cNumInts = 0;
	}
	
	/**
	 * w肳ꂽrbgŏB
	 * @param size	rbg
	 */
	public CqBitVector( int size )
	{
		m_aBits = null; m_cLength = 0; m_cNumInts = 0;
		if ( size > 0 ) SetSize( size );
	}
	
	
	/**
	 * Rs[RXgN^BSvfRs[B
	 * @param from	Rs[
	 */
	public CqBitVector( final CqBitVector from )
	{
		this.assignment( from );
	}
	
	
	/**
	 * rbg擾
	 * 
	 * @return	݂̃rbg
	 */
	public int Size()
	{
		return ( m_cLength );
	}
	
	/**
	 * rbgݒ肷B
	 * 
	 * @param size	rbg
	 */
	public void SetSize( int size )
	{
		int cNumInts = NumberOfInts( size );
		if ( m_cNumInts != cNumInts )
		{
			m_aBits = null;
			m_cNumInts = NumberOfInts( size );
			m_aBits = new byte[ m_cNumInts ];
		}
		m_cLength = size;
	}
	
	/** 
	 * IɕW`֐`B<br>
	 * Ⴆ΁ASẴrbggpł΁AIȃoCgz͂OTCYƂȂB
	 * 
	 */
	public void Canonize()
	{
		( m_aBits ) [ m_cNumInts - 1 ] &= ( byte ) ~0 >>> ( CHAR_BIT - ( ( m_cLength % CHAR_BIT )!=0
				? ( m_cLength % CHAR_BIT )
				: CHAR_BIT ) )
				+ 24;// 24 = Integer.SIZE - Byte.SIZE
	}
	
	/**
	 * wʒũrbgݒ
	 * 
	 * @param elem	ݒ肷rbg̈ʒu
	 * @param value	ݒ肷rbgBtrue:1Afalse:0
	 */
	public void SetValue( int elem, boolean value )
	{
		assert( elem < m_cLength );
		if ( value )
			m_aBits[ elem / CHAR_BIT ] |= ( 1 << ( elem % CHAR_BIT ) );
		else
			m_aBits[ elem / CHAR_BIT ] &= ~( 1 << ( elem % CHAR_BIT ) );
	}
	
	/**
	 * wʒũrbg擾
	 * 
	 * @param elem	擾rbg̈ʒu
	 * @return	wʒũrbg
	 */
	public boolean Value( int elem )
	{
		assert( elem < m_cLength );
		return ( m_aBits[ elem / CHAR_BIT ] & ( 1 << ( elem % CHAR_BIT ) ) )!=0? true : false ;
	}
	
	/**
	 * wʒũrbg𔽓]
	 * 
	 * @param elem	]rbg̈ʒu
	 */
	public void Toggle( int elem )
	{
		assert( elem < m_cLength );
		m_aBits[ elem / CHAR_BIT ] ^= ( 1 << ( elem % CHAR_BIT ) );
	}
	
	/**
	 * SẴrbgݒ肷
	 * 
	 * @param value	ݒ肷rbgBtrue:1Afalse:0
	 */
	public void SetAll( boolean value )
	{
		byte setval = ( value ) ? (byte)~0 : (byte)0;
		int i;
		
		for ( i = 0; i < m_cNumInts; i++ )
			m_aBits[ i ] = setval;
		Canonize();
	}
	
	/**
	 * SẴrbg𔽓]
	 * 
	 */
	public void Complement()
	{
		int i;
		
		for ( i = 0; i < m_cNumInts; i++ )
			m_aBits[ i ] = (byte)~m_aBits[ i ];
		Canonize();
	}
	
	/**
	 * OÑrbgZo
	 * 
	 * @return	OÑrbg
	 */
	public int Count()
	{
	    int count;
	    int i;
	    
		for( count = 0, i = 0; i < m_cNumInts; i++ ){
			int index = m_aBits[i]>=0 ? m_aBits[i] : m_aBits[i]+256; 
			count += bitcount[ index ];
		}
		return ( count );
	}
	
	/**
	 * _ρB<br>
	 * ҂̃TCYقȂꍇǍvZʂ͕ۏ؂ȂB
	 * 
	 * @param from	ΏۂCqBitVector
	 * @return	vZʁithisj
	 */
	public CqBitVector	Intersect( CqBitVector from )
	{
	    int size = ( from.m_cLength < m_cLength ) ? from.m_cLength : m_cLength;
	    SetSize( size );
	    int numints = NumberOfInts( size );

	    int i;
	    for ( i = 0; i < numints; i++ )
	        m_aBits[ i ] = (byte)( m_aBits[ i ] & from.m_aBits[ i ] );

	    Canonize();

	    return ( this );
	}
	
	/**
	 * _aB<br>
	 * ҂̃TCYقȂꍇǍvZʂ͕ۏ؂ȂB
	 * 
	 * 
	 * @param from	ΏۂCqBitVector
	 * @return	vZʁithisj
	 */
	public CqBitVector	Union( CqBitVector from )
	{
	    int size = ( from.m_cLength > m_cLength ) ? from.m_cLength : m_cLength;
	    int ssize = ( from.m_cLength < m_cLength ) ? from.m_cLength : m_cLength;
	    SetSize( size );
	    int numints = NumberOfInts( ssize );

	    int i;
	    for ( i = 0; i < numints; i++ )
	        m_aBits[ i ] = (byte)( m_aBits[ i ] | from.m_aBits[ i ] );

	    Canonize();

	    return ( this );
	}
	
	/**
	 * rI_aB<br>
	 * ҂̃TCYقȂꍇǍvZʂ͕ۏ؂ȂB
	 * 
	 * @param from	ΏۂCqBitVector
	 * @return	vZʁithisj
	 */
	public CqBitVector Difference( CqBitVector from )
	{
	    int size = ( from.m_cLength > m_cLength ) ? from.m_cLength : m_cLength;
	    int ssize = ( from.m_cLength < m_cLength ) ? from.m_cLength : m_cLength;
	    SetSize( size );
	    int numints = NumberOfInts( ssize );

	    int i;
	    for ( i = 0; i < numints; i++ )
	        m_aBits[ i ] = (byte)( m_aBits[ i ] ^ from.m_aBits[ i ] );

	    Canonize();

	    return ( this );
	}
	
	/**
	 * oCgł̔zTCYԂ
	 * 
	 * @return	oCgōlꍇ̃oCgz
	 */
	public int ArraySize()
	{
		return( NumberOfInts(m_cLength) );
	}
	
	/**
	 * rbgz̎擾
	 * 
	 * @return	rbgz
	 */
	public byte[] IntArray()
	{
		return ( m_aBits );
	}
	
	/**
	 * wrbg\̂ɕKvȃoCgZoB
	 * 
	 * @param size	Kvȃrbg
	 * @return	KvȃoCg
	 */
	public static int NumberOfInts( int size )
	{
		return ( ( size + ( CHAR_BIT ) - 1 ) / ( CHAR_BIT ) );
	}
	
	//************************************************************************//
	//*** Zq̃I[o[[h
	//************************************************************************//
	
	/**
	 * Zq
	 * 
	 * @param from	ƂCqBitVector
	 * @return	Zʁithisj
	 */
	public CqBitVector assignment( final CqBitVector from )
	{
		// Copy the array of bits
		SetSize( from.m_cLength );
		for ( int i = 0; i < m_cNumInts; i++ )
			m_aBits[ i ] = from.m_aBits[ i ];
		
		return ( this );
	}
	
	/**
	 * _ωZq
	 * @see #Intersect(CqBitVector)
	 * 
	 * @param from	ZΏۂCqBitVector
	 * @return	Z
	 */
	public CqBitVector and( CqBitVector from )
	{
		CqBitVector res = new CqBitVector( this );
		res.Intersect( from );
		return ( res );
	}
	
	/**
	 * _aZq
	 * @see #Union(CqBitVector)
	 *  
	 * @param from	ZΏۂCqBitVector
	 * @return	Z
	 */
	public CqBitVector or( CqBitVector from )
	{
		CqBitVector res = new CqBitVector( this );
		res.Union( from );
		return ( res );
	}
	
	/**
	 * rI_aZq
	 * @see #Difference(CqBitVector)
	 * 
	 * @param from	ZΏۂCqBitVector
	 * @return	Z
	 */
	public CqBitVector xor( CqBitVector from )
	{
		CqBitVector res = new CqBitVector( this );
		res.Difference( from );
		return ( res );
	}
	
	/**
	 * _ϑ
	 * @see #Intersect(CqBitVector)
	 * 
	 * @param from	ZΏۂCqBitVector
	 * @return	Zʁithisj
	 */
	public CqBitVector assignAnd( CqBitVector from )
	{
		Intersect( from );
		return ( this );
	}
	
	/**
	 * _a
	 * @see #Union(CqBitVector)
	 * 
	 * @param from	ZΏۂCqBitVector
	 * @return	Zʁithisj
	 */
	public CqBitVector assignOr( CqBitVector from )
	{
		Union( from );
		return ( this );
	}
	
	/**
	 * rI_a
	 * @see #Difference(CqBitVector)
	 * 
	 * @param from	ZΏۂCqBitVector
	 * @return	Zʁithisj
	 */
	public CqBitVector assignXor( CqBitVector from )
	{
		Difference( from );
		return ( this );
	}
	

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		
		String Stream = "";

	    int numints = this.ArraySize();
	    if( numints == 0 ) return "0";
	    this.Canonize();

	    int i;
	    for ( i = 0; i < numints; i++ ){
			Stream += String.format( "%x" , IntArray()[i] );
	    }
	    
		return Stream;
	}
	
	
}
