// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

/**
 * 
 * _֘A̋ʊ֐Q
 * 
 * @author NTT DATA Corporation
 */

import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.exception.XqException;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;

public strictfp interface IqRenderer {
	
	public void destruct();
	
	
	// Handle various coordinate system transformation requirements.
	// R[fBl[gVXe̕ω̒lvnhB

    public CqMatrix		matSpaceToSpace ( final String strFrom, final String strTo, final CqMatrix matShaderToWorld, final CqMatrix matObjectToWorld, float time );
    public CqMatrix 	matVSpaceToSpace ( final String strFrom, final String strTo, final CqMatrix matShaderToWorld, final CqMatrix matObjectToWorld, float time );
    public CqMatrix 	matNSpaceToSpace ( final String strFrom, final String strTo, final CqMatrix matShaderToWorld, final CqMatrix matObjectToWorld, float time );

    public	float[]		GetFloatOption( final String strName, final String strParam );
    public	int[] 		GetIntegerOption( final String strName, final String strParam );
    public	String[]		GetStringOption( final String strName, final String strParam );
    public	CqVector3D[]	GetPointOption( final String strName, final String strParam );
    public	CqColor[] 	GetColorOption( final String strName, final String strParam );

    public	p_float[]		GetFloatOptionWrite( final String strName, final String strParam );
    public	p_int[]		GetIntegerOptionWrite( final String strName, final String strParam );
    public	p_String[]	GetStringOptionWrite( final String strName, final String strParam );
    public	CqVector3D[]	GetPointOptionWrite( final String strName, final String strParam );
    public	CqColor[]		GetColorOptionWrite( final String strName, final String strParam );

    /** Get the global statistics class.
     * @ÓIO[oNX擾B
     * \return A reference to the CqStats class on this renderer.<br>
     * @CqStats@NX̃_[QƂB
     */ 
    //		virtual	CqStats&	Stats() = 0;
    /** Print a message to stdout, along with any relevant message codes.
     *  ֘ÃbZ[WR[hƈꏏɁAWo͂̃bZ[W\B
     * \param str A SqMessage structure to print.
     * @@SqMessage\B
     */
   	public	void	PrintString( final String str );

    /*
     *  Access to the texture map handling component
     *  eNX`}bvɃANZXnhR|[lg
     */

    /** Get a pointer to a loaded texturemap ready for processing.
     * @|C^̏łAǂݍ܂ꂽeNX`}bv擾ĂB
     */
    public	IqTextureMap 	GetTextureMap( final String strFileName );
    public	IqTextureMap 	GetEnvironmentMap( final String strName );
    public	IqTextureMap	GetShadowMap( final String strName );
    public	IqTextureMap 	GetLatLongMap( final String strName );


    public	boolean			GetBasisMatrix( CqMatrix matBasis, final String name );

    public 	int		RegisterOutputData( final String name ) throws XqException;
    public 	int		OutputDataIndex( final String name );
    public 	int		OutputDataSamples( final String name );
    public 	int		OutputDataType( final String name );

    public	void	SetCurrentFrame( int FrameNo );
    public	int		CurrentFrame();

    public	CqObjectInstance	pCurrentObject();

    public	float	Time();

    public	int		bucketCount();
}
