// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

/**
 * 
 * 
 * 
 * @author NTT DATA Corporation
 */
public strictfp class EqEnvVars {
	public static final int EnvVars_Cs = 0;   		///< Surface color.
	public static final int EnvVars_Os = 1;   		///< Surface opacity.
	public static final int EnvVars_Ng = 2;    		///< Geometric normal.
	public static final int EnvVars_du = 3;   		///< First derivative in u.
	public static final int EnvVars_dv = 4;   		///< First derivative in v.
	public static final int EnvVars_L = 5;   		///< Incoming light direction.
	public static final int EnvVars_Cl = 6;			///< Light color.
	public static final int EnvVars_Ol = 7;			///< Light opacity.
	public static final int EnvVars_P = 8;   		///< Point being shaded.
	public static final int EnvVars_dPdu = 9;   	///< Change in P with respect to change in u.
	public static final int EnvVars_dPdv = 10;   	///< Change in P with respect to change in v.
	public static final int EnvVars_N = 11;   		///< Surface normal.
	public static final int EnvVars_u = 12;   		///< Surface u coordinate.
	public static final int EnvVars_v = 13;   		///< Surface v coordinate.
	public static final int EnvVars_s = 14;   		///< Texture s coordinate.
	public static final int EnvVars_t = 15;   		///< Texture t coordinate.
	public static final int EnvVars_I = 16;   		///< Incident ray direction.
	public static final int EnvVars_Ci = 17;   		///< Incident color.
	public static final int EnvVars_Oi = 18;   		///< Incident opacity.
	public static final int EnvVars_Ps = 19;   		///< Point being lit.
	public static final int EnvVars_E = 20;   		///< Viewpoint position.
	public static final int EnvVars_ncomps = 21;   	///< Number of color components.
	public static final int EnvVars_time = 22;   	///< Frame time.
	public static final int EnvVars_alpha = 23;   	///< Fractional pixel coverage.

	public static final int EnvVars_Ns = 24;   		///< Normal at point being lit.

	public static final int EnvVars_Last = 25;
    
    private int value = 0;

    public EqEnvVars()
    {
    	value = 0;
    }
    public EqEnvVars(int val)
    {
    	value = val;
    }
    
	public int getValue()
	{
		return value;
	}
	public void setValue(int val)
	{
		value = val;
	}
}
