// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;

/**
 * 
 * Container surface to store the polygons making up a RiPointsPolygons surface.
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqSurfaceSubdivisionMesh extends CqSurface {

	private int			m_NumFaces;
	private CqSubdivision2	m_pTopology;		///< Pointer to the associated CqPolygonPoints class.
	
    public CqSurfaceSubdivisionMesh( final CqSubdivision2 pTopology, int NumFaces)
    {
        m_NumFaces	= NumFaces;
        m_pTopology	= pTopology;
    }
    
    /** 
     * Get the gemoetric bound of this GPrim.
     */
    public	CqBound	Bound()
    {
        CqBound B = new CqBound();
        if( m_pTopology!=null && m_pTopology.pPoints()!=null && m_pTopology.pPoints().P()!=null )
        {
            int PointIndex;
            for( PointIndex = m_pTopology.pPoints().P().Size()-1; PointIndex >= 0; PointIndex-- )
                B.Encapsulate( new CqVector3D( (CqVector4D)m_pTopology.pPoints().P().pValue_get( 0 ,PointIndex ) ) );
        }
        return( AdjustBoundForTransformationMotion( B ) );
    }
    
    /** 
     * Dice this GPrim.
     * @return A pointer to a new micropolygrid..
     */
    @Override
    public	CqMicroPolyGridBase Dice()
    {
        return null;
    }
    
    /** 
     * Split this GPrim into a number of other GPrims.
     * @param aSplits A reference to a CqBasicSurface array to fill in with the new GPrim pointers.
     * @return Integer count of new GPrims created.
     */
    @Override
    public int Split( STLVector<CqBasicSurface> aSplits )
    {
        int CreatedPolys = 0;
        int face;

        for ( face = 0; face < m_NumFaces; face++ )
        {
            // Don't add faces which are on the boundary, unless "interpolateboundary" is specified.
            if( ( !m_pTopology.pFacet( face ).isBoundaryFacet() ) || ( m_pTopology.isInterpolateBoundary() ) )
            {
                // Don't add "hole" faces
                if( !m_pTopology.isHoleFace( face ) )
                {
                    // Add a patch surface to the bucket queue
    				CqSurfaceSubdivisionPatch pNew = new CqSurfaceSubdivisionPatch( m_pTopology, m_pTopology.pFacet( face ), face );
                    aSplits.add( pNew );
                    CreatedPolys++;
                }
            }
        }
        return( CreatedPolys );

    }
    
    /** 
     * Determine whether this GPrim is diceable at its current size.
     */
    @Override
    public boolean Diceable()
    {
        return( false );
    }

    @Override
    public void Transform(CqMatrix matTx, CqMatrix matITTx, CqMatrix matRTx, int iTime)
    {
        assert( m_pTopology!=null );
        m_pTopology.pPoints().Transform( matTx, matITTx, matRTx, iTime );
    }

    public boolean IsMotionBlurMatch( CqBasicSurface pSurf )
    {
        return( false );
    }

    public	int	cUniform()
    {
        return ( m_NumFaces );
    }
    public	int	cVarying()
    {
        assert( m_pTopology!=null );
        assert( m_pTopology.pPoints()!=null );
        return ( m_pTopology.pPoints().cVarying() );
    }
    public	int	cVertex()
    {
        assert( m_pTopology!=null );
        assert( m_pTopology.pPoints()!=null );
        return ( m_pTopology.pPoints().cVertex() );
    }
    public	int	cFaceVarying()
    {
        assert( m_pTopology!=null );
        assert( m_pTopology.pPoints()!=null );
        return ( m_pTopology.pPoints().cFaceVarying() );
    }

	
}
