// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import java.util.Iterator;

import net.cellcomputing.himawari.accessory.STLArray;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;

/**
 * l̃^CvƁAid̃^CvŃev[gꂽA̔z̃p[^^CvB
 * @author NTT DATA Corporation
 */
public strictfp class CqParameterTypedUniformArray<T,SLT> extends CqParameterTyped<T,SLT> {
	private EqVariableType I;	//Generic I
	//private STLVector<T> m_aValues;
	private STLArray<T> m_aValues;
	
	/**
	 * RXgN^
	 * 
	 * @param name O
	 * @param count z
	 * @param I GenericsI
	 * @param TClass Generics TŎw肳Class
	 * @param SLTClass Generics SLTŎw肳Class
	 */
	public CqParameterTypedUniformArray(final String name,int count,EqVariableType I,Class<? extends T> TClass,Class<? extends SLT> SLTClass){
		super(name,count,TClass,SLTClass);
		
		//m_aValues = new STLVector<T>(TClass,count);
		m_aValues = new STLArray<T>(TClass,count);
		//nttdata 
		//m_aValues.setSize(count);
		
		this.I = I;
	}
	/**
	 * RXgN^
	 * 
	 * @param name O
	 * @param I GenericsI
	 * @param TClass Generics TŎw肳Class
	 * @param SLTClass Generics SLTŎw肳Class
	 */
	public CqParameterTypedUniformArray(final String name,EqVariableType I,Class<? extends T> TClass,Class<? extends SLT> SLTClass){
		this(name,1,I,TClass,SLTClass);
	}
	/**
	 * fXgN^
	 */
	public void destruct(){
		super.destruct();
	}
	/**
	 * Rs[RXgN^
	 * @param From Rs[CX^X
	 * @param I Generics I
	 */
	public CqParameterTypedUniformArray(CqParameterTypedUniformArray<T,SLT> From,EqVariableType I){
		super(From);
		//m_aValues = new STLVector<T>(TClass);
		m_aValues = new STLArray<T>(TClass);
		m_aValues.setSize(From.Count());
		this.I = I;
		if(TClass.equals(CqVector3D.class)){
			for(int i=0; i < From.m_Count ; i++)
				((CqVector3D)m_aValues.elementAt(i)).assignment((CqVector3D)From.m_aValues.elementAt(i));
			
		}else if(TClass.equals(CqVector4D.class)){
			for(int i=0; i < From.m_Count ; i++)
				((CqVector4D)m_aValues.elementAt(i)).assignment((CqVector4D)From.m_aValues.elementAt(i));
		}else if(TClass.equals(CqColor.class)){
			for(int i=0; i < From.m_Count ; i++)
				((CqColor)m_aValues.elementAt(i)).assignment((CqColor)From.m_aValues.elementAt(i));
		}else if(TClass.equals(CqMatrix.class)){
			for(int i=0; i < From.m_Count ; i++)
				((CqMatrix)m_aValues.elementAt(i)).assignment((CqMatrix)From.m_aValues.elementAt(i));
		}else if(TClass.equals(p_float.class)){
			for(int i=0; i < From.m_Count ; i++)
				((p_float)m_aValues.elementAt(i)).value = ((p_float)From.m_aValues.elementAt(i)).value;
		}else if(TClass.equals(p_int.class)){
			for(int i=0; i < From.m_Count ; i++)
				((p_int)m_aValues.elementAt(i)).value = ((p_int)From.m_aValues.elementAt(i)).value;
		}else if(TClass.equals(p_String.class)){
			for(int i=0; i < From.m_Count ; i++)
				((p_String)m_aValues.elementAt(i)).value = ((p_String)From.m_aValues.elementAt(i)).value;
		}
	}
	
	/**
	 * ̎Vector̒lzƂđSĕԂB
	 * @return Vector̒l͂Ăz
	 */
	public Object[] pValue() {
        assert( 0 < m_aValues.size() );

		return m_aValues.toArray();
	}

	/**
	 * ̎Vector̒lzƂđSĕԂB
	 * 
	 * @param Index gpȂ 
	 * @return Vector̒l͂Ăz
	 */
	public Object[] pValue(int Index) {
        assert( 0 < m_aValues.size() );

		return m_aValues.toArray();
	}

//	public STLVector<T> pValue_get() {
//        assert( 0 < m_aValues.size() );
//
//		return m_aValues;
//	}

	public T pValue_get(final int Index ,final int arrayIndex)
	{
		return m_aValues.elementAt(arrayIndex);
	}
	/**
	 * Type̓N[𐶐ĕԂ
	 * 
	 * @param Name O
	 * @param Count ̎Vector̒
	 * @return VCqParameter
	 */
	public CqParameter CloneType(final String Name, int Count) {
        return ( new CqParameterTypedUniformArray<T, SLT>( Name, Count, I,TClass,SLTClass ) );
	}
	
	/**
	 * gƓlCX^X𐶐B
	 */
	public CqParameter Clone() {
        return ( new CqParameterTypedUniformArray<T, SLT>(this,I) );
	}
	
	/**
	 * EqVariableClassԂ
	 *
	 * @return EqVariableClass
	 */
	public EqVariableClass Class() {
		return new EqVariableClass(EqVariableClass.class_uniform);
	}
	
	/**
	 * ̂EqVariableTypeԂ
	 * (C++łGenericsŗpĂ)
	 * @return EqVariableType
	 */
	public EqVariableType Type() {
		return I;
	}

	/**
	 * 󃁃\bh 
	 */
	public void SetSize(int size) {
		//󃁃\bh
		//m_aValuessetSizeĂяoKv͂Ȃ̂낤H
	}
	/**
	 * 1Ԃ֐
	 * 
	 */
	public int Size() {
		return 1;
	}

	/**
	 * 󃁃\bh 
	 */
	public void Clear() {
		//󃁃\bh
	}

	/**
	 * 󃁃\bh 
	 */
	public void Subdivide(CqParameter pResult1, CqParameter pResult2, boolean u,
			IqSurface pSurface) {
		//󃁃\bh
	}
	
	/**
	 * IqShaderDataɒl<br>
	 * (eNXł̐)<br>
	 * z̒P̗vfl̃NX̓K؂ȕ⊮păObhɐ؂o(Dice)
	 * 
	 * @param u
	 * @param v
	 * @param pResult 
	 * @param pSurface gpȂ
	 */	
	public void Dice(int u, int v, IqShaderData pResult, IqSurface pSurface) {
//		 Just promote the constant value to varying by duplication.
		assert( pResult.Type().getValue() == Type().getValue() );
        // Note it is assumed that the variable has been
        // initialised to the correct size prior to calling.
        int i;
        long max = Math.max( (long)(u * v), pResult.Size() );
        
        //Genericsɓ^ɂďꍇ킯s
        if(TClass.equals(CqMatrix.class)){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( (CqMatrix)pValue_get( 0 , 0 ), i );
            }
        }else if(TClass.equals(CqVector3D.class)){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( (CqVector3D)pValue_get( 0 , 0 ), i );
            }
        }else if(TClass.equals(CqVector4D.class)){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue(new CqVector3D(((CqVector4D)( pValue_get( 0 , 0 )))), i );
            }
        }else if(TClass.equals(CqColor.class)){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( (CqColor) pValue_get( 0 , 0 ), i );
            }
        }else if(TClass.equals(p_float.class)){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( ((p_float) pValue_get( 0 , 0 )).value, i );
            }
        }else if(TClass.equals(p_int.class)){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( ((p_int)pValue_get( 0 , 0 )).value, i );
            }
        }else if(TClass.equals(p_String.class)){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( ((p_String)pValue_get( 0 , 0 )).value, i );
            }
        }
	}
	/**
	 * IqShaderDataɎVectorArrayIndexŎw肳ꂽꏊ̒lB
	 * Max(u*v,pResult.size())IqShaderDataɃRs[
	 * <br>
	 * (eNXł̐)<br>
	 * z̒P̗vfl̃NX̓K؂ȕ⊮păObhɐ؂o(Dice)
	 * 
	 * @param u
	 * @param v
	 * @param pResult 
	 * @param pSurface gpȂ
	 * @param ArrayIndex w肷ꏊ
	 */	
	public void DiceOne(int u, int v, IqShaderData pResult, IqSurface pSurface,
			int ArrayIndex) {
//		 Just promote the constant value to varying by duplication.
		assert( Count() > ArrayIndex );
		assert( pResult.Type().getValue() == Type().getValue() );
        // Note it is assumed that the variable has been
        // initialised to the correct size prior to calling.
        int i;
        long max = Math.max( (long)(u * v), pResult.Size() );
        
        //Genericsɓ^ɂďꍇ킯s
        if(TClass.equals(CqMatrix.class)){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( (CqMatrix)pValue_get( 0 , ArrayIndex ), i );
            }
        }else if(TClass.equals(CqVector3D.class)){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( (CqVector3D) pValue_get( 0 , ArrayIndex ), i );
            }
        }else if(TClass.equals(CqVector4D.class)){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue(new CqVector3D(((CqVector4D)( pValue_get( 0 , ArrayIndex )))), i );
            }
        }else if(TClass.equals(CqColor.class)){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( (CqColor) pValue_get( 0 , ArrayIndex ), i );
            }
        }else if(TClass.equals(p_float.class)){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( ((p_float) pValue_get( 0 , ArrayIndex )).value, i );
            }
        }else if(TClass.equals(p_int.class)){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( ((p_int) pValue_get( 0 , ArrayIndex )).value, i );
            }
        }else if(TClass.equals(p_String.class)){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( ((p_String) pValue_get( 0 , ArrayIndex )).value, i );
            }
        }

	}
	/**
	 * CqParameterTypedŒ`Ă
	 * Ŏw肵CX^XVectorAw肵l
	 * gVector̎w肵ʒuɃRs[s
	 * 
	 * @param pFrom Rs[CX^X
	 * @param idxTarget Rs[̔zԍB
	 * @param idxSource Rs[̔zԍ
	 */
	public void SetValue(CqParameter pFrom, int idxTarget, int idxSource){
		assert( pFrom.Type().getValue() == Type().getValue() );
		
        CqParameterTyped<T, SLT> pFromTyped = (CqParameterTyped<T, SLT>)( pFrom );
        T tmp = (T)pValue_get( idxTarget , 0 );//|C^Ȃ̂Œlo
        if(tmp instanceof CqMatrix){
        	((CqMatrix)tmp).assignment((CqMatrix)(pFromTyped.pValue_get( idxSource , 0 )));
        }else if(tmp instanceof CqVector3D){
        	((CqVector3D)tmp).assignment((CqVector3D)(pFromTyped.pValue_get( idxSource , 0 )));
        }else if(tmp instanceof CqVector4D){
        	((CqVector4D)tmp).assignment((CqVector4D)(pFromTyped.pValue_get( idxSource , 0 )));
        }else if(tmp instanceof CqColor){
        	((CqColor)tmp).assignment((CqColor)(pFromTyped.pValue_get( idxSource , 0 )));
        }else if(tmp instanceof p_float){
        	((p_float)tmp).value = ((p_float)(pFromTyped.pValue_get( idxSource , 0 ))).value;
        }else if(tmp instanceof p_int){
        	((p_int)tmp).value = ((p_int)(pFromTyped.pValue_get( idxSource , 0 ))).value;
        }else if(tmp instanceof p_String){
        	((p_String)tmp).value = ((p_String)(pFromTyped.pValue_get( idxSource , 0 ))).value;
        }
	}
	
	/**
	 * CR[Zq
	 * Vector̒lSĎgVectorɃRs[
	 * 
	 * @param From CX^X
	 * @return g
	 */
//    public CqParameterTypedUniformArray<T,SLT> assignment(final CqParameterTypedUniformArray<T,SLT> From )
//    {
//        m_aValues.resize( From.m_aValues.size() );
//        int i2 = 0;
//        Iterator<T> i = From.m_aValues.iterator();
//        if(TClass.equals(CqMatrix.class)){
//        	while(i.hasNext()){
//        		((CqMatrix)m_aValues.elementAt(i2)).assignment((CqMatrix)i.next());
//        		i2++;
//        	}
//        }else if(TClass.equals(CqVector3D.class)){
//        	while(i.hasNext()){
//        		((CqVector3D)m_aValues.elementAt(i2)).assignment((CqVector3D)i.next());
//        		i2++;
//        	}
//        }else if(TClass.equals(CqVector4D.class)){
//        	while(i.hasNext()){
//        		((CqVector4D)m_aValues.elementAt(i2)).assignment((CqVector4D)i.next());
//        		i2++;
//        	}
//        }else if(TClass.equals(CqColor.class)){
//        	while(i.hasNext()){
//        		((CqColor)m_aValues.elementAt(i2)).assignment((CqColor)i.next());
//        		i2++;
//        	}
//        }else if(TClass.equals(p_int.class)){
//        	while(i.hasNext()){
//        		((p_int)m_aValues.elementAt(i2)).value = ((p_int)i.next()).value;
//        		i2++;
//        	}
//        }else if(TClass.equals(p_float.class)){
//        	while(i.hasNext()){
//        		((p_float)m_aValues.elementAt(i2)).value = ((p_float)i.next()).value;
//        		i2++;
//        	}
//        }else if(TClass.equals(p_String.class)){
//        	while(i.hasNext()){
//        		((p_String)m_aValues.elementAt(i2)).value = ((p_String)i.next()).value;
//        		i2++;
//        	}
//        }
//        return ( this );
//    }
	public CqParameterTypedUniformArray<T,SLT> assignment(final CqParameterTypedUniformArray<T,SLT> From )
    {
		int fromsize = From.m_aValues.size() ;
        m_aValues.resize( fromsize );
        int i = 0;
        if(TClass.equals(CqVector3D.class)){
        	for(i=0; i < fromsize ; i++){
        		((CqVector3D)m_aValues.elementAt(i)).assignment((CqVector3D)From.m_aValues.elementAt(i));
        	}
        }else if(TClass.equals(CqVector4D.class)){
        	for(i=0; i < fromsize ; i++){
        		((CqVector4D)m_aValues.elementAt(i)).assignment((CqVector4D)From.m_aValues.elementAt(i));
        	}
        }else if(TClass.equals(CqColor.class)){
        	for(i=0; i < fromsize ; i++){
        		((CqColor)m_aValues.elementAt(i)).assignment((CqColor)From.m_aValues.elementAt(i));
        	}
        }else if(TClass.equals(p_int.class)){
        	for(i=0; i < fromsize ; i++){
        		((p_int)m_aValues.elementAt(i)).value = ((p_int)From.m_aValues.elementAt(i)).value;
        	}
        }else if(TClass.equals(p_float.class)){
        	for(i=0; i < fromsize ; i++){
        		((p_float)m_aValues.elementAt(i)).value = ((p_float)From.m_aValues.elementAt(i)).value;
        	}
        }else if(TClass.equals(p_String.class)){
        	for(i=0; i < fromsize ; i++){
        		((p_String)m_aValues.elementAt(i)).value = ((p_String)From.m_aValues.elementAt(i)).value;
        	}
        }
        else if(TClass.equals(CqMatrix.class)){
        	for(i=0; i < fromsize ; i++){
        		((CqMatrix)m_aValues.elementAt(i)).assignment((CqMatrix)From.m_aValues.elementAt(i));
        	}
        }
        return ( this );
    }
    /* Static constructor, to allow type free parameter construction.
     * \param strName Character pointer to new parameter name.
     * \param Count Integer array size.
     */
    /**
	 * static RXgN^
	 * RXgN^Ɠlɗpł
	 */
     public static	<T,SLT> CqParameter	Create( final String strName, int Count,EqVariableType I,Class<? extends T> TClass,Class<? extends SLT> SLTClass)
    {
        return ( new CqParameterTypedUniformArray<T,SLT>( strName, Count ,I,TClass,SLTClass) );
    }
 	
     /**
 	 * static RXgN^
 	 * RXgN^Ɠlɗpł(countȗn)
 	 */
     
     public static	<T,SLT> CqParameter	Create( final String strName,EqVariableType I,Class<? extends T> TClass,Class<? extends SLT> SLTClass)
     {
    	 return CqParameterTypedUniformArray.<T,SLT>Create(strName,1,I,TClass,SLTClass);
     }
}
