// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import static net.cellcomputing.himawari.library.EqCSGNodeType.CSGNodeType_Primitive;

import java.util.ArrayList;

import net.cellcomputing.himawari.accessory.STLVector;

/**
 * 
 * @Primitive CSG node.
 *  Does very little, primitive is basically a grouping node. 
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqCSGNodePrimitive extends CqCSGTreeNode {

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.CqCSGTreeNode#lChildren()
	 */
	public ArrayList<CqCSGTreeNode> lChildren()
	{
		assert false; 
		return ( m_lDefPrimChildren );
	}
	
	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.CqCSGTreeNode#AddChild(net.cellcomputing.himawari.library.CqCSGTreeNode)
	 */
	public void	AddChild( final CqCSGTreeNode pChild )
	{
		assert false;
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.CqCSGTreeNode#NodeType()
	 */
	@Override
	public EqCSGNodeType NodeType() {
	
		EqCSGNodeType type = new EqCSGNodeType();
		type.setValue( CSGNodeType_Primitive );
		return type;
	
	}

    /* (non-Javadoc)
     * @see net.cellcomputing.himawari.library.CqCSGTreeNode#ProcessSampleList(java.util.Vector)
     */
    public void	ProcessSampleList( STLVector<SqImageSample> samples )
    {
    	// Now go through samples, clearing samples related to this node.
        for ( SqImageSample i : samples )
        {
            if ( i.m_pCSGNode == this )
            {
                i.m_pCSGNode = null;
            }
        }
    }

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.CqCSGTreeNode#EvaluateState(java.util.Vector)
	 */
	@Override
	public boolean EvaluateState( boolean[] abChildStates) {
	
		return true;
	}
	
	/**
	 * v~eBum[h̎qm[h̃Xg<br>
	 * (ۂ̃v~eBum[h͎qȂ߁ÃXg͏ɋłB)
	 */
	private static ArrayList<CqCSGTreeNode>	m_lDefPrimChildren = new ArrayList<CqCSGTreeNode>();	
	//v~eBu͎qƂłȂ߁AqXgvꂽƂp̋󃊃XgB
	// Static empty child list, as primitives cannot have children nodes.
	
}
