/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.display;

import java.awt.image.BufferedImage;

import javax.swing.ImageIcon;

import net.cellcomputing.himawari.util.HimawariLogger;

/**
 * @author NTT DATA Corporation
 * _Oʂ\閽߂NXB
 * _OĂ摜\WindowB
 * 
 * openRequestŏsA
 * display()ɂWindowɍĕ`施߂oB
 * 
 * 
 */
public strictfp class FrameBufferRequest extends DisplayRequest {
	/**
	 * _O摜\Window
	 */
	private FrameBuffer frameBuffer;

	/**
	 * RXgN^
	 * @param name O
	 * @param type fBXvC^Cv(FrameBuffer)
	 * @param mode J[[h
	 * @param modeID
	 * @param dataOffset
	 * @param dataSize
	 * @param imageData 摜f[^ǗNX
	 */
	public FrameBufferRequest(String name, final String type,final String mode,
			int modeID, int dataOffset, int dataSize ,ImageData imageData){
		super(name,type,mode,modeID,dataOffset,dataSize,imageData);

	}

	/**
	 * DisplayBucketĂяoOɕKĂ΂郁\bhB
	 * Window쐬A\B
	 */
	public void openRequest() {
		Object image = imageData.getImage();
		
		if(!(image instanceof BufferedImage)){
			//Errors
			HimawariLogger.getLogger().error("Can't open framebuffer");
			
		}
		frameBuffer = new FrameBuffer((BufferedImage)imageData.getImage(),name);
		frameBuffer.init();
		frameBuffer.setVisible(true);
		//icon
		ImageIcon Icon;
        String file = "himawarilogo.png";
        if( getClass().getResource("/"+file)!= null ){
            Icon = new ImageIcon(getClass().getResource("/"+file)) ;
        }
        else{
        	Icon =  new ImageIcon(file);
        }
		frameBuffer.setIconImage(Icon.getImage());
	}
	
	/**
	 * ĕ`̖߂windowɑ΂sB
	 */
	public void display() {
		frameBuffer.repaint();

	}

	/**
	 * Ȃ
	 */
	public void closeRequest() {
		imageData = null;
		frameBuffer = null;
	}

}
