/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.display;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

import javax.swing.JPanel;

/**
 * @author NTT DATA Corporation
 * Image\邽߂PanelB
 * `lw肳ĂImageꍇ
 * `FbNwiɕ`悳B
 */
public strictfp class FrameBufferPanel extends JPanel {
	
	private static final long serialVersionUID = -983819772199207027L;
	
	private BufferedImage image;								//\Image
	private BufferedImage checkImage;							//`FbNimage
	
	private Rectangle2D.Double image_size;						//imagẽTCY
	private TexturePaint checkPaint;							//`FbNTexture
	
	private static int CHECK_SIZE = 32;						//`FbÑTCY
	private static  int CHECK_HALF_SIZE = CHECK_SIZE / 2 ;	//`FbN̔̃TCY
	
//	private static AffineTransform trans;						//{ϊ̂߂
	
	/**
	 * RXgN^
	 * \摜ɂƂ
	 * 
	 * @param image \摜
	 */
	public FrameBufferPanel(BufferedImage image){
		this.image = image;
		setSize(image.getWidth(),image.getHeight());
		setPreferredSize(new Dimension(image.getWidth(),image.getHeight()));

		//`lw肳Ă̂ł΃`FbJ[쐬
		createCheckerImage(image);
		
		//{w邽߂̃CX^X
//		trans = new AffineTransform();
		
		//--}EX
		//------eXg
//		addMouseListener(new MouseAdapter() {
//            public void mousePressed(MouseEvent e) {
//            	if(SwingUtilities.isRightMouseButton(e))
//                	ZoomIn();
//            	else
//            		ZoomOut();
//            }
//		});
	}

//
//	/**
//	 * {0.2グ
//	 *
//	 */
//	public void ZoomIn(){
//		trans.setToScale(trans.getScaleX()+0.2,trans.getScaleX()+0.2);
////		setSize(new Dimension((int)(image.getWidth()*trans.getScaleX()),(int)(image.getHeight()*trans.getScaleY())));
//		repaint();
//	}
//	/**
//	 * {0.2
//	 *
//	 */
//	public void ZoomOut(){
//		trans.setToScale(trans.getScaleX()-0.2,trans.getScaleX()-0.2);
////		setSize(new Dimension((int)(image.getWidth()*trans.getScaleX()),(int)(image.getHeight()*trans.getScaleY())));
//		repaint();
//	}
	
	/**
	 * `FbJ[̃C[W쐬
	 * @param image
	 */
	private void createCheckerImage(BufferedImage image) {
		if(image.getType() == BufferedImage.TYPE_INT_ARGB){
			checkImage = new BufferedImage(CHECK_SIZE,CHECK_SIZE,BufferedImage.TYPE_INT_ARGB);
			Graphics g = checkImage.getGraphics();
			g.setColor(Color.WHITE);
			g.fillRect(CHECK_HALF_SIZE,CHECK_HALF_SIZE,CHECK_HALF_SIZE,CHECK_HALF_SIZE);
			g.fillRect(0,0,CHECK_HALF_SIZE,CHECK_HALF_SIZE);
			g.setColor(Color.GRAY);
			g.fillRect(CHECK_HALF_SIZE,0,CHECK_HALF_SIZE,CHECK_HALF_SIZE);
			g.fillRect(0,CHECK_HALF_SIZE,CHECK_HALF_SIZE,CHECK_HALF_SIZE);
			
			checkPaint = new TexturePaint(checkImage,new Rectangle2D.Double(0,0,CHECK_SIZE,CHECK_SIZE));
			image_size = new Rectangle2D.Double(0,0,image.getWidth(),image.getHeight());
		}
	}
	
	/**
	 * ʂtbVꂽƂ
	 * `s\bhB
	 * 
	 * @param g
	 */
	protected void paintComponent(Graphics g) {
		super.paintComponent(g);
//		((Graphics2D)g).setTransform(trans);
		//`lĂĂȂ΁Acheck͗l
		if(image.getType() == BufferedImage.TYPE_INT_ARGB){
			paintCheckMark(g);
		}
		
		g.drawImage(image,0,0,this);
	}
	
	/**
	 * ʂimagẽTCY
	 * `FbNœhԂB
	 * @param g
	 */
	private void paintCheckMark(Graphics g){
		((Graphics2D)g).setPaint(checkPaint);
		((Graphics2D)g).fill(image_size);
	}
}
