/* Simple argument-parsing class
 * Copyright (C) 2001 Patrick E. Pelletier <ppelleti@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.argparse;

import net.cellcomputing.himawari.accessory.primitive.p_String;

/**
 * IvV̏ڍ׃p[^(String^)̐ݒsNXB
 * @author NTT DATA Corporation
 */
strictfp class StringHandler extends OptionHandler 
{
	/**
	 * IvV̎gp
	 */
	public boolean already_used;
	/**
	 * IvV̏ڍ׃p[^
	 */
	public p_String value;

	/**
	 * RXgN^
	 * @param usage_in	p@bZ[W
	 * @param value_in	IvV̏ڍ׃p[^
	 */
	public StringHandler(String usage_in, p_String value_in)
	{
		super(usage_in); 
		already_used = false;
		value = value_in;
	}
	
	/**
	 * p[^̉͂Zbg(͂̏Ԃɖ߂)
	 * @see net.cellcomputing.himawari.argparse.OptionHandler#reset()
	 */
	public void reset()
	{
		already_used = false;
	}
	
	/**
	 * IvV̗L𔻒f
	 * ̓IvV̗L𔻒fbZ[WԂB
	 * @return	"option specified more than once"
	 * @return	""
	 * @see net.cellcomputing.himawari.argparse.OptionHandler#handlearg(java.lang.String)
	 */
	public String handlearg(String arg)
	{
//		łɓ͂ĂIvVǂ𔻒
		if (already_used) {
	        return "option specified more than once";
	    }
	    already_used = true;
	    value.value = arg;
	    return "";
	}
	    
}
