/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

/**
 *@LogǗNX
 *@LoggerSingletonNX
 *
 *  getLoggerpHimawariLogger擾B
 *  o͂xsetLogLevelŐݒs
 * @author NTT DATA Corporation
 */
public class HimawariLogger {
	/**
	 * DEBUGx
	 */
	public static final String LEVEL_DEBUG = "DEBUG";
	/**
	 * INFOx
	 */
	public static final String LEVEL_INFO = "INFO";
	/**
	 * WARNINGx
	 */
	public static final String LEVEL_WARNING = "WARNING";
	/**
	 * CRITICALx
	 */
	public static final String LEVEL_CRITICAL = "CRITICAL";
	/**
	 * ERRORx
	 */
	public static final String LEVEL_ERROR = "ERROR";
	/**
	 * logger̖O
	 */
	private static final String LOGGER_NAME = "net.cellcomputing.himawari";
	private Logger logger;
	private ConsoleHandler handler;
	private static HimawariLogger logInstance;
	
	/**
	 * StackTraceۑt@C
	 */
	private static final String LOG_FILE_NAME = "stacktrace.log";
	private static final DateFormat df = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.MEDIUM);
	

	/**
	 * G[bZ[WŎgp镶萔
	 */
	private final String REPEATED_MESSAGE = " Last message repeated ";
	private final String REPEATED_TIMES = " time";
	private final String DEFALUT_MESSAGE = "";
	
	
	/**
	 * OɎw肳ꂽbZ[W
	 */
	private String lastMessage = DEFALUT_MESSAGE;

	
	/**
	 * dbZ[W̉
	 */
	private int	count = 0;
	
	/**
	 * OɎw肳ꂽOx
	 */
	private Level lastLevel = Level.OFF;
	
	/**
	 * Op̎tH[}bg
	 */
	private Date date;

	
	/**
	 * RXgN^
	 * Logger̐ݒ
	 */
	private HimawariLogger(){
		if(logger == null){
			LogManager.getLogManager().reset();
			logger = Logger.getLogger(LOGGER_NAME);
		
			handler = new ConsoleHandler();
			handler.setFormatter(new HimawariLogFormatter());
			
			logger.addHandler(handler);
			
		}
		
	}
	
	/**
	 * O擾郌xݒ肷
	 * 
	 * @param level ݒ肷郌x
	 */
	public void setLogLevel(Level level){
		logger.setLevel(level);
		handler.setLevel(level);
	}
	
	public void setLogLevel(String level){
		//ɉăÕxݒ肷
		
		if(level.equals(LEVEL_CRITICAL)){
			logger.setLevel(Level.SEVERE);
			handler.setLevel(Level.SEVERE);
		}else if(level.equals(LEVEL_ERROR)){
			logger.setLevel(Level.WARNING);
			handler.setLevel(Level.WARNING);
		}else if(level.equals(LEVEL_WARNING)){
			logger.setLevel(Level.INFO);
			handler.setLevel(Level.INFO);
		}else if(level.equals(LEVEL_INFO)){
			logger.setLevel(Level.CONFIG);
			handler.setLevel(Level.CONFIG);
		}else if(level.equals(LEVEL_DEBUG)){
			logger.setLevel(Level.FINE);
			handler.setLevel(Level.FINE);
		}
	}
	
	/**
	 * OxԂ
	 * @return Ox
	 */
	public Level getLevel(){
		return logger.getLevel();
	}
	/**
	 * OǗLoggerԂ
	 * 
	 * @return logger
	 */
	public static HimawariLogger getLogger(){
		
		if(logInstance == null){
			logInstance =new HimawariLogger();
		}
		
		return logInstance;
	}
	
	/**
	 * bZ[WJԂLoggerɓnĂ邩ǂ𔻒肷B
	 * ÕbZ[WLevelbZ[WłtrueԂA
	 * count1₷B
	 * falseł΁AflushLoggerĂяo
	 * lastMessageLevelŎw肳ꂽ̂ɕύXA
	 * count0ɖ߂B
	 * 
	 * @param str ObZ[W
	 * @param level Õx
	 * @return ÕbZ[WłALevelłtrue,ȊOfalse
	 */
	private boolean checkRepeatedMessage(String str,Level level){
		if(lastLevel.equals(level)){
			if(str.equals(lastMessage)){
				count++;
				return true;
			}			
		}
		//flushB

		flushLogger();
		lastMessage = str;
		count = 0;
		lastLevel = level;
		
		return false;
	}
	
	/**
	 * Aqsisinfox̕o͂
	 * 
	 * @param str bZ[W
	 */
	public void info(String str){
		//dłȂꍇlogflushĕ\
		if(!checkRepeatedMessage(str,Level.CONFIG))
			logger.config(str);
	}
	/**
	 * Aqsiscriticalx̕o͂
	 * 
	 * @param str bZ[W
	 */
	
	public void critical(String str){
		//dłȂꍇlogflushĕ\
		if(!checkRepeatedMessage(str,Level.SEVERE))
			logger.severe(str);
	}
	/**
	 * AqsisERRORx̕o͂
	 * 
	 * @param str bZ[W
	 */
	public void error(String str){
		//dłȂꍇlogflushĕ\
		if(!checkRepeatedMessage(str,Level.WARNING))
			logger.warning(str);
	}
	/**
	 * AqsisWARNINGx̕o͂
	 * 
	 * @param str bZ[W
	 */
	public void warning(String str){
		//dłȂꍇlogflushĕ\
		if(!checkRepeatedMessage(str,Level.INFO))
			logger.info(str);
	}
	/**
	 * AqsisDEBUGx̕o͂
	 * 
	 * @param str bZ[W
	 */
	public void debug(String str){
		//dłȂꍇlogflushĕ\
		if(!checkRepeatedMessage(str,Level.FINE))
			logger.fine(str);
	}
	
	
	private static File logFile;
	
	/**
	 * 
	 * ExceptionStackTracet@CɋL^B
	 * 
	 * @param e	X[ꂽException
	 */
	public static void outputException( Exception e ){
		
		//t@CI[v
		if( logFile == null ){
			logFile = new File( LOG_FILE_NAME );
			logFile.delete();
		}
		
		//C^[쐬
		PrintWriter writer;
		try {
			writer = new PrintWriter( new FileWriter(logFile,true) );
		} catch (IOException e1) {
			logInstance = getLogger();
			logInstance.error("log file open error. file is " +LOG_FILE_NAME+ "\n");
			return;
		}
		
		// for DEBUG
//		writer = new PrintWriter( System.err );
		
//		//to
//		Date date = new Date();
//		writer.println( df.format(date) + " Threw Exceptiln is..." );
//		e.printStackTrace( writer );
//		
//		Throwable cause = e.getCause();
//		if( cause!=null ){
//			writer.print( "Caused by: " );
//			cause.printStackTrace( writer );
//		}
//		writer.close();
		
		//StackTrace̓e擾
		StackTraceElement[] elements = e.getStackTrace();
		
		//G[bZ[W̍쐬
		Date date = new Date();
		writer.println( df.format(date) + " Threw Exceptiln is..." );
		
		writer.println( e );
		for( StackTraceElement ele : elements ){
			writer.print( "\tat " );
			writer.println( ele );
		}
		
		Throwable cause = e.getCause();
		if( cause!=null ){
			writer.print("Caused by: ");
			cause.printStackTrace( writer );
		}
		
		//t@CN[Y
		writer.close();
		
	}
	
	/**
	 * bZ[WflushAo͂B
	 */
	public void flushLogger(){
		if(count > 0){
			date = new Date();
			StringBuffer mes = new StringBuffer();
			mes.append(df.format(date));
			mes.append(REPEATED_MESSAGE);
			mes.append(count);
			mes.append(REPEATED_TIMES);

			if(count > 1){
				mes.append("s");
			}
			if(logger.isLoggable(lastLevel))
				System.err.println(mes.toString());
			
			lastMessage = DEFALUT_MESSAGE;
			count = 0;
			lastLevel = Level.OFF;
		}
	}
}
