// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.shadervm;

import static net.cellcomputing.himawari.library.EqIntIndex.*;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_boolean;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.IqShaderData;

/**
 * CqShaderUniformpFloatNX
 * @author NTT DATA Corporation
 */
public strictfp class CqShaderVariableUniformFloat extends CqShaderVariableUniform<p_float> {
	/**
	 * RXgN^
	 *
	 */
	public CqShaderVariableUniformFloat( )
	{
		super(new EqVariableType(EqVariableType.type_float));
		m_Value = new p_float();
		CqStats.STATS_INC( SHD_var_uniform_float );
		
	}
	/**
	 * RXgN^
	 * 
	 * @param strName
	 * @param fParameter
	 */
	public CqShaderVariableUniformFloat( final String strName, boolean fParameter)
	{
		super( strName, fParameter,new EqVariableType(EqVariableType.type_float));
		m_Value = new p_float();
		CqStats.STATS_INC( SHD_var_uniform_float );
	}
	
	/**
	 * Rs[RXgN^
	 * @param val
	 */
	public CqShaderVariableUniformFloat(CqShaderVariableUniformFloat val){
		super(val,new EqVariableType(EqVariableType.type_float));
	}
	
	/**
	 * RXgN^
	 * @param strName
	 */
	public CqShaderVariableUniformFloat(final String strName){
		this(strName,false);
	}
	/**
	 * ɁA̎lRs[
	 * @param res Rs[
	 * @param index gpȂ
	 */
	public void GetFloat(p_float res, int index)
	{
		res.value = m_Value.value;
	}
	
	/**
	 * Ɏ̎l̃|C^}
	 * \bȟĂяoŒlύXꍇA
	 * g̒le󂯂B
	 * 
	 * @param res |C^i[vector
	 */
	public	void GetFloatPtr( final STLVector<p_float> res )
	{
		if(res.size() < 1)
			res.add(m_Value);
		else
			res.setElementAt(m_Value,0);
	}
	
	/**
	 * ̎lɈ̒lRs[
	 * 
	 * @param f Rs[l
	 */
	public void	SetFloat( final float f )
	{
		m_Value.value = f;
	}
	
	/**
	 * booleanlB
	 * l0łtrue
	 * l1łfalse
	 * B
	 * 
	 * @param res ʂ
	 * @param index gpȂ
	 */
	public void	GetBool( p_boolean res, int index)
	{
		res.value = m_Value.value != 0.0f;
	}
	
	/**
	 * ɂAg̎lύXB
	 * trueł΂P
	 * falseł0
	 * 
	 * 
	 * @param val 
	 */
	public void	SetBool( final boolean val )
	{
		
//		m_Value.value = val.value;
		if(val){
			m_Value.value = 1.0f;//true
		}else{
			m_Value.value =0;
		}
	}
	/**
	 * ɂAg̎lύXB
	 * trueł΂P
	 * falseł0
	 * 
	 * 
	 * @param val
	 * @param index gpȂ
	 */
	public void	SetBool( final boolean val, int index )
	{
//		m_Value.value = val.value;
		if(val){
			m_Value.value = 1.0f;//true
		}else{
			m_Value.value =0;
		}
	}
	/** 
	 * Copy the values from the passed variable into this, taking into account any class differences.
	 *
	 * ŗ^ꂽCX^X̎m_Value̒lgɃRs[B
	 * GetFloatĂяoƂŎĂB
	 * @param pVal Rs[̕ϐ / The variable to copy from.
	 */
	public void	SetValueFromVariable( final IqShaderData pVal )
	{
		pVal.GetFloat( m_Value );
	}
	
	/**
	 * g̃Rs[Ԃ
	 * @return ƓlIqShaderData
	 */
	public IqShaderData Clone()
	{
		CqShaderVariableUniformFloat newVar = new CqShaderVariableUniformFloat( this );
		newVar.SetSize( (int)Size() );
		newVar.SetValueFromVariable( this );
		return ( newVar );
	}
	
}
