// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.shadervm;

import net.cellcomputing.himawari.accessory.primitive.p_boolean;
import net.cellcomputing.himawari.library.EqVariableClass;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.IqShaderData;

/**
 * 
 * 
 * 
 * @author NTT DATA Corporation
 */
public strictfp interface CqShaderStack {
	
	public IqShaderData GetNextTemp( EqVariableType type, EqVariableClass _class );
	
//	----------------------------------------------------------------------
    /** Push a new shader variable reference onto the stack.
     */
	public void Push( IqShaderData pv );
	
	 //----------------------------------------------------------------------
    /** Push a new shader variable reference onto the stack.
     */
    public void	PushV( IqShaderData pv );
    
//  ----------------------------------------------------------------------
    /** Pop the top stack entry.
     * \param f Boolean value to update if this is varying. If not varying, leaves f unaltered.
     * \return Reference to the top stack entry.
     */
    public SqStackEntry Pop( p_boolean f );

    public void Release( SqStackEntry s );

    //----------------------------------------------------------------------
    /** Duplicate the top stack entry.
     */
    public void	Dup();
    
    /** Drop the top stack entry.
     */
    public void	Drop();
    
    /**
     * Print the max number of depth if compiled for it.
     */
    //public static void Statistics();
    
    /** set the more efficient number of samples per type of variable at run-time.
     */
    //public static void	SetSamples(int n);
    
    
}
