/*
 KeywordMakeTexture.java
 Copyright (C) 2003 Gerardo Horvilleur Martinez

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.parser.keywords;

import java.lang.reflect.Method;
import net.cellcomputing.himawari.library.RendermanInterface;
import net.cellcomputing.himawari.parser.Global;
import net.cellcomputing.himawari.parser.Tokenizer;

public strictfp class KeywordMakeTexture extends AbstractKeywordParser {

    public void parse(Tokenizer st) throws Exception {
        // Expect picture name
        match(st, TK_STRING);
        String picturename = st.sval;
        
        // Expect texturename
        match(st, TK_STRING);
        String texturename = st.sval;
        
        // Expect s wrap
        match(st, TK_STRING);
        String swrap = st.sval;
        
        // Expect t wrap
        match(st, TK_STRING);
        String twrap = st.sval;
        
        // Expect filter
        match(st, TK_STRING);
        String filtername = Global.GetFilterFunction( st.sval );
        Method filterfunc = RendermanInterface.class.getMethod( filtername, float.class, float.class, float.class, float.class);
        
        // Expect s width
        match(st, TK_NUMBER);
        int swidth = (int) st.nval;
        
        // Expect t width
        match(st, TK_NUMBER);
        int twidth = (int) st.nval;
       
		// Expect parameter list
		parseParameterList(st);
        
        RendermanInterface.RiMakeTextureV( picturename, texturename, swrap, twrap, filterfunc, swidth, twidth, count(), tokens(), values() );
        //parser.makeTexture(picturename, texturename, swrap, twrap, filter, swidth, twidth);
    }

}
