// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.cache;

import net.cellcomputing.himawari.library.RendermanInterface;

/**
 * 
 * RiTrimCurvẽLbV
 * 
 * @author NTT DATA Corporation
 */
public strictfp class RiTrimCurveCache extends RiCacheBase {
	
	public RiTrimCurveCache(int nloops, int[] ncurves, int[] order, float[] knot, float[] min, float[] max, int[] n, float[] u, float[] v, float[] w)
	{
		m_nloops = nloops;
		int __ncurves_length = nloops;
		m_ncurves = new int[__ncurves_length];
		int __ncurves_index;
		for(__ncurves_index = 0; __ncurves_index<__ncurves_length; __ncurves_index++)
		{
			m_ncurves[__ncurves_index] = ncurves[__ncurves_index];
		}
		int __order_length = 0;
		{
			int __i;
			for(__i=0; __i<nloops; __i++)
				__order_length+=ncurves[__i];
		}
		m_order = new int[__order_length];
		int __order_index;
		for(__order_index = 0; __order_index<__order_length; __order_index++)
		{
			m_order[__order_index] = order[__order_index];
		}
		int __knot_length = 0;
		{
			int __i;
			for(__i=0; __i<__order_length; __i++)
				__knot_length+=order[__i]+n[__i];
		}
		m_knot = new float[__knot_length];
		int __knot_index;
		for(__knot_index = 0; __knot_index<__knot_length; __knot_index++)
		{
			m_knot[__knot_index] = knot[__knot_index];
		}
		int __min_length = __order_length;
		m_min = new float[__min_length];
		int __min_index;
		for(__min_index = 0; __min_index<__min_length; __min_index++)
		{
			m_min[__min_index] = min[__min_index];
		}
		int __max_length = __order_length;
		m_max = new float[__max_length];
		int __max_index;
		for(__max_index = 0; __max_index<__max_length; __max_index++)
		{
			m_max[__max_index] = max[__max_index];
		}
		int __n_length = __order_length;
		m_n = new int[__n_length];
		int __n_index;
		for(__n_index = 0; __n_index<__n_length; __n_index++)
		{
			m_n[__n_index] = n[__n_index];
		}
		int __u_length = 0;
		{
			int __i;
			for(__i=0; __i<__order_length; __i++)
				__u_length+=n[__i];
		}
		m_u = new float[__u_length];
		int __u_index;
		for(__u_index = 0; __u_index<__u_length; __u_index++)
		{
			m_u[__u_index] = u[__u_index];
		}
		int __v_length = __u_length;
		m_v = new float[__v_length];
		int __v_index;
		for(__v_index = 0; __v_index<__v_length; __v_index++)
		{
			m_v[__v_index] = v[__v_index];
		}
		int __w_length = __u_length;
		m_w = new float[__w_length];
		int __w_index;
		for(__w_index = 0; __w_index<__w_length; __w_index++)
		{
			m_w[__w_index] = w[__w_index];
		}
	}
	
	@Override
	public void destruct()
	{
		super.destruct();
//		delete[](m_ncurves);
//		delete[](m_order);
//		delete[](m_knot);
//		delete[](m_min);
//		delete[](m_max);
//		delete[](m_n);
//		delete[](m_u);
//		delete[](m_v);
//		delete[](m_w);
	}
	
	@Override
	public void ReCall()
	{
		RendermanInterface.RiTrimCurve(m_nloops, m_ncurves, m_order, m_knot, m_min, m_max, m_n, m_u, m_v, m_w);
	}
	
	private int		m_nloops;
	private int[]		m_ncurves;
	private int[]		m_order;
	private float[]	m_knot;
	private float[]	m_min;
	private float[]	m_max;
	private int[]		m_n;
	private float[]	m_u;
	private float[]	m_v;
	private float[]	m_w;
	
}
