// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.cache;

import net.cellcomputing.himawari.library.RendermanInterface;

/**
 * 
 * RiPatchṼLbV
 * 
 * @author NTT DATA Corporation
 */
public strictfp class RiPatchCache extends RiCacheBase {
	
	public RiPatchCache(String type, int count, String[] tokens, Object[] values)
	{
//		int __type_length = strlen(type);
//		m_type = new char[ __type_length + 1 ];
//		strcpy(m_type, type);
		m_type = new String( type );
		// Copy the plist here.
		int constant_size = 1;
		int uniform_size = 1;
		int varying_size = 1;
		int vertex_size = 1;
		int facevarying_size = 1;
		varying_size = 4;
		vertex_size = 4;
//		if(strcmp(type, "bicubic")==0)
		if( type.compareTo("bicubic") == 0 )
			vertex_size=16;
		facevarying_size = varying_size;
		CachePlist(count, tokens, values, constant_size, uniform_size, varying_size, vertex_size, facevarying_size);
	}
	
	@Override
	public void destruct()
	{
		super.destruct();
//		delete[](m_type);
		// plist gets destroyed by the base class.
	}
	
	@Override
	public void ReCall()
	{
		RendermanInterface.RiPatchV(m_type, m_count, m_tokens, m_values);
	}
	
	private String m_type;
	// plist information is stored in the base class.
	
}
