// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.cache;

import java.lang.reflect.Method;

import net.cellcomputing.himawari.library.RendermanInterface;

/**
 * 
 * RiMakeCubeFaceEnvironmentṼLbV
 * 
 * @author NTT DATA Corporation
 */
public strictfp class RiMakeCubeFaceEnvironmentCache extends RiCacheBase {
	
	public RiMakeCubeFaceEnvironmentCache(String px, String nx, String py, String ny, String pz, String nz, String reflfile, float fov, Method filterfunc, float swidth, float twidth, int count, String[] tokens, Object[] values)
	{
//		int __px_length = strlen(px);
//		m_px = new char[ __px_length + 1 ];
//		strcpy(m_px, px);
		m_px = new String( px );
//		int __nx_length = strlen(nx);
//		m_nx = new char[ __nx_length + 1 ];
//		strcpy(m_nx, nx);
		m_nx = new String( nx );
//		int __py_length = strlen(py);
//		m_py = new char[ __py_length + 1 ];
//		strcpy(m_py, py);
		m_py = new String( py );
//		int __ny_length = strlen(ny);
//		m_ny = new char[ __ny_length + 1 ];
//		strcpy(m_ny, ny);
		m_ny = new String( ny );
//		int __pz_length = strlen(pz);
//		m_pz = new char[ __pz_length + 1 ];
//		strcpy(m_pz, pz);
		m_pz = new String( pz );
//		int __nz_length = strlen(nz);
//		m_nz = new char[ __nz_length + 1 ];
//		strcpy(m_nz, nz);
		m_nz = new String( nz );
//		int __reflfile_length = strlen(reflfile);
//		m_reflfile = new char[ __reflfile_length + 1 ];
//		strcpy(m_reflfile, reflfile);
		m_reflfile = new String( reflfile );
		m_fov = fov;
		m_filterfunc = filterfunc;
		m_swidth = swidth;
		m_twidth = twidth;
		// Copy the plist here.
		int constant_size = 1;
		int uniform_size = 1;
		int varying_size = 1;
		int vertex_size = 1;
		int facevarying_size = 1;
		CachePlist(count, tokens, values, constant_size, uniform_size, varying_size, vertex_size, facevarying_size);
	}
	
	@Override
	public void destruct()
	{
		super.destruct();
//		delete[](m_px);
//		delete[](m_nx);
//		delete[](m_py);
//		delete[](m_ny);
//		delete[](m_pz);
//		delete[](m_nz);
//		delete[](m_reflfile);
		// plist gets destroyed by the base class.
	}
	
	@Override
	public void ReCall()
	{
		RendermanInterface.RiMakeCubeFaceEnvironmentV(m_px, m_nx, m_py, m_ny, m_pz, m_nz, m_reflfile, m_fov, m_filterfunc, m_swidth, m_twidth, m_count, m_tokens, m_values);
	}
	
	private String m_px;
	private String m_nx;
	private String m_py;
	private String m_ny;
	private String m_pz;
	private String m_nz;
	private String m_reflfile;
	private float m_fov;
	private Method m_filterfunc;
	private float m_swidth;
	private float m_twidth;
	// plist information is stored in the base class.
	
}
