// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLArray;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_boolean;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;

/**
 * Interface to the shader engine specific implementation of a shader variable.
 * 
 * VF[_̉σ^CvʎqB
 * ^CvʎqƖOXgOe[ułւ̂ǂȕωfȂ΂Ȃ܂B
 * 
 * @author NTT DATA Corporation
 */

public abstract strictfp class IqShaderData {

	/**
	 * fXgN^
	 *
	 */
	abstract public void destruct();
	//--nttdata ǉ 2005/09/12
	/**
	 * ShaderĂl̐擪|C^擾B
	 * JavałSTLVector̒ɒlB
	 * 
	 * @param vector ShaderĂlVector
	 */
	public final void  GetValuePtr(STLVector vector){
		
		assert (vector != null);
		Object obj = null;
		
		try{
			obj = vector.elementAt(0);
		}catch(ArrayIndexOutOfBoundsException ae){
			if(vector.size() < 1 )
				vector.setSize(1);
			obj = vector.elementAt(0);
		}
		if(obj instanceof p_float){
			GetFloatPtr(vector);
		}else if(obj instanceof p_String){
			GetStringPtr(vector);
		}else if(obj instanceof CqMatrix){
			GetMatrixPtr(vector);
		}else if(obj instanceof CqVector3D){
			GetPointPtr(vector);
		}else if(obj instanceof CqColor){
			GetColorPtr(vector);
		}else if(obj instanceof p_boolean){
			GetBoolPtr(vector);
		}
		
	}
	
	//public final STLVector GetValuePtr_2(Object obj){
	public final STLArray GetValuePtr_2(Object obj){	
		if(obj instanceof p_float){
			return GetFloatPtr_2();
		}else if(obj instanceof CqVector3D){
			return GetPointPtr_2();
		}else if(obj instanceof CqColor){
			return GetColorPtr_2();
		}else if(obj instanceof p_boolean){
			return GetBoolPtr_2();
		}else if(obj instanceof p_String){
			return GetStringPtr_2();
		}else if(obj instanceof CqMatrix){
			return GetMatrixPtr_2();
		} 
		return null;
	}
	
	//
	
	abstract public void GetBoolPtr(STLVector<p_boolean> vector);
	abstract public void GetPointPtr(STLVector<CqVector3D> vector);
	abstract public void GetNormalPtr(STLVector<CqVector3D> vector);
	abstract public void GetVectorPtr(STLVector<CqVector3D> vector);
	abstract public void GetColorPtr(STLVector<CqColor> vector);
	abstract public void GetMatrixPtr(STLVector<CqMatrix> vector);
	abstract public void GetStringPtr(STLVector<p_String> vector);
	abstract public void GetFloatPtr(STLVector<p_float> vector);

	//nttdata
//	public STLVector<p_boolean> GetBoolPtr_2(){return null;};
//	public STLVector<CqVector3D> GetPointPtr_2(){return null;};
//	public STLVector<CqVector3D> GetNormalPtr_2(){return null;};
//	public STLVector<CqVector3D> GetVectorPtr_2(){return null;};
//	public STLVector<CqColor> GetColorPtr_2(){return null;};
//	public STLVector<CqMatrix> GetMatrixPtr_2(){return null;};
//	public STLVector<p_String> GetStringPtr_2(){return null;};
//	public STLVector<p_float> GetFloatPtr_2(){return null;};
	public STLArray<p_boolean> GetBoolPtr_2(){return null;};
	public STLArray<CqVector3D> GetPointPtr_2(){return null;};
	public STLArray<CqVector3D> GetNormalPtr_2(){return null;};
	public STLArray<CqVector3D> GetVectorPtr_2(){return null;};
	public STLArray<CqColor> GetColorPtr_2(){return null;};
	public STLArray<CqMatrix> GetMatrixPtr_2(){return null;};
	public STLArray<p_String> GetStringPtr_2(){return null;};
	public STLArray<p_float> GetFloatPtr_2(){return null;};

	//--܂
	
	///	Get the data as a float..
	abstract public void GetFloat( p_float res, int index );
	final public void GetFloat( p_float res ){
		GetFloat( res, 0 );
	}
	
    ///	Get the data as a boolean value..
	abstract public void GetBool( p_boolean res, int index );
	final public void GetBool( p_boolean res ){
		GetBool( res, 0 );
	}
	///	Get the data as a string..
	abstract public void GetString( p_String res, int index );
	final public void GetString( p_String res ){
		GetString( res, 0 );
	}
	///	Get the data as a point..
	abstract public void GetPoint( CqVector3D res, int index );
	final public void GetPoint( CqVector3D res ){
		GetPoint( res, 0 );
	}
	///	Get the data as a vector..
	abstract public void GetVector( CqVector3D res, int index );
	final public void GetVector( CqVector3D res ){
		GetVector( res, 0 );
	}
	///	Get the data as a normal..
	abstract public void GetNormal( CqVector3D res, int index );
	final public void GetNormal( CqVector3D res ){
		GetVector( res, 0 );
	}
	///	Get the data as a color..
	abstract public void GetColor( CqColor res, int index );
	final public void GetColor( CqColor res ){
		GetColor( res, 0 );
	}
	///	Get the data as a matrix..
	abstract public void GetMatrix( CqMatrix res, int index );
	final public void GetMatrix( CqMatrix res ){
		GetMatrix( res, 0 );
	}



    ///	Set the value to the specified float.
	abstract public void SetFloat( final float val );
    ///	Set the value to the specified boolean value.
	abstract public void SetBool( final boolean val );
    ///	Set the value to the specified string.
	abstract public void SetString( final String val );
    ///	Set the value to the specified point.
	abstract public void SetPoint( final CqVector3D val );
    ///	Set the value to the specified vector.
	abstract public void SetVector( final CqVector3D val );
    ///	Set the value to the specified normal.
	abstract public void SetNormal( final CqVector3D val );
    ///	Set the value to the specified color.
	abstract public void SetColor( final CqColor val );
    ///	Set the value to the specified matrix.
	abstract public void SetMatrix( final CqMatrix val );

    ///	Set the value to the specified float.
	abstract public void SetFloat( final float val, int index );
    ///	Set the value to the specified boolean value.
	abstract public void SetBool( final boolean val, int index );
    ///	Set the value to the specified string.
	abstract public void SetString( final String val, int index );
    ///	Set the value to the specified point.
	abstract public void SetPoint( final CqVector3D val, int index );
    ///	Set the value to the specified vector.
	abstract public void SetVector( final CqVector3D val, int index );
    ///	Set the value to the specified normal.
	abstract public void SetNormal( final CqVector3D val, int index );
    ///	Set the value to the specified color.
	abstract public void SetColor( final CqColor val, int index );
    ///	Set the value to the specified matrix.
	abstract public void SetMatrix( final CqMatrix val, int index );


    public void GetValue( p_float f, int index )
    {
        GetFloat( f, index );
    }
    final public void GetValue( p_float f )
    {
        GetFloat( f, 0 );
    }
    
    public void GetValue( p_boolean b, int index )
    {
        GetBool( b, index );
    }
    final public void GetValue( p_boolean b )
    {
        GetBool( b, 0 );
    }
    
    public void GetValue( p_String s, int index )
    {
        GetString( s, index );
    }
    final public void GetValue( p_String s )
    {
        GetString( s, 0 );
    }
    
    public void GetValue( CqVector3D p, int index )
    {
        GetPoint( p, index );
    }
    final public void GetValue( CqVector3D p )
    {
        GetPoint( p, 0 );
    }
    
    public void GetValue( CqColor c, int index )
    {
        GetColor( c, index );
    }
    final public void GetValue( CqColor c )
    {
        GetColor( c, 0 );
    }
    
    public void GetValue( CqMatrix m, int index )
    {
        GetMatrix( m, index );
    }
    final public void GetValue( CqMatrix m )
    {
        GetMatrix( m, 0 );
    }
    public void GetValue( Object obj, int index, Class cls ){
    
    	if ( cls == p_float.class ){
    		GetValue( (p_float)obj, index );
		}else if( cls == p_String.class ){
			GetValue( (p_String)obj, index );
		}else if( cls == CqMatrix.class ){
			GetValue( (CqMatrix)obj, index );
		}else if( cls == CqVector3D.class ){
			GetValue( (CqVector3D)obj, index );
		}else if( cls == CqColor.class ){
			GetValue( (CqColor)obj, index );
		}else if( cls == p_boolean.class ){
			GetValue( (p_boolean)obj, index );
		}
    	
    }
    final public void GetValue( Object obj, Class cls )
    {
    	GetValue( obj, 0, cls );
    }

    public void SetValue( final float f )
    {
        SetFloat( f );
    }
    public void SetValue( final int i )
    {
        SetFloat( (float)( i ) );
    }
    public void SetValue( final boolean b )
    {
        SetBool( b );
    }
    public void SetValue( final String s )
    {
        SetString( s );
    }
    public void SetValue( final CqVector3D p )
    {
        SetPoint( p );
    }
    public void SetValue( final CqColor c )
    {
        SetColor( c );
    }
    public void SetValue( final CqMatrix m )
    {
        SetMatrix( m );
    }

    public void SetValue( final float f, int index )
    {
        SetFloat( f, index );
    }
    public void SetValue( final int i , int index )
    {
        SetFloat( (float)( i ), index );
    }
    public void SetValue( final boolean b, int index )
    {
        SetBool( b, index );
    }
    public void SetValue( final String s, int index )
    {
        SetString( s, index );
    }
    public void SetValue( final CqVector3D p, int index )
    {
        SetPoint( p, index );
    }
    public void SetValue( final CqColor c, int index )
    {
        SetColor( c, index );
    }
    public void SetValue( final CqMatrix m, int index )
    {
        SetMatrix( m, index );
    }
    public void SetValue( Object obj, int index, Class cls ){
        
    	if ( cls == p_float.class ){
    		SetValue( ((p_float)obj).value, index );
		}else if( cls == p_String.class ){
			SetValue( ((p_String)obj).value, index );
		}else if( cls == CqMatrix.class ){
			SetValue( (CqMatrix)obj, index );
		}else if( cls == CqVector3D.class ){
			SetValue( (CqVector3D)obj, index );
		}else if( cls == CqColor.class ){
			SetValue( (CqColor)obj, index );
		}else if( cls == p_boolean.class ){
			SetValue( ((p_boolean)obj).value, index );
		}
		else if( cls == CqVector4D.class ){
			SetValue( new CqVector3D((CqVector4D)obj), index );
		}
    	
    }
    final public void SetValue( Object obj, Class cls )
    {
    	SetValue( obj, 0, cls );
    }

    /** Get the name of this variable.
     * @return Read only reference to a String class.
     */
    abstract public	String	strName();
    /** Determine whether this data storage represents a shader argument.
     * @return Read only reference to a String class.
     */
    abstract public	boolean	fParameter();

    /** Pure public, prepare the variable for the SIMD size.
     * @param uGridRes The size of the SIMD grid in u.
     * @param vGridRes The size of the SIMD grid in v.
     */
    abstract public	void	Initialise( final int uGridRes, final int vGridRes );
    /** Create a duplicate of this variable.
     * @return A IqShaderData pointer.
     */
    abstract public	IqShaderData Clone();

    /** Set the all SIMD data ased on a state vector, only indexes whose bit is set are modified.
     * @param pVal The stack entry to assign.
     * @param index Integer SIMD index.
     */
    abstract public	void	SetValueFromVariable( final IqShaderData pVal, int index );
    /** Copy the values from the passed variable into this, taking into account any class differences.
     * @param pVal The variable to copy from.
     */
    abstract public	void	SetValueFromVariable( final IqShaderData pVal );
    /** Get an indexed SIMD data value.
     */
    abstract public	EqVariableClass	Class();
    /** Get the variable type.
     * @return Type as a member of EqVariableType.
     */
    abstract  public	EqVariableType	Type();
    /** Get the SIMD size of this variable.
     * @return Integer SIMD data size.
     */
    abstract public long	Size();
    /** Set the SIMD size of this variable.
     * @param size Integer SIMD data size.
     */
    abstract public void	SetSize( final int size );
    /** Get the length of the variable array.
     * @return Integer array length.
     */
    abstract public int	ArrayLength();
    /** Get the i'th entry of the variable array.
     * @return Pointer to an object implementing IqShaderData.
     */
    abstract public IqShaderData ArrayEntry( int i );
    
}
