// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

/**
 * 
 * Key class for keeping track of shaders.
 * VF[_̃L[v邽߂̃L[NXB
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqShaderKey {
  
	/**
	 * RXgN^
	 * @param strName VF[_̖O
	 * @param type@VF[_̃^Cv
	 */
	public CqShaderKey( String strName, EqShaderType type )
	{
		strName = strName.concat( String.valueOf( type.getValue() ) );
		m_type = type ;
		m_name = strName.hashCode();
	}

	public long getkey()
	{
		return m_name;
	}
	
	/**
	 *@Rs[RXgN^
	 *@@param other Rs[RXgN^
	 */
	public CqShaderKey( final CqShaderKey other )
	{
		m_name = other.m_name;
		m_type = other.m_type;	
	}
	

	/**
	 * Zqu=v ̃I[o[[hB
	 * SvfRs[B
	 * @param other@CqShaderKeyIuWFNg
	 * @return this CqShaderKeyIuWFNg
	 */
	public CqShaderKey assignment( final CqShaderKey other )
	{
		m_name = other.m_name;
		m_type = other.m_type;
		return this; 
	}
	
	/**
	 * Zqu==v ̃I[o[[hB
	 * SvfƂtrueԂB
	 * @param other@rCqShaderKeyIuWFNg
	 * @return true / false
	 */
	public boolean equals( final CqShaderKey other )
	{
		return (
				( m_name == other.m_name ) &&
				( m_type.getValue() == other.m_type.getValue() )
		);
	}
	
	/**
	 * Zqu<v ̃I[o[[h
	 * rvfꍇtrueԂB
	 * @param other rCqShaderKeyIuWFNg
	 * @return true / false
	 */
	public boolean lt( final CqShaderKey other )
	{
		if ( m_name < other.m_name )		
			return true;
		else if ( m_name > other.m_name )
			return false;
		else
			return m_type.getValue() < other.m_type.getValue();
	}
		
	private long m_name; 			// Name of the shader.
	private EqShaderType m_type;	// Type of the shader.

}
