// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import static net.cellcomputing.himawari.library.CqStats.STATS_INC;
import static net.cellcomputing.himawari.library.EqIntIndex.GEO_prc_created;
import static net.cellcomputing.himawari.library.EqIntIndex.GEO_prc_split;
import static net.cellcomputing.himawari.library.RiGlobal.QGetRenderContext;

import java.lang.reflect.Method;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.util.HimawariLogger;

/**
 * 
 * Abstract base class for all Procedural objects, providing the basic state
 * management.
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqProcedural extends CqSurface {
	
	/* Contexy saved when the Procedural was declared */
	private CqModeBlock m_pconStored;
	
	/* The RIB request data */
	private Object[] m_pData;
	private Method m_pSubdivFunc;
	private Method m_pFreeFunc;
	
	
	/**
	 * CqProcedural constructor.
	 */
	public CqProcedural()
	{
		super();
	    STATS_INC( GEO_prc_created );
	}
	
	/**
	 * CqProcedural copy constructor.
	 */
	public CqProcedural(Object[] data, CqBound B, Method subfunc, Method freefunc )
	{
		super();
	    m_pData = data;
	    m_Bound = B;
	    m_pSubdivFunc = subfunc;
	    m_pFreeFunc = freefunc;

	    m_pconStored = QGetRenderContext().pconCurrent();

	    STATS_INC( GEO_prc_created );
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#finalize()
	 */
	@Override
	protected void finalize() throws Throwable {
		super.finalize();
		
	    try {
	    	if( m_pFreeFunc!=null )
	    		m_pFreeFunc.invoke( null, new Object[]{ m_pData } );
		} catch (Exception e) {
			HimawariLogger.outputException( e );
		}
	}
	
	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.CqSurface#Split(net.cellcomputing.himawari.accessory.STLVector)
	 */
	@Override
	public int Split(STLVector<CqBasicSurface> aSplits)
	{
	    // Store current context, set current context to the stored one
	    CqModeBlock pconSave = QGetRenderContext().pconCurrent( m_pconStored );

		m_pconStored.m_pattrCurrent = m_pAttributes;
		m_pAttributes.AddRef();

		m_pconStored.m_ptransCurrent = m_pTransform;

	    /// \note: The bound is in "raster" coordinates by now, as during posting to the imagebuffer
		/// the the Culling routines do the job for us, see CqBasicSurface::CacheRasterBound.
		CqBound bound = m_Bound;
//	    bound.Transform(QGetRenderContext()->matSpaceToSpace("camera", "raster"));
	    float detail = ( bound.vecMax().x - bound.vecMin().x ) * ( bound.vecMax().y - bound.vecMin().y );
	    //std::cout << "detail: " << detail << std::endl;

	    // Call the procedural secific Split()
	    RendermanInterface.RiAttributeBegin();

	    //\bhs
	    try {
//	    	m_pSubdivFunc(m_pData, detail);
			m_pSubdivFunc.invoke( RendermanInterface.class, new Object[]{ m_pData, detail } );
		} catch (Exception e) {
			HimawariLogger.outputException( e );
		}

	    RendermanInterface.RiAttributeEnd();

	    // restore saved context
	    QGetRenderContext().pconCurrent( pconSave );

	    STATS_INC( GEO_prc_split );

	    return 0;
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.CqBasicSurface#IsMotionBlurMatch(net.cellcomputing.himawari.library.CqBasicSurface)
	 */
	@Override
	public boolean IsMotionBlurMatch(CqBasicSurface pSurf) {
		return false;
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqSurface#cUniform()
	 */
	@Override
	public int cUniform() {
		return 0;
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqSurface#cVarying()
	 */
	@Override
	public int cVarying() {
		return 0;
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqSurface#cVertex()
	 */
	@Override
	public int cVertex() {
		return 0;
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqSurface#cFaceVarying()
	 */
	@Override
	public int cFaceVarying() {
		return 0;
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqSurface#Bound()
	 */
	@Override
	public CqBound Bound() {
		  return m_Bound;
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.CqSurface#Diceable()
	 */
	@Override
	public boolean Diceable() {
		return false;
	}
	
	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.CqSurface#Dice()
	 */
	@Override
	public CqMicroPolyGridBase Dice() {
		return null;
	}
	
	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.CqSurface#Transform(net.cellcomputing.himawari.library.types.CqMatrix, net.cellcomputing.himawari.library.types.CqMatrix, net.cellcomputing.himawari.library.types.CqMatrix, int)
	 */
	@Override
	public void Transform(CqMatrix matTx, CqMatrix matITTx, CqMatrix matRTx, int iTime) {
		 m_Bound.Transform( matTx );
	}
	
}
