// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;
import net.cellcomputing.himawari.util.HimawariLogger;

/**
 * l̃^CvƁAId̃^CvŃev[gꂽAp[^̈̃^Cv
 * @author NTT DATA Corporation
 */
public strictfp class CqParameterTypedConstant<T,SLT> extends CqParameterTyped<T,SLT> {

	private EqVariableType I;
	private T m_aValues;
	/**
	 * RXgN^
	 * 
	 * @param strName O
	 * @param count JEg
	 * @param I Generics I
	 * @param TClass Generics TClass
	 * @param SLTClass Generics SLTClass
	 */
	public CqParameterTypedConstant(final String strName,int count,EqVariableType I,Class<? extends T> TClass,Class<? extends SLT> SLTClass){
		super(strName,count,TClass,SLTClass);
		this.I = I;
		
		try{
			m_aValues = TClass.newInstance();
		}catch(IllegalAccessException e){
			HimawariLogger.outputException( e );
			assert(false);
		}catch(InstantiationException ie){
			HimawariLogger.outputException( ie );
			assert(false);
		}
	}
	
	/**
	 * RXgN^
	 * 
	 * @param strName O
	 * @param I Generics I
	 * @param TClass Generics TClass
	 * @param SLTClass Generics SLT̃NX
	 */
	public CqParameterTypedConstant(final String strName,EqVariableType I,Class<? extends T> TClass,Class<? extends SLT> SLTClass){
			this(strName,1,I,TClass,SLTClass);
	}
	/**
	 * Rs[RXgN^
	 * @param From Rs[
	 * @param I Generics I
	 */
	public CqParameterTypedConstant(final CqParameterTypedConstant<T,SLT> From,EqVariableType I){
		super(From);
		this.I = I;
		try{
			m_aValues = (T)TClass.newInstance();
			
	        if(m_aValues instanceof CqVector3D){

	                ((CqVector3D)m_aValues).assignment((CqVector3D)(From.m_aValues));
	        	
	        }else if(m_aValues instanceof CqVector4D){
	                ((CqVector4D)m_aValues).assignment((CqVector4D)(From.m_aValues));
	        	
	        }else if(m_aValues instanceof CqColor){
	                ((CqColor)m_aValues).assignment((CqColor)(From.m_aValues));
	        	
	        }else if(m_aValues instanceof CqMatrix){
	                ((CqMatrix)m_aValues).assignment((CqMatrix)(From.m_aValues));
	        	
	        }else if(m_aValues instanceof p_float){
	                ((p_float)m_aValues).value = ((p_float)(From.m_aValues)).value;
	        	
	        }else if(m_aValues instanceof p_int){
	                ((p_int)m_aValues).value = ((p_int)(From.m_aValues)).value;
	        	
	        }else if(m_aValues instanceof p_String){
	                ((p_String)m_aValues).value = ((p_String)(From.m_aValues)).value;
        	
	        }

		
		}catch(IllegalAccessException e){
			HimawariLogger.outputException( e );
			assert(false);
		}catch(InstantiationException ie){
			HimawariLogger.outputException( ie );
			assert(false);
		}

	}
	/**
	 * CR[Zq
	 * Vector̒lSĎgVectorɃRs[
	 * 
	 * @param From CX^X
	 * @return g
	 */
	public  CqParameterTypedConstant<T,SLT> assignment(CqParameterTypedConstant<T,SLT> From){
		if(m_aValues instanceof CqVector3D){
			
			((CqVector3D)m_aValues).assignment((CqVector3D)(From.m_aValues));
			
		}else if(m_aValues instanceof CqVector4D){
			((CqVector4D)m_aValues).assignment((CqVector4D)(From.m_aValues));
			
		}else if(m_aValues instanceof CqColor){
			((CqColor)m_aValues).assignment((CqColor)(From.m_aValues));
			
		}else if(m_aValues instanceof CqMatrix){
			((CqMatrix)m_aValues).assignment((CqMatrix)(From.m_aValues));
			
		}else if(m_aValues instanceof p_float){
			((p_float)m_aValues).value = ((p_float)(From.m_aValues)).value;
			
		}else if(m_aValues instanceof p_int){
			((p_int)m_aValues).value = ((p_int)(From.m_aValues)).value;
			
		}else if(m_aValues instanceof p_String){
			((p_String)m_aValues).value = ((p_String)(From.m_aValues)).value;
			
		}
		

		return this;
	}
	/**
	 * fXgN^
	 */
	public void destruct(){
		super.destruct();
	}
	
	/**
	 * lm_aValuesԂ
	 * z͂P̒lȂ
	 */
	public Object[] pValue() {
		Object[] retval = new Object[1];
		retval[0] = m_aValues;
		return retval;
	}

	/**
	 * lm_aValuesԂ
	 * z͂P̒lȂ
	 */
	public Object[] pValue(final int Index) {
		Object[] retval = new Object[1];
		retval[0] = m_aValues;
		return retval;
	}

	//nttdata chenge
	public T pValue_get(final int Index ,final int arrayIndex)
	{
		return m_aValues;
	}
	/**
	 * Type̓CX^X𐶐ĕԂ
	 * 
	 * @param Name O
	 * @param Count JEg
	 * @return VCqParameter
	 */
	public CqParameter CloneType(final String Name, int Count) {
		return ( new CqParameterTypedConstant<T,SLT>( Name, Count,I,TClass,SLTClass) );
	}
	
	/**
	 * g̕𐶐ĕԂ
	 */
	public CqParameter Clone() {
		return ( new CqParameterTypedConstant<T,SLT>( this , I ) );		
	}
	/**
	 * EqVariableClassԂ
	 *
	 * @return EqVariableClass
	 */

	public EqVariableClass Class() {
		return new EqVariableClass(EqVariableClass.class_constant);
	}

	/**
	 * EqVariableTypeԂ
	 * @return EqVariableType
	 */
	public EqVariableType Type() {
		return I;
	}

	/**
	 * 󃁃\bh
	 */
	public void SetSize(int size) {

	}
	/**
	 * ɂPԂ
	 */
	public int Size() {
		
		return 1;
	}
	/**
	 * 󃁃\bh
	 */
	public void Clear() {

	}

	/**
	 * w肳ꂽɑ΂SubdividesB
	 * TypeClass`FbNāAł
	 * gɑ(assignment)B<br>
	 * (eNX̐)<br>
	 * u ̒̕lAɕB̒lw̕ϐŕB
	 * 
	 * @param pResult1 
	 * @param pResult2 
	 * @param u pȂ
	 * @param pSurface pȂ
	 */
	public void Subdivide(CqParameter pResult1, CqParameter pResult2, boolean u,
			IqSurface pSurface) {
        assert( pResult1.Type().getValue() == Type().getValue() && pResult2.Type().getValue() == Type().getValue() &&
                pResult1.Class().getValue() == Class().getValue() && pResult2.Class().getValue() == Class().getValue() );

        CqParameterTypedConstant<T,SLT> pTResult1 = (CqParameterTypedConstant<T,SLT>)( pResult1 );
        CqParameterTypedConstant<T,SLT> pTResult2 = (CqParameterTypedConstant<T,SLT>)( pResult2 );
        pTResult1.assignment(pTResult2.assignment( this ));

	}

	/**
	 * IqShaderDataɒl<br>
	 * (eNXł̐)<br>
	 * z̒P̗vfl̃NX̓K؂ȕ⊮păObhɐ؂o(Dice)
	 * @param u
	 * @param v
	 * @param pResult 
	 * @param pSurface gpȂ
	 */
	public void Dice(int u, int v, IqShaderData pResult, IqSurface pSurface) {
//		 Just promote the constant value to varying by duplication.
		assert( pResult.Type().getValue() == Type().getValue() );
        // Note it is assumed that the variable has been
        // initialised to the correct size prior to calling.
        int i;
        long max = Math.max( (long)(u * v), pResult.Size() );
        
        //Genericsɓ^ɂďꍇ킯s
        if(m_aValues instanceof CqMatrix){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( (CqMatrix)m_aValues, i );
            }
        }else if(m_aValues instanceof CqVector3D){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( (CqVector3D)m_aValues, i );
            }
        }else if(m_aValues instanceof CqVector4D){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( new CqVector3D(((CqVector4D)(m_aValues))), i );
            }
        }else if(m_aValues instanceof CqColor){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( (CqColor)m_aValues, i );
            }
        }else if(m_aValues instanceof p_float){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( ((p_float)m_aValues).value, i );
            }
        }else if(m_aValues instanceof p_int){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( ((p_int)m_aValues).value, i );
            }
        }else if(m_aValues instanceof p_String){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( ((p_String)m_aValues).value, i );
            }
        }
	}
	
	/**
	 * Ɏs֐
	 */
	public void DiceOne(int u, int v, IqShaderData pResult, IqSurface pSurface,
			int ArrayIndex) {
		assert( false );

	}
	
	/**
	 * static RXgN^
	 * RXgN^Ɠlɗpł
	 * @param strName O
	 * @param Count JEg
	 * @param I Generics I
	 * @param myClass Generics TClass
	 */
     public static	<T,SLT> CqParameter	Create( final String strName, int Count,EqVariableType I,Class<? extends T> TClass,Class<? extends SLT> SLTClass)
    {
        return ( new CqParameterTypedConstant<T,SLT>( strName, Count ,I,TClass,SLTClass) );
    }

     /**
 	 * static RXgN^
 	 * RXgN^Ɠlɗpł(countȗn)
	 * @param strName O
	 * @param I Generics I
	 * @param TClass Generics TClass
	 * @param SLTClass Generics SLTClass
 	 */
     public static	<T,SLT> CqParameter	Create( final String strName,EqVariableType I,Class<? extends T> TClass,Class<? extends SLT> SLTClass)
     {
    	 return CqParameterTypedConstant.<T,SLT>Create(strName,1,I,TClass,SLTClass);
     }
	
	/**
	 * CqParameterTypedŒ`Ă
	 * Ŏw肵CX^XVectorAw肵l
	 * gVector̎w肵ʒuɃRs[s
	 * 
	 * @param pFrom Rs[CX^X
	 * @param idxTarget Rs[̔zԍB
	 * @param idxSource Rs[̔zԍ
	 */
//	public void SetValue(CqParameter pFrom, int idxTarget, int idxSource){
//		assert( pFrom.Type().getValue() == Type().getValue() );
//		
//        CqParameterTyped<T, SLT> pFromTyped = (CqParameterTyped<T, SLT>)( pFrom );
//        T tmp = (T)pValue( idxTarget )[0];//|C^Ȃ̂Œlo
//        if(tmp instanceof CqMatrix){
//        	((CqMatrix)tmp).assignment((CqMatrix)(pFromTyped.pValue( idxSource )[0]));
//        }else if(tmp instanceof CqVector3D){
//        	((CqVector3D)tmp).assignment((CqVector3D)(pFromTyped.pValue( idxSource )[0]));
//        }else if(tmp instanceof CqVector4D){
//        	((CqVector4D)tmp).assignment((CqVector4D)(pFromTyped.pValue( idxSource )[0]));
//        }else if(tmp instanceof CqColor){
//        	((CqColor)tmp).assignment((CqColor)(pFromTyped.pValue( idxSource )[0]));
//        }else if(tmp instanceof p_float){
//        	((p_float)tmp).value = ((p_float)(pFromTyped.pValue(idxSource)[0])).value;
//        }else if(tmp instanceof p_int){
//        	((p_int)tmp).value = ((p_int)(pFromTyped.pValue(idxSource)[0])).value;
//        }else if(tmp instanceof p_String){
//        	((p_String)tmp).value = ((p_String)(pFromTyped.pValue(idxSource)[0])).value;
//        }
//	}
     public void SetValue(CqParameter pFrom, int idxTarget, int idxSource){
 		assert( pFrom.Type().getValue() == Type().getValue() );
 		
         CqParameterTyped<T, SLT> pFromTyped = (CqParameterTyped<T, SLT>)( pFrom );
         T tmp = (T)pValue_get( idxTarget ,0 );//|C^Ȃ̂Œlo
         if(tmp instanceof CqMatrix){
         	((CqMatrix)tmp).assignment((CqMatrix)(pFromTyped.pValue_get( idxSource , 0 )));
         }else if(tmp instanceof CqVector3D){
         	((CqVector3D)tmp).assignment((CqVector3D)(pFromTyped.pValue_get( idxSource , 0 )));
         }else if(tmp instanceof CqVector4D){
         	((CqVector4D)tmp).assignment((CqVector4D)(pFromTyped.pValue_get( idxSource , 0 )));
         }else if(tmp instanceof CqColor){
         	((CqColor)tmp).assignment((CqColor)(pFromTyped.pValue_get( idxSource , 0 )));
         }else if(tmp instanceof p_float){
         	((p_float)tmp).value = ((p_float)(pFromTyped.pValue(idxSource)[0])).value;
         }else if(tmp instanceof p_int){
         	((p_int)tmp).value = ((p_int)(pFromTyped.pValue(idxSource)[0])).value;
         }else if(tmp instanceof p_String){
         	((p_String)tmp).value = ((p_String)(pFromTyped.pValue(idxSource)[0])).value;
         }
 	}
}
