// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import static net.cellcomputing.himawari.library.EqModeBlock.*;

/**
 * Define the context that exists between calls to RiObjectBegin/RiObjectEnd.<br>
 *  RiObjectBegin/RiObjectEndĂ΂ĂԂɑ݂AReLXg`B
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqObjectModeBlock extends CqModeBlock
{
	
	/**
	 * RXgN^B@l̐ݒB
	 * @param pconParent	ÕReLXg
	 */
	public CqObjectModeBlock( final CqModeBlock pconParent )
	{
		super(pconParent, Object);
	 
		// Create new Attributes as they must be pushed/popped by the state change.
		// Ԃ̕ωŕςAgr[gV쐬B
		m_pattrCurrent = new CqAttributes();
	    m_pattrCurrent.AddRef();
		m_ptransCurrent = new CqTransform(pconParent.m_ptransCurrent );
	}
	

	/**
	 * fXgN^B<br>
	 * QƂB@(QƃJE^fNgB)
	 * @see net.cellcomputing.himawari.library.CqModeBlock#destruct()
	 */
	@Override
	public void destruct()
	{
		m_pattrCurrent.Release();
	}


    /** 
     * Create a main context.<br>
     * 	C̃ReLXg쐬B
     * 
     * @warning IuWFNgReLXg̒ŁÃ\bhĂ΂ꂽꍇG[ƂȂB
     * @see net.cellcomputing.himawari.library.CqModeBlock#BeginMainModeBlock()
     */
	@Override
    public CqModeBlock	BeginMainModeBlock()
    {
        return 	null;	// Error
    }		
    
	
    /** 
     * Create a frame context.<br>
     * 	t[̃ReLXg쐬B
     * 
     * @warning [hReLXg̒ŁÃ\bhĂ΂ꂽꍇG[ƂȂB
     * @see net.cellcomputing.himawari.library.CqModeBlock#BeginFrameModeBlock()
     */
	@Override
    public	CqModeBlock	BeginFrameModeBlock()
    {
        return	 null;	// Error
    }		
    
	
    /** 
     * Create a world context.<br>
     * 	[h̃ReLXg쐬B
     * 
     * @warning [hReLXg̒ŁÃ\bhĂ΂ꂽꍇG[ƂȂB
     * @see net.cellcomputing.himawari.library.CqModeBlock#BeginWorldModeBlock()
     */
	@Override
    public CqModeBlock	BeginWorldModeBlock()
    {
        return	null;	// Error
    }		

	
    /** 
     * Delete the object context.<br>
     * 	IuWFNgReLXgB
     * 
     * @attention ̃\bĥ݁AIuWFNg̃ReLXg邱ƂłB
     * @see net.cellcomputing.himawari.library.CqModeBlock#EndObjectModeBlock()
     */
	@Override
    public void	EndObjectModeBlock()
    {
		destruct();
    }

	
    /** 
     * Get a reference to the options at the parent context, <br>
     * as object context doesn't store options.<br>
     * 	ẽReLXg̃IvṼQb^B<br>@
     *  (IuWFNgReLXg̓IvVĂȂ)
     *  
     * @return ẽIvV
     * @see net.cellcomputing.himawari.library.CqModeBlock#optCurrent()
     */
	@Override
    public	CqOptions	optCurrent()
    {
        return ( pconParent().optCurrent() );
    }
    
    
	 /** 
     * Get a pointer to the attributes at the parent context, <br>
     * as object context doesn't store attributes.<br>
     * 	Agr[g̃Qb^B<br>@
     *  (IuWFNgReLXg̓Agr[gۑȂ߁AẽAgr[gԂB)
     * 
     * @return 	ẽAgr[g̎Q
     * @see net.cellcomputing.himawari.library.CqModeBlock#pattrCurrent()
     */
	@Override
    public CqAttributes pattrCurrent()
    {
        return ( pconParent().pattrCurrent() );
    }
	
	
	/** 
     * Get a pointer suitable for writing to the attributes at the parent context, <br>
     * as object context doesn't store attributes.<br>
     * 	Agr[g̏̂߂̃Qb^B
     * @IuWFNǵAAgr[gȂ߁Ã\bhĂяoƃG[ƂȂB
     *  
     * @return 	null
     * @see net.cellcomputing.himawari.library.CqModeBlock#pattrWriteCurrent()
     */
	@Override
    public CqAttributes pattrWriteCurrent()
    {
		//@Illegal to change attributes here.
		//@IuWFNgubN̒ŃAgr[gύXƂ͂łȂB
        assert( false ); return ( null );	
    }	

}