// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.CqVector3D;

/**
 * 
 * Base lass for static micropolygons. Stores point information about the geometry of the micropoly.
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqMovingMicroPolygonKeyPoints {
	
	public CqVector3D	m_Point0 = new CqVector3D();
	public float		m_radius;
	
	public CqMovingMicroPolygonKeyPoints()
	{}
	
	public CqMovingMicroPolygonKeyPoints( final CqVector3D vA, float radius)
	{
		Initialise( vA, radius );
	}
	
	public boolean fContains( final CqVector2D vecP, p_float Depth, float time )
	{
		if( (new CqVector2D( m_Point0.x, m_Point0.y ).sub( vecP ) ).Magnitude() < m_radius )
		{
			Depth.value = m_Point0.z;
			return( true );
		}
		return( false );
	}
	
	public CqBound GetTotalBound()
	{
//		Pmin = Pmax = m_Point0;
		CqVector3D Pmin = new CqVector3D( m_Point0 );
		CqVector3D Pmax = new CqVector3D( m_Point0 );
		
		Pmin.x( Pmin.x - m_radius );
		Pmin.y( Pmin.y - m_radius );
		Pmax.x( Pmax.x + m_radius );
		Pmax.y( Pmax.y + m_radius );
		return( new CqBound( Pmin, Pmax ) );
	}
	
	public void Initialise( final CqVector3D vA, float radius )
	{
		m_Point0.assignment( vA );
		m_radius = radius;
	}
	
}
