/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.display;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;

import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

import net.cellcomputing.himawari.util.HimawariLogger;

/**
 * @author NTT DATA Corporation
 * JPEG2000`Display߂ǗNXB
 * 摜C[WAt@CB
 */
public strictfp class JPEG2000Request extends DisplayRequest {
	/**
	 * JPEG2000`\萔
	 */
	private static final String IMAGE_EXT = "jpeg2000";
	
	/**
	 * RXgN^
	 * Request
	 * @param name t@C̖O
	 * @param type ۑ`
	 * @param mode RGB,RGBAȂǂ̃J[񂪂͂
	 * @param modeID modehash
	 * @param dataOffset 
	 * @param dataSize
	 * @param imageData RequestǗImageData (BufferedImage)
	 */
	public JPEG2000Request(String name, final String type,final String mode,
			int modeID, int dataOffset, int dataSize ,ImageData imageData){
		super(name,type,mode,modeID,dataOffset,dataSize,imageData);
	}

	/**
	 * Ȃ
	 */
	public void openRequest() {

	}
	/**
	 * Ŏw肳ꂽimage
	 * jpeg2000t@Cɏo͂
	 * @param image
	 */
	public void saveImage(BufferedImage image){
		Iterator writers = ImageIO.getImageWritersByFormatName(IMAGE_EXT);
		
		if (writers.hasNext()) {
			ImageWriter writer = (ImageWriter)writers.next();
			
			try {
				ImageOutputStream stream 
				= ImageIO.createImageOutputStream(new File(name));
				writer.setOutput(stream);
				
				writer.write(image);
				writer.dispose();
				
				return;
				
			} catch (FileNotFoundException e) {
				HimawariLogger.outputException(e);
				HimawariLogger.getLogger().error( "Cannot open output image file: " + name + "\n");
				
			} catch (IOException e) {
				HimawariLogger.outputException(e);
				HimawariLogger.getLogger().error( "Cannot open output image file: " + name + "\n");
			}
		}
	}
		
	/**
	 * Ȃ
	 */
	public void display() {

	}

	/**
	 * 摜f[^jpeg2000`̃t@C
	 * o͂B
	 */
	public void closeRequest() {
		BufferedImage image = (BufferedImage) imageData.getImage();
		saveImage(image);
		imageData = null;

	}

}
