/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.display;

import static net.cellcomputing.himawari.library.RiGlobal.QGetRenderContext;
import static net.cellcomputing.himawari.library.types.PublicFunctions.CLAMP;

import java.awt.image.WritableRaster;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.IqBucket;
import net.cellcomputing.himawari.library.UserParameter;
import net.cellcomputing.himawari.library.types.PublicFunctions;

/**
 * @author NTT DATA Corporation
 * _O摜f[^NXB
 * T^̃f[^B
 * BufferedImageɗpB
 * BufferedImage͕ۑłȂ`ɂꍇ
 * VectorȂǂ̃f[^`ppixel
 * ۂׂ̂łB
 * 
 * Singletonp^[ŎĂA
 * p҂getInstancepăCX^XB
 * 2006/11/10
 * NXł͂ȂoffsetlقȂ
 * ႤCX^XƂĐ悤ɕύX
 * ܂HashMapKeyClass+":"+offsetƂ
 */
public abstract strictfp class ImageData <T> {
	protected String 			type;		//imageType
	protected int				width;		//image̕
	protected int 				height;		//image̍
	protected float[] 		pixelData;	//pixel̃f[^
	protected WritableRaster	raster;		//Raster
	protected int				dataSize;	//pixelf[^
	protected T 				imageData;	//imagepf[^
	protected int 				offset;		//摜f[^offset 2006/11/10 offsetpǉ
	
	
	//-------------------------------------
	protected STLVector<UserParameter>	m_customParams = new STLVector<UserParameter>(UserParameter.class,1);
	protected float	m_QuantizeZeroVal;
	protected float	m_QuantizeOneVal;
	protected float	m_QuantizeMinVal;
	protected float	m_QuantizeMaxVal;
	protected float	m_QuantizeDitherVal;
	//-------------------------------------
	
	
	/**
	 * oPbg̃f[^擾
	 * @param bucket `f[^
	 */
	public abstract void setBucket(IqBucket bucket);
	
	/**
	 * ێĂ摜f[^ԂB
	 * 摜f[^̌^͎qNXɈˑ
	 * 
	 * 
	 * @return 摜f[^
	 */
	public abstract T getImage();

	/**
	 * s
	 *
	 */
	public  void init(){
		width = QGetRenderContext() .optCurrent().GetIntegerOptionIndex( "System", "Resolution" , 0 ).value;		//image̕擾
		height = QGetRenderContext() .optCurrent().GetIntegerOptionIndex( "System", "Resolution" , 1 ).value;	//image̍擾
//		int xmin = (int)( PublicFunctions.CLAMP((float) Math.ceil( width * QGetRenderContext().optCurrent().GetFloatOption( "System", "CropWindow" ) [ 0 ] ), 0, width ) );
//		int xmax = (int)( PublicFunctions.CLAMP( (float)Math.ceil( width * QGetRenderContext().optCurrent().GetFloatOption( "System", "CropWindow" ) [ 1 ] ), 0, width ) );
//		int ymin = (int)( PublicFunctions.CLAMP( (float)Math.ceil( height * QGetRenderContext().optCurrent().GetFloatOption( "System", "CropWindow" ) [ 2 ] ), 0, height ) );
//		int ymax = (int)( PublicFunctions.CLAMP( (float)Math.ceil( height * QGetRenderContext().optCurrent().GetFloatOption( "System", "CropWindow" ) [ 3 ] ), 0, height ) );
		int xmin = (int)( PublicFunctions.CLAMP((float) Math.ceil( width * QGetRenderContext().optCurrent().GetFloatOptionIndex( "System", "CropWindow" , 0 ).value ), 0, width ) );
		int xmax = (int)( PublicFunctions.CLAMP( (float)Math.ceil( width * QGetRenderContext().optCurrent().GetFloatOptionIndex( "System", "CropWindow" , 1 ).value ), 0, width ) );
		int ymin = (int)( PublicFunctions.CLAMP( (float)Math.ceil( height * QGetRenderContext().optCurrent().GetFloatOptionIndex( "System", "CropWindow" , 2 ).value ), 0, height ) );
		int ymax = (int)( PublicFunctions.CLAMP( (float)Math.ceil( height * QGetRenderContext().optCurrent().GetFloatOptionIndex( "System", "CropWindow" , 3 ).value ), 0, height ) );

		width = xmax -xmin;
		height = ymax - ymin;
	}
	
	//--SingletonptB[hE\bh
	private static HashMap<String,ImageData> classMap 	= new HashMap<String,ImageData>();	//TuNX̃CX^XǗHashMap
	private static Object	 _lock		= new Object();		//lockpObject
	
//	/**
//	 * RXgN^
//	 *
//	 */
//	protected ImageData(){
//		synchronized(_lock){
//			String classname =this.getClass().getName();
//			
//			//HashmapNXŃCX^XĂ邩
//			if(classMap.get(classname) != null){
//				throw new RuntimeException("Already created: " + classname);
//			}
//			
//			classMap.put(classname,this);
//		}
//	}

	//2006/11/10 offsettSingletonpύX
	/**
	 * RXgN^
	 *
	 */
	protected ImageData(int offset){
		synchronized(_lock){
			String classname =this.getClass().getName();
			classname = classname + ":" + offset;
			//HashmapNXŃCX^XĂ邩
			if(classMap.get(classname) != null){
				throw new RuntimeException("Already created: " + classname);
			}
			this.offset = offset;
			classMap.put(classname,this);
		}
	}
	//--
	/**
	 * ImageData擾郁\bhB
	 * <<Singleton>>
	 * @param cls 擾Class
	 * @return w肳ꂽImageData
	 */
	public static  ImageData getInstance(Class cls,int offset){
		synchronized (_lock) {
			String classname = cls.getName();
			//2006/11/10ǉ offsettŃCX^X𔻕ʂ
			classname = classname + ":" + offset;
			//--
			ImageData obj = (ImageData)classMap.get(classname);
			if (obj == null) {
				try {
//					Class cls = Class.forName(classname);
//					obj = (ImageData)cls.newInstance(); //2006/11/10 offsetpύX
					Constructor constr = cls.getDeclaredConstructor(int.class);
					constr.setAccessible(true);
					obj = (ImageData)constr.newInstance(offset);
					
				} catch (IllegalAccessException e) {
					throw new RuntimeException(classname + " cannot be accessed.");
				} catch (InstantiationException e) {
					throw new RuntimeException(classname + " cannot be instantiated.");
				}//--2006/11/10 offsetpύX
				catch (NoSuchMethodException e){
					throw new RuntimeException(classname + " cannot be instantiated.");					
				} catch (InvocationTargetException e){
					throw new RuntimeException(classname + " cannot be instantiated.");
				}//--
			}
			return obj;
		}
		
	}
	
	/**
	 * w肳ꂽlʎq
	 * @param value	ʎql
	 * @return	ʎqꂽl
	 */
	protected float quantize( float value ) {
		value = Math.round(m_QuantizeZeroVal + value * (m_QuantizeOneVal - m_QuantizeZeroVal) + m_QuantizeDitherVal );
		value = CLAMP(value, m_QuantizeMinVal, m_QuantizeMaxVal) ;
		return value;
	}
	
	
}
