/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.shaderexecenv;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Stack;
import net.cellcomputing.himawari.accessory.STLArray;
import net.cellcomputing.himawari.accessory.Valarray;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.CqTransform;
import net.cellcomputing.himawari.library.EqVariableClass;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.IqAttributes;
import net.cellcomputing.himawari.library.IqLightsource;
import net.cellcomputing.himawari.library.IqShader;
import net.cellcomputing.himawari.library.IqShaderData;
import net.cellcomputing.himawari.library.IqShaderExecEnv;
import net.cellcomputing.himawari.library.IqSurface;
import net.cellcomputing.himawari.library.IqTextureMap;
import net.cellcomputing.himawari.library.IqTransform;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqBitVector;
import net.cellcomputing.himawari.library.types.CqCellNoise;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqNoise;
import net.cellcomputing.himawari.library.types.CqRandom;
import net.cellcomputing.himawari.library.types.CqSplineCubic;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;
import net.cellcomputing.himawari.library.types.PublicFunctions;
import net.cellcomputing.himawari.shaderexecenv.BakingChannel;
import net.cellcomputing.himawari.shaderexecenv.GlobalShaderExecEnv;
import net.cellcomputing.himawari.util.HimawariLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqShaderExecEnv
extends IqShaderExecEnv {
    private STLArray<IqShaderData> m_apVariables = new STLArray<IqShaderData>(IqShaderData.class);
    private static CqNoise m_noise = CqNoise.getInstance();
    private static CqCellNoise m_cellnoise = new CqCellNoise();
    private static CqRandom m_random = new CqRandom();
    private static CqMatrix m_matIdentity = new CqMatrix();
    private int m_uGridRes;
    private int m_vGridRes;
    private int m_GridSize;
    private int m_li = 0;
    private int m_Illuminate = 0;
    private boolean m_IlluminanceCacheValid;
    private IqAttributes m_pAttributes = null;
    private CqTransform m_pTransform;
    private CqBitVector m_CurrentState = new CqBitVector();
    private CqBitVector m_RunningState = new CqBitVector();
    private Stack<CqBitVector> m_stkState = new Stack();
    private int m_LocalIndex = 0;
    private IqSurface m_pCurrentSurface;
    static int cnt = 0;
    static /* synthetic */ Class class$0;

    public CqShaderExecEnv() {
        this.m_apVariables.setSize(25);
        int i = 0;
        while (i < 25) {
            this.m_apVariables.set(i, null);
            ++i;
        }
    }

    public void destruct() {
        int i = 0;
        while (i < 25) {
            this.m_apVariables.get(i).destruct();
            ++i;
        }
        if (this.m_pAttributes != null) {
            this.m_pAttributes.Release();
        }
    }

    private void GetFilterParams(int cParams, IqShaderData[] apParams, p_float _pswidth, p_float _ptwidth) {
        p_String strParam = new p_String();
        p_float f = new p_float();
        int i = 0;
        while (cParams > 0) {
            apParams[i].GetString(strParam, 0);
            apParams[i + 1].GetFloat(f, 0);
            if (strParam.value.compareTo("width") == 0) {
                _pswidth.value = _ptwidth.value = f.value;
            } else if (strParam.value.compareTo("swidth") == 0) {
                _pswidth.value = f.value;
            } else if (strParam.value.compareTo("twidth") == 0) {
                _ptwidth.value = f.value;
            }
            i += 2;
            cParams -= 2;
        }
    }

    private void GetTexParams(int cParams, IqShaderData[] apParams, HashMap<String, IqShaderData> map) {
        p_String strParam = new p_String();
        int i = 0;
        while (cParams > 0) {
            apParams[i].GetString(strParam, 0);
            map.put(strParam.value, apParams[i + 1]);
            i += 2;
            cParams -= 2;
        }
    }

    @Override
    public void Initialise(int uGridRes, int vGridRes, IqAttributes pAttr, IqTransform pTrans, IqShader pShader, int Uses) {
        float[] shutter;
        this.m_uGridRes = uGridRes;
        this.m_vGridRes = vGridRes;
        this.m_GridSize = (uGridRes + 1) * (vGridRes + 1);
        this.m_LocalIndex = 0;
        if (pAttr != null) {
            if (this.m_pAttributes != null) {
                this.m_pAttributes.Release();
            }
            this.m_pAttributes = pAttr;
            this.m_pAttributes.AddRef();
        } else {
            this.m_pAttributes = null;
        }
        if (pTrans != null) {
            this.m_pTransform = (CqTransform)pTrans;
        }
        this.m_li = 0;
        this.m_Illuminate = 0;
        this.m_IlluminanceCacheValid = false;
        this.m_CurrentState.SetSize(this.m_GridSize);
        this.m_RunningState.SetSize(this.m_GridSize);
        this.m_RunningState.SetAll(true);
        if (pShader != null) {
            if (RiGlobal.USES(Uses, 8) && this.m_apVariables.get(8) == null) {
                this.m_apVariables.set(8, pShader.CreateVariable(new EqVariableType(3), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[8]));
            }
            if (RiGlobal.USES(Uses, 0) && this.m_apVariables.get(0) == null) {
                this.m_apVariables.set(0, pShader.CreateVariable(new EqVariableType(5), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[0]));
            }
            if (RiGlobal.USES(Uses, 1) && this.m_apVariables.get(1) == null) {
                this.m_apVariables.set(1, pShader.CreateVariable(new EqVariableType(5), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[1]));
            }
            if (RiGlobal.USES(Uses, 2) && this.m_apVariables.get(2) == null) {
                this.m_apVariables.set(2, pShader.CreateVariable(new EqVariableType(8), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[2]));
            }
            if (RiGlobal.USES(Uses, 3) && this.m_apVariables.get(3) == null) {
                this.m_apVariables.set(3, pShader.CreateVariable(new EqVariableType(1), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[3]));
            }
            if (RiGlobal.USES(Uses, 4) && this.m_apVariables.get(4) == null) {
                this.m_apVariables.set(4, pShader.CreateVariable(new EqVariableType(1), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[4]));
            }
            if (RiGlobal.USES(Uses, 5) && this.m_apVariables.get(5) == null) {
                this.m_apVariables.set(5, pShader.CreateVariable(new EqVariableType(9), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[5]));
            }
            if (RiGlobal.USES(Uses, 6) && this.m_apVariables.get(6) == null) {
                this.m_apVariables.set(6, pShader.CreateVariable(new EqVariableType(5), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[6]));
            }
            if (RiGlobal.USES(Uses, 7) && this.m_apVariables.get(7) == null) {
                this.m_apVariables.set(7, pShader.CreateVariable(new EqVariableType(5), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[7]));
            }
            if (RiGlobal.USES(Uses, 9) && this.m_apVariables.get(9) == null) {
                this.m_apVariables.set(9, pShader.CreateVariable(new EqVariableType(9), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[9]));
            }
            if (RiGlobal.USES(Uses, 10) && this.m_apVariables.get(10) == null) {
                this.m_apVariables.set(10, pShader.CreateVariable(new EqVariableType(9), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[10]));
            }
            if (RiGlobal.USES(Uses, 11) && this.m_apVariables.get(11) == null) {
                this.m_apVariables.set(11, pShader.CreateVariable(new EqVariableType(8), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[11]));
            }
            if (RiGlobal.USES(Uses, 12) && this.m_apVariables.get(12) == null) {
                this.m_apVariables.set(12, pShader.CreateVariable(new EqVariableType(1), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[12]));
            }
            if (RiGlobal.USES(Uses, 13) && this.m_apVariables.get(13) == null) {
                this.m_apVariables.set(13, pShader.CreateVariable(new EqVariableType(1), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[13]));
            }
            if (RiGlobal.USES(Uses, 14) && this.m_apVariables.get(14) == null) {
                this.m_apVariables.set(14, pShader.CreateVariable(new EqVariableType(1), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[14]));
            }
            if (RiGlobal.USES(Uses, 15) && this.m_apVariables.get(15) == null) {
                this.m_apVariables.set(15, pShader.CreateVariable(new EqVariableType(1), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[15]));
            }
            if (RiGlobal.USES(Uses, 16) && this.m_apVariables.get(16) == null) {
                this.m_apVariables.set(16, pShader.CreateVariable(new EqVariableType(9), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[16]));
            }
            if (RiGlobal.USES(Uses, 17) && this.m_apVariables.get(17) == null) {
                this.m_apVariables.set(17, pShader.CreateVariable(new EqVariableType(5), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[17]));
            }
            if (RiGlobal.USES(Uses, 18) && this.m_apVariables.get(18) == null) {
                this.m_apVariables.set(18, pShader.CreateVariable(new EqVariableType(5), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[18]));
            }
            if (RiGlobal.USES(Uses, 19) && this.m_apVariables.get(19) == null) {
                this.m_apVariables.set(19, pShader.CreateVariable(new EqVariableType(3), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[19]));
            }
            if (RiGlobal.USES(Uses, 20) && this.m_apVariables.get(20) == null) {
                this.m_apVariables.set(20, pShader.CreateVariable(new EqVariableType(3), new EqVariableClass(2), GlobalShaderExecEnv.gVariableNames[20]));
            }
            if (RiGlobal.USES(Uses, 21) && this.m_apVariables.get(21) == null) {
                this.m_apVariables.set(21, pShader.CreateVariable(new EqVariableType(1), new EqVariableClass(2), GlobalShaderExecEnv.gVariableNames[21]));
            }
            if (RiGlobal.USES(Uses, 22) && this.m_apVariables.get(22) == null) {
                this.m_apVariables.set(22, pShader.CreateVariable(new EqVariableType(1), new EqVariableClass(2), GlobalShaderExecEnv.gVariableNames[22]));
            }
            if (RiGlobal.USES(Uses, 23) && this.m_apVariables.get(23) == null) {
                this.m_apVariables.set(23, pShader.CreateVariable(new EqVariableType(1), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[23]));
            }
            if (RiGlobal.USES(Uses, 24) && this.m_apVariables.get(24) == null) {
                this.m_apVariables.set(24, pShader.CreateVariable(new EqVariableType(8), new EqVariableClass(3), GlobalShaderExecEnv.gVariableNames[24]));
            }
        }
        int i = 0;
        while (i < 25) {
            if (this.m_apVariables.get(i) != null && RiGlobal.USES(Uses, i)) {
                this.m_apVariables.get(i).Initialise(uGridRes, vGridRes);
            }
            ++i;
        }
        if (RiGlobal.USES(Uses, 22) && (shutter = RiGlobal.QGetRenderContextI().GetFloatOption("System", "Shutter")) != null) {
            float[] shutteroffset = RiGlobal.QGetRenderContextI().GetFloatOption("shutter", "offset");
            float offset = 0.0f;
            if (shutteroffset != null) {
                offset = shutteroffset[0];
            }
            this.m_apVariables.get(22).SetFloat(shutter[0] + offset);
        }
    }

    @Override
    public int uGridRes() {
        return this.m_uGridRes;
    }

    @Override
    public int vGridRes() {
        return this.m_vGridRes;
    }

    @Override
    public int GridSize() {
        return this.m_GridSize;
    }

    @Override
    public CqMatrix matObjectToWorld() {
        return this.m_pTransform == null ? m_matIdentity : this.m_pTransform.matObjectToWorld(this.m_pTransform.Time(0));
    }

    @Override
    public IqAttributes pAttributes() {
        return this.m_pAttributes;
    }

    @Override
    public IqTransform pTransform() {
        return this.m_pTransform;
    }

    @Override
    public void SetCurrentSurface(IqSurface pEnv) {
        this.m_pCurrentSurface = pEnv;
    }

    @Override
    public IqSurface GetCurrentSurface() {
        return this.m_pCurrentSurface;
    }

    @Override
    public void ValidateIlluminanceCache(IqShaderData pP, IqShaderData pN, IqShader pShader) {
        if (!this.m_IlluminanceCacheValid) {
            IqShaderData Ns = pN != null ? pN : this.N();
            IqShaderData Ps = pP != null ? pP : this.P();
            int li = 0;
            while (li < this.m_pAttributes.cLights()) {
                IqLightsource lp = this.m_pAttributes.pLight(li);
                lp.Initialise(this.uGridRes(), this.vGridRes());
                this.m_Illuminate = 0;
                lp.Evaluate(Ps, Ns, this.m_pCurrentSurface);
                ++li;
            }
            this.m_IlluminanceCacheValid = true;
        }
    }

    @Override
    public void InvalidateIlluminanceCache() {
        this.m_IlluminanceCacheValid = false;
    }

    @Override
    public CqBitVector CurrentState() {
        return this.m_CurrentState;
    }

    @Override
    public CqBitVector RunningState() {
        return this.m_RunningState;
    }

    @Override
    public void GetCurrentState() {
        this.m_RunningState.assignment(this.m_CurrentState);
    }

    @Override
    public void ClearCurrentState() {
        this.m_CurrentState.SetAll(false);
    }

    @Override
    public void PushState() {
        this.m_stkState.push(new CqBitVector(this.m_RunningState));
    }

    @Override
    public void PopState() {
        this.m_RunningState = new CqBitVector(this.m_stkState.peek());
        this.m_stkState.pop();
    }

    @Override
    public void InvertRunningState() {
        this.m_RunningState.Complement();
        if (!this.m_stkState.empty()) {
            this.m_RunningState.Intersect(this.m_stkState.peek());
        }
    }

    @Override
    public IqShaderData FindStandardVar(String pname) {
        int tmp = this.m_LocalIndex;
        long htoken = pname.hashCode();
        while (this.m_LocalIndex < 25) {
            if (GlobalShaderExecEnv.gVariableTokens[this.m_LocalIndex] == htoken) {
                return this.m_apVariables.get(this.m_LocalIndex);
            }
            ++this.m_LocalIndex;
        }
        this.m_LocalIndex = 0;
        while (this.m_LocalIndex < tmp) {
            if (GlobalShaderExecEnv.gVariableTokens[this.m_LocalIndex] == htoken) {
                return this.m_apVariables.get(this.m_LocalIndex);
            }
            ++this.m_LocalIndex;
        }
        return null;
    }

    @Override
    public int FindStandardVarIndex(String pname) {
        int tmp = this.m_LocalIndex;
        long htoken = pname.hashCode();
        while (this.m_LocalIndex < 25) {
            if (GlobalShaderExecEnv.gVariableTokens[this.m_LocalIndex] == htoken) {
                return this.m_LocalIndex;
            }
            ++this.m_LocalIndex;
        }
        this.m_LocalIndex = 0;
        while (this.m_LocalIndex < tmp) {
            if (GlobalShaderExecEnv.gVariableTokens[this.m_LocalIndex] == htoken) {
                return this.m_LocalIndex;
            }
            ++this.m_LocalIndex;
        }
        return -1;
    }

    @Override
    public IqShaderData pVar(int Index) {
        return this.m_apVariables.get(Index);
    }

    @Override
    public void DeleteVariable(int Index) {
        if (this.m_apVariables.get(Index) != null) {
            this.m_apVariables.get(Index).destruct();
        }
        this.m_apVariables.set(Index, null);
    }

    @Override
    public IqShaderData Cs() {
        return this.m_apVariables.get(0);
    }

    @Override
    public IqShaderData Os() {
        return this.m_apVariables.get(1);
    }

    @Override
    public IqShaderData Ng() {
        return this.m_apVariables.get(2);
    }

    @Override
    public IqShaderData du() {
        return this.m_apVariables.get(3);
    }

    @Override
    public IqShaderData dv() {
        return this.m_apVariables.get(4);
    }

    @Override
    public IqShaderData L() {
        return this.m_apVariables.get(5);
    }

    @Override
    public IqShaderData Cl() {
        return this.m_apVariables.get(6);
    }

    @Override
    public IqShaderData Ol() {
        return this.m_apVariables.get(7);
    }

    @Override
    public IqShaderData P() {
        return this.m_apVariables.get(8);
    }

    @Override
    public IqShaderData dPdu() {
        return this.m_apVariables.get(9);
    }

    @Override
    public IqShaderData dPdv() {
        return this.m_apVariables.get(10);
    }

    @Override
    public IqShaderData N() {
        return this.m_apVariables.get(11);
    }

    @Override
    public IqShaderData u() {
        return this.m_apVariables.get(12);
    }

    @Override
    public IqShaderData v() {
        return this.m_apVariables.get(13);
    }

    @Override
    public IqShaderData s() {
        return this.m_apVariables.get(14);
    }

    @Override
    public IqShaderData t() {
        return this.m_apVariables.get(15);
    }

    @Override
    public IqShaderData I() {
        return this.m_apVariables.get(16);
    }

    @Override
    public IqShaderData Ci() {
        return this.m_apVariables.get(17);
    }

    @Override
    public IqShaderData Oi() {
        return this.m_apVariables.get(18);
    }

    @Override
    public IqShaderData Ps() {
        return this.m_apVariables.get(19);
    }

    @Override
    public IqShaderData E() {
        return this.m_apVariables.get(20);
    }

    @Override
    public IqShaderData ncomps() {
        return this.m_apVariables.get(21);
    }

    @Override
    public IqShaderData time() {
        return this.m_apVariables.get(22);
    }

    @Override
    public IqShaderData alpha() {
        return this.m_apVariables.get(23);
    }

    @Override
    public IqShaderData Ns() {
        return this.m_apVariables.get(24);
    }

    @Override
    public boolean SO_init_illuminance() {
        this.m_li = -1;
        return this.SO_advance_illuminance();
    }

    @Override
    public boolean SO_advance_illuminance() {
        ++this.m_li;
        while (this.m_li < this.m_pAttributes.cLights() && this.m_pAttributes.pLight(this.m_li).pShader().fAmbient()) {
            ++this.m_li;
        }
        return this.m_li < this.m_pAttributes.cLights();
    }

    @Override
    public void SO_radians(IqShaderData degrees, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(228);
        boolean __fVarying = false;
        __fVarying = degrees.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_degrees = new p_float();
            degrees.GetFloat(_aq_degrees, __iGrid);
            Result.SetFloat((float)Math.toRadians(_aq_degrees.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_degrees(IqShaderData radians, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(144);
        boolean __fVarying = false;
        __fVarying = radians.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_radians = new p_float();
            radians.GetFloat(_aq_radians, __iGrid);
            Result.SetFloat((float)Math.toDegrees(_aq_radians.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_sin(IqShaderData a, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(248);
        boolean __fVarying = false;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_a = new p_float();
            a.GetFloat(_aq_a, __iGrid);
            Result.SetFloat((float)Math.sin(_aq_a.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_asin(IqShaderData a, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(105);
        boolean __fVarying = false;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_a = new p_float();
            a.GetFloat(_aq_a, __iGrid);
            Result.SetFloat((float)Math.asin(_aq_a.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_cos(IqShaderData a, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(132);
        boolean __fVarying = false;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_a = new p_float();
            a.GetFloat(_aq_a, __iGrid);
            Result.SetFloat((float)Math.cos(_aq_a.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_acos(IqShaderData a, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(102);
        boolean __fVarying = false;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_a = new p_float();
            a.GetFloat(_aq_a, __iGrid);
            Result.SetFloat((float)Math.acos(_aq_a.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_tan(IqShaderData a, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(258);
        boolean __fVarying = false;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_a = new p_float();
            a.GetFloat(_aq_a, __iGrid);
            Result.SetFloat((float)Math.tan(_aq_a.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_atan(IqShaderData yoverx, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(106);
        boolean __fVarying = false;
        __fVarying = yoverx.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_yoverx = new p_float();
            yoverx.GetFloat(_aq_yoverx, __iGrid);
            Result.SetFloat((float)Math.atan(_aq_yoverx.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_atan(IqShaderData y, IqShaderData x, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(106);
        boolean __fVarying = false;
        __fVarying = x.Class().getValue() == 3 || __fVarying;
        __fVarying = y.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_x = new p_float();
            x.GetFloat(_aq_x, __iGrid);
            p_float _aq_y = new p_float();
            y.GetFloat(_aq_y, __iGrid);
            Result.SetFloat((float)Math.atan2(_aq_y.value, _aq_x.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_pow(IqShaderData x, IqShaderData y, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(218);
        boolean __fVarying = false;
        __fVarying = x.Class().getValue() == 3 || __fVarying;
        __fVarying = y.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_x = new p_float();
            x.GetFloat(_aq_x, __iGrid);
            p_float _aq_y = new p_float();
            y.GetFloat(_aq_y, __iGrid);
            p_float yy = _aq_y;
            p_float xx = _aq_x;
            if (xx.value < 0.0f) {
                yy.value = (float)Math.floor(yy.value);
            }
            Result.SetFloat((float)Math.pow(xx.value, yy.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_exp(IqShaderData x, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(150);
        boolean __fVarying = false;
        __fVarying = x.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_x = new p_float();
            x.GetFloat(_aq_x, __iGrid);
            Result.SetFloat((float)Math.exp(_aq_x.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_sqrt(IqShaderData x, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(255);
        boolean __fVarying = false;
        __fVarying = x.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_x = new p_float();
            x.GetFloat(_aq_x, __iGrid);
            Result.SetFloat((float)Math.sqrt(_aq_x.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_log(IqShaderData x, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(189);
        boolean __fVarying = false;
        __fVarying = x.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_x = new p_float();
            x.GetFloat(_aq_x, __iGrid);
            Result.SetFloat((float)Math.log(_aq_x.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_log(IqShaderData x, IqShaderData base, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(189);
        boolean __fVarying = false;
        __fVarying = x.Class().getValue() == 3 || __fVarying;
        __fVarying = base.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_x = new p_float();
            x.GetFloat(_aq_x, __iGrid);
            p_float _aq_base = new p_float();
            base.GetFloat(_aq_base, __iGrid);
            Result.SetFloat((float)(Math.log(_aq_x.value) / Math.log(_aq_base.value)), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_mod(IqShaderData a, IqShaderData b, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(193);
        boolean __fVarying = false;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = b.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_a = new p_float();
            a.GetFloat(_aq_a, __iGrid);
            p_float _aq_b = new p_float();
            b.GetFloat(_aq_b, __iGrid);
            int n = (int)(_aq_a.value / _aq_b.value);
            float a2 = _aq_a.value - (float)n * _aq_b.value;
            if (a2 < 0.0f) {
                a2 += _aq_b.value;
            }
            Result.SetFloat(a2, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_abs(IqShaderData x, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(101);
        boolean __fVarying = false;
        __fVarying = x.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_x = new p_float();
            x.GetFloat(_aq_x, __iGrid);
            Result.SetFloat(Math.abs(_aq_x.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_sign(IqShaderData x, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(247);
        boolean __fVarying = false;
        __fVarying = x.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_x = new p_float();
            x.GetFloat(_aq_x, __iGrid);
            Result.SetFloat(_aq_x.value < 0.0f ? -1.0f : 1.0f, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_min(IqShaderData a, IqShaderData b, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(192);
        boolean __fVarying = false;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = b.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_a = new p_float();
            a.GetFloat(_aq_a, __iGrid);
            p_float _aq_b = new p_float();
            b.GetFloat(_aq_b, __iGrid);
            float fRes = Math.min(_aq_a.value, _aq_b.value);
            while (cParams-- > 0) {
                p_float fn = new p_float();
                apParams[cParams].GetFloat(fn, __iGrid);
                fRes = Math.min(fRes, fn.value);
            }
            Result.SetFloat(fRes, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_max(IqShaderData a, IqShaderData b, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(191);
        boolean __fVarying = false;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = b.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_a = new p_float();
            a.GetFloat(_aq_a, __iGrid);
            p_float _aq_b = new p_float();
            b.GetFloat(_aq_b, __iGrid);
            float fRes = Math.max(_aq_a.value, _aq_b.value);
            while (cParams-- > 0) {
                p_float fn = new p_float();
                apParams[cParams].GetFloat(fn, __iGrid);
                fRes = Math.max(fRes, fn.value);
            }
            Result.SetFloat(fRes, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_pmin(IqShaderData a, IqShaderData b, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(212);
        boolean __fVarying = false;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = b.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_a = new CqVector3D();
            a.GetPoint(_aq_a, __iGrid);
            CqVector3D _aq_b = new CqVector3D();
            b.GetPoint(_aq_b, __iGrid);
            CqVector3D res = PublicFunctions.VMIN(_aq_a, _aq_b);
            while (cParams-- > 0) {
                CqVector3D pn = new CqVector3D();
                apParams[cParams].GetPoint(pn, __iGrid);
                res = PublicFunctions.VMIN(res, pn);
            }
            Result.SetPoint(res, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_pmax(IqShaderData a, IqShaderData b, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(211);
        boolean __fVarying = false;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = b.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_a = new CqVector3D();
            a.GetPoint(_aq_a, __iGrid);
            CqVector3D _aq_b = new CqVector3D();
            b.GetPoint(_aq_b, __iGrid);
            CqVector3D res = PublicFunctions.VMAX(_aq_a, _aq_b);
            while (cParams-- > 0) {
                CqVector3D pn = new CqVector3D();
                apParams[cParams].GetPoint(pn, __iGrid);
                res = PublicFunctions.VMAX(res, pn);
            }
            Result.SetPoint(res, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_cmin(IqShaderData a, IqShaderData b, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(125);
        boolean __fVarying = false;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = b.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqColor _aq_a = new CqColor();
            a.GetColor(_aq_a, __iGrid);
            CqColor _aq_b = new CqColor();
            b.GetColor(_aq_b, __iGrid);
            CqColor res = PublicFunctions.CMIN(_aq_a, _aq_b);
            while (cParams-- > 0) {
                CqColor cn = new CqColor();
                apParams[cParams].GetColor(cn, __iGrid);
                res = PublicFunctions.CMIN(res, cn);
            }
            Result.SetColor(res, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_cmax(IqShaderData a, IqShaderData b, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(124);
        boolean __fVarying = false;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = b.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqColor _aq_a = new CqColor();
            a.GetColor(_aq_a, __iGrid);
            CqColor _aq_b = new CqColor();
            b.GetColor(_aq_b, __iGrid);
            CqColor res = PublicFunctions.CMAX(_aq_a, _aq_b);
            while (cParams-- > 0) {
                CqColor cn = new CqColor();
                apParams[cParams].GetColor(cn, __iGrid);
                res = PublicFunctions.CMAX(res, cn);
            }
            Result.SetColor(res, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_clamp(IqShaderData a, IqShaderData _min, IqShaderData _max, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(123);
        boolean __fVarying = false;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = _min.Class().getValue() == 3 || __fVarying;
        __fVarying = _max.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_a = new p_float();
            a.GetFloat(_aq_a, __iGrid);
            p_float _aq__min = new p_float();
            _min.GetFloat(_aq__min, __iGrid);
            p_float _aq__max = new p_float();
            _max.GetFloat(_aq__max, __iGrid);
            Result.SetFloat(PublicFunctions.CLAMP(_aq_a.value, _aq__min.value, _aq__max.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_pclamp(IqShaderData a, IqShaderData _min, IqShaderData _max, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(209);
        boolean __fVarying = false;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = _min.Class().getValue() == 3 || __fVarying;
        __fVarying = _max.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_a = new CqVector3D();
            a.GetPoint(_aq_a, __iGrid);
            CqVector3D _aq__min = new CqVector3D();
            _min.GetPoint(_aq__min, __iGrid);
            CqVector3D _aq__max = new CqVector3D();
            _max.GetPoint(_aq__max, __iGrid);
            Result.SetPoint(PublicFunctions.VCLAMP(_aq_a, _aq__min, _aq__max), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_cclamp(IqShaderData a, IqShaderData _min, IqShaderData _max, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(122);
        boolean __fVarying = false;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = _min.Class().getValue() == 3 || __fVarying;
        __fVarying = _max.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqColor _aq_a = new CqColor();
            a.GetColor(_aq_a, __iGrid);
            CqColor _aq__min = new CqColor();
            _min.GetColor(_aq__min, __iGrid);
            CqColor _aq__max = new CqColor();
            _max.GetColor(_aq__max, __iGrid);
            Result.SetColor(PublicFunctions.CCLAMP(_aq_a, _aq__min, _aq__max), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_floor(IqShaderData x, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(165);
        boolean __fVarying = false;
        __fVarying = x.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_x = new p_float();
            x.GetFloat(_aq_x, __iGrid);
            Result.SetFloat((float)Math.floor(_aq_x.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_ceil(IqShaderData x, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(119);
        boolean __fVarying = false;
        __fVarying = x.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_x = new p_float();
            x.GetFloat(_aq_x, __iGrid);
            Result.SetFloat((float)Math.ceil(_aq_x.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_round(IqShaderData x, IqShaderData Result, IqShader pShader) {
        boolean __fVarying = false;
        __fVarying = x.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_x = new p_float();
            x.GetFloat(_aq_x, __iGrid);
            float res = _aq_x.value >= 0.0f ? (float)((int)(_aq_x.value + 0.5f)) : (float)((int)Math.ceil(_aq_x.value - 0.5f));
            Result.SetFloat(res, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_step(IqShaderData _min, IqShaderData value, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(256);
        boolean __fVarying = false;
        __fVarying = _min.Class().getValue() == 3 || __fVarying;
        __fVarying = value.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq__min = new p_float();
            _min.GetFloat(_aq__min, __iGrid);
            p_float _aq_value = new p_float();
            value.GetFloat(_aq_value, __iGrid);
            Result.SetFloat(_aq_value.value < _aq__min.value ? 0.0f : 1.0f, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_smoothstep(IqShaderData _min, IqShaderData _max, IqShaderData value, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(249);
        boolean __fVarying = false;
        __fVarying = value.Class().getValue() == 3 || __fVarying;
        __fVarying = _min.Class().getValue() == 3 || __fVarying;
        __fVarying = _max.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq__min = new p_float();
            _min.GetFloat(_aq__min, __iGrid);
            p_float _aq__max = new p_float();
            _max.GetFloat(_aq__max, __iGrid);
            p_float _aq_value = new p_float();
            value.GetFloat(_aq_value, __iGrid);
            if (_aq_value.value < _aq__min.value) {
                Result.SetFloat(0.0f, __iGrid);
                continue;
            }
            if (_aq_value.value >= _aq__max.value) {
                Result.SetFloat(1.0f, __iGrid);
                continue;
            }
            float v = (_aq_value.value - _aq__min.value) / (_aq__max.value - _aq__min.value);
            Result.SetFloat(v * v * (3.0f - 2.0f * v), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_fspline(IqShaderData value, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(178);
        boolean __fVarying = false;
        CqSplineCubic spline = new CqSplineCubic(cParams);
        spline.SetBasis("catmull-rom");
        __fVarying = value.Class().getValue() == 3 || __fVarying;
        int v = 0;
        while (v < cParams) {
            __fVarying = apParams[v].Class().getValue() == 3 || __fVarying;
            ++v;
        }
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_value = new p_float();
            value.GetFloat(_aq_value, __iGrid);
            if (_aq_value.value >= 1.0f) {
                p_float fl = new p_float();
                apParams[cParams - 2].GetFloat(fl, __iGrid);
                Result.SetFloat(fl.value, __iGrid);
                continue;
            }
            if (_aq_value.value <= 0.0f) {
                p_float ff = new p_float();
                apParams[1].GetFloat(ff, __iGrid);
                Result.SetFloat(ff.value, __iGrid);
                continue;
            }
            int j = 0;
            while (j < cParams) {
                p_float fn = new p_float();
                apParams[j].GetFloat(fn, __iGrid);
                spline.valueAt(j).assignment(new CqVector4D(fn.value, 0.0f, 0.0f, 1.0f));
                ++j;
            }
            CqVector4D res = spline.Evaluate(_aq_value.value);
            Result.SetFloat(res.x, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_cspline(IqShaderData value, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(138);
        boolean __fVarying = false;
        CqSplineCubic spline = new CqSplineCubic(cParams);
        __fVarying = value.Class().getValue() == 3 || __fVarying;
        int v = 0;
        while (v < cParams) {
            __fVarying = apParams[v].Class().getValue() == 3 || __fVarying;
            ++v;
        }
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_value = new p_float();
            value.GetFloat(_aq_value, __iGrid);
            if (_aq_value.value >= 1.0f) {
                CqColor cl = new CqColor();
                apParams[cParams - 2].GetColor(cl, __iGrid);
                Result.SetColor(cl, __iGrid);
                continue;
            }
            if (_aq_value.value <= 0.0f) {
                CqColor cf = new CqColor();
                apParams[1].GetColor(cf, __iGrid);
                Result.SetColor(cf, __iGrid);
                continue;
            }
            int j = 0;
            while (j < cParams) {
                CqColor cn = new CqColor();
                apParams[j].GetColor(cn, __iGrid);
                spline.valueAt(j).assignment(new CqVector4D(cn.fRed(), cn.fGreen(), cn.fBlue(), 1.0f));
                ++j;
            }
            CqVector4D res = spline.Evaluate(_aq_value.value);
            Result.SetColor(new CqColor(res.x, res.y, res.z), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_pspline(IqShaderData value, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(225);
        boolean __fVarying = false;
        CqSplineCubic spline = new CqSplineCubic(cParams);
        __fVarying = value.Class().getValue() == 3 || __fVarying;
        int v = 0;
        while (v < cParams) {
            __fVarying = apParams[v].Class().getValue() == 3 || __fVarying;
            ++v;
        }
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_value = new p_float();
            value.GetFloat(_aq_value, __iGrid);
            if (_aq_value.value >= 1.0f) {
                CqVector3D pl = new CqVector3D();
                apParams[cParams - 2].GetPoint(pl, __iGrid);
                Result.SetPoint(pl, __iGrid);
                continue;
            }
            if (_aq_value.value <= 0.0f) {
                CqVector3D pf = new CqVector3D();
                apParams[1].GetPoint(pf, __iGrid);
                Result.SetPoint(pf, __iGrid);
                continue;
            }
            int j = 0;
            while (j < cParams) {
                CqVector3D pn = new CqVector3D();
                apParams[j].GetPoint(pn, __iGrid);
                spline.valueAt(j).assignment(pn);
                ++j;
            }
            CqVector3D res = new CqVector3D(spline.Evaluate(_aq_value.value));
            Result.SetPoint(res, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_sfspline(IqShaderData basis, IqShaderData value, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(241);
        boolean __fVarying = false;
        CqSplineCubic spline = new CqSplineCubic(cParams);
        __fVarying = value.Class().getValue() == 3 || __fVarying;
        int v = 0;
        while (v < cParams) {
            __fVarying = apParams[v].Class().getValue() == 3 || __fVarying;
            ++v;
        }
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        p_String _aq_basis = new p_String();
        basis.GetString(_aq_basis, __iGrid);
        spline.SetBasis(_aq_basis.value);
        __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_value = new p_float();
            value.GetFloat(_aq_value, __iGrid);
            if (_aq_value.value >= 1.0f) {
                p_float fl = new p_float();
                apParams[cParams - 2].GetFloat(fl, __iGrid);
                Result.SetFloat(fl.value, __iGrid);
                continue;
            }
            if (_aq_value.value <= 0.0f) {
                p_float ff = new p_float();
                apParams[1].GetFloat(ff, __iGrid);
                Result.SetFloat(ff.value, __iGrid);
                continue;
            }
            int j = 0;
            while (j < cParams) {
                p_float fn = new p_float();
                apParams[j].GetFloat(fn, __iGrid);
                spline.valueAt(j).assignment(new CqVector4D(fn.value, 0.0f, 0.0f, 1.0f));
                ++j;
            }
            CqVector4D res = spline.Evaluate(_aq_value.value);
            Result.SetFloat(res.x, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_scspline(IqShaderData basis, IqShaderData value, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(234);
        boolean __fVarying = false;
        CqSplineCubic spline = new CqSplineCubic(cParams);
        __fVarying = value.Class().getValue() == 3 || __fVarying;
        int v = 0;
        while (v < cParams) {
            __fVarying = apParams[v].Class().getValue() == 3 || __fVarying;
            ++v;
        }
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        p_String _aq_basis = new p_String();
        basis.GetString(_aq_basis, __iGrid);
        spline.SetBasis(_aq_basis.value);
        __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_value = new p_float();
            value.GetFloat(_aq_value, __iGrid);
            if (_aq_value.value >= 1.0f) {
                CqColor cl = new CqColor();
                apParams[cParams - 2].GetColor(cl, __iGrid);
                Result.SetColor(cl, __iGrid);
                continue;
            }
            if (_aq_value.value <= 0.0f) {
                CqColor cf = new CqColor();
                apParams[1].GetColor(cf, __iGrid);
                Result.SetColor(cf, __iGrid);
                continue;
            }
            int j = 0;
            while (j < cParams) {
                CqColor cn = new CqColor();
                apParams[j].GetColor(cn, __iGrid);
                spline.valueAt(j).assignment(new CqVector4D(cn.fRed(), cn.fGreen(), cn.fBlue(), 1.0f));
                ++j;
            }
            CqVector4D res = spline.Evaluate(_aq_value.value);
            Result.SetColor(new CqColor(res.x, res.y, res.z), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_spspline(IqShaderData basis, IqShaderData value, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(253);
        boolean __fVarying = false;
        CqSplineCubic spline = new CqSplineCubic(cParams);
        __fVarying = value.Class().getValue() == 3 || __fVarying;
        int v = 0;
        while (v < cParams) {
            __fVarying = apParams[v].Class().getValue() == 3 || __fVarying;
            ++v;
        }
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        p_String _aq_basis = new p_String();
        basis.GetString(_aq_basis, __iGrid);
        spline.SetBasis(_aq_basis.value);
        __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_value = new p_float();
            value.GetFloat(_aq_value, __iGrid);
            if (_aq_value.value >= 1.0f) {
                CqVector3D pl = new CqVector3D();
                apParams[cParams - 2].GetPoint(pl, __iGrid);
                Result.SetPoint(pl, __iGrid);
                continue;
            }
            if (_aq_value.value <= 0.0f) {
                CqVector3D pf = new CqVector3D();
                apParams[1].GetPoint(pf, __iGrid);
                Result.SetPoint(pf, __iGrid);
                continue;
            }
            int j = 0;
            while (j < cParams) {
                CqVector3D pn = new CqVector3D();
                apParams[j].GetPoint(pn, __iGrid);
                spline.valueAt(j).assignment(pn);
                ++j;
            }
            CqVector3D res = new CqVector3D(spline.Evaluate(_aq_value.value));
            Result.SetPoint(res, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_fDu(IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(153);
        float Deffloat = 0.0f;
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            Result.SetFloat(RiGlobal.SO_DuType_TqFloat(p, __iGrid, this, Deffloat), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_fDv(IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(154);
        float Deffloat = 0.0f;
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            Result.SetFloat(RiGlobal.SO_DvType_TqFloat(p, __iGrid, this, Deffloat), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_fDeriv(IqShaderData p, IqShaderData den, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(152);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = den.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            Result.SetFloat(RiGlobal.SO_DerivType_TqFloat(p, den, __iGrid, this), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_cDu(IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(112);
        CqColor Defcol = new CqColor(0.0f, 0.0f, 0.0f);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            Result.SetColor(RiGlobal.SO_DuType_CqColor(p, __iGrid, this, Defcol), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_cDv(IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(113);
        CqColor Defcol = new CqColor(0.0f, 0.0f, 0.0f);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            Result.SetColor(RiGlobal.SO_DvType_CqColor(p, __iGrid, this, Defcol), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_cDeriv(IqShaderData p, IqShaderData den, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(111);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = den.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            Result.SetColor(RiGlobal.SO_DerivType_CqColor(p, den, __iGrid, this), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_pDu(IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(203);
        CqVector3D Defvec = new CqVector3D(0.0f, 0.0f, 0.0f);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            Result.SetPoint(RiGlobal.SO_DuType_CqVector3D(p, __iGrid, this, Defvec), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_pDv(IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(204);
        CqVector3D Defvec = new CqVector3D(0.0f, 0.0f, 0.0f);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            Result.SetPoint(RiGlobal.SO_DvType_CqVector3D(p, __iGrid, this, Defvec), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_pDeriv(IqShaderData p, IqShaderData den, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(202);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = den.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            Result.SetPoint(RiGlobal.SO_DerivType_CqVector3D(p, den, __iGrid, this), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_frandom(IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(176);
        boolean __fVarying = false;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            Result.SetFloat(m_random.RandomFloat(), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_crandom(IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(137);
        boolean __fVarying = false;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            float a = m_random.RandomFloat();
            float b = m_random.RandomFloat();
            float c = m_random.RandomFloat();
            Result.SetColor(new CqColor(a, b, c), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_prandom(IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(223);
        boolean __fVarying = false;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            float a = m_random.RandomFloat();
            float b = m_random.RandomFloat();
            float c = m_random.RandomFloat();
            Result.SetPoint(new CqVector3D(a, b, c), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_fnoise1(IqShaderData v, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(167);
        boolean __fVarying = false;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            Result.SetFloat((m_noise.FGNoise1(_aq_v.value) + 1.0f) / 2.0f, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_fnoise2(IqShaderData u, IqShaderData v, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(168);
        boolean __fVarying = false;
        __fVarying = u.Class().getValue() == 3 || __fVarying;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_u = new p_float();
            u.GetFloat(_aq_u, __iGrid);
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            Result.SetFloat((m_noise.FGNoise2(_aq_u.value, _aq_v.value) + 1.0f) / 2.0f, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_fnoise3(IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(169);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            Result.SetFloat((m_noise.FGNoise3(_aq_p) + 1.0f) / 2.0f, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_fnoise4(IqShaderData p, IqShaderData t, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(170);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = t.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            p_float _aq_t = new p_float();
            t.GetFloat(_aq_t, __iGrid);
            Result.SetFloat((m_noise.FGNoise3(_aq_p) + 1.0f) / 2.0f, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_cnoise1(IqShaderData v, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(127);
        boolean __fVarying = false;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            Result.SetColor(m_noise.CGNoise1(_aq_v.value).add(1.0f).div(2.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_cnoise2(IqShaderData u, IqShaderData v, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(128);
        boolean __fVarying = false;
        __fVarying = u.Class().getValue() == 3 || __fVarying;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_u = new p_float();
            u.GetFloat(_aq_u, __iGrid);
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            Result.SetColor(m_noise.CGNoise2(_aq_u.value, _aq_v.value).add(1.0f).div(2.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_cnoise3(IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(129);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            Result.SetColor(m_noise.CGNoise3(_aq_p).add(1.0f).div(2.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_cnoise4(IqShaderData p, IqShaderData t, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(130);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = t.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            p_float _aq_t = new p_float();
            t.GetFloat(_aq_t, __iGrid);
            Result.SetColor(m_noise.CGNoise3(_aq_p).add(1.0f).div(2.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_pnoise1(IqShaderData v, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(214);
        boolean __fVarying = false;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            Result.SetPoint(m_noise.PGNoise1(_aq_v.value).add(1.0f).div(2.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_pnoise2(IqShaderData u, IqShaderData v, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(215);
        boolean __fVarying = false;
        __fVarying = u.Class().getValue() == 3 || __fVarying;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_u = new p_float();
            u.GetFloat(_aq_u, __iGrid);
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            Result.SetPoint(m_noise.PGNoise2(_aq_u.value, _aq_v.value).add(1.0f).div(2.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_pnoise3(IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(216);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            Result.SetPoint(m_noise.PGNoise3(_aq_p).add(1.0f).div(2.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_pnoise4(IqShaderData p, IqShaderData t, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(217);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = t.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            p_float _aq_t = new p_float();
            t.GetFloat(_aq_t, __iGrid);
            Result.SetPoint(m_noise.PGNoise3(_aq_p).add(1.0f).div(2.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_setcomp(IqShaderData p, IqShaderData index, IqShaderData v, IqShader pShader) {
        CqStats.STATS_INC(236);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = index.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqColor _aq_p = new CqColor();
            p.GetColor(_aq_p, __iGrid);
            p_float _aq_index = new p_float();
            index.GetFloat(_aq_index, __iGrid);
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            _aq_p.setValueAt((int)_aq_index.value, _aq_v.value);
            p.SetColor(_aq_p, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_setxcomp(IqShaderData p, IqShaderData v, IqShader pShader) {
        CqStats.STATS_INC(238);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            _aq_p.x = _aq_v.value;
            p.SetPoint(_aq_p, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_setycomp(IqShaderData p, IqShaderData v, IqShader pShader) {
        CqStats.STATS_INC(239);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            _aq_p.y = _aq_v.value;
            p.SetPoint(_aq_p, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_setzcomp(IqShaderData p, IqShaderData v, IqShader pShader) {
        CqStats.STATS_INC(240);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            _aq_p.z = _aq_v.value;
            p.SetPoint(_aq_p, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_length(IqShaderData V, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(187);
        boolean __fVarying = false;
        __fVarying = V.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_V = new CqVector3D();
            V.GetVector(_aq_V, __iGrid);
            Result.SetFloat(_aq_V.Magnitude(), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_distance(IqShaderData P1, IqShaderData P2, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(149);
        boolean __fVarying = false;
        __fVarying = P1.Class().getValue() == 3 || __fVarying;
        __fVarying = P2.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_P1 = new CqVector3D();
            P1.GetPoint(_aq_P1, __iGrid);
            CqVector3D _aq_P2 = new CqVector3D();
            P2.GetPoint(_aq_P2, __iGrid);
            Result.SetFloat(_aq_P1.sub(_aq_P2).Magnitude(), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_area(IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(104);
        CqVector3D Defvec = new CqVector3D(0.0f, 0.0f, 0.0f);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid) || this.m_pAttributes == null) continue;
            p_float fdu = new p_float();
            p_float fdv = new p_float();
            this.du().GetFloat(fdu, __iGrid);
            this.dv().GetFloat(fdv, __iGrid);
            CqVector3D vecR = RiGlobal.SO_DuType_CqVector3D(p, __iGrid, this, Defvec).mul(fdu.value).mod(RiGlobal.SO_DvType_CqVector3D(p, __iGrid, this, Defvec).mul(fdv.value));
            Result.SetFloat(vecR.Magnitude(), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_normalize(IqShaderData V, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(197);
        boolean __fVarying = false;
        __fVarying = V.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_V = new CqVector3D();
            V.GetVector(_aq_V, __iGrid);
            _aq_V.Unit();
            Result.SetVector(_aq_V, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_faceforward(IqShaderData N, IqShaderData I, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(155);
        boolean __fVarying = false;
        __fVarying = N.Class().getValue() == 3 || __fVarying;
        __fVarying = I.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_N = new CqVector3D();
            N.GetNormal(_aq_N, __iGrid);
            CqVector3D _aq_I = new CqVector3D();
            I.GetVector(_aq_I, __iGrid);
            CqVector3D Nref = new CqVector3D();
            this.Ng().GetNormal(Nref, __iGrid);
            float s = _aq_I.negative().mul(Nref) < 0.0f ? -1.0f : 1.0f;
            Result.SetNormal(_aq_N.mul(s), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_faceforward2(IqShaderData N, IqShaderData I, IqShaderData Nref, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(156);
        boolean __fVarying = false;
        __fVarying = N.Class().getValue() == 3 || __fVarying;
        __fVarying = I.Class().getValue() == 3 || __fVarying;
        __fVarying = Nref.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_N = new CqVector3D();
            N.GetNormal(_aq_N, __iGrid);
            CqVector3D _aq_I = new CqVector3D();
            I.GetVector(_aq_I, __iGrid);
            CqVector3D _aq_Nref = new CqVector3D();
            Nref.GetNormal(_aq_Nref, __iGrid);
            float s = _aq_I.negative().mul(_aq_Nref) < 0.0f ? -1.0f : 1.0f;
            Result.SetNormal(_aq_N.mul(s), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_reflect(IqShaderData I, IqShaderData N, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(229);
        boolean __fVarying = false;
        __fVarying = I.Class().getValue() == 3 || __fVarying;
        __fVarying = N.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_I = new CqVector3D();
            I.GetVector(_aq_I, __iGrid);
            CqVector3D _aq_N = new CqVector3D();
            N.GetNormal(_aq_N, __iGrid);
            float idn = 2.0f * _aq_I.mul(_aq_N);
            CqVector3D res = _aq_I.sub(_aq_N.mul(idn));
            Result.SetVector(res, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_refract(IqShaderData I, IqShaderData N, IqShaderData eta, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(230);
        boolean __fVarying = false;
        __fVarying = I.Class().getValue() == 3 || __fVarying;
        __fVarying = N.Class().getValue() == 3 || __fVarying;
        __fVarying = eta.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_I = new CqVector3D();
            I.GetVector(_aq_I, __iGrid);
            CqVector3D _aq_N = new CqVector3D();
            N.GetNormal(_aq_N, __iGrid);
            p_float _aq_eta = new p_float();
            eta.GetFloat(_aq_eta, __iGrid);
            float IdotN = _aq_I.mul(_aq_N);
            float feta = _aq_eta.value;
            float k = 1.0f - feta * feta * (1.0f - IdotN * IdotN);
            Result.SetVector(k < 0.0f ? new CqVector3D(0.0f, 0.0f, 0.0f) : new CqVector3D(_aq_I.mul(feta).sub(_aq_N.mul(feta * IdotN + (float)Math.sqrt(k)))), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_fresnel(IqShaderData I, IqShaderData N, IqShaderData eta, IqShaderData Kr, IqShaderData Kt, IqShader pShader) {
        CqStats.STATS_INC(177);
        boolean __fVarying = false;
        __fVarying = I.Class().getValue() == 3 || __fVarying;
        __fVarying = N.Class().getValue() == 3 || __fVarying;
        __fVarying = eta.Class().getValue() == 3 || __fVarying;
        __fVarying = Kr.Class().getValue() == 3 || __fVarying;
        __fVarying = Kt.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_I = new CqVector3D();
            I.GetVector(_aq_I, __iGrid);
            CqVector3D _aq_N = new CqVector3D();
            N.GetNormal(_aq_N, __iGrid);
            p_float _aq_eta = new p_float();
            eta.GetFloat(_aq_eta, __iGrid);
            p_float _aq_Kr = new p_float();
            Kr.GetFloat(_aq_Kr, __iGrid);
            p_float _aq_Kt = new p_float();
            Kt.GetFloat(_aq_Kt, __iGrid);
            float cos_theta = _aq_I.negative().mul(_aq_N);
            float fuvA = 1.0f / _aq_eta.value * (1.0f / _aq_eta.value) - (1.0f - cos_theta * cos_theta);
            float fuvB = Math.abs(fuvA);
            float fu2 = (fuvA + fuvB) / 2.0f;
            float fv2 = (-fuvA + fuvB) / 2.0f;
            float fv2sqrt = fv2 == 0.0f ? 0.0f : (float)Math.sqrt(Math.abs(fv2));
            float fu2sqrt = fu2 == 0.0f ? 0.0f : (float)Math.sqrt(Math.abs(fu2));
            float fperp2 = ((cos_theta - fu2sqrt) * (cos_theta - fu2sqrt) + fv2) / ((cos_theta + fu2sqrt) * (cos_theta + fu2sqrt) + fv2);
            float feta = _aq_eta.value;
            float fpara2 = ((1.0f / feta * (1.0f / feta) * cos_theta - fu2sqrt) * (1.0f / feta * (1.0f / feta) * cos_theta - fu2sqrt) + -fv2sqrt * -fv2sqrt) / ((1.0f / feta * (1.0f / feta) * cos_theta + fu2sqrt) * (1.0f / feta * (1.0f / feta) * cos_theta + fu2sqrt) + fv2sqrt * fv2sqrt);
            float __Kr = 0.5f * (fperp2 + fpara2);
            Kr.SetFloat(__Kr, __iGrid);
            Kt.SetFloat(1.0f - __Kr, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_fresnel(IqShaderData I, IqShaderData N, IqShaderData eta, IqShaderData Kr, IqShaderData Kt, IqShaderData R, IqShaderData T, IqShader pShader) {
        CqStats.STATS_INC(177);
        boolean __fVarying = false;
        __fVarying = I.Class().getValue() == 3 || __fVarying;
        __fVarying = N.Class().getValue() == 3 || __fVarying;
        __fVarying = eta.Class().getValue() == 3 || __fVarying;
        __fVarying = Kr.Class().getValue() == 3 || __fVarying;
        __fVarying = Kt.Class().getValue() == 3 || __fVarying;
        __fVarying = R.Class().getValue() == 3 || __fVarying;
        __fVarying = T.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_I = new CqVector3D();
            I.GetVector(_aq_I, __iGrid);
            CqVector3D _aq_N = new CqVector3D();
            N.GetNormal(_aq_N, __iGrid);
            p_float _aq_eta = new p_float();
            eta.GetFloat(_aq_eta, __iGrid);
            p_float _aq_Kr = new p_float();
            Kr.GetFloat(_aq_Kr, __iGrid);
            p_float _aq_Kt = new p_float();
            Kt.GetFloat(_aq_Kt, __iGrid);
            CqVector3D _aq_R = new CqVector3D();
            R.GetVector(_aq_R, __iGrid);
            CqVector3D _aq_T = new CqVector3D();
            T.GetVector(_aq_T, __iGrid);
            float cos_theta = _aq_I.negative().mul(_aq_N);
            float fuvA = 1.0f / _aq_eta.value * (1.0f / _aq_eta.value) - (1.0f - cos_theta * cos_theta);
            float fuvB = Math.abs(fuvA);
            float fu2 = (fuvA + fuvB) / 2.0f;
            float fv2 = (-fuvA + fuvB) / 2.0f;
            float feta = _aq_eta.value;
            float fv2sqrt = fv2 == 0.0f ? 0.0f : (float)Math.sqrt(Math.abs(fv2));
            float fu2sqrt = fu2 == 0.0f ? 0.0f : (float)Math.sqrt(Math.abs(fu2));
            float fperp2 = ((cos_theta - fu2sqrt) * (cos_theta - fu2sqrt) + fv2) / ((cos_theta + fu2sqrt) * (cos_theta + fu2sqrt) + fv2);
            float fpara2 = ((1.0f / feta * (1.0f / feta) * cos_theta - fu2sqrt) * (1.0f / feta * (1.0f / feta) * cos_theta - fu2sqrt) + -fv2sqrt * -fv2sqrt) / ((1.0f / feta * (1.0f / feta) * cos_theta + fu2sqrt) * (1.0f / feta * (1.0f / feta) * cos_theta + fu2sqrt) + fv2sqrt * fv2sqrt);
            float __Kr = 0.5f * (fperp2 + fpara2);
            Kr.SetFloat(__Kr, __iGrid);
            Kt.SetFloat(1.0f - __Kr, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
        this.SO_reflect(I, N, R);
        this.SO_refract(I, N, eta, T);
    }

    @Override
    public void SO_transform(IqShaderData fromspace, IqShaderData tospace, IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(261);
        boolean __fVarying = false;
        assert (pShader != null);
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        boolean bl = __fVarying = Result.Class().getValue() == 3 || __fVarying;
        if (RiGlobal.QGetRenderContextI() != null) {
            int __iGrid = 0;
            p_String _aq_fromspace = new p_String();
            fromspace.GetString(_aq_fromspace, __iGrid);
            p_String _aq_tospace = new p_String();
            tospace.GetString(_aq_tospace, __iGrid);
            CqMatrix mat = RiGlobal.QGetRenderContextI().matSpaceToSpace(_aq_fromspace.value, _aq_tospace.value, pShader.matCurrent(), this.matObjectToWorld(), RiGlobal.QGetRenderContextI().Time());
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                CqVector3D _aq_p = new CqVector3D();
                p.GetPoint(_aq_p, __iGrid);
                Result.SetPoint(mat.multiply(_aq_p), __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        } else {
            int __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                CqVector3D _aq_p = new CqVector3D();
                p.GetPoint(_aq_p, __iGrid);
                Result.SetPoint(_aq_p, __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        }
    }

    @Override
    public void SO_transform(IqShaderData tospace, IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(261);
        boolean __fVarying = false;
        assert (pShader != null);
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        boolean bl = __fVarying = Result.Class().getValue() == 3 || __fVarying;
        if (RiGlobal.QGetRenderContextI() != null) {
            int __iGrid = 0;
            p_String _aq_tospace = new p_String();
            tospace.GetString(_aq_tospace, __iGrid);
            CqMatrix mat = RiGlobal.QGetRenderContextI().matSpaceToSpace("current", _aq_tospace.value, pShader.matCurrent(), this.matObjectToWorld(), RiGlobal.QGetRenderContextI().Time());
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                CqVector3D _aq_p = new CqVector3D();
                p.GetPoint(_aq_p, __iGrid);
                Result.SetPoint(mat.multiply(_aq_p), __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        } else {
            int __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                CqVector3D _aq_p = new CqVector3D();
                p.GetPoint(_aq_p, __iGrid);
                Result.SetPoint(_aq_p, __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        }
    }

    @Override
    public void SO_transformm(IqShaderData tospace, IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(261);
        boolean __fVarying = false;
        assert (pShader != null);
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqMatrix _aq_tospace = new CqMatrix();
            tospace.GetMatrix(_aq_tospace, __iGrid);
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            Result.SetPoint(_aq_tospace.multiply(_aq_p), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_vtransform(IqShaderData fromspace, IqShaderData tospace, IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(263);
        boolean __fVarying = false;
        assert (pShader != null);
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        boolean bl = __fVarying = Result.Class().getValue() == 3 || __fVarying;
        if (RiGlobal.QGetRenderContextI() != null) {
            int __iGrid = 0;
            p_String _aq_fromspace = new p_String();
            fromspace.GetString(_aq_fromspace, __iGrid);
            p_String _aq_tospace = new p_String();
            tospace.GetString(_aq_tospace, __iGrid);
            CqMatrix mat = RiGlobal.QGetRenderContextI().matVSpaceToSpace(_aq_fromspace.value, _aq_tospace.value, pShader.matCurrent(), this.matObjectToWorld(), RiGlobal.QGetRenderContextI().Time());
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                CqVector3D _aq_p = new CqVector3D();
                p.GetVector(_aq_p, __iGrid);
                Result.SetVector(mat.multiply(_aq_p), __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        } else {
            int __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                CqVector3D _aq_p = new CqVector3D();
                p.GetVector(_aq_p, __iGrid);
                Result.SetVector(_aq_p, __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        }
    }

    @Override
    public void SO_vtransform(IqShaderData tospace, IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(263);
        boolean __fVarying = false;
        assert (pShader != null);
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        boolean bl = __fVarying = Result.Class().getValue() == 3 || __fVarying;
        if (RiGlobal.QGetRenderContextI() != null) {
            int __iGrid = 0;
            p_String _aq_tospace = new p_String();
            tospace.GetString(_aq_tospace, __iGrid);
            CqMatrix mat = RiGlobal.QGetRenderContextI().matVSpaceToSpace("current", _aq_tospace.value, pShader.matCurrent(), this.matObjectToWorld(), RiGlobal.QGetRenderContextI().Time());
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                CqVector3D _aq_p = new CqVector3D();
                p.GetVector(_aq_p, __iGrid);
                Result.SetVector(mat.multiply(_aq_p), __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        } else {
            int __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                CqVector3D _aq_p = new CqVector3D();
                p.GetVector(_aq_p, __iGrid);
                Result.SetVector(_aq_p, __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        }
    }

    @Override
    public void SO_vtransformm(IqShaderData tospace, IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(263);
        boolean __fVarying = false;
        assert (pShader != null);
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqMatrix _aq_tospace = new CqMatrix();
            tospace.GetMatrix(_aq_tospace, __iGrid);
            CqVector3D _aq_p = new CqVector3D();
            p.GetVector(_aq_p, __iGrid);
            Result.SetVector(_aq_tospace.multiply(_aq_p), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_ntransform(IqShaderData fromspace, IqShaderData tospace, IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(198);
        boolean __fVarying = false;
        assert (pShader != null);
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        boolean bl = __fVarying = Result.Class().getValue() == 3 || __fVarying;
        if (RiGlobal.QGetRenderContextI() != null) {
            int __iGrid = 0;
            p_String _aq_fromspace = new p_String();
            fromspace.GetString(_aq_fromspace, __iGrid);
            p_String _aq_tospace = new p_String();
            tospace.GetString(_aq_tospace, __iGrid);
            CqMatrix mat = RiGlobal.QGetRenderContextI().matNSpaceToSpace(_aq_fromspace.value, _aq_tospace.value, pShader.matCurrent(), this.matObjectToWorld(), RiGlobal.QGetRenderContextI().Time());
            __iGrid = 0;
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                CqVector3D _aq_p = new CqVector3D();
                p.GetNormal(_aq_p, __iGrid);
                Result.SetNormal(mat.multiply(_aq_p), __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        } else {
            int __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                CqVector3D _aq_p = new CqVector3D();
                p.GetNormal(_aq_p, __iGrid);
                Result.SetNormal(_aq_p, __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        }
    }

    @Override
    public void SO_ntransform(IqShaderData tospace, IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(198);
        boolean __fVarying = false;
        assert (pShader != null);
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        boolean bl = __fVarying = Result.Class().getValue() == 3 || __fVarying;
        if (RiGlobal.QGetRenderContextI() != null) {
            int __iGrid = 0;
            p_String _aq_tospace = new p_String();
            tospace.GetString(_aq_tospace, __iGrid);
            CqMatrix mat = RiGlobal.QGetRenderContextI().matNSpaceToSpace("current", _aq_tospace.value, pShader.matCurrent(), this.matObjectToWorld(), RiGlobal.QGetRenderContextI().Time());
            __iGrid = 0;
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                CqVector3D _aq_p = new CqVector3D();
                p.GetNormal(_aq_p, __iGrid);
                Result.SetNormal(mat.multiply(_aq_p), __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        } else {
            int __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                CqVector3D _aq_p = new CqVector3D();
                p.GetNormal(_aq_p, __iGrid);
                Result.SetNormal(_aq_p, __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        }
    }

    @Override
    public void SO_ntransformm(IqShaderData tospace, IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(198);
        boolean __fVarying = false;
        assert (pShader != null);
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqMatrix _aq_tospace = new CqMatrix();
            tospace.GetMatrix(_aq_tospace, __iGrid);
            CqVector3D _aq_p = new CqVector3D();
            p.GetNormal(_aq_p, __iGrid);
            Result.SetNormal(_aq_tospace.multiply(_aq_p), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_depth(IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(145);
        boolean __fVarying = false;
        if (RiGlobal.QGetRenderContextI() == null) {
            return;
        }
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            float d = _aq_p.z;
            d = (d - RiGlobal.QGetRenderContextI().GetFloatOption("System", "Clipping")[0]) / (RiGlobal.QGetRenderContextI().GetFloatOption("System", "Clipping")[1] - RiGlobal.QGetRenderContextI().GetFloatOption("System", "Clipping")[0]);
            Result.SetFloat(d, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_calculatenormal(IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(114);
        boolean __fVarying = false;
        boolean CSO = this.pTransform().GetHandedness(RiGlobal.QGetRenderContextI().Time());
        boolean O = false;
        if (this.pAttributes() != null) {
            O = this.pAttributes().GetIntegerAttribute("System", "Orientation")[0] != 0;
        }
        float neg = 1.0f;
        if (O != CSO) {
            neg = -1.0f;
        }
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D Ret = new CqVector3D();
            CqVector3D Ret2 = new CqVector3D();
            int uRes = this.uGridRes();
            int GridX = __iGrid % (uRes + 1);
            CqVector3D v1 = new CqVector3D();
            CqVector3D v2 = new CqVector3D();
            if (GridX < uRes) {
                p.GetValue(v1, __iGrid + 1);
                p.GetValue(v2, __iGrid);
                Ret = v1.sub(v2);
            } else {
                p.GetValue(v1, __iGrid);
                p.GetValue(v2, __iGrid - 1);
                Ret = v1.sub(v2);
            }
            int vRes = this.vGridRes();
            int GridY = __iGrid / (uRes + 1);
            if (GridY < vRes) {
                p.GetValue(v1, __iGrid + uRes + 1);
                p.GetValue(v2, __iGrid);
                Ret2 = v1.sub(v2);
            } else {
                p.GetValue(v1, __iGrid);
                p.GetValue(v2, __iGrid - (uRes + 1));
                Ret2 = v1.sub(v2);
            }
            CqVector3D N = Ret.mod(Ret2);
            N.Unit();
            N.assignMul(neg);
            Result.SetNormal(N, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_cmix(IqShaderData color0, IqShaderData color1, IqShaderData value, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(126);
        boolean __fVarying = false;
        __fVarying = color0.Class().getValue() == 3 || __fVarying;
        __fVarying = color1.Class().getValue() == 3 || __fVarying;
        __fVarying = value.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqColor _aq_color0 = new CqColor();
            color0.GetColor(_aq_color0, __iGrid);
            CqColor _aq_color1 = new CqColor();
            color1.GetColor(_aq_color1, __iGrid);
            p_float _aq_value = new p_float();
            value.GetFloat(_aq_value, __iGrid);
            CqColor c = _aq_color0.mul(1.0f - _aq_value.value).add(_aq_color1.mul(_aq_value.value));
            Result.SetColor(c, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_fmix(IqShaderData f0, IqShaderData f1, IqShaderData value, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(166);
        boolean __fVarying = false;
        __fVarying = f0.Class().getValue() == 3 || __fVarying;
        __fVarying = f1.Class().getValue() == 3 || __fVarying;
        __fVarying = value.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_f0 = new p_float();
            f0.GetFloat(_aq_f0, __iGrid);
            p_float _aq_f1 = new p_float();
            f1.GetFloat(_aq_f1, __iGrid);
            p_float _aq_value = new p_float();
            value.GetFloat(_aq_value, __iGrid);
            float f = (1.0f - _aq_value.value) * _aq_f0.value + _aq_value.value * _aq_f1.value;
            Result.SetFloat(f, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_pmix(IqShaderData p0, IqShaderData p1, IqShaderData value, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(213);
        boolean __fVarying = false;
        __fVarying = p0.Class().getValue() == 3 || __fVarying;
        __fVarying = p1.Class().getValue() == 3 || __fVarying;
        __fVarying = value.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p0 = new CqVector3D();
            p0.GetPoint(_aq_p0, __iGrid);
            CqVector3D _aq_p1 = new CqVector3D();
            p1.GetPoint(_aq_p1, __iGrid);
            p_float _aq_value = new p_float();
            value.GetFloat(_aq_value, __iGrid);
            CqVector3D p = _aq_p0.mul(1.0f - _aq_value.value).add(_aq_p1.mul(_aq_value.value));
            Result.SetPoint(p, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_vmix(IqShaderData v0, IqShaderData v1, IqShaderData value, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(262);
        boolean __fVarying = false;
        __fVarying = v0.Class().getValue() == 3 || __fVarying;
        __fVarying = v1.Class().getValue() == 3 || __fVarying;
        __fVarying = value.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_v0 = new CqVector3D();
            v0.GetVector(_aq_v0, __iGrid);
            CqVector3D _aq_v1 = new CqVector3D();
            v1.GetVector(_aq_v1, __iGrid);
            p_float _aq_value = new p_float();
            value.GetFloat(_aq_value, __iGrid);
            CqVector3D v = _aq_v0.mul(1.0f - _aq_value.value).add(_aq_v1.mul(_aq_value.value));
            Result.SetVector(v, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_nmix(IqShaderData n0, IqShaderData n1, IqShaderData value, IqShaderData Result, IqShader pShader) {
        boolean __fVarying = false;
        __fVarying = n0.Class().getValue() == 3 || __fVarying;
        __fVarying = n1.Class().getValue() == 3 || __fVarying;
        __fVarying = value.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_n0 = new CqVector3D();
            n0.GetNormal(_aq_n0, __iGrid);
            CqVector3D _aq_n1 = new CqVector3D(9.0f);
            n1.GetNormal(_aq_n1, __iGrid);
            p_float _aq_value = new p_float();
            value.GetFloat(_aq_value, __iGrid);
            CqVector3D n = _aq_n0.mul(1.0f - _aq_value.value).add(_aq_n1.mul(_aq_value.value));
            Result.SetNormal(n, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_ambient(IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(103);
        boolean __fVarying = false;
        if (this.m_pAttributes != null) {
            if (!this.m_IlluminanceCacheValid) {
                this.ValidateIlluminanceCache(null, null, pShader);
            }
            Result.SetColor(RiGlobal.gColBlack);
            int light_index = 0;
            while (light_index < this.m_pAttributes.cLights()) {
                __fVarying = true;
                IqLightsource lp = this.m_pAttributes.pLight(light_index);
                if (lp.pShader().fAmbient()) {
                    int __iGrid = 0;
                    CqBitVector RS = this.RunningState();
                    do {
                        if (__fVarying && !RS.Value(__iGrid)) continue;
                        CqColor _aq_Result = new CqColor();
                        Result.GetColor(_aq_Result, __iGrid);
                        CqColor colCl = new CqColor();
                        if (lp.Cl() != null) {
                            lp.Cl().GetColor(colCl, __iGrid);
                        }
                        Result.SetColor(_aq_Result.add(colCl), __iGrid);
                    } while (++__iGrid < this.GridSize() && __fVarying);
                }
                ++light_index;
            }
        }
    }

    @Override
    public void SO_diffuse(IqShaderData N, IqShaderData Result, IqShader pShader) {
        IqShaderData pDefAngle;
        CqStats.STATS_INC(147);
        boolean __fVarying = false;
        if (!this.m_IlluminanceCacheValid) {
            this.ValidateIlluminanceCache(null, N, pShader);
        }
        if ((pDefAngle = pShader.CreateTemporaryStorage(new EqVariableType(1), new EqVariableClass(2))) == null) {
            return;
        }
        pDefAngle.SetFloat(1.5707964f);
        Result.SetColor(RiGlobal.gColBlack);
        __fVarying = true;
        IqShaderData __nondiffuse = null;
        __nondiffuse = pShader.CreateTemporaryStorage(new EqVariableType(1), new EqVariableClass(3));
        if (this.SO_init_illuminance()) {
            CqVector3D Ln = new CqVector3D();
            CqColor _aq_Result = new CqColor();
            CqVector3D _aq_N = new CqVector3D();
            CqColor colCl = new CqColor();
            IqShader pLightsource = null;
            do {
                p_float __nondiffuse_val = new p_float();
                if (this.m_li < this.m_pAttributes.cLights()) {
                    pLightsource = this.m_pAttributes.pLight(this.m_li).pShader();
                }
                if (pLightsource != null) {
                    pLightsource.GetValue("__nondiffuse", __nondiffuse);
                    if (__nondiffuse != null) {
                        __nondiffuse.GetFloat(__nondiffuse_val, 0);
                        if (__nondiffuse_val.value != 0.0f) continue;
                    }
                }
                this.SO_illuminance(null, null, N, pDefAngle, null);
                this.PushState();
                this.GetCurrentState();
                int __iGrid = 0;
                CqBitVector RS = this.RunningState();
                do {
                    if (__fVarying && !RS.Value(__iGrid)) continue;
                    this.L().GetVector(Ln, __iGrid);
                    Ln.Unit();
                    Result.GetColor(_aq_Result, __iGrid);
                    N.GetNormal(_aq_N, __iGrid);
                    this.Cl().GetColor(colCl, __iGrid);
                    Result.SetColor(_aq_Result.add(colCl.mul(Ln.mul(_aq_N))), __iGrid);
                } while (++__iGrid < this.GridSize() && __fVarying);
                this.PopState();
            } while (this.SO_advance_illuminance());
        }
        pShader.DeleteTemporaryStorage(__nondiffuse);
        pShader.DeleteTemporaryStorage(pDefAngle);
    }

    @Override
    public void SO_specular(IqShaderData N, IqShaderData V, IqShaderData roughness, IqShaderData Result, IqShader pShader) {
        IqShaderData pDefAngle;
        CqStats.STATS_INC(251);
        boolean __fVarying = false;
        if (!this.m_IlluminanceCacheValid) {
            this.ValidateIlluminanceCache(null, N, pShader);
        }
        if ((pDefAngle = pShader.CreateTemporaryStorage(new EqVariableType(1), new EqVariableClass(2))) == null) {
            return;
        }
        pDefAngle.SetFloat(1.5707964f);
        Result.SetColor(RiGlobal.gColBlack);
        __fVarying = true;
        IqShaderData __nonspecular = null;
        __nonspecular = pShader.CreateTemporaryStorage(new EqVariableType(1), new EqVariableClass(3));
        if (this.SO_init_illuminance()) {
            IqShader pLightsource = null;
            do {
                p_float __nonspecular_val = new p_float();
                if (this.m_li < this.m_pAttributes.cLights()) {
                    pLightsource = this.m_pAttributes.pLight(this.m_li).pShader();
                }
                if (pLightsource != null) {
                    pLightsource.GetValue("__nonspecular", __nonspecular);
                    if (__nonspecular != null) {
                        __nonspecular.GetFloat(__nonspecular_val, 0);
                        if (__nonspecular_val.value != 0.0f) continue;
                    }
                }
                this.SO_illuminance(null, null, N, pDefAngle, null);
                this.PushState();
                this.GetCurrentState();
                int __iGrid = 0;
                CqBitVector RS = this.RunningState();
                do {
                    if (__fVarying && !RS.Value(__iGrid)) continue;
                    CqVector3D _aq_V = new CqVector3D();
                    V.GetVector(_aq_V, __iGrid);
                    CqVector3D Ln = new CqVector3D();
                    this.L().GetVector(Ln, __iGrid);
                    Ln.Unit();
                    CqVector3D H = Ln.add(_aq_V);
                    H.Unit();
                    CqColor _aq_Result = new CqColor();
                    Result.GetColor(_aq_Result, __iGrid);
                    CqVector3D _aq_N = new CqVector3D();
                    N.GetNormal(_aq_N, __iGrid);
                    p_float _aq_roughness = new p_float();
                    roughness.GetFloat(_aq_roughness, __iGrid);
                    CqColor colCl = new CqColor();
                    this.Cl().GetColor(colCl, __iGrid);
                    Result.SetColor(_aq_Result.add(colCl.mul((float)Math.pow(Math.max(0.0f, _aq_N.mul(H)), 1.0f / (_aq_roughness.value / 8.0f)))), __iGrid);
                } while (++__iGrid < this.GridSize() && __fVarying);
                this.PopState();
            } while (this.SO_advance_illuminance());
        }
        pShader.DeleteTemporaryStorage(__nonspecular);
        pShader.DeleteTemporaryStorage(pDefAngle);
    }

    @Override
    public void SO_phong(IqShaderData N, IqShaderData V, IqShaderData size, IqShaderData Result, IqShader pShader) {
        IqShaderData pDefAngle;
        CqStats.STATS_INC(210);
        boolean __fVarying = false;
        IqShaderData pnV = pShader.CreateTemporaryStorage(new EqVariableType(9), new EqVariableClass(3));
        IqShaderData pnN = pShader.CreateTemporaryStorage(new EqVariableType(8), new EqVariableClass(3));
        IqShaderData pR = pShader.CreateTemporaryStorage(new EqVariableType(9), new EqVariableClass(3));
        pnV.Initialise(this.uGridRes(), this.vGridRes());
        pnN.Initialise(this.uGridRes(), this.vGridRes());
        pR.Initialise(this.uGridRes(), this.vGridRes());
        this.SO_normalize(V, pnV);
        this.SO_normalize(N, pnN);
        __fVarying = true;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D vecnV = new CqVector3D();
            pnV.GetVector(vecnV, __iGrid);
            pnV.SetVector(vecnV.negative(), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
        this.SO_reflect(pnV, pnN, pR);
        pShader.DeleteTemporaryStorage(pnV);
        pShader.DeleteTemporaryStorage(pnN);
        if (!this.m_IlluminanceCacheValid) {
            this.ValidateIlluminanceCache(null, N, pShader);
        }
        if ((pDefAngle = pShader.CreateTemporaryStorage(new EqVariableType(1), new EqVariableClass(2))) == null) {
            return;
        }
        pDefAngle.SetFloat(1.5707964f);
        Result.SetColor(RiGlobal.gColBlack);
        if (this.SO_init_illuminance()) {
            do {
                this.SO_illuminance(null, null, N, pDefAngle, null);
                this.PushState();
                this.GetCurrentState();
                __iGrid = 0;
                RS = this.RunningState();
                do {
                    if (__fVarying && !RS.Value(__iGrid)) continue;
                    CqVector3D Ln = new CqVector3D();
                    this.L().GetVector(Ln, __iGrid);
                    Ln.Unit();
                    CqColor _aq_Result = new CqColor();
                    Result.GetColor(_aq_Result, __iGrid);
                    CqVector3D vecR = new CqVector3D();
                    pR.GetVector(vecR, __iGrid);
                    p_float _aq_size = new p_float();
                    size.GetFloat(_aq_size, __iGrid);
                    CqColor colCl = new CqColor();
                    this.Cl().GetColor(colCl, __iGrid);
                    Result.SetColor(_aq_Result.add(colCl.mul((float)Math.pow(Math.max(0.0f, vecR.mul(Ln)), _aq_size.value))), __iGrid);
                } while (++__iGrid < this.GridSize() && __fVarying);
                this.PopState();
            } while (this.SO_advance_illuminance());
        }
        pShader.DeleteTemporaryStorage(pDefAngle);
        pShader.DeleteTemporaryStorage(pR);
    }

    @Override
    public void SO_trace(IqShaderData P, IqShaderData R, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(260);
        boolean __fVarying = false;
        __fVarying = P.Class().getValue() == 3 || __fVarying;
        __fVarying = R.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            Result.SetColor(new CqColor(0.0f, 0.0f, 0.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_ftexture1(IqShaderData name, IqShaderData channel, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(180);
        float Deffloat = 0.0f;
        boolean __fVarying = false;
        if (RiGlobal.QGetRenderContextI() == null) {
            return;
        }
        HashMap<String, IqShaderData> paramMap = new HashMap<String, IqShaderData>();
        this.GetTexParams(cParams, apParams, paramMap);
        p_float fill = new p_float(0.0f);
        if (paramMap.containsKey("fill")) {
            paramMap.get("fill").GetFloat(fill);
        }
        int __iGrid = 0;
        p_String _aq_name = new p_String();
        name.GetString(_aq_name, __iGrid);
        p_float _aq_channel = new p_float();
        channel.GetFloat(_aq_channel, __iGrid);
        IqTextureMap pTMap = RiGlobal.QGetRenderContextI().GetTextureMap(_aq_name.value);
        p_float fdu = new p_float(0.0f);
        p_float fdv = new p_float(0.0f);
        if (this.m_pAttributes != null) {
            this.du().GetFloat(fdu);
            this.dv().GetFloat(fdv);
        }
        __fVarying = true;
        if (pTMap != null && pTMap.IsValid()) {
            Valarray val = new Valarray();
            pTMap.PrepareSampleOptions(paramMap);
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                float swidth = 0.0f;
                float twidth = 0.0f;
                if (fdu.value != 0.0f && fdv.value != 0.0f) {
                    float dsdu = RiGlobal.SO_DuType_TqFloat(this.s(), __iGrid, this, Deffloat);
                    swidth = Math.abs(dsdu * fdu.value);
                    float dtdu = RiGlobal.SO_DuType_TqFloat(this.t(), __iGrid, this, Deffloat);
                    twidth = Math.abs(dtdu * fdu.value);
                    float dsdv = RiGlobal.SO_DvType_TqFloat(this.s(), __iGrid, this, Deffloat);
                    swidth += Math.abs(dsdv * fdv.value);
                    float dtdv = RiGlobal.SO_DvType_TqFloat(this.t(), __iGrid, this, Deffloat);
                    twidth += Math.abs(dtdv * fdv.value);
                } else {
                    swidth = (float)(1.0 / (double)pTMap.XRes());
                    twidth = (float)(1.0 / (double)pTMap.YRes());
                }
                p_float fs = new p_float();
                p_float ft = new p_float();
                this.s().GetFloat(fs, __iGrid);
                this.t().GetFloat(ft, __iGrid);
                pTMap.SampleMap(fs.value, ft.value, swidth, twidth, val);
                float fchan = _aq_channel.value;
                if (fchan >= (float)val.size()) {
                    Result.SetFloat(fill.value, __iGrid);
                    continue;
                }
                Result.SetFloat(val.valueAt((int)fchan), __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        } else {
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                Result.SetFloat(0.0f, __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        }
    }

    @Override
    public void SO_ftexture2(IqShaderData name, IqShaderData channel, IqShaderData s, IqShaderData t, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(181);
        float Deffloat = 0.0f;
        boolean __fVarying = false;
        if (RiGlobal.QGetRenderContextI() == null) {
            return;
        }
        HashMap<String, IqShaderData> paramMap = new HashMap<String, IqShaderData>();
        this.GetTexParams(cParams, apParams, paramMap);
        p_float fill = new p_float(0.0f);
        if (paramMap.containsKey("fill")) {
            paramMap.get("fill").GetFloat(fill);
        }
        int __iGrid = 0;
        p_String _aq_name = new p_String();
        name.GetString(_aq_name, __iGrid);
        p_float _aq_channel = new p_float();
        channel.GetFloat(_aq_channel, __iGrid);
        IqTextureMap pTMap = RiGlobal.QGetRenderContextI().GetTextureMap(_aq_name.value);
        p_float fdu = new p_float(0.0f);
        p_float fdv = new p_float(0.0f);
        if (this.m_pAttributes != null) {
            this.du().GetFloat(fdu);
            this.dv().GetFloat(fdv);
        }
        __fVarying = true;
        if (pTMap != null && pTMap.IsValid()) {
            Valarray val = new Valarray();
            pTMap.PrepareSampleOptions(paramMap);
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                float swidth = 0.0f;
                float twidth = 0.0f;
                if (fdu.value != 0.0f && fdv.value != 0.0f) {
                    float dsdu = RiGlobal.SO_DuType_TqFloat(s, __iGrid, this, Deffloat);
                    swidth = Math.abs(dsdu * fdu.value);
                    float dtdu = RiGlobal.SO_DuType_TqFloat(t, __iGrid, this, Deffloat);
                    twidth = Math.abs(dtdu * fdu.value);
                    float dsdv = RiGlobal.SO_DvType_TqFloat(s, __iGrid, this, Deffloat);
                    swidth += Math.abs(dsdv * fdv.value);
                    float dtdv = RiGlobal.SO_DvType_TqFloat(t, __iGrid, this, Deffloat);
                    twidth += Math.abs(dtdv * fdv.value);
                } else {
                    swidth = (float)(1.0 / (double)pTMap.XRes());
                    twidth = (float)(1.0 / (double)pTMap.YRes());
                }
                p_float _aq_s = new p_float();
                s.GetFloat(_aq_s, __iGrid);
                p_float _aq_t = new p_float();
                t.GetFloat(_aq_t, __iGrid);
                pTMap.SampleMap(_aq_s.value, _aq_t.value, swidth, twidth, val);
                float fchan = _aq_channel.value;
                if (fchan >= (float)val.size()) {
                    Result.SetFloat(fill.value, __iGrid);
                    continue;
                }
                Result.SetFloat(val.valueAt((int)fchan), __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        } else {
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                Result.SetFloat(0.0f, __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        }
    }

    @Override
    public void SO_ftexture3(IqShaderData name, IqShaderData channel, IqShaderData s1, IqShaderData t1, IqShaderData s2, IqShaderData t2, IqShaderData s3, IqShaderData t3, IqShaderData s4, IqShaderData t4, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(182);
        boolean __fVarying = false;
        if (RiGlobal.QGetRenderContextI() == null) {
            return;
        }
        HashMap<String, IqShaderData> paramMap = new HashMap<String, IqShaderData>();
        this.GetTexParams(cParams, apParams, paramMap);
        p_float fill = new p_float(0.0f);
        if (paramMap.containsKey("fill")) {
            paramMap.get("fill").GetFloat(fill);
        }
        int __iGrid = 0;
        p_String _aq_name = new p_String();
        name.GetString(_aq_name, __iGrid);
        p_float _aq_channel = new p_float();
        channel.GetFloat(_aq_channel, __iGrid);
        IqTextureMap pTMap = RiGlobal.QGetRenderContextI().GetTextureMap(_aq_name.value);
        __fVarying = true;
        if (pTMap != null && pTMap.IsValid()) {
            Valarray val = new Valarray();
            pTMap.PrepareSampleOptions(paramMap);
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                p_float _aq_s1 = new p_float();
                s1.GetFloat(_aq_s1, __iGrid);
                p_float _aq_t1 = new p_float();
                t1.GetFloat(_aq_t1, __iGrid);
                p_float _aq_s2 = new p_float();
                s2.GetFloat(_aq_s2, __iGrid);
                p_float _aq_t2 = new p_float();
                t2.GetFloat(_aq_t2, __iGrid);
                p_float _aq_s3 = new p_float();
                s3.GetFloat(_aq_s3, __iGrid);
                p_float _aq_t3 = new p_float();
                t3.GetFloat(_aq_t3, __iGrid);
                p_float _aq_s4 = new p_float();
                s4.GetFloat(_aq_s4, __iGrid);
                p_float _aq_t4 = new p_float();
                t4.GetFloat(_aq_t4, __iGrid);
                pTMap.SampleMap(_aq_s1.value, _aq_t1.value, _aq_s2.value, _aq_t2.value, _aq_s3.value, _aq_t3.value, _aq_s4.value, _aq_t4.value, val);
                float fchan = _aq_channel.value;
                if (fchan >= (float)val.size()) {
                    Result.SetFloat(fill.value, __iGrid);
                    continue;
                }
                Result.SetFloat(val.valueAt((int)fchan), __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        } else {
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                Result.SetFloat(0.0f, __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        }
    }

    @Override
    public void SO_ctexture1(IqShaderData name, IqShaderData channel, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(140);
        float Deffloat = 0.0f;
        boolean __fVarying = false;
        if (RiGlobal.QGetRenderContextI() == null) {
            return;
        }
        HashMap<String, IqShaderData> paramMap = new HashMap<String, IqShaderData>();
        this.GetTexParams(cParams, apParams, paramMap);
        p_float fill = new p_float(0.0f);
        if (paramMap.containsKey("fill")) {
            paramMap.get("fill").GetFloat(fill);
        }
        int __iGrid = 0;
        p_String _aq_name = new p_String();
        name.GetString(_aq_name, __iGrid);
        p_float _aq_channel = new p_float();
        channel.GetFloat(_aq_channel, __iGrid);
        IqTextureMap pTMap = RiGlobal.QGetRenderContextI().GetTextureMap(_aq_name.value);
        p_float fdu = new p_float(0.0f);
        p_float fdv = new p_float(0.0f);
        if (this.m_pAttributes != null) {
            this.du().GetFloat(fdu);
            this.dv().GetFloat(fdv);
        }
        __fVarying = true;
        if (pTMap != null && pTMap.IsValid()) {
            Valarray val = new Valarray();
            pTMap.PrepareSampleOptions(paramMap);
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                float swidth = 0.0f;
                float twidth = 0.0f;
                if (fdu.value != 0.0f && fdv.value != 0.0f) {
                    float dsdu = RiGlobal.SO_DuType_TqFloat(this.s(), __iGrid, this, Deffloat);
                    swidth = Math.abs(dsdu * fdu.value);
                    float dsdv = RiGlobal.SO_DvType_TqFloat(this.s(), __iGrid, this, Deffloat);
                    swidth += Math.abs(dsdv * fdv.value);
                    float dtdu = RiGlobal.SO_DuType_TqFloat(this.t(), __iGrid, this, Deffloat);
                    twidth = Math.abs(dtdu * fdu.value);
                    float dtdv = RiGlobal.SO_DvType_TqFloat(this.t(), __iGrid, this, Deffloat);
                    twidth += Math.abs(dtdv * fdv.value);
                } else {
                    swidth = (float)(1.0 / (double)pTMap.XRes());
                    twidth = (float)(1.0 / (double)pTMap.YRes());
                }
                p_float fs = new p_float();
                p_float ft = new p_float();
                this.s().GetFloat(fs, __iGrid);
                this.t().GetFloat(ft, __iGrid);
                pTMap.SampleMap(fs.value, ft.value, swidth, twidth, val);
                float fchan = _aq_channel.value;
                CqColor colResult = new CqColor();
                colResult.SetfRed(fchan >= (float)val.size() ? fill.value : val.valueAt((int)fchan));
                colResult.SetfGreen(fchan + 1.0f >= (float)val.size() ? fill.value : val.valueAt((int)(fchan + 1.0f)));
                colResult.SetfBlue(fchan + 2.0f >= (float)val.size() ? fill.value : val.valueAt((int)(fchan + 2.0f)));
                Result.SetColor(colResult, __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        } else {
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                Result.SetColor(new CqColor(0.0f, 0.0f, 0.0f), __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        }
    }

    @Override
    public void SO_ctexture2(IqShaderData name, IqShaderData channel, IqShaderData s, IqShaderData t, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(141);
        float Deffloat = 0.0f;
        boolean __fVarying = false;
        if (RiGlobal.QGetRenderContextI() == null) {
            return;
        }
        HashMap<String, IqShaderData> paramMap = new HashMap<String, IqShaderData>();
        this.GetTexParams(cParams, apParams, paramMap);
        p_float fill = new p_float(0.0f);
        if (paramMap.containsKey("fill")) {
            paramMap.get("fill").GetFloat(fill);
        }
        int __iGrid = 0;
        p_String _aq_name = new p_String();
        name.GetString(_aq_name, __iGrid);
        p_float _aq_channel = new p_float();
        channel.GetFloat(_aq_channel, __iGrid);
        IqTextureMap pTMap = RiGlobal.QGetRenderContextI().GetTextureMap(_aq_name.value);
        p_float fdu = new p_float(0.0f);
        p_float fdv = new p_float(0.0f);
        if (this.m_pAttributes != null) {
            this.du().GetFloat(fdu);
            this.dv().GetFloat(fdv);
        }
        __fVarying = true;
        if (pTMap != null && pTMap.IsValid()) {
            Valarray val = new Valarray();
            pTMap.PrepareSampleOptions(paramMap);
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                float swidth = 0.0f;
                float twidth = 0.0f;
                if (fdu.value != 0.0f && fdv.value != 0.0f) {
                    float dsdu = RiGlobal.SO_DuType_TqFloat(s, __iGrid, this, Deffloat);
                    swidth = Math.abs(dsdu * fdu.value);
                    float dsdv = RiGlobal.SO_DvType_TqFloat(s, __iGrid, this, Deffloat);
                    swidth += Math.abs(dsdv * fdv.value);
                    float dtdu = RiGlobal.SO_DuType_TqFloat(t, __iGrid, this, Deffloat);
                    twidth = Math.abs(dtdu * fdu.value);
                    float dtdv = RiGlobal.SO_DvType_TqFloat(t, __iGrid, this, Deffloat);
                    twidth += Math.abs(dtdv * fdv.value);
                } else {
                    swidth = (float)(1.0 / (double)pTMap.XRes());
                    twidth = (float)(1.0 / (double)pTMap.YRes());
                }
                p_float _aq_s = new p_float();
                s.GetFloat(_aq_s, __iGrid);
                p_float _aq_t = new p_float();
                t.GetFloat(_aq_t, __iGrid);
                pTMap.SampleMap(_aq_s.value, _aq_t.value, swidth, twidth, val);
                float fchan = _aq_channel.value;
                CqColor colResult = new CqColor();
                colResult.SetfRed(fchan >= (float)val.size() ? fill.value : val.valueAt((int)fchan));
                colResult.SetfGreen(fchan + 1.0f >= (float)val.size() ? fill.value : val.valueAt((int)(fchan + 1.0f)));
                colResult.SetfBlue(fchan + 2.0f >= (float)val.size() ? fill.value : val.valueAt((int)(fchan + 2.0f)));
                Result.SetColor(colResult, __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        } else {
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                Result.SetColor(new CqColor(0.0f, 0.0f, 0.0f), __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        }
    }

    @Override
    public void SO_ctexture3(IqShaderData name, IqShaderData channel, IqShaderData s1, IqShaderData t1, IqShaderData s2, IqShaderData t2, IqShaderData s3, IqShaderData t3, IqShaderData s4, IqShaderData t4, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(142);
        boolean __fVarying = false;
        if (RiGlobal.QGetRenderContextI() == null) {
            return;
        }
        HashMap<String, IqShaderData> paramMap = new HashMap<String, IqShaderData>();
        this.GetTexParams(cParams, apParams, paramMap);
        p_float fill = new p_float(0.0f);
        if (paramMap.containsKey("fill")) {
            paramMap.get("fill").GetFloat(fill);
        }
        int __iGrid = 0;
        p_String _aq_name = new p_String();
        name.GetString(_aq_name, __iGrid);
        p_float _aq_channel = new p_float();
        channel.GetFloat(_aq_channel, __iGrid);
        IqTextureMap pTMap = RiGlobal.QGetRenderContextI().GetTextureMap(_aq_name.value);
        __fVarying = true;
        if (pTMap != null && pTMap.IsValid()) {
            Valarray val = new Valarray();
            pTMap.PrepareSampleOptions(paramMap);
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                p_float _aq_s1 = new p_float();
                s1.GetFloat(_aq_s1, __iGrid);
                p_float _aq_t1 = new p_float();
                t1.GetFloat(_aq_t1, __iGrid);
                p_float _aq_s2 = new p_float();
                s2.GetFloat(_aq_s2, __iGrid);
                p_float _aq_t2 = new p_float();
                t2.GetFloat(_aq_t2, __iGrid);
                p_float _aq_s3 = new p_float();
                s3.GetFloat(_aq_s3, __iGrid);
                p_float _aq_t3 = new p_float();
                t3.GetFloat(_aq_t3, __iGrid);
                p_float _aq_s4 = new p_float();
                s4.GetFloat(_aq_s4, __iGrid);
                p_float _aq_t4 = new p_float();
                t4.GetFloat(_aq_t4, __iGrid);
                pTMap.SampleMap(_aq_s1.value, _aq_t1.value, _aq_s2.value, _aq_t2.value, _aq_s3.value, _aq_t3.value, _aq_s4.value, _aq_t4.value, val);
                float fchan = _aq_channel.value;
                CqColor colResult = new CqColor();
                colResult.SetfRed(fchan >= (float)val.size() ? fill.value : val.valueAt((int)fchan));
                colResult.SetfGreen(fchan + 1.0f >= (float)val.size() ? fill.value : val.valueAt((int)(fchan + 1.0f)));
                colResult.SetfBlue(fchan + 2.0f >= (float)val.size() ? fill.value : val.valueAt((int)(fchan + 2.0f)));
                Result.SetColor(colResult, __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        } else {
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                Result.SetColor(new CqColor(0.0f, 0.0f, 0.0f), __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        }
    }

    @Override
    public void SO_fenvironment2(IqShaderData name, IqShaderData channel, IqShaderData R, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(161);
        CqVector3D Defvec = new CqVector3D(0.0f, 0.0f, 0.0f);
        boolean __fVarying = false;
        if (RiGlobal.QGetRenderContextI() == null) {
            return;
        }
        HashMap<String, IqShaderData> paramMap = new HashMap<String, IqShaderData>();
        this.GetTexParams(cParams, apParams, paramMap);
        p_float fill = new p_float(0.0f);
        if (paramMap.containsKey("fill")) {
            paramMap.get("fill").GetFloat(fill);
        }
        int __iGrid = 0;
        p_String _aq_name = new p_String();
        name.GetString(_aq_name, __iGrid);
        p_float _aq_channel = new p_float();
        channel.GetFloat(_aq_channel, __iGrid);
        IqTextureMap pTMap = RiGlobal.QGetRenderContextI().GetEnvironmentMap(_aq_name.value);
        if (pTMap == null) {
            pTMap = RiGlobal.QGetRenderContextI().GetLatLongMap(_aq_name.value);
        }
        p_float fdu = new p_float(0.0f);
        p_float fdv = new p_float(0.0f);
        if (this.m_pAttributes != null) {
            this.du().GetFloat(fdu);
            this.dv().GetFloat(fdv);
        }
        __fVarying = true;
        if (pTMap != null && pTMap.IsValid()) {
            pTMap.PrepareSampleOptions(paramMap);
            Valarray val = new Valarray();
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                CqVector3D swidth = new CqVector3D(0.0f);
                CqVector3D twidth = new CqVector3D(0.0f);
                if (fdu.value != 0.0f) {
                    CqVector3D dRdu = RiGlobal.SO_DuType_CqVector3D(R, __iGrid, this, Defvec);
                    swidth = dRdu.mul(fdu.value);
                }
                if (fdv.value != 0.0f) {
                    CqVector3D dRdv = RiGlobal.SO_DvType_CqVector3D(R, __iGrid, this, Defvec);
                    twidth = dRdv.mul(fdv.value);
                } else {
                    swidth = new CqVector3D((float)(1.0 / (double)pTMap.XRes()));
                    twidth = new CqVector3D((float)(1.0 / (double)pTMap.YRes()));
                }
                CqVector3D _aq_R = new CqVector3D();
                R.GetVector(_aq_R, __iGrid);
                pTMap.SampleMap(_aq_R, swidth, twidth, val);
                float fchan = _aq_channel.value;
                if (fchan >= (float)val.size()) {
                    Result.SetFloat(fill.value, __iGrid);
                    continue;
                }
                Result.SetFloat(val.valueAt((int)fchan), __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        } else {
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                Result.SetFloat(0.0f, __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        }
    }

    @Override
    public void SO_fenvironment3(IqShaderData name, IqShaderData channel, IqShaderData R1, IqShaderData R2, IqShaderData R3, IqShaderData R4, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(162);
        boolean __fVarying = false;
        if (RiGlobal.QGetRenderContextI() == null) {
            return;
        }
        HashMap<String, IqShaderData> paramMap = new HashMap<String, IqShaderData>();
        this.GetTexParams(cParams, apParams, paramMap);
        p_float fill = new p_float(0.0f);
        if (paramMap.containsKey("fill")) {
            paramMap.get("fill").GetFloat(fill);
        }
        int __iGrid = 0;
        p_String _aq_name = new p_String();
        name.GetString(_aq_name, __iGrid);
        p_float _aq_channel = new p_float();
        channel.GetFloat(_aq_channel, __iGrid);
        IqTextureMap pTMap = RiGlobal.QGetRenderContextI().GetEnvironmentMap(_aq_name.value);
        if (pTMap == null) {
            pTMap = RiGlobal.QGetRenderContextI().GetLatLongMap(_aq_name.value);
        }
        __fVarying = true;
        if (pTMap != null && pTMap.IsValid()) {
            Valarray val = new Valarray();
            pTMap.PrepareSampleOptions(paramMap);
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                CqVector3D _aq_R1 = new CqVector3D();
                R1.GetVector(_aq_R1, __iGrid);
                CqVector3D _aq_R2 = new CqVector3D();
                R2.GetVector(_aq_R2, __iGrid);
                CqVector3D _aq_R3 = new CqVector3D(9.0f);
                R3.GetVector(_aq_R3, __iGrid);
                CqVector3D _aq_R4 = new CqVector3D();
                R4.GetVector(_aq_R4, __iGrid);
                pTMap.SampleMap(_aq_R1, _aq_R2, _aq_R3, _aq_R4, val);
                float fchan = _aq_channel.value;
                if (fchan >= (float)val.size()) {
                    Result.SetFloat(fill.value, __iGrid);
                    continue;
                }
                Result.SetFloat(val.valueAt((int)fchan), __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        } else {
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                Result.SetFloat(0.0f, __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        }
    }

    @Override
    public void SO_cenvironment2(IqShaderData name, IqShaderData channel, IqShaderData R, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(120);
        CqVector3D Defvec = new CqVector3D(0.0f, 0.0f, 0.0f);
        boolean __fVarying = false;
        if (RiGlobal.QGetRenderContextI() == null) {
            return;
        }
        HashMap<String, IqShaderData> paramMap = new HashMap<String, IqShaderData>();
        this.GetTexParams(cParams, apParams, paramMap);
        p_float fill = new p_float(0.0f);
        if (paramMap.containsKey("fill")) {
            paramMap.get("fill").GetFloat(fill);
        }
        int __iGrid = 0;
        p_String _aq_name = new p_String();
        name.GetString(_aq_name, __iGrid);
        p_float _aq_channel = new p_float();
        channel.GetFloat(_aq_channel, __iGrid);
        IqTextureMap pTMap = RiGlobal.QGetRenderContextI().GetEnvironmentMap(_aq_name.value);
        if (pTMap == null) {
            pTMap = RiGlobal.QGetRenderContextI().GetLatLongMap(_aq_name.value);
        }
        p_float fdu = new p_float(0.0f);
        p_float fdv = new p_float(0.0f);
        if (this.m_pAttributes != null) {
            this.du().GetFloat(fdu);
            this.dv().GetFloat(fdv);
        }
        __fVarying = true;
        if (pTMap != null && pTMap.IsValid()) {
            Valarray val = new Valarray();
            pTMap.PrepareSampleOptions(paramMap);
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                CqVector3D swidth = new CqVector3D(0.0f);
                CqVector3D twidth = new CqVector3D(0.0f);
                if (fdu.value != 0.0f) {
                    CqVector3D dRdu = RiGlobal.SO_DuType_CqVector3D(R, __iGrid, this, Defvec);
                    swidth = dRdu.mul(fdu.value);
                }
                if (fdv.value != 0.0f) {
                    CqVector3D dRdv = RiGlobal.SO_DvType_CqVector3D(R, __iGrid, this, Defvec);
                    twidth = dRdv.mul(fdv.value);
                } else {
                    swidth = new CqVector3D((float)(1.0 / (double)pTMap.XRes()));
                    twidth = new CqVector3D((float)(1.0 / (double)pTMap.YRes()));
                }
                CqVector3D _aq_R = new CqVector3D();
                R.GetVector(_aq_R, __iGrid);
                pTMap.SampleMap(_aq_R, swidth, twidth, val);
                float fchan = _aq_channel.value;
                if (fchan + 2.0f >= (float)val.size()) {
                    Result.SetColor(new CqColor(fill.value, fill.value, fill.value), __iGrid);
                    continue;
                }
                Result.SetColor(new CqColor(val.valueAt((int)fchan), val.valueAt((int)fchan + 1), val.valueAt((int)fchan + 2)), __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        } else {
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                Result.SetColor(new CqColor(0.0f, 0.0f, 0.0f), __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        }
    }

    @Override
    public void SO_cenvironment3(IqShaderData name, IqShaderData channel, IqShaderData R1, IqShaderData R2, IqShaderData R3, IqShaderData R4, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(121);
        boolean __fVarying = false;
        if (RiGlobal.QGetRenderContextI() == null) {
            return;
        }
        HashMap<String, IqShaderData> paramMap = new HashMap<String, IqShaderData>();
        this.GetTexParams(cParams, apParams, paramMap);
        p_float fill = new p_float(0.0f);
        if (paramMap.containsKey("fill")) {
            paramMap.get("fill").GetFloat(fill);
        }
        int __iGrid = 0;
        p_String _aq_name = new p_String();
        name.GetString(_aq_name, __iGrid);
        p_float _aq_channel = new p_float();
        channel.GetFloat(_aq_channel, __iGrid);
        IqTextureMap pTMap = RiGlobal.QGetRenderContextI().GetEnvironmentMap(_aq_name.value);
        if (pTMap == null) {
            pTMap = RiGlobal.QGetRenderContextI().GetLatLongMap(_aq_name.value);
        }
        __iGrid = 0;
        __fVarying = true;
        if (pTMap != null && pTMap.IsValid()) {
            Valarray val = new Valarray();
            pTMap.PrepareSampleOptions(paramMap);
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                CqVector3D _aq_R1 = new CqVector3D();
                R1.GetVector(_aq_R1, __iGrid);
                CqVector3D _aq_R2 = new CqVector3D();
                R2.GetVector(_aq_R2, __iGrid);
                CqVector3D _aq_R3 = new CqVector3D();
                R3.GetVector(_aq_R3, __iGrid);
                CqVector3D _aq_R4 = new CqVector3D();
                R4.GetVector(_aq_R4, __iGrid);
                pTMap.SampleMap(_aq_R1, _aq_R2, _aq_R3, _aq_R4, val);
                float fchan = _aq_channel.value;
                if (fchan + 2.0f >= (float)val.size()) {
                    Result.SetColor(new CqColor(fill.value, fill.value, fill.value), __iGrid);
                    continue;
                }
                Result.SetColor(new CqColor(val.valueAt((int)fchan), val.valueAt((int)fchan + 1), val.valueAt((int)fchan + 2)), __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        } else {
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                Result.SetColor(new CqColor(0.0f, 0.0f, 0.0f), __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        }
    }

    @Override
    public void SO_bump1(IqShaderData name, IqShaderData channel, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        boolean __fVarying = false;
        __fVarying = true;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            Result.SetPoint(new CqVector3D(0.0f, 0.0f, 0.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_bump2(IqShaderData name, IqShaderData channel, IqShaderData s, IqShaderData t, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        boolean __fVarying = false;
        __fVarying = true;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            Result.SetPoint(new CqVector3D(0.0f, 0.0f, 0.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_bump3(IqShaderData name, IqShaderData channel, IqShaderData s1, IqShaderData t1, IqShaderData s2, IqShaderData t2, IqShaderData s3, IqShaderData t3, IqShaderData s4, IqShaderData t4, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        boolean __fVarying = false;
        __fVarying = true;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            Result.SetPoint(new CqVector3D(0.0f, 0.0f, 0.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_shadow(IqShaderData name, IqShaderData channel, IqShaderData P, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(245);
        boolean __fVarying = false;
        if (RiGlobal.QGetRenderContextI() == null) {
            return;
        }
        HashMap<String, IqShaderData> paramMap = new HashMap<String, IqShaderData>();
        this.GetTexParams(cParams, apParams, paramMap);
        int __iGrid = 0;
        p_String _aq_name = new p_String();
        name.GetString(_aq_name, __iGrid);
        p_float _aq_channel = new p_float();
        channel.GetFloat(_aq_channel, __iGrid);
        IqTextureMap pMap = RiGlobal.QGetRenderContextI().GetShadowMap(_aq_name.value);
        __fVarying = true;
        if (pMap != null && pMap.IsValid()) {
            Valarray fv = new Valarray();
            pMap.PrepareSampleOptions(paramMap);
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                CqVector3D swidth = new CqVector3D(0.0f);
                CqVector3D twidth = new CqVector3D(0.0f);
                CqVector3D _aq_P = new CqVector3D();
                P.GetPoint(_aq_P, __iGrid);
                pMap.SampleMap(_aq_P, swidth, twidth, fv, 0);
                Result.SetFloat(fv.valueAt(0), __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        } else {
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                Result.SetFloat(0.0f, __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        }
    }

    @Override
    public void SO_shadow1(IqShaderData name, IqShaderData channel, IqShaderData P1, IqShaderData P2, IqShaderData P3, IqShaderData P4, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(246);
        boolean __fVarying = false;
        if (RiGlobal.QGetRenderContextI() == null) {
            return;
        }
        HashMap<String, IqShaderData> paramMap = new HashMap<String, IqShaderData>();
        this.GetTexParams(cParams, apParams, paramMap);
        int __iGrid = 0;
        p_String _aq_name = new p_String();
        name.GetString(_aq_name, __iGrid);
        p_float _aq_channel = new p_float();
        channel.GetFloat(_aq_channel, __iGrid);
        IqTextureMap pMap = RiGlobal.QGetRenderContextI().GetShadowMap(_aq_name.value);
        __fVarying = true;
        if (pMap != null && pMap.IsValid()) {
            Valarray fv = new Valarray();
            pMap.PrepareSampleOptions(paramMap);
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                CqVector3D _aq_P1 = new CqVector3D();
                P1.GetPoint(_aq_P1, __iGrid);
                CqVector3D _aq_P2 = new CqVector3D();
                P2.GetPoint(_aq_P2, __iGrid);
                CqVector3D _aq_P3 = new CqVector3D();
                P3.GetPoint(_aq_P3, __iGrid);
                CqVector3D _aq_P4 = new CqVector3D();
                P4.GetPoint(_aq_P4, __iGrid);
                pMap.SampleMap(_aq_P1, _aq_P2, _aq_P3, _aq_P4, fv, 0);
                Result.SetFloat(fv.valueAt(0), __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        } else {
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                Result.SetFloat(0.0f, __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        }
    }

    @Override
    public void SO_illuminance(IqShaderData Category2, IqShaderData P, IqShader pShader) {
        CqStats.STATS_INC(183);
        this.SO_illuminance(Category2, P, null, null);
    }

    @Override
    public void SO_illuminance(IqShaderData Category2, IqShaderData P, IqShaderData Axis, IqShaderData Angle, IqShader pShader) {
        CqStats.STATS_INC(183);
        boolean __fVarying = false;
        int __iGrid = 0;
        p_String cat = new p_String("");
        if (Category2 != null) {
            Category2.GetString(cat);
        }
        __fVarying = true;
        if (this.m_pAttributes != null) {
            IqLightsource lp = this.m_pAttributes.pLight(this.m_li);
            if (Axis != null) {
                boolean bl = __fVarying = Axis.Class().getValue() == 3 || __fVarying;
            }
            if (Angle != null) {
                __fVarying = Angle.Class().getValue() == 3 || __fVarying;
            }
            boolean exec = true;
            if (cat.value.length() != 0) {
                String catname;
                boolean exclude = false;
                p_String lightcategories = new p_String();
                if (cat.value.startsWith("-")) {
                    exclude = true;
                    catname = cat.value.substring(1, cat.value.length());
                } else {
                    catname = cat.value;
                }
                IqShaderData pcats = lp.pShader().FindArgument("__category");
                if (pcats != null) {
                    int tokenend;
                    pcats.GetString(lightcategories);
                    exec = false;
                    int tokenpos = 0;
                    while ((tokenend = lightcategories.value.indexOf(",", tokenpos)) != -1) {
                        String token = lightcategories.value.substring(tokenpos, tokenend);
                        if (catname.compareTo(token) == 0 && !exclude) {
                            exec = true;
                            break;
                        }
                        tokenpos = tokenend + 1;
                    }
                }
            }
            if (exec) {
                CqVector3D Ln = new CqVector3D();
                CqColor colCl = new CqColor();
                CqVector3D vecAxis = new CqVector3D(0.0f, 1.0f, 0.0f);
                p_float fAngle = new p_float((float)Math.PI);
                __iGrid = 0;
                CqBitVector RS = this.RunningState();
                do {
                    if (__fVarying && !RS.Value(__iGrid)) continue;
                    lp.L().GetVector(Ln, __iGrid);
                    Ln.x = -Ln.x;
                    Ln.y = -Ln.y;
                    Ln.z = -Ln.z;
                    this.L().SetVector(Ln, __iGrid);
                    lp.Cl().GetColor(colCl, __iGrid);
                    this.Cl().SetColor(colCl, __iGrid);
                    Ln.Unit();
                    if (Axis != null) {
                        Axis.GetVector(vecAxis, __iGrid);
                    }
                    if (Angle != null) {
                        Angle.GetFloat(fAngle, __iGrid);
                    }
                    float cosangle = Ln.mul(vecAxis);
                    if (Math.acos(cosangle = PublicFunctions.CLAMP(cosangle, -1.0f, 1.0f)) > (double)fAngle.value) {
                        this.m_CurrentState.SetValue(__iGrid, false);
                        continue;
                    }
                    this.m_CurrentState.SetValue(__iGrid, true);
                } while (++__iGrid < this.GridSize() && __fVarying);
            }
        }
    }

    @Override
    public void SO_illuminate(IqShaderData P, IqShaderData Axis, IqShaderData Angle, IqShader pShader) {
        CqStats.STATS_INC(184);
        boolean __fVarying = false;
        boolean res = true;
        if (this.m_Illuminate > 0) {
            res = false;
        }
        __fVarying = true;
        if (res) {
            int __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                CqVector3D _aq_P = new CqVector3D();
                P.GetPoint(_aq_P, __iGrid);
                CqVector3D vecPs = new CqVector3D();
                this.Ps().GetPoint(vecPs, __iGrid);
                this.L().SetVector(vecPs.sub(_aq_P), __iGrid);
                CqVector3D Ln = new CqVector3D();
                this.L().GetVector(Ln, __iGrid);
                Ln.Unit();
                CqVector3D vecAxis = new CqVector3D(0.0f, 1.0f, 0.0f);
                if (Axis != null) {
                    Axis.GetVector(vecAxis, __iGrid);
                }
                p_float fAngle = new p_float((float)Math.PI);
                if (Angle != null) {
                    Angle.GetFloat(fAngle, __iGrid);
                }
                float cosangle = Ln.mul(vecAxis);
                if (Math.acos(cosangle = PublicFunctions.CLAMP(cosangle, -1.0f, 1.0f)) > (double)fAngle.value) {
                    this.Cl().SetColor(new CqColor(0.0f, 0.0f, 0.0f), __iGrid);
                    this.m_CurrentState.SetValue(__iGrid, false);
                    continue;
                }
                this.m_CurrentState.SetValue(__iGrid, true);
            } while (++__iGrid < this.GridSize() && __fVarying);
        }
        ++this.m_Illuminate;
    }

    @Override
    public void SO_illuminate(IqShaderData P, IqShader pShader) {
        CqStats.STATS_INC(184);
        this.SO_illuminate(P, null, null, pShader);
    }

    @Override
    public void SO_solar(IqShaderData Axis, IqShaderData Angle, IqShader pShader) {
        CqStats.STATS_INC(250);
        boolean __fVarying = false;
        boolean res = true;
        if (this.m_Illuminate > 0) {
            res = false;
        }
        __fVarying = true;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid) || !res) continue;
            CqVector3D vecAxis = new CqVector3D(0.0f, 1.0f, 0.0f);
            if (Axis != null) {
                Axis.GetVector(vecAxis, __iGrid);
            }
            this.L().SetVector(vecAxis, __iGrid);
            this.m_CurrentState.SetValue(__iGrid, true);
        } while (++__iGrid < this.GridSize() && __fVarying);
        ++this.m_Illuminate;
    }

    @Override
    public void SO_solar(IqShader pShader) {
        CqStats.STATS_INC(250);
        this.SO_solar(null, null, pShader);
    }

    @Override
    public void SO_printf(IqShaderData str, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(224);
        boolean __fVarying = false;
        if (RiGlobal.QGetRenderContextI() == null) {
            return;
        }
        __fVarying = str.Class().getValue() == 3 || __fVarying;
        int ii = 0;
        while (ii < cParams) {
            __fVarying = apParams[ii].Class().getValue() == 3 || __fVarying;
            ++ii;
        }
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_String _aq_str = new p_String("");
            str.GetString(_aq_str, __iGrid);
            String strA = GlobalShaderExecEnv.SO_sprintf(_aq_str.value, cParams, apParams, __iGrid);
            RiGlobal.QGetRenderContextI().PrintString(strA);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_format(IqShaderData str, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(171);
        boolean __fVarying = false;
        __fVarying = str.Class().getValue() == 3 || __fVarying;
        int ii = 0;
        while (ii < cParams) {
            __fVarying = apParams[ii].Class().getValue() == 3 || __fVarying;
            ++ii;
        }
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_String _aq_str = new p_String("");
            str.GetString(_aq_str, __iGrid);
            String strA = GlobalShaderExecEnv.SO_sprintf(_aq_str.value, cParams, apParams, __iGrid);
            Result.SetString(strA, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_concat(IqShaderData stra, IqShaderData strb, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(131);
        boolean __fVarying = false;
        __fVarying = stra.Class().getValue() == 3 || __fVarying;
        __fVarying = strb.Class().getValue() == 3 || __fVarying;
        int ii = 0;
        while (ii < cParams) {
            __fVarying = apParams[ii].Class().getValue() == 3 || __fVarying;
            ++ii;
        }
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_String _aq_stra = new p_String();
            stra.GetString(_aq_stra, __iGrid);
            String strRes = _aq_stra.value;
            p_String _aq_strb = new p_String();
            strb.GetString(_aq_strb, __iGrid);
            strRes = String.valueOf(strRes) + _aq_strb.value;
            ii = 0;
            while (ii < cParams) {
                p_String sn = new p_String();
                apParams[ii].GetString(sn, __iGrid);
                strRes = String.valueOf(strRes) + sn.value;
                ++ii;
            }
            Result.SetString(strRes, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_atmosphere(IqShaderData name, IqShaderData pV, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(107);
        IqShader pAtmosphere = null;
        if (this.m_pAttributes != null && this.m_pAttributes.pshadAtmosphere(RiGlobal.QGetRenderContextI().Time()) != null) {
            pAtmosphere = this.m_pAttributes.pshadAtmosphere(RiGlobal.QGetRenderContextI().Time());
        }
        int __iGrid = 0;
        p_String _aq_name = new p_String();
        name.GetString(_aq_name, __iGrid);
        if (pAtmosphere != null) {
            Result.SetValue(pAtmosphere.GetValue(_aq_name.value, pV) ? 1.0f : 0.0f, 0);
        } else {
            Result.SetValue(0.0f, 0);
        }
    }

    @Override
    public void SO_displacement(IqShaderData name, IqShaderData pV, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(148);
        IqShader pDisplacement = null;
        if (this.m_pAttributes != null && this.m_pAttributes.pshadDisplacement(RiGlobal.QGetRenderContextI().Time()) != null) {
            pDisplacement = this.m_pAttributes.pshadDisplacement(RiGlobal.QGetRenderContextI().Time());
        }
        int __iGrid = 0;
        p_String _aq_name = new p_String("");
        name.GetString(_aq_name, __iGrid);
        if (pDisplacement != null) {
            Result.SetValue(pDisplacement.GetValue(_aq_name.value, pV) ? 1.0f : 0.0f, 0);
        } else {
            Result.SetValue(0.0f, 0);
        }
    }

    @Override
    public void SO_lightsource(IqShaderData name, IqShaderData pV, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(188);
        IqShader pLightsource = null;
        int __iGrid = 0;
        p_String _aq_name = new p_String();
        name.GetString(_aq_name, __iGrid);
        if (this.m_li < this.m_pAttributes.cLights()) {
            pLightsource = this.m_pAttributes.pLight(this.m_li).pShader();
        }
        if (pLightsource != null) {
            Result.SetValue(pLightsource.GetValue(_aq_name.value, pV) ? 1.0f : 0.0f, 0);
        } else {
            Result.SetValue(0.0f, 0);
        }
    }

    @Override
    public void SO_surface(IqShaderData name, IqShaderData pV, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(257);
        IqShader pSurface = null;
        if (this.GetCurrentSurface() != null && this.GetCurrentSurface().pAttributes() != null && this.GetCurrentSurface().pAttributes().pshadSurface(RiGlobal.QGetRenderContextI().Time()) != null) {
            pSurface = this.GetCurrentSurface().pAttributes().pshadSurface(RiGlobal.QGetRenderContextI().Time());
        }
        int __iGrid = 0;
        p_String _aq_name = new p_String();
        name.GetString(_aq_name, __iGrid);
        if (pSurface != null) {
            Result.SetValue(pSurface.GetValue(_aq_name.value, pV) ? 1.0f : 0.0f, 0);
        } else {
            Result.SetValue(0.0f, 0);
        }
    }

    @Override
    public void SO_attribute(IqShaderData name, IqShaderData pV, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(108);
        int __iGrid = 0;
        p_String p_aq_name = new p_String();
        name.GetString(p_aq_name, __iGrid);
        String _aq_name = p_aq_name.value;
        float Ret = 0.0f;
        if (_aq_name.compareTo("ShadingRate") == 0) {
            if (pV.Type().getValue() == 1) {
                pV.SetFloat(this.m_pAttributes.GetFloatAttribute("System", "ShadingRate")[0]);
                Ret = 1.0f;
            }
        } else if (_aq_name.compareTo("Sides") == 0) {
            if (pV.Type().getValue() == 1) {
                pV.SetFloat(this.m_pAttributes.GetIntegerAttribute("System", "Sides")[0]);
                Ret = 1.0f;
            }
        } else if (_aq_name.compareTo("Matte") == 0) {
            if (pV.Type().getValue() == 1) {
                pV.SetFloat(this.m_pAttributes.GetIntegerAttribute("System", "Matte")[0]);
                Ret = 1.0f;
            }
        } else {
            int iColon = _aq_name.indexOf(58);
            if (iColon >= 0) {
                String strParam = _aq_name.substring(iColon + 1, _aq_name.length());
                _aq_name = _aq_name.substring(0, iColon);
                Ret = 1.0f;
                if (this.pAttributes().GetFloatAttribute(_aq_name, strParam) != null) {
                    pV.SetFloat(this.pAttributes().GetFloatAttribute(_aq_name, strParam)[0]);
                } else if (this.pAttributes().GetIntegerAttribute(_aq_name, strParam) != null) {
                    pV.SetFloat(this.pAttributes().GetIntegerAttribute(_aq_name, strParam)[0]);
                } else if (this.pAttributes().GetStringAttribute(_aq_name, strParam) != null) {
                    pV.SetString(this.pAttributes().GetStringAttribute(_aq_name, strParam)[0]);
                } else if (this.pAttributes().GetPointAttribute(_aq_name, strParam) != null) {
                    pV.SetPoint(this.pAttributes().GetPointAttribute(_aq_name, strParam)[0]);
                } else if (this.pAttributes().GetVectorAttribute(_aq_name, strParam) != null) {
                    pV.SetVector(this.pAttributes().GetVectorAttribute(_aq_name, strParam)[0]);
                } else if (this.pAttributes().GetNormalAttribute(_aq_name, strParam) != null) {
                    pV.SetNormal(this.pAttributes().GetNormalAttribute(_aq_name, strParam)[0]);
                } else if (this.pAttributes().GetColorAttribute(_aq_name, strParam) != null) {
                    pV.SetColor(this.pAttributes().GetColorAttribute(_aq_name, strParam)[0]);
                } else if (this.pAttributes().GetMatrixAttribute(_aq_name, strParam) != null) {
                    pV.SetMatrix(this.pAttributes().GetMatrixAttribute(_aq_name, strParam)[0]);
                } else {
                    Ret = 0.0f;
                }
            }
        }
        Result.SetValue(Ret, 0);
    }

    @Override
    public void SO_option(IqShaderData name, IqShaderData pV, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(201);
        if (RiGlobal.QGetRenderContextI() == null) {
            return;
        }
        int __iGrid = 0;
        p_String p_aq_name = new p_String();
        name.GetString(p_aq_name, __iGrid);
        String _aq_name = p_aq_name.value;
        float Ret = 0.0f;
        if (_aq_name.compareTo("Format") == 0) {
            if (pV.Type().getValue() == 1 && pV.ArrayLength() > 0 && pV.ArrayLength() >= 3) {
                pV.ArrayEntry(0).SetFloat(RiGlobal.QGetRenderContextI().GetIntegerOption("System", "Resolution")[0]);
                pV.ArrayEntry(1).SetFloat(RiGlobal.QGetRenderContextI().GetIntegerOption("System", "Resolution")[1]);
                pV.ArrayEntry(2).SetFloat(RiGlobal.QGetRenderContextI().GetFloatOption("System", "PixelAspectRatio")[0]);
                Ret = 1.0f;
            }
        } else if (_aq_name.compareTo("CropWindow") == 0) {
            if (pV.Type().getValue() == 1 && pV.ArrayLength() > 0 && pV.ArrayLength() >= 4) {
                pV.ArrayEntry(0).SetFloat(RiGlobal.QGetRenderContextI().GetFloatOption("System", "CropWindow")[0]);
                pV.ArrayEntry(1).SetFloat(RiGlobal.QGetRenderContextI().GetFloatOption("System", "CropWindow")[1]);
                pV.ArrayEntry(2).SetFloat(RiGlobal.QGetRenderContextI().GetFloatOption("System", "CropWindow")[2]);
                pV.ArrayEntry(3).SetFloat(RiGlobal.QGetRenderContextI().GetFloatOption("System", "CropWindow")[3]);
                Ret = 1.0f;
            }
        } else if (_aq_name.compareTo("FrameAspectRatio") == 0) {
            if (pV.Type().getValue() == 1) {
                pV.SetFloat(RiGlobal.QGetRenderContextI().GetFloatOption("System", "FrameAspectRatio")[0]);
                Ret = 1.0f;
            }
        } else if (_aq_name.compareTo("DepthOfField") == 0) {
            if (pV.Type().getValue() == 1 && pV.ArrayLength() > 0 && pV.ArrayLength() >= 3) {
                pV.ArrayEntry(0).SetFloat(RiGlobal.QGetRenderContextI().GetFloatOption("System", "DepthOfField")[0]);
                pV.ArrayEntry(1).SetFloat(RiGlobal.QGetRenderContextI().GetFloatOption("System", "DepthOfField")[1]);
                pV.ArrayEntry(2).SetFloat(RiGlobal.QGetRenderContextI().GetFloatOption("System", "DepthOfField")[2]);
                Ret = 1.0f;
            }
        } else if (_aq_name.compareTo("Shutter") == 0) {
            if (pV.Type().getValue() == 1 && pV.ArrayLength() > 0 && pV.ArrayLength() >= 2) {
                pV.ArrayEntry(0).SetFloat(RiGlobal.QGetRenderContextI().GetFloatOption("System", "Shutter")[0]);
                pV.ArrayEntry(1).SetFloat(RiGlobal.QGetRenderContextI().GetFloatOption("System", "Shutter")[1]);
                Ret = 1.0f;
            }
        } else if (_aq_name.compareTo("Clipping") == 0) {
            if (pV.Type().getValue() == 1 && pV.ArrayLength() > 0 && pV.ArrayLength() >= 2) {
                pV.ArrayEntry(0).SetFloat(RiGlobal.QGetRenderContextI().GetFloatOption("System", "Clipping")[0]);
                pV.ArrayEntry(1).SetFloat(RiGlobal.QGetRenderContextI().GetFloatOption("System", "Clipping")[1]);
                Ret = 1.0f;
            }
        } else {
            String strName = _aq_name;
            int iColon = strName.indexOf(58);
            if (iColon >= 0) {
                String strParam = strName.substring(iColon + 1, strName.length());
                strName = strName.substring(0, iColon);
                Ret = 1.0f;
                if (RiGlobal.QGetRenderContextI().GetStringOption(strName, strParam) != null) {
                    pV.SetString(RiGlobal.QGetRenderContextI().GetStringOption(strName, strParam)[0]);
                } else if (RiGlobal.QGetRenderContextI().GetIntegerOption(strName, strParam) != null) {
                    pV.SetFloat(RiGlobal.QGetRenderContextI().GetIntegerOption(strName, strParam)[0]);
                } else if (RiGlobal.QGetRenderContextI().GetPointOption(strName, strParam) != null) {
                    pV.SetPoint(RiGlobal.QGetRenderContextI().GetPointOption(strName, strParam)[0]);
                } else if (RiGlobal.QGetRenderContextI().GetColorOption(strName, strParam) != null) {
                    pV.SetColor(RiGlobal.QGetRenderContextI().GetColorOption(strName, strParam)[0]);
                } else if (RiGlobal.QGetRenderContextI().GetFloatOption(strName, strParam) != null) {
                    pV.SetFloat(RiGlobal.QGetRenderContextI().GetFloatOption(strName, strParam)[0]);
                } else {
                    Ret = 0.0f;
                }
            }
        }
        Result.SetValue(Ret, 0);
    }

    @Override
    public void SO_rendererinfo(IqShaderData name, IqShaderData pV, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(231);
        int __iGrid = 0;
        p_String p_aq_name = new p_String();
        name.GetString(p_aq_name, __iGrid);
        String _aq_name = p_aq_name.value;
        float Ret = 0.0f;
        if (_aq_name.compareTo("renderer") == 0) {
            if (pV.Type().getValue() == 4) {
                pV.SetString("Aqsis");
                Ret = 1.0f;
            }
        } else if (_aq_name.compareTo("version") == 0) {
            if (pV.Type().getValue() == 1 && pV.ArrayLength() > 0 && pV.ArrayLength() >= 4) {
                pV.ArrayEntry(0).SetFloat(1.0f);
                pV.ArrayEntry(1).SetFloat(0.0f);
                pV.ArrayEntry(2).SetFloat(0.0f);
                pV.ArrayEntry(3).SetFloat(0.0f);
                Ret = 1.0f;
            }
        } else if (_aq_name.compareTo("versionstring") == 0 && pV.Type().getValue() == 4) {
            pV.SetString("1.0.0");
            Ret = 1.0f;
        }
        Result.SetValue(Ret, 0);
    }

    @Override
    public void SO_incident(IqShaderData name, IqShaderData pV, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(185);
        Result.SetValue(0.0f, 0);
    }

    @Override
    public void SO_opposite(IqShaderData name, IqShaderData pV, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(200);
        Result.SetValue(0.0f, 0);
    }

    @Override
    public void SO_fcellnoise1(IqShaderData v, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(157);
        boolean __fVarying = false;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            Result.SetFloat(m_cellnoise.FCellNoise1(_aq_v.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_fcellnoise2(IqShaderData u, IqShaderData v, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(158);
        boolean __fVarying = false;
        __fVarying = u.Class().getValue() == 3 || __fVarying;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_u = new p_float();
            u.GetFloat(_aq_u, __iGrid);
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            Result.SetFloat(m_cellnoise.FCellNoise2(_aq_u.value, _aq_v.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_fcellnoise3(IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(159);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            Result.SetFloat(m_cellnoise.FCellNoise3(_aq_p), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_fcellnoise4(IqShaderData p, IqShaderData v, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(160);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            Result.SetFloat(m_cellnoise.FCellNoise4(_aq_p, _aq_v.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_ccellnoise1(IqShaderData v, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(115);
        boolean __fVarying = false;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            Result.SetColor(new CqColor(m_cellnoise.PCellNoise1(_aq_v.value)), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_ccellnoise2(IqShaderData u, IqShaderData v, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(116);
        boolean __fVarying = false;
        __fVarying = u.Class().getValue() == 3 || __fVarying;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_u = new p_float();
            u.GetFloat(_aq_u, __iGrid);
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            Result.SetColor(new CqColor(m_cellnoise.PCellNoise2(_aq_u.value, _aq_v.value)), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_ccellnoise3(IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(117);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            Result.SetColor(new CqColor(m_cellnoise.PCellNoise3(_aq_p)), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_ccellnoise4(IqShaderData p, IqShaderData v, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(118);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            Result.SetColor(new CqColor(m_cellnoise.PCellNoise4(_aq_p, _aq_v.value)), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_pcellnoise1(IqShaderData v, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(205);
        boolean __fVarying = false;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            Result.SetPoint(m_cellnoise.PCellNoise1(_aq_v.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_pcellnoise2(IqShaderData u, IqShaderData v, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(206);
        boolean __fVarying = false;
        __fVarying = u.Class().getValue() == 3 || __fVarying;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_u = new p_float();
            u.GetFloat(_aq_u, __iGrid);
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            Result.SetPoint(m_cellnoise.PCellNoise2(_aq_u.value, _aq_v.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_pcellnoise3(IqShaderData p, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(207);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            Result.SetPoint(m_cellnoise.PCellNoise3(_aq_p), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_pcellnoise4(IqShaderData p, IqShaderData v, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(208);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            Result.SetPoint(m_cellnoise.PCellNoise4(_aq_p, _aq_v.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_fpnoise1(IqShaderData v, IqShaderData period, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(172);
        boolean __fVarying = false;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = period.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            p_float _aq_period = new p_float();
            period.GetFloat(_aq_period, __iGrid);
            Result.SetFloat((m_noise.FGNoise1(_aq_v.value % _aq_period.value) + 1.0f) / 2.0f, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_fpnoise2(IqShaderData u, IqShaderData v, IqShaderData uperiod, IqShaderData vperiod, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(173);
        boolean __fVarying = false;
        __fVarying = u.Class().getValue() == 3 || __fVarying;
        __fVarying = uperiod.Class().getValue() == 3 || __fVarying;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = vperiod.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_u = new p_float();
            u.GetFloat(_aq_u, __iGrid);
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            p_float _aq_uperiod = new p_float();
            uperiod.GetFloat(_aq_uperiod, __iGrid);
            p_float _aq_vperiod = new p_float();
            vperiod.GetFloat(_aq_vperiod, __iGrid);
            float a = _aq_u.value % _aq_uperiod.value;
            float b = _aq_v.value % _aq_vperiod.value;
            Result.SetFloat((m_noise.FGNoise2(a, b) + 1.0f) / 2.0f, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_fpnoise3(IqShaderData p, IqShaderData pperiod, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(174);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = pperiod.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            CqVector3D _aq_pperiod = new CqVector3D();
            pperiod.GetPoint(_aq_pperiod, __iGrid);
            float a = _aq_p.x % _aq_pperiod.x;
            float b = _aq_p.y % _aq_pperiod.y;
            float c = _aq_p.z % _aq_pperiod.z;
            Result.SetFloat((m_noise.FGNoise3(new CqVector3D(a, b, c)) + 1.0f) / 2.0f, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_fpnoise4(IqShaderData p, IqShaderData t, IqShaderData pperiod, IqShaderData tperiod, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(175);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = pperiod.Class().getValue() == 3 || __fVarying;
        __fVarying = t.Class().getValue() == 3 || __fVarying;
        __fVarying = tperiod.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            p_float _aq_t = new p_float();
            t.GetFloat(_aq_t, __iGrid);
            CqVector3D _aq_pperiod = new CqVector3D();
            pperiod.GetPoint(_aq_pperiod, __iGrid);
            p_float _aq_tperiod = new p_float();
            tperiod.GetFloat(_aq_tperiod, __iGrid);
            float a = _aq_p.x % _aq_pperiod.x;
            float b = _aq_p.y % _aq_pperiod.y;
            float c = _aq_p.z % _aq_pperiod.z;
            Result.SetFloat((m_noise.FGNoise3(new CqVector3D(a, b, c)) + 1.0f) / 2.0f, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_cpnoise1(IqShaderData v, IqShaderData period, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(133);
        boolean __fVarying = false;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = period.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            p_float _aq_period = new p_float();
            period.GetFloat(_aq_period, __iGrid);
            Result.SetColor(m_noise.CGNoise1(_aq_v.value % _aq_period.value).add(1.0f).div(2.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_cpnoise2(IqShaderData u, IqShaderData v, IqShaderData uperiod, IqShaderData vperiod, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(134);
        boolean __fVarying = false;
        __fVarying = u.Class().getValue() == 3 || __fVarying;
        __fVarying = uperiod.Class().getValue() == 3 || __fVarying;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = vperiod.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_u = new p_float();
            u.GetFloat(_aq_u, __iGrid);
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            p_float _aq_uperiod = new p_float();
            uperiod.GetFloat(_aq_uperiod, __iGrid);
            p_float _aq_vperiod = new p_float();
            vperiod.GetFloat(_aq_vperiod, __iGrid);
            float a = _aq_u.value % _aq_uperiod.value;
            float b = _aq_v.value % _aq_vperiod.value;
            Result.SetColor(m_noise.CGNoise2(a, b).add(1.0f).div(2.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_cpnoise3(IqShaderData p, IqShaderData pperiod, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(135);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = pperiod.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            CqVector3D _aq_pperiod = new CqVector3D();
            pperiod.GetPoint(_aq_pperiod, __iGrid);
            float a = _aq_p.x % _aq_pperiod.x;
            float b = _aq_p.y % _aq_pperiod.y;
            float c = _aq_p.z % _aq_pperiod.z;
            Result.SetColor(m_noise.CGNoise3(new CqVector3D(a, b, c)).add(1.0f).div(2.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_cpnoise4(IqShaderData p, IqShaderData t, IqShaderData pperiod, IqShaderData tperiod, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(136);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = pperiod.Class().getValue() == 3 || __fVarying;
        __fVarying = t.Class().getValue() == 3 || __fVarying;
        __fVarying = tperiod.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            p_float _aq_t = new p_float();
            t.GetFloat(_aq_t, __iGrid);
            CqVector3D _aq_pperiod = new CqVector3D();
            pperiod.GetPoint(_aq_pperiod, __iGrid);
            p_float _aq_tperiod = new p_float();
            tperiod.GetFloat(_aq_tperiod, __iGrid);
            float a = _aq_p.x % _aq_pperiod.x;
            float b = _aq_p.y % _aq_pperiod.y;
            float c = _aq_p.z % _aq_pperiod.z;
            Result.SetColor(m_noise.CGNoise3(new CqVector3D(a, b, c)).add(1.0f).div(2.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_ppnoise1(IqShaderData v, IqShaderData period, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(219);
        boolean __fVarying = false;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = period.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            p_float _aq_period = new p_float();
            period.GetFloat(_aq_period, __iGrid);
            Result.SetPoint(m_noise.PGNoise1(_aq_v.value % _aq_period.value).add(1.0f).div(2.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_ppnoise2(IqShaderData u, IqShaderData v, IqShaderData uperiod, IqShaderData vperiod, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(220);
        boolean __fVarying = false;
        __fVarying = u.Class().getValue() == 3 || __fVarying;
        __fVarying = uperiod.Class().getValue() == 3 || __fVarying;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        __fVarying = vperiod.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_u = new p_float();
            u.GetFloat(_aq_u, __iGrid);
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            p_float _aq_uperiod = new p_float();
            uperiod.GetFloat(_aq_uperiod, __iGrid);
            p_float _aq_vperiod = new p_float();
            vperiod.GetFloat(_aq_vperiod, __iGrid);
            float a = _aq_u.value % _aq_uperiod.value;
            float b = _aq_v.value % _aq_vperiod.value;
            Result.SetPoint(m_noise.PGNoise2(a, b).add(1.0f).div(2.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_ppnoise3(IqShaderData p, IqShaderData pperiod, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(221);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = pperiod.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            CqVector3D _aq_pperiod = new CqVector3D();
            pperiod.GetPoint(_aq_pperiod, __iGrid);
            float a = _aq_p.x % _aq_pperiod.x;
            float b = _aq_p.y % _aq_pperiod.y;
            float c = _aq_p.z % _aq_pperiod.z;
            Result.SetPoint(m_noise.PGNoise3(new CqVector3D(a, b, c)).add(1.0f).div(2.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_ppnoise4(IqShaderData p, IqShaderData t, IqShaderData pperiod, IqShaderData tperiod, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(222);
        boolean __fVarying = false;
        __fVarying = p.Class().getValue() == 3 || __fVarying;
        __fVarying = pperiod.Class().getValue() == 3 || __fVarying;
        __fVarying = t.Class().getValue() == 3 || __fVarying;
        __fVarying = tperiod.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_p = new CqVector3D();
            p.GetPoint(_aq_p, __iGrid);
            p_float _aq_t = new p_float();
            t.GetFloat(_aq_t, __iGrid);
            CqVector3D _aq_pperiod = new CqVector3D();
            pperiod.GetPoint(_aq_pperiod, __iGrid);
            p_float _aq_tperiod = new p_float();
            tperiod.GetFloat(_aq_tperiod, __iGrid);
            float a = _aq_p.x % _aq_pperiod.x;
            float b = _aq_p.y % _aq_pperiod.y;
            float c = _aq_p.z % _aq_pperiod.z;
            Result.SetPoint(m_noise.PGNoise3(new CqVector3D(a, b, c)).add(1.0f).div(2.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_ctransform(IqShaderData fromspace, IqShaderData tospace, IqShaderData c, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(143);
        boolean __fVarying = false;
        __fVarying = c.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        String strfromspace = "rgb";
        if (fromspace != null) {
            p_String p_strfromspace = new p_String(strfromspace);
            fromspace.GetString(p_strfromspace);
            strfromspace = p_strfromspace.value;
        }
        String _aq_tospace = "";
        p_String p_aq_tospace = new p_String(_aq_tospace);
        tospace.GetString(p_aq_tospace, __iGrid);
        _aq_tospace = p_aq_tospace.value;
        __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqColor _aq_c = new CqColor();
            c.GetColor(_aq_c, __iGrid);
            CqColor res = new CqColor(new CqVector3D(_aq_c));
            if (strfromspace.compareTo("hsv") == 0) {
                res = _aq_c.hsvtorgb();
            } else if (strfromspace.compareTo("hsl") == 0) {
                res = _aq_c.hsltorgb();
            } else if (strfromspace.compareTo("XYZ") == 0) {
                res = _aq_c.XYZtorgb();
            } else if (strfromspace.compareTo("xyY") == 0) {
                res = _aq_c.xyYtorgb();
            } else if (strfromspace.compareTo("YIQ") == 0) {
                res = _aq_c.YIQtorgb();
            }
            if (_aq_tospace.compareTo("hsv") == 0) {
                res = _aq_c.rgbtohsv();
            } else if (_aq_tospace.compareTo("hsl") == 0) {
                res = _aq_c.rgbtohsl();
            } else if (_aq_tospace.compareTo("XYZ") == 0) {
                res = _aq_c.rgbtoXYZ();
            } else if (_aq_tospace.compareTo("xyY") == 0) {
                res = _aq_c.rgbtoxyY();
            } else if (_aq_tospace.compareTo("YIQ") == 0) {
                res = _aq_c.rgbtoYIQ();
            }
            Result.SetColor(res, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_ctransform(IqShaderData tospace, IqShaderData c, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(143);
        assert (pShader != null);
        this.SO_ctransform(null, tospace, c, Result, pShader);
    }

    @Override
    public void SO_ptlined(IqShaderData P0, IqShaderData P1, IqShaderData Q, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(227);
        boolean __fVarying = false;
        __fVarying = P0.Class().getValue() == 3 || __fVarying;
        __fVarying = P1.Class().getValue() == 3 || __fVarying;
        __fVarying = Q.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_P0 = new CqVector3D();
            P0.GetPoint(_aq_P0, __iGrid);
            CqVector3D _aq_P1 = new CqVector3D();
            P1.GetPoint(_aq_P1, __iGrid);
            CqVector3D _aq_Q = new CqVector3D();
            Q.GetPoint(_aq_Q, __iGrid);
            CqVector3D kDiff = _aq_Q.sub(_aq_P0);
            CqVector3D vecDir = _aq_P1.sub(_aq_P0);
            float fT = kDiff.mul(vecDir);
            if (fT <= 0.0f) {
                fT = 0.0f;
            } else {
                float fSqrLen = vecDir.Magnitude2();
                if (fT >= fSqrLen) {
                    fT = 1.0f;
                    kDiff.assignSub(vecDir);
                } else {
                    kDiff.assignSub(vecDir.mul(fT /= fSqrLen));
                }
            }
            Result.SetFloat(kDiff.Magnitude(), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_inversesqrt(IqShaderData x, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(186);
        boolean __fVarying = false;
        __fVarying = x.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_x = new p_float();
            x.GetFloat(_aq_x, __iGrid);
            Result.SetFloat(1.0f / (float)Math.sqrt(_aq_x.value), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_match(IqShaderData a, IqShaderData b, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(190);
        int __iGrid = 0;
        float r = 0.0f;
        p_String _aq_a = new p_String();
        a.GetString(_aq_a, __iGrid);
        p_String _aq_b = new p_String();
        b.GetString(_aq_b, __iGrid);
        r = _aq_a.value.length() == 0 ? 0.0f : (_aq_b.value.length() == 0 ? 0.0f : (_aq_b.value.indexOf(_aq_a.value) != -1 ? 1.0f : 0.0f));
        Result.SetFloat(r, __iGrid);
    }

    @Override
    public void SO_rotate(IqShaderData Q, IqShaderData angle, IqShaderData P0, IqShaderData P1, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(232);
        boolean __fVarying = false;
        __fVarying = Q.Class().getValue() == 3 || __fVarying;
        __fVarying = angle.Class().getValue() == 3 || __fVarying;
        __fVarying = P0.Class().getValue() == 3 || __fVarying;
        __fVarying = P1.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_angle = new p_float();
            angle.GetFloat(_aq_angle, __iGrid);
            CqVector3D _aq_Q = new CqVector3D();
            Q.GetVector(_aq_Q, __iGrid);
            CqVector3D _aq_P0 = new CqVector3D();
            P0.GetPoint(_aq_P0, __iGrid);
            CqVector3D _aq_P1 = new CqVector3D();
            P1.GetPoint(_aq_P1, __iGrid);
            CqMatrix matR = new CqMatrix(_aq_angle.value, _aq_P1.sub(_aq_P0));
            CqVector3D Res = new CqVector3D(_aq_Q);
            Res = matR.multiply(Res);
            Result.SetPoint(Res, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_filterstep(IqShaderData edge, IqShaderData s1, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(163);
        float Deffloat = 0.0f;
        boolean __fVarying = false;
        p_float _pswidth = new p_float(1.0f);
        p_float _ptwidth = new p_float(1.0f);
        this.GetFilterParams(cParams, apParams, _pswidth, _ptwidth);
        __fVarying = edge.Class().getValue() == 3 || __fVarying;
        __fVarying = s1.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        p_float fdu = new p_float();
        p_float fdv = new p_float();
        this.du().GetFloat(fdu);
        this.dv().GetFloat(fdv);
        __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_s1 = new p_float();
            s1.GetFloat(_aq_s1, __iGrid);
            p_float _aq_edge = new p_float();
            edge.GetFloat(_aq_edge, __iGrid);
            float dsdu = RiGlobal.SO_DuType_TqFloat(s1, __iGrid, this, Deffloat);
            float dsdv = RiGlobal.SO_DvType_TqFloat(s1, __iGrid, this, Deffloat);
            float uwidth = Math.abs(dsdu * fdu.value);
            float vwidth = Math.abs(dsdv * fdv.value);
            float w = uwidth + vwidth;
            Result.SetFloat(PublicFunctions.CLAMP((_aq_s1.value + (w *= _pswidth.value) / 2.0f - _aq_edge.value) / w, 0.0f, 1.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_filterstep2(IqShaderData edge, IqShaderData s1, IqShaderData s2, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(164);
        p_float _pswidth = new p_float(1.0f);
        p_float _ptwidth = new p_float(1.0f);
        this.GetFilterParams(cParams, apParams, _pswidth, _ptwidth);
        boolean __fVarying = false;
        __fVarying = edge.Class().getValue() == 3 || __fVarying;
        __fVarying = s1.Class().getValue() == 3 || __fVarying;
        __fVarying = s2.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_edge = new p_float();
            edge.GetFloat(_aq_edge, __iGrid);
            p_float _aq_s1 = new p_float();
            s1.GetFloat(_aq_s1, __iGrid);
            p_float _aq_s2 = new p_float();
            s2.GetFloat(_aq_s2, __iGrid);
            float w = _aq_s2.value - _aq_s1.value;
            Result.SetFloat(PublicFunctions.CLAMP((_aq_s1.value + (w *= _pswidth.value) / 2.0f - _aq_edge.value) / w, 0.0f, 1.0f), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_specularbrdf(IqShaderData L, IqShaderData N, IqShaderData V, IqShaderData rough, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(252);
        boolean __fVarying = false;
        __fVarying = L.Class().getValue() == 3 || __fVarying;
        __fVarying = N.Class().getValue() == 3 || __fVarying;
        __fVarying = V.Class().getValue() == 3 || __fVarying;
        __fVarying = rough.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_L = new CqVector3D();
            L.GetVector(_aq_L, __iGrid);
            CqVector3D _aq_V = new CqVector3D();
            V.GetVector(_aq_V, __iGrid);
            _aq_L.Unit();
            CqVector3D H = _aq_L.add(_aq_V);
            H.Unit();
            CqVector3D _aq_N = new CqVector3D();
            N.GetNormal(_aq_N, __iGrid);
            p_float _aq_rough = new p_float();
            rough.GetFloat(_aq_rough, __iGrid);
            CqColor colCl = new CqColor();
            this.Cl().GetColor(colCl, __iGrid);
            Result.SetColor(colCl.mul((float)Math.pow(Math.max(0.0f, _aq_N.mul(H)), 1.0f / (_aq_rough.value / 8.0f))), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_setmcomp(IqShaderData M, IqShaderData r, IqShaderData c, IqShaderData v, IqShader pShader) {
        CqStats.STATS_INC(237);
        boolean __fVarying = false;
        __fVarying = M.Class().getValue() == 3 || __fVarying;
        __fVarying = r.Class().getValue() == 3 || __fVarying;
        __fVarying = c.Class().getValue() == 3 || __fVarying;
        __fVarying = v.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqMatrix _aq_M = new CqMatrix();
            M.GetMatrix(_aq_M, __iGrid);
            p_float _aq_r = new p_float();
            r.GetFloat(_aq_r, __iGrid);
            p_float _aq_c = new p_float();
            c.GetFloat(_aq_c, __iGrid);
            p_float _aq_v = new p_float();
            v.GetFloat(_aq_v, __iGrid);
            _aq_M.m_aaElement[(int)_aq_r.value][(int)_aq_c.value] = _aq_v.value;
            _aq_M.SetfIdentity(false);
            M.SetValue(_aq_M, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_determinant(IqShaderData M, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(146);
        boolean __fVarying = false;
        __fVarying = M.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqMatrix _aq_M = new CqMatrix();
            M.GetMatrix(_aq_M, __iGrid);
            Result.SetFloat(_aq_M.Determinant(), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_mtranslate(IqShaderData M, IqShaderData V, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(196);
        boolean __fVarying = false;
        __fVarying = M.Class().getValue() == 3 || __fVarying;
        __fVarying = V.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqMatrix _aq_M = new CqMatrix();
            M.GetMatrix(_aq_M, __iGrid);
            CqVector3D _aq_V = new CqVector3D();
            V.GetVector(_aq_V, __iGrid);
            _aq_M.Translate(_aq_V);
            Result.SetMatrix(_aq_M, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_mrotate(IqShaderData M, IqShaderData angle, IqShaderData axis, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(194);
        boolean __fVarying = false;
        __fVarying = M.Class().getValue() == 3 || __fVarying;
        __fVarying = angle.Class().getValue() == 3 || __fVarying;
        __fVarying = axis.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqMatrix _aq_M = new CqMatrix();
            M.GetMatrix(_aq_M, __iGrid);
            p_float _aq_angle = new p_float();
            angle.GetFloat(_aq_angle, __iGrid);
            CqVector3D _aq_axis = new CqVector3D();
            axis.GetVector(_aq_axis, __iGrid);
            _aq_M.Rotate(_aq_angle.value, _aq_axis);
            Result.SetMatrix(_aq_M, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_mscale(IqShaderData M, IqShaderData S, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(195);
        boolean __fVarying = false;
        __fVarying = M.Class().getValue() == 3 || __fVarying;
        __fVarying = S.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            CqVector3D _aq_S = new CqVector3D();
            S.GetPoint(_aq_S, __iGrid);
            CqMatrix _aq_M = new CqMatrix();
            M.GetMatrix(_aq_M, __iGrid);
            _aq_M.Scale(_aq_S.x, _aq_S.y, _aq_S.z);
            Result.SetMatrix(_aq_M, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_fsplinea(IqShaderData value, IqShaderData a, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(179);
        boolean __fVarying = false;
        assert (a.ArrayLength() > 0);
        assert (a.Type().getValue() == 1);
        int cParams = a.ArrayLength();
        CqSplineCubic spline = new CqSplineCubic(cParams);
        __fVarying = value.Class().getValue() == 3 || __fVarying;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_value = new p_float();
            value.GetFloat(_aq_value, __iGrid);
            p_float fTemp = new p_float();
            if (_aq_value.value >= 1.0f) {
                a.ArrayEntry(cParams - 2).GetFloat(fTemp, __iGrid);
                Result.SetFloat(fTemp.value, __iGrid);
                continue;
            }
            if (_aq_value.value <= 0.0f) {
                a.ArrayEntry(1).GetFloat(fTemp, __iGrid);
                Result.SetFloat(fTemp.value, __iGrid);
                continue;
            }
            int j = 0;
            while (j < cParams) {
                a.ArrayEntry(j).GetFloat(fTemp, __iGrid);
                spline.valueAt(j).assignment(new CqVector4D(fTemp.value, 0.0f, 0.0f, 1.0f));
                ++j;
            }
            CqVector4D res = spline.Evaluate(_aq_value.value);
            Result.SetFloat(res.x, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_csplinea(IqShaderData value, IqShaderData a, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(139);
        boolean __fVarying = false;
        assert (a.ArrayLength() > 0);
        assert (a.Type().getValue() == 5);
        int cParams = a.ArrayLength();
        CqSplineCubic spline = new CqSplineCubic(cParams);
        CqColor colTemp = new CqColor();
        __fVarying = value.Class().getValue() == 3 || __fVarying;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_value = new p_float();
            value.GetFloat(_aq_value, __iGrid);
            if (_aq_value.value >= 1.0f) {
                a.ArrayEntry(cParams - 2).GetColor(colTemp, __iGrid);
                Result.SetColor(colTemp, __iGrid);
                continue;
            }
            if (_aq_value.value <= 0.0f) {
                a.ArrayEntry(1).GetColor(colTemp, __iGrid);
                Result.SetColor(colTemp, __iGrid);
                continue;
            }
            int j = 0;
            while (j < cParams) {
                a.ArrayEntry(j).GetColor(colTemp, __iGrid);
                spline.valueAt(j).assignment(new CqVector4D(colTemp.fRed(), colTemp.fGreen(), colTemp.fBlue(), 1.0f));
                ++j;
            }
            CqVector4D res = spline.Evaluate(_aq_value.value);
            Result.SetColor(new CqColor(res.x, res.y, res.z), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_psplinea(IqShaderData value, IqShaderData a, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(226);
        boolean __fVarying = false;
        assert (a.ArrayLength() > 0);
        assert (a.Type().getValue() == 3);
        int cParams = a.ArrayLength();
        CqSplineCubic spline = new CqSplineCubic(cParams);
        __fVarying = value.Class().getValue() == 3 || __fVarying;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_value = new p_float();
            value.GetFloat(_aq_value, __iGrid);
            CqVector3D vecTemp = new CqVector3D();
            if (_aq_value.value >= 1.0f) {
                a.ArrayEntry(cParams - 2).GetPoint(vecTemp, __iGrid);
                Result.SetPoint(vecTemp, __iGrid);
                continue;
            }
            if (_aq_value.value <= 0.0f) {
                a.ArrayEntry(1).GetPoint(vecTemp, __iGrid);
                Result.SetPoint(vecTemp, __iGrid);
                continue;
            }
            int j = 0;
            while (j < cParams) {
                a.ArrayEntry(j).GetPoint(vecTemp, __iGrid);
                spline.valueAt(j).assignment(vecTemp);
                ++j;
            }
            CqVector3D res = new CqVector3D(spline.Evaluate(_aq_value.value));
            Result.SetPoint(res, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_sfsplinea(IqShaderData basis, IqShaderData value, IqShaderData a, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(242);
        boolean __fVarying = false;
        assert (a.ArrayLength() > 0);
        assert (a.Type().getValue() == 1);
        int cParams = a.ArrayLength();
        CqSplineCubic spline = new CqSplineCubic(cParams);
        __fVarying = value.Class().getValue() == 3 || __fVarying;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        p_String _aq_basis = new p_String();
        basis.GetString(_aq_basis, __iGrid);
        spline.SetBasis(_aq_basis.value);
        __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_value = new p_float();
            value.GetFloat(_aq_value, __iGrid);
            p_float fTemp = new p_float();
            if (_aq_value.value >= 1.0f) {
                a.ArrayEntry(cParams - 2).GetFloat(fTemp, __iGrid);
                Result.SetFloat(fTemp.value, __iGrid);
                continue;
            }
            if (_aq_value.value <= 0.0f) {
                a.ArrayEntry(1).GetFloat(fTemp, __iGrid);
                Result.SetFloat(fTemp.value, __iGrid);
                continue;
            }
            int j = 0;
            while (j < cParams) {
                a.ArrayEntry(j).GetFloat(fTemp, __iGrid);
                spline.valueAt(j).assignment(new CqVector4D(fTemp.value, 0.0f, 0.0f, 1.0f));
                ++j;
            }
            CqVector4D res = spline.Evaluate(_aq_value.value);
            Result.SetFloat(res.x, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_scsplinea(IqShaderData basis, IqShaderData value, IqShaderData a, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(235);
        boolean __fVarying = false;
        assert (a.ArrayLength() > 0);
        assert (a.Type().getValue() == 5);
        int cParams = a.ArrayLength();
        CqSplineCubic spline = new CqSplineCubic(cParams);
        __fVarying = value.Class().getValue() == 3 || __fVarying;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        p_String _aq_basis = new p_String();
        basis.GetString(_aq_basis, __iGrid);
        spline.SetBasis(_aq_basis.value);
        __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_value = new p_float();
            value.GetFloat(_aq_value, __iGrid);
            CqColor colTemp = new CqColor();
            if (_aq_value.value >= 1.0f) {
                a.ArrayEntry(cParams - 2).GetColor(colTemp, __iGrid);
                Result.SetColor(colTemp, __iGrid);
                continue;
            }
            if (_aq_value.value <= 0.0f) {
                a.ArrayEntry(1).GetColor(colTemp, __iGrid);
                Result.SetColor(colTemp, __iGrid);
                continue;
            }
            int j = 0;
            while (j < cParams) {
                a.ArrayEntry(j).GetColor(colTemp, __iGrid);
                spline.valueAt(j).assignment(new CqVector4D(colTemp.fRed(), colTemp.fGreen(), colTemp.fBlue(), 1.0f));
                ++j;
            }
            CqVector4D res = spline.Evaluate(_aq_value.value);
            Result.SetColor(new CqColor(res.x, res.y, res.z), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_spsplinea(IqShaderData basis, IqShaderData value, IqShaderData a, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(254);
        boolean __fVarying = false;
        assert (a.ArrayLength() > 0);
        assert (a.Type().getValue() == 3);
        int cParams = a.ArrayLength();
        CqSplineCubic spline = new CqSplineCubic(cParams);
        __fVarying = value.Class().getValue() == 3 || __fVarying;
        __fVarying = a.Class().getValue() == 3 || __fVarying;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        p_String _aq_basis = new p_String();
        basis.GetString(_aq_basis, __iGrid);
        spline.SetBasis(_aq_basis.value);
        __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_value = new p_float();
            value.GetFloat(_aq_value, __iGrid);
            CqVector3D vecTemp = new CqVector3D();
            if (_aq_value.value >= 1.0f) {
                a.ArrayEntry(cParams - 2).GetPoint(vecTemp, __iGrid);
                Result.SetPoint(vecTemp, __iGrid);
                continue;
            }
            if (_aq_value.value <= 0.0f) {
                a.ArrayEntry(1).GetPoint(vecTemp, __iGrid);
                Result.SetPoint(vecTemp, __iGrid);
                continue;
            }
            int j = 0;
            while (j < cParams) {
                a.ArrayEntry(j).GetPoint(vecTemp, __iGrid);
                spline.valueAt(j).assignment(vecTemp);
                ++j;
            }
            CqVector3D res = new CqVector3D(spline.Evaluate(_aq_value.value));
            Result.SetPoint(res, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_shadername(IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(243);
        boolean __fVarying = false;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            Result.SetString(pShader.strName(), __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_shadername2(IqShaderData shader, IqShaderData Result, IqShader pShader) {
        CqStats.STATS_INC(244);
        boolean __fVarying = false;
        String strName = "";
        IqShader pSurface = null;
        IqShader pDisplacement = null;
        IqShader pAtmosphere = null;
        if (this.m_pAttributes != null) {
            pSurface = this.m_pAttributes.pshadSurface(RiGlobal.QGetRenderContextI().Time());
            pDisplacement = this.m_pAttributes.pshadDisplacement(RiGlobal.QGetRenderContextI().Time());
            pAtmosphere = this.m_pAttributes.pshadAtmosphere(RiGlobal.QGetRenderContextI().Time());
        }
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            strName = "";
            p_String _aq_shader = new p_String();
            shader.GetString(_aq_shader, __iGrid);
            if (_aq_shader.value.compareTo("surface") == 0 && pSurface != null) {
                strName = pSurface.strName();
            } else if (_aq_shader.value.compareTo("displacement") == 0 && pDisplacement != null) {
                strName = pDisplacement.strName();
            } else if (_aq_shader.value.compareTo("atmosphere") == 0 && pAtmosphere != null) {
                strName = pAtmosphere.strName();
            }
            Result.SetString(strName, __iGrid);
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_textureinfo(IqShaderData name, IqShaderData dataname, IqShaderData pV, IqShaderData Result, IqShader pShader) {
        CqMatrix m;
        CqStats.STATS_INC(259);
        if (RiGlobal.QGetRenderContextI() == null) {
            return;
        }
        float Ret = 0.0f;
        IqTextureMap pMap = null;
        IqTextureMap pSMap = null;
        IqTextureMap pEMap = null;
        IqTextureMap pTMap = null;
        int __iGrid = 0;
        String _aq_name = "";
        p_String p_aq_name = new p_String(_aq_name);
        name.GetString(p_aq_name, __iGrid);
        _aq_name = p_aq_name.value;
        String _aq_dataname = "";
        p_String p_aq_dataname = new p_String(_aq_dataname);
        dataname.GetString(p_aq_dataname, __iGrid);
        _aq_dataname = p_aq_dataname.value;
        if (pMap == null && _aq_name.indexOf(".tif") != -1) {
            pTMap = RiGlobal.QGetRenderContextI().GetTextureMap(_aq_name);
            if (pTMap != null && pTMap.Type().getValue() == 1) {
                pMap = pTMap;
            } else if (pTMap != null) {
                pTMap = null;
            }
        }
        if (pMap == null) {
            pSMap = RiGlobal.QGetRenderContextI().GetShadowMap(_aq_name);
            if (pSMap != null && pSMap.Type().getValue() == 4) {
                pMap = pSMap;
            } else if (pSMap != null) {
                pSMap = null;
            }
        }
        if (pMap == null) {
            pEMap = RiGlobal.QGetRenderContextI().GetEnvironmentMap(_aq_name);
            if (pEMap != null && pEMap.Type().getValue() == 2) {
                pMap = pEMap;
            } else if (pEMap != null) {
                pEMap = null;
            }
        }
        if (pMap == null) {
            pTMap = RiGlobal.QGetRenderContextI().GetTextureMap(_aq_name);
            if (pTMap != null && pTMap.Type().getValue() == 1) {
                pMap = pTMap;
            } else if (pTMap != null) {
                pTMap = null;
            }
        }
        if (pMap == null) {
            return;
        }
        if (_aq_dataname.compareTo("resolution") == 0 && pV.Type().getValue() == 1 && pV.ArrayLength() > 0 && pV.ArrayLength() == 2) {
            pV.ArrayEntry(0).SetFloat(pMap.XRes());
            pV.ArrayEntry(1).SetFloat(pMap.YRes());
            Ret = 1.0f;
        }
        if (_aq_dataname.compareTo("type") == 0 && pV.Type().getValue() == 4) {
            if (pMap.Type().getValue() == 1) {
                pV.SetString("texture");
                Ret = 1.0f;
            }
            if (pMap.Type().getValue() == 3) {
                pV.SetString("bump");
                Ret = 1.0f;
            }
            if (pMap.Type().getValue() == 4) {
                pV.SetString("shadow");
                Ret = 1.0f;
            }
            if (pMap.Type().getValue() == 2) {
                pV.SetString("environment");
                Ret = 1.0f;
            }
            if (pMap.Type().getValue() == 5) {
                pV.SetString("environment");
                Ret = 1.0f;
            }
        }
        if (_aq_dataname.compareTo("channels") == 0 && pV.Type().getValue() == 1) {
            pV.SetFloat(pMap.SamplesPerPixel());
            Ret = 1.0f;
        }
        if (_aq_dataname.compareTo("viewingmatrix") == 0 && (pV.Type().getValue() == 1 && pV.ArrayLength() == 16 || pV.Type().getValue() == 11) && pSMap != null) {
            m = pSMap.GetMatrix(0);
            if (pV.ArrayLength() == 16) {
                pV.ArrayEntry(0).SetFloat(m.m_aaElement[0][0]);
                pV.ArrayEntry(1).SetFloat(m.m_aaElement[0][1]);
                pV.ArrayEntry(2).SetFloat(m.m_aaElement[0][2]);
                pV.ArrayEntry(3).SetFloat(m.m_aaElement[0][3]);
                pV.ArrayEntry(4).SetFloat(m.m_aaElement[1][0]);
                pV.ArrayEntry(5).SetFloat(m.m_aaElement[1][1]);
                pV.ArrayEntry(6).SetFloat(m.m_aaElement[1][2]);
                pV.ArrayEntry(7).SetFloat(m.m_aaElement[1][3]);
                pV.ArrayEntry(8).SetFloat(m.m_aaElement[2][0]);
                pV.ArrayEntry(9).SetFloat(m.m_aaElement[2][1]);
                pV.ArrayEntry(10).SetFloat(m.m_aaElement[2][2]);
                pV.ArrayEntry(11).SetFloat(m.m_aaElement[2][3]);
                pV.ArrayEntry(12).SetFloat(m.m_aaElement[3][0]);
                pV.ArrayEntry(13).SetFloat(m.m_aaElement[3][1]);
                pV.ArrayEntry(14).SetFloat(m.m_aaElement[3][2]);
                pV.ArrayEntry(15).SetFloat(m.m_aaElement[3][3]);
            } else {
                pV.SetMatrix(m, 0);
            }
            Ret = 1.0f;
        }
        if (_aq_dataname.compareTo("projectionmatrix") == 0 && (pV.Type().getValue() == 1 && pV.ArrayLength() == 16 || pV.Type().getValue() == 11) && pSMap != null) {
            m = pSMap.GetMatrix(1);
            if (pV.ArrayLength() == 16) {
                pV.ArrayEntry(0).SetFloat(m.m_aaElement[0][0]);
                pV.ArrayEntry(1).SetFloat(m.m_aaElement[0][1]);
                pV.ArrayEntry(2).SetFloat(m.m_aaElement[0][2]);
                pV.ArrayEntry(3).SetFloat(m.m_aaElement[0][3]);
                pV.ArrayEntry(4).SetFloat(m.m_aaElement[1][0]);
                pV.ArrayEntry(5).SetFloat(m.m_aaElement[1][1]);
                pV.ArrayEntry(6).SetFloat(m.m_aaElement[1][2]);
                pV.ArrayEntry(7).SetFloat(m.m_aaElement[1][3]);
                pV.ArrayEntry(8).SetFloat(m.m_aaElement[2][0]);
                pV.ArrayEntry(9).SetFloat(m.m_aaElement[2][1]);
                pV.ArrayEntry(10).SetFloat(m.m_aaElement[2][2]);
                pV.ArrayEntry(11).SetFloat(m.m_aaElement[2][3]);
                pV.ArrayEntry(12).SetFloat(m.m_aaElement[3][0]);
                pV.ArrayEntry(13).SetFloat(m.m_aaElement[3][1]);
                pV.ArrayEntry(14).SetFloat(m.m_aaElement[3][2]);
                pV.ArrayEntry(15).SetFloat(m.m_aaElement[3][3]);
            } else {
                pV.SetMatrix(m, 0);
            }
            Ret = 1.0f;
        }
        pMap = null;
        Result.SetFloat(Ret, __iGrid);
    }

    @Override
    public void SO_bake_f(IqShaderData name, IqShaderData s, IqShaderData t, IqShaderData f, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(109);
        boolean __fVarying = false;
        __fVarying = f.Class().getValue() == 3 || __fVarying;
        __fVarying = s.Class().getValue() == 3 || __fVarying;
        __fVarying = t.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        p_String _aq_name = new p_String();
        name.GetString(_aq_name, __iGrid);
        HashMap<String, BakingChannel> bd = GlobalShaderExecEnv.bake_init();
        __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_s = new p_float();
            s.GetFloat(_aq_s, __iGrid);
            p_float _aq_t = new p_float();
            t.GetFloat(_aq_t, __iGrid);
            p_float _aq_f = new p_float();
            f.GetFloat(_aq_f, __iGrid);
            GlobalShaderExecEnv.bake_f(bd, _aq_name.value, _aq_s.value, _aq_t.value, _aq_f.value);
        } while (++__iGrid < this.GridSize() && __fVarying);
        __iGrid = 0;
        GlobalShaderExecEnv.bake_done(bd);
    }

    @Override
    public void SO_bake_3c(IqShaderData name, IqShaderData s, IqShaderData t, IqShaderData f, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(109);
        boolean __fVarying = false;
        __fVarying = f.Class().getValue() == 3 || __fVarying;
        __fVarying = s.Class().getValue() == 3 || __fVarying;
        __fVarying = t.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        float[] rgb = new float[3];
        p_String _aq_name = new p_String();
        name.GetString(_aq_name, __iGrid);
        HashMap<String, BakingChannel> bd = GlobalShaderExecEnv.bake_init();
        __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_s = new p_float();
            s.GetFloat(_aq_s, __iGrid);
            p_float _aq_t = new p_float();
            t.GetFloat(_aq_t, __iGrid);
            CqColor _aq_f = new CqColor();
            f.GetColor(_aq_f, __iGrid);
            p_float[] p_rgb = new p_float[3];
            int i = 0;
            while (i < p_rgb.length) {
                p_rgb[i] = new p_float();
                ++i;
            }
            _aq_f.GetColorRGB(p_rgb[0], p_rgb[1], p_rgb[2]);
            rgb[0] = p_rgb[0].value;
            rgb[1] = p_rgb[1].value;
            rgb[2] = p_rgb[2].value;
            GlobalShaderExecEnv.bake_3(bd, _aq_name.value, _aq_s.value, _aq_t.value, rgb);
        } while (++__iGrid < this.GridSize() && __fVarying);
        __iGrid = 0;
        GlobalShaderExecEnv.bake_done(bd);
    }

    @Override
    public void SO_bake_3p(IqShaderData name, IqShaderData s, IqShaderData t, IqShaderData f, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(109);
        boolean __fVarying = false;
        __fVarying = f.Class().getValue() == 3 || __fVarying;
        __fVarying = s.Class().getValue() == 3 || __fVarying;
        __fVarying = t.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        p_String _aq_name = new p_String();
        name.GetString(_aq_name, __iGrid);
        HashMap<String, BakingChannel> bd = GlobalShaderExecEnv.bake_init();
        __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_s = new p_float();
            s.GetFloat(_aq_s, __iGrid);
            p_float _aq_t = new p_float();
            t.GetFloat(_aq_t, __iGrid);
            CqVector3D _aq_f = new CqVector3D();
            f.GetPoint(_aq_f, __iGrid);
            float[] rgb = new float[]{_aq_f.valueAt(0), _aq_f.valueAt(1), _aq_f.valueAt(2)};
            GlobalShaderExecEnv.bake_3(bd, _aq_name.value, _aq_s.value, _aq_t.value, rgb);
        } while (++__iGrid < this.GridSize() && __fVarying);
        __iGrid = 0;
        GlobalShaderExecEnv.bake_done(bd);
    }

    @Override
    public void SO_bake_3n(IqShaderData name, IqShaderData s, IqShaderData t, IqShaderData f, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(109);
        boolean __fVarying = false;
        __fVarying = f.Class().getValue() == 3 || __fVarying;
        __fVarying = s.Class().getValue() == 3 || __fVarying;
        __fVarying = t.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        p_String _aq_name = new p_String();
        name.GetString(_aq_name, __iGrid);
        HashMap<String, BakingChannel> bd = GlobalShaderExecEnv.bake_init();
        __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_s = new p_float();
            s.GetFloat(_aq_s, __iGrid);
            p_float _aq_t = new p_float();
            t.GetFloat(_aq_t, __iGrid);
            CqVector3D _aq_f = new CqVector3D();
            f.GetNormal(_aq_f, __iGrid);
            float[] rgb = new float[]{_aq_f.valueAt(0), _aq_f.valueAt(1), _aq_f.valueAt(2)};
            GlobalShaderExecEnv.bake_3(bd, _aq_name.value, _aq_s.value, _aq_t.value, rgb);
        } while (++__iGrid < this.GridSize() && __fVarying);
        __iGrid = 0;
        GlobalShaderExecEnv.bake_done(bd);
    }

    @Override
    public void SO_bake_3v(IqShaderData name, IqShaderData s, IqShaderData t, IqShaderData f, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(109);
        boolean __fVarying = false;
        __fVarying = f.Class().getValue() == 3 || __fVarying;
        __fVarying = s.Class().getValue() == 3 || __fVarying;
        __fVarying = t.Class().getValue() == 3 || __fVarying;
        int __iGrid = 0;
        p_String _aq_name = new p_String();
        name.GetString(_aq_name, __iGrid);
        HashMap<String, BakingChannel> bd = GlobalShaderExecEnv.bake_init();
        __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p_float _aq_s = new p_float();
            s.GetFloat(_aq_s, __iGrid);
            p_float _aq_t = new p_float();
            t.GetFloat(_aq_t, __iGrid);
            CqVector3D _aq_f = new CqVector3D();
            f.GetVector(_aq_f, __iGrid);
            float[] rgb = new float[]{_aq_f.valueAt(0), _aq_f.valueAt(1), _aq_f.valueAt(2)};
            GlobalShaderExecEnv.bake_3(bd, _aq_name.value, _aq_s.value, _aq_t.value, rgb);
        } while (++__iGrid < this.GridSize() && __fVarying);
        __iGrid = 0;
        GlobalShaderExecEnv.bake_done(bd);
    }

    @Override
    public void SO_external(Method method, Object initData, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(151);
        boolean __fVarying = false;
        __fVarying = Result.Class().getValue() == 3 || __fVarying;
        int p = 0;
        while (p < cParams) {
            __fVarying = apParams[p].Class().getValue() == 3 || __fVarying;
            ++p;
        }
        int dso_argc = cParams + 1;
        Object[] dso_argv = new Object[dso_argc];
        switch (Result.Type().getValue()) {
            case 1: {
                dso_argv[0] = new p_float();
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                dso_argv[0] = new float[3];
                break;
            }
            case 4: {
                dso_argv[0] = new String();
                break;
            }
            case 11: 
            case 12: {
                dso_argv[0] = new float[16];
                break;
            }
        }
        p = 1;
        while (p <= cParams) {
            switch (apParams[p - 1].Type().getValue()) {
                case 1: {
                    dso_argv[p] = new p_float();
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    dso_argv[p] = new float[3];
                    break;
                }
                case 4: {
                    dso_argv[p] = new String();
                    break;
                }
                case 11: 
                case 12: {
                    dso_argv[0] = new float[16];
                    break;
                }
            }
            ++p;
        }
        int __iGrid = 0;
        CqBitVector RS = this.RunningState();
        do {
            CqMatrix m;
            Object s;
            CqColor c;
            CqVector3D v;
            if (__fVarying && !RS.Value(__iGrid)) continue;
            p = 1;
            while (p <= cParams) {
                switch (apParams[p - 1].Type().getValue()) {
                    case 1: {
                        apParams[p - 1].GetFloat((p_float)dso_argv[p], __iGrid);
                        break;
                    }
                    case 3: 
                    case 7: {
                        v = new CqVector3D();
                        apParams[p - 1].GetPoint(v, __iGrid);
                        ((float[])dso_argv[p])[0] = v.valueAt(0);
                        ((float[])dso_argv[p])[1] = v.valueAt(1);
                        ((float[])dso_argv[p])[2] = v.valueAt(2);
                        break;
                    }
                    case 6: 
                    case 9: {
                        v = new CqVector3D();
                        apParams[p - 1].GetVector(v, __iGrid);
                        ((float[])dso_argv[p])[0] = v.valueAt(0);
                        ((float[])dso_argv[p])[1] = v.valueAt(1);
                        ((float[])dso_argv[p])[2] = v.valueAt(2);
                        break;
                    }
                    case 8: {
                        v = new CqVector3D();
                        apParams[p - 1].GetNormal(v, __iGrid);
                        ((float[])dso_argv[p])[0] = v.valueAt(0);
                        ((float[])dso_argv[p])[1] = v.valueAt(1);
                        ((float[])dso_argv[p])[2] = v.valueAt(2);
                        break;
                    }
                    case 5: {
                        c = new CqColor();
                        apParams[p - 1].GetColor(c, __iGrid);
                        ((float[])dso_argv[p])[0] = c.valueAt(0);
                        ((float[])dso_argv[p])[1] = c.valueAt(1);
                        ((float[])dso_argv[p])[2] = c.valueAt(2);
                        break;
                    }
                    case 4: {
                        s = new p_String();
                        apParams[p - 1].GetString((p_String)s, __iGrid);
                        dso_argv[p] = ((p_String)s).value;
                        break;
                    }
                    case 11: 
                    case 12: {
                        m = new CqMatrix();
                        apParams[p - 1].GetMatrix(m, __iGrid);
                        int r = 0;
                        while (r < 4) {
                            int c2 = 0;
                            while (c2 < 4) {
                                ((float[])dso_argv[p])[r * 4 + c2] = m.m_aaElement[r][c2];
                                ++c2;
                            }
                            ++r;
                        }
                        break;
                    }
                }
                ++p;
            }
            try {
                method.invoke(null, initData, dso_argc, dso_argv);
            }
            catch (Exception e) {
                HimawariLogger.outputException(e);
            }
            switch (Result.Type().getValue()) {
                case 1: {
                    float val = ((p_float)dso_argv[0]).value;
                    Result.SetFloat(val, __iGrid);
                    break;
                }
                case 3: 
                case 7: {
                    v = new CqVector3D();
                    v.x = ((float[])dso_argv[0])[0];
                    v.y = ((float[])dso_argv[0])[1];
                    v.z = ((float[])dso_argv[0])[2];
                    Result.SetPoint(v, __iGrid);
                    break;
                }
                case 6: 
                case 9: {
                    v = new CqVector3D();
                    v.x = ((float[])dso_argv[0])[0];
                    v.y = ((float[])dso_argv[0])[1];
                    v.z = ((float[])dso_argv[0])[2];
                    Result.SetVector(v, __iGrid);
                    break;
                }
                case 8: {
                    v = new CqVector3D();
                    v.x = ((float[])dso_argv[0])[0];
                    v.y = ((float[])dso_argv[0])[1];
                    v.z = ((float[])dso_argv[0])[2];
                    Result.SetNormal(v, __iGrid);
                    break;
                }
                case 5: {
                    c = new CqColor();
                    c.setValueAt(0, ((float[])dso_argv[0])[0]);
                    c.setValueAt(1, ((float[])dso_argv[0])[1]);
                    c.setValueAt(2, ((float[])dso_argv[0])[2]);
                    Result.SetColor(c, __iGrid);
                    break;
                }
                case 4: {
                    s = new String((String)dso_argv[0]);
                    Result.SetString((String)s, __iGrid);
                    break;
                }
                case 11: 
                case 12: {
                    m = new CqMatrix((float[])dso_argv[0]);
                    Result.SetMatrix(m, __iGrid);
                    break;
                }
                default: {
                    System.out.println("Unsupported type");
                }
            }
            p = 1;
            while (p <= cParams) {
                switch (apParams[p - 1].Type().getValue()) {
                    case 1: {
                        float val = ((p_float)dso_argv[p]).value;
                        apParams[p - 1].SetFloat(val, __iGrid);
                        break;
                    }
                    case 3: 
                    case 7: {
                        CqVector3D v2 = new CqVector3D();
                        v2.x = ((float[])dso_argv[p])[0];
                        v2.y = ((float[])dso_argv[p])[1];
                        v2.z = ((float[])dso_argv[p])[2];
                        apParams[p - 1].SetPoint(v2, __iGrid);
                        break;
                    }
                    case 6: 
                    case 9: {
                        CqVector3D v3 = new CqVector3D();
                        v3.x = ((float[])dso_argv[p])[0];
                        v3.y = ((float[])dso_argv[p])[1];
                        v3.z = ((float[])dso_argv[p])[2];
                        apParams[p - 1].SetVector(v3, __iGrid);
                        break;
                    }
                    case 8: {
                        CqVector3D v4 = new CqVector3D();
                        v4.x = ((float[])dso_argv[p])[0];
                        v4.y = ((float[])dso_argv[p])[1];
                        v4.z = ((float[])dso_argv[p])[2];
                        apParams[p - 1].SetNormal(v4, __iGrid);
                        break;
                    }
                    case 5: {
                        CqColor c3 = new CqColor();
                        c3.setValueAt(0, ((float[])dso_argv[p])[0]);
                        c3.setValueAt(1, ((float[])dso_argv[p])[1]);
                        c3.setValueAt(2, ((float[])dso_argv[p])[2]);
                        apParams[p - 1].SetColor(c3, __iGrid);
                        break;
                    }
                    case 4: {
                        String s2 = new String((String)dso_argv[p]);
                        apParams[p - 1].SetString(s2, __iGrid);
                        break;
                    }
                    case 11: 
                    case 12: {
                        CqMatrix m2 = new CqMatrix((float[])dso_argv[p]);
                        apParams[p - 1].SetMatrix(m2, __iGrid);
                        break;
                    }
                }
                ++p;
            }
        } while (++__iGrid < this.GridSize() && __fVarying);
    }

    @Override
    public void SO_occlusion(IqShaderData occlmap, IqShaderData channel, IqShaderData P, IqShaderData N, IqShaderData samples, IqShaderData Result, IqShader pShader, int cParams, IqShaderData[] apParams) {
        CqStats.STATS_INC(199);
        boolean __fVarying = false;
        if (RiGlobal.QGetRenderContextI() == null) {
            return;
        }
        HashMap<String, IqShaderData> paramMap = new HashMap<String, IqShaderData>();
        this.GetTexParams(cParams, apParams, paramMap);
        int __iGrid = 0;
        p_String _aq_occlmap = new p_String();
        occlmap.GetString(_aq_occlmap, __iGrid);
        p_float _aq_samples = new p_float();
        samples.GetFloat(_aq_samples, __iGrid);
        IqTextureMap pMap = RiGlobal.QGetRenderContextI().GetShadowMap(_aq_occlmap.value);
        CqVector3D L = new CqVector3D(0.0f, 0.0f, -1.0f);
        __fVarying = true;
        if (pMap != null && pMap.IsValid()) {
            Valarray fv = new Valarray();
            pMap.PrepareSampleOptions(paramMap);
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                float occlsum = 0.0f;
                float dotsum = 0.0f;
                CqVector3D swidth = new CqVector3D(0.0f);
                CqVector3D twidth = new CqVector3D(0.0f);
                CqVector3D _aq_P = new CqVector3D();
                P.GetPoint(_aq_P, __iGrid);
                CqVector3D _aq_N = new CqVector3D();
                N.GetNormal(_aq_N, __iGrid);
                int i = pMap.NumPages() - 1;
                while (i >= 0) {
                    CqVector3D Nl = pMap.GetMatrix(2, i).multiply(_aq_N);
                    float cosangle = Nl.mul(L);
                    if (!(cosangle < 0.0f)) {
                        pMap.SampleMap(_aq_P, swidth, twidth, fv, i);
                        occlsum += cosangle * fv.valueAt(0);
                        dotsum += cosangle;
                    }
                    --i;
                }
                Result.SetFloat(occlsum /= dotsum, __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        } else {
            __iGrid = 0;
            CqBitVector RS = this.RunningState();
            do {
                if (__fVarying && !RS.Value(__iGrid)) continue;
                Result.SetFloat(0.0f, __iGrid);
            } while (++__iGrid < this.GridSize() && __fVarying);
        }
    }
}

