/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.parser;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.RendermanInterface;
import net.cellcomputing.himawari.main.Globalmain;
import net.cellcomputing.himawari.parser.BufferedYenEscapeReader;
import net.cellcomputing.himawari.parser.Global;
import net.cellcomputing.himawari.parser.Tokenizer;
import net.cellcomputing.himawari.parser.keywords.KeywordParser;
import net.cellcomputing.himawari.util.CellCipher;
import net.cellcomputing.himawari.util.HimawariLogger;

public strictfp class Parser {
    private HimawariLogger logger = HimawariLogger.getLogger();
    private static final String KEYWORD_PREFIX = "net.cellcomputing.himawari.parser.keywords.Keyword";
    private HashMap<String, KeywordParser> keywordParsers = new HashMap();
    private static int sizeType = 1;
    private static boolean tipType = false;

    public void parse(String filename) throws Exception {
        int tk;
        System.out.println(filename);
        InputStreamReader reader = null;
        reader = Globalmain.g_enc_flag.value ? CellCipher.getReader(filename) : new FileReader(filename);
        Tokenizer st = new Tokenizer(new BufferedYenEscapeReader(reader));
        st.commentChar(35);
        while ((tk = st.nextToken()) != -1) {
            try {
                if (tk != -3) {
                    throw new Exception("Expected keyword " + filename + " at line " + st.lineno());
                }
                String keyword = st.sval;
                KeywordParser kp = this.getKeyWordParser(keyword);
                kp.parse(st);
                kp.clearParameterList();
                kp = null;
            }
            catch (Exception pe) {
                this.logger.error(String.valueOf(pe.getClass().getSimpleName()) + ": " + pe.getMessage() + "\n");
                HimawariLogger.outputException(pe);
            }
        }
        ((Reader)reader).close();
    }

    public void parse(String filename, InputStream is) throws Exception {
        int tk;
        System.out.println(filename);
        Tokenizer st = new Tokenizer(new BufferedReader(new InputStreamReader(is)));
        st.commentChar(35);
        while ((tk = st.nextToken()) != -1) {
            try {
                if (tk != -3) {
                    throw new Exception("Expected keyword " + filename + " at line " + st.lineno());
                }
                String keyword = st.sval;
                KeywordParser kp = this.getKeyWordParser(keyword);
                kp.parse(st);
            }
            catch (Exception pe) {
                this.logger.error(String.valueOf(pe.getClass().getSimpleName()) + ": " + pe.getMessage() + "\n");
                HimawariLogger.outputException(pe);
            }
        }
    }

    private KeywordParser getKeyWordParser(String keyword) throws Exception {
        KeywordParser kp = this.keywordParsers.get(keyword.toLowerCase());
        if (kp == null) {
            char c = keyword.charAt(0);
            if (Character.isLowerCase(c)) {
                keyword = String.valueOf(Character.toUpperCase(c)) + keyword.substring(1);
            }
            kp = (KeywordParser)Class.forName(KEYWORD_PREFIX + keyword).newInstance();
            kp.setParser(this);
            this.keywordParsers.put(keyword.toLowerCase(), kp);
        }
        return kp;
    }

    public static void ParserDeclare(String Name, String Type2) {
        if (Global.DeclareParameterType(Name, Type2).getValue() == 0) {
            HimawariLogger.getLogger().error("RiDeclare: Unknown type [" + Name + ", " + Type2 + "]\n");
        }
        RendermanInterface.RiDeclare(Name, Type2);
    }

    public static EqVariableType ParseParameterType(String Source) {
        if (Source == null || Source.length() == 0) {
            HimawariLogger.getLogger().error("Cannot Parse Empty Parameter Type\n");
            return new EqVariableType(0);
        }
        sizeType = 1;
        Parser.setParamterSize(Source);
        StringTokenizer p_type = new StringTokenizer(Source);
        while (p_type.hasMoreTokens()) {
            String cleanword = Parser.CleanParameterType(p_type.nextToken());
            if (cleanword.equals("varying") || cleanword.equals("vertex") || cleanword.equals("facevarying")) {
                tipType = true;
                continue;
            }
            if (cleanword.equals("int") || cleanword.equals("integer")) {
                return new EqVariableType(2);
            }
            if (cleanword.equals("float")) {
                return new EqVariableType(1);
            }
            if (cleanword.equals("string")) {
                return new EqVariableType(4);
            }
            if (cleanword.equals("hpoint")) {
                sizeType *= 4;
                return new EqVariableType(7);
            }
            if (cleanword.equals("point")) {
                sizeType *= 3;
                return new EqVariableType(3);
            }
            if (cleanword.equals("color")) {
                sizeType *= 3;
                return new EqVariableType(5);
            }
            if (cleanword.equals("vector")) {
                sizeType *= 3;
                return new EqVariableType(9);
            }
            if (cleanword.equals("normal")) {
                sizeType *= 3;
                return new EqVariableType(8);
            }
            if (!cleanword.equals("matrix")) continue;
            sizeType *= 16;
            return new EqVariableType(11);
        }
        sizeType = 0;
        return new EqVariableType(0);
    }

    private static String CleanParameterType(String word) {
        String cleanword = word;
        if (word == null) {
            return null;
        }
        int index = word.indexOf("[");
        if (index > 0) {
            cleanword = word.substring(0, index);
        }
        return cleanword;
    }

    private static void setParamterSize(String Source) {
        int open = Source.indexOf("[");
        int close = Source.lastIndexOf("]");
        if (open < 1) {
            return;
        }
        if (open + 1 >= close) {
            sizeType = 0;
            return;
        }
        StringReader lbrace = new StringReader(Source.substring(open + 1, close));
        Tokenizer contents = new Tokenizer(lbrace);
        int ttype = 0;
        try {
            ttype = contents.nextToken();
            sizeType = ttype == -2 && contents.nextToken() == -1 && contents.nval % 1.0 == 0.0 ? (int)((double)sizeType * contents.nval) : 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getParameterSize() {
        return sizeType;
    }

    public static boolean getParameterTip() {
        return tipType;
    }
}

