/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library.types;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector4D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqSplineCubic {
    protected CqMatrix m_matBasis = new CqMatrix();
    protected int m_Step;
    protected int m_cu;
    protected STLVector<CqVector4D> m_aControlPoints = new STLVector<CqVector4D>(CqVector4D.class);
    protected CqVector4D m_vecFDPoint = new CqVector4D();
    protected CqVector4D m_vecFDDelta = new CqVector4D();
    protected CqVector4D m_vecFDDelta2 = new CqVector4D();
    protected CqVector4D m_vecFDDelta3 = new CqVector4D();
    private static float[][] gBezierBasis = new float[][]{{-1.0f, 3.0f, -3.0f, 1.0f}, {3.0f, -6.0f, 3.0f, 0.0f}, {-3.0f, 3.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f, 0.0f}};
    private static float[][] gBSplineBasis = new float[][]{{-0.16666667f, 0.5f, -0.5f, 0.16666667f}, {0.5f, -1.0f, 0.5f, 0.0f}, {-0.5f, 0.0f, 0.5f, 0.0f}, {0.16666667f, 0.6666667f, 0.16666667f, 0.0f}};
    private static float[][] gCatmullRomBasis = new float[][]{{-0.5f, 1.5f, -1.5f, 0.5f}, {1.0f, -2.5f, 2.0f, -0.5f}, {-0.5f, 0.0f, 0.5f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}};
    private static float[][] gHermiteBasis = new float[][]{{2.0f, 1.0f, -2.0f, 1.0f}, {-3.0f, -2.0f, 3.0f, -1.0f}, {0.0f, 1.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f, 0.0f}};
    private static float[][] gPowerBasis = new float[][]{{1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f}};
    static /* synthetic */ Class class$0;

    public CqSplineCubic() {
        this.m_matBasis = new CqMatrix(gBezierBasis);
        this.m_aControlPoints.setSize(4);
        this.m_cu = 4;
        this.m_Step = 3;
    }

    public CqSplineCubic(int cu) {
        this.m_matBasis = new CqMatrix(gBezierBasis);
        this.m_aControlPoints.setSize(cu);
        this.m_cu = cu;
        this.m_Step = 3;
    }

    public CqVector4D Evaluate(float t) {
        CqVector4D Gx = new CqVector4D();
        CqVector4D Gy = new CqVector4D();
        CqVector4D Gz = new CqVector4D();
        float u = (float)this.cSections() * t;
        int iSection = (int)u;
        t = u - (float)iSection;
        int iv = iSection * this.m_Step;
        Gx.x = ((CqVector4D)this.m_aControlPoints.get((int)(0 + iv))).x;
        Gx.y = ((CqVector4D)this.m_aControlPoints.get((int)(1 + iv))).x;
        Gx.z = ((CqVector4D)this.m_aControlPoints.get((int)(2 + iv))).x;
        Gx.w = ((CqVector4D)this.m_aControlPoints.get((int)(3 + iv))).x;
        Gy.x = ((CqVector4D)this.m_aControlPoints.get((int)(0 + iv))).y;
        Gy.y = ((CqVector4D)this.m_aControlPoints.get((int)(1 + iv))).y;
        Gy.z = ((CqVector4D)this.m_aControlPoints.get((int)(2 + iv))).y;
        Gy.w = ((CqVector4D)this.m_aControlPoints.get((int)(3 + iv))).y;
        Gz.x = ((CqVector4D)this.m_aControlPoints.get((int)(0 + iv))).z;
        Gz.y = ((CqVector4D)this.m_aControlPoints.get((int)(1 + iv))).z;
        Gz.z = ((CqVector4D)this.m_aControlPoints.get((int)(2 + iv))).z;
        Gz.w = ((CqVector4D)this.m_aControlPoints.get((int)(3 + iv))).z;
        Gx = this.m_matBasis.PreMultiply(Gx);
        Gy = this.m_matBasis.PreMultiply(Gy);
        Gz = this.m_matBasis.PreMultiply(Gz);
        float t2 = t * t;
        float t3 = t2 * t;
        float x = t3 * Gx.x + t2 * Gx.y + t * Gx.z + Gx.w;
        float y = t3 * Gy.x + t2 * Gy.y + t * Gy.z + Gy.w;
        float z = t3 * Gz.x + t2 * Gz.y + t * Gz.z + Gz.w;
        return new CqVector4D(x, y, z, 1.0f);
    }

    public void InitFD(int n) {
        float d = 1.0f / (float)n;
        float d2 = d * d;
        float d3 = d2 * d;
        CqVector4D Cx = new CqVector4D();
        CqVector4D Cy = new CqVector4D();
        CqVector4D Cz = new CqVector4D();
        Cx.x = ((CqVector4D)this.m_aControlPoints.get((int)0)).x;
        Cx.y = ((CqVector4D)this.m_aControlPoints.get((int)1)).x;
        Cx.z = ((CqVector4D)this.m_aControlPoints.get((int)2)).x;
        Cx.w = ((CqVector4D)this.m_aControlPoints.get((int)3)).x;
        Cy.x = ((CqVector4D)this.m_aControlPoints.get((int)0)).y;
        Cy.y = ((CqVector4D)this.m_aControlPoints.get((int)1)).y;
        Cy.z = ((CqVector4D)this.m_aControlPoints.get((int)2)).y;
        Cy.w = ((CqVector4D)this.m_aControlPoints.get((int)3)).y;
        Cz.x = ((CqVector4D)this.m_aControlPoints.get((int)0)).z;
        Cz.y = ((CqVector4D)this.m_aControlPoints.get((int)1)).z;
        Cz.z = ((CqVector4D)this.m_aControlPoints.get((int)2)).z;
        Cz.w = ((CqVector4D)this.m_aControlPoints.get((int)3)).z;
        Cx = this.m_matBasis.multiply(Cx);
        Cy = this.m_matBasis.multiply(Cy);
        Cz = this.m_matBasis.multiply(Cz);
        Cx.z = Cx.z * d + Cx.y * d2 + Cx.x * d3;
        Cx.x = Cx.x * 6.0f * d3;
        Cx.y = Cx.y * 2.0f * d2 + Cx.x;
        Cy.z = Cy.z * d + Cy.y * d2 + Cy.x * d3;
        Cy.x = Cy.x * 6.0f * d3;
        Cy.y = Cy.y * 2.0f * d2 + Cy.x;
        Cz.z = Cz.z * d + Cz.y * d2 + Cz.x * d3;
        Cz.x = Cz.x * 6.0f * d3;
        Cz.y = Cz.y * 2.0f * d2 + Cz.x;
        this.m_vecFDPoint = new CqVector4D(Cx.w, Cy.w, Cz.w, 1.0f);
        this.m_vecFDDelta = new CqVector4D(Cx.z, Cy.z, Cz.z, 1.0f);
        this.m_vecFDDelta2 = new CqVector4D(Cx.y, Cy.y, Cz.y, 1.0f);
        this.m_vecFDDelta3 = new CqVector4D(Cx.x, Cy.x, Cz.x, 1.0f);
    }

    public CqVector4D EvaluateFD() {
        CqVector4D vecPoint = this.m_vecFDPoint;
        this.m_vecFDPoint.assignAdd(this.m_vecFDDelta);
        this.m_vecFDDelta.assignAdd(this.m_vecFDDelta2);
        this.m_vecFDDelta2.assignAdd(this.m_vecFDDelta3);
        return vecPoint;
    }

    public STLVector<CqVector4D> aControlPoints() {
        STLVector<CqVector4D> tmp = new STLVector<CqVector4D>(CqVector4D.class, this.m_aControlPoints.size());
        int i = 0;
        while (i < this.m_aControlPoints.size()) {
            ((CqVector4D)tmp.get(i)).assignment((CqVector4D)this.m_aControlPoints.get(i));
            ++i;
        }
        return tmp;
    }

    public CqMatrix matBasis() {
        return new CqMatrix(this.m_matBasis);
    }

    public void SetmatBasis(CqMatrix mat) {
        this.m_matBasis.assignment(mat);
    }

    public void SetBasis(String strName) {
        float[][] pVals = null;
        int step = 3;
        if (strName.compareTo("bezier") == 0) {
            pVals = gBezierBasis;
            step = 3;
        } else if (strName.compareTo("bspline") == 0) {
            pVals = gBSplineBasis;
            step = 1;
        } else if (strName.compareTo("catmull-rom") == 0) {
            pVals = gCatmullRomBasis;
            step = 1;
        } else if (strName.compareTo("hermite") == 0) {
            pVals = gHermiteBasis;
            step = 2;
        } else if (strName.compareTo("power") == 0) {
            pVals = gPowerBasis;
            step = 4;
        }
        if (pVals != null) {
            CqMatrix m = new CqMatrix(pVals);
            this.SetmatBasis(m);
            this.SetStep(step);
        }
    }

    public int Step() {
        return this.m_Step;
    }

    public void SetStep(int Step) {
        this.m_Step = Step;
    }

    public int cSections() {
        return (this.m_cu - 4) / this.m_Step + 1;
    }

    public CqVector4D valueAt(int i) {
        assert (i < this.m_cu);
        return (CqVector4D)this.m_aControlPoints.get(i);
    }
}

