/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.Valarray;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqEnvironmentMap;
import net.cellcomputing.himawari.library.CqLatLongMap;
import net.cellcomputing.himawari.library.CqRiFile;
import net.cellcomputing.himawari.library.CqShadowMap;
import net.cellcomputing.himawari.library.CqTextureMapBuffer;
import net.cellcomputing.himawari.library.EqMapType;
import net.cellcomputing.himawari.library.EqTexFormat;
import net.cellcomputing.himawari.library.EqWrapMode;
import net.cellcomputing.himawari.library.IqShaderData;
import net.cellcomputing.himawari.library.IqTextureMap;
import net.cellcomputing.himawari.library.RendermanInterface;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.PublicFunctions;
import net.cellcomputing.himawari.main.Globalmain;
import net.cellcomputing.himawari.util.CellCipher;
import net.cellcomputing.himawari.util.HimawariLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqTextureMap
extends IqTextureMap {
    public static final int COMPRESSION_NONE = 1;
    public static final int PLANARCONFIG_CONTIG = 1;
    static ArrayList<CqTextureMap> m_TextureMap_Cache = new ArrayList();
    static STLVector<p_String> m_ConvertString_Cache = new STLVector<p_String>(p_String.class);
    int m_Compression = 1;
    int m_Quality = 70;
    float m_MinZ;
    long m_XRes = 0L;
    long m_YRes = 0L;
    int m_PlanarConfig = 1;
    int m_SamplesPerPixel = 3;
    int m_SampleFormat;
    int m_BitsPerSample;
    EqTexFormat m_Format;
    String m_strName;
    BufferedImage m_pImage;
    boolean m_IsValid;
    EqWrapMode m_smode;
    EqWrapMode m_tmode;
    Method m_FilterFunc;
    float m_swidth;
    float m_twidth;
    LinkedList<CqTextureMapBuffer> m_apSegments = new LinkedList();
    CqMatrix m_matWorldToScreen;
    float m_sblur;
    float m_tblur;
    float m_pswidth;
    float m_ptwidth;
    float m_samples;
    Valarray m_tempval1 = new Valarray();
    Valarray m_tempval2 = new Valarray();
    Valarray m_tempval3 = new Valarray();
    Valarray m_tempval4 = new Valarray();
    Valarray m_low_color = new Valarray();
    Valarray m_high_color = new Valarray();
    int m_Directory;
    static int correct;
    static int size;
    static CqTextureMap previous;
    static int env_size;
    static CqTextureMap env_previous;
    static int shadow_size;
    static CqTextureMap shadow_previous;
    static int lat_size;
    static CqTextureMap lat_previous;
    protected Raster raster = null;
    static float sqr;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        size = -1;
        previous = null;
        env_size = -1;
        env_previous = null;
        shadow_size = -1;
        shadow_previous = null;
        lat_size = -1;
        lat_previous = null;
        sqr = -1.0f;
    }

    public float INTERPOLATE1(float A, float B, float C) {
        return A + (B - A) * C;
    }

    public float INTERPOLATE2(float A, float B, float C, float D, float U, float V) {
        return this.INTERPOLATE1(this.INTERPOLATE1(A, B, U), this.INTERPOLATE1(C, D, U), V);
    }

    public static int ForceCorrect() {
        correct = -1;
        if (correct == -1) {
            int[] pCorrect = RiGlobal.QGetRenderContextI().GetIntegerOption("limits", "texturecorrect");
            correct = 0;
            if (pCorrect != null) {
                correct = pCorrect[0];
            }
        }
        return correct;
    }

    public CqTextureMap(String strName) {
        this.m_MinZ = Float.MAX_VALUE;
        this.m_Format = new EqTexFormat(0);
        this.m_strName = strName;
        this.m_pImage = null;
        this.m_IsValid = true;
        this.m_smode = new EqWrapMode(0);
        this.m_tmode = new EqWrapMode(0);
        try {
            this.m_FilterFunc = RendermanInterface.class.getMethod("RiBoxFilter", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
        }
        catch (SecurityException e) {
            HimawariLogger.outputException(e);
            this.m_FilterFunc = null;
        }
        catch (NoSuchMethodException e) {
            HimawariLogger.outputException(e);
            this.m_FilterFunc = null;
        }
        this.m_swidth = 1.0f;
        this.m_twidth = 1.0f;
        this.m_tempval1.resize(this.m_SamplesPerPixel);
        this.m_tempval2.resize(this.m_SamplesPerPixel);
        this.m_tempval3.resize(this.m_SamplesPerPixel);
        this.m_tempval4.resize(this.m_SamplesPerPixel);
        this.m_low_color.resize(this.m_SamplesPerPixel);
        this.m_high_color.resize(this.m_SamplesPerPixel);
    }

    public void destruct() {
        for (CqTextureMap i : m_TextureMap_Cache) {
            if (i != this) continue;
            m_TextureMap_Cache.remove(i);
            break;
        }
        for (CqTextureMapBuffer s : this.m_apSegments) {
            s.destruct();
        }
        this.m_apSegments.clear();
    }

    public static CqTextureMap GetTextureMap(String strName) {
        RiGlobal.QGetRenderContext().Stats().IncTextureMisses(0);
        if (size == m_TextureMap_Cache.size() && previous != null && CqTextureMap.previous.m_strName.equals(strName)) {
            RiGlobal.QGetRenderContext().Stats().IncTextureHits(0, 0);
            return previous;
        }
        for (CqTextureMap i : m_TextureMap_Cache) {
            if (!i.m_strName.equals(strName)) continue;
            if (i.Type().getValue() == 1) {
                previous = i;
                size = m_TextureMap_Cache.size();
                RiGlobal.QGetRenderContext().Stats().IncTextureHits(1, 0);
                return i;
            }
            return null;
        }
        CqTextureMap pNew = new CqTextureMap(strName);
        pNew.Open();
        if (pNew.Format().getValue() != 1) {
            if (!pNew.CreateMIPMAP(true)) {
                pNew.SetInvalid();
            }
            pNew.Close();
        }
        m_TextureMap_Cache.add(pNew);
        previous = pNew;
        size = m_TextureMap_Cache.size();
        return pNew;
    }

    public static CqTextureMap GetEnvironmentMap(String strName) {
        RiGlobal.QGetRenderContext().Stats().IncTextureMisses(1);
        if (env_size == m_TextureMap_Cache.size() && env_previous != null && CqTextureMap.env_previous.m_strName.equals(strName)) {
            RiGlobal.QGetRenderContext().Stats().IncTextureHits(0, 1);
            return env_previous;
        }
        for (CqTextureMap i : m_TextureMap_Cache) {
            if (i.m_strName != strName) continue;
            if (i.Type().getValue() == 2) {
                env_previous = i;
                env_size = m_TextureMap_Cache.size();
                RiGlobal.QGetRenderContext().Stats().IncTextureHits(1, 1);
                return i;
            }
            return null;
        }
        CqEnvironmentMap pNew = new CqEnvironmentMap(strName);
        m_TextureMap_Cache.add(pNew);
        pNew.Open();
        if (pNew.m_pImage == null) {
            HimawariLogger.getLogger().error("Map \"" + strName + "\" is not an environment map, use RiMakeCubeFaceEnvironment\n");
            pNew.SetInvalid();
            ((CqTextureMap)pNew).destruct();
            pNew = null;
        }
        if (pNew != null && pNew.Format().getValue() != 1 && !pNew.CreateMIPMAP(true)) {
            pNew.SetInvalid();
        }
        env_previous = pNew;
        env_size = m_TextureMap_Cache.size();
        return pNew;
    }

    public void shadowOpen() {
        block21: {
            this.m_IsValid = false;
            CqRiFile fileImage = new CqRiFile(this.m_strName, "texture");
            if (!fileImage.IsValid()) {
                HimawariLogger.getLogger().error("Cannot open texture file \"" + this.m_strName + "\"\n");
                return;
            }
            String strRealName = fileImage.strRealName();
            fileImage.Close();
            RandomAccessFile file = null;
            try {
                file = new RandomAccessFile(strRealName, "r");
                this.m_SamplesPerPixel = 1;
                this.m_tempval1.resize(this.m_SamplesPerPixel);
                this.m_tempval2.resize(this.m_SamplesPerPixel);
                this.m_tempval3.resize(this.m_SamplesPerPixel);
                this.m_tempval4.resize(this.m_SamplesPerPixel);
                this.m_low_color.resize(this.m_SamplesPerPixel);
                this.m_high_color.resize(this.m_SamplesPerPixel);
                String tag_name = file.readLine();
                if (tag_name != null && tag_name.equals("START_SHADOW_HEADER")) {
                    String[] split;
                    tag_name = file.readLine();
                    if (tag_name.contains("SHADOW_WIDTH")) {
                        split = tag_name.split("\\W");
                        this.m_XRes = Integer.parseInt(split[1]);
                    }
                    if ((tag_name = file.readLine()) == null || !tag_name.contains("SHADOW_HEIGHT")) {
                        this.m_IsValid = false;
                        HimawariLogger.getLogger().error("invalid image file \"" + this.m_strName + "\"\n");
                        return;
                    }
                    split = tag_name.split("\\W");
                    this.m_YRes = Integer.parseInt(split[1]);
                    this.m_Format = new EqTexFormat(0);
                    this.m_IsValid = true;
                    this.m_Directory = 0;
                    break block21;
                }
                this.m_IsValid = false;
                HimawariLogger.getLogger().error("invalid image file \"" + this.m_strName + "\"\n");
                return;
            }
            catch (IOException e) {
                HimawariLogger.outputException(e);
                break block21;
            }
            {
                finally {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (IOException e1) {
                            HimawariLogger.outputException(e1);
                        }
                    }
                }
            }
        }
    }

    public static CqTextureMap GetShadowMap(String strName) {
        RiGlobal.QGetRenderContext().Stats().IncTextureMisses(3);
        if (shadow_size == m_TextureMap_Cache.size() && shadow_previous != null && CqTextureMap.shadow_previous.m_strName.equals(strName)) {
            RiGlobal.QGetRenderContext().Stats().IncTextureHits(0, 3);
            return shadow_previous;
        }
        for (CqTextureMap i : m_TextureMap_Cache) {
            if (!i.m_strName.equals(strName)) continue;
            if (i.Type().getValue() == 4) {
                shadow_previous = i;
                shadow_size = m_TextureMap_Cache.size();
                RiGlobal.QGetRenderContext().Stats().IncTextureHits(1, 3);
                return i;
            }
            return null;
        }
        CqShadowMap pNew = new CqShadowMap(strName);
        m_TextureMap_Cache.add(pNew);
        pNew.shadowOpen();
        pNew.ReadMatrices();
        shadow_previous = pNew;
        shadow_size = m_TextureMap_Cache.size();
        return pNew;
    }

    public static CqTextureMap GetLatLongMap(String strName) {
        RiGlobal.QGetRenderContext().Stats().IncTextureMisses(2);
        if (size == m_TextureMap_Cache.size() && lat_previous != null && CqTextureMap.lat_previous.m_strName.equals(strName)) {
            RiGlobal.QGetRenderContext().Stats().IncTextureHits(0, 2);
            return lat_previous;
        }
        for (CqTextureMap i : m_TextureMap_Cache) {
            if (!i.m_strName.equals(strName)) continue;
            if (i.Type().getValue() == 5) {
                lat_previous = i;
                lat_size = m_TextureMap_Cache.size();
                RiGlobal.QGetRenderContext().Stats().IncTextureHits(1, 2);
                return i;
            }
            return null;
        }
        CqLatLongMap pNew = new CqLatLongMap(strName);
        m_TextureMap_Cache.add(pNew);
        pNew.Open();
        if (pNew.m_pImage == null) {
            HimawariLogger.getLogger().error("Map \"" + strName + "\" is not an environment map, use RiMakeLatLongEnvironment\n");
            pNew.SetInvalid();
        }
        lat_previous = pNew;
        lat_size = m_TextureMap_Cache.size();
        return pNew;
    }

    void SetInvalid() {
        this.m_IsValid = false;
    }

    public boolean CreateMIPMAP() {
        return this.CreateMIPMAP(false);
    }

    public boolean CreateMIPMAP(boolean fProtectBuffers) {
        if (this.m_pImage != null) {
            CqTextureMapBuffer pBuffer = this.GetBuffer(0L, 0L, 0, fProtectBuffers);
            int m_xres = (int)this.m_XRes;
            int m_yres = (int)this.m_YRes;
            int directory = 0;
            do {
                CqTextureMapBuffer pTMB;
                if ((pTMB = this.CreateBuffer(0L, 0L, m_xres, m_yres, directory, fProtectBuffers)).pVoidBufferData() != null) {
                    int y = 0;
                    while (y < m_yres) {
                        int temp = this.SamplesPerPixel();
                        float[] accum = new float[temp];
                        int x = 0;
                        while (x < m_xres) {
                            this.ImageFilterVal2(pBuffer, x, y, directory, m_xres, m_yres, accum);
                            int sample = 0;
                            while (sample < this.m_SamplesPerPixel) {
                                pTMB.SetValue(x, y, sample, accum[sample]);
                                ++sample;
                            }
                            ++x;
                        }
                        ++y;
                    }
                    this.m_apSegments.add(pTMB);
                }
                ++directory;
            } while ((m_xres /= 2) > 2 && (m_yres /= 2) > 2);
        }
        return true;
    }

    public static void FlushCache() {
        CqTextureMap i;
        while (m_TextureMap_Cache.size() > 0 && (i = m_TextureMap_Cache.get(0)) != null) {
            i.destruct();
        }
        m_TextureMap_Cache.clear();
    }

    @Override
    public long XRes() {
        return this.m_XRes;
    }

    @Override
    public long YRes() {
        return this.m_YRes;
    }

    @Override
    public int SamplesPerPixel() {
        return this.m_SamplesPerPixel;
    }

    @Override
    public EqTexFormat Format() {
        return this.m_Format;
    }

    @Override
    public EqMapType Type() {
        return this.IsValid() ? new EqMapType(1) : new EqMapType(0);
    }

    @Override
    public void Open() {
        block21: {
            this.m_IsValid = false;
            CqRiFile fileImage = new CqRiFile(this.m_strName, "texture");
            if (!fileImage.IsValid()) {
                HimawariLogger.getLogger().error("Cannot open texture file \"" + this.m_strName + "\"\n");
                return;
            }
            String strRealName = fileImage.strRealName();
            fileImage.Close();
            InputStream is = null;
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                is = Globalmain.g_enc_flag.value ? CellCipher.getInputStream(strRealName) : new FileInputStream(strRealName);
                this.m_pImage = ImageIO.read(is);
                if (this.m_pImage != null) {
                    HimawariLogger.getLogger().info("TextureMap: \"" + strRealName + "\" is open\n");
                    this.m_XRes = this.m_pImage.getWidth();
                    this.m_YRes = this.m_pImage.getHeight();
                    int samplesperpixel = 1;
                    this.m_SamplesPerPixel = samplesperpixel = this.m_pImage.getRaster().getNumBands();
                    this.m_tempval1.resize(this.m_SamplesPerPixel);
                    this.m_tempval2.resize(this.m_SamplesPerPixel);
                    this.m_tempval3.resize(this.m_SamplesPerPixel);
                    this.m_tempval4.resize(this.m_SamplesPerPixel);
                    this.m_low_color.resize(this.m_SamplesPerPixel);
                    this.m_high_color.resize(this.m_SamplesPerPixel);
                    isr = new InputStreamReader(is);
                    br = new BufferedReader(isr);
                    String pModes = br.readLine();
                    if (pModes != null) {
                        this.Interpreted(pModes);
                    }
                } else {
                    HimawariLogger.getLogger().error("invalid image file \"" + this.m_strName + "\"\n");
                    return;
                }
                this.m_Format = new EqTexFormat(0);
                this.m_IsValid = true;
                this.m_Directory = 0;
            }
            catch (FileNotFoundException e) {
                HimawariLogger.outputException(e);
            }
            catch (IOException e) {
                HimawariLogger.outputException(e);
            }
            break block21;
            {
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        if (isr != null) {
                            isr.close();
                        }
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException e) {
                        HimawariLogger.outputException(e);
                    }
                }
            }
        }
    }

    @Override
    public void Close() {
        this.m_pImage = null;
    }

    @Override
    public boolean IsValid() {
        return this.m_IsValid;
    }

    @Override
    public void PrepareSampleOptions(HashMap<String, IqShaderData> paramMap) {
        this.m_sblur = 0.0f;
        this.m_tblur = 0.0f;
        this.m_pswidth = 1.0f;
        this.m_ptwidth = 1.0f;
        this.m_samples = 16.0f;
        if (paramMap.size() != 0) {
            p_float temp_value = new p_float();
            if (paramMap.containsKey("width")) {
                paramMap.get("width").GetFloat(temp_value);
                this.m_ptwidth = this.m_pswidth = temp_value.value;
            } else {
                if (paramMap.containsKey("swidth")) {
                    paramMap.get("swidth").GetFloat(temp_value);
                    this.m_pswidth = temp_value.value;
                }
                if (paramMap.containsKey("twidth")) {
                    paramMap.get("twidth").GetFloat(temp_value);
                    this.m_ptwidth = temp_value.value;
                }
            }
            if (paramMap.containsKey("blur")) {
                paramMap.get("blur").GetFloat(temp_value);
                this.m_sblur = temp_value.value;
                this.m_sblur /= CqTextureMap.FindBlurRatio();
                this.m_tblur = this.m_sblur;
            } else {
                if (paramMap.containsKey("sblur")) {
                    paramMap.get("sblur").GetFloat(temp_value);
                    this.m_sblur = temp_value.value;
                    this.m_sblur /= CqTextureMap.FindBlurRatio();
                }
                if (paramMap.containsKey("tblur")) {
                    paramMap.get("tblur").GetFloat(temp_value);
                    this.m_tblur = temp_value.value;
                    this.m_tblur /= CqTextureMap.FindBlurRatio();
                }
            }
            if (paramMap.containsKey("samples")) {
                paramMap.get("samples").GetFloat(temp_value);
                this.m_samples = temp_value.value;
            }
        }
    }

    @Override
    public void SampleMap(float s1, float t1, float swidth, float twidth, Valarray val) {
        this.CriticalMeasure();
        if (!this.IsValid()) {
            return;
        }
        swidth *= this.m_pswidth;
        twidth *= this.m_ptwidth;
        val.resize(this.m_SamplesPerPixel);
        val.assignment(0.0f);
        if (this.m_smode.getValue() == 1 && (double)(s1 %= 1.0f) < 0.0) {
            s1 += 1.0f;
        }
        if (this.m_tmode.getValue() == 1 && (double)(t1 %= 1.0f) < 0.0) {
            t1 += 1.0f;
        }
        if (this.m_smode.getValue() == 0 && (s1 < 0.0f || s1 > 1.0f)) {
            return;
        }
        if (this.m_tmode.getValue() == 0 && (t1 < 0.0f || t1 > 1.0f)) {
            return;
        }
        if (this.m_smode.getValue() == 2 || this.Type().getValue() == 2) {
            s1 = PublicFunctions.CLAMP(s1, 0.0f, 1.0f);
        }
        if (this.m_tmode.getValue() == 2 || this.Type().getValue() == 2) {
            t1 = PublicFunctions.CLAMP(t1, 0.0f, 1.0f);
        }
        float ss1 = s1 - swidth - this.m_sblur * 0.5f;
        float tt1 = t1 - twidth - this.m_tblur * 0.5f;
        ss1 = PublicFunctions.CLAMP(ss1, 0.0f, 1.0f);
        tt1 = PublicFunctions.CLAMP(tt1, 0.0f, 1.0f);
        float ss2 = s1 + swidth + this.m_sblur * 0.5f;
        float tt2 = t1 + twidth + this.m_tblur * 0.5f;
        ss2 = PublicFunctions.CLAMP(ss2, 0.0f, 1.0f);
        tt2 = PublicFunctions.CLAMP(tt2, 0.0f, 1.0f);
        float tmp = ss1;
        ss1 = Math.min(ss1, ss2);
        ss2 = Math.max(tmp, ss2);
        tmp = tt1;
        tt1 = Math.min(tt1, tt2);
        tt2 = Math.max(tmp, tt2);
        this.GetSample(ss1, tt1, ss2, tt2, val);
    }

    public void GetSample(float u1, float v1, float u2, float v2, Valarray val) {
        if (this.m_sblur != 0.0f || this.m_tblur != 0.0f) {
            this.GetSampleTri(u1, v1, u2, v2, val);
        } else {
            this.GetSampleSgle(u1, v1, u2, v2, val);
        }
    }

    public void GetSampleSgle(float u1, float v1, float u2, float v2, Valarray val) {
        RiGlobal.QGetRenderContext().Stats().TextureMapTimer().Start();
        float UVArea = (float)Math.sqrt(Math.abs((u2 - u1) * (v2 - v1)));
        float u = (u2 + u1) / 2.0f;
        float v = (v2 + v1) / 2.0f;
        float d = Math.min(UVArea, 1.0f);
        long size = Math.min(this.m_XRes, this.m_YRes);
        long id = (long)Math.floor(d * (float)size);
        boolean singlelevel = id == 0L || id == size;
        int umapsize = (int)this.m_XRes;
        int vmapsize = (int)this.m_YRes;
        int level = 0;
        while (id > 1L) {
            id >>= 1;
            ++level;
            if ((umapsize >>= 1) < 8 || (vmapsize >>= 1) < 8) break;
        }
        this.BiLinear(u, v, umapsize, vmapsize, level, this.m_low_color);
        if (singlelevel) {
            int c = 0;
            while (c < this.m_SamplesPerPixel) {
                val.setValueAt(c, this.m_low_color.valueAt(c));
                ++c;
            }
        } else {
            size = Math.min(umapsize, vmapsize);
            float a = 1.0f / (float)size;
            float b = 1.0f / (float)(size / 2L);
            float interp = (d - a) / (b - a);
            this.BiLinear(u, v, umapsize >>= 1, vmapsize >>= 1, ++level, this.m_high_color);
            int c = 0;
            while (c < this.m_SamplesPerPixel) {
                val.setValueAt(c, this.INTERPOLATE1(this.m_low_color.valueAt(c), this.m_high_color.valueAt(c), interp));
                ++c;
            }
        }
        RiGlobal.QGetRenderContext().Stats().TextureMapTimer().Stop();
    }

    public CqTextureMapBuffer GetBuffer(long s, long t, int directory) {
        return this.GetBuffer(s, t, directory, false);
    }

    public CqTextureMapBuffer GetBuffer(long s, long t, int directory, boolean fProt) {
        RiGlobal.QGetRenderContext().Stats().IncTextureMisses(4);
        if (this.m_apSegments.size() > 0 && this.m_apSegments.getFirst().IsValid(s, t, directory)) {
            RiGlobal.QGetRenderContext().Stats().IncTextureHits(1, 4);
            return this.m_apSegments.getFirst();
        }
        for (CqTextureMapBuffer i : this.m_apSegments) {
            if (!i.IsValid(s, t, directory)) continue;
            RiGlobal.QGetRenderContext().Stats().IncTextureHits(1, 4);
            CqTextureMapBuffer pbuffer = i;
            this.m_apSegments.remove(i);
            this.m_apSegments.addFirst(pbuffer);
            return pbuffer;
        }
        CqTextureMapBuffer pTMB = null;
        if (this.m_pImage == null) {
            CqRiFile fileImage = new CqRiFile(this.m_strName, "texture");
            if (!fileImage.IsValid()) {
                HimawariLogger.getLogger().error("Cannot open texture file \"" + this.m_strName + "\"\n");
                return pTMB;
            }
            String strRealName = fileImage.strRealName();
            fileImage.Close();
            try {
                this.m_pImage = ImageIO.read(new File(strRealName));
            }
            catch (IOException e) {
                HimawariLogger.outputException(e);
            }
        }
        if (this.m_pImage != null) {
            long tsx = this.m_XRes;
            long tsy = this.m_YRes;
            long ox = s / tsx * tsx;
            long oy = t / tsy * tsy;
            pTMB = this.CreateBuffer(ox, oy, tsx, tsy, directory, fProt);
            WritableRaster raster = this.m_pImage.getRaster();
            int[] buf = new int[raster.getNumBands()];
            Byte[] pdata = (Byte[])pTMB.pVoidBufferData();
            int count = 0;
            int i = 0;
            while ((long)i < this.m_YRes) {
                int j = 0;
                while ((long)j < this.m_XRes) {
                    raster.getPixel(j, i, buf);
                    int k = 0;
                    while (k < buf.length) {
                        byte temp_byte = (byte)(buf[k] - 128);
                        pdata[count] = temp_byte;
                        ++count;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            this.m_apSegments.addFirst(pTMB);
        }
        return pTMB;
    }

    public CqTextureMapBuffer CreateBuffer(long xorigin, long yorigin, long width, long height, int directory, boolean fProt) {
        CqTextureMapBuffer pRes = new CqTextureMapBuffer();
        pRes.Init(xorigin, yorigin, width, height, this.m_SamplesPerPixel, directory, fProt);
        return pRes;
    }

    public CqTextureMapBuffer CreateBuffer(long xorigin, long yorigin, long width, long height, int directory) {
        return this.CreateBuffer(xorigin, yorigin, width, height, directory, false);
    }

    public CqTextureMapBuffer CreateBuffer(long xorigin, long yorigin, long width, long height) {
        return this.CreateBuffer(xorigin, yorigin, width, height, 0);
    }

    public boolean BiLinear(float u, float v, int umapsize, int vmapsize, int id, Valarray m_color) {
        CqTextureMapBuffer pTMBa;
        long umapsize1 = umapsize - 1;
        long vmapsize1 = vmapsize - 1;
        long iu = (long)Math.floor(u * (float)umapsize1);
        double ru = (double)u * (double)umapsize1 - (double)iu;
        long iu_n = (long)Math.floor((double)(u * (float)umapsize1) + 1.0);
        iu_n %= (long)umapsize;
        long iv = (long)Math.floor(v * (float)vmapsize1);
        double rv = (double)v * (double)vmapsize1 - (double)iv;
        long iv_n = (long)Math.floor((double)(v * (float)vmapsize1) + 1.0);
        CqTextureMapBuffer pTMBb = pTMBa = this.GetBuffer(iu %= (long)umapsize, iv %= (long)vmapsize, id);
        if (iv != (iv_n %= (long)vmapsize)) {
            pTMBb = this.GetBuffer(iu, iv_n, id);
        }
        CqTextureMapBuffer pTMBc = pTMBa;
        if (iu_n != iu) {
            pTMBc = this.GetBuffer(iu_n, iv, id);
        }
        CqTextureMapBuffer pTMBd = null;
        pTMBd = iv == iv_n ? pTMBc : (iu == iu_n ? pTMBb : this.GetBuffer(iu_n, iv_n, id));
        if (pTMBa == null || pTMBb == null || pTMBc == null || pTMBd == null) {
            int c = 0;
            while (c < this.m_SamplesPerPixel) {
                m_color.setValueAt(c, 1.0f);
                ++c;
            }
            HimawariLogger.getLogger().error("Cannot find value for either pTMPB[a,b,c,d]\n");
            return false;
        }
        iu -= pTMBa.sOrigin();
        iu_n -= pTMBc.sOrigin();
        iv -= pTMBa.tOrigin();
        iv_n -= pTMBb.tOrigin();
        int c = 0;
        while (c < this.m_SamplesPerPixel) {
            float Val00 = pTMBa.GetValue((int)iu, (int)iv, c);
            float Val01 = pTMBc.GetValue((int)iu_n, (int)iv, c);
            float Val10 = pTMBb.GetValue((int)iu, (int)iv_n, c);
            float Val11 = pTMBd.GetValue((int)iu_n, (int)iv_n, c);
            m_color.setValueAt(c, this.INTERPOLATE2(Val00, Val01, Val10, Val11, (float)ru, (float)rv));
            ++c;
        }
        return true;
    }

    public void GetSampleTri(float u1, float v1, float u2, float v2, Valarray val) {
        int c;
        float mul;
        float v;
        RiGlobal.QGetRenderContext().Stats().TextureMapTimer().Start();
        float cs = (u1 + u2) * 0.5f;
        float ct = (v1 + v2) * 0.5f;
        Method pFilter = null;
        try {
            pFilter = RendermanInterface.class.getMethod("RiSincFilter", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
        }
        catch (SecurityException e) {
            HimawariLogger.outputException(e);
        }
        catch (NoSuchMethodException e) {
            HimawariLogger.outputException(e);
        }
        float ds = u1 - cs;
        float dt = v1 - ct;
        float diag = ds * ds * (float)this.m_XRes * (float)this.m_XRes + dt * dt * (float)this.m_YRes * (float)this.m_YRes;
        ds = u2 - cs;
        dt = v2 - ct;
        diag = Math.min(diag, ds * ds * (float)this.m_XRes * (float)this.m_XRes + dt * dt * (float)this.m_YRes * (float)this.m_YRes);
        float l = (float)(Math.log(diag) / (2.0 * Math.log(2.0)));
        l = Math.max(l, 0.0f);
        int id = (int)Math.floor(l);
        float offset = l - (float)id;
        offset = Math.min(offset, 1.0f);
        int umapsize = (int)this.m_XRes;
        int vmapsize = (int)this.m_YRes;
        boolean singlelevel = false;
        if (this.m_Directory != 0 && CqTextureMap.ForceCorrect() != 0 && id > this.m_Directory) {
            id = this.m_Directory;
        }
        int idx = 0;
        while (idx < id && umapsize > 8 && vmapsize > 8) {
            ++idx;
            umapsize >>= 1;
            vmapsize >>= 1;
        }
        if (idx != id) {
            id = idx;
        }
        this.m_low_color.assignment(0.0f);
        this.m_Directory = id;
        if (umapsize < 3 || vmapsize < 3) {
            singlelevel = true;
        }
        if ((double)cs == 0.0 || (double)cs == 1.0) {
            singlelevel = true;
        }
        if ((double)ct == 0.0 || (double)ct == 1.0) {
            singlelevel = true;
        }
        this.m_low_color.assignment(0.0f);
        float div = 0.0f;
        float deltau = 1.0f / (this.m_pswidth * (float)umapsize);
        float deltav = 1.0f / (this.m_ptwidth * (float)vmapsize);
        float u = u1;
        while (u <= u2) {
            v = v1;
            while (v <= v2) {
                this.BiLinear(u, v, umapsize, vmapsize, id, this.m_tempval1);
                try {
                    mul = ((Float)pFilter.invoke((Object)Float.valueOf(u - cs), Float.valueOf(v - ct), 2.0 * (double)cs, 2.0 * (double)ct)).floatValue();
                }
                catch (IllegalArgumentException e) {
                    HimawariLogger.outputException(e);
                    mul = 1.0f;
                }
                catch (IllegalAccessException e) {
                    HimawariLogger.outputException(e);
                    mul = 1.0f;
                }
                catch (InvocationTargetException e) {
                    HimawariLogger.outputException(e);
                    mul = 1.0f;
                }
                if (!(mul < 1.1920929E-7f)) {
                    div += mul;
                    c = 0;
                    while (c < this.m_SamplesPerPixel) {
                        this.m_low_color.setValueAt(c, this.m_low_color.valueAt(c) + mul * this.m_tempval1.valueAt(c));
                        ++c;
                    }
                }
                v += deltav;
            }
            u += deltau;
        }
        c = 0;
        while (c < this.m_SamplesPerPixel) {
            this.m_low_color.setValueAt(c, this.m_low_color.valueAt(c) / div);
            ++c;
        }
        if (singlelevel) {
            c = 0;
            while (c < this.m_SamplesPerPixel) {
                val.setValueAt(c, this.m_low_color.valueAt(c));
                ++c;
            }
        } else {
            ++id;
            this.m_high_color.assignment(0.0f);
            div = 0.0f;
            deltau = 1.0f / (this.m_pswidth * (float)(umapsize >>= 1));
            deltav = 1.0f / (this.m_ptwidth * (float)(vmapsize >>= 1));
            u = u1;
            while (u <= u2) {
                v = v1;
                while (v <= v2) {
                    this.BiLinear(u, v, umapsize, vmapsize, id, this.m_tempval1);
                    try {
                        mul = ((Float)pFilter.invoke((Object)Float.valueOf(u - cs), Float.valueOf(v - ct), 2.0 * (double)cs, 2.0 * (double)ct)).floatValue();
                    }
                    catch (IllegalArgumentException e) {
                        mul = 1.0f;
                        HimawariLogger.outputException(e);
                    }
                    catch (IllegalAccessException e) {
                        mul = 1.0f;
                        HimawariLogger.outputException(e);
                    }
                    catch (InvocationTargetException e) {
                        mul = 1.0f;
                        HimawariLogger.outputException(e);
                    }
                    if (!(mul < 1.1920929E-7f)) {
                        div += mul;
                        c = 0;
                        while (c < this.m_SamplesPerPixel) {
                            this.m_high_color.setValueAt(c, this.m_high_color.valueAt(c) + mul * this.m_tempval1.valueAt(c));
                            ++c;
                        }
                    }
                    v += deltav;
                }
                u += deltau;
            }
            c = 0;
            while (c < this.m_SamplesPerPixel) {
                this.m_high_color.setValueAt(c, this.m_high_color.valueAt(c) / div);
                ++c;
            }
            c = 0;
            while (c < this.m_SamplesPerPixel) {
                val.setValueAt(c, (1.0f - offset) * this.m_low_color.valueAt(c) + offset * this.m_high_color.valueAt(c));
                ++c;
            }
        }
        RiGlobal.QGetRenderContext().Stats().TextureMapTimer().Stop();
    }

    @Override
    public void SampleMap(float s1, float t1, float s2, float t2, float s3, float t3, float s4, float t4, Valarray val) {
    }

    @Override
    public void SampleMap(CqVector3D R, CqVector3D swidth, CqVector3D twidth, Valarray val, int index, p_float average_depth, p_float shadow_depth) {
    }

    @Override
    public void SampleMap(CqVector3D R1, CqVector3D R2, CqVector3D R3, CqVector3D R4, Valarray val, int index, p_float average_depth, p_float shadow_depth) {
    }

    @Override
    public CqMatrix GetMatrix(int which, int index) {
        return null;
    }

    @Override
    public int NumPages() {
        return 1;
    }

    public void CriticalMeasure() {
        int current;
        int[] poptMem = RiGlobal.QGetRenderContextI().GetIntegerOption("limits", "texturememory");
        int limit = 0x800000;
        if (poptMem != null) {
            limit = poptMem[0] * 1024;
        }
        int now = RiGlobal.QGetRenderContext().Stats().GetTextureMemory();
        if (RiGlobal.m_critical) {
            for (CqTextureMap i : m_TextureMap_Cache) {
                if (i == this) continue;
                for (CqTextureMapBuffer j : i.m_apSegments) {
                    if (j.fProtected()) continue;
                    j.Release();
                }
                i.m_apSegments.clear();
                current = RiGlobal.QGetRenderContext().Stats().GetTextureMemory();
                if (now - current > limit / 4) break;
            }
        }
        current = RiGlobal.QGetRenderContext().Stats().GetTextureMemory();
        RiGlobal.m_critical = false;
    }

    public void Interpreted(String mode) {
        String filter = "";
        String smode = "";
        String tmode = "";
        String sep = "[,\\s\\t]";
        String[] token = mode.split(sep);
        if (token.length > 0) {
            smode = token[0];
            if (token.length > 1) {
                tmode = token[1];
                if (token.length > 2) {
                    filter = token[2];
                    if (token.length > 3) {
                        this.m_swidth = Float.parseFloat(token[3]);
                        if (token.length > 4) {
                            this.m_twidth = Float.parseFloat(token[4]);
                        }
                    }
                }
            }
        }
        try {
            this.m_FilterFunc = RendermanInterface.class.getMethod("RiBoxFilter", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            if (filter.equals("gaussian")) {
                this.m_FilterFunc = RendermanInterface.class.getMethod("RiGaussianFilter", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            }
            if (filter.equals("box")) {
                this.m_FilterFunc = RendermanInterface.class.getMethod("RiBoxFilter", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            }
            if (filter.equals("triangle")) {
                this.m_FilterFunc = RendermanInterface.class.getMethod("RiTriangleFilter", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            }
            if (filter.equals("catmull-rom")) {
                this.m_FilterFunc = RendermanInterface.class.getMethod("RiCatmullRomFilter", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            }
            if (filter.equals("sinc")) {
                this.m_FilterFunc = RendermanInterface.class.getMethod("RiSincFilter", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            }
            if (filter.equals("disk")) {
                this.m_FilterFunc = RendermanInterface.class.getMethod("RiDiskFilter", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            }
            if (filter.equals("bessel")) {
                this.m_FilterFunc = RendermanInterface.class.getMethod("RiBesselFilter", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            }
        }
        catch (SecurityException e) {
            this.m_FilterFunc = null;
            HimawariLogger.outputException(e);
        }
        catch (NoSuchMethodException e) {
            this.m_FilterFunc = null;
            HimawariLogger.outputException(e);
        }
        this.m_smode = this.m_tmode = new EqWrapMode(2);
        if (smode.equals("periodic")) {
            this.m_smode = new EqWrapMode(1);
        } else if (smode.equals("clamp")) {
            this.m_smode = new EqWrapMode(2);
        } else if (smode.equals("black")) {
            this.m_smode = new EqWrapMode(0);
        }
        if (tmode.equals("periodic")) {
            this.m_tmode = new EqWrapMode(1);
        } else if (tmode.equals("clamp")) {
            this.m_tmode = new EqWrapMode(2);
        } else if (tmode.equals("black")) {
            this.m_tmode = new EqWrapMode(0);
        }
    }

    public void ImageFilterVal(CqTextureMapBuffer pData, int x, int y, int directory, int m_xres, int m_yres, STLVector<Float> accum) {
        Method pFilter = this.m_FilterFunc;
        int delta = 1 << directory;
        float div = 0.0f;
        float mul = 0.0f;
        int xdelta = (int)Math.max(Math.floor(this.m_swidth) * (double)(delta / 2), 1.0);
        int ydelta = (int)Math.max(Math.floor(this.m_twidth) * (double)(delta / 2), 1.0);
        int xdelta2 = xdelta * 2;
        int ydelta2 = ydelta * 2;
        float fx = (float)x / (float)(m_xres - 1);
        float fy = (float)y / (float)(m_yres - 1);
        accum.assign(this.SamplesPerPixel(), Float.valueOf(0.0f));
        if (directory != 0) {
            int isample = 0;
            while (isample < this.SamplesPerPixel()) {
                accum.setElementAt(Float.valueOf(0.0f), isample);
                ++isample;
            }
            int j = -ydelta;
            while (j <= ydelta) {
                int i = -xdelta;
                while (i <= xdelta) {
                    try {
                        mul = ((Float)pFilter.invoke(null, Float.valueOf(i), Float.valueOf(j), Float.valueOf(xdelta2), Float.valueOf(ydelta2))).floatValue();
                    }
                    catch (IllegalArgumentException e) {
                        HimawariLogger.outputException(e);
                    }
                    catch (IllegalAccessException e) {
                        HimawariLogger.outputException(e);
                    }
                    catch (InvocationTargetException e) {
                        HimawariLogger.outputException(e);
                    }
                    if ((double)mul != 0.0) {
                        int ypos = (int)(fy * (float)this.m_YRes - 1.0f) + j;
                        int xpos = (int)(fx * (float)this.m_XRes - 1.0f) + i;
                        if (ypos >= 0 && xpos >= 0 && ypos <= (int)this.m_YRes - 1 && xpos <= (int)this.m_XRes - 1) {
                            isample = 0;
                            while (isample < this.SamplesPerPixel()) {
                                accum.setElementAt(Float.valueOf(pData.GetValue(xpos, ypos, isample) * mul + ((Float)accum.elementAt(isample)).floatValue()), isample);
                                ++isample;
                            }
                            div += mul;
                        }
                    }
                    ++i;
                }
                ++j;
            }
            isample = 0;
            while (isample < this.SamplesPerPixel()) {
                accum.setElementAt(Float.valueOf(((Float)accum.elementAt(isample)).floatValue() / div), isample);
                ++isample;
            }
        } else {
            int isample = 0;
            while (isample < this.SamplesPerPixel()) {
                accum.setElementAt(Float.valueOf(pData.GetValue(x, y, isample)), isample);
                ++isample;
            }
        }
    }

    public static float FindBlurRatio() {
        if ((double)sqr < 0.0) {
            float[] pCorrect = RiGlobal.QGetRenderContextI().GetFloatOption("limits", "textureblur");
            sqr = 1.2f;
            if (pCorrect != null) {
                sqr = Math.max(0.1f, pCorrect[0]);
            }
        }
        return sqr;
    }

    public void ImageFilterVal2(CqTextureMapBuffer pData, int x, int y, int directory, int m_xres, int m_yres, float[] accum) {
        Method pFilter = this.m_FilterFunc;
        int delta = 1 << directory;
        float div = 0.0f;
        float mul = 0.0f;
        int xdelta = (int)Math.max(Math.floor(this.m_swidth) * (double)(delta / 2), 1.0);
        int ydelta = (int)Math.max(Math.floor(this.m_twidth) * (double)(delta / 2), 1.0);
        int xdelta2 = xdelta * 2;
        int ydelta2 = ydelta * 2;
        float fx = (float)x / (float)(m_xres - 1);
        float fy = (float)y / (float)(m_yres - 1);
        int i = 0;
        while (i < accum.length) {
            accum[i] = 0.0f;
            ++i;
        }
        if (directory != 0) {
            int isample = 0;
            while (isample < this.SamplesPerPixel()) {
                accum[isample] = 0.0f;
                ++isample;
            }
            int j = -ydelta;
            while (j <= ydelta) {
                i = -xdelta;
                while (i <= xdelta) {
                    try {
                        mul = ((Float)pFilter.invoke(null, Float.valueOf(i), Float.valueOf(j), Float.valueOf(xdelta2), Float.valueOf(ydelta2))).floatValue();
                    }
                    catch (IllegalArgumentException e) {
                        HimawariLogger.outputException(e);
                    }
                    catch (IllegalAccessException e) {
                        HimawariLogger.outputException(e);
                    }
                    catch (InvocationTargetException e) {
                        HimawariLogger.outputException(e);
                    }
                    if ((double)mul != 0.0) {
                        int ypos = (int)(fy * (float)this.m_YRes - 1.0f) + j;
                        int xpos = (int)(fx * (float)this.m_XRes - 1.0f) + i;
                        if (ypos >= 0 && xpos >= 0 && ypos <= (int)this.m_YRes - 1 && xpos <= (int)this.m_XRes - 1) {
                            isample = 0;
                            while (isample < this.SamplesPerPixel()) {
                                accum[isample] = pData.GetValue(xpos, ypos, isample) * mul + accum[isample];
                                ++isample;
                            }
                            div += mul;
                        }
                    }
                    ++i;
                }
                ++j;
            }
            isample = 0;
            while (isample < this.SamplesPerPixel()) {
                if (div != 0.0f) {
                    accum[isample] = accum[isample] / div;
                }
                ++isample;
            }
        } else {
            int isample = 0;
            while (isample < this.SamplesPerPixel()) {
                accum[isample] = pData.GetValue(x, y, isample);
                ++isample;
            }
        }
    }

    public int Compression() {
        return this.m_Compression;
    }

    public void SetCompression(int Compression) {
        this.m_Compression = Compression;
    }

    public int Quality() {
        return this.m_Quality;
    }

    public void SetQuality(int Quality) {
        this.m_Quality = Quality;
    }

    public float MinZ() {
        return this.m_MinZ;
    }

    public void SetMinZ(float minz) {
        if (minz <= this.m_MinZ) {
            this.m_MinZ = minz;
        }
    }
}

