/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.CqMotionSpec;
import net.cellcomputing.himawari.library.CqPolygonPoints;
import net.cellcomputing.himawari.library.CqSurface;
import net.cellcomputing.himawari.library.IqMotionSpec;
import net.cellcomputing.himawari.util.AccessSupplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class CqSurfaceMotionImple
extends CqSurface
implements IqMotionSpec<CqPolygonPoints> {
    protected STLVector<Float> m_aTimes = new STLVector<Float>(Float.class);
    protected STLVector<CqPolygonPoints> m_aObjects;
    protected CqPolygonPoints m_DefObject;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CqSurfaceMotionImple() {
    }

    public CqSurfaceMotionImple(CqSurface From) {
        super(From);
    }

    protected void CqMotionSpec(CqPolygonPoints a) {
        this.m_DefObject = a;
        this.m_aObjects = new STLVector<CqPolygonPoints>(CqPolygonPoints.class);
    }

    protected void CqMotionSpec(IqMotionSpec<CqPolygonPoints> From) {
        this.m_aObjects = new STLVector<CqPolygonPoints>(CqPolygonPoints.class);
        this.assignment(From);
    }

    @Override
    public void assignment(IqMotionSpec<CqPolygonPoints> From) {
        this.m_aTimes.clear();
        this.m_aObjects.clear();
        this.m_aTimes.addAll((STLVector)AccessSupplier.getField(From, "m_aTimes"));
        this.m_aObjects.addAll((STLVector)AccessSupplier.getField(From, "m_aObjects"));
        this.m_DefObject = (CqPolygonPoints)AccessSupplier.getField(From, "m_DefObject");
    }

    @Override
    public void assignment(CqMotionSpec<CqPolygonPoints> From) {
        this.assignment(From);
    }

    @Override
    public void AddTimeSlot(float time, CqPolygonPoints Object2) {
        p_int iIndex = new p_int();
        if (this.iTimes() == 0) {
            this.m_aTimes.add(Float.valueOf(time));
            this.m_aObjects.add(Object2);
            return;
        }
        if (this.TimeSlotExists(time, iIndex)) {
            this.ClearMotionObject((CqPolygonPoints)this.m_aObjects.elementAt(iIndex.value));
            this.m_aObjects.setElementAt(Object2, iIndex.value);
        } else {
            int index = 0;
            while (index != this.m_aTimes.size() && ((Float)this.m_aTimes.elementAt(index)).floatValue() < time) {
                ++index;
            }
            this.m_aTimes.add(index, Float.valueOf(time));
            this.m_aObjects.add(index, Object2);
        }
    }

    @Override
    public void ConcatTimeSlot(float time, CqPolygonPoints Object2) {
        p_int iIndex = new p_int();
        if (this.TimeSlotExists(time, iIndex)) {
            this.m_aObjects.setElementAt(this.ConcatMotionObjects((CqPolygonPoints)this.m_aObjects.elementAt(iIndex.value), Object2), iIndex.value);
        } else {
            this.AddTimeSlot(time, this.m_DefObject);
            this.TimeSlotExists(time, iIndex);
            this.m_aObjects.setElementAt(this.ConcatMotionObjects((CqPolygonPoints)this.m_aObjects.elementAt(iIndex.value), Object2), iIndex.value);
        }
    }

    @Override
    public void ConcatAllTimeSlots(CqPolygonPoints Object2) {
        int index = 0;
        while (index < this.m_aObjects.size()) {
            this.m_aObjects.setElementAt(this.ConcatMotionObjects((CqPolygonPoints)this.m_aObjects.elementAt(index), Object2), index);
            ++index;
        }
    }

    @Override
    public float Time(int index) {
        if (this.m_aTimes.size() == 0) {
            return 0.0f;
        }
        if (index < 0) {
            return ((Float)this.m_aTimes.elementAt(0)).floatValue();
        }
        if (index < this.iTimes()) {
            return ((Float)this.m_aTimes.elementAt(index)).floatValue();
        }
        return ((Float)this.m_aTimes.lastElement()).floatValue();
    }

    @Override
    public int iTimes() {
        return this.m_aTimes.size();
    }

    @Override
    public boolean fMotionBlurred() {
        return this.iTimes() > 1;
    }

    @Override
    public boolean GetTimeSlot(float time, p_int iIndex, p_float Fraction) {
        assert (this.iTimes() > 0);
        if (time >= ((Float)this.m_aTimes.lastElement()).floatValue()) {
            iIndex.value = this.m_aTimes.size() - 1;
            return true;
        }
        if (time <= ((Float)this.m_aTimes.firstElement()).floatValue()) {
            iIndex.value = 0;
            return true;
        }
        iIndex.value = 0;
        while (time >= ((Float)this.m_aTimes.elementAt(iIndex.value + 1)).floatValue()) {
            ++iIndex.value;
        }
        Fraction.value = (time - ((Float)this.m_aTimes.elementAt(iIndex.value)).floatValue()) / (((Float)this.m_aTimes.elementAt(iIndex.value + 1)).floatValue() - ((Float)this.m_aTimes.elementAt(iIndex.value)).floatValue());
        return ((Float)this.m_aTimes.elementAt(iIndex.value)).floatValue() == time;
    }

    @Override
    public boolean TimeSlotExists(float time, p_int iIndex) {
        iIndex.value = 0;
        while (iIndex.value < this.iTimes() && time != ((Float)this.m_aTimes.elementAt(iIndex.value)).floatValue()) {
            ++iIndex.value;
        }
        return iIndex.value < this.iTimes();
    }

    @Override
    public CqPolygonPoints GetMotionObjectInterpolated(float time) {
        p_int iIndex = new p_int();
        p_float Fraction = new p_float();
        if (this.GetTimeSlot(time, iIndex, Fraction)) {
            return (CqPolygonPoints)this.m_aObjects.elementAt(iIndex.value);
        }
        return this.LinearInterpolateMotionObjects(Fraction.value, (CqPolygonPoints)this.m_aObjects.elementAt(iIndex.value), (CqPolygonPoints)this.m_aObjects.elementAt(iIndex.value + 1));
    }

    @Override
    public CqPolygonPoints GetMotionObject(float time) {
        p_int iIndex = new p_int();
        p_float Fraction = new p_float();
        if (this.GetTimeSlot(time, iIndex, Fraction)) {
            return (CqPolygonPoints)this.m_aObjects.elementAt(iIndex.value);
        }
        assert (false);
        return this.m_DefObject;
    }

    @Override
    public CqPolygonPoints GetMotionObject(int iIndex) {
        assert (iIndex >= 0 && iIndex < this.iTimes());
        return (CqPolygonPoints)this.m_aObjects.elementAt(iIndex);
    }

    @Override
    public void SetDefaultObject(CqPolygonPoints a) {
        this.m_DefObject = a;
    }

    @Override
    public void Reset() {
        this.m_aTimes.clear();
        for (CqPolygonPoints tmp : this.m_aObjects) {
            this.ClearMotionObject(tmp);
        }
        this.m_aObjects.clear();
    }
}

