/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import java.io.PrintStream;
import net.cellcomputing.himawari.library.CqStatTimer;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.util.HimawariLogger;

public strictfp class CqStats {
    private static final int CLOCKS_PER_SEC = 1000;
    private float m_Complete;
    private static float[] m_floatVars = new float[4];
    private static int[] m_intVars = new int[270];
    private int m_cTextureMemory;
    private int[][] m_cTextureHits = new int[2][5];
    private int[] m_cTextureMisses = new int[5];
    private CqStatTimer m_timeTotal = new CqStatTimer();
    private CqStatTimer m_timeTotalFrame = new CqStatTimer();
    private CqStatTimer m_timeSurface = new CqStatTimer();
    private CqStatTimer m_timeImager = new CqStatTimer();
    private CqStatTimer m_timeDisplacement = new CqStatTimer();
    private CqStatTimer m_timeAtmosphere = new CqStatTimer();
    private CqStatTimer m_timeSplits = new CqStatTimer();
    private CqStatTimer m_timeDicing = new CqStatTimer();
    private CqStatTimer m_timeRenderMPGs = new CqStatTimer();
    private CqStatTimer m_timeOcclusionCull = new CqStatTimer();
    private CqStatTimer m_timeDiceable = new CqStatTimer();
    private CqStatTimer m_timeTM = new CqStatTimer();
    private CqStatTimer m_timeMakeTexture = new CqStatTimer();
    private CqStatTimer m_timeMakeShadow = new CqStatTimer();
    private CqStatTimer m_timeMakeEnv = new CqStatTimer();
    private CqStatTimer m_timeFB = new CqStatTimer();
    private CqStatTimer m_timeDB = new CqStatTimer();
    private CqStatTimer m_timeCombine = new CqStatTimer();
    private CqStatTimer m_timeParse = new CqStatTimer();
    private CqStatTimer m_timeProject = new CqStatTimer();
    private CqStatTimer m_timeOthers = new CqStatTimer();

    public CqStats() {
        this.Initialise();
    }

    public void Initialise() {
        this.m_Complete = 0.0f;
        this.InitialiseFrame();
    }

    public void InitialiseFrame() {
        this.m_cTextureMemory = 0;
        this.m_cTextureHits = new int[2][5];
        this.m_cTextureMisses = new int[5];
        this.m_timeTotalFrame.Reset();
        this.m_timeSurface.Reset();
        this.m_timeDisplacement.Reset();
        this.m_timeImager.Reset();
        this.m_timeAtmosphere.Reset();
        this.m_timeSplits.Reset();
        this.m_timeDicing.Reset();
        this.m_timeRenderMPGs.Reset();
        this.m_timeOcclusionCull.Reset();
        this.m_timeDiceable.Reset();
        this.m_timeTM.Reset();
        this.m_timeMakeTexture.Reset();
        this.m_timeMakeShadow.Reset();
        this.m_timeMakeEnv.Reset();
        this.m_timeFB.Reset();
        this.m_timeDB.Reset();
        this.m_timeParse.Reset();
        this.m_timeProject.Reset();
        this.m_timeCombine.Reset();
        this.m_timeOthers.Reset();
    }

    public float Complete() {
        return this.m_Complete;
    }

    public void SetComplete(float complete) {
        this.m_Complete = complete;
    }

    public static void IncI(int index) {
        int n = index;
        m_intVars[n] = m_intVars[n] + 1;
    }

    public static void DecI(int index) {
        int n = index;
        m_intVars[n] = m_intVars[n] - 1;
    }

    public static void setI(int index, int value) {
        CqStats.m_intVars[index] = value;
    }

    public static int getI(int index) {
        return m_intVars[index];
    }

    public static void setF(int index, float value) {
        CqStats.m_floatVars[index] = value;
    }

    public static float getF(int index) {
        return m_floatVars[index];
    }

    public static int log2(int value) {
        assert (value >= 1);
        return (int)(StrictMath.log(value) / StrictMath.log(2.0));
    }

    public void IncTextureMemory(int n) {
        this.m_cTextureMemory += n;
    }

    public void IncTextureMemory() {
        this.IncTextureMemory(0);
    }

    public void IncTextureHits(int primary, int which) {
        int[] nArray = this.m_cTextureHits[primary];
        int n = which;
        nArray[n] = nArray[n] + 1;
    }

    public void IncTextureMisses(int which) {
        int n = which;
        this.m_cTextureMisses[n] = this.m_cTextureMisses[n] + 1;
    }

    public int GetTextureMemory() {
        return this.m_cTextureMemory;
    }

    public void StartFrameTimer() {
        this.m_timeTotalFrame.Reset();
        if (!this.m_timeTotalFrame.isStarted()) {
            this.m_timeTotalFrame.Start();
        }
    }

    public void StopFrameTimer() {
        this.m_timeTotalFrame.Stop();
        this.m_timeTotal.assignAdd(this.m_timeTotalFrame);
    }

    CqStatTimer SurfaceTimer() {
        return this.m_timeSurface;
    }

    CqStatTimer DisplacementTimer() {
        return this.m_timeDisplacement;
    }

    CqStatTimer ImagerTimer() {
        return this.m_timeImager;
    }

    CqStatTimer AtmosphereTimer() {
        return this.m_timeAtmosphere;
    }

    CqStatTimer SplitsTimer() {
        return this.m_timeSplits;
    }

    CqStatTimer DicingTimer() {
        return this.m_timeDicing;
    }

    CqStatTimer TextureMapTimer() {
        return this.m_timeTM;
    }

    CqStatTimer RenderMPGsTimer() {
        return this.m_timeRenderMPGs;
    }

    CqStatTimer OcclusionCullTimer() {
        return this.m_timeOcclusionCull;
    }

    CqStatTimer DiceableTimer() {
        return this.m_timeDiceable;
    }

    CqStatTimer MakeTextureTimer() {
        return this.m_timeMakeTexture;
    }

    CqStatTimer MakeShadowTimer() {
        return this.m_timeMakeShadow;
    }

    CqStatTimer MakeEnvTimer() {
        return this.m_timeMakeEnv;
    }

    CqStatTimer MakeFilterBucket() {
        return this.m_timeFB;
    }

    CqStatTimer MakeDisplayBucket() {
        return this.m_timeDB;
    }

    CqStatTimer MakeCombine() {
        return this.m_timeCombine;
    }

    CqStatTimer MakeParse() {
        return this.m_timeParse;
    }

    CqStatTimer MakeProject() {
        return this.m_timeProject;
    }

    CqStatTimer Others() {
        return this.m_timeOthers;
    }

    public void PrintStats(int level) {
        HimawariLogger logger = HimawariLogger.getLogger();
        PrintStream MSG = System.out;
        float timeTotal = this.m_timeSurface.TimeTotal() + this.m_timeDisplacement.TimeTotal() + this.m_timeImager.TimeTotal() + this.m_timeAtmosphere.TimeTotal() + this.m_timeSplits.TimeTotal() + this.m_timeDicing.TimeTotal() + this.m_timeRenderMPGs.TimeTotal() + this.m_timeOcclusionCull.TimeTotal() + this.m_timeDiceable.TimeTotal() + this.m_timeMakeTexture.TimeTotal() + this.m_timeMakeShadow.TimeTotal() + this.m_timeMakeEnv.TimeTotal() + this.m_timeTM.TimeTotal() + this.m_timeFB.TimeTotal() + this.m_timeDB.TimeTotal() + this.m_timeParse.TimeTotal() + this.m_timeProject.TimeTotal() + this.m_timeCombine.TimeTotal() + this.m_timeOthers.TimeTotal();
        logger.info("Total render time: " + this.TimeToString(this.m_timeTotal.TimeTotal(), -1.0f) + "\n");
        logger.info("Last frame: " + this.TimeToString(this.m_timeTotalFrame.TimeTotal(), -1.0f) + "\n");
        System.err.flush();
        if (level >= 1) {
            MSG.println();
            MSG.print("Parsing             : ");
            this.TimeToString(MSG, this.m_timeParse.TimeTotal(), this.m_timeTotalFrame.TimeTotal()).println();
            MSG.print("Diceable check      : ");
            this.TimeToString(MSG, this.m_timeDiceable.TimeTotal(), this.m_timeTotalFrame.TimeTotal()).println();
            MSG.print("Splitting           : ");
            this.TimeToString(MSG, this.m_timeSplits.TimeTotal(), this.m_timeTotalFrame.TimeTotal()).println();
            MSG.print("Dicing              : ");
            this.TimeToString(MSG, this.m_timeDicing.TimeTotal(), this.m_timeTotalFrame.TimeTotal()).println();
            MSG.print("Render MPGs         : ");
            this.TimeToString(MSG, this.m_timeRenderMPGs.TimeTotal(), this.m_timeTotalFrame.TimeTotal()).println();
            MSG.print("Occlusion Culling   : ");
            this.TimeToString(MSG, this.m_timeOcclusionCull.TimeTotal(), this.m_timeTotalFrame.TimeTotal()).println();
            MSG.print("Imager shading      : ");
            this.TimeToString(MSG, this.m_timeImager.TimeTotal(), this.m_timeTotalFrame.TimeTotal()).println();
            MSG.print("Surface shading     : ");
            this.TimeToString(MSG, this.m_timeSurface.TimeTotal(), this.m_timeTotalFrame.TimeTotal()).println();
            MSG.print("Displacement shading: ");
            this.TimeToString(MSG, this.m_timeDisplacement.TimeTotal(), this.m_timeTotalFrame.TimeTotal()).println();
            MSG.print("Atmosphere shading  : ");
            this.TimeToString(MSG, this.m_timeAtmosphere.TimeTotal(), this.m_timeTotalFrame.TimeTotal()).println();
            MSG.print("SampleTexture       : ");
            this.TimeToString(MSG, this.m_timeTM.TimeTotal(), this.m_timeTotalFrame.TimeTotal()).println();
            MSG.print("Combine             : ");
            this.TimeToString(MSG, this.m_timeCombine.TimeTotal(), this.m_timeTotalFrame.TimeTotal()).println();
            MSG.print("Project             : ");
            this.TimeToString(MSG, this.m_timeProject.TimeTotal(), this.m_timeTotalFrame.TimeTotal()).println();
            MSG.print("FilterBucket        : ");
            this.TimeToString(MSG, this.m_timeFB.TimeTotal(), this.m_timeTotalFrame.TimeTotal()).println();
            MSG.print("DisplayBucket       : ");
            this.TimeToString(MSG, this.m_timeDB.TimeTotal(), this.m_timeTotalFrame.TimeTotal()).println();
            MSG.print("MakeTexture         : ");
            this.TimeToString(MSG, this.m_timeMakeTexture.TimeTotal(), this.m_timeTotalFrame.TimeTotal()).println();
            MSG.print("MakeShadow          : ");
            this.TimeToString(MSG, this.m_timeMakeShadow.TimeTotal(), this.m_timeTotalFrame.TimeTotal()).println();
            MSG.print("MakeCubeEnv         : ");
            this.TimeToString(MSG, this.m_timeMakeEnv.TimeTotal(), this.m_timeTotalFrame.TimeTotal()).println();
            MSG.print("Others              : ");
            this.TimeToString(MSG, this.m_timeOthers.TimeTotal(), this.m_timeTotalFrame.TimeTotal()).println();
            MSG.print("Total time measured : ");
            this.TimeToString(MSG, timeTotal, this.m_timeTotalFrame.TimeTotal()).println();
            MSG.println();
        }
        if (level == 2 || level == 3) {
            float _gpr_c_q = 100.0f * (float)CqStats.STATS_INT_GETI(6) / (float)CqStats.STATS_INT_GETI(3);
            float _gpr_u_q = 100.0f * (float)CqStats.STATS_INT_GETI(3) / (float)CqStats.STATS_INT_GETI(1);
            MSG.print("Input geometry:\n\t" + CqStats.STATS_INT_GETI(2) + " primitives created\n\n" + "\t" + CqStats.STATS_INT_GETI(9) + " subdivision primitives\n\t" + CqStats.STATS_INT_GETI(7) + " NURBS primitives\n\t" + CqStats.STATS_INT_GETI(8) + " polygons\n\t" + CqStats.STATS_INT_GETI(10) + " curves\n\t" + CqStats.STATS_INT_GETI(11) + " points\n\t" + CqStats.STATS_INT_GETI(13) + " patches\n\t" + CqStats.STATS_INT_GETI(12) + " quadrics\n\t" + "\n");
            MSG.print("GPrims:\n\t" + CqStats.STATS_INT_GETI(1) + " allocated\n\t" + CqStats.STATS_INT_GETI(3) + " used (" + _gpr_u_q + "%), " + CqStats.STATS_INT_GETI(5) + " peak,\n\t" + CqStats.STATS_INT_GETI(6) + " culled (" + _gpr_c_q + "%)\n" + "\n");
            float _geo_crv_s_q = 100.0f * (float)CqStats.STATS_INT_GETI(14) / (float)CqStats.STATS_INT_GETI(10);
            float _geo_crv_s_c_q = 100.0f * (float)CqStats.STATS_INT_GETI(15) / (float)CqStats.STATS_INT_GETI(14);
            float _geo_crv_s_p_q = 100.0f * (float)CqStats.STATS_INT_GETI(16) / (float)CqStats.STATS_INT_GETI(14);
            float _geo_prc_s_q = 100.0f * (float)CqStats.STATS_INT_GETI(20) / (float)CqStats.STATS_INT_GETI(19);
            MSG.print("Geometry:\n\tCurves:\n\t\t" + CqStats.STATS_INT_GETI(10) + " created\n\t" + "\t" + CqStats.STATS_INT_GETI(14) + " split (" + _geo_crv_s_q + "%)\n\t\t\t" + CqStats.STATS_INT_GETI(15) + " (" + _geo_crv_s_c_q + "%) into " + CqStats.STATS_INT_GETI(17) + " subcurves\n\t\t\t" + CqStats.STATS_INT_GETI(16) + " (" + _geo_crv_s_p_q + "%) into " + CqStats.STATS_INT_GETI(18) + " patches\n\t" + "Procedurals:\n" + "\t\t" + CqStats.STATS_INT_GETI(19) + " created\n\t" + "\t" + CqStats.STATS_INT_GETI(20) + " split (" + _geo_prc_s_q + "%)\n\t\t" + CqStats.STATS_INT_GETI(21) + " dynamic load,\n\t\t" + CqStats.STATS_INT_GETI(22) + " dynamic read archive,\n\t\t" + CqStats.STATS_INT_GETI(23) + " run program\n\t\t" + "\n");
            int _grd_init = CqStats.STATS_INT_GETI(30) + CqStats.STATS_INT_GETI(31) + CqStats.STATS_INT_GETI(32) + CqStats.STATS_INT_GETI(33) + CqStats.STATS_INT_GETI(34) + CqStats.STATS_INT_GETI(35) + CqStats.STATS_INT_GETI(36) + CqStats.STATS_INT_GETI(37);
            int _grd_shade = CqStats.STATS_INT_GETI(38) + CqStats.STATS_INT_GETI(39) + CqStats.STATS_INT_GETI(40) + CqStats.STATS_INT_GETI(41) + CqStats.STATS_INT_GETI(42) + CqStats.STATS_INT_GETI(43) + CqStats.STATS_INT_GETI(44) + CqStats.STATS_INT_GETI(45);
            float _grd_init_quote = 100.0f * (float)_grd_init / (float)CqStats.STATS_INT_GETI(24);
            float _grd_shade_quote = 100.0f * (float)_grd_shade / (float)CqStats.STATS_INT_GETI(24);
            float _grd_cull_quote = 100.0f * (float)CqStats.STATS_INT_GETI(25) / (float)CqStats.STATS_INT_GETI(24);
            float _grd_4 = 100.0f * (float)CqStats.STATS_INT_GETI(30) / (float)_grd_init;
            float _grd_8 = 100.0f * (float)CqStats.STATS_INT_GETI(31) / (float)_grd_init;
            float _grd_16 = 100.0f * (float)CqStats.STATS_INT_GETI(32) / (float)_grd_init;
            float _grd_32 = 100.0f * (float)CqStats.STATS_INT_GETI(33) / (float)_grd_init;
            float _grd_64 = 100.0f * (float)CqStats.STATS_INT_GETI(34) / (float)_grd_init;
            float _grd_128 = 100.0f * (float)CqStats.STATS_INT_GETI(35) / (float)_grd_init;
            float _grd_256 = 100.0f * (float)CqStats.STATS_INT_GETI(36) / (float)_grd_init;
            float _grd_g256 = 100.0f * (float)CqStats.STATS_INT_GETI(37) / (float)_grd_init;
            float _grd_shd_4 = 100.0f * (float)CqStats.STATS_INT_GETI(38) / (float)_grd_shade;
            float _grd_shd_8 = 100.0f * (float)CqStats.STATS_INT_GETI(39) / (float)_grd_shade;
            float _grd_shd_16 = 100.0f * (float)CqStats.STATS_INT_GETI(40) / (float)_grd_shade;
            float _grd_shd_32 = 100.0f * (float)CqStats.STATS_INT_GETI(41) / (float)_grd_shade;
            float _grd_shd_64 = 100.0f * (float)CqStats.STATS_INT_GETI(42) / (float)_grd_shade;
            float _grd_shd_128 = 100.0f * (float)CqStats.STATS_INT_GETI(43) / (float)_grd_shade;
            float _grd_shd_256 = 100.0f * (float)CqStats.STATS_INT_GETI(44) / (float)_grd_shade;
            float _grd_shd_g256 = 100.0f * (float)CqStats.STATS_INT_GETI(45) / (float)_grd_shade;
            MSG.print("Grids:\n\t" + CqStats.STATS_INT_GETI(24) + " created, " + CqStats.STATS_INT_GETI(27) + " peak,\n\t" + _grd_init + " initialized (" + _grd_init_quote + "%),\n\t" + _grd_shade + " shaded (" + _grd_shade_quote + "%), " + CqStats.STATS_INT_GETI(25) + " culled (" + _grd_cull_quote + "%)\n\n" + "\tGrid count/size (diced grids):\n" + "\t+------+------+------+------+------+------+------+------+\n" + "\t|<=  4 |<=  8 |<= 16 |<= 32 |<= 64 |<=128 |<=256 | >256 |\n" + "\t+------+------+------+------+------+------+------+------+\n\t|" + String.format("%6d", CqStats.STATS_INT_GETI(30)) + "|" + String.format("%6d", CqStats.STATS_INT_GETI(31)) + "|" + String.format("%6d", CqStats.STATS_INT_GETI(32)) + "|" + String.format("%6d", CqStats.STATS_INT_GETI(33)) + "|" + String.format("%6d", CqStats.STATS_INT_GETI(34)) + "|" + String.format("%6d", CqStats.STATS_INT_GETI(35)) + "|" + String.format("%6d", CqStats.STATS_INT_GETI(36)) + "|" + String.format("%6d", CqStats.STATS_INT_GETI(37)) + "|\n" + "\t|" + String.format("%5.1f", Float.valueOf(_grd_4)) + "%|" + String.format("%5.1f", Float.valueOf(_grd_8)) + "%|" + String.format("%5.1f", Float.valueOf(_grd_16)) + "%|" + String.format("%5.1f", Float.valueOf(_grd_32)) + "%|" + String.format("%5.1f", Float.valueOf(_grd_64)) + "%|" + String.format("%5.1f", Float.valueOf(_grd_128)) + "%|" + String.format("%5.1f", Float.valueOf(_grd_256)) + "%|" + String.format("%5.1f", Float.valueOf(_grd_g256)) + "%|\n" + "\t+------+------+------+------+------+------+------+------+\n\n" + "\tGrid count/size (shaded grids):\n" + "\t+------+------+------+------+------+------+------+------+\n" + "\t|<=  4 |<=  8 |<= 16 |<= 32 |<= 64 |<=128 |<=256 | >256 |\n" + "\t+------+------+------+------+------+------+------+------+\n\t|" + String.format("%6d", CqStats.STATS_INT_GETI(38)) + "|" + String.format("%6d", CqStats.STATS_INT_GETI(39)) + "|" + String.format("%6d", CqStats.STATS_INT_GETI(40)) + "|" + String.format("%6d", CqStats.STATS_INT_GETI(41)) + "|" + String.format("%6d", CqStats.STATS_INT_GETI(42)) + "|" + String.format("%6d", CqStats.STATS_INT_GETI(43)) + "|" + String.format("%6d", CqStats.STATS_INT_GETI(44)) + "|" + String.format("%6d", CqStats.STATS_INT_GETI(45)) + "|\n" + "\t|" + String.format("%5.1f", Float.valueOf(_grd_shd_4)) + "%|" + String.format("%5.1f", Float.valueOf(_grd_shd_8)) + "%|" + String.format("%5.1f", Float.valueOf(_grd_shd_16)) + "%|" + String.format("%5.1f", Float.valueOf(_grd_shd_32)) + "%|" + String.format("%5.1f", Float.valueOf(_grd_shd_64)) + "%|" + String.format("%5.1f", Float.valueOf(_grd_shd_128)) + "%|" + String.format("%5.1f", Float.valueOf(_grd_shd_256)) + "%|" + String.format("%5.1f", Float.valueOf(_grd_shd_g256)) + "%|\n" + "\t+------+------+------+------+------+------+------+------+\n\n" + "\n");
            int _mpg_pushes_all = CqStats.STATS_INT_GETI(62) + CqStats.STATS_INT_GETI(63) + CqStats.STATS_INT_GETI(64);
            float _mpg_p_f = 100.0f * (float)CqStats.STATS_INT_GETI(62) / (float)_mpg_pushes_all;
            float _mpg_p_d = 100.0f * (float)CqStats.STATS_INT_GETI(63) / (float)_mpg_pushes_all;
            float _mpg_p_fd = 100.0f * (float)CqStats.STATS_INT_GETI(64) / (float)_mpg_pushes_all;
            float _mpg_p_a = 100.0f * (float)_mpg_pushes_all / (float)CqStats.STATS_INT_GETI(46);
            float _mpg_m_q = 100.0f * (float)CqStats.STATS_INT_GETI(51) / (float)CqStats.STATS_INT_GETI(46);
            int _mpg_hits = CqStats.STATS_INT_GETI(54) + CqStats.STATS_INT_GETI(55) + CqStats.STATS_INT_GETI(56) + CqStats.STATS_INT_GETI(57) + CqStats.STATS_INT_GETI(58) + CqStats.STATS_INT_GETI(59) + CqStats.STATS_INT_GETI(60) + CqStats.STATS_INT_GETI(61);
            float _mpg_1 = 100.0f * (float)CqStats.STATS_INT_GETI(54) / (float)_mpg_hits;
            float _mpg_2 = 100.0f * (float)CqStats.STATS_INT_GETI(55) / (float)_mpg_hits;
            float _mpg_3 = 100.0f * (float)CqStats.STATS_INT_GETI(56) / (float)_mpg_hits;
            float _mpg_4 = 100.0f * (float)CqStats.STATS_INT_GETI(57) / (float)_mpg_hits;
            float _mpg_5 = 100.0f * (float)CqStats.STATS_INT_GETI(58) / (float)_mpg_hits;
            float _mpg_6 = 100.0f * (float)CqStats.STATS_INT_GETI(59) / (float)_mpg_hits;
            float _mpg_7 = 100.0f * (float)CqStats.STATS_INT_GETI(60) / (float)_mpg_hits;
            float _mpg_8 = 100.0f * (float)CqStats.STATS_INT_GETI(61) / (float)_mpg_hits;
            MSG.print("Micropolygons:\n\t" + CqStats.STATS_INT_GETI(46) + " created (" + CqStats.STATS_INT_GETI(50) + " culled)\n" + "\t" + CqStats.STATS_INT_GETI(49) + " peak, " + CqStats.STATS_INT_GETI(52) + " trimmed, ( " + CqStats.STATS_INT_GETI(53) + " completely ) " + CqStats.STATS_INT_GETI(51) + " missed (" + _mpg_m_q + "%)\n\t" + "\n\tMPG Area:\t" + CqStats.STATS_INT_GETF(1) / (float)CqStats.STATS_INT_GETI(46) + " average \n\t\t\t" + CqStats.STATS_INT_GETF(2) + " min\n\t\t\t" + CqStats.STATS_INT_GETF(3) + " max\n\t" + "\n\t% of sample hits:\n" + "\t+------+------+------+------+------+------+------+------+\n" + "\t|<=12,5|<=  25|<=37,5|<=  50|<=62,5|<= 75 |<=87,5|<= 100|\n" + "\t+------+------+------+------+------+------+------+------+\n\t|" + String.format("%5.1f", Float.valueOf(_mpg_1)) + "%|" + String.format("%5.1f", Float.valueOf(_mpg_2)) + "%|" + String.format("%5.1f", Float.valueOf(_mpg_3)) + "%|" + String.format("%5.1f", Float.valueOf(_mpg_4)) + "%|" + String.format("%5.1f", Float.valueOf(_mpg_5)) + "%|" + String.format("%5.1f", Float.valueOf(_mpg_6)) + "%|" + String.format("%5.1f", Float.valueOf(_mpg_7)) + "%|" + String.format("%5.1f", Float.valueOf(_mpg_8)) + "%|\n" + "\t+------+------+------+------+------+------+------+------+\n\n" + "\n");
            MSG.print("\tPushes:\t" + _mpg_pushes_all + " MPGs pushed (" + _mpg_p_a + "%)\n\t\t" + CqStats.STATS_INT_GETI(62) + " forward (" + _mpg_p_f + "%), " + CqStats.STATS_INT_GETI(63) + " down (" + _mpg_p_d + "%),\n\t\t" + CqStats.STATS_INT_GETI(64) + " far down (" + _mpg_p_fd + "%)\n" + "\n");
            float _spl_b_h = 100.0f * (float)CqStats.STATS_INT_GETI(265) / (float)CqStats.STATS_INT_GETI(264);
            float _spl_h = 100.0f * (float)CqStats.STATS_INT_GETI(266) / (float)CqStats.STATS_INT_GETI(264);
            float _spl_m = 100.0f - _spl_b_h - _spl_h;
            int _spl_px = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"PixelSamples", (int)0).value;
            int _spl_py = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"PixelSamples", (int)1).value;
            MSG.print("Sampling:\n\tSamples per Pixel: " + _spl_px * _spl_py + " (" + _spl_px + " " + _spl_py + ")\n\t" + CqStats.STATS_INT_GETI(264) + " samples" + "\n");
            MSG.print("\tHits: " + CqStats.STATS_INT_GETI(266) + " (" + _spl_h + "%), " + "bound hits: " + CqStats.STATS_INT_GETI(265) + " (" + _spl_b_h + "%),\n\tmisses: " + (CqStats.STATS_INT_GETI(264) - CqStats.STATS_INT_GETI(266) - CqStats.STATS_INT_GETI(265)) + " (" + _spl_m + "%)\n" + "\n");
            int _shd_var_all = CqStats.STATS_INT_GETI(75) + CqStats.STATS_INT_GETI(79) + CqStats.STATS_INT_GETI(90);
            float _shd_var_a = 100.0f * (float)CqStats.STATS_INT_GETI(75) / (float)_shd_var_all;
            float _shd_var_u = 100.0f * (float)CqStats.STATS_INT_GETI(79) / (float)_shd_var_all;
            float _shd_var_v = 100.0f * (float)CqStats.STATS_INT_GETI(90) / (float)_shd_var_all;
            float _shd_var_c_q = 100.0f * (float)CqStats.STATS_INT_GETI(72) / (float)_shd_var_all;
            MSG.print("Shading:\n\tStack:\n\t\t" + CqStats.STATS_INT_GETI(67) + " max stack depth\n\t\t" + CqStats.STATS_INT_GETI(65) + " push, " + CqStats.STATS_INT_GETI(66) + " pushv\n\t\t" + CqStats.STATS_INT_GETI(68) + " pop, " + CqStats.STATS_INT_GETI(69) + " release\n\t\t" + CqStats.STATS_INT_GETI(70) + " dup, " + CqStats.STATS_INT_GETI(71) + " drop\n\n\t" + "Variables:\n\t\t" + _shd_var_all + " allocated, " + CqStats.STATS_INT_GETI(72) + " created (" + _shd_var_c_q + "%), " + CqStats.STATS_INT_GETI(74) + " peak\n\n\t\t" + "Arrays:\n\t\t" + "\t" + CqStats.STATS_INT_GETI(75) + " created (" + _shd_var_a + "%), " + CqStats.STATS_INT_GETI(77) + " peak\n\t\t" + "\t" + CqStats.STATS_INT_GETI(78) + " initialized\n\n\t\t" + "Uniform:\n\t\t" + "\t" + CqStats.STATS_INT_GETI(79) + " created (" + _shd_var_u + "%), " + CqStats.STATS_INT_GETI(81) + " peak\n\t\t" + "\t" + CqStats.STATS_INT_GETI(82) + " inits\n\n\t\t" + "\t\t" + CqStats.STATS_INT_GETI(83) + " float\n\t\t" + "\t\t" + CqStats.STATS_INT_GETI(84) + " string\n\t\t" + "\t\t" + CqStats.STATS_INT_GETI(85) + " point\n\t\t" + "\t\t" + CqStats.STATS_INT_GETI(86) + " vector\n\t\t" + "\t\t" + CqStats.STATS_INT_GETI(87) + " normal\n\t\t" + "\t\t" + CqStats.STATS_INT_GETI(88) + " color\n\t\t" + "\t\t" + CqStats.STATS_INT_GETI(89) + " matrix\n\n\t\t" + "Varying:\n\t\t" + "\t" + CqStats.STATS_INT_GETI(90) + " created (" + _shd_var_v + "%), " + CqStats.STATS_INT_GETI(92) + " peak\n\t\t" + "\t" + CqStats.STATS_INT_GETI(93) + " inits\n\n\t\t" + "\t\t" + CqStats.STATS_INT_GETI(94) + " float\n\t\t" + "\t\t" + CqStats.STATS_INT_GETI(95) + " string\n\t\t" + "\t\t" + CqStats.STATS_INT_GETI(96) + " point\n\t\t" + "\t\t" + CqStats.STATS_INT_GETI(97) + " vector\n\t\t" + "\t\t" + CqStats.STATS_INT_GETI(98) + " normal\n\t\t" + "\t\t" + CqStats.STATS_INT_GETI(99) + " color\n\t\t" + "\t\t" + CqStats.STATS_INT_GETI(100) + " matrix\n\n\t" + "Shadeop calls:\n\t\t");
            if (CqStats.STATS_INT_GETI(101) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(101)) + "\tabs\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(102) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(102)) + "\tacos\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(103) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(103)) + "\tambient\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(104) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(104)) + "\tarea\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(105) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(105)) + "\tasin\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(106) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(106)) + "\tatan\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(107) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(107)) + "\tatmosphere\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(108) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(108)) + "\tattribute\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(109) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(109)) + "\tbake\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(110) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(110)) + "\tbump\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(111) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(111)) + "\tcDeriv\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(112) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(112)) + "\tcDu\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(113) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(113)) + "\tcDv\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(114) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(114)) + "\tcalculatenormal\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(115) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(115)) + "\tccellnoise1\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(116) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(116)) + "\tccellnoise2\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(117) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(117)) + "\tccellnoise3\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(118) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(118)) + "\tccellnoise4\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(119) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(119)) + "\tceil\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(120) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(120)) + "\tcenvironment2\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(121) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(121)) + "\tcenvironment3\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(122) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(122)) + "\tcclamp\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(123) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(123)) + "\tclamp\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(124) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(124)) + "\tcmax\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(125) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(125)) + "\tcmin\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(126) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(126)) + "\tcmix\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(127) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(127)) + "\tcnoise1\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(128) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(128)) + "\tcnoise2\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(129) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(129)) + "\tcnoise3\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(130) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(130)) + "\tcnoise4\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(131) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(131)) + "\tconcat\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(132) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(132)) + "\tcos\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(133) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(133)) + "\tcpnoise1\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(134) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(134)) + "\tcpnoise2\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(135) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(135)) + "\tcpnoise3\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(136) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(136)) + "\tcpnoise4\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(137) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(137)) + "\tcrandom\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(138) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(138)) + "\tcspline\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(139) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(139)) + "\tcsplinea\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(140) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(140)) + "\tctexture1\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(141) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(141)) + "\tctexture2\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(142) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(142)) + "\tctexture3\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(143) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(143)) + "\tctransform\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(144) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(144)) + "\tdegrees\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(145) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(145)) + "\tdepth\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(146) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(146)) + "\tdeterminant\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(147) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(147)) + "\tdiffuse\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(148) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(148)) + "\tdisplacement\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(149) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(149)) + "\tdistance\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(150) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(150)) + "\texp\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(151) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(151)) + "\texternal\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(152) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(152)) + "\tfDeriv\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(153) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(153)) + "\tfDu\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(154) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(154)) + "\tfDv\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(155) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(155)) + "\tfaceforward\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(156) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(156)) + "\tfaceforward2\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(157) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(157)) + "\tfcellnoise1\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(158) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(158)) + "\tfcellnoise2\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(159) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(159)) + "\tfcellnoise3\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(160) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(160)) + "\tfcellnoise4\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(161) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(161)) + "\tfenvironment2\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(162) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(162)) + "\tfenvironment3\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(163) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(163)) + "\tfilterstep\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(164) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(164)) + "\tfilterstep2\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(165) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(165)) + "\tfloor\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(166) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(166)) + "\tfmix\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(167) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(167)) + "\tfnoise1\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(168) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(168)) + "\tfnoise2\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(169) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(169)) + "\tfnoise3\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(170) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(170)) + "\tfnoise4\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(171) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(171)) + "\tformat\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(172) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(172)) + "\tfpnoise1\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(173) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(173)) + "\tfpnoise2\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(174) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(174)) + "\tfpnoise3\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(175) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(175)) + "\tfpnoise4\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(176) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(176)) + "\tfrandom\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(177) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(177)) + "\tfresnel\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(178) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(178)) + "\tfspline\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(179) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(179)) + "\tfsplinea\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(180) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(180)) + "\tftexture1\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(181) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(181)) + "\tftexture2\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(182) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(182)) + "\tftexture3\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(183) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(183)) + "\tilluminance\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(184) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(184)) + "\tilluminate\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(185) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(185)) + "\tincident\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(186) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(186)) + "\tinversesqrt\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(187) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(187)) + "\tlength\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(188) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(188)) + "\tlightsource\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(189) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(189)) + "\tlog\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(190) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(190)) + "\tmatch\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(191) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(191)) + "\tmax\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(192) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(192)) + "\tmin\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(193) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(193)) + "\tmod\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(194) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(194)) + "\tmrotate\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(195) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(195)) + "\tmscale\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(196) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(196)) + "\tmtranslate\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(197) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(197)) + "\tnormalize\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(198) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(198)) + "\tntransform\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(199) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(199)) + "\tocclusion\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(200) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(200)) + "\topposite\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(201) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(201)) + "\toption\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(202) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(202)) + "\tpDeriv\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(203) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(203)) + "\tpDu\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(204) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(204)) + "\tpDv\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(205) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(205)) + "\tpcellnoise1\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(206) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(206)) + "\tpcellnoise2\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(207) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(207)) + "\tpcellnoise3\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(208) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(208)) + "\tpcellnoise4\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(209) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(209)) + "\tpclamp\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(210) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(210)) + "\tphong\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(211) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(211)) + "\tpmax\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(212) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(212)) + "\tpmin\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(213) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(213)) + "\tpmix\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(214) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(214)) + "\tpnoise1\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(215) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(215)) + "\tpnoise2\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(216) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(216)) + "\tpnoise3\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(217) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(217)) + "\tpnoise4\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(218) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(218)) + "\tpow\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(219) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(219)) + "\tppnoise1\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(220) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(220)) + "\tppnoise2\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(221) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(221)) + "\tppnoise3\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(222) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(222)) + "\tppnoise4\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(223) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(223)) + "\tprandom\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(224) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(224)) + "\tprintf\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(225) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(225)) + "\tpspline\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(226) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(226)) + "\tpsplinea\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(227) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(227)) + "\tptlined\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(228) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(228)) + "\tradians\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(229) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(229)) + "\treflect\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(230) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(230)) + "\trefract\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(231) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(231)) + "\trendererinfo\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(232) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(232)) + "\trotate\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(233) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(233)) + "\tround\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(234) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(234)) + "\tscspline\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(235) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(235)) + "\tscsplinea\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(236) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(236)) + "\tsetcomp\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(237) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(237)) + "\tsetmcomp\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(238) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(238)) + "\tsetxcomp\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(239) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(239)) + "\tsetycomp\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(240) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(240)) + "\tsetzcomp\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(241) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(241)) + "\tsfspline\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(242) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(242)) + "\tsfsplinea\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(243) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(243)) + "\tshadername\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(244) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(244)) + "\tshadername2\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(245) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(245)) + "\tshadow\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(246) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(246)) + "\tshadow1\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(247) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(247)) + "\tsign\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(248) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(248)) + "\tsin\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(249) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(249)) + "\tsmoothstep\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(250) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(250)) + "\tsolar\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(251) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(251)) + "\tspecular\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(252) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(252)) + "\tspecularbrdf\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(253) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(253)) + "\tspspline\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(254) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(254)) + "\tspsplinea\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(255) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(255)) + "\tsqrt\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(256) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(256)) + "\tstep\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(257) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(257)) + "\tsurface\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(258) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(258)) + "\ttan\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(259) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(259)) + "\ttextureinfo\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(260) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(260)) + "\ttrace\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(261) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(261)) + "\ttransform\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(262) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(262)) + "\tvmix\n\t\t");
            }
            if (CqStats.STATS_INT_GETI(263) != 0) {
                MSG.print(String.valueOf(CqStats.STATS_INT_GETI(263)) + "\tvtransform\n\t\t");
            }
            MSG.println();
            MSG.print("Attributes:\n\t");
            MSG.print(RiGlobal.Attribute_Stack.size() + " created\n" + "\n");
            MSG.print("Parameters:\n\t" + CqStats.STATS_INT_GETI(267) + " created, " + CqStats.STATS_INT_GETI(269) + " peak\n" + "\n");
        }
        if (level == 3) {
            MSG.print("Textures            : " + this.m_cTextureMemory + " bytes used." + "\n");
            MSG.print("Textures hits       : \n");
            int i = 0;
            while (i < 5) {
                if (this.m_cTextureHits[0][i] != 0) {
                    switch (i) {
                        case 0: {
                            MSG.print("\t\t\tMipMap   P(");
                            break;
                        }
                        case 1: {
                            MSG.print("\t\t\tCube Env.P(");
                            break;
                        }
                        case 2: {
                            MSG.print("\t\t\tLatLong  P(");
                            break;
                        }
                        case 3: {
                            MSG.print("\t\t\tShadow   P(");
                            break;
                        }
                        case 4: {
                            MSG.print("\t\t\tTiles    P(");
                        }
                    }
                    MSG.print(String.valueOf(100.0f * ((float)this.m_cTextureHits[0][i] / (float)(this.m_cTextureHits[0][i] + this.m_cTextureMisses[i]))) + "%)" + " of " + this.m_cTextureMisses[i] + " tries" + "\n");
                }
                if (this.m_cTextureHits[1][i] != 0) {
                    switch (i) {
                        case 0: {
                            MSG.print("\t\t\tMipMap   S(");
                            break;
                        }
                        case 1: {
                            MSG.print("\t\t\tCube Env.S(");
                            break;
                        }
                        case 2: {
                            MSG.print("\t\t\tLatLong  S(");
                            break;
                        }
                        case 3: {
                            MSG.print("\t\t\tShadow   S(");
                            break;
                        }
                        case 4: {
                            MSG.print("\t\t\tTiles    S(");
                        }
                    }
                    MSG.print(String.valueOf(100.0f * ((float)this.m_cTextureHits[1][i] / (float)(this.m_cTextureHits[1][i] + this.m_cTextureMisses[i]))) + "%)" + "\n");
                }
                ++i;
            }
            MSG.println();
        }
    }

    public void PrintInfo() {
        int[] poptGridSize;
        HimawariLogger logger = HimawariLogger.getLogger();
        int bX = 16;
        int bY = 16;
        int psX = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"PixelSamples", (int)0).value;
        int psY = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"PixelSamples", (int)1).value;
        int resX = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"Resolution", (int)0).value;
        int resY = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"Resolution", (int)1).value;
        int fX = (int)RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"FilterWidth", (int)0).value;
        int fY = (int)RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"FilterWidth", (int)1).value;
        float gain = RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"Exposure", (int)0).value;
        float gamma = RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"Exposure", (int)1).value;
        float pratio = RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"PixelAspectRatio", (int)0).value;
        int[] poptBucketSize = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOption("limits", "bucketsize");
        if (poptBucketSize != null) {
            bX = poptBucketSize[0];
            bY = poptBucketSize[1];
        }
        int gs = (poptGridSize = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOption("limits", "gridsize")) != null && poptGridSize.length > 0 ? poptGridSize[0] : 256;
        logger.info("Image settings:\n");
        logger.info("\tResolution: " + resX + " " + resY + "\n");
        logger.info("\tPixelAspectRatio: " + pratio + "\n");
        logger.info("\tExposure:\n");
        logger.info("\t\tGain: " + gain + "\n");
        logger.info("\t\tGamma: " + gamma + "\n");
        logger.info("Shading:\n");
        logger.info("\tBucket size: [ " + bX + " " + bY + "]" + "\n");
        logger.info("\tGridsize: " + gs + "\n");
        logger.info("Anti-aliasing settings: \n");
        logger.info("\tPixelSamples: " + psX + " " + psY + "\n");
        logger.info("\tFilterWidth: " + fX + " " + fY + "\n");
        System.err.flush();
    }

    private PrintStream TimeToString(PrintStream os, float ticks, float tot) {
        float t = ticks / 1000.0f;
        if ((double)t < 0.0) {
            os.print("<invalid>");
            return os;
        }
        if ((double)t > 5.0) {
            t = Math.round(t);
        }
        int h = (int)(t / 3600.0f);
        int m = (int)(t / 60.0f - (float)(h * 60));
        float s = t - (float)(h * 60 * 60) - (float)(m * 60);
        if (h > 0) {
            os.print(String.valueOf(String.format("%6d", h)) + "hrs ");
        }
        if (m > 0) {
            os.print(String.valueOf(String.format("%6d", m)) + "mins ");
        }
        os.print(String.valueOf(String.format("%6.1f", Float.valueOf(s))) + "secs");
        if (tot >= 0.0f) {
            os.print(" (" + String.format("%6.2f", Float.valueOf(100.0f * ticks / tot)) + "%)");
        }
        return os;
    }

    private String TimeToString(float ticks, float tot) {
        String str = "";
        float t = ticks / 1000.0f;
        if ((double)t < 0.0) {
            str = String.valueOf(str) + "<invalid>";
            return str;
        }
        if ((double)t > 5.0) {
            t = Math.round(t);
        }
        int h = (int)(t / 3600.0f);
        int m = (int)(t / 60.0f - (float)(h * 60));
        float s = t - (float)(h * 60 * 60) - (float)(m * 60);
        if (h > 0) {
            str = String.valueOf(str) + String.format("%6d", h) + "hrs ";
        }
        if (m > 0) {
            str = String.valueOf(str) + String.format("%6d", m) + "mins ";
        }
        str = String.valueOf(str) + String.format("%6.1f", Float.valueOf(s)) + "secs";
        if (tot >= 0.0f) {
            str = String.valueOf(str) + " (" + String.format("%6.2f", Float.valueOf(100.0f * ticks / tot)) + "%)";
        }
        return str;
    }

    public static void STATS_INC(int index) {
        CqStats.gStats_IncI(index);
    }

    public static void STATS_DEC(int index) {
        CqStats.gStats_DecI(index);
    }

    public static int STATS_GETI(int index) {
        return CqStats.gStats_getI(index);
    }

    public static void STATS_SETI(int index, int value) {
        CqStats.gStats_setI(index, value);
    }

    public static float STATS_GETF(int index) {
        return CqStats.gStats_getF(index);
    }

    public static void STATS_SETF(int index, float value) {
        CqStats.gStats_setF(index, value);
    }

    public static int STATS_INT_GETI(int index) {
        return CqStats.getI(index);
    }

    public static float STATS_INT_GETF(int index) {
        return CqStats.getF(index);
    }

    public static float gStats_getF(int index) {
        return CqStats.getF(index);
    }

    public static void gStats_setI(int index, int value) {
        CqStats.setI(index, value);
    }

    public static void gStats_IncI(int index) {
        CqStats.IncI(index);
    }

    public static void gStats_DecI(int index) {
        CqStats.DecI(index);
    }

    public static int gStats_getI(int index) {
        return CqStats.getI(index);
    }

    public static void gStats_setF(int index, float value) {
        CqStats.setF(index, value);
    }
}

