/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqBoundList;
import net.cellcomputing.himawari.library.CqMicroPolygon;
import net.cellcomputing.himawari.library.CqMovingMicroPolygonKeyPoints;
import net.cellcomputing.himawari.library.SqSampleData;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.CqVector3D;

public strictfp class CqMicroPolygonMotionPoints
extends CqMicroPolygon {
    private CqBound m_Bound = new CqBound();
    private CqBoundList m_BoundList = new CqBoundList();
    private boolean m_BoundReady;
    private STLVector<p_float> m_Times = new STLVector<p_float>(p_float.class);
    private STLVector<CqMovingMicroPolygonKeyPoints> m_Keys = new STLVector<CqMovingMicroPolygonKeyPoints>(CqMovingMicroPolygonKeyPoints.class);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CqMicroPolygonMotionPoints() {
        this.m_BoundReady = false;
    }

    public void AppendKey(CqVector3D vA, float radius, float time) {
        CqMovingMicroPolygonKeyPoints pMP = new CqMovingMicroPolygonKeyPoints(vA, radius);
        this.m_Times.add(new p_float(time));
        this.m_Keys.add(pMP);
        if (this.m_Times.size() == 1) {
            this.m_Bound = new CqBound(pMP.GetTotalBound());
        } else {
            this.m_Bound.Encapsulate(pMP.GetTotalBound());
        }
    }

    public void DeleteVariables(boolean all) {
    }

    public boolean fContains(CqVector2D vecP, p_float Depth, float time) {
        int iIndex = 0;
        float Fraction = 0.0f;
        boolean Exact = true;
        if (time > ((p_float)this.m_Times.firstElement()).value) {
            if (time >= ((p_float)this.m_Times.lastElement()).value) {
                iIndex = this.m_Times.size() - 1;
            } else {
                iIndex = 0;
                while (time >= ((p_float)this.m_Times.get((int)(iIndex + 1))).value) {
                    ++iIndex;
                }
                Fraction = (time - ((p_float)this.m_Times.get((int)iIndex)).value) / (((p_float)this.m_Times.get((int)(iIndex + 1))).value - ((p_float)this.m_Times.get((int)iIndex)).value);
                boolean bl = Exact = ((p_float)this.m_Times.get((int)iIndex)).value == time;
            }
        }
        if (Exact) {
            CqMovingMicroPolygonKeyPoints pMP1 = (CqMovingMicroPolygonKeyPoints)this.m_Keys.get(iIndex);
            return pMP1.fContains(vecP, Depth, time);
        }
        CqMovingMicroPolygonKeyPoints pMP1 = (CqMovingMicroPolygonKeyPoints)this.m_Keys.get(iIndex);
        CqMovingMicroPolygonKeyPoints pMP2 = (CqMovingMicroPolygonKeyPoints)this.m_Keys.get(iIndex + 1);
        CqVector3D MidPoint = pMP2.m_Point0.sub(pMP1.m_Point0).mul(Fraction).add(pMP1.m_Point0);
        float MidRadius = (pMP2.m_radius - pMP1.m_radius) * Fraction + pMP1.m_radius;
        CqVector2D cqVector2D = new CqVector2D(MidPoint.x, MidPoint.y);
        if (cqVector2D.sub(vecP).Magnitude() < MidRadius) {
            Depth.value = MidPoint.z;
            return true;
        }
        return false;
    }

    public void CalculateTotalBound() {
        assert (this.m_Keys.get(0) != null);
        this.m_Bound = ((CqMovingMicroPolygonKeyPoints)this.m_Keys.get(0)).GetTotalBound();
        for (CqMovingMicroPolygonKeyPoints i : this.m_Keys) {
            this.m_Bound.Encapsulate(i.GetTotalBound());
        }
    }

    public CqBound GetTotalBound(boolean fForce) {
        return new CqBound(this.m_Bound);
    }

    public final CqBound GetTotalBound() {
        return this.GetTotalBound(false);
    }

    public int cSubBounds() {
        if (!this.m_BoundReady) {
            this.BuildBoundList();
        }
        return this.m_BoundList.Size();
    }

    public CqBound SubBound(int iIndex, p_float time) {
        if (!this.m_BoundReady) {
            this.BuildBoundList();
        }
        assert (iIndex < this.m_BoundList.Size());
        time.value = this.m_BoundList.GetTime(iIndex);
        return this.m_BoundList.GetBound(iIndex);
    }

    public void BuildBoundList() {
        this.m_BoundList.Clear();
        assert (this.m_Keys.get(0) != null);
        CqBound start = ((CqMovingMicroPolygonKeyPoints)this.m_Keys.get(0)).GetTotalBound();
        float startTime = ((p_float)this.m_Times.get((int)0)).value;
        int cTimes = this.m_Keys.size();
        int i = 1;
        while (i < cTimes) {
            CqBound end = ((CqMovingMicroPolygonKeyPoints)this.m_Keys.get(i)).GetTotalBound();
            CqBound mid0 = new CqBound(start);
            CqBound mid1 = new CqBound();
            float endTime = ((p_float)this.m_Times.get((int)i)).value;
            float time = startTime;
            int divisions = 4;
            float delta = 1.0f / (float)divisions;
            this.m_BoundList.SetSize(divisions);
            int d = 1;
            while (d <= divisions) {
                mid1.vecMin().assignment(end.vecMin().sub(start.vecMin()).mul(delta).add(start.vecMin()));
                mid1.vecMax().assignment(end.vecMax().sub(start.vecMax()).mul(delta).add(start.vecMax()));
                this.m_BoundList.Set(d - 1, mid0.Combine(mid1), time);
                time = delta * (endTime - startTime) + startTime;
                mid0.assignment(mid1);
                delta += delta;
                ++d;
            }
            start = end;
            startTime = endTime;
            ++i;
        }
        this.m_BoundReady = true;
    }

    public boolean IsMoving() {
        return true;
    }

    public boolean Sample(SqSampleData sample, p_float D, float time, boolean UsingDof) {
        CqVector2D vecSample = sample.m_Position;
        return this.fContains(vecSample, D, time);
    }

    private CqMicroPolygonMotionPoints(CqMicroPolygonMotionPoints From) {
    }
}

