/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqCurvesGroup;
import net.cellcomputing.himawari.library.CqLinearCurveSegment;
import net.cellcomputing.himawari.library.CqParameter;
import net.cellcomputing.himawari.library.CqParameterTypedVarying;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.util.HimawariLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqLinearCurvesGroup
extends CqCurvesGroup {
    static /* synthetic */ Class class$0;

    public CqLinearCurvesGroup(int ncurves, int[] nvertices) {
        this(ncurves, nvertices, false);
    }

    public CqLinearCurvesGroup(int ncurves, int[] nvertices, boolean periodic) {
        assert (nvertices != null);
        HimawariLogger logger = HimawariLogger.getLogger();
        this.m_ncurves = ncurves;
        this.m_periodic = periodic;
        this.m_nTotalVerts = 0;
        int i = 0;
        while (i < this.m_ncurves) {
            this.m_nTotalVerts += nvertices[i];
            if (nvertices[i] <= 2 && this.m_periodic) {
                logger.warning("Periodic linear curves should have more than two vertices\n");
            }
            ++i;
        }
        this.m_nvertices.clear();
        this.m_nvertices.ensureCapacity(this.m_ncurves);
        i = 0;
        while (i < this.m_ncurves) {
            this.m_nvertices.add(nvertices[i]);
            ++i;
        }
    }

    public CqLinearCurvesGroup(CqLinearCurvesGroup from) {
        super(from);
        this.assignment(from);
    }

    @Override
    public void destruct() {
        this.m_nvertices.clear();
    }

    public CqLinearCurvesGroup assignment(CqLinearCurvesGroup from) {
        super.assignment(from);
        return this;
    }

    @Override
    public int Split(STLVector<CqBasicSurface> aSplits) {
        int nSplits = 0;
        int bUses = this.Uses();
        int vertexI = 0;
        int uniformI = 0;
        int curveI = 0;
        while (curveI < this.m_ncurves) {
            int lastSegment = this.m_periodic ? (Integer)this.m_nvertices.get(curveI) : (Integer)this.m_nvertices.get(curveI) - 1;
            int firstVertex = vertexI;
            int segI = 0;
            while (segI < lastSegment) {
                int nextVertex = segI == (Integer)this.m_nvertices.get(curveI) - 1 ? firstVertex : vertexI + 1;
                CqLinearCurveSegment pSeg = new CqLinearCurveSegment();
                pSeg.SetSurfaceParameters(this);
                if (RiGlobal.USES(bUses, 13)) {
                    float vv = (float)segI / (float)lastSegment;
                    float vvnext = (float)(segI + 1) / (float)lastSegment;
                    CqParameterTypedVarying<p_float, p_float> pVP = new CqParameterTypedVarying<p_float, p_float>("v", new EqVariableType(1), p_float.class, p_float.class);
                    pVP.SetSize(pSeg.cVarying());
                    pVP.pValue_get((int)0, (int)0).value = vv;
                    pVP.pValue_get((int)1, (int)0).value = vvnext;
                    pSeg.AddPrimitiveVariable(pVP);
                }
                for (CqParameter iUP : this.aUserParams()) {
                    CqParameter pNewUP;
                    if (iUP.Class().getValue() == 3 || iUP.Class().getValue() == 4) {
                        pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                        assert (pSeg.cVarying() == pSeg.cVertex());
                        pNewUP.SetSize(pSeg.cVarying());
                        pNewUP.SetValue(iUP, 0, vertexI);
                        pNewUP.SetValue(iUP, 1, nextVertex);
                        pSeg.AddPrimitiveVariable(pNewUP);
                        continue;
                    }
                    if (iUP.Class().getValue() == 2) {
                        pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                        pNewUP.SetSize(pSeg.cUniform());
                        pNewUP.SetValue(iUP, 0, uniformI);
                        pSeg.AddPrimitiveVariable(pNewUP);
                        continue;
                    }
                    if (iUP.Class().getValue() != 1) continue;
                    pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                    pNewUP.SetSize(1);
                    pNewUP.SetValue(iUP, 0, 0);
                    pSeg.AddPrimitiveVariable(pNewUP);
                }
                ++vertexI;
                aSplits.add(pSeg);
                ++nSplits;
                ++segI;
            }
            if (!this.m_periodic) {
                ++vertexI;
            }
            ++uniformI;
            ++curveI;
        }
        return nSplits;
    }

    @Override
    public void Transform(CqMatrix matTx, CqMatrix matITTx, CqMatrix matRTx) {
        this.Transform(matTx, matITTx, matRTx, 0);
    }

    @Override
    public void Transform(CqMatrix matTx, CqMatrix matITTx, CqMatrix matRTx, int iTime) {
        this.PopulateWidth();
        assert (this.cVarying() == this.cVertex());
        int i = 0;
        while (i < this.cVarying()) {
            CqVector3D horiz = new CqVector3D(1.0f, 0.0f, 0.0f);
            horiz = matITTx.multiply(horiz);
            horiz.assignMul(this.width().pValue_get((int)i, (int)0).value / horiz.Magnitude());
            CqVector3D pt = new CqVector3D(this.P().pValue_get(i, 0));
            CqVector3D pt_delta = new CqVector3D(pt.add(horiz));
            pt = matTx.multiply(pt);
            pt_delta = matTx.multiply(pt_delta);
            CqVector3D widthVector = new CqVector3D(pt_delta.sub(pt));
            this.width().pValue_get((int)i, (int)0).value = widthVector.Magnitude();
            ++i;
        }
        super.Transform(matTx, matITTx, matRTx, iTime);
    }

    @Override
    public int cFaceVarying() {
        return 0;
    }

    @Override
    public int cUniform() {
        return this.m_ncurves;
    }

    @Override
    public int cVarying() {
        return this.m_nTotalVerts;
    }

    @Override
    public int cVertex() {
        return this.m_nTotalVerts;
    }

    @Override
    public String strName() {
        return "CqLinearCurvesGroup";
    }
}

