/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqQuadric;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqDisk
extends CqQuadric {
    private float m_Height;
    private float m_MajorRadius;
    private float m_MinorRadius;
    private float m_ThetaMin;
    private float m_ThetaMax;
    static /* synthetic */ Class class$0;

    public CqDisk() {
        this(0.0f, 0.0f, 1.0f, 0.0f, 360.0f);
    }

    public CqDisk(float height) {
        this(height, 0.0f, 1.0f, 0.0f, 360.0f);
    }

    public CqDisk(float height, float minorradius) {
        this(height, minorradius, 1.0f, 0.0f, 360.0f);
    }

    public CqDisk(float height, float minorradius, float majorradius) {
        this(height, minorradius, majorradius, 0.0f, 360.0f);
    }

    public CqDisk(float height, float minorradius, float majorradius, float thetamin) {
        this(height, minorradius, majorradius, thetamin, 360.0f);
    }

    public CqDisk(float height, float minorradius, float majorradius, float thetamin, float thetamax) {
        this.m_Height = height;
        this.m_MajorRadius = majorradius;
        this.m_MinorRadius = minorradius;
        this.m_ThetaMin = thetamin;
        this.m_ThetaMax = thetamax;
    }

    public CqDisk(CqDisk From) {
        this.assignment(From);
    }

    @Override
    public void destruct() {
    }

    @Override
    public CqBound Bound() {
        STLVector<CqVector3D> curve = new STLVector<CqVector3D>(CqVector3D.class);
        CqVector3D vA = new CqVector3D(this.m_MajorRadius, 0.0f, this.m_Height);
        CqVector3D vB = new CqVector3D(this.m_MinorRadius, 0.0f, this.m_Height);
        CqVector3D vC = new CqVector3D(0.0f, 0.0f, 0.0f);
        CqVector3D vD = new CqVector3D(0.0f, 0.0f, 1.0f);
        curve.add(vA);
        curve.add(vB);
        CqMatrix matRot = new CqMatrix((float)Math.toRadians(this.m_ThetaMin), vD);
        for (CqVector3D i : curve) {
            i.assignment(matRot.multiply(i));
        }
        CqBound B = new CqBound(this.RevolveForBound(curve, vC, vD, (float)Math.toRadians(this.m_ThetaMax - this.m_ThetaMin)));
        B.Transform(this.m_matTx);
        return this.AdjustBoundForTransformationMotion(B);
    }

    @Override
    public CqVector3D DicePoint(int u, int v) {
        float theta = (float)Math.toRadians(this.m_ThetaMin + (float)u * (this.m_ThetaMax - this.m_ThetaMin) / (float)this.m_uDiceSize);
        float vv = this.m_MajorRadius - (float)v * (this.m_MajorRadius - this.m_MinorRadius) / (float)this.m_vDiceSize;
        return new CqVector3D((float)((double)vv * Math.cos(theta)), (float)((double)vv * Math.sin(theta)), this.m_Height);
    }

    @Override
    public CqVector3D DicePoint(int u, int v, CqVector3D Normal) {
        Normal.assignment(new CqVector3D(0.0f, 0.0f, this.m_ThetaMax > 0.0f ? 1.0f : -1.0f));
        return this.DicePoint(u, v);
    }

    @Override
    public boolean CanGenerateNormals() {
        return true;
    }

    @Override
    public int PreSubdivide(STLVector<CqBasicSurface> aSplits, boolean u) {
        float zcent = (float)((double)(this.m_MajorRadius + this.m_MinorRadius) * 0.5);
        float arccent = (float)((double)(this.m_ThetaMin + this.m_ThetaMax) * 0.5);
        CqDisk pNew1 = new CqDisk(this);
        CqDisk pNew2 = new CqDisk(this);
        if (u) {
            pNew1.m_ThetaMax = arccent;
            pNew2.m_ThetaMin = arccent;
        } else {
            pNew1.m_MinorRadius = zcent;
            pNew2.m_MajorRadius = zcent;
        }
        aSplits.add(pNew1);
        aSplits.add(pNew2);
        return 2;
    }

    public CqDisk assignment(CqDisk From) {
        super.assignment(From);
        this.m_Height = From.m_Height;
        this.m_MajorRadius = From.m_MajorRadius;
        this.m_MinorRadius = From.m_MinorRadius;
        this.m_ThetaMin = From.m_ThetaMin;
        this.m_ThetaMax = From.m_ThetaMax;
        return this;
    }
}

