/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import java.util.ArrayList;
import java.util.Iterator;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.CqCSGNodeDifference;
import net.cellcomputing.himawari.library.CqCSGNodeIntersection;
import net.cellcomputing.himawari.library.CqCSGNodePrimitive;
import net.cellcomputing.himawari.library.CqCSGNodeUnion;
import net.cellcomputing.himawari.library.EqCSGNodeType;
import net.cellcomputing.himawari.library.SqImageSample;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class CqCSGTreeNode {
    private CqCSGTreeNode m_pParent;
    private ArrayList<CqCSGTreeNode> m_lChildren = new ArrayList();
    private static boolean m_bCSGRequired;

    public void destruct() {
    }

    public ArrayList<CqCSGTreeNode> lChildren() {
        return this.m_lChildren;
    }

    public abstract EqCSGNodeType NodeType();

    public void AddChild(CqCSGTreeNode pChild) {
        this.lChildren().add(pChild);
        pChild.m_pParent = this;
    }

    public int isChild(CqCSGTreeNode pNode) {
        if (pNode == null) {
            return -1;
        }
        int iChild = 0;
        for (CqCSGTreeNode pChild : this.lChildren()) {
            if (pChild.equals(pNode)) {
                return iChild;
            }
            ++iChild;
        }
        return -1;
    }

    public CqCSGTreeNode pParent() {
        return this.m_pParent;
    }

    public int cChildren() {
        return this.lChildren().size();
    }

    public abstract boolean EvaluateState(boolean[] var1);

    public void ProcessSampleList(STLVector<SqImageSample> samples) {
        for (CqCSGTreeNode pChild : this.lChildren()) {
            if (pChild == null || pChild.NodeType().getValue() == 0) continue;
            pChild.ProcessSampleList(samples);
        }
        boolean[] abChildState = new boolean[this.cChildren()];
        int[] aChildIndex = new int[samples.size()];
        boolean bCurrentI = false;
        int j = 0;
        for (SqImageSample sqImageSample : samples) {
            aChildIndex[j] = this.isChild(sqImageSample.m_pCSGNode);
            if (aChildIndex[j] >= 0 && sqImageSample.m_pCSGNode.NodeType().getValue() == 0 && sqImageSample.m_pCSGNode.NodeType().getValue() == 1) {
                abChildState[aChildIndex[j]] = !abChildState[aChildIndex[j]];
            }
            ++j;
        }
        bCurrentI = this.EvaluateState(abChildState);
        Iterator iterator = samples.iterator();
        j = 0;
        while (iterator.hasNext()) {
            SqImageSample image = (SqImageSample)iterator.next();
            if (aChildIndex[j] >= 0) {
                abChildState[aChildIndex[j]] = !abChildState[aChildIndex[j]];
                boolean bNewI = this.EvaluateState(abChildState);
                if (bNewI == bCurrentI) {
                    iterator.remove();
                } else {
                    bCurrentI = bNewI;
                    image.m_pCSGNode = this.pParent() != null ? this : null;
                }
            }
            ++j;
        }
    }

    public void ProcessTree(STLVector<SqImageSample> samples) {
        CqCSGTreeNode pTop = this;
        while (pTop.pParent() != null) {
            pTop = pTop.pParent();
        }
        pTop.ProcessSampleList(samples);
    }

    public static CqCSGTreeNode CreateNode(String type) {
        CqCSGTreeNode.SetRequired(true);
        if (type == null) {
            return null;
        }
        if (type.equalsIgnoreCase("primitive")) {
            CqCSGNodePrimitive csg = new CqCSGNodePrimitive();
            return csg;
        }
        if (type.equalsIgnoreCase("union")) {
            CqCSGNodeUnion csg = new CqCSGNodeUnion();
            return csg;
        }
        if (type.equalsIgnoreCase("intersection")) {
            CqCSGNodeIntersection csg = new CqCSGNodeIntersection();
            return csg;
        }
        if (type.equalsIgnoreCase("difference")) {
            CqCSGNodeDifference csg = new CqCSGNodeDifference();
            return csg;
        }
        return null;
    }

    public static boolean IsRequired() {
        return m_bCSGRequired;
    }

    public static void SetRequired(boolean value) {
        m_bCSGRequired = value;
    }
}

