/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.display;

import java.awt.image.WritableRaster;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.IqBucket;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.UserParameter;
import net.cellcomputing.himawari.library.types.PublicFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class ImageData<T> {
    protected String type;
    protected int width;
    protected int height;
    protected float[] pixelData;
    protected WritableRaster raster;
    protected int dataSize;
    protected T imageData;
    protected int offset;
    protected STLVector<UserParameter> m_customParams = new STLVector<UserParameter>(UserParameter.class, 1);
    protected float m_QuantizeZeroVal;
    protected float m_QuantizeOneVal;
    protected float m_QuantizeMinVal;
    protected float m_QuantizeMaxVal;
    protected float m_QuantizeDitherVal;
    private static HashMap<String, ImageData> classMap = new HashMap();
    private static Object _lock = new Object();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public abstract void setBucket(IqBucket var1);

    public abstract T getImage();

    public void init() {
        this.width = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"Resolution", (int)0).value;
        this.height = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"Resolution", (int)1).value;
        int xmin = (int)PublicFunctions.CLAMP((float)Math.ceil((float)this.width * RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"CropWindow", (int)0).value), 0.0f, this.width);
        int xmax = (int)PublicFunctions.CLAMP((float)Math.ceil((float)this.width * RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"CropWindow", (int)1).value), 0.0f, this.width);
        int ymin = (int)PublicFunctions.CLAMP((float)Math.ceil((float)this.height * RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"CropWindow", (int)2).value), 0.0f, this.height);
        int ymax = (int)PublicFunctions.CLAMP((float)Math.ceil((float)this.height * RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"CropWindow", (int)3).value), 0.0f, this.height);
        this.width = xmax - xmin;
        this.height = ymax - ymin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImageData(int offset) {
        Object object = _lock;
        synchronized (object) {
            String classname = this.getClass().getName();
            classname = String.valueOf(classname) + ":" + offset;
            if (classMap.get(classname) != null) {
                throw new RuntimeException("Already created: " + classname);
            }
            this.offset = offset;
            classMap.put(classname, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageData getInstance(Class cls, int offset) {
        Object object = _lock;
        synchronized (object) {
            String classname = cls.getName();
            classname = String.valueOf(classname) + ":" + offset;
            ImageData obj = classMap.get(classname);
            if (obj == null) {
                try {
                    Constructor constr = cls.getDeclaredConstructor(Integer.TYPE);
                    constr.setAccessible(true);
                    obj = (ImageData)constr.newInstance(offset);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(String.valueOf(classname) + " cannot be accessed.");
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(String.valueOf(classname) + " cannot be instantiated.");
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(String.valueOf(classname) + " cannot be instantiated.");
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(String.valueOf(classname) + " cannot be instantiated.");
                }
            }
            return obj;
        }
    }

    protected float quantize(float value) {
        value = Math.round(this.m_QuantizeZeroVal + value * (this.m_QuantizeOneVal - this.m_QuantizeZeroVal) + this.m_QuantizeDitherVal);
        value = PublicFunctions.CLAMP(value, this.m_QuantizeMinVal, this.m_QuantizeMaxVal);
        return value;
    }
}

