/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.display;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.display.DisplayRequest;
import net.cellcomputing.himawari.display.ImageData;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.PublicFunctions;
import net.cellcomputing.himawari.util.HimawariLogger;

public strictfp class HDRRequest
extends DisplayRequest {
    private int imageWidth;
    private int imageHeight;

    public HDRRequest(String name, String type, String mode, int modeID, int dataOffset, int dataSize, ImageData imageData) {
        super(name, type, mode, modeID, dataOffset, dataSize, imageData);
    }

    public void openRequest() {
        this.imageWidth = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOption("System", "Resolution")[0];
        this.imageHeight = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOption("System", "Resolution")[1];
        int xmin = (int)PublicFunctions.CLAMP((float)Math.ceil((float)this.imageWidth * RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"CropWindow", (int)0).value), 0.0f, this.imageWidth);
        int xmax = (int)PublicFunctions.CLAMP((float)Math.ceil((float)this.imageWidth * RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"CropWindow", (int)1).value), 0.0f, this.imageWidth);
        int ymin = (int)PublicFunctions.CLAMP((float)Math.ceil((float)this.imageHeight * RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"CropWindow", (int)2).value), 0.0f, this.imageHeight);
        int ymax = (int)PublicFunctions.CLAMP((float)Math.ceil((float)this.imageHeight * RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"CropWindow", (int)3).value), 0.0f, this.imageHeight);
        this.imageWidth = xmax - xmin;
        this.imageHeight = ymax - ymin;
    }

    public void display() {
    }

    public void closeRequest() {
        RandomAccessFile file = null;
        CqColor[][] bucketList = (CqColor[][])this.imageData.getImage();
        try {
            file = new RandomAccessFile(this.name, "rw");
            file.write("#?RGBE\n".getBytes());
            file.write("FORMAT=32-bit_rle_rgbe\n\n".getBytes());
            file.write(("-Y " + this.imageHeight + " +X " + this.imageWidth + "\n").getBytes());
            byte[] rgbe = new byte[4];
            int y = 0;
            while (y < bucketList.length) {
                int x = 0;
                while (x < bucketList[0].length) {
                    if (bucketList[y][x] != null) {
                        switch (this.dataSize) {
                            case 1: {
                                this.float2rgbe(rgbe, bucketList[y][x].fRed(), bucketList[y][x].fRed(), bucketList[y][x].fRed());
                                break;
                            }
                            default: {
                                this.float2rgbe(rgbe, bucketList[y][x].fRed(), bucketList[y][x].fGreen(), bucketList[y][x].fBlue());
                            }
                        }
                        file.write(rgbe);
                    }
                    ++x;
                }
                ++y;
            }
            file.close();
        }
        catch (FileNotFoundException e) {
            HimawariLogger.outputException(e);
            HimawariLogger.getLogger().error("Cannot open output image file: " + this.name + "\n");
        }
        catch (IOException e) {
            HimawariLogger.outputException(e);
            HimawariLogger.getLogger().error("Cannot open output image file: " + this.name + "\n");
        }
        this.imageData = null;
    }

    public void float2rgbe(byte[] rgbe, float red, float green, float blue) {
        p_int e = new p_int();
        float v = red;
        if (green > v) {
            v = green;
        }
        if (blue > v) {
            v = blue;
        }
        if ((double)v < 1.0E-32) {
            rgbe[3] = 0;
            rgbe[2] = 0;
            rgbe[1] = 0;
            rgbe[0] = 0;
        } else {
            v = (float)((double)this.frexp(v, e) * 256.0 / (double)v);
            rgbe[0] = (byte)(red * v);
            rgbe[1] = (byte)(green * v);
            rgbe[2] = (byte)(blue * v);
            rgbe[3] = (byte)(e.value + 128);
        }
    }

    public float frexp(float v, p_int e) {
        int i = 0;
        if ((double)v != 0.0) {
            int sign = 1;
            if (v < 0.0f) {
                sign = -1;
                v = -v;
            }
            while ((double)v < 0.5) {
                v *= 2.0f;
                --i;
            }
            while ((double)v >= 1.0) {
                v *= 0.5f;
                ++i;
            }
            v *= (float)sign;
        }
        float ret = v;
        e.value = i;
        return ret;
    }
}

