/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.shadervm;

import java.lang.reflect.Method;
import net.cellcomputing.himawari.accessory.STLArray;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.IqShaderData;
import net.cellcomputing.himawari.library.types.CqBitVector;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;
import net.cellcomputing.himawari.util.AccessSupplier;
import net.cellcomputing.himawari.util.HimawariLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class GlobalShaderVM {
    public static p_float temp_float = new p_float();
    public static CqVector3D temp_point = new CqVector3D();
    public static CqColor temp_color = new CqColor();
    public static p_String temp_string = new p_String();
    public static CqMatrix temp_matrix = new CqMatrix();
    private static final int _OP_LSS_ = "<".hashCode();
    private static final int _OP_GRT_ = ">".hashCode();
    private static final int _OP_LE_ = "<=".hashCode();
    private static final int _OP_GE_ = ">=".hashCode();
    private static final int _OP_EQ_ = "==".hashCode();
    private static final int _OP_NE_ = "!=".hashCode();
    private static final int _OP_MUL_ = "*".hashCode();
    private static final int _OP_DIV_ = "/".hashCode();
    private static final int _OP_ADD_ = "+".hashCode();
    private static final int _OP_SUB_ = "-".hashCode();
    private static final int _OP_DOT_ = "*".hashCode();
    private static final int _OP_CRS_ = "%".hashCode();
    private static final int _OP_LAND_ = "&&".hashCode();
    private static final int _OP_LOR_ = "||".hashCode();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public static void OpLSS_FF(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpLSS(temp_float, temp_float, temp_float, a, b, Res, State, p_float.class, p_float.class, p_float.class);
    }

    public static void OpLSS_PP(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpLSS(temp_point, temp_point, temp_float, a, b, Res, State, CqVector3D.class, CqVector3D.class, p_float.class);
    }

    public static void OpLSS_CC(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpLSS(temp_color, temp_color, temp_float, a, b, Res, State, CqColor.class, CqColor.class, p_float.class);
    }

    public static void OpGRT_FF(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpGRT(temp_float, temp_float, temp_float, a, b, Res, State, p_float.class, p_float.class, p_float.class);
    }

    public static void OpGRT_PP(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpGRT(temp_point, temp_point, temp_float, a, b, Res, State, CqVector3D.class, CqVector3D.class, p_float.class);
    }

    public static void OpGRT_CC(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpGRT(temp_color, temp_color, temp_float, a, b, Res, State, CqColor.class, CqColor.class, p_float.class);
    }

    public static void OpLE_FF(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpLE(temp_float, temp_float, temp_float, a, b, Res, State, p_float.class, p_float.class, p_float.class);
    }

    public static void OpLE_PP(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpLE(temp_point, temp_point, temp_float, a, b, Res, State, CqVector3D.class, CqVector3D.class, p_float.class);
    }

    public static void OpLE_CC(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpLE(temp_color, temp_color, temp_float, a, b, Res, State, CqColor.class, CqColor.class, p_float.class);
    }

    public static void OpGE_FF(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpGE(temp_float, temp_float, temp_float, a, b, Res, State, p_float.class, p_float.class, p_float.class);
    }

    public static void OpGE_PP(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpGE(temp_point, temp_point, temp_float, a, b, Res, State, CqVector3D.class, CqVector3D.class, p_float.class);
    }

    public static void OpGE_CC(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpGE(temp_color, temp_color, temp_float, a, b, Res, State, CqColor.class, CqColor.class, p_float.class);
    }

    public static void OpEQ_FF(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpEQ(temp_float, temp_float, temp_float, a, b, Res, State, p_float.class, p_float.class, p_float.class);
    }

    public static void OpEQ_PP(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpEQ(temp_point, temp_point, temp_float, a, b, Res, State, CqVector3D.class, CqVector3D.class, p_float.class);
    }

    public static void OpEQ_CC(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpEQ(temp_color, temp_color, temp_float, a, b, Res, State, CqColor.class, CqColor.class, p_float.class);
    }

    public static void OpEQ_SS(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpEQ(temp_string, temp_string, temp_float, a, b, Res, State, p_String.class, p_String.class, p_float.class);
    }

    public static void OpNE_FF(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpNE(temp_float, temp_float, temp_float, a, b, Res, State, p_float.class, p_float.class, p_float.class);
    }

    public static void OpNE_PP(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpNE(temp_point, temp_point, temp_float, a, b, Res, State, CqVector3D.class, CqVector3D.class, p_float.class);
    }

    public static void OpNE_CC(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpNE(temp_color, temp_color, temp_float, a, b, Res, State, CqColor.class, CqColor.class, p_float.class);
    }

    public static void OpNE_SS(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpNE(temp_string, temp_string, temp_float, a, b, Res, State, p_String.class, p_String.class, p_float.class);
    }

    public static void OpMUL_FF(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpMUL(temp_float, temp_float, temp_float, a, b, Res, State, p_float.class, p_float.class, p_float.class);
    }

    public static void OpDIV_FF(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpDIV(temp_float, temp_float, temp_float, a, b, Res, State, p_float.class, p_float.class, p_float.class);
    }

    public static void OpADD_FF(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpADD(temp_float, temp_float, temp_float, a, b, Res, State, p_float.class, p_float.class, p_float.class);
    }

    public static void OpSUB_FF(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpSUB(temp_float, temp_float, temp_float, a, b, Res, State, p_float.class, p_float.class, p_float.class);
    }

    public static void OpNEG_F(IqShaderData a, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpNEG(temp_float, a, Res, State, p_float.class);
    }

    public static void OpMUL_PP(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpMUL(temp_point, temp_point, temp_point, a, b, Res, State, CqVector3D.class, CqVector3D.class, CqVector3D.class);
    }

    public static void OpDIV_PP(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpDIV(temp_point, temp_point, temp_point, a, b, Res, State, CqVector3D.class, CqVector3D.class, CqVector3D.class);
    }

    public static void OpADD_PP(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpADD(temp_point, temp_point, temp_point, a, b, Res, State, CqVector3D.class, CqVector3D.class, CqVector3D.class);
    }

    public static void OpSUB_PP(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpSUB(temp_point, temp_point, temp_point, a, b, Res, State, CqVector3D.class, CqVector3D.class, CqVector3D.class);
    }

    public static void OpCRS_PP(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpCRS(temp_point, temp_point, temp_point, a, b, Res, State, CqVector3D.class, CqVector3D.class, CqVector3D.class);
    }

    public static void OpDOT_PP(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpDOT(temp_point, temp_point, temp_float, a, b, Res, State, CqVector3D.class, CqVector3D.class, p_float.class);
    }

    public static void OpNEG_P(IqShaderData a, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpNEG(temp_point, a, Res, State, CqVector3D.class);
    }

    public static void OpMUL_CC(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpMUL(temp_color, temp_color, temp_color, a, b, Res, State, CqColor.class, CqColor.class, CqColor.class);
    }

    public static void OpDIV_CC(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpDIV(temp_color, temp_color, temp_color, a, b, Res, State, CqColor.class, CqColor.class, CqColor.class);
    }

    public static void OpADD_CC(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpADD(temp_color, temp_color, temp_color, a, b, Res, State, CqColor.class, CqColor.class, CqColor.class);
    }

    public static void OpSUB_CC(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpSUB(temp_color, temp_color, temp_color, a, b, Res, State, CqColor.class, CqColor.class, CqColor.class);
    }

    public static void OpCRS_CC(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpCRS(temp_color, temp_color, temp_color, a, b, Res, State, CqColor.class, CqColor.class, CqColor.class);
    }

    public static void OpDOT_CC(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpDOT(temp_color, temp_color, temp_color, a, b, Res, State, CqColor.class, CqColor.class, CqColor.class);
    }

    public static void OpNEG_C(IqShaderData a, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpNEG(temp_color, a, Res, State, CqColor.class);
    }

    public static void OpMUL_FP(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpMUL(temp_float, temp_point, temp_point, a, b, Res, State, p_float.class, CqVector3D.class, CqVector3D.class);
    }

    public static void OpDIV_FP(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpDIV(temp_float, temp_point, temp_point, a, b, Res, State, p_float.class, CqVector3D.class, CqVector3D.class);
    }

    public static void OpADD_FP(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpADD(temp_float, temp_point, temp_point, a, b, Res, State, p_float.class, CqVector3D.class, CqVector3D.class);
    }

    public static void OpSUB_FP(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpSUB(temp_float, temp_point, temp_point, a, b, Res, State, p_float.class, CqVector3D.class, CqVector3D.class);
    }

    public static void OpMUL_FC(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpMUL(temp_float, temp_color, temp_color, a, b, Res, State, p_float.class, CqColor.class, CqColor.class);
    }

    public static void OpDIV_FC(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpDIV(temp_float, temp_color, temp_color, a, b, Res, State, p_float.class, CqColor.class, CqColor.class);
    }

    public static void OpADD_FC(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpADD(temp_float, temp_color, temp_color, a, b, Res, State, p_float.class, CqColor.class, CqColor.class);
    }

    public static void OpSUB_FC(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpSUB(temp_float, temp_color, temp_color, a, b, Res, State, p_float.class, CqColor.class, CqColor.class);
    }

    public static void OpLAND_B(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpLAND(temp_float, temp_float, temp_float, a, b, Res, State, p_float.class, p_float.class, p_float.class);
    }

    public static void OpLOR_B(IqShaderData a, IqShaderData b, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpLOR(temp_float, temp_float, temp_float, a, b, Res, State, p_float.class, p_float.class, p_float.class);
    }

    public static void OpCAST_FC(IqShaderData a, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpCAST(temp_float, temp_color, a, Res, State, p_float.class, CqColor.class);
    }

    public static void OpCAST_FP(IqShaderData a, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpCAST(temp_float, temp_point, a, Res, State, p_float.class, CqVector3D.class);
    }

    public static void OpCAST_PC(IqShaderData a, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpCAST(temp_point, temp_color, a, Res, State, CqVector3D.class, CqColor.class);
    }

    public static void OpCAST_CP(IqShaderData a, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpCAST(temp_color, temp_point, a, Res, State, CqColor.class, CqVector3D.class);
    }

    public static void OpCAST_FM(IqShaderData a, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpCAST(temp_float, temp_matrix, a, Res, State, p_float.class, CqMatrix.class);
    }

    public static void OpTRIPLE_C(IqShaderData r, IqShaderData a, IqShaderData b, IqShaderData c, CqBitVector State) {
        GlobalShaderVM.OpTRIPLE(temp_color, r, a, b, c, State, CqColor.class);
    }

    public static void OpTRIPLE_P(IqShaderData r, IqShaderData a, IqShaderData b, IqShaderData c, CqBitVector State) {
        GlobalShaderVM.OpTRIPLE(temp_point, r, a, b, c, State, CqVector3D.class);
    }

    public static void OpHEXTUPLE_M(IqShaderData r, IqShaderData a, IqShaderData b, IqShaderData c, IqShaderData d, IqShaderData e, IqShaderData f, IqShaderData g, IqShaderData h, IqShaderData i, IqShaderData j, IqShaderData k, IqShaderData l, IqShaderData m, IqShaderData n, IqShaderData o, IqShaderData p, CqBitVector State) {
        GlobalShaderVM.OpHEXTUPLE(temp_matrix, r, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, State, CqMatrix.class);
    }

    public static void OpCOMP_C(IqShaderData a, IqShaderData index, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpCOMP(temp_color, a, index, Res, State, CqColor.class);
    }

    public static void OpCOMP_P(IqShaderData a, IqShaderData index, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpCOMP(temp_point, a, index, Res, State, CqVector3D.class);
    }

    public static void OpCOMP_C(IqShaderData a, int index, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpCOMP(temp_color, a, index, Res, State, CqColor.class);
    }

    public static void OpCOMP_P(IqShaderData a, int index, IqShaderData Res, CqBitVector State) {
        GlobalShaderVM.OpCOMP(temp_point, a, index, Res, State, CqVector3D.class);
    }

    private static <A, B, R> void OpABRS(String OP, A a, B b, R r, IqShaderData pA, IqShaderData pB, IqShaderData pRes, CqBitVector RunningState, Class<A> clsA, Class<B> clsB, Class<R> clsR) {
        STLArray pdA;
        boolean fBVar;
        A vA = null;
        B vB = null;
        try {
            vA = clsA.newInstance();
            vB = clsB.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        int idxR = 0;
        int idxB = 0;
        int idxA = 0;
        boolean fAVar = pA.Size() > 1L;
        boolean bl = fBVar = pB.Size() > 1L;
        if (fAVar && fBVar) {
            pdA = pA.GetValuePtr_2(a);
            STLArray pdB = pB.GetValuePtr_2(b);
            STLArray pdR = pRes.GetValuePtr_2(r);
            int ii = (int)pA.Size();
            int i = 0;
            while (i < ii) {
                if (RunningState.Value(i)) {
                    pRes.SetValue(GlobalShaderVM.oparator(OP, pdA.get(idxA), pdB.get(idxB), clsA, clsB), idxR, clsR);
                }
                ++idxA;
                ++idxB;
                ++idxR;
                ++i;
            }
        } else if (!fBVar && fAVar) {
            int ii = (int)pA.Size();
            pdA = pA.GetValuePtr_2(a);
            pB.GetValue(vB, clsB);
            STLArray pdR = pRes.GetValuePtr_2(r);
            int i = 0;
            while (i < ii) {
                if (RunningState.Value(i)) {
                    pRes.SetValue(GlobalShaderVM.oparator(OP, pdA.get(idxA), vB, clsA, clsB), idxR, clsR);
                }
                ++idxA;
                ++idxR;
                ++i;
            }
        } else if (!fAVar && fBVar) {
            int ii = (int)pB.Size();
            STLArray pdB = pB.GetValuePtr_2(b);
            pA.GetValue(vA, clsA);
            STLArray pdR = pRes.GetValuePtr_2(r);
            int i = 0;
            while (i < ii) {
                if (RunningState.Value(i)) {
                    pRes.SetValue(GlobalShaderVM.oparator(OP, vA, pdB.get(idxB), clsA, clsB), idxR, clsR);
                }
                ++idxB;
                ++idxR;
                ++i;
            }
        } else {
            pA.GetValue(vA, clsA);
            pB.GetValue(vB, clsB);
            pRes.SetValue(GlobalShaderVM.oparator(OP, vA, vB, clsA, clsB), clsR);
        }
    }

    private static <A, B, R> void OpLSS(A a, B b, R r, IqShaderData pA, IqShaderData pB, IqShaderData pRes, CqBitVector RunningState, Class<A> clsA, Class<B> clsB, Class<R> clsR) {
        GlobalShaderVM.OpABRS("<", a, b, r, pA, pB, pRes, RunningState, clsA, clsB, clsR);
    }

    private static <A, B, R> void OpGRT(A a, B b, R r, IqShaderData pA, IqShaderData pB, IqShaderData pRes, CqBitVector RunningState, Class<A> clsA, Class<B> clsB, Class<R> clsR) {
        GlobalShaderVM.OpABRS(">", a, b, r, pA, pB, pRes, RunningState, clsA, clsB, clsR);
    }

    private static <A, B, R> void OpLE(A a, B b, R r, IqShaderData pA, IqShaderData pB, IqShaderData pRes, CqBitVector RunningState, Class<A> clsA, Class<B> clsB, Class<R> clsR) {
        GlobalShaderVM.OpABRS("<=", a, b, r, pA, pB, pRes, RunningState, clsA, clsB, clsR);
    }

    private static <A, B, R> void OpGE(A a, B b, R r, IqShaderData pA, IqShaderData pB, IqShaderData pRes, CqBitVector RunningState, Class<A> clsA, Class<B> clsB, Class<R> clsR) {
        GlobalShaderVM.OpABRS(">=", a, b, r, pA, pB, pRes, RunningState, clsA, clsB, clsR);
    }

    private static <A, B, R> void OpEQ(A a, B b, R r, IqShaderData pA, IqShaderData pB, IqShaderData pRes, CqBitVector RunningState, Class<A> clsA, Class<B> clsB, Class<R> clsR) {
        GlobalShaderVM.OpABRS("==", a, b, r, pA, pB, pRes, RunningState, clsA, clsB, clsR);
    }

    private static <A, B, R> void OpNE(A a, B b, R r, IqShaderData pA, IqShaderData pB, IqShaderData pRes, CqBitVector RunningState, Class<A> clsA, Class<B> clsB, Class<R> clsR) {
        GlobalShaderVM.OpABRS("!=", a, b, r, pA, pB, pRes, RunningState, clsA, clsB, clsR);
    }

    private static <A, B, R> void OpMUL(A a, B b, R r, IqShaderData pA, IqShaderData pB, IqShaderData pRes, CqBitVector RunningState, Class<A> clsA, Class<B> clsB, Class<R> clsR) {
        GlobalShaderVM.OpABRS("*", a, b, r, pA, pB, pRes, RunningState, clsA, clsB, clsR);
    }

    public static void OpMULV(IqShaderData pA, IqShaderData pB, IqShaderData pRes, CqBitVector RunningState) {
        boolean fBVar;
        CqVector3D vA = new CqVector3D();
        CqVector3D vB = new CqVector3D();
        int idxB = 0;
        int idxA = 0;
        boolean fAVar = pA.Size() > 1L;
        boolean bl = fBVar = pB.Size() > 1L;
        if (fAVar && fBVar) {
            STLArray pdA = pA.GetValuePtr_2(vA);
            STLArray pdB = pB.GetValuePtr_2(vB);
            int ii = (int)pA.Size();
            int i = 0;
            while (i < ii) {
                if (RunningState.Value(i)) {
                    pRes.SetValue(new CqVector3D(((CqVector3D)pdA.get((int)idxA)).x * ((CqVector3D)pdB.get((int)idxB)).x, ((CqVector3D)pdA.get((int)idxA)).y * ((CqVector3D)pdB.get((int)idxB)).y, ((CqVector3D)pdA.get((int)idxA)).z * ((CqVector3D)pdB.get((int)idxB)).z), i);
                }
                ++idxA;
                ++idxB;
                ++i;
            }
        } else if (!fBVar && fAVar) {
            int ii = (int)pA.Size();
            STLArray pdA = pA.GetValuePtr_2(vA);
            pB.GetValue(vB);
            int i = 0;
            while (i < ii) {
                if (RunningState.Value(i)) {
                    pRes.SetValue(new CqVector3D(((CqVector3D)pdA.get((int)idxA)).x * vB.x, ((CqVector3D)pdA.get((int)idxA)).y * vB.y, ((CqVector3D)pdA.get((int)idxA)).z * vB.z), i);
                }
                ++idxA;
                ++i;
            }
        } else if (!fAVar && fBVar) {
            int ii = (int)pB.Size();
            STLArray pdB = pB.GetValuePtr_2(vB);
            pA.GetValue(vA);
            int i = 0;
            while (i < ii) {
                if (RunningState.Value(i)) {
                    pRes.SetValue(new CqVector3D(vA.x * ((CqVector3D)pdB.get((int)idxB)).x, vA.y * ((CqVector3D)pdB.get((int)idxB)).y, vA.z * ((CqVector3D)pdB.get((int)idxB)).z), i);
                }
                ++idxB;
                ++i;
            }
        } else {
            pA.GetValue(vA);
            pB.GetValue(vB);
            pRes.SetValue(new CqVector3D(vA.x * vB.x, vA.y * vB.y, vA.z * vB.z));
        }
    }

    private static <A, B, R> void OpDIV(A a, B b, R r, IqShaderData pA, IqShaderData pB, IqShaderData pRes, CqBitVector RunningState, Class<A> clsA, Class<B> clsB, Class<R> clsR) {
        GlobalShaderVM.OpABRS("/", a, b, r, pA, pB, pRes, RunningState, clsA, clsB, clsR);
    }

    private static <A, B, R> void OpADD(A a, B b, R r, IqShaderData pA, IqShaderData pB, IqShaderData pRes, CqBitVector RunningState, Class<A> clsA, Class<B> clsB, Class<R> clsR) {
        GlobalShaderVM.OpABRS("+", a, b, r, pA, pB, pRes, RunningState, clsA, clsB, clsR);
    }

    private static <A, B, R> void OpSUB(A a, B b, R r, IqShaderData pA, IqShaderData pB, IqShaderData pRes, CqBitVector RunningState, Class<A> clsA, Class<B> clsB, Class<R> clsR) {
        GlobalShaderVM.OpABRS("-", a, b, r, pA, pB, pRes, RunningState, clsA, clsB, clsR);
    }

    private static <A, B, R> void OpDOT(A a, B b, R r, IqShaderData pA, IqShaderData pB, IqShaderData pRes, CqBitVector RunningState, Class<A> clsA, Class<B> clsB, Class<R> clsR) {
        GlobalShaderVM.OpABRS("*", a, b, r, pA, pB, pRes, RunningState, clsA, clsB, clsR);
    }

    private static <A, B, R> void OpCRS(A a, B b, R r, IqShaderData pA, IqShaderData pB, IqShaderData pRes, CqBitVector RunningState, Class<A> clsA, Class<B> clsB, Class<R> clsR) {
        GlobalShaderVM.OpABRS("%", a, b, r, pA, pB, pRes, RunningState, clsA, clsB, clsR);
    }

    private static <A, B, R> void OpLAND(A a, B b, R r, IqShaderData pA, IqShaderData pB, IqShaderData pRes, CqBitVector RunningState, Class<A> clsA, Class<B> clsB, Class<R> clsR) {
        GlobalShaderVM.OpABRS("&&", a, b, r, pA, pB, pRes, RunningState, clsA, clsB, clsR);
    }

    private static <A, B, R> void OpLOR(A a, B b, R r, IqShaderData pA, IqShaderData pB, IqShaderData pRes, CqBitVector RunningState, Class<A> clsA, Class<B> clsB, Class<R> clsR) {
        GlobalShaderVM.OpABRS("||", a, b, r, pA, pB, pRes, RunningState, clsA, clsB, clsR);
    }

    private static <A> void OpNEG(A a, IqShaderData pA, IqShaderData pRes, CqBitVector RunningState, Class<A> clsA) {
        block16: {
            A vA;
            block18: {
                block17: {
                    block15: {
                        boolean fAVar;
                        vA = AccessSupplier.getNewInstance(clsA, new Object[0]);
                        int idxA = 0;
                        boolean bl = fAVar = pA.Size() > 1L;
                        if (!fAVar) break block15;
                        STLArray pdA = pA.GetValuePtr_2(vA);
                        int ii = (int)pA.Size();
                        int i = 0;
                        while (i < ii) {
                            if (RunningState.Value(i)) {
                                Method negate;
                                if (clsA == p_float.class) {
                                    p_float fltA = (p_float)pdA.get(idxA);
                                    pRes.SetValue(-fltA.value, i);
                                } else if (clsA == CqVector3D.class) {
                                    try {
                                        negate = AccessSupplier.getMethod(pdA.get(idxA), "negative", new Class[0]);
                                        pRes.SetValue(negate.invoke(pdA.get(idxA), new Object[0]), i, clsA);
                                    }
                                    catch (Exception e) {
                                        HimawariLogger.outputException(e);
                                    }
                                } else if (clsA == CqColor.class) {
                                    try {
                                        negate = AccessSupplier.getMethod(pdA.get(idxA), "negate", new Class[0]);
                                        pRes.SetValue(negate.invoke(pdA.get(idxA), new Object[0]), i, clsA);
                                    }
                                    catch (Exception e) {
                                        HimawariLogger.outputException(e);
                                    }
                                }
                            }
                            ++idxA;
                            ++i;
                        }
                        break block16;
                    }
                    pA.GetValue(vA, clsA);
                    if (clsA != p_float.class) break block17;
                    p_float fltA = (p_float)vA;
                    pRes.SetValue(-fltA.value);
                    break block16;
                }
                if (clsA != CqVector3D.class) break block18;
                try {
                    Method negate = AccessSupplier.getMethod(vA, "negative", new Class[0]);
                    pRes.SetValue(negate.invoke(vA, new Object[0]), clsA);
                }
                catch (Exception e) {
                    HimawariLogger.outputException(e);
                }
                break block16;
            }
            if (clsA != CqColor.class) break block16;
            try {
                Method negate = AccessSupplier.getMethod(vA, "negate", new Class[0]);
                pRes.SetValue(negate.invoke(vA, new Object[0]), clsA);
            }
            catch (Exception e) {
                HimawariLogger.outputException(e);
            }
        }
    }

    private static <A, B> void OpCAST(A a, B b, IqShaderData pA, IqShaderData pRes, CqBitVector RunningState, Class<A> clsA, Class<B> clsB) {
        boolean fAVar;
        A vA = AccessSupplier.getNewInstance(clsA, new Object[0]);
        STLArray pdA = new STLArray(clsA);
        int idxA = 0;
        boolean bl = fAVar = pA.Size() > 1L;
        if (fAVar) {
            pdA = pA.GetValuePtr_2(vA);
            int ii = (int)pA.Size();
            int i = 0;
            while (i < ii) {
                if (RunningState.Value(i)) {
                    B ret;
                    if (clsA == p_float.class) {
                        ret = AccessSupplier.getNewInstance(clsB, Float.valueOf(((p_float)pdA.get((int)idxA)).value));
                        pRes.SetValue(ret, i, clsB);
                    } else {
                        ret = AccessSupplier.getNewInstance(clsB, pdA.get(idxA));
                        pRes.SetValue(ret, i, clsB);
                    }
                }
                ++idxA;
                ++i;
            }
        } else {
            pA.GetValue(vA, clsA);
            if (clsA == p_float.class) {
                B ret = AccessSupplier.getNewInstance(clsB, Float.valueOf(((p_float)vA).value));
                pRes.SetValue(ret, clsB);
            } else {
                B ret = AccessSupplier.getNewInstance(clsB, vA);
                pRes.SetValue(ret, clsB);
            }
        }
    }

    private static <A> void OpTRIPLE(A a, IqShaderData pRes, IqShaderData pA, IqShaderData pB, IqShaderData pC, CqBitVector RunningState, Class<A> clsA) {
        p_float x = new p_float();
        p_float y = new p_float();
        p_float z = new p_float();
        int i = (int)Math.max(Math.max(pA.Size(), pB.Size()), pC.Size()) - 1;
        boolean __fVarying = i > 0;
        while (i >= 0) {
            if (!__fVarying || RunningState.Value(i)) {
                pA.GetValue(x, i);
                pB.GetValue(y, i);
                pC.GetValue(z, i);
                pRes.SetValue(AccessSupplier.getNewInstance(clsA, Float.valueOf(x.value), Float.valueOf(y.value), Float.valueOf(z.value)), i, clsA);
            }
            --i;
        }
    }

    private static <A> void OpHEXTUPLE(A z, IqShaderData pRes, IqShaderData pA, IqShaderData pB, IqShaderData pC, IqShaderData pD, IqShaderData pE, IqShaderData pF, IqShaderData pG, IqShaderData pH, IqShaderData pI, IqShaderData pJ, IqShaderData pK, IqShaderData pL, IqShaderData pM, IqShaderData pN, IqShaderData pO, IqShaderData pP, CqBitVector RunningState, Class<A> clsA) {
        p_float a1 = new p_float();
        p_float a2 = new p_float();
        p_float a3 = new p_float();
        p_float a4 = new p_float();
        p_float b1 = new p_float();
        p_float b2 = new p_float();
        p_float b3 = new p_float();
        p_float b4 = new p_float();
        p_float c1 = new p_float();
        p_float c2 = new p_float();
        p_float c3 = new p_float();
        p_float c4 = new p_float();
        p_float d1 = new p_float();
        p_float d2 = new p_float();
        p_float d3 = new p_float();
        p_float d4 = new p_float();
        int ii1 = (int)Math.max(Math.max(Math.max(pA.Size(), pB.Size()), pC.Size()), pD.Size());
        int ii2 = (int)Math.max(Math.max(Math.max(pE.Size(), pF.Size()), pG.Size()), pH.Size());
        int ii3 = (int)Math.max(Math.max(Math.max(pI.Size(), pJ.Size()), pK.Size()), pL.Size());
        int ii4 = (int)Math.max(Math.max(Math.max(pM.Size(), pN.Size()), pO.Size()), pP.Size());
        int ii = Math.max(Math.max(Math.max(ii1, ii2), ii3), ii4);
        boolean __fVarying = ii > 0;
        while (ii >= 0) {
            if (!__fVarying || RunningState.Value(ii)) {
                pA.GetValue(a1, ii);
                pB.GetValue(a2, ii);
                pC.GetValue(a3, ii);
                pD.GetValue(a4, ii);
                pE.GetValue(b1, ii);
                pF.GetValue(b2, ii);
                pG.GetValue(b3, ii);
                pH.GetValue(b4, ii);
                pI.GetValue(c1, ii);
                pJ.GetValue(c2, ii);
                pK.GetValue(c3, ii);
                pL.GetValue(c4, ii);
                pM.GetValue(d1, ii);
                pN.GetValue(d2, ii);
                pO.GetValue(d3, ii);
                pP.GetValue(d4, ii);
                A tt = AccessSupplier.getNewInstance(clsA, Float.valueOf(a1.value), Float.valueOf(a2.value), Float.valueOf(a3.value), Float.valueOf(a4.value), Float.valueOf(b1.value), Float.valueOf(b2.value), Float.valueOf(b3.value), Float.valueOf(b4.value), Float.valueOf(c1.value), Float.valueOf(c2.value), Float.valueOf(c3.value), Float.valueOf(c4.value), Float.valueOf(d1.value), Float.valueOf(d2.value), Float.valueOf(d3.value), Float.valueOf(d4.value));
                AccessSupplier.invokeMethod(tt, "SetfIdentity", false);
                pRes.SetValue(tt, ii, clsA);
            }
            --ii;
        }
    }

    public static <A> void OpCOMP(A z, IqShaderData pA, int index, IqShaderData pRes, CqBitVector RunningState, Class<A> clsA) {
        boolean fAVar;
        A vA = AccessSupplier.getNewInstance(clsA, new Object[0]);
        STLArray pdA = new STLArray(clsA);
        int idxA = 0;
        boolean bl = fAVar = pA.Size() > 1L;
        if (fAVar) {
            pdA = pA.GetValuePtr_2(vA);
            int ii = (int)pA.Size();
            int i = 0;
            while (i < ii) {
                if (RunningState.Value(i)) {
                    float res = ((Float)AccessSupplier.invokeMethod(pdA.get(idxA), "valueAt", index)).floatValue();
                    pRes.SetValue(new p_float(res), i, p_float.class);
                }
                ++idxA;
                ++i;
            }
        } else {
            pA.GetValue(vA, clsA);
            float res = ((Float)AccessSupplier.invokeMethod(vA, "valueAt", index)).floatValue();
            pRes.SetValue(new p_float(res), p_float.class);
        }
    }

    public static <A> void OpCOMP(A z, IqShaderData pA, IqShaderData pB, IqShaderData pRes, CqBitVector RunningState, Class<A> clsA) {
        boolean fBVar;
        A vA = AccessSupplier.getNewInstance(clsA, new Object[0]);
        p_float vB = new p_float();
        STLArray pdA = new STLArray(clsA);
        STLArray pdB = new STLArray(p_float.class);
        int idxB = 0;
        int idxA = 0;
        boolean fAVar = pA.Size() > 1L;
        boolean bl = fBVar = pB.Size() > 1L;
        if (fAVar && fBVar) {
            pdA = pA.GetValuePtr_2(vA);
            pdB = pB.GetValuePtr_2(vB);
            int ii = (int)pA.Size();
            int i = 0;
            while (i < ii) {
                if (RunningState.Value(i)) {
                    float res = ((Float)AccessSupplier.invokeMethod(pdA.get(idxA), "valueAt", (int)((p_float)pdB.get((int)idxB)).value)).floatValue();
                    pRes.SetValue(new p_float(res), i, p_float.class);
                }
                ++idxA;
                ++idxB;
                ++i;
            }
        } else if (!fBVar && fAVar) {
            int ii = (int)pA.Size();
            pdA = pA.GetValuePtr_2(vA);
            pB.GetValue(vB);
            int index = (int)vB.value;
            int i = 0;
            while (i < ii) {
                if (RunningState.Value(i)) {
                    float res = ((Float)AccessSupplier.invokeMethod(pdA.get(idxA), "valueAt", index)).floatValue();
                    pRes.SetValue(new p_float(res), i, p_float.class);
                }
                ++idxA;
                ++i;
            }
        } else if (!fAVar && fBVar) {
            int ii = (int)pB.Size();
            pdB = pB.GetValuePtr_2(vB);
            pA.GetValue(vA, clsA);
            int i = 0;
            while (i < ii) {
                if (RunningState.Value(i)) {
                    float res = ((Float)AccessSupplier.invokeMethod(vA, "valueAt", (int)((p_float)pdB.get((int)idxB)).value)).floatValue();
                    pRes.SetValue(new p_float(res), i, p_float.class);
                }
                ++idxB;
                ++i;
            }
        } else {
            pA.GetValue(vA, clsA);
            pB.GetValue(vB);
            int index = (int)vB.value;
            float res = ((Float)AccessSupplier.invokeMethod(vA, "valueAt", index)).floatValue();
            pRes.SetValue(new p_float(res), p_float.class);
        }
    }

    public static void OpCOMPM(IqShaderData pA, IqShaderData pR, IqShaderData pC, IqShaderData pRes, CqBitVector RunningState) {
        CqMatrix m = new CqMatrix();
        p_float fr = new p_float();
        p_float fc = new p_float();
        int i = (int)Math.max(pA.Size(), pRes.Size()) - 1;
        boolean __fVarying = i > 0;
        while (i >= 0) {
            if (!__fVarying || RunningState.Value(i)) {
                pA.GetValue(m, i);
                pR.GetValue(fr, i);
                pC.GetValue(fc, i);
                pRes.SetValue(m.m_aaElement[(int)fr.value][(int)fc.value], i);
            }
            --i;
        }
    }

    private static <A, B> Object oparator(String op, A vA, B vB, Class<A> clsA, Class<B> clsB) {
        try {
            int opHash;
            boolean isNotSame = false;
            boolean existPfloat = false;
            if (clsA == p_float.class || clsB == p_float.class) {
                existPfloat = true;
            }
            if (clsA != clsB) {
                isNotSame = true;
            }
            if ((opHash = op.hashCode()) == _OP_LSS_) {
                if (clsA == p_float.class) {
                    p_float fltA = (p_float)vA;
                    p_float fltB = (p_float)vB;
                    return new p_float(fltA.value < fltB.value ? 1 : 0);
                }
                if (clsA == p_String.class) {
                    p_String strA = (p_String)vA;
                    p_String strB = (p_String)vB;
                    return new p_float(strA.value.compareTo(strB.value) < 0 ? 1 : 0);
                }
                if (clsA == CqVector3D.class) {
                    return new p_float(Boolean.valueOf(((CqVector3D)vA).lt((CqVector3D)vB)) != false ? 1 : 0);
                }
                if (clsA == CqVector4D.class) {
                    return new p_float(Boolean.valueOf(((CqVector4D)vA).lt((CqVector4D)vB)) != false ? 1 : 0);
                }
                if (clsA == CqColor.class) {
                    return new p_float(Boolean.valueOf(((CqColor)vA).lt((CqColor)vB)) != false ? 1 : 0);
                }
            } else if (opHash == _OP_GRT_) {
                if (clsA == p_float.class) {
                    p_float fltA = (p_float)vA;
                    p_float fltB = (p_float)vB;
                    return new p_float(fltA.value > fltB.value ? 1 : 0);
                }
                if (clsA == p_String.class) {
                    p_String strA = (p_String)vA;
                    p_String strB = (p_String)vB;
                    return new p_float(strA.value.compareTo(strB.value) > 0 ? 1 : 0);
                }
                if (clsA == CqVector3D.class) {
                    return new p_float(Boolean.valueOf(((CqVector3D)vA).gt((CqVector3D)vB)) != false ? 1 : 0);
                }
                if (clsA == CqVector4D.class) {
                    return new p_float(Boolean.valueOf(((CqVector4D)vA).gt((CqVector4D)vB)) != false ? 1 : 0);
                }
                if (clsA == CqColor.class) {
                    return new p_float(Boolean.valueOf(((CqColor)vA).gt((CqColor)vB)) != false ? 1 : 0);
                }
            } else if (opHash == _OP_LE_) {
                if (clsA == p_float.class) {
                    p_float fltA = (p_float)vA;
                    p_float fltB = (p_float)vB;
                    return new p_float(fltA.value <= fltB.value ? 1 : 0);
                }
                if (clsA == p_String.class) {
                    p_String strA = (p_String)vA;
                    p_String strB = (p_String)vB;
                    return new p_float(strA.value.compareTo(strB.value) <= 0 ? 1 : 0);
                }
                if (clsA == CqVector3D.class) {
                    return new p_float(Boolean.valueOf(((CqVector3D)vA).le((CqVector3D)vB)) != false ? 1 : 0);
                }
                if (clsA == CqVector4D.class) {
                    return new p_float(Boolean.valueOf(((CqVector4D)vA).le((CqVector4D)vB)) != false ? 1 : 0);
                }
                if (clsA == CqColor.class) {
                    return new p_float(Boolean.valueOf(((CqColor)vA).le((CqColor)vB)) != false ? 1 : 0);
                }
            } else if (opHash == _OP_GE_) {
                if (clsA == p_float.class) {
                    p_float fltA = (p_float)vA;
                    p_float fltB = (p_float)vB;
                    return new p_float(fltA.value >= fltB.value ? 1 : 0);
                }
                if (clsA == p_String.class) {
                    p_String strA = (p_String)vA;
                    p_String strB = (p_String)vB;
                    return new p_float(strA.value.compareTo(strB.value) >= 0 ? 1 : 0);
                }
                if (clsA == CqVector3D.class) {
                    return new p_float(Boolean.valueOf(((CqVector3D)vA).ge((CqVector3D)vB)) != false ? 1 : 0);
                }
                if (clsA == CqVector4D.class) {
                    return new p_float(Boolean.valueOf(((CqVector4D)vA).ge((CqVector4D)vB)) != false ? 1 : 0);
                }
                if (clsA == CqColor.class) {
                    return new p_float(Boolean.valueOf(((CqColor)vA).ge((CqColor)vB)) != false ? 1 : 0);
                }
            } else if (opHash == _OP_EQ_) {
                if (clsA == p_float.class) {
                    p_float fltA = (p_float)vA;
                    p_float fltB = (p_float)vB;
                    return new p_float(fltA.value == fltB.value ? 1 : 0);
                }
                if (clsA == p_String.class) {
                    p_String strA = (p_String)vA;
                    p_String strB = (p_String)vB;
                    return new p_float(strA.value.compareTo(strB.value) == 0 ? 1 : 0);
                }
                if (clsA == CqVector3D.class) {
                    return new p_float(Boolean.valueOf(((CqVector3D)vA).equals((CqVector3D)vB)) != false ? 1 : 0);
                }
                if (clsA == CqVector4D.class) {
                    return new p_float(Boolean.valueOf(((CqVector4D)vA).equals((CqVector4D)vB)) != false ? 1 : 0);
                }
                if (clsA == CqColor.class) {
                    return new p_float(Boolean.valueOf(((CqColor)vA).equals((CqColor)vB)) != false ? 1 : 0);
                }
            } else if (opHash == _OP_NE_) {
                if (clsA == p_float.class) {
                    p_float fltA = (p_float)vA;
                    p_float fltB = (p_float)vB;
                    return new p_float(fltA.value != fltB.value ? 1 : 0);
                }
                if (clsA == p_String.class) {
                    p_String strA = (p_String)vA;
                    p_String strB = (p_String)vB;
                    return new p_float(strA.value.compareTo(strB.value) != 0 ? 1 : 0);
                }
                if (clsA == CqVector3D.class) {
                    return new p_float(Boolean.valueOf(((CqVector3D)vA).equals((CqVector3D)vB)) == false ? 1 : 0);
                }
                if (clsA == CqVector4D.class) {
                    return new p_float(Boolean.valueOf(((CqVector4D)vA).equals((CqVector4D)vB)) == false ? 1 : 0);
                }
                if (clsA == CqColor.class) {
                    return new p_float(Boolean.valueOf(((CqColor)vA).equals((CqColor)vB)) == false ? 1 : 0);
                }
            } else if (opHash == _OP_MUL_) {
                if (!isNotSame || !existPfloat) {
                    if (clsA == CqVector3D.class) {
                        return new p_float(((CqVector3D)vA).mul((CqVector3D)vB));
                    }
                    if (clsA == p_float.class) {
                        p_float fltA = (p_float)vA;
                        p_float fltB = (p_float)vB;
                        return new p_float(fltA.value * fltB.value);
                    }
                    if (clsA == CqVector4D.class) {
                        return new p_float(((CqVector4D)vA).mul((CqVector4D)vB));
                    }
                    if (clsA == CqColor.class) {
                        return ((CqColor)vA).mul((CqColor)vB);
                    }
                    if (clsA == p_String.class) {
                        p_String strA = (p_String)vA;
                        return strA;
                    }
                } else if (clsA == p_float.class) {
                    if (clsB == CqVector3D.class) {
                        return ((CqVector3D)vB).mul(((p_float)vA).value);
                    }
                    if (clsB == CqVector4D.class) {
                        return ((CqVector4D)vB).mul(((p_float)vA).value);
                    }
                    if (clsB == CqColor.class) {
                        return ((CqColor)vB).mul(((p_float)vA).value);
                    }
                } else if (clsB == p_float.class) {
                    if (clsA == CqVector3D.class) {
                        return ((CqVector3D)vA).mul(((p_float)vB).value);
                    }
                    if (clsA == CqVector4D.class) {
                        return ((CqVector4D)vA).mul(((p_float)vB).value);
                    }
                    if (clsA == CqColor.class) {
                        return ((CqColor)vA).mul(((p_float)vB).value);
                    }
                }
            } else if (opHash == _OP_DIV_) {
                if (!isNotSame || !existPfloat) {
                    if (clsA == CqVector3D.class) {
                        return ((CqVector3D)vA).div((CqVector3D)vB);
                    }
                    if (clsA == p_float.class) {
                        p_float fltA = (p_float)vA;
                        p_float fltB = (p_float)vB;
                        return new p_float(fltA.value / fltB.value);
                    }
                    if (clsA == CqColor.class) {
                        return ((CqColor)vA).div((CqColor)vB);
                    }
                    if (clsA == p_String.class) {
                        p_String strA = (p_String)vA;
                        return strA;
                    }
                } else if (clsA == p_float.class) {
                    if (clsB == CqVector3D.class) {
                        return ((CqVector3D)vB).divInv(((p_float)vA).value);
                    }
                    if (clsB == CqVector4D.class) {
                        return ((CqVector4D)vB).divInv(((p_float)vA).value);
                    }
                    if (clsB == CqColor.class) {
                        return ((CqColor)vB).divInv(((p_float)vA).value);
                    }
                } else if (clsB == p_float.class) {
                    if (clsA == CqVector3D.class) {
                        return ((CqVector3D)vA).div(((p_float)vB).value);
                    }
                    if (clsA == CqVector4D.class) {
                        return ((CqVector4D)vA).div(((p_float)vB).value);
                    }
                    if (clsA == CqColor.class) {
                        return ((CqColor)vA).div(((p_float)vB).value);
                    }
                }
            } else if (opHash == _OP_ADD_) {
                if (!isNotSame || !existPfloat) {
                    if (clsA == CqVector3D.class) {
                        return ((CqVector3D)vA).add((CqVector3D)vB);
                    }
                    if (clsA == p_float.class) {
                        p_float fltA = (p_float)vA;
                        p_float fltB = (p_float)vB;
                        return new p_float(fltA.value + fltB.value);
                    }
                    if (clsA == CqVector4D.class) {
                        return ((CqVector4D)vA).add((CqVector4D)vB);
                    }
                    if (clsA == CqColor.class) {
                        return ((CqColor)vA).add((CqColor)vB);
                    }
                    if (clsA == p_String.class) {
                        p_String strA = (p_String)vA;
                        p_String strB = (p_String)vB;
                        return new p_String(String.valueOf(strA.value) + strB.value);
                    }
                } else if (clsA == p_float.class) {
                    if (clsB == CqVector3D.class) {
                        return ((CqVector3D)vB).add(((p_float)vA).value);
                    }
                    if (clsB == CqColor.class) {
                        return ((CqColor)vB).add(((p_float)vA).value);
                    }
                } else if (clsB == p_float.class) {
                    if (clsA == CqVector3D.class) {
                        return ((CqVector3D)vA).add(((p_float)vB).value);
                    }
                    if (clsA == CqColor.class) {
                        return ((CqColor)vA).add(((p_float)vB).value);
                    }
                }
            } else if (opHash == _OP_SUB_) {
                if (!isNotSame || !existPfloat) {
                    if (clsA == CqVector3D.class) {
                        return ((CqVector3D)vA).sub((CqVector3D)vB);
                    }
                    if (clsA == p_float.class) {
                        p_float fltA = (p_float)vA;
                        p_float fltB = (p_float)vB;
                        return new p_float(fltA.value - fltB.value);
                    }
                    if (clsA == CqVector4D.class) {
                        return ((CqVector4D)vA).sub((CqVector4D)vB);
                    }
                    if (clsA == CqColor.class) {
                        return ((CqColor)vA).sub((CqColor)vB);
                    }
                    if (clsA == p_String.class) {
                        p_String strA = (p_String)vA;
                        p_String strB = (p_String)vB;
                        return strA;
                    }
                } else if (clsA == p_float.class) {
                    if (clsB == CqVector3D.class) {
                        return ((CqVector3D)vB).subInv(((p_float)vA).value);
                    }
                    if (clsB == CqColor.class) {
                        return ((CqColor)vB).subInv(((p_float)vA).value);
                    }
                } else if (clsB == p_float.class) {
                    if (clsA == CqVector3D.class) {
                        return ((CqVector3D)vA).sub(((p_float)vB).value);
                    }
                    if (clsA == CqColor.class) {
                        return ((CqColor)vA).sub(((p_float)vB).value);
                    }
                }
            } else if (opHash == _OP_DOT_) {
                if (clsA == p_float.class) {
                    p_float fltA = (p_float)vA;
                    p_float fltB = (p_float)vB;
                    return new p_float(fltA.value * fltB.value);
                }
                if (clsA == p_String.class) {
                    p_String strA = (p_String)vA;
                    return strA;
                }
                if (clsA == CqVector3D.class) {
                    return new p_float(((CqVector3D)vA).mul((CqVector3D)vB));
                }
                if (clsA == CqVector4D.class) {
                    return new p_float(((CqVector4D)vA).mul((CqVector4D)vB));
                }
                if (clsA == CqColor.class) {
                    return ((CqColor)vA).mul((CqColor)vB);
                }
            } else if (opHash == _OP_CRS_) {
                if (clsA == p_float.class) {
                    p_float fltA = (p_float)vA;
                    p_float fltB = (p_float)vB;
                    return new p_float(fltA.value % fltB.value);
                }
                if (clsA == p_String.class) {
                    p_String strA = (p_String)vA;
                    return strA;
                }
                if (!isNotSame && clsA == CqColor.class) {
                    CqVector3D vecA = new CqVector3D((CqColor)vA);
                    CqVector3D vecB = new CqVector3D((CqColor)vB);
                    CqVector3D ret = vecA.mod(vecB);
                    return new CqColor(ret);
                }
                if (clsA == CqVector3D.class) {
                    return ((CqVector3D)vA).mod((CqVector3D)vB);
                }
                if (clsA == CqVector4D.class) {
                    return ((CqVector4D)vA).mod((CqVector4D)vB);
                }
            } else {
                if (opHash == _OP_LAND_) {
                    if (clsA == p_float.class) {
                        p_float fltA = (p_float)vA;
                        p_float fltB = (p_float)vB;
                        return new p_float(fltA.value != 0.0f && fltB.value != 0.0f ? 1 : 0);
                    }
                    if (clsA == p_String.class) {
                        p_String strA = (p_String)vA;
                        p_String strB = (p_String)vB;
                        return new p_float(strA.value != null && strB.value != null ? 1 : 0);
                    }
                    return new p_float(vA != null && vB != null ? 1 : 0);
                }
                if (opHash == _OP_LOR_) {
                    if (clsA == p_float.class) {
                        p_float fltA = (p_float)vA;
                        p_float fltB = (p_float)vB;
                        return new p_float(fltA.value != 0.0f || fltB.value != 0.0f ? 1 : 0);
                    }
                    if (clsA == p_String.class) {
                        p_String strA = (p_String)vA;
                        p_String strB = (p_String)vB;
                        return new p_float(strA.value != null || strB.value != null ? 1 : 0);
                    }
                    return new p_float(vA != null || vB != null ? 1 : 0);
                }
            }
        }
        catch (Exception e) {
            HimawariLogger.outputException(e);
        }
        return null;
    }
}

