/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.parser.keywords;

import net.cellcomputing.himawari.library.RendermanInterface;
import net.cellcomputing.himawari.parser.Tokenizer;
import net.cellcomputing.himawari.parser.keywords.AbstractKeywordParser;

public strictfp class KeywordBasis
extends AbstractKeywordParser {
    public void parse(Tokenizer st) throws Exception {
        float[][] uBasis = this.readBasis(st);
        if (uBasis == null) {
            this.logger.error("Invalid uBasis : \"" + st.sval + "\"\n");
        }
        this.match(st, -2);
        int uStep = (int)st.nval;
        float[][] vBasis = this.readBasis(st);
        if (vBasis == null) {
            this.logger.error("Invalid vBasis : \"" + st.sval + "\"\n");
        }
        this.match(st, -2);
        int vStep = (int)st.nval;
        if (uBasis != null && vBasis != null) {
            RendermanInterface.RiBasis(uBasis, uStep, vBasis, vStep);
        }
    }

    private float[][] readBasis(Tokenizer st) throws Exception {
        float[][] result;
        int token = st.nextToken();
        st.pushBack();
        if (token == 91) {
            result = this.readMatrix(st);
        } else {
            this.match(st, 34);
            String name = st.sval;
            result = new float[4][4];
            boolean basis = RendermanInterface.BasisFromName(result, name);
            if (!basis) {
                return null;
            }
        }
        return result;
    }
}

