/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.parser.keywords;

import java.io.IOException;
import java.util.ArrayList;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.parser.Global;
import net.cellcomputing.himawari.parser.Parser;
import net.cellcomputing.himawari.parser.Tokenizer;
import net.cellcomputing.himawari.parser.keywords.KeywordParser;
import net.cellcomputing.himawari.util.HimawariLogger;

public strictfp abstract class AbstractKeywordParser
implements KeywordParser {
    public static final int TK_KEYWORD = -3;
    public static final int TK_NUMBER = -2;
    public static final int TK_EOF = -1;
    public static final int TK_EOL = 10;
    public static final int TK_STRING = 34;
    public static final int TK_LBRACE = 91;
    public static final int TK_RBRACE = 93;
    private static STLVector<Object> numbers = new STLVector<Object>(Object.class);
    private static STLVector<String> strings = new STLVector<String>(String.class);
    private static int arraySize;
    private int elemSize;
    protected Parser parser;
    HimawariLogger logger = HimawariLogger.getLogger();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    private String tokenToString(int token) {
        String result;
        switch (token) {
            case -3: {
                result = "keyword";
                break;
            }
            case -2: {
                result = "number";
                break;
            }
            case -1: {
                result = "EOF";
                break;
            }
            case 10: {
                result = "EOL";
                break;
            }
            case 34: {
                result = "string";
                break;
            }
            default: {
                result = "" + (char)token;
            }
        }
        return result;
    }

    private static String typeToString(int type) {
        String result;
        switch (type) {
            case 0: {
                result = "unknown";
                break;
            }
            case 1: {
                result = "float";
                break;
            }
            case 2: {
                result = "integer";
                break;
            }
            case 3: {
                result = "point";
                break;
            }
            case 4: {
                result = "string";
                break;
            }
            case 5: {
                result = "color";
                break;
            }
            case 6: {
                result = "triple";
                break;
            }
            case 7: {
                result = "hpoint";
                break;
            }
            case 8: {
                result = "normal";
                break;
            }
            case 9: {
                result = "vector";
                break;
            }
            case 11: {
                result = "matrix";
                break;
            }
            default: {
                result = "unknown";
            }
        }
        return result;
    }

    public static String paramToString(Class myclass) {
        if (myclass == p_float[].class) {
            return "Float";
        }
        if (myclass == p_String[].class) {
            return "String";
        }
        return "unknown";
    }

    protected void match(Tokenizer st, int expected) throws Exception {
        int found = st.nextToken();
        if (found != expected) {
            if (found == -3) {
                st.pushBack();
            }
            throw new Exception("\nParsing error.\nExpected: " + this.tokenToString(expected) + "\n" + "Found: " + this.tokenToString(found));
        }
    }

    public boolean MatchType(int token) {
        String name = this.tokens()[arraySize - 1];
        int type = Global.LookupParameterType(name).getValue();
        if (this.values() == null || this.countElem() == 0) {
            this.logger.error("Not Exist Parameter[" + name + "], ExpectedType[" + AbstractKeywordParser.typeToString(type) + "]\n");
            return false;
        }
        Object value = this.values()[arraySize - 1];
        Class<?> myclass = value.getClass();
        if (type == 0) {
            this.logger.error("Undeclared! " + AbstractKeywordParser.paramToString(myclass) + " Parameter[" + name + "]\n");
            return false;
        }
        int apex = Global.LookupParameterValue(name);
        boolean tip = Global.LookupParameterTip(name);
        if (myclass == p_String[].class) {
            if (type == 4) {
                if (((p_String[])value).length == apex) {
                    return true;
                }
                if (tip && ((p_String[])value).length > apex && ((p_String[])value).length % apex == 0) {
                    return true;
                }
            }
        } else {
            if (((p_float[])value).length == apex) {
                return true;
            }
            if (tip && ((p_float[])value).length > apex && ((p_float[])value).length % apex == 0) {
                return true;
            }
        }
        if (name.equals("Pz")) {
            return true;
        }
        this.logger.error(String.valueOf(AbstractKeywordParser.paramToString(myclass)) + " Parameter Type Mismatch[" + name + "], ExpectedType[" + AbstractKeywordParser.typeToString(type) + "]\n");
        return false;
    }

    protected float[] readBounds(Tokenizer st) throws IOException, Exception {
        boolean array = false;
        int token = st.nextToken();
        if (token == 91) {
            array = true;
        } else {
            st.pushBack();
        }
        this.match(st, -2);
        float xMin = (float)st.nval;
        this.match(st, -2);
        float xMax = (float)st.nval;
        this.match(st, -2);
        float yMin = (float)st.nval;
        this.match(st, -2);
        float yMax = (float)st.nval;
        this.match(st, -2);
        float zMin = (float)st.nval;
        this.match(st, -2);
        float zMax = (float)st.nval;
        if (array) {
            this.match(st, 93);
        }
        float[] bounds = new float[]{xMin, xMax, yMin, yMax, zMin, zMax};
        return bounds;
    }

    protected float[][] readMatrix(Tokenizer st) throws Exception {
        this.match(st, 91);
        this.match(st, -2);
        float a = (float)st.nval;
        this.match(st, -2);
        float b = (float)st.nval;
        this.match(st, -2);
        float c = (float)st.nval;
        this.match(st, -2);
        float d = (float)st.nval;
        this.match(st, -2);
        float e = (float)st.nval;
        this.match(st, -2);
        float f = (float)st.nval;
        this.match(st, -2);
        float g = (float)st.nval;
        this.match(st, -2);
        float h = (float)st.nval;
        this.match(st, -2);
        float i = (float)st.nval;
        this.match(st, -2);
        float j = (float)st.nval;
        this.match(st, -2);
        float k = (float)st.nval;
        this.match(st, -2);
        float l = (float)st.nval;
        this.match(st, -2);
        float m = (float)st.nval;
        this.match(st, -2);
        float n = (float)st.nval;
        this.match(st, -2);
        float o = (float)st.nval;
        this.match(st, -2);
        float p = (float)st.nval;
        this.match(st, 93);
        float[][] transform = new float[][]{{a, b, c, d}, {e, f, g, h}, {i, j, k, l}, {m, n, o, p}};
        return transform;
    }

    protected float[] parseColor(Tokenizer st) throws IOException, Exception {
        boolean array = false;
        int token = st.nextToken();
        if (token == 91) {
            array = true;
        } else {
            st.pushBack();
        }
        this.match(st, -2);
        float red = (float)st.nval;
        this.match(st, -2);
        float green = (float)st.nval;
        this.match(st, -2);
        float blue = (float)st.nval;
        if (array) {
            this.match(st, 93);
        }
        float[] color = new float[]{red, green, blue};
        return color;
    }

    protected float[] readFloatArray(Tokenizer st) throws Exception, IOException {
        ArrayList<Float> floats = new ArrayList<Float>();
        this.match(st, 91);
        while (st.nextToken() == -2) {
            floats.add(Float.valueOf((float)st.nval));
        }
        st.pushBack();
        float[] result = new float[floats.size()];
        int i = 0;
        while (i < floats.size()) {
            result[i] = ((Float)floats.get(i)).floatValue();
            ++i;
        }
        this.match(st, 93);
        return result;
    }

    protected void parseArray(Tokenizer st) throws Exception {
        this.match(st, 91);
        this.elemSize = 0;
        int token = 0;
        STLVector<p_float> tmpNum = new STLVector<p_float>(p_float.class);
        STLVector<p_String> tmpStr = new STLVector<p_String>(p_String.class);
        block4: while ((token = st.nextToken()) == -2 || token == 34) {
            switch (token) {
                case -2: {
                    tmpNum.add(new p_float((float)st.nval));
                    ++this.elemSize;
                    break;
                }
                case 34: {
                    if (st.sval.length() == 0) continue block4;
                    tmpStr.add(new p_String(st.sval));
                    ++this.elemSize;
                }
            }
        }
        if (tmpNum.size() > 0) {
            numbers.add(tmpNum.toArray());
            ++arraySize;
        } else {
            numbers.add(tmpStr.toArray());
            ++arraySize;
        }
        st.pushBack();
        this.match(st, 93);
    }

    protected void parseParameterList(Tokenizer st) throws Exception {
        this.clearParameterList();
        int token = 0;
        while ((token = st.nextToken()) == 34 || token != -3 && token != -1) {
            if (st.sval == null) continue;
            strings.add(st.sval);
            token = st.nextToken();
            switch (token) {
                case 91: {
                    st.pushBack();
                    this.parseArray(st);
                    break;
                }
                case -2: {
                    numbers.add(new p_float[]{new p_float((float)st.nval)});
                    ++arraySize;
                    this.elemSize = 1;
                    break;
                }
                case 34: {
                    if (st.sval.length() == 0) break;
                    numbers.add(new p_String[]{new p_String(st.sval)});
                    ++arraySize;
                    this.elemSize = 1;
                    break;
                }
                default: {
                    strings.remove(arraySize);
                    st.pushBack();
                    return;
                }
            }
            if (this.MatchType(token)) continue;
            strings.remove(arraySize - 1);
            numbers.remove(arraySize - 1);
            --arraySize;
        }
        st.pushBack();
    }

    protected int getVarying(String[] name, Object[] values) throws Exception {
        int length = 0;
        int i = 0;
        while (i < this.count()) {
            if (name[i].equals("P")) {
                length = ((p_float[])values[i]).length / 3;
            } else if (name[i].equals("Pw")) {
                length = ((p_float[])values[i]).length / 4;
            }
            ++i;
        }
        if (length < 1) {
            throw new Exception("Expecting P / Pw \n");
        }
        return length;
    }

    protected int[] toInteger() {
        Object[] tmp = this.values();
        int[] res = new int[this.countElem()];
        int index = this.count() - 1;
        int i = 0;
        while (i < this.countElem()) {
            res[i] = (int)((p_float[])tmp[index])[i].value;
            ++i;
        }
        return res;
    }

    protected float[] toFloat() {
        Object[] tmp = this.values();
        float[] res = new float[this.countElem()];
        int index = this.count() - 1;
        int i = 0;
        while (i < this.countElem()) {
            res[i] = ((p_float[])tmp[index])[i].value;
            ++i;
        }
        return res;
    }

    protected String[] toStringArray() {
        Object[] tmp = this.values();
        String[] res = new String[this.countElem()];
        int index = this.count() - 1;
        int i = 0;
        while (i < this.countElem()) {
            res[i] = ((p_String[])tmp[index])[i].value;
            ++i;
        }
        return res;
    }

    public void clearParameterList() {
        numbers.clear();
        strings.clear();
        arraySize = 0;
    }

    public int count() {
        return arraySize;
    }

    public String[] tokens() {
        return strings.toArray();
    }

    public Object[] values() {
        return numbers.toArray();
    }

    public int countElem() {
        return this.elemSize;
    }
}

