/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library.types;

import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;

public strictfp class CqMatrix {
    private static final long serialVersionUID = -1422529258858713988L;
    private static final float PI = (float)Math.PI;
    public float[][] m_aaElement = new float[4][4];
    public boolean m_fIdentity = false;

    public CqMatrix() {
        this.Identity();
    }

    public CqMatrix(float xs, float ys, float zs) {
        this.Identity();
        if (xs == 1.0f && ys == 1.0f && zs == 1.0f) {
            this.m_fIdentity = true;
        } else {
            this.m_aaElement[0][0] = xs;
            this.m_aaElement[1][1] = ys;
            this.m_aaElement[2][2] = zs;
            this.m_aaElement[3][3] = 1.0f;
            this.m_fIdentity = false;
        }
    }

    public CqMatrix(CqVector3D Trans) {
        this.Identity();
        if (Trans.x == 0.0f && Trans.y == 0.0f && Trans.z == 0.0f) {
            this.m_fIdentity = true;
        } else {
            this.m_fIdentity = false;
            this.m_aaElement[3][0] = Trans.x;
            this.m_aaElement[3][1] = Trans.y;
            this.m_aaElement[3][2] = Trans.z;
        }
    }

    public CqMatrix(float Angle, CqVector3D Axis) {
        this.Identity();
        if (Angle != 0.0f && Axis.Magnitude() != 0.0f) {
            this.Rotate(Angle, Axis);
        }
    }

    public CqMatrix(float angle, float dx1, float dy1, float dz1, float dx2, float dy2, float dz2) {
        CqVector3D d1 = new CqVector3D(dx1, dy1, dz1);
        CqVector3D d2 = new CqVector3D(dx2, dy2, dz2);
        d1.Unit();
        d2.Unit();
        float d1d2dot = d1.mul(d2);
        float axisangle = (float)Math.acos(d1d2dot);
        if (angle >= axisangle || angle <= axisangle - (float)Math.PI) {
            this.Identity();
        } else {
            CqVector3D right = new CqVector3D();
            right.assignment(d1.mod(d2));
            right.Unit();
            CqVector3D d1ortho = new CqVector3D();
            d1ortho.assignment(d2.mod(right));
            CqMatrix Rot = new CqMatrix(right.x, d1ortho.x, d2.x, 0.0f, right.y, d1ortho.y, d2.y, 0.0f, right.z, d1ortho.z, d2.z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
            float par = d1d2dot;
            float perp = (float)Math.sqrt(1.0 - (double)(par * par));
            float s = (float)(Math.tan((double)angle + Math.acos(perp)) * (double)perp - (double)par);
            CqMatrix Skw = new CqMatrix(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, s, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
            this.assignment(Rot.Transpose());
            this.assignMul(Skw);
            this.assignMul(Rot);
        }
    }

    public CqMatrix(CqMatrix from) {
        this.assignment(from);
        this.m_fIdentity = from.m_fIdentity;
    }

    public CqMatrix(float r1c1, float r1c2, float r1c3, float r1c4, float r2c1, float r2c2, float r2c3, float r2c4, float r3c1, float r3c2, float r3c3, float r3c4, float r4c1, float r4c2, float r4c3, float r4c4) {
        this.m_aaElement[0][0] = r1c1;
        this.m_aaElement[0][1] = r1c2;
        this.m_aaElement[0][2] = r1c3;
        this.m_aaElement[0][3] = r1c4;
        this.m_aaElement[1][0] = r2c1;
        this.m_aaElement[1][1] = r2c2;
        this.m_aaElement[1][2] = r2c3;
        this.m_aaElement[1][3] = r2c4;
        this.m_aaElement[2][0] = r3c1;
        this.m_aaElement[2][1] = r3c2;
        this.m_aaElement[2][2] = r3c3;
        this.m_aaElement[2][3] = r3c4;
        this.m_aaElement[3][0] = r4c1;
        this.m_aaElement[3][1] = r4c2;
        this.m_aaElement[3][2] = r4c3;
        this.m_aaElement[3][3] = r4c4;
        this.m_fIdentity = false;
    }

    public CqMatrix(float[][] From) {
        this.m_aaElement[0][0] = From[0][0];
        this.m_aaElement[0][1] = From[0][1];
        this.m_aaElement[0][2] = From[0][2];
        this.m_aaElement[0][3] = From[0][3];
        this.m_aaElement[1][0] = From[1][0];
        this.m_aaElement[1][1] = From[1][1];
        this.m_aaElement[1][2] = From[1][2];
        this.m_aaElement[1][3] = From[1][3];
        this.m_aaElement[2][0] = From[2][0];
        this.m_aaElement[2][1] = From[2][1];
        this.m_aaElement[2][2] = From[2][2];
        this.m_aaElement[2][3] = From[2][3];
        this.m_aaElement[3][0] = From[3][0];
        this.m_aaElement[3][1] = From[3][1];
        this.m_aaElement[3][2] = From[3][2];
        this.m_aaElement[3][3] = From[3][3];
    }

    public CqMatrix(float[] From) {
        this.m_aaElement[0][0] = From[0];
        this.m_aaElement[0][1] = From[1];
        this.m_aaElement[0][2] = From[2];
        this.m_aaElement[0][3] = From[3];
        this.m_aaElement[1][0] = From[4];
        this.m_aaElement[1][1] = From[5];
        this.m_aaElement[1][2] = From[6];
        this.m_aaElement[1][3] = From[7];
        this.m_aaElement[2][0] = From[8];
        this.m_aaElement[2][1] = From[9];
        this.m_aaElement[2][2] = From[10];
        this.m_aaElement[2][3] = From[11];
        this.m_aaElement[3][0] = From[12];
        this.m_aaElement[3][1] = From[13];
        this.m_aaElement[3][2] = From[14];
        this.m_aaElement[3][3] = From[15];
        this.m_fIdentity = false;
    }

    public CqMatrix(float f) {
        float f2 = f;
        this.m_aaElement[0][3] = f2;
        this.m_aaElement[0][2] = f2;
        this.m_aaElement[0][1] = f2;
        this.m_aaElement[0][0] = f2;
        float f3 = f;
        this.m_aaElement[1][3] = f3;
        this.m_aaElement[1][2] = f3;
        this.m_aaElement[1][1] = f3;
        this.m_aaElement[1][0] = f3;
        float f4 = f;
        this.m_aaElement[2][3] = f4;
        this.m_aaElement[2][2] = f4;
        this.m_aaElement[2][1] = f4;
        this.m_aaElement[2][0] = f4;
        float f5 = f;
        this.m_aaElement[3][3] = f5;
        this.m_aaElement[3][2] = f5;
        this.m_aaElement[3][1] = f5;
        this.m_aaElement[3][0] = f5;
    }

    public CqMatrix(CqVector4D From) {
        this(new CqVector3D(From.x / From.w, From.y / From.w, From.z / From.w));
    }

    public void Identity() {
        this.m_aaElement[3][2] = 0.0f;
        this.m_aaElement[3][1] = 0.0f;
        this.m_aaElement[3][0] = 0.0f;
        this.m_aaElement[2][3] = 0.0f;
        this.m_aaElement[2][1] = 0.0f;
        this.m_aaElement[2][0] = 0.0f;
        this.m_aaElement[1][3] = 0.0f;
        this.m_aaElement[1][2] = 0.0f;
        this.m_aaElement[1][0] = 0.0f;
        this.m_aaElement[0][3] = 0.0f;
        this.m_aaElement[0][2] = 0.0f;
        this.m_aaElement[0][1] = 0.0f;
        this.m_aaElement[3][3] = 1.0f;
        this.m_aaElement[2][2] = 1.0f;
        this.m_aaElement[1][1] = 1.0f;
        this.m_aaElement[0][0] = 1.0f;
        this.m_fIdentity = true;
    }

    public void SetfIdentity(boolean f) {
        this.m_fIdentity = f;
    }

    public boolean fIdentity() {
        return this.m_fIdentity;
    }

    public void Scale(float S) {
        if (S != 1.0f) {
            this.Scale(S, S, S);
        }
    }

    public void Scale(float xs, float ys, float zs) {
        CqMatrix Scale = new CqMatrix(xs, ys, zs);
        this.PreMultiply(Scale);
    }

    public void Rotate(float Angle, CqVector3D Axis) {
        if (Angle != 0.0f) {
            CqMatrix R = new CqMatrix();
            R.Identity();
            CqVector3D RotAxis = Axis;
            R.m_fIdentity = false;
            RotAxis.Unit();
            float s = (float)Math.sin(Angle);
            float c = (float)Math.cos(Angle);
            float t = 1.0f - c;
            R.m_aaElement[0][0] = t * RotAxis.x * RotAxis.x + c;
            R.m_aaElement[1][1] = t * RotAxis.y * RotAxis.y + c;
            R.m_aaElement[2][2] = t * RotAxis.z * RotAxis.z + c;
            float txy = t * RotAxis.x * RotAxis.y;
            float sz = s * RotAxis.z;
            R.m_aaElement[0][1] = txy + sz;
            R.m_aaElement[1][0] = txy - sz;
            float txz = t * RotAxis.x * RotAxis.z;
            float sy = s * RotAxis.y;
            R.m_aaElement[0][2] = txz - sy;
            R.m_aaElement[2][0] = txz + sy;
            float tyz = t * RotAxis.y * RotAxis.z;
            float sx = s * RotAxis.x;
            R.m_aaElement[1][2] = tyz + sx;
            R.m_aaElement[2][1] = tyz - sx;
            this.PreMultiply(R);
        }
    }

    public void Translate(CqVector3D Trans) {
        CqMatrix matTrans = new CqMatrix(Trans);
        this.PreMultiply(matTrans);
    }

    public void Translate(float xt, float yt, float zt) {
        if (xt != 0.0f || yt != 0.0f || zt != 0.0f) {
            this.Translate(new CqVector3D(xt, yt, zt));
        }
    }

    public void ShearX(float yh, float zh) {
        CqMatrix Shear = new CqMatrix();
        Shear.m_fIdentity = false;
        Shear.m_aaElement[0][1] = yh;
        Shear.m_aaElement[0][2] = zh;
        this.PreMultiply(Shear);
    }

    public void ShearY(float xh, float zh) {
        CqMatrix Shear = new CqMatrix();
        Shear.m_fIdentity = false;
        Shear.m_aaElement[1][0] = xh;
        Shear.m_aaElement[1][2] = zh;
        this.PreMultiply(Shear);
    }

    public void ShearZ(float xh, float yh) {
        CqMatrix Shear = new CqMatrix();
        Shear.m_fIdentity = false;
        Shear.m_aaElement[2][0] = xh;
        Shear.m_aaElement[2][1] = yh;
        this.PreMultiply(Shear);
    }

    public void Skew(float angle, float dx1, float dy1, float dz1, float dx2, float dy2, float dz2) {
        CqMatrix Skew = new CqMatrix(angle, dx1, dy1, dz1, dx2, dy2, dz2);
        this.PreMultiply(Skew);
    }

    public void Normalise() {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                float[] fArray = this.m_aaElement[i];
                int n = j++;
                fArray[n] = fArray[n] / this.m_aaElement[3][3];
            }
            ++i;
        }
    }

    public CqMatrix PreMultiply(CqMatrix From) {
        if (this.m_fIdentity) {
            this.assignment(From);
            return this;
        }
        if (From.m_fIdentity) {
            return this;
        }
        CqMatrix A = new CqMatrix(this);
        this.m_aaElement[0][0] = A.m_aaElement[0][0] * From.m_aaElement[0][0] + A.m_aaElement[0][1] * From.m_aaElement[1][0] + A.m_aaElement[0][2] * From.m_aaElement[2][0] + A.m_aaElement[0][3] * From.m_aaElement[3][0];
        this.m_aaElement[0][1] = A.m_aaElement[0][0] * From.m_aaElement[0][1] + A.m_aaElement[0][1] * From.m_aaElement[1][1] + A.m_aaElement[0][2] * From.m_aaElement[2][1] + A.m_aaElement[0][3] * From.m_aaElement[3][1];
        this.m_aaElement[0][2] = A.m_aaElement[0][0] * From.m_aaElement[0][2] + A.m_aaElement[0][1] * From.m_aaElement[1][2] + A.m_aaElement[0][2] * From.m_aaElement[2][2] + A.m_aaElement[0][3] * From.m_aaElement[3][2];
        this.m_aaElement[0][3] = A.m_aaElement[0][0] * From.m_aaElement[0][3] + A.m_aaElement[0][1] * From.m_aaElement[1][3] + A.m_aaElement[0][2] * From.m_aaElement[2][3] + A.m_aaElement[0][3] * From.m_aaElement[3][3];
        this.m_aaElement[1][0] = A.m_aaElement[1][0] * From.m_aaElement[0][0] + A.m_aaElement[1][1] * From.m_aaElement[1][0] + A.m_aaElement[1][2] * From.m_aaElement[2][0] + A.m_aaElement[1][3] * From.m_aaElement[3][0];
        this.m_aaElement[1][1] = A.m_aaElement[1][0] * From.m_aaElement[0][1] + A.m_aaElement[1][1] * From.m_aaElement[1][1] + A.m_aaElement[1][2] * From.m_aaElement[2][1] + A.m_aaElement[1][3] * From.m_aaElement[3][1];
        this.m_aaElement[1][2] = A.m_aaElement[1][0] * From.m_aaElement[0][2] + A.m_aaElement[1][1] * From.m_aaElement[1][2] + A.m_aaElement[1][2] * From.m_aaElement[2][2] + A.m_aaElement[1][3] * From.m_aaElement[3][2];
        this.m_aaElement[1][3] = A.m_aaElement[1][0] * From.m_aaElement[0][3] + A.m_aaElement[1][1] * From.m_aaElement[1][3] + A.m_aaElement[1][2] * From.m_aaElement[2][3] + A.m_aaElement[1][3] * From.m_aaElement[3][3];
        this.m_aaElement[2][0] = A.m_aaElement[2][0] * From.m_aaElement[0][0] + A.m_aaElement[2][1] * From.m_aaElement[1][0] + A.m_aaElement[2][2] * From.m_aaElement[2][0] + A.m_aaElement[2][3] * From.m_aaElement[3][0];
        this.m_aaElement[2][1] = A.m_aaElement[2][0] * From.m_aaElement[0][1] + A.m_aaElement[2][1] * From.m_aaElement[1][1] + A.m_aaElement[2][2] * From.m_aaElement[2][1] + A.m_aaElement[2][3] * From.m_aaElement[3][1];
        this.m_aaElement[2][2] = A.m_aaElement[2][0] * From.m_aaElement[0][2] + A.m_aaElement[2][1] * From.m_aaElement[1][2] + A.m_aaElement[2][2] * From.m_aaElement[2][2] + A.m_aaElement[2][3] * From.m_aaElement[3][2];
        this.m_aaElement[2][3] = A.m_aaElement[2][0] * From.m_aaElement[0][3] + A.m_aaElement[2][1] * From.m_aaElement[1][3] + A.m_aaElement[2][2] * From.m_aaElement[2][3] + A.m_aaElement[2][3] * From.m_aaElement[3][3];
        this.m_aaElement[3][0] = A.m_aaElement[3][0] * From.m_aaElement[0][0] + A.m_aaElement[3][1] * From.m_aaElement[1][0] + A.m_aaElement[3][2] * From.m_aaElement[2][0] + A.m_aaElement[3][3] * From.m_aaElement[3][0];
        this.m_aaElement[3][1] = A.m_aaElement[3][0] * From.m_aaElement[0][1] + A.m_aaElement[3][1] * From.m_aaElement[1][1] + A.m_aaElement[3][2] * From.m_aaElement[2][1] + A.m_aaElement[3][3] * From.m_aaElement[3][1];
        this.m_aaElement[3][2] = A.m_aaElement[3][0] * From.m_aaElement[0][2] + A.m_aaElement[3][1] * From.m_aaElement[1][2] + A.m_aaElement[3][2] * From.m_aaElement[2][2] + A.m_aaElement[3][3] * From.m_aaElement[3][2];
        this.m_aaElement[3][3] = A.m_aaElement[3][0] * From.m_aaElement[0][3] + A.m_aaElement[3][1] * From.m_aaElement[1][3] + A.m_aaElement[3][2] * From.m_aaElement[2][3] + A.m_aaElement[3][3] * From.m_aaElement[3][3];
        this.m_fIdentity = false;
        return this;
    }

    public CqVector4D PreMultiply(CqVector4D Vector2) {
        if (this.m_fIdentity) {
            return Vector2;
        }
        CqVector4D Result = new CqVector4D();
        Result.x(this.m_aaElement[0][0] * Vector2.x + this.m_aaElement[0][1] * Vector2.y + this.m_aaElement[0][2] * Vector2.z + this.m_aaElement[0][3] * Vector2.w);
        Result.y(this.m_aaElement[1][0] * Vector2.x + this.m_aaElement[1][1] * Vector2.y + this.m_aaElement[1][2] * Vector2.z + this.m_aaElement[1][3] * Vector2.w);
        Result.z(this.m_aaElement[2][0] * Vector2.x + this.m_aaElement[2][1] * Vector2.y + this.m_aaElement[2][2] * Vector2.z + this.m_aaElement[2][3] * Vector2.w);
        Result.h(this.m_aaElement[3][0] * Vector2.x + this.m_aaElement[3][1] * Vector2.y + this.m_aaElement[3][2] * Vector2.z + this.m_aaElement[3][3] * Vector2.w);
        return Result;
    }

    public CqMatrix Inverse() {
        if (this.Determinant() == 0.0f) {
            return this;
        }
        CqMatrix b = new CqMatrix();
        CqMatrix a = new CqMatrix(this);
        if (this.m_fIdentity) {
            b.assignment(this);
        } else {
            b.Identity();
            b.m_fIdentity = false;
            int j = 0;
            while (j < 4) {
                int i1 = j;
                int i = j + 1;
                while (i < 4) {
                    if (Math.abs(a.m_aaElement[i][j]) > Math.abs(a.m_aaElement[i1][j])) {
                        i1 = i;
                    }
                    ++i;
                }
                if (i1 != j) {
                    float temp = a.m_aaElement[i1][0];
                    a.m_aaElement[i1][0] = a.m_aaElement[j][0];
                    a.m_aaElement[j][0] = temp;
                    temp = a.m_aaElement[i1][1];
                    a.m_aaElement[i1][1] = a.m_aaElement[j][1];
                    a.m_aaElement[j][1] = temp;
                    temp = a.m_aaElement[i1][2];
                    a.m_aaElement[i1][2] = a.m_aaElement[j][2];
                    a.m_aaElement[j][2] = temp;
                    temp = a.m_aaElement[i1][3];
                    a.m_aaElement[i1][3] = a.m_aaElement[j][3];
                    a.m_aaElement[j][3] = temp;
                    temp = b.m_aaElement[i1][0];
                    b.m_aaElement[i1][0] = b.m_aaElement[j][0];
                    b.m_aaElement[j][0] = temp;
                    temp = b.m_aaElement[i1][1];
                    b.m_aaElement[i1][1] = b.m_aaElement[j][1];
                    b.m_aaElement[j][1] = temp;
                    temp = b.m_aaElement[i1][2];
                    b.m_aaElement[i1][2] = b.m_aaElement[j][2];
                    b.m_aaElement[j][2] = temp;
                    temp = b.m_aaElement[i1][3];
                    b.m_aaElement[i1][3] = b.m_aaElement[j][3];
                    b.m_aaElement[j][3] = temp;
                }
                float cfr_ignored_0 = a.m_aaElement[j][j];
                float scale = 1.0f / a.m_aaElement[j][j];
                float[] fArray = b.m_aaElement[j];
                fArray[0] = fArray[0] * scale;
                float[] fArray2 = b.m_aaElement[j];
                fArray2[1] = fArray2[1] * scale;
                float[] fArray3 = b.m_aaElement[j];
                fArray3[2] = fArray3[2] * scale;
                float[] fArray4 = b.m_aaElement[j];
                fArray4[3] = fArray4[3] * scale;
                i1 = j + 1;
                while (i1 < 4) {
                    float[] fArray5 = a.m_aaElement[j];
                    int n = i1++;
                    fArray5[n] = fArray5[n] * scale;
                }
                a.m_aaElement[j][j] = 1.0f;
                i = 0;
                while (i < 4) {
                    if (i != j) {
                        scale = a.m_aaElement[i][j];
                        float[] fArray6 = b.m_aaElement[i];
                        fArray6[0] = fArray6[0] - scale * b.m_aaElement[j][0];
                        float[] fArray7 = b.m_aaElement[i];
                        fArray7[1] = fArray7[1] - scale * b.m_aaElement[j][1];
                        float[] fArray8 = b.m_aaElement[i];
                        fArray8[2] = fArray8[2] - scale * b.m_aaElement[j][2];
                        float[] fArray9 = b.m_aaElement[i];
                        fArray9[3] = fArray9[3] - scale * b.m_aaElement[j][3];
                        i1 = j + 1;
                        while (i1 < 4) {
                            float[] fArray10 = a.m_aaElement[i];
                            int n = i1;
                            fArray10[n] = fArray10[n] - scale * a.m_aaElement[j][i1];
                            ++i1;
                        }
                        a.m_aaElement[i][j] = 0.0f;
                    }
                    ++i;
                }
                ++j;
            }
        }
        return b;
    }

    public CqMatrix Transpose() {
        CqMatrix Temp;
        if (this.m_fIdentity) {
            Temp = new CqMatrix(this);
        } else {
            Temp = new CqMatrix(this);
            Temp.m_aaElement[0][0] = this.m_aaElement[0][0];
            Temp.m_aaElement[0][1] = this.m_aaElement[1][0];
            Temp.m_aaElement[0][2] = this.m_aaElement[2][0];
            Temp.m_aaElement[0][3] = this.m_aaElement[3][0];
            Temp.m_aaElement[1][0] = this.m_aaElement[0][1];
            Temp.m_aaElement[1][1] = this.m_aaElement[1][1];
            Temp.m_aaElement[1][2] = this.m_aaElement[2][1];
            Temp.m_aaElement[1][3] = this.m_aaElement[3][1];
            Temp.m_aaElement[2][0] = this.m_aaElement[0][2];
            Temp.m_aaElement[2][1] = this.m_aaElement[1][2];
            Temp.m_aaElement[2][2] = this.m_aaElement[2][2];
            Temp.m_aaElement[2][3] = this.m_aaElement[3][2];
            Temp.m_aaElement[3][0] = this.m_aaElement[0][3];
            Temp.m_aaElement[3][1] = this.m_aaElement[1][3];
            Temp.m_aaElement[3][2] = this.m_aaElement[2][3];
            Temp.m_aaElement[3][3] = this.m_aaElement[3][3];
            Temp.m_fIdentity = false;
        }
        return Temp;
    }

    public float Determinant() {
        float a1 = this.m_aaElement[0][0];
        float b1 = this.m_aaElement[0][1];
        float c1 = this.m_aaElement[0][2];
        float d1 = this.m_aaElement[0][3];
        float a2 = this.m_aaElement[1][0];
        float b2 = this.m_aaElement[1][1];
        float c2 = this.m_aaElement[1][2];
        float d2 = this.m_aaElement[1][3];
        float a3 = this.m_aaElement[2][0];
        float b3 = this.m_aaElement[2][1];
        float c3 = this.m_aaElement[2][2];
        float d3 = this.m_aaElement[2][3];
        float a4 = this.m_aaElement[3][0];
        float b4 = this.m_aaElement[3][1];
        float c4 = this.m_aaElement[3][2];
        float d4 = this.m_aaElement[3][3];
        return a1 * CqMatrix.det3x3(b2, b3, b4, c2, c3, c4, d2, d3, d4) - b1 * CqMatrix.det3x3(a2, a3, a4, c2, c3, c4, d2, d3, d4) + c1 * CqMatrix.det3x3(a2, a3, a4, b2, b3, b4, d2, d3, d4) - d1 * CqMatrix.det3x3(a2, a3, a4, b2, b3, b4, c2, c3, c4);
    }

    public CqMatrix multiply(CqMatrix From) {
        CqMatrix Temp = new CqMatrix(this);
        Temp.assignMul(From);
        return Temp;
    }

    public CqMatrix assignMul(CqMatrix From) {
        if (this.m_fIdentity) {
            this.assignment(From);
            return this;
        }
        if (From.m_fIdentity) {
            return this;
        }
        CqMatrix A = new CqMatrix(this);
        this.m_aaElement[0][0] = From.m_aaElement[0][0] * A.m_aaElement[0][0] + From.m_aaElement[0][1] * A.m_aaElement[1][0] + From.m_aaElement[0][2] * A.m_aaElement[2][0] + From.m_aaElement[0][3] * A.m_aaElement[3][0];
        this.m_aaElement[0][1] = From.m_aaElement[0][0] * A.m_aaElement[0][1] + From.m_aaElement[0][1] * A.m_aaElement[1][1] + From.m_aaElement[0][2] * A.m_aaElement[2][1] + From.m_aaElement[0][3] * A.m_aaElement[3][1];
        this.m_aaElement[0][2] = From.m_aaElement[0][0] * A.m_aaElement[0][2] + From.m_aaElement[0][1] * A.m_aaElement[1][2] + From.m_aaElement[0][2] * A.m_aaElement[2][2] + From.m_aaElement[0][3] * A.m_aaElement[3][2];
        this.m_aaElement[0][3] = From.m_aaElement[0][0] * A.m_aaElement[0][3] + From.m_aaElement[0][1] * A.m_aaElement[1][3] + From.m_aaElement[0][2] * A.m_aaElement[2][3] + From.m_aaElement[0][3] * A.m_aaElement[3][3];
        this.m_aaElement[1][0] = From.m_aaElement[1][0] * A.m_aaElement[0][0] + From.m_aaElement[1][1] * A.m_aaElement[1][0] + From.m_aaElement[1][2] * A.m_aaElement[2][0] + From.m_aaElement[1][3] * A.m_aaElement[3][0];
        this.m_aaElement[1][1] = From.m_aaElement[1][0] * A.m_aaElement[0][1] + From.m_aaElement[1][1] * A.m_aaElement[1][1] + From.m_aaElement[1][2] * A.m_aaElement[2][1] + From.m_aaElement[1][3] * A.m_aaElement[3][1];
        this.m_aaElement[1][2] = From.m_aaElement[1][0] * A.m_aaElement[0][2] + From.m_aaElement[1][1] * A.m_aaElement[1][2] + From.m_aaElement[1][2] * A.m_aaElement[2][2] + From.m_aaElement[1][3] * A.m_aaElement[3][2];
        this.m_aaElement[1][3] = From.m_aaElement[1][0] * A.m_aaElement[0][3] + From.m_aaElement[1][1] * A.m_aaElement[1][3] + From.m_aaElement[1][2] * A.m_aaElement[2][3] + From.m_aaElement[1][3] * A.m_aaElement[3][3];
        this.m_aaElement[2][0] = From.m_aaElement[2][0] * A.m_aaElement[0][0] + From.m_aaElement[2][1] * A.m_aaElement[1][0] + From.m_aaElement[2][2] * A.m_aaElement[2][0] + From.m_aaElement[2][3] * A.m_aaElement[3][0];
        this.m_aaElement[2][1] = From.m_aaElement[2][0] * A.m_aaElement[0][1] + From.m_aaElement[2][1] * A.m_aaElement[1][1] + From.m_aaElement[2][2] * A.m_aaElement[2][1] + From.m_aaElement[2][3] * A.m_aaElement[3][1];
        this.m_aaElement[2][2] = From.m_aaElement[2][0] * A.m_aaElement[0][2] + From.m_aaElement[2][1] * A.m_aaElement[1][2] + From.m_aaElement[2][2] * A.m_aaElement[2][2] + From.m_aaElement[2][3] * A.m_aaElement[3][2];
        this.m_aaElement[2][3] = From.m_aaElement[2][0] * A.m_aaElement[0][3] + From.m_aaElement[2][1] * A.m_aaElement[1][3] + From.m_aaElement[2][2] * A.m_aaElement[2][3] + From.m_aaElement[2][3] * A.m_aaElement[3][3];
        this.m_aaElement[3][0] = From.m_aaElement[3][0] * A.m_aaElement[0][0] + From.m_aaElement[3][1] * A.m_aaElement[1][0] + From.m_aaElement[3][2] * A.m_aaElement[2][0] + From.m_aaElement[3][3] * A.m_aaElement[3][0];
        this.m_aaElement[3][1] = From.m_aaElement[3][0] * A.m_aaElement[0][1] + From.m_aaElement[3][1] * A.m_aaElement[1][1] + From.m_aaElement[3][2] * A.m_aaElement[2][1] + From.m_aaElement[3][3] * A.m_aaElement[3][1];
        this.m_aaElement[3][2] = From.m_aaElement[3][0] * A.m_aaElement[0][2] + From.m_aaElement[3][1] * A.m_aaElement[1][2] + From.m_aaElement[3][2] * A.m_aaElement[2][2] + From.m_aaElement[3][3] * A.m_aaElement[3][2];
        this.m_aaElement[3][3] = From.m_aaElement[3][0] * A.m_aaElement[0][3] + From.m_aaElement[3][1] * A.m_aaElement[1][3] + From.m_aaElement[3][2] * A.m_aaElement[2][3] + From.m_aaElement[3][3] * A.m_aaElement[3][3];
        this.m_fIdentity = false;
        return this;
    }

    public CqMatrix multiply(float S) {
        CqMatrix Temp = new CqMatrix(this);
        Temp.assignMul(S);
        return Temp;
    }

    public CqMatrix assignMul(float S) {
        CqMatrix ScaleMatrix = new CqMatrix(S, S, S);
        this.PreMultiply(ScaleMatrix);
        return this;
    }

    public CqVector4D multiply(CqVector4D Vector2) {
        if (this.m_fIdentity) {
            return Vector2;
        }
        CqVector4D Result = new CqVector4D();
        Result.x = this.m_aaElement[0][0] * Vector2.x + this.m_aaElement[1][0] * Vector2.y + this.m_aaElement[2][0] * Vector2.z + this.m_aaElement[3][0] * Vector2.w;
        Result.y = this.m_aaElement[0][1] * Vector2.x + this.m_aaElement[1][1] * Vector2.y + this.m_aaElement[2][1] * Vector2.z + this.m_aaElement[3][1] * Vector2.w;
        Result.z = this.m_aaElement[0][2] * Vector2.x + this.m_aaElement[1][2] * Vector2.y + this.m_aaElement[2][2] * Vector2.z + this.m_aaElement[3][2] * Vector2.w;
        Result.w = this.m_aaElement[0][3] * Vector2.x + this.m_aaElement[1][3] * Vector2.y + this.m_aaElement[2][3] * Vector2.z + this.m_aaElement[3][3] * Vector2.w;
        return Result;
    }

    public CqVector3D multiply(CqVector3D Vector2) {
        if (this.m_fIdentity) {
            return Vector2;
        }
        CqVector3D Result = new CqVector3D();
        float h = this.m_aaElement[0][3] * Vector2.x + this.m_aaElement[1][3] * Vector2.y + this.m_aaElement[2][3] * Vector2.z + this.m_aaElement[3][3];
        Result.x = (this.m_aaElement[0][0] * Vector2.x + this.m_aaElement[1][0] * Vector2.y + this.m_aaElement[2][0] * Vector2.z + this.m_aaElement[3][0]) / h;
        Result.y = (this.m_aaElement[0][1] * Vector2.x + this.m_aaElement[1][1] * Vector2.y + this.m_aaElement[2][1] * Vector2.z + this.m_aaElement[3][1]) / h;
        Result.z = (this.m_aaElement[0][2] * Vector2.x + this.m_aaElement[1][2] * Vector2.y + this.m_aaElement[2][2] * Vector2.z + this.m_aaElement[3][2]) / h;
        return Result;
    }

    public CqMatrix add(CqVector4D Vector2) {
        CqMatrix Temp = new CqMatrix(this);
        Temp.assignAdd(Vector2);
        return Temp;
    }

    public CqMatrix assignAdd(CqVector4D Vector2) {
        CqMatrix Trans = new CqMatrix(Vector2);
        this.PreMultiply(Trans);
        return this;
    }

    public CqMatrix sub(CqVector4D Vector2) {
        CqMatrix Temp = new CqMatrix(this);
        Temp.assignSub(Vector2);
        return Temp;
    }

    public CqMatrix assignSub(CqVector4D Vector2) {
        CqVector4D Temp = new CqVector4D(Vector2);
        Temp.x = -Temp.x;
        Temp.y = -Temp.y;
        Temp.z = -Temp.z;
        CqMatrix Trans = new CqMatrix(Temp);
        this.PreMultiply(Trans);
        return this;
    }

    public CqMatrix add(CqMatrix From) {
        CqMatrix Temp = new CqMatrix(this);
        Temp.assignAdd(From);
        return Temp;
    }

    public CqMatrix assignAdd(CqMatrix From) {
        float[] fArray = this.m_aaElement[0];
        fArray[0] = fArray[0] + From.m_aaElement[0][0];
        float[] fArray2 = this.m_aaElement[1];
        fArray2[0] = fArray2[0] + From.m_aaElement[1][0];
        float[] fArray3 = this.m_aaElement[2];
        fArray3[0] = fArray3[0] + From.m_aaElement[2][0];
        float[] fArray4 = this.m_aaElement[3];
        fArray4[0] = fArray4[0] + From.m_aaElement[3][0];
        float[] fArray5 = this.m_aaElement[0];
        fArray5[1] = fArray5[1] + From.m_aaElement[0][1];
        float[] fArray6 = this.m_aaElement[1];
        fArray6[1] = fArray6[1] + From.m_aaElement[1][1];
        float[] fArray7 = this.m_aaElement[2];
        fArray7[1] = fArray7[1] + From.m_aaElement[2][1];
        float[] fArray8 = this.m_aaElement[3];
        fArray8[1] = fArray8[1] + From.m_aaElement[3][1];
        float[] fArray9 = this.m_aaElement[0];
        fArray9[2] = fArray9[2] + From.m_aaElement[0][2];
        float[] fArray10 = this.m_aaElement[1];
        fArray10[2] = fArray10[2] + From.m_aaElement[1][2];
        float[] fArray11 = this.m_aaElement[2];
        fArray11[2] = fArray11[2] + From.m_aaElement[2][2];
        float[] fArray12 = this.m_aaElement[3];
        fArray12[2] = fArray12[2] + From.m_aaElement[3][2];
        float[] fArray13 = this.m_aaElement[0];
        fArray13[3] = fArray13[3] + From.m_aaElement[0][3];
        float[] fArray14 = this.m_aaElement[1];
        fArray14[3] = fArray14[3] + From.m_aaElement[1][3];
        float[] fArray15 = this.m_aaElement[2];
        fArray15[3] = fArray15[3] + From.m_aaElement[2][3];
        float[] fArray16 = this.m_aaElement[3];
        fArray16[3] = fArray16[3] + From.m_aaElement[3][3];
        this.m_fIdentity = false;
        return this;
    }

    public CqMatrix sub(CqMatrix From) {
        CqMatrix Temp = new CqMatrix(this);
        Temp.assignSub(From);
        return Temp;
    }

    public CqMatrix assignSub(CqMatrix From) {
        float[] fArray = this.m_aaElement[0];
        fArray[0] = fArray[0] - From.m_aaElement[0][0];
        float[] fArray2 = this.m_aaElement[1];
        fArray2[0] = fArray2[0] - From.m_aaElement[1][0];
        float[] fArray3 = this.m_aaElement[2];
        fArray3[0] = fArray3[0] - From.m_aaElement[2][0];
        float[] fArray4 = this.m_aaElement[3];
        fArray4[0] = fArray4[0] - From.m_aaElement[3][0];
        float[] fArray5 = this.m_aaElement[0];
        fArray5[1] = fArray5[1] - From.m_aaElement[0][1];
        float[] fArray6 = this.m_aaElement[1];
        fArray6[1] = fArray6[1] - From.m_aaElement[1][1];
        float[] fArray7 = this.m_aaElement[2];
        fArray7[1] = fArray7[1] - From.m_aaElement[2][1];
        float[] fArray8 = this.m_aaElement[3];
        fArray8[1] = fArray8[1] - From.m_aaElement[3][1];
        float[] fArray9 = this.m_aaElement[0];
        fArray9[2] = fArray9[2] - From.m_aaElement[0][2];
        float[] fArray10 = this.m_aaElement[1];
        fArray10[2] = fArray10[2] - From.m_aaElement[1][2];
        float[] fArray11 = this.m_aaElement[2];
        fArray11[2] = fArray11[2] - From.m_aaElement[2][2];
        float[] fArray12 = this.m_aaElement[3];
        fArray12[2] = fArray12[2] - From.m_aaElement[3][2];
        float[] fArray13 = this.m_aaElement[0];
        fArray13[3] = fArray13[3] - From.m_aaElement[0][3];
        float[] fArray14 = this.m_aaElement[1];
        fArray14[3] = fArray14[3] - From.m_aaElement[1][3];
        float[] fArray15 = this.m_aaElement[2];
        fArray15[3] = fArray15[3] - From.m_aaElement[2][3];
        float[] fArray16 = this.m_aaElement[3];
        fArray16[3] = fArray16[3] - From.m_aaElement[3][3];
        this.m_fIdentity = false;
        return this;
    }

    public CqMatrix assignment(CqMatrix From) {
        this.m_aaElement[0][0] = From.m_aaElement[0][0];
        this.m_aaElement[1][0] = From.m_aaElement[1][0];
        this.m_aaElement[2][0] = From.m_aaElement[2][0];
        this.m_aaElement[3][0] = From.m_aaElement[3][0];
        this.m_aaElement[0][1] = From.m_aaElement[0][1];
        this.m_aaElement[1][1] = From.m_aaElement[1][1];
        this.m_aaElement[2][1] = From.m_aaElement[2][1];
        this.m_aaElement[3][1] = From.m_aaElement[3][1];
        this.m_aaElement[0][2] = From.m_aaElement[0][2];
        this.m_aaElement[1][2] = From.m_aaElement[1][2];
        this.m_aaElement[2][2] = From.m_aaElement[2][2];
        this.m_aaElement[3][2] = From.m_aaElement[3][2];
        this.m_aaElement[0][3] = From.m_aaElement[0][3];
        this.m_aaElement[1][3] = From.m_aaElement[1][3];
        this.m_aaElement[2][3] = From.m_aaElement[2][3];
        this.m_aaElement[3][3] = From.m_aaElement[3][3];
        this.m_fIdentity = From.m_fIdentity;
        return this;
    }

    public CqMatrix assignment(float[][] From) {
        this.m_aaElement[0][0] = From[0][0];
        this.m_aaElement[1][0] = From[1][0];
        this.m_aaElement[2][0] = From[2][0];
        this.m_aaElement[3][0] = From[3][0];
        this.m_aaElement[0][1] = From[0][1];
        this.m_aaElement[1][1] = From[1][1];
        this.m_aaElement[2][1] = From[2][1];
        this.m_aaElement[3][1] = From[3][1];
        this.m_aaElement[0][2] = From[0][2];
        this.m_aaElement[1][2] = From[1][2];
        this.m_aaElement[2][2] = From[2][2];
        this.m_aaElement[3][2] = From[3][2];
        this.m_aaElement[0][3] = From[0][3];
        this.m_aaElement[1][3] = From[1][3];
        this.m_aaElement[2][3] = From[2][3];
        this.m_aaElement[3][3] = From[3][3];
        this.m_fIdentity = false;
        return this;
    }

    public CqMatrix assignment(float[] From) {
        this.m_aaElement[0][0] = From[0];
        this.m_aaElement[0][1] = From[1];
        this.m_aaElement[0][2] = From[2];
        this.m_aaElement[0][3] = From[3];
        this.m_aaElement[1][0] = From[4];
        this.m_aaElement[1][1] = From[5];
        this.m_aaElement[1][2] = From[6];
        this.m_aaElement[1][3] = From[7];
        this.m_aaElement[2][0] = From[8];
        this.m_aaElement[2][1] = From[9];
        this.m_aaElement[2][2] = From[10];
        this.m_aaElement[2][3] = From[11];
        this.m_aaElement[3][0] = From[12];
        this.m_aaElement[3][1] = From[13];
        this.m_aaElement[3][2] = From[14];
        this.m_aaElement[3][3] = From[15];
        this.m_fIdentity = false;
        return this;
    }

    public CqMatrix mulInv(float S) {
        CqMatrix Temp = new CqMatrix(this);
        float[] fArray = Temp.m_aaElement[0];
        fArray[0] = fArray[0] * S;
        float[] fArray2 = Temp.m_aaElement[1];
        fArray2[0] = fArray2[0] * S;
        float[] fArray3 = Temp.m_aaElement[2];
        fArray3[0] = fArray3[0] * S;
        float[] fArray4 = Temp.m_aaElement[3];
        fArray4[0] = fArray4[0] * S;
        float[] fArray5 = Temp.m_aaElement[0];
        fArray5[1] = fArray5[1] * S;
        float[] fArray6 = Temp.m_aaElement[1];
        fArray6[1] = fArray6[1] * S;
        float[] fArray7 = Temp.m_aaElement[2];
        fArray7[1] = fArray7[1] * S;
        float[] fArray8 = Temp.m_aaElement[3];
        fArray8[1] = fArray8[1] * S;
        float[] fArray9 = Temp.m_aaElement[0];
        fArray9[2] = fArray9[2] * S;
        float[] fArray10 = Temp.m_aaElement[1];
        fArray10[2] = fArray10[2] * S;
        float[] fArray11 = Temp.m_aaElement[2];
        fArray11[2] = fArray11[2] * S;
        float[] fArray12 = Temp.m_aaElement[3];
        fArray12[2] = fArray12[2] * S;
        float[] fArray13 = Temp.m_aaElement[0];
        fArray13[3] = fArray13[3] * S;
        float[] fArray14 = Temp.m_aaElement[1];
        fArray14[3] = fArray14[3] * S;
        float[] fArray15 = Temp.m_aaElement[2];
        fArray15[3] = fArray15[3] * S;
        float[] fArray16 = Temp.m_aaElement[3];
        fArray16[3] = fArray16[3] * S;
        return Temp;
    }

    public boolean equals(CqMatrix mtx) {
        if (this.m_aaElement[0][0] != mtx.m_aaElement[0][0]) {
            return false;
        }
        if (this.m_aaElement[0][1] != mtx.m_aaElement[0][1]) {
            return false;
        }
        if (this.m_aaElement[0][2] != mtx.m_aaElement[0][2]) {
            return false;
        }
        if (this.m_aaElement[0][3] != mtx.m_aaElement[0][3]) {
            return false;
        }
        if (this.m_aaElement[1][0] != mtx.m_aaElement[1][0]) {
            return false;
        }
        if (this.m_aaElement[1][1] != mtx.m_aaElement[1][1]) {
            return false;
        }
        if (this.m_aaElement[1][2] != mtx.m_aaElement[1][2]) {
            return false;
        }
        if (this.m_aaElement[1][3] != mtx.m_aaElement[1][3]) {
            return false;
        }
        if (this.m_aaElement[2][0] != mtx.m_aaElement[2][0]) {
            return false;
        }
        if (this.m_aaElement[2][1] != mtx.m_aaElement[2][1]) {
            return false;
        }
        if (this.m_aaElement[2][2] != mtx.m_aaElement[2][2]) {
            return false;
        }
        if (this.m_aaElement[2][3] != mtx.m_aaElement[2][3]) {
            return false;
        }
        if (this.m_aaElement[3][0] != mtx.m_aaElement[3][0]) {
            return false;
        }
        if (this.m_aaElement[3][1] != mtx.m_aaElement[3][1]) {
            return false;
        }
        if (this.m_aaElement[3][2] != mtx.m_aaElement[3][2]) {
            return false;
        }
        return this.m_aaElement[3][3] == mtx.m_aaElement[3][3];
    }

    public static float det2x2(float a, float b, float c, float d) {
        return a * d - b * c;
    }

    public static float det3x3(float a1, float a2, float a3, float b1, float b2, float b3, float c1, float c2, float c3) {
        return a1 * CqMatrix.det2x2(b2, b3, c2, c3) - b1 * CqMatrix.det2x2(a2, a3, c2, c3) + c1 * CqMatrix.det2x2(a2, a3, b2, b3);
    }
}

