/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.library.CqMotionSpec;
import net.cellcomputing.himawari.library.IqTransform;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.SqTransformation;
import net.cellcomputing.himawari.library.types.CqMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqTransform
extends CqMotionSpec<SqTransformation>
implements IqTransform {
    private boolean m_IsMoving = true;
    private CqMatrix m_StaticMatrix = new CqMatrix();
    private boolean m_Handedness = true;
    private static CqMatrix matInt = new CqMatrix();

    public CqTransform() {
        super(new SqTransformation());
        this.m_IsMoving = false;
    }

    public CqTransform(CqTransform From) {
        super(From);
        this.m_IsMoving = From.m_IsMoving;
        this.m_StaticMatrix.assignment(From.m_StaticMatrix);
        this.m_Handedness = From.m_Handedness;
        this.InitialiseDefaultObject(From);
    }

    public CqTransform(CqTransform From, float time, CqMatrix matTrans, Set set) {
        super(From);
        this.m_IsMoving = From.m_IsMoving;
        this.m_StaticMatrix.assignment(From.m_StaticMatrix);
        this.m_Handedness = From.m_Handedness;
        this.SetTransform(time, matTrans);
    }

    public CqTransform(CqTransform From, float time, CqMatrix matTrans, ConcatCurrent concatCurrent) {
        super(From);
        this.m_IsMoving = From.m_IsMoving;
        this.m_StaticMatrix.assignment(From.m_StaticMatrix);
        this.m_Handedness = From.m_Handedness;
        this.ConcatCurrentTransform(time, matTrans);
    }

    public CqTransform(CqTransform From, float time, CqMatrix matTrans, SetCurrent setCurrent) {
        super(From);
        this.m_IsMoving = From.m_IsMoving;
        this.m_StaticMatrix.assignment(From.m_StaticMatrix);
        this.m_Handedness = From.m_Handedness;
        this.SetCurrentTransform(time, matTrans);
    }

    public void SetCurrentTransform(float time, CqMatrix matTrans) {
        float det = matTrans.Determinant();
        boolean flip = !matTrans.fIdentity() && det < 0.0f;
        SqTransformation ct = new SqTransformation();
        ct.m_matTransform.assignment(matTrans);
        if (RiGlobal.QGetRenderContext().pconCurrent().fMotionBlock()) {
            this.AddTimeSlot(time, ct);
            this.m_IsMoving = true;
        } else if (this.m_IsMoving) {
            this.AddTimeSlot(time, ct);
        } else {
            this.m_StaticMatrix.assignment(matTrans);
            this.m_Handedness = flip;
            ct.m_Handedness = flip;
            this.SetDefaultObject(new SqTransformation(ct));
        }
    }

    public void ResetTransform(CqMatrix mat, boolean hand, boolean makeStatic) {
        if (makeStatic) {
            this.Reset();
            this.m_IsMoving = false;
            this.m_StaticMatrix.assignment(mat);
            this.m_Handedness = hand;
        } else {
            int i = 0;
            while (i < this.iTimes()) {
                this.SetCurrentTransform(this.Time(i), mat);
                ++i;
            }
        }
    }

    public final void ResetTransform(CqMatrix mat, boolean hand) {
        this.ResetTransform(mat, hand, true);
    }

    @Override
    public CqMatrix matObjectToWorld(float time) {
        if (this.m_IsMoving) {
            matInt = ((SqTransformation)this.GetMotionObjectInterpolated((float)time)).m_matTransform;
            return new CqMatrix(matInt);
        }
        return new CqMatrix(this.m_StaticMatrix);
    }

    @Override
    public float Time(int index) {
        return super.Time(index);
    }

    @Override
    public int cTimes() {
        if (this.m_IsMoving) {
            return super.iTimes();
        }
        return 1;
    }

    @Override
    public boolean GetHandedness(float time) {
        if (this.m_IsMoving) {
            return ((SqTransformation)this.GetMotionObject((float)time)).m_Handedness;
        }
        return this.m_Handedness;
    }

    @Override
    public void ClearMotionObject(SqTransformation A) {
    }

    @Override
    public SqTransformation ConcatMotionObjects(SqTransformation A, SqTransformation B) {
        boolean flip;
        SqTransformation res = new SqTransformation();
        res.m_matTransform = A.m_matTransform.multiply(B.m_matTransform);
        boolean bl = flip = B.m_matTransform.Determinant() < 0.0f;
        res.m_Handedness = flip ? !A.m_Handedness : A.m_Handedness;
        return res;
    }

    @Override
    public SqTransformation LinearInterpolateMotionObjects(float Fraction, SqTransformation A, SqTransformation B) {
        return A;
    }

    private void InitialiseDefaultObject(CqTransform From) {
        float time = RiGlobal.QGetRenderContext().Time();
        CqMatrix matOtoWLast = From.matObjectToWorld(time);
        boolean handLast = From.GetHandedness(time);
        SqTransformation ct = new SqTransformation();
        ct.m_Handedness = handLast;
        ct.m_matTransform = matOtoWLast;
        this.SetDefaultObject(ct);
    }

    private void SetTransform(float time, CqMatrix matTrans) {
        boolean camhand;
        float det = matTrans.Determinant();
        boolean flip = !matTrans.fIdentity() && det < 0.0f;
        CqMatrix matCtoW = RiGlobal.QGetRenderContext().matSpaceToSpace("world", "camera", new CqMatrix(), new CqMatrix(), RiGlobal.QGetRenderContext().Time());
        float camdet = matCtoW.Determinant();
        boolean bl = camhand = !matCtoW.fIdentity() && camdet < 0.0f;
        if (RiGlobal.QGetRenderContext().pconCurrent().fMotionBlock()) {
            SqTransformation ct = new SqTransformation();
            ct.m_Handedness = flip ? !camhand : camhand;
            ct.m_matTransform.assignment(matTrans);
            this.AddTimeSlot(time, ct);
            this.m_IsMoving = true;
        } else if (this.m_IsMoving) {
            CqMatrix mat0 = this.matObjectToWorld(this.Time(0));
            SqTransformation ct = new SqTransformation();
            boolean hand0 = ct.m_Handedness = flip ? !camhand : camhand;
            ct.m_matTransform.assignment(matTrans);
            this.AddTimeSlot(this.Time(0), ct);
            int i = 1;
            while (i < this.iTimes()) {
                boolean flip2;
                CqMatrix matOffset = mat0.multiply(this.matObjectToWorld(this.Time(i)).Inverse());
                ct.m_matTransform = matOffset.multiply(matTrans);
                boolean bl2 = flip2 = matOffset.Determinant() < 0.0f;
                ct.m_Handedness = flip2 ? !hand0 : hand0;
                this.AddTimeSlot(this.Time(i), new SqTransformation(ct));
                ++i;
            }
        } else {
            this.m_StaticMatrix.assignment(matTrans);
            this.m_Handedness = flip ? !camhand : camhand;
        }
    }

    private void ConcatCurrentTransform(float time, CqMatrix matTrans) {
        float det = matTrans.Determinant();
        boolean flip = !matTrans.fIdentity() && det < 0.0f;
        SqTransformation ct = new SqTransformation();
        ct.m_matTransform.assignment(matTrans);
        boolean bl = flip ? !this.m_Handedness : (ct.m_Handedness = this.m_Handedness);
        if (RiGlobal.QGetRenderContext().pconCurrent().fMotionBlock()) {
            this.ConcatTimeSlot(time, ct);
            this.m_IsMoving = true;
        } else if (this.m_IsMoving) {
            this.ConcatAllTimeSlots(ct);
        } else {
            this.m_StaticMatrix.assignment(this.m_StaticMatrix.multiply(matTrans));
            ct.m_Handedness = this.m_Handedness = flip ? !this.m_Handedness : this.m_Handedness;
            this.SetDefaultObject(ct);
        }
    }

    public strictfp static class Set {
    }

    public strictfp static class ConcatCurrent {
    }

    public strictfp static class SetCurrent {
    }
}

