/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.library.EqBufferType;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.util.HimawariLogger;

public strictfp class CqTextureMapBuffer {
    protected Object[] m_pBufferData;
    protected long m_sOrigin = 0L;
    protected long m_tOrigin = 0L;
    protected long m_Width = 0L;
    protected long m_Height = 0L;
    protected int m_Samples = 0;
    protected int m_Directory = 0;
    protected boolean m_fProtected = false;
    protected Class dataClass = Byte.class;
    static int limit = -1;
    static int report = -1;
    static int megs = 10;
    static /* synthetic */ Class class$0;

    public void destruct() {
        this.Release();
    }

    public void Init(long xorigin, long yorigin, long width, long height, int samples, int directory, boolean fProt) {
        this.Release();
        this.m_sOrigin = xorigin;
        this.m_tOrigin = yorigin;
        this.m_Width = width;
        this.m_Height = height;
        this.m_Samples = samples;
        this.m_Directory = directory;
        this.m_fProtected = fProt;
        this.m_pBufferData = this.AllocSegment(width, height, samples, this.m_fProtected);
    }

    public void Init(long xorigin, long yorigin, long width, long height, int samples, int directory) {
        this.Init(xorigin, yorigin, width, height, samples, directory, false);
    }

    public void Init(long xorigin, long yorigin, long width, long height, int samples) {
        this.Init(xorigin, yorigin, width, height, samples, 0, false);
    }

    public void Release() {
        if (this.m_pBufferData != null) {
            this.FreeSegment(this.m_pBufferData, this.m_Width, this.m_Height, this.m_Samples);
        }
        this.m_pBufferData = null;
    }

    public boolean IsValid(long s, long t, int directory) {
        return s >= this.m_sOrigin && t >= this.m_tOrigin && s < this.m_sOrigin + this.m_Width && t < this.m_tOrigin + this.m_Height && directory == this.m_Directory;
    }

    public boolean IsValid(long s, long t) {
        return this.IsValid(s, t, 0);
    }

    public Object[] pBufferData() {
        return this.m_pBufferData;
    }

    public Object[] pVoidBufferData() {
        return this.m_pBufferData;
    }

    public int ElemSize() {
        return this.m_Samples;
    }

    public EqBufferType BufferType() {
        return new EqBufferType(EqBufferType.BufferType_RGBA);
    }

    public float GetValue(int x, int y, int sample) {
        int iv = (int)((long)y * (this.m_Width * (long)this.ElemSize()));
        int iu = x * this.ElemSize();
        return (float)((Byte)this.m_pBufferData[iv + iu + sample] + 128) / 255.0f;
    }

    public void SetValue(int x, int y, int sample, float value) {
        int iv = (int)((long)y * (this.m_Width * (long)this.ElemSize()));
        int iu = x * this.ElemSize();
        this.m_pBufferData[iv + iu + sample] = (byte)(value * 255.0f - 128.0f);
    }

    public long sOrigin() {
        return this.m_sOrigin;
    }

    public long tOrigin() {
        return this.m_tOrigin;
    }

    public long Width() {
        return this.m_Width;
    }

    public long Height() {
        return this.m_Height;
    }

    public int Directory() {
        return this.m_Directory;
    }

    public int Samples() {
        return this.m_Samples;
    }

    public boolean fProtected() {
        return this.m_fProtected;
    }

    public void SetfProtected(boolean fProt) {
        this.m_fProtected = fProt;
    }

    public void SetfProtected() {
        this.SetfProtected(true);
    }

    public Object[] AllocSegment(long width, long height, int samples, boolean fProt) {
        int more;
        int demand = (int)(width * height * (long)this.ElemSize());
        if (limit == -1) {
            int[] poptMem = RiGlobal.QGetRenderContextI().GetIntegerOption("limits", "texturememory");
            limit = 0x800000;
            if (poptMem != null) {
                limit = poptMem[0] * 1024;
            }
        }
        if ((more = RiGlobal.QGetRenderContext().Stats().GetTextureMemory() + demand) > limit && !fProt) {
            if (report != 0) {
                HimawariLogger.getLogger().warning("Exceeding allocated texture memory by " + (more - limit) + "\n");
            }
            report = 0;
            RiGlobal.m_critical = true;
        }
        RiGlobal.QGetRenderContext().Stats().IncTextureMemory(demand);
        return new Byte[demand];
    }

    public Object[] AllocSegment(long width, long height, int samples) {
        return this.AllocSegment(width, height, samples, false);
    }

    public void FreeSegment(Object[] pBufferData, long width, long height, int samples) {
        long demand = width * height * (long)samples;
        RiGlobal.QGetRenderContext().Stats().IncTextureMemory((int)(-demand));
    }
}

