/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqMicroPolyGrid;
import net.cellcomputing.himawari.library.CqParameter;
import net.cellcomputing.himawari.library.CqSurface;
import net.cellcomputing.himawari.library.EqSplitDir;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.PublicFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqSurfacePatchBilinear
extends CqSurface {
    protected boolean m_fHasPhantomFourthVertex;
    protected int m_iInternalu;
    protected int m_iInternalv;

    public CqSurfacePatchBilinear() {
        this.m_fHasPhantomFourthVertex = false;
        this.m_iInternalu = -1;
        this.m_iInternalv = -1;
    }

    public CqSurfacePatchBilinear(CqSurfacePatchBilinear From) {
        super(From);
        this.assignment(From);
    }

    @Override
    public void destruct() {
    }

    public CqSurfacePatchBilinear assignment(CqSurfacePatchBilinear From) {
        super.assignment(From);
        this.m_fHasPhantomFourthVertex = From.m_fHasPhantomFourthVertex;
        this.m_iInternalu = From.m_iInternalu;
        this.m_iInternalv = From.m_iInternalv;
        return this;
    }

    public void SetfHasPhantomFourthVertex(boolean fHasPhantomFourthVertex) {
        this.m_fHasPhantomFourthVertex = fHasPhantomFourthVertex;
    }

    public boolean fHasPhantomFourthVertex() {
        return this.m_fHasPhantomFourthVertex;
    }

    public void GenNormals() {
    }

    @Override
    public CqBound Bound() {
        assert (this.P() != null);
        CqVector3D vecA = new CqVector3D(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        CqVector3D vecB = new CqVector3D(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        CqVector3D vecV = new CqVector3D();
        int i = 0;
        while (i < (this.m_fHasPhantomFourthVertex ? 3 : 4)) {
            vecV.assignment(this.P().pValue_get(i, 0));
            if (vecV.x < vecA.x) {
                vecA.x(vecV.x);
            }
            if (vecV.y < vecA.y) {
                vecA.y(vecV.y);
            }
            if (vecV.x > vecB.x) {
                vecB.x(vecV.x);
            }
            if (vecV.y > vecB.y) {
                vecB.y(vecV.y);
            }
            if (vecV.z < vecA.z) {
                vecA.z(vecV.z);
            }
            if (vecV.z > vecB.z) {
                vecB.z(vecV.z);
            }
            ++i;
        }
        CqBound B = new CqBound();
        B.vecMin().assignment(vecA);
        B.vecMax().assignment(vecB);
        return this.AdjustBoundForTransformationMotion(B);
    }

    @Override
    public boolean Diceable() {
        float gs2;
        assert (this.P() != null);
        if (!this.m_fDiceable) {
            return false;
        }
        CqMatrix matCtoR = RiGlobal.QGetRenderContext().matSpaceToSpace("camera", "raster", new CqMatrix(), new CqMatrix(), RiGlobal.QGetRenderContext().Time());
        CqVector2D[] avecHull = new CqVector2D[4];
        int i = 0;
        float ShadingRate = this.pAttributes().GetFloatAttribute("System", "ShadingRate")[0];
        i = 0;
        while (i < 4) {
            avecHull[i] = new CqVector2D(matCtoR.multiply(this.P().pValue_get(i, 0)));
            ++i;
        }
        float uLen = 0.0f;
        float vLen = 0.0f;
        CqVector2D Vec1 = new CqVector2D(avecHull[1].sub(avecHull[0]));
        CqVector2D Vec2 = new CqVector2D(avecHull[3].sub(avecHull[2]));
        uLen = Vec1.Magnitude2() > Vec2.Magnitude2() ? Vec1.Magnitude2() : Vec2.Magnitude2();
        Vec1.assignment(avecHull[2].sub(avecHull[0]));
        Vec2.assignment(avecHull[3].sub(avecHull[1]));
        float f = vLen = Vec1.Magnitude2() > Vec2.Magnitude2() ? Vec1.Magnitude2() : Vec2.Magnitude2();
        if (ShadingRate > 0.0f) {
            uLen = (float)StrictMath.sqrt(uLen / ShadingRate);
            vLen = (float)StrictMath.sqrt(vLen / ShadingRate);
        } else {
            uLen = 0.0f;
            vLen = 0.0f;
        }
        this.m_SplitDir = uLen > vLen ? new EqSplitDir(0) : new EqSplitDir(1);
        uLen = Math.max(Math.round(uLen), 1);
        vLen = Math.max(Math.round(vLen), 1);
        this.m_uDiceSize = (int)uLen;
        this.m_vDiceSize = (int)vLen;
        int[] binary = this.pAttributes().GetIntegerAttribute("dice", "binary");
        if (binary != null && binary[0] != 0) {
            this.m_uDiceSize = (int)PublicFunctions.CEIL_POW2(this.m_uDiceSize);
            this.m_vDiceSize = (int)PublicFunctions.CEIL_POW2(this.m_vDiceSize);
        }
        if (uLen < 1.1920929E-7f || vLen < 1.1920929E-7f) {
            this.m_fDiscard = true;
            return false;
        }
        float gs = 16.0f;
        float[] poptGridSize = RiGlobal.QGetRenderContext().optCurrent().GetFloatOption("System", "SqrtGridSize");
        if (poptGridSize != null) {
            gs = poptGridSize[0];
        }
        return !((float)this.m_uDiceSize > (gs2 = gs * gs)) && !((float)this.m_vDiceSize > gs2) && !((float)(this.m_uDiceSize * this.m_vDiceSize) > gs2);
    }

    @Override
    public boolean IsMotionBlurMatch(CqBasicSurface pSurf) {
        return false;
    }

    @Override
    public int cUniform() {
        return 1;
    }

    @Override
    public int cVarying() {
        return 4;
    }

    @Override
    public int cVertex() {
        return 4;
    }

    @Override
    public int cFaceVarying() {
        return 1;
    }

    @Override
    public int Split(STLVector<CqBasicSurface> aSplits) {
        aSplits.add(new CqSurfacePatchBilinear());
        aSplits.add(new CqSurfacePatchBilinear());
        if (this.m_fHasPhantomFourthVertex) {
            aSplits.add(new CqSurfacePatchBilinear());
            aSplits.add(new CqSurfacePatchBilinear());
        }
        boolean direction = this.SplitDir() == 0;
        boolean opposite = !direction;
        int i = 0;
        while (i < (this.m_fHasPhantomFourthVertex ? 4 : 2)) {
            ((CqBasicSurface)aSplits.get(i)).SetSurfaceParameters(this);
            ((CqBasicSurface)aSplits.get(i)).SetSplitDir(direction ? new EqSplitDir(1) : new EqSplitDir(0));
            ((CqBasicSurface)aSplits.get(i)).SetEyeSplitCount(this.EyeSplitCount());
            ((CqBasicSurface)aSplits.get((int)i)).m_fDiceable = true;
            ++i;
        }
        for (CqParameter iUP : this.m_aUserParams) {
            CqParameter pNewA = iUP.Clone();
            CqParameter pNewB = iUP.Clone();
            iUP.Subdivide(pNewA, pNewB, direction, this);
            if (this.m_fHasPhantomFourthVertex) {
                CqParameter pNewC = pNewA.Clone();
                CqParameter pNewD = pNewA.Clone();
                CqParameter pNewE = pNewB.Clone();
                CqParameter pNewF = pNewB.Clone();
                pNewA.Subdivide(pNewC, pNewD, opposite, this);
                pNewB.Subdivide(pNewE, pNewF, opposite, this);
                ((CqSurface)aSplits.get(0)).AddPrimitiveVariable(pNewC);
                ((CqSurface)aSplits.get(1)).AddPrimitiveVariable(pNewD);
                ((CqSurface)aSplits.get(2)).AddPrimitiveVariable(pNewE);
                ((CqSurface)aSplits.get(3)).AddPrimitiveVariable(pNewF);
                pNewA = null;
                pNewB = null;
                continue;
            }
            ((CqSurface)aSplits.get(0)).AddPrimitiveVariable(pNewA);
            ((CqSurface)aSplits.get(1)).AddPrimitiveVariable(pNewB);
        }
        if (this.m_fHasPhantomFourthVertex) {
            aSplits.remove(aSplits.lastElement());
            ((CqSurfacePatchBilinear)aSplits.get((int)0)).m_fHasPhantomFourthVertex = false;
            ((CqSurfacePatchBilinear)aSplits.get((int)1)).m_fHasPhantomFourthVertex = true;
            ((CqSurfacePatchBilinear)aSplits.get((int)2)).m_fHasPhantomFourthVertex = true;
            return 3;
        }
        ((CqSurfacePatchBilinear)aSplits.get((int)0)).m_fHasPhantomFourthVertex = false;
        ((CqSurfacePatchBilinear)aSplits.get((int)1)).m_fHasPhantomFourthVertex = false;
        return 2;
    }

    @Override
    public int PreSubdivide(STLVector<CqBasicSurface> aSplits, boolean u) {
        aSplits.add(new CqSurfacePatchBilinear());
        aSplits.add(new CqSurfacePatchBilinear());
        return 2;
    }

    @Override
    public void PostDice(CqMicroPolyGrid pGrid) {
        if (this.m_fHasPhantomFourthVertex) {
            pGrid.SetfTriangular(true);
        }
    }
}

